# Streamlit TOON Viewer

A custom Streamlit component for viewing TOON (Tree Object Oriented Notation) data in an interactive, collapsible tree view.

## Requirements

- Python >= 3.12
- Streamlit >= 1.51.0

## Installation

Install the package using pip:

```bash
pip install streamlit-toon
```

## Usage

### Basic Usage

```python
import streamlit as st
from streamlit_toon import StreamlitTOONViewer

# Create a viewer instance
viewer = StreamlitTOONViewer()

# Display TOON data from a string
toon_data = """
root:
  child1: value1
  child2: value2
"""
viewer.display_toon(toon_data)
```

### Display TOON Data from a File

```python
import streamlit as st
from streamlit_toon import StreamlitTOONViewer

viewer = StreamlitTOONViewer()

# Pass a file path directly
viewer.display_toon("path/to/your/toon_file.toon")
```

### Custom Height and Key

```python
import streamlit as st
from streamlit_toon import StreamlitTOONViewer

viewer = StreamlitTOONViewer()

# Customize the viewer height and add a unique key
viewer.display_toon(
    data="your_toon_data_here",
    height=600,
    key="my_toon_viewer"
)
```

## API Reference

### `StreamlitTOONViewer()`

Creates a new TOON viewer instance.

### `display_toon(data, height=400, key=None)`

Display TOON data in an interactive tree view.

**Parameters:**
- `data` (str): TOON text as a string, or file path to a TOON file
- `height` (int, optional): Height of the component in pixels (default: 400)
- `key` (str, optional): Unique key for the component

**Returns:**
- Component return value

## License

[Add your license here]
