# Generated by Django 2.2.8 on 2019-12-10 16:55

import django.contrib.postgres.fields.jsonb
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ("models", "5613_notification_type"),
    ]

    def forwards_func(apps, schema_editor):
        OntologyModel = apps.get_model("models", "Ontology")
        ontologies = OntologyModel.objects.all()
        namespaces = {
            "http://www.w3.org/2001/XMLSchema#": "xsd",
            "http://www.w3.org/XML/1998/namespace": "xml",
            "http://www.w3.org/2000/01/rdf-schema#": "rdfs",
            "http://www.w3.org/1999/02/22-rdf-syntax-ns#": "rdf",
        }
        for ontology in ontologies:
            ontology.namespaces = namespaces
            ontology.save()

    def reverse_func(apps, schema_editor):
        pass

    operations = [
        migrations.AlterField(
            model_name="ontology",
            name="path",
            field=models.TextField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name="ontology",
            name="namespaces",
            field=django.contrib.postgres.fields.jsonb.JSONField(blank=True, null=True),
        ),
        migrations.RunPython(forwards_func, reverse_func),
    ]
