# -*- coding: utf-8 -*-
# Generated by Django 1.11.15 on 2019-04-17 19:51

import os
import uuid
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ("models", "4684_updates_tabbed_report_configs"),
    ]

    operations = [
        migrations.CreateModel(
            name="SearchComponent",
            fields=[
                (
                    "searchcomponentid",
                    models.UUIDField(
                        default=uuid.uuid1, primary_key=True, serialize=False
                    ),
                ),
                ("name", models.TextField()),
                ("icon", models.TextField(default=None)),
                ("modulename", models.TextField(blank=True, null=True)),
                ("classname", models.TextField(blank=True, null=True)),
                ("type", models.TextField()),
                ("componentpath", models.TextField(unique=True)),
                ("componentname", models.TextField(unique=True)),
                ("sortorder", models.IntegerField(blank=True, default=None, null=True)),
                ("enabled", models.BooleanField(default=False)),
            ],
            options={"db_table": "search_component", "managed": True},
        ),
        migrations.RunSQL(
            """
            insert into search_component (
                "searchcomponentid",
                "name",
                "icon",
                "modulename",
                "classname",
                "type",
                "componentpath",
                "componentname",
                "sortorder",
                "enabled")
            values (
                '7aff5819-651c-4390-9b9a-a61221ba52c6',
                'Paging',
                '',
                'paging_filter.py',
                'PagingFilter',
                'paging',
                'views/components/search/paging-filter',
                'paging-filter',
                0,
                true);
            insert into search_component (
                "searchcomponentid",
                "name",
                "icon",
                "modulename",
                "classname",
                "type",
                "componentpath",
                "componentname",
                "sortorder",
                "enabled")
            values (
                '09d97fc6-8c83-4319-9cef-3aaa08c3fbec',
                'Map Filter',
                'fa fa-map-marker',
                'map_filter.py',
                'MapFilter',
                'filter',
                'views/components/search/map-filter',
                'map-filter',
                0,
                true);
            insert into search_component (
                "searchcomponentid",
                "name",
                "icon",
                "modulename",
                "classname",
                "type",
                "componentpath",
                "componentname",
                "sortorder",
                "enabled")
            values (
                '00673743-8c1c-4cc0-bd85-c073a52e03ec',
                'Search Results',
                '',
                'search_results.py',
                'SearchResultsFilter',
                'results-list',
                'views/components/search/search-results',
                'search-results',
                0,
                true);
            insert into search_component (
                "searchcomponentid",
                "name",
                "icon",
                "modulename",
                "classname",
                "type",
                "componentpath",
                "componentname",
                "sortorder",
                "enabled")
            values (
                'f0e56205-acb5-475b-9c98-f5e44f1dbd2c',
                'Advanced',
                'fa fa-check-circle-o',
                'advanced_search.py',
                'AdvancedSearch',
                'filter',
                'views/components/search/advanced-search',
                'advanced-search',
                3,
                true);
            insert into search_component (
                "searchcomponentid",
                "name",
                "icon",
                "modulename",
                "classname",
                "type",
                "componentpath",
                "componentname",
                "sortorder",
                "enabled")
            values (
                '7497ed4f-2085-40da-bee5-52076a48bcb1',
                'Time Filter',
                'fa fa-calendar',
                'time_filter.py',
                'TimeFilter',
                'popup',
                'views/components/search/time-filter',
                'time-filter',
                1,
                true);
            insert into search_component (
                "searchcomponentid",
                "name",
                "icon",
                "modulename",
                "classname",
                "type",
                "componentpath",
                "componentname",
                "sortorder",
                "enabled")
            values (
                '1f42f501-ed70-48c5-bae1-6ff7d0d187da',
                'Term Filter',
                '',
                'term_filter.py',
                'TermFilter',
                'text-input',
                'views/components/search/term-filter',
                'term-filter',
                0,
                true);
            insert into search_component (
                "searchcomponentid",
                "name",
                "icon",
                "modulename",
                "classname",
                "type",
                "componentpath",
                "componentname",
                "sortorder",
                "enabled")
            values (
                '073406ed-93e5-4b5b-9418-b61c26b3640f',
                'Provisional Filter',
                '',
                'provisional_filter.py',
                'ProvisionalFilter',
                '',
                'views/components/search/provisional-filter',
                'provisional-filter',
                0,
                true);
            insert into search_component (
                "searchcomponentid",
                "name",
                "icon",
                "modulename",
                "classname",
                "type",
                "componentpath",
                "componentname",
                "sortorder",
                "enabled")
            values (
                '59f28272-d1f1-4805-af51-227771739aed',
                'Related',
                'fa fa-code-fork',
                '',
                '',
                'filter',
                'views/components/search/related-resources-filter',
                'related-resources-filter',4,true);
            insert into search_component (
                "searchcomponentid",
                "name",
                "icon",
                "modulename",
                "classname",
                "type",
                "componentpath",
                "componentname",
                "sortorder",
                "enabled")
            values (
                'f1c46b7d-0132-421b-b1f3-95d67f9b3980',
                'Resource Type Filter',
                '',
                'resource_type_filter.py',
                'ResourceTypeFilter',
                'resource-type-filter',
                'views/components/search/resource-type-filter',
                'resource-type-filter',0,true);
            insert into search_component (
                "searchcomponentid",
                "name",
                "icon",
                "modulename",
                "classname",
                "type",
                "componentpath",
                "componentname",
                "sortorder",
                "enabled")
            values (
                '6dc29637-43a1-4fba-adae-8d9956dcd3b9',
                'Saved',
                'fa fa-bookmark',
                'saved_searches.py',
                'SavedSearches',
                'popup',
                'views/components/search/saved-searches',
                'saved-searches',
                2,
                true);
            """,
            """
            delete from search_component where searchcomponentid in
                ('7aff5819-651c-4390-9b9a-a61221ba52c6',
                '09d97fc6-8c83-4319-9cef-3aaa08c3fbec',
                '00673743-8c1c-4cc0-bd85-c073a52e03ec',
                'f0e56205-acb5-475b-9c98-f5e44f1dbd2c',
                '7497ed4f-2085-40da-bee5-52076a48bcb1',
                '1f42f501-ed70-48c5-bae1-6ff7d0d187da',
                '073406ed-93e5-4b5b-9418-b61c26b3640f',
                '59f28272-d1f1-4805-af51-227771739aed',
                'f1c46b7d-0132-421b-b1f3-95d67f9b3980',
                '6dc29637-43a1-4fba-adae-8d9956dcd3b9');
            """,
        ),
    ]
