# Generated by Django 2.2.24 on 2021-12-03 13:27

import re
import uuid
import django.contrib.postgres.fields.jsonb
import django.core.validators
from django.db import migrations, models
from arches.app.models.system_settings import settings

update_check_excess_tiles_trigger = """
    DROP TRIGGER IF EXISTS __arches_check_excess_tiles_trigger ON tiles;
    DROP FUNCTION IF EXISTS __arches_check_excess_tiles_trigger_function();
    CREATE OR REPLACE FUNCTION __arches_check_excess_tiles_trigger_function()
    RETURNS trigger AS $$
    BEGIN
        IF (NEW.resourceinstanceid, NEW.nodegroupid, COALESCE(NEW.parenttileid::text, '')) IN (
                SELECT t.resourceinstanceid, t.nodegroupid, COALESCE(t.parenttileid::text, '')
                FROM tiles t, node_groups ng
                WHERE t.nodegroupid = ng.nodegroupid
                AND ng.cardinality = '1'
            ) THEN
                RAISE EXCEPTION 'Multiple Tiles for Cardinality-1 Nodegroup | nodegroupid: %, resourceinstanceid: %, parenttileid: %', NEW.nodegroupid, NEW.resourceinstanceid, COALESCE(NEW.parenttileid::text, 'root')  USING ERRCODE = '21000';
        END IF;
        RETURN NEW;
    END;
    $$ LANGUAGE plpgsql;

    CREATE TRIGGER __arches_check_excess_tiles_trigger
        BEFORE INSERT ON tiles
        FOR EACH ROW
        EXECUTE PROCEDURE __arches_check_excess_tiles_trigger_function();
    """

restore_check_excess_tiles_trigger = """
    DROP TRIGGER IF EXISTS __arches_check_excess_tiles_trigger ON tiles;
    DROP FUNCTION IF EXISTS __arches_check_excess_tiles_trigger_function();
    CREATE OR REPLACE FUNCTION __arches_check_excess_tiles_trigger_function()
    RETURNS trigger AS $$
    BEGIN
        IF (NEW.resourceinstanceid, NEW.nodegroupid, COALESCE(NEW.parenttileid::text, '')) IN (
                SELECT t.resourceinstanceid, t.nodegroupid, COALESCE(t.parenttileid::text, '')
                FROM tiles t, node_groups ng
                WHERE t.nodegroupid = ng.nodegroupid
                AND ng.cardinality = '1'
            ) THEN
                RAISE EXCEPTION 'Multiple Tiles for Cardinality-1 Nodegroup' USING ERRCODE = '21000';
        END IF;
        RETURN NEW;
    END;
    $$ LANGUAGE plpgsql;

    CREATE TRIGGER __arches_check_excess_tiles_trigger
        BEFORE INSERT ON tiles
        FOR EACH ROW
        EXECUTE PROCEDURE __arches_check_excess_tiles_trigger_function();
    """


class Migration(migrations.Migration):

    dependencies = [
        ("models", "8528_bulk_load_performance_functions"),
    ]

    operations = [
        migrations.RunSQL(
            update_check_excess_tiles_trigger, restore_check_excess_tiles_trigger
        ),
    ]
