# mypy-boto3-iot

[![PyPI - mypy-boto3-iot](https://img.shields.io/pypi/v/mypy-boto3-iot.svg?color=blue)](https://pypi.org/project/mypy-boto3-iot)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-iot.svg?color=blue)](https://pypi.org/project/mypy-boto3-iot)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.IoT 1.17.20](https://boto3.amazonaws.com/v1/documentation/api/1.17.20/reference/services/iot.html#IoT) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 4.4.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-iot](#mypy-boto3-iot)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Typed dictionations](#typed-dictionations)

## How to install

Install `boto3-stubs` for `IoT` service.

```bash
python -m pip install boto3-stubs[iot]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[iot]` in your environment: `python -m pip install 'boto3-stubs[iot]'`

Both type checking and auto-complete should work for `IoT` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[iot]` in your environment: `python -m pip install 'boto3-stubs[iot]'`

Both type checking and auto-complete should work for `IoT` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[iot]` in your environment: `python -m pip install 'boto3-stubs[iot]'`
- Run `mypy` as usual

Type checking should work for `IoT` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[iot]` in your environment: `python -m pip install 'boto3-stubs[iot]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `IoT` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`IoTClient` provides annotations for `boto3.client("iot")`.

```python
import boto3

from mypy_boto3_iot import IoTClient

client: IoTClient = boto3.client("iot")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: IoTClient = session.client("iot")
```

### Paginators annotations

`mypy_boto3_iot.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_iot import IoTClient
from mypy_boto3_iot.paginator import (
    GetBehaviorModelTrainingSummariesPaginator,
    ListActiveViolationsPaginator,
    ListAttachedPoliciesPaginator,
    ListAuditFindingsPaginator,
    ListAuditMitigationActionsExecutionsPaginator,
    ListAuditMitigationActionsTasksPaginator,
    ListAuditSuppressionsPaginator,
    ListAuditTasksPaginator,
    ListAuthorizersPaginator,
    ListBillingGroupsPaginator,
    ListCACertificatesPaginator,
    ListCertificatesPaginator,
    ListCertificatesByCAPaginator,
    ListCustomMetricsPaginator,
    ListDetectMitigationActionsExecutionsPaginator,
    ListDetectMitigationActionsTasksPaginator,
    ListDimensionsPaginator,
    ListDomainConfigurationsPaginator,
    ListIndicesPaginator,
    ListJobExecutionsForJobPaginator,
    ListJobExecutionsForThingPaginator,
    ListJobsPaginator,
    ListMitigationActionsPaginator,
    ListOTAUpdatesPaginator,
    ListOutgoingCertificatesPaginator,
    ListPoliciesPaginator,
    ListPolicyPrincipalsPaginator,
    ListPrincipalPoliciesPaginator,
    ListPrincipalThingsPaginator,
    ListProvisioningTemplateVersionsPaginator,
    ListProvisioningTemplatesPaginator,
    ListRoleAliasesPaginator,
    ListScheduledAuditsPaginator,
    ListSecurityProfilesPaginator,
    ListSecurityProfilesForTargetPaginator,
    ListStreamsPaginator,
    ListTagsForResourcePaginator,
    ListTargetsForPolicyPaginator,
    ListTargetsForSecurityProfilePaginator,
    ListThingGroupsPaginator,
    ListThingGroupsForThingPaginator,
    ListThingPrincipalsPaginator,
    ListThingRegistrationTaskReportsPaginator,
    ListThingRegistrationTasksPaginator,
    ListThingTypesPaginator,
    ListThingsPaginator,
    ListThingsInBillingGroupPaginator,
    ListThingsInThingGroupPaginator,
    ListTopicRuleDestinationsPaginator,
    ListTopicRulesPaginator,
    ListV2LoggingLevelsPaginator,
    ListViolationEventsPaginator,
)

client: IoTClient = boto3.client("iot")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
get_behavior_model_training_summaries_paginator: GetBehaviorModelTrainingSummariesPaginator = client.get_paginator("get_behavior_model_training_summaries")
list_active_violations_paginator: ListActiveViolationsPaginator = client.get_paginator("list_active_violations")
list_attached_policies_paginator: ListAttachedPoliciesPaginator = client.get_paginator("list_attached_policies")
list_audit_findings_paginator: ListAuditFindingsPaginator = client.get_paginator("list_audit_findings")
list_audit_mitigation_actions_executions_paginator: ListAuditMitigationActionsExecutionsPaginator = client.get_paginator("list_audit_mitigation_actions_executions")
list_audit_mitigation_actions_tasks_paginator: ListAuditMitigationActionsTasksPaginator = client.get_paginator("list_audit_mitigation_actions_tasks")
list_audit_suppressions_paginator: ListAuditSuppressionsPaginator = client.get_paginator("list_audit_suppressions")
list_audit_tasks_paginator: ListAuditTasksPaginator = client.get_paginator("list_audit_tasks")
list_authorizers_paginator: ListAuthorizersPaginator = client.get_paginator("list_authorizers")
list_billing_groups_paginator: ListBillingGroupsPaginator = client.get_paginator("list_billing_groups")
list_ca_certificates_paginator: ListCACertificatesPaginator = client.get_paginator("list_ca_certificates")
list_certificates_paginator: ListCertificatesPaginator = client.get_paginator("list_certificates")
list_certificates_by_ca_paginator: ListCertificatesByCAPaginator = client.get_paginator("list_certificates_by_ca")
list_custom_metrics_paginator: ListCustomMetricsPaginator = client.get_paginator("list_custom_metrics")
list_detect_mitigation_actions_executions_paginator: ListDetectMitigationActionsExecutionsPaginator = client.get_paginator("list_detect_mitigation_actions_executions")
list_detect_mitigation_actions_tasks_paginator: ListDetectMitigationActionsTasksPaginator = client.get_paginator("list_detect_mitigation_actions_tasks")
list_dimensions_paginator: ListDimensionsPaginator = client.get_paginator("list_dimensions")
list_domain_configurations_paginator: ListDomainConfigurationsPaginator = client.get_paginator("list_domain_configurations")
list_indices_paginator: ListIndicesPaginator = client.get_paginator("list_indices")
list_job_executions_for_job_paginator: ListJobExecutionsForJobPaginator = client.get_paginator("list_job_executions_for_job")
list_job_executions_for_thing_paginator: ListJobExecutionsForThingPaginator = client.get_paginator("list_job_executions_for_thing")
list_jobs_paginator: ListJobsPaginator = client.get_paginator("list_jobs")
list_mitigation_actions_paginator: ListMitigationActionsPaginator = client.get_paginator("list_mitigation_actions")
list_ota_updates_paginator: ListOTAUpdatesPaginator = client.get_paginator("list_ota_updates")
list_outgoing_certificates_paginator: ListOutgoingCertificatesPaginator = client.get_paginator("list_outgoing_certificates")
list_policies_paginator: ListPoliciesPaginator = client.get_paginator("list_policies")
list_policy_principals_paginator: ListPolicyPrincipalsPaginator = client.get_paginator("list_policy_principals")
list_principal_policies_paginator: ListPrincipalPoliciesPaginator = client.get_paginator("list_principal_policies")
list_principal_things_paginator: ListPrincipalThingsPaginator = client.get_paginator("list_principal_things")
list_provisioning_template_versions_paginator: ListProvisioningTemplateVersionsPaginator = client.get_paginator("list_provisioning_template_versions")
list_provisioning_templates_paginator: ListProvisioningTemplatesPaginator = client.get_paginator("list_provisioning_templates")
list_role_aliases_paginator: ListRoleAliasesPaginator = client.get_paginator("list_role_aliases")
list_scheduled_audits_paginator: ListScheduledAuditsPaginator = client.get_paginator("list_scheduled_audits")
list_security_profiles_paginator: ListSecurityProfilesPaginator = client.get_paginator("list_security_profiles")
list_security_profiles_for_target_paginator: ListSecurityProfilesForTargetPaginator = client.get_paginator("list_security_profiles_for_target")
list_streams_paginator: ListStreamsPaginator = client.get_paginator("list_streams")
list_tags_for_resource_paginator: ListTagsForResourcePaginator = client.get_paginator("list_tags_for_resource")
list_targets_for_policy_paginator: ListTargetsForPolicyPaginator = client.get_paginator("list_targets_for_policy")
list_targets_for_security_profile_paginator: ListTargetsForSecurityProfilePaginator = client.get_paginator("list_targets_for_security_profile")
list_thing_groups_paginator: ListThingGroupsPaginator = client.get_paginator("list_thing_groups")
list_thing_groups_for_thing_paginator: ListThingGroupsForThingPaginator = client.get_paginator("list_thing_groups_for_thing")
list_thing_principals_paginator: ListThingPrincipalsPaginator = client.get_paginator("list_thing_principals")
list_thing_registration_task_reports_paginator: ListThingRegistrationTaskReportsPaginator = client.get_paginator("list_thing_registration_task_reports")
list_thing_registration_tasks_paginator: ListThingRegistrationTasksPaginator = client.get_paginator("list_thing_registration_tasks")
list_thing_types_paginator: ListThingTypesPaginator = client.get_paginator("list_thing_types")
list_things_paginator: ListThingsPaginator = client.get_paginator("list_things")
list_things_in_billing_group_paginator: ListThingsInBillingGroupPaginator = client.get_paginator("list_things_in_billing_group")
list_things_in_thing_group_paginator: ListThingsInThingGroupPaginator = client.get_paginator("list_things_in_thing_group")
list_topic_rule_destinations_paginator: ListTopicRuleDestinationsPaginator = client.get_paginator("list_topic_rule_destinations")
list_topic_rules_paginator: ListTopicRulesPaginator = client.get_paginator("list_topic_rules")
list_v2_logging_levels_paginator: ListV2LoggingLevelsPaginator = client.get_paginator("list_v2_logging_levels")
list_violation_events_paginator: ListViolationEventsPaginator = client.get_paginator("list_violation_events")
```







### Typed dictionations

`mypy_boto3_iot.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_iot.type_defs import (
    AbortConfigTypeDef,
    AbortCriteriaTypeDef,
    ActionTypeDef,
    ActiveViolationTypeDef,
    AddThingsToThingGroupParamsTypeDef,
    AlertTargetTypeDef,
    AllowedTypeDef,
    AssetPropertyTimestampTypeDef,
    AssetPropertyValueTypeDef,
    AssetPropertyVariantTypeDef,
    AttributePayloadTypeDef,
    AuditCheckConfigurationTypeDef,
    AuditCheckDetailsTypeDef,
    AuditFindingTypeDef,
    AuditMitigationActionExecutionMetadataTypeDef,
    AuditMitigationActionsTaskMetadataTypeDef,
    AuditMitigationActionsTaskTargetTypeDef,
    AuditNotificationTargetTypeDef,
    AuditSuppressionTypeDef,
    AuditTaskMetadataTypeDef,
    AuthInfoTypeDef,
    AuthResultTypeDef,
    AuthorizerConfigTypeDef,
    AuthorizerDescriptionTypeDef,
    AuthorizerSummaryTypeDef,
    AwsJobAbortCriteriaTypeDef,
    AwsJobExecutionsRolloutConfigTypeDef,
    AwsJobExponentialRolloutRateTypeDef,
    AwsJobPresignedUrlConfigTypeDef,
    AwsJobRateIncreaseCriteriaTypeDef,
    BehaviorCriteriaTypeDef,
    BehaviorModelTrainingSummaryTypeDef,
    BehaviorTypeDef,
    BillingGroupMetadataTypeDef,
    BillingGroupPropertiesTypeDef,
    CACertificateDescriptionTypeDef,
    CACertificateTypeDef,
    CertificateDescriptionTypeDef,
    CertificateTypeDef,
    CertificateValidityTypeDef,
    CloudwatchAlarmActionTypeDef,
    CloudwatchLogsActionTypeDef,
    CloudwatchMetricActionTypeDef,
    CodeSigningCertificateChainTypeDef,
    CodeSigningSignatureTypeDef,
    CodeSigningTypeDef,
    ConfigurationTypeDef,
    CustomCodeSigningTypeDef,
    DeniedTypeDef,
    DestinationTypeDef,
    DetectMitigationActionExecutionTypeDef,
    DetectMitigationActionsTaskStatisticsTypeDef,
    DetectMitigationActionsTaskSummaryTypeDef,
    DetectMitigationActionsTaskTargetTypeDef,
    DomainConfigurationSummaryTypeDef,
    DynamoDBActionTypeDef,
    DynamoDBv2ActionTypeDef,
    EffectivePolicyTypeDef,
    ElasticsearchActionTypeDef,
    EnableIoTLoggingParamsTypeDef,
    ErrorInfoTypeDef,
    ExplicitDenyTypeDef,
    ExponentialRolloutRateTypeDef,
    FieldTypeDef,
    FileLocationTypeDef,
    FirehoseActionTypeDef,
    GroupNameAndArnTypeDef,
    HttpActionHeaderTypeDef,
    HttpActionTypeDef,
    HttpAuthorizationTypeDef,
    HttpUrlDestinationConfigurationTypeDef,
    HttpUrlDestinationPropertiesTypeDef,
    HttpUrlDestinationSummaryTypeDef,
    ImplicitDenyTypeDef,
    IotAnalyticsActionTypeDef,
    IotEventsActionTypeDef,
    IotSiteWiseActionTypeDef,
    JobExecutionStatusDetailsTypeDef,
    JobExecutionSummaryForJobTypeDef,
    JobExecutionSummaryForThingTypeDef,
    JobExecutionSummaryTypeDef,
    JobExecutionTypeDef,
    JobExecutionsRolloutConfigTypeDef,
    JobProcessDetailsTypeDef,
    JobSummaryTypeDef,
    JobTypeDef,
    KafkaActionTypeDef,
    KeyPairTypeDef,
    KinesisActionTypeDef,
    LambdaActionTypeDef,
    LogTargetConfigurationTypeDef,
    LogTargetTypeDef,
    MachineLearningDetectionConfigTypeDef,
    MetricDimensionTypeDef,
    MetricToRetainTypeDef,
    MetricValueTypeDef,
    MitigationActionIdentifierTypeDef,
    MitigationActionParamsTypeDef,
    MitigationActionTypeDef,
    NonCompliantResourceTypeDef,
    OTAUpdateFileTypeDef,
    OTAUpdateInfoTypeDef,
    OTAUpdateSummaryTypeDef,
    OutgoingCertificateTypeDef,
    PercentPairTypeDef,
    PolicyTypeDef,
    PolicyVersionIdentifierTypeDef,
    PolicyVersionTypeDef,
    PresignedUrlConfigTypeDef,
    ProvisioningHookTypeDef,
    ProvisioningTemplateSummaryTypeDef,
    ProvisioningTemplateVersionSummaryTypeDef,
    PublishFindingToSnsParamsTypeDef,
    PutAssetPropertyValueEntryTypeDef,
    PutItemInputTypeDef,
    RateIncreaseCriteriaTypeDef,
    RegistrationConfigTypeDef,
    RelatedResourceTypeDef,
    ReplaceDefaultPolicyVersionParamsTypeDef,
    RepublishActionTypeDef,
    ResourceIdentifierTypeDef,
    RoleAliasDescriptionTypeDef,
    S3ActionTypeDef,
    S3DestinationTypeDef,
    S3LocationTypeDef,
    SalesforceActionTypeDef,
    ScheduledAuditMetadataTypeDef,
    SecurityProfileIdentifierTypeDef,
    SecurityProfileTargetMappingTypeDef,
    SecurityProfileTargetTypeDef,
    ServerCertificateSummaryTypeDef,
    SigV4AuthorizationTypeDef,
    SigningProfileParameterTypeDef,
    SnsActionTypeDef,
    SqsActionTypeDef,
    StartSigningJobParameterTypeDef,
    StatisticalThresholdTypeDef,
    StatisticsTypeDef,
    StepFunctionsActionTypeDef,
    StreamFileTypeDef,
    StreamInfoTypeDef,
    StreamSummaryTypeDef,
    StreamTypeDef,
    TagTypeDef,
    TaskStatisticsForAuditCheckTypeDef,
    TaskStatisticsTypeDef,
    ThingAttributeTypeDef,
    ThingConnectivityTypeDef,
    ThingDocumentTypeDef,
    ThingGroupDocumentTypeDef,
    ThingGroupIndexingConfigurationTypeDef,
    ThingGroupMetadataTypeDef,
    ThingGroupPropertiesTypeDef,
    ThingIndexingConfigurationTypeDef,
    ThingTypeDefinitionTypeDef,
    ThingTypeMetadataTypeDef,
    ThingTypePropertiesTypeDef,
    TimeoutConfigTypeDef,
    TimestreamActionTypeDef,
    TimestreamDimensionTypeDef,
    TimestreamTimestampTypeDef,
    TopicRuleDestinationSummaryTypeDef,
    TopicRuleDestinationTypeDef,
    TopicRuleListItemTypeDef,
    TopicRuleTypeDef,
    TransferDataTypeDef,
    UpdateCACertificateParamsTypeDef,
    UpdateDeviceCertificateParamsTypeDef,
    ValidationErrorTypeDef,
    ViolationEventAdditionalInfoTypeDef,
    ViolationEventOccurrenceRangeTypeDef,
    ViolationEventTypeDef,
    VpcDestinationConfigurationTypeDef,
    VpcDestinationPropertiesTypeDef,
    VpcDestinationSummaryTypeDef,
    AssociateTargetsWithJobResponseTypeDef,
    AwsJobAbortConfigTypeDef,
    AwsJobTimeoutConfigTypeDef,
    CancelJobResponseTypeDef,
    CreateAuthorizerResponseTypeDef,
    CreateBillingGroupResponseTypeDef,
    CreateCertificateFromCsrResponseTypeDef,
    CreateCustomMetricResponseTypeDef,
    CreateDimensionResponseTypeDef,
    CreateDomainConfigurationResponseTypeDef,
    CreateDynamicThingGroupResponseTypeDef,
    CreateJobResponseTypeDef,
    CreateKeysAndCertificateResponseTypeDef,
    CreateMitigationActionResponseTypeDef,
    CreateOTAUpdateResponseTypeDef,
    CreatePolicyResponseTypeDef,
    CreatePolicyVersionResponseTypeDef,
    CreateProvisioningClaimResponseTypeDef,
    CreateProvisioningTemplateResponseTypeDef,
    CreateProvisioningTemplateVersionResponseTypeDef,
    CreateRoleAliasResponseTypeDef,
    CreateScheduledAuditResponseTypeDef,
    CreateSecurityProfileResponseTypeDef,
    CreateStreamResponseTypeDef,
    CreateThingGroupResponseTypeDef,
    CreateThingResponseTypeDef,
    CreateThingTypeResponseTypeDef,
    CreateTopicRuleDestinationResponseTypeDef,
    DescribeAccountAuditConfigurationResponseTypeDef,
    DescribeAuditFindingResponseTypeDef,
    DescribeAuditMitigationActionsTaskResponseTypeDef,
    DescribeAuditSuppressionResponseTypeDef,
    DescribeAuditTaskResponseTypeDef,
    DescribeAuthorizerResponseTypeDef,
    DescribeBillingGroupResponseTypeDef,
    DescribeCACertificateResponseTypeDef,
    DescribeCertificateResponseTypeDef,
    DescribeCustomMetricResponseTypeDef,
    DescribeDefaultAuthorizerResponseTypeDef,
    DescribeDetectMitigationActionsTaskResponseTypeDef,
    DescribeDimensionResponseTypeDef,
    DescribeDomainConfigurationResponseTypeDef,
    DescribeEndpointResponseTypeDef,
    DescribeEventConfigurationsResponseTypeDef,
    DescribeIndexResponseTypeDef,
    DescribeJobExecutionResponseTypeDef,
    DescribeJobResponseTypeDef,
    DescribeMitigationActionResponseTypeDef,
    DescribeProvisioningTemplateResponseTypeDef,
    DescribeProvisioningTemplateVersionResponseTypeDef,
    DescribeRoleAliasResponseTypeDef,
    DescribeScheduledAuditResponseTypeDef,
    DescribeSecurityProfileResponseTypeDef,
    DescribeStreamResponseTypeDef,
    DescribeThingGroupResponseTypeDef,
    DescribeThingRegistrationTaskResponseTypeDef,
    DescribeThingResponseTypeDef,
    DescribeThingTypeResponseTypeDef,
    GetBehaviorModelTrainingSummariesResponseTypeDef,
    GetCardinalityResponseTypeDef,
    GetEffectivePoliciesResponseTypeDef,
    GetIndexingConfigurationResponseTypeDef,
    GetJobDocumentResponseTypeDef,
    GetLoggingOptionsResponseTypeDef,
    GetOTAUpdateResponseTypeDef,
    GetPercentilesResponseTypeDef,
    GetPolicyResponseTypeDef,
    GetPolicyVersionResponseTypeDef,
    GetRegistrationCodeResponseTypeDef,
    GetStatisticsResponseTypeDef,
    GetTopicRuleDestinationResponseTypeDef,
    GetTopicRuleResponseTypeDef,
    GetV2LoggingOptionsResponseTypeDef,
    HttpContextTypeDef,
    ListActiveViolationsResponseTypeDef,
    ListAttachedPoliciesResponseTypeDef,
    ListAuditFindingsResponseTypeDef,
    ListAuditMitigationActionsExecutionsResponseTypeDef,
    ListAuditMitigationActionsTasksResponseTypeDef,
    ListAuditSuppressionsResponseTypeDef,
    ListAuditTasksResponseTypeDef,
    ListAuthorizersResponseTypeDef,
    ListBillingGroupsResponseTypeDef,
    ListCACertificatesResponseTypeDef,
    ListCertificatesByCAResponseTypeDef,
    ListCertificatesResponseTypeDef,
    ListCustomMetricsResponseTypeDef,
    ListDetectMitigationActionsExecutionsResponseTypeDef,
    ListDetectMitigationActionsTasksResponseTypeDef,
    ListDimensionsResponseTypeDef,
    ListDomainConfigurationsResponseTypeDef,
    ListIndicesResponseTypeDef,
    ListJobExecutionsForJobResponseTypeDef,
    ListJobExecutionsForThingResponseTypeDef,
    ListJobsResponseTypeDef,
    ListMitigationActionsResponseTypeDef,
    ListOTAUpdatesResponseTypeDef,
    ListOutgoingCertificatesResponseTypeDef,
    ListPoliciesResponseTypeDef,
    ListPolicyPrincipalsResponseTypeDef,
    ListPolicyVersionsResponseTypeDef,
    ListPrincipalPoliciesResponseTypeDef,
    ListPrincipalThingsResponseTypeDef,
    ListProvisioningTemplateVersionsResponseTypeDef,
    ListProvisioningTemplatesResponseTypeDef,
    ListRoleAliasesResponseTypeDef,
    ListScheduledAuditsResponseTypeDef,
    ListSecurityProfilesForTargetResponseTypeDef,
    ListSecurityProfilesResponseTypeDef,
    ListStreamsResponseTypeDef,
    ListTagsForResourceResponseTypeDef,
    ListTargetsForPolicyResponseTypeDef,
    ListTargetsForSecurityProfileResponseTypeDef,
    ListThingGroupsForThingResponseTypeDef,
    ListThingGroupsResponseTypeDef,
    ListThingPrincipalsResponseTypeDef,
    ListThingRegistrationTaskReportsResponseTypeDef,
    ListThingRegistrationTasksResponseTypeDef,
    ListThingTypesResponseTypeDef,
    ListThingsInBillingGroupResponseTypeDef,
    ListThingsInThingGroupResponseTypeDef,
    ListThingsResponseTypeDef,
    ListTopicRuleDestinationsResponseTypeDef,
    ListTopicRulesResponseTypeDef,
    ListV2LoggingLevelsResponseTypeDef,
    ListViolationEventsResponseTypeDef,
    LoggingOptionsPayloadTypeDef,
    MqttContextTypeDef,
    PaginatorConfigTypeDef,
    RegisterCACertificateResponseTypeDef,
    RegisterCertificateResponseTypeDef,
    RegisterCertificateWithoutCAResponseTypeDef,
    RegisterThingResponseTypeDef,
    SearchIndexResponseTypeDef,
    SetDefaultAuthorizerResponseTypeDef,
    StartAuditMitigationActionsTaskResponseTypeDef,
    StartDetectMitigationActionsTaskResponseTypeDef,
    StartOnDemandAuditTaskResponseTypeDef,
    StartThingRegistrationTaskResponseTypeDef,
    TestAuthorizationResponseTypeDef,
    TestInvokeAuthorizerResponseTypeDef,
    TlsContextTypeDef,
    TopicRuleDestinationConfigurationTypeDef,
    TopicRulePayloadTypeDef,
    TransferCertificateResponseTypeDef,
    UpdateAuthorizerResponseTypeDef,
    UpdateBillingGroupResponseTypeDef,
    UpdateCustomMetricResponseTypeDef,
    UpdateDimensionResponseTypeDef,
    UpdateDomainConfigurationResponseTypeDef,
    UpdateDynamicThingGroupResponseTypeDef,
    UpdateMitigationActionResponseTypeDef,
    UpdateRoleAliasResponseTypeDef,
    UpdateScheduledAuditResponseTypeDef,
    UpdateSecurityProfileResponseTypeDef,
    UpdateStreamResponseTypeDef,
    UpdateThingGroupResponseTypeDef,
    ValidateSecurityProfileBehaviorsResponseTypeDef,
)

def get_structure() -> AbortConfigTypeDef:
    return {
      ...
    }
```
