import pytest

from starknet_py.hash.storage import get_storage_var_address

# fmt: off


@pytest.mark.parametrize(
    "value, args, address",
    [
        ("a", [], 1247650000417123719142308899207783949116295758836619114717800638088997106123),
        ("a", [123, 456, 789], 404238469756318355939104484967681930221679732602307291786242730553081970461),
        ("a" * 32, [], 1639766182393060139699536825713183380146349476460289054183902158918808727042),
        ("a" * 64, [32, 64, 128, 256], 1170278195143236183253456127997214153696661952271500757743981570818429662143),
        ("storage_name", [], 268122074306748686933226222576463058414657484382047525198367644523311212699),
        ("storage_name", [2, 2, 2], 1815994203838325690189267524162006605165509742004447508084124379729518768247),
        ("another_storage_name", [3], 3209489259786454249517264229792296517536124865381513663576107903160324151127),
    ],
)
def test_get_storage_var_address(value, args, address):
    assert get_storage_var_address(value, *args) == address
