# coding=utf-8
# *** WARNING: this file was generated by pulumi-gen-awsx. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import pulumi
from enum import Enum

__all__ = [
    'NatGatewayStrategy',
    'SubnetAllocationStrategy',
    'SubnetType',
]


@pulumi.type_token("awsx:ec2:NatGatewayStrategy")
class NatGatewayStrategy(_builtins.str, Enum):
    """
    A strategy for creating NAT Gateways for private subnets within a VPC.
    """
    NONE = "None"
    """
    Do not create any NAT Gateways. Resources in private subnets will not be able to access the internet.
    """
    SINGLE = "Single"
    """
    Create a single NAT Gateway for the entire VPC. This configuration is not recommended for production infrastructure as it creates a single point of failure.
    """
    ONE_PER_AZ = "OnePerAz"
    """
    Create a NAT Gateway in each availability zone. This is the recommended configuration for production infrastructure.
    """


@pulumi.type_token("awsx:ec2:SubnetAllocationStrategy")
class SubnetAllocationStrategy(_builtins.str, Enum):
    """
    Strategy for calculating subnet ranges from the subnet specifications.
    """
    LEGACY = "Legacy"
    """
    Group private subnets first, followed by public subnets, followed by isolated subnets.
    """
    AUTO = "Auto"
    """
    Order remains as specified by specs, allowing gaps where required.
    """
    EXACT = "Exact"
    """
    Whole range of VPC must be accounted for, using "Unused" spec types for deliberate gaps.
    """


@pulumi.type_token("awsx:ec2:SubnetType")
class SubnetType(_builtins.str, Enum):
    """
    A type of subnet within a VPC.
    """
    PUBLIC = "Public"
    """
    A subnet whose hosts can directly communicate with the internet.
    """
    PRIVATE = "Private"
    """
    A subnet whose hosts can not directly communicate with the internet, but can initiate outbound network traffic via a NAT Gateway.
    """
    ISOLATED = "Isolated"
    """
    A subnet whose hosts have no connectivity with the internet.
    """
    UNUSED = "Unused"
    """
    A subnet range which is reserved, but no subnet will be created.
    """
