# coding=utf-8
# *** WARNING: this file was generated by pulumi-gen-awsx. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import awsx as _awsx
from ._enums import *
import pulumi_aws

__all__ = [
    'EC2ServiceTaskDefinitionArgs',
    'EC2ServiceTaskDefinitionArgsDict',
    'FargateServiceTaskDefinitionArgs',
    'FargateServiceTaskDefinitionArgsDict',
    'TaskDefinitionContainerDefinitionArgs',
    'TaskDefinitionContainerDefinitionArgsDict',
    'TaskDefinitionContainerDependencyArgs',
    'TaskDefinitionContainerDependencyArgsDict',
    'TaskDefinitionDeviceArgs',
    'TaskDefinitionDeviceArgsDict',
    'TaskDefinitionEnvironmentFileArgs',
    'TaskDefinitionEnvironmentFileArgsDict',
    'TaskDefinitionFirelensConfigurationArgs',
    'TaskDefinitionFirelensConfigurationArgsDict',
    'TaskDefinitionHealthCheckArgs',
    'TaskDefinitionHealthCheckArgsDict',
    'TaskDefinitionHostEntryArgs',
    'TaskDefinitionHostEntryArgsDict',
    'TaskDefinitionKernelCapabilitiesArgs',
    'TaskDefinitionKernelCapabilitiesArgsDict',
    'TaskDefinitionKeyValuePairArgs',
    'TaskDefinitionKeyValuePairArgsDict',
    'TaskDefinitionLinuxParametersArgs',
    'TaskDefinitionLinuxParametersArgsDict',
    'TaskDefinitionLogConfigurationArgs',
    'TaskDefinitionLogConfigurationArgsDict',
    'TaskDefinitionMountPointArgs',
    'TaskDefinitionMountPointArgsDict',
    'TaskDefinitionPortMappingArgs',
    'TaskDefinitionPortMappingArgsDict',
    'TaskDefinitionRepositoryCredentialsArgs',
    'TaskDefinitionRepositoryCredentialsArgsDict',
    'TaskDefinitionResourceRequirementArgs',
    'TaskDefinitionResourceRequirementArgsDict',
    'TaskDefinitionSecretArgs',
    'TaskDefinitionSecretArgsDict',
    'TaskDefinitionSystemControlArgs',
    'TaskDefinitionSystemControlArgsDict',
    'TaskDefinitionTmpfsArgs',
    'TaskDefinitionTmpfsArgsDict',
    'TaskDefinitionUlimitArgs',
    'TaskDefinitionUlimitArgsDict',
    'TaskDefinitionVolumeFromArgs',
    'TaskDefinitionVolumeFromArgsDict',
]

MYPY = False

if not MYPY:
    class EC2ServiceTaskDefinitionArgsDict(TypedDict):
        """
        Create a TaskDefinition resource with the given unique name, arguments, and options.
        Creates required log-group and task & execution roles.
        Presents required Service load balancers if target group included in port mappings.
        """
        container: NotRequired['TaskDefinitionContainerDefinitionArgsDict']
        """
        Single container to make a TaskDefinition from.  Useful for simple cases where there aren't
        multiple containers, especially when creating a TaskDefinition to call [run] on.

        Either [container] or [containers] must be provided.
        """
        containers: NotRequired[Mapping[str, 'TaskDefinitionContainerDefinitionArgsDict']]
        """
        All the containers to make a TaskDefinition from.  Useful when creating a Service that will
        contain many containers within.

        Either [container] or [containers] must be provided.
        """
        cpu: NotRequired[pulumi.Input[_builtins.str]]
        """
        The number of cpu units used by the task. If not provided, a default will be computed based on the cumulative needs specified by [containerDefinitions]
        """
        enable_fault_injection: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Enables fault injection and allows for fault injection requests to be accepted from the task's containers. Default is `false`.
        """
        ephemeral_storage: NotRequired[pulumi.Input['pulumi_aws.ecs.TaskDefinitionEphemeralStorageArgsDict']]
        """
        The amount of ephemeral storage to allocate for the task. This parameter is used to expand the total amount of ephemeral storage available, beyond the default amount, for tasks hosted on AWS Fargate. See Ephemeral Storage.
        """
        execution_role: NotRequired['_awsx.DefaultRoleWithPolicyArgsDict']
        """
        The execution role that the Amazon ECS container agent and the Docker daemon can assume.
        Will be created automatically if not defined.
        """
        family: NotRequired[pulumi.Input[_builtins.str]]
        """
        An optional unique name for your task definition. If not specified, then a default will be created.
        """
        ipc_mode: NotRequired[pulumi.Input[_builtins.str]]
        """
        IPC resource namespace to be used for the containers in the task The valid values are `host`, `task`, and `none`.
        """
        log_group: NotRequired['_awsx.DefaultLogGroupArgsDict']
        """
        A set of volume blocks that containers in your task may use.
        """
        memory: NotRequired[pulumi.Input[_builtins.str]]
        """
        The amount (in MiB) of memory used by the task.  If not provided, a default will be computed
        based on the cumulative needs specified by [containerDefinitions]
        """
        network_mode: NotRequired[pulumi.Input[_builtins.str]]
        """
        Docker networking mode to use for the containers in the task. Valid values are `none`, `bridge`, `awsvpc`, and `host`.
        """
        pid_mode: NotRequired[pulumi.Input[_builtins.str]]
        """
        Process namespace to use for the containers in the task. The valid values are `host` and `task`.
        """
        placement_constraints: NotRequired[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ecs.TaskDefinitionPlacementConstraintArgsDict']]]]
        """
        Configuration block for rules that are taken into consideration during task placement. Maximum number of `placement_constraints` is `10`. Detailed below.
        """
        proxy_configuration: NotRequired[pulumi.Input['pulumi_aws.ecs.TaskDefinitionProxyConfigurationArgsDict']]
        """
        Configuration block for the App Mesh proxy. Detailed below.
        """
        region: NotRequired[pulumi.Input[_builtins.str]]
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        runtime_platform: NotRequired[pulumi.Input['pulumi_aws.ecs.TaskDefinitionRuntimePlatformArgsDict']]
        """
        Configuration block for runtime_platform that containers in your task may use.
        """
        skip_destroy: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether to retain the old revision when the resource is destroyed or replacement is necessary. Default is `false`.
        """
        tags: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        task_role: NotRequired['_awsx.DefaultRoleWithPolicyArgsDict']
        """
        IAM role that allows your Amazon ECS container task to make calls to other AWS services.
        Will be created automatically if not defined.
        """
        track_latest: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether should track latest `ACTIVE` task definition on AWS or the one created with the resource stored in state. Default is `false`. Useful in the event the task definition is modified outside of this resource.
        """
        volumes: NotRequired[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ecs.TaskDefinitionVolumeArgsDict']]]]
        """
        Configuration block for volumes that containers in your task may use. Detailed below.

        > **NOTE:** Proper escaping is required for JSON field values containing quotes (`"`) such as `environment` values. If directly setting the JSON, they should be escaped as `\\"` in the JSON,  e.g., `"value": "I \\"love\\" escaped quotes"`. If using a variable value, they should be escaped as `\\\\\\"` in the variable, e.g., `value = "I \\\\\\"love\\\\\\" escaped quotes"` in the variable and `"value": "${var.myvariable}"` in the JSON.

        > **Note:** Fault injection only works with tasks using the `awsvpc` or `host` network modes. Fault injection isn't available on Windows.
        """
elif False:
    EC2ServiceTaskDefinitionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EC2ServiceTaskDefinitionArgs:
    def __init__(__self__, *,
                 container: Optional['TaskDefinitionContainerDefinitionArgs'] = None,
                 containers: Optional[Mapping[str, 'TaskDefinitionContainerDefinitionArgs']] = None,
                 cpu: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_fault_injection: Optional[pulumi.Input[_builtins.bool]] = None,
                 ephemeral_storage: Optional[pulumi.Input['pulumi_aws.ecs.TaskDefinitionEphemeralStorageArgs']] = None,
                 execution_role: Optional['_awsx.DefaultRoleWithPolicyArgs'] = None,
                 family: Optional[pulumi.Input[_builtins.str]] = None,
                 ipc_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 log_group: Optional['_awsx.DefaultLogGroupArgs'] = None,
                 memory: Optional[pulumi.Input[_builtins.str]] = None,
                 network_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 pid_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 placement_constraints: Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ecs.TaskDefinitionPlacementConstraintArgs']]]] = None,
                 proxy_configuration: Optional[pulumi.Input['pulumi_aws.ecs.TaskDefinitionProxyConfigurationArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 runtime_platform: Optional[pulumi.Input['pulumi_aws.ecs.TaskDefinitionRuntimePlatformArgs']] = None,
                 skip_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 task_role: Optional['_awsx.DefaultRoleWithPolicyArgs'] = None,
                 track_latest: Optional[pulumi.Input[_builtins.bool]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ecs.TaskDefinitionVolumeArgs']]]] = None):
        """
        Create a TaskDefinition resource with the given unique name, arguments, and options.
        Creates required log-group and task & execution roles.
        Presents required Service load balancers if target group included in port mappings.
        :param 'TaskDefinitionContainerDefinitionArgs' container: Single container to make a TaskDefinition from.  Useful for simple cases where there aren't
               multiple containers, especially when creating a TaskDefinition to call [run] on.
               
               Either [container] or [containers] must be provided.
        :param Mapping[str, 'TaskDefinitionContainerDefinitionArgs'] containers: All the containers to make a TaskDefinition from.  Useful when creating a Service that will
               contain many containers within.
               
               Either [container] or [containers] must be provided.
        :param pulumi.Input[_builtins.str] cpu: The number of cpu units used by the task. If not provided, a default will be computed based on the cumulative needs specified by [containerDefinitions]
        :param pulumi.Input[_builtins.bool] enable_fault_injection: Enables fault injection and allows for fault injection requests to be accepted from the task's containers. Default is `false`.
        :param pulumi.Input['pulumi_aws.ecs.TaskDefinitionEphemeralStorageArgs'] ephemeral_storage: The amount of ephemeral storage to allocate for the task. This parameter is used to expand the total amount of ephemeral storage available, beyond the default amount, for tasks hosted on AWS Fargate. See Ephemeral Storage.
        :param '_awsx.DefaultRoleWithPolicyArgs' execution_role: The execution role that the Amazon ECS container agent and the Docker daemon can assume.
               Will be created automatically if not defined.
        :param pulumi.Input[_builtins.str] family: An optional unique name for your task definition. If not specified, then a default will be created.
        :param pulumi.Input[_builtins.str] ipc_mode: IPC resource namespace to be used for the containers in the task The valid values are `host`, `task`, and `none`.
        :param '_awsx.DefaultLogGroupArgs' log_group: A set of volume blocks that containers in your task may use.
        :param pulumi.Input[_builtins.str] memory: The amount (in MiB) of memory used by the task.  If not provided, a default will be computed
               based on the cumulative needs specified by [containerDefinitions]
        :param pulumi.Input[_builtins.str] network_mode: Docker networking mode to use for the containers in the task. Valid values are `none`, `bridge`, `awsvpc`, and `host`.
        :param pulumi.Input[_builtins.str] pid_mode: Process namespace to use for the containers in the task. The valid values are `host` and `task`.
        :param pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ecs.TaskDefinitionPlacementConstraintArgs']]] placement_constraints: Configuration block for rules that are taken into consideration during task placement. Maximum number of `placement_constraints` is `10`. Detailed below.
        :param pulumi.Input['pulumi_aws.ecs.TaskDefinitionProxyConfigurationArgs'] proxy_configuration: Configuration block for the App Mesh proxy. Detailed below.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input['pulumi_aws.ecs.TaskDefinitionRuntimePlatformArgs'] runtime_platform: Configuration block for runtime_platform that containers in your task may use.
        :param pulumi.Input[_builtins.bool] skip_destroy: Whether to retain the old revision when the resource is destroyed or replacement is necessary. Default is `false`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param '_awsx.DefaultRoleWithPolicyArgs' task_role: IAM role that allows your Amazon ECS container task to make calls to other AWS services.
               Will be created automatically if not defined.
        :param pulumi.Input[_builtins.bool] track_latest: Whether should track latest `ACTIVE` task definition on AWS or the one created with the resource stored in state. Default is `false`. Useful in the event the task definition is modified outside of this resource.
        :param pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ecs.TaskDefinitionVolumeArgs']]] volumes: Configuration block for volumes that containers in your task may use. Detailed below.
               
               > **NOTE:** Proper escaping is required for JSON field values containing quotes (`"`) such as `environment` values. If directly setting the JSON, they should be escaped as `\\"` in the JSON,  e.g., `"value": "I \\"love\\" escaped quotes"`. If using a variable value, they should be escaped as `\\\\\\"` in the variable, e.g., `value = "I \\\\\\"love\\\\\\" escaped quotes"` in the variable and `"value": "${var.myvariable}"` in the JSON.
               
               > **Note:** Fault injection only works with tasks using the `awsvpc` or `host` network modes. Fault injection isn't available on Windows.
        """
        if container is not None:
            pulumi.set(__self__, "container", container)
        if containers is not None:
            pulumi.set(__self__, "containers", containers)
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if enable_fault_injection is not None:
            pulumi.set(__self__, "enable_fault_injection", enable_fault_injection)
        if ephemeral_storage is not None:
            pulumi.set(__self__, "ephemeral_storage", ephemeral_storage)
        if execution_role is not None:
            pulumi.set(__self__, "execution_role", execution_role)
        if family is not None:
            pulumi.set(__self__, "family", family)
        if ipc_mode is not None:
            pulumi.set(__self__, "ipc_mode", ipc_mode)
        if log_group is not None:
            pulumi.set(__self__, "log_group", log_group)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)
        if network_mode is not None:
            pulumi.set(__self__, "network_mode", network_mode)
        if pid_mode is not None:
            pulumi.set(__self__, "pid_mode", pid_mode)
        if placement_constraints is not None:
            pulumi.set(__self__, "placement_constraints", placement_constraints)
        if proxy_configuration is not None:
            pulumi.set(__self__, "proxy_configuration", proxy_configuration)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if runtime_platform is not None:
            pulumi.set(__self__, "runtime_platform", runtime_platform)
        if skip_destroy is not None:
            pulumi.set(__self__, "skip_destroy", skip_destroy)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if task_role is not None:
            pulumi.set(__self__, "task_role", task_role)
        if track_latest is not None:
            pulumi.set(__self__, "track_latest", track_latest)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)

    @_builtins.property
    @pulumi.getter
    def container(self) -> Optional['TaskDefinitionContainerDefinitionArgs']:
        """
        Single container to make a TaskDefinition from.  Useful for simple cases where there aren't
        multiple containers, especially when creating a TaskDefinition to call [run] on.

        Either [container] or [containers] must be provided.
        """
        return pulumi.get(self, "container")

    @container.setter
    def container(self, value: Optional['TaskDefinitionContainerDefinitionArgs']):
        pulumi.set(self, "container", value)

    @_builtins.property
    @pulumi.getter
    def containers(self) -> Optional[Mapping[str, 'TaskDefinitionContainerDefinitionArgs']]:
        """
        All the containers to make a TaskDefinition from.  Useful when creating a Service that will
        contain many containers within.

        Either [container] or [containers] must be provided.
        """
        return pulumi.get(self, "containers")

    @containers.setter
    def containers(self, value: Optional[Mapping[str, 'TaskDefinitionContainerDefinitionArgs']]):
        pulumi.set(self, "containers", value)

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The number of cpu units used by the task. If not provided, a default will be computed based on the cumulative needs specified by [containerDefinitions]
        """
        return pulumi.get(self, "cpu")

    @cpu.setter
    def cpu(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cpu", value)

    @_builtins.property
    @pulumi.getter(name="enableFaultInjection")
    def enable_fault_injection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables fault injection and allows for fault injection requests to be accepted from the task's containers. Default is `false`.
        """
        return pulumi.get(self, "enable_fault_injection")

    @enable_fault_injection.setter
    def enable_fault_injection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_fault_injection", value)

    @_builtins.property
    @pulumi.getter(name="ephemeralStorage")
    def ephemeral_storage(self) -> Optional[pulumi.Input['pulumi_aws.ecs.TaskDefinitionEphemeralStorageArgs']]:
        """
        The amount of ephemeral storage to allocate for the task. This parameter is used to expand the total amount of ephemeral storage available, beyond the default amount, for tasks hosted on AWS Fargate. See Ephemeral Storage.
        """
        return pulumi.get(self, "ephemeral_storage")

    @ephemeral_storage.setter
    def ephemeral_storage(self, value: Optional[pulumi.Input['pulumi_aws.ecs.TaskDefinitionEphemeralStorageArgs']]):
        pulumi.set(self, "ephemeral_storage", value)

    @_builtins.property
    @pulumi.getter(name="executionRole")
    def execution_role(self) -> Optional['_awsx.DefaultRoleWithPolicyArgs']:
        """
        The execution role that the Amazon ECS container agent and the Docker daemon can assume.
        Will be created automatically if not defined.
        """
        return pulumi.get(self, "execution_role")

    @execution_role.setter
    def execution_role(self, value: Optional['_awsx.DefaultRoleWithPolicyArgs']):
        pulumi.set(self, "execution_role", value)

    @_builtins.property
    @pulumi.getter
    def family(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An optional unique name for your task definition. If not specified, then a default will be created.
        """
        return pulumi.get(self, "family")

    @family.setter
    def family(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "family", value)

    @_builtins.property
    @pulumi.getter(name="ipcMode")
    def ipc_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IPC resource namespace to be used for the containers in the task The valid values are `host`, `task`, and `none`.
        """
        return pulumi.get(self, "ipc_mode")

    @ipc_mode.setter
    def ipc_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipc_mode", value)

    @_builtins.property
    @pulumi.getter(name="logGroup")
    def log_group(self) -> Optional['_awsx.DefaultLogGroupArgs']:
        """
        A set of volume blocks that containers in your task may use.
        """
        return pulumi.get(self, "log_group")

    @log_group.setter
    def log_group(self, value: Optional['_awsx.DefaultLogGroupArgs']):
        pulumi.set(self, "log_group", value)

    @_builtins.property
    @pulumi.getter
    def memory(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The amount (in MiB) of memory used by the task.  If not provided, a default will be computed
        based on the cumulative needs specified by [containerDefinitions]
        """
        return pulumi.get(self, "memory")

    @memory.setter
    def memory(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "memory", value)

    @_builtins.property
    @pulumi.getter(name="networkMode")
    def network_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Docker networking mode to use for the containers in the task. Valid values are `none`, `bridge`, `awsvpc`, and `host`.
        """
        return pulumi.get(self, "network_mode")

    @network_mode.setter
    def network_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_mode", value)

    @_builtins.property
    @pulumi.getter(name="pidMode")
    def pid_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Process namespace to use for the containers in the task. The valid values are `host` and `task`.
        """
        return pulumi.get(self, "pid_mode")

    @pid_mode.setter
    def pid_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pid_mode", value)

    @_builtins.property
    @pulumi.getter(name="placementConstraints")
    def placement_constraints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ecs.TaskDefinitionPlacementConstraintArgs']]]]:
        """
        Configuration block for rules that are taken into consideration during task placement. Maximum number of `placement_constraints` is `10`. Detailed below.
        """
        return pulumi.get(self, "placement_constraints")

    @placement_constraints.setter
    def placement_constraints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ecs.TaskDefinitionPlacementConstraintArgs']]]]):
        pulumi.set(self, "placement_constraints", value)

    @_builtins.property
    @pulumi.getter(name="proxyConfiguration")
    def proxy_configuration(self) -> Optional[pulumi.Input['pulumi_aws.ecs.TaskDefinitionProxyConfigurationArgs']]:
        """
        Configuration block for the App Mesh proxy. Detailed below.
        """
        return pulumi.get(self, "proxy_configuration")

    @proxy_configuration.setter
    def proxy_configuration(self, value: Optional[pulumi.Input['pulumi_aws.ecs.TaskDefinitionProxyConfigurationArgs']]):
        pulumi.set(self, "proxy_configuration", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="runtimePlatform")
    def runtime_platform(self) -> Optional[pulumi.Input['pulumi_aws.ecs.TaskDefinitionRuntimePlatformArgs']]:
        """
        Configuration block for runtime_platform that containers in your task may use.
        """
        return pulumi.get(self, "runtime_platform")

    @runtime_platform.setter
    def runtime_platform(self, value: Optional[pulumi.Input['pulumi_aws.ecs.TaskDefinitionRuntimePlatformArgs']]):
        pulumi.set(self, "runtime_platform", value)

    @_builtins.property
    @pulumi.getter(name="skipDestroy")
    def skip_destroy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to retain the old revision when the resource is destroyed or replacement is necessary. Default is `false`.
        """
        return pulumi.get(self, "skip_destroy")

    @skip_destroy.setter
    def skip_destroy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_destroy", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="taskRole")
    def task_role(self) -> Optional['_awsx.DefaultRoleWithPolicyArgs']:
        """
        IAM role that allows your Amazon ECS container task to make calls to other AWS services.
        Will be created automatically if not defined.
        """
        return pulumi.get(self, "task_role")

    @task_role.setter
    def task_role(self, value: Optional['_awsx.DefaultRoleWithPolicyArgs']):
        pulumi.set(self, "task_role", value)

    @_builtins.property
    @pulumi.getter(name="trackLatest")
    def track_latest(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether should track latest `ACTIVE` task definition on AWS or the one created with the resource stored in state. Default is `false`. Useful in the event the task definition is modified outside of this resource.
        """
        return pulumi.get(self, "track_latest")

    @track_latest.setter
    def track_latest(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "track_latest", value)

    @_builtins.property
    @pulumi.getter
    def volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ecs.TaskDefinitionVolumeArgs']]]]:
        """
        Configuration block for volumes that containers in your task may use. Detailed below.

        > **NOTE:** Proper escaping is required for JSON field values containing quotes (`"`) such as `environment` values. If directly setting the JSON, they should be escaped as `\\"` in the JSON,  e.g., `"value": "I \\"love\\" escaped quotes"`. If using a variable value, they should be escaped as `\\\\\\"` in the variable, e.g., `value = "I \\\\\\"love\\\\\\" escaped quotes"` in the variable and `"value": "${var.myvariable}"` in the JSON.

        > **Note:** Fault injection only works with tasks using the `awsvpc` or `host` network modes. Fault injection isn't available on Windows.
        """
        return pulumi.get(self, "volumes")

    @volumes.setter
    def volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ecs.TaskDefinitionVolumeArgs']]]]):
        pulumi.set(self, "volumes", value)


if not MYPY:
    class FargateServiceTaskDefinitionArgsDict(TypedDict):
        """
        Create a TaskDefinition resource with the given unique name, arguments, and options.
        Creates required log-group and task & execution roles.
        Presents required Service load balancers if target group included in port mappings.
        """
        container: NotRequired['TaskDefinitionContainerDefinitionArgsDict']
        """
        Single container to make a TaskDefinition from.  Useful for simple cases where there aren't
        multiple containers, especially when creating a TaskDefinition to call [run] on.

        Either [container] or [containers] must be provided.
        """
        containers: NotRequired[Mapping[str, 'TaskDefinitionContainerDefinitionArgsDict']]
        """
        All the containers to make a TaskDefinition from.  Useful when creating a Service that will
        contain many containers within.

        Either [container] or [containers] must be provided.
        """
        cpu: NotRequired[pulumi.Input[_builtins.str]]
        """
        The number of cpu units used by the task. If not provided, a default will be computed based on the cumulative needs specified by [containerDefinitions]
        """
        enable_fault_injection: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Enables fault injection and allows for fault injection requests to be accepted from the task's containers. Default is `false`.
        """
        ephemeral_storage: NotRequired[pulumi.Input['pulumi_aws.ecs.TaskDefinitionEphemeralStorageArgsDict']]
        """
        The amount of ephemeral storage to allocate for the task. This parameter is used to expand the total amount of ephemeral storage available, beyond the default amount, for tasks hosted on AWS Fargate. See Ephemeral Storage.
        """
        execution_role: NotRequired['_awsx.DefaultRoleWithPolicyArgsDict']
        """
        The execution role that the Amazon ECS container agent and the Docker daemon can assume.
        Will be created automatically if not defined.
        """
        family: NotRequired[pulumi.Input[_builtins.str]]
        """
        An optional unique name for your task definition. If not specified, then a default will be created.
        """
        ipc_mode: NotRequired[pulumi.Input[_builtins.str]]
        """
        IPC resource namespace to be used for the containers in the task The valid values are `host`, `task`, and `none`.
        """
        log_group: NotRequired['_awsx.DefaultLogGroupArgsDict']
        """
        A set of volume blocks that containers in your task may use.
        """
        memory: NotRequired[pulumi.Input[_builtins.str]]
        """
        The amount (in MiB) of memory used by the task.  If not provided, a default will be computed
        based on the cumulative needs specified by [containerDefinitions]
        """
        pid_mode: NotRequired[pulumi.Input[_builtins.str]]
        """
        Process namespace to use for the containers in the task. The valid values are `host` and `task`.
        """
        placement_constraints: NotRequired[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ecs.TaskDefinitionPlacementConstraintArgsDict']]]]
        """
        Configuration block for rules that are taken into consideration during task placement. Maximum number of `placement_constraints` is `10`. Detailed below.
        """
        proxy_configuration: NotRequired[pulumi.Input['pulumi_aws.ecs.TaskDefinitionProxyConfigurationArgsDict']]
        """
        Configuration block for the App Mesh proxy. Detailed below.
        """
        region: NotRequired[pulumi.Input[_builtins.str]]
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        runtime_platform: NotRequired[pulumi.Input['pulumi_aws.ecs.TaskDefinitionRuntimePlatformArgsDict']]
        """
        Configuration block for runtime_platform that containers in your task may use.
        """
        skip_destroy: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether to retain the old revision when the resource is destroyed or replacement is necessary. Default is `false`.
        """
        tags: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        task_role: NotRequired['_awsx.DefaultRoleWithPolicyArgsDict']
        """
        IAM role that allows your Amazon ECS container task to make calls to other AWS services.
        Will be created automatically if not defined.
        """
        track_latest: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether should track latest `ACTIVE` task definition on AWS or the one created with the resource stored in state. Default is `false`. Useful in the event the task definition is modified outside of this resource.
        """
        volumes: NotRequired[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ecs.TaskDefinitionVolumeArgsDict']]]]
        """
        Configuration block for volumes that containers in your task may use. Detailed below.

        > **NOTE:** Proper escaping is required for JSON field values containing quotes (`"`) such as `environment` values. If directly setting the JSON, they should be escaped as `\\"` in the JSON,  e.g., `"value": "I \\"love\\" escaped quotes"`. If using a variable value, they should be escaped as `\\\\\\"` in the variable, e.g., `value = "I \\\\\\"love\\\\\\" escaped quotes"` in the variable and `"value": "${var.myvariable}"` in the JSON.

        > **Note:** Fault injection only works with tasks using the `awsvpc` or `host` network modes. Fault injection isn't available on Windows.
        """
elif False:
    FargateServiceTaskDefinitionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FargateServiceTaskDefinitionArgs:
    def __init__(__self__, *,
                 container: Optional['TaskDefinitionContainerDefinitionArgs'] = None,
                 containers: Optional[Mapping[str, 'TaskDefinitionContainerDefinitionArgs']] = None,
                 cpu: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_fault_injection: Optional[pulumi.Input[_builtins.bool]] = None,
                 ephemeral_storage: Optional[pulumi.Input['pulumi_aws.ecs.TaskDefinitionEphemeralStorageArgs']] = None,
                 execution_role: Optional['_awsx.DefaultRoleWithPolicyArgs'] = None,
                 family: Optional[pulumi.Input[_builtins.str]] = None,
                 ipc_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 log_group: Optional['_awsx.DefaultLogGroupArgs'] = None,
                 memory: Optional[pulumi.Input[_builtins.str]] = None,
                 pid_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 placement_constraints: Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ecs.TaskDefinitionPlacementConstraintArgs']]]] = None,
                 proxy_configuration: Optional[pulumi.Input['pulumi_aws.ecs.TaskDefinitionProxyConfigurationArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 runtime_platform: Optional[pulumi.Input['pulumi_aws.ecs.TaskDefinitionRuntimePlatformArgs']] = None,
                 skip_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 task_role: Optional['_awsx.DefaultRoleWithPolicyArgs'] = None,
                 track_latest: Optional[pulumi.Input[_builtins.bool]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ecs.TaskDefinitionVolumeArgs']]]] = None):
        """
        Create a TaskDefinition resource with the given unique name, arguments, and options.
        Creates required log-group and task & execution roles.
        Presents required Service load balancers if target group included in port mappings.
        :param 'TaskDefinitionContainerDefinitionArgs' container: Single container to make a TaskDefinition from.  Useful for simple cases where there aren't
               multiple containers, especially when creating a TaskDefinition to call [run] on.
               
               Either [container] or [containers] must be provided.
        :param Mapping[str, 'TaskDefinitionContainerDefinitionArgs'] containers: All the containers to make a TaskDefinition from.  Useful when creating a Service that will
               contain many containers within.
               
               Either [container] or [containers] must be provided.
        :param pulumi.Input[_builtins.str] cpu: The number of cpu units used by the task. If not provided, a default will be computed based on the cumulative needs specified by [containerDefinitions]
        :param pulumi.Input[_builtins.bool] enable_fault_injection: Enables fault injection and allows for fault injection requests to be accepted from the task's containers. Default is `false`.
        :param pulumi.Input['pulumi_aws.ecs.TaskDefinitionEphemeralStorageArgs'] ephemeral_storage: The amount of ephemeral storage to allocate for the task. This parameter is used to expand the total amount of ephemeral storage available, beyond the default amount, for tasks hosted on AWS Fargate. See Ephemeral Storage.
        :param '_awsx.DefaultRoleWithPolicyArgs' execution_role: The execution role that the Amazon ECS container agent and the Docker daemon can assume.
               Will be created automatically if not defined.
        :param pulumi.Input[_builtins.str] family: An optional unique name for your task definition. If not specified, then a default will be created.
        :param pulumi.Input[_builtins.str] ipc_mode: IPC resource namespace to be used for the containers in the task The valid values are `host`, `task`, and `none`.
        :param '_awsx.DefaultLogGroupArgs' log_group: A set of volume blocks that containers in your task may use.
        :param pulumi.Input[_builtins.str] memory: The amount (in MiB) of memory used by the task.  If not provided, a default will be computed
               based on the cumulative needs specified by [containerDefinitions]
        :param pulumi.Input[_builtins.str] pid_mode: Process namespace to use for the containers in the task. The valid values are `host` and `task`.
        :param pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ecs.TaskDefinitionPlacementConstraintArgs']]] placement_constraints: Configuration block for rules that are taken into consideration during task placement. Maximum number of `placement_constraints` is `10`. Detailed below.
        :param pulumi.Input['pulumi_aws.ecs.TaskDefinitionProxyConfigurationArgs'] proxy_configuration: Configuration block for the App Mesh proxy. Detailed below.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input['pulumi_aws.ecs.TaskDefinitionRuntimePlatformArgs'] runtime_platform: Configuration block for runtime_platform that containers in your task may use.
        :param pulumi.Input[_builtins.bool] skip_destroy: Whether to retain the old revision when the resource is destroyed or replacement is necessary. Default is `false`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param '_awsx.DefaultRoleWithPolicyArgs' task_role: IAM role that allows your Amazon ECS container task to make calls to other AWS services.
               Will be created automatically if not defined.
        :param pulumi.Input[_builtins.bool] track_latest: Whether should track latest `ACTIVE` task definition on AWS or the one created with the resource stored in state. Default is `false`. Useful in the event the task definition is modified outside of this resource.
        :param pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ecs.TaskDefinitionVolumeArgs']]] volumes: Configuration block for volumes that containers in your task may use. Detailed below.
               
               > **NOTE:** Proper escaping is required for JSON field values containing quotes (`"`) such as `environment` values. If directly setting the JSON, they should be escaped as `\\"` in the JSON,  e.g., `"value": "I \\"love\\" escaped quotes"`. If using a variable value, they should be escaped as `\\\\\\"` in the variable, e.g., `value = "I \\\\\\"love\\\\\\" escaped quotes"` in the variable and `"value": "${var.myvariable}"` in the JSON.
               
               > **Note:** Fault injection only works with tasks using the `awsvpc` or `host` network modes. Fault injection isn't available on Windows.
        """
        if container is not None:
            pulumi.set(__self__, "container", container)
        if containers is not None:
            pulumi.set(__self__, "containers", containers)
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if enable_fault_injection is not None:
            pulumi.set(__self__, "enable_fault_injection", enable_fault_injection)
        if ephemeral_storage is not None:
            pulumi.set(__self__, "ephemeral_storage", ephemeral_storage)
        if execution_role is not None:
            pulumi.set(__self__, "execution_role", execution_role)
        if family is not None:
            pulumi.set(__self__, "family", family)
        if ipc_mode is not None:
            pulumi.set(__self__, "ipc_mode", ipc_mode)
        if log_group is not None:
            pulumi.set(__self__, "log_group", log_group)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)
        if pid_mode is not None:
            pulumi.set(__self__, "pid_mode", pid_mode)
        if placement_constraints is not None:
            pulumi.set(__self__, "placement_constraints", placement_constraints)
        if proxy_configuration is not None:
            pulumi.set(__self__, "proxy_configuration", proxy_configuration)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if runtime_platform is not None:
            pulumi.set(__self__, "runtime_platform", runtime_platform)
        if skip_destroy is not None:
            pulumi.set(__self__, "skip_destroy", skip_destroy)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if task_role is not None:
            pulumi.set(__self__, "task_role", task_role)
        if track_latest is not None:
            pulumi.set(__self__, "track_latest", track_latest)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)

    @_builtins.property
    @pulumi.getter
    def container(self) -> Optional['TaskDefinitionContainerDefinitionArgs']:
        """
        Single container to make a TaskDefinition from.  Useful for simple cases where there aren't
        multiple containers, especially when creating a TaskDefinition to call [run] on.

        Either [container] or [containers] must be provided.
        """
        return pulumi.get(self, "container")

    @container.setter
    def container(self, value: Optional['TaskDefinitionContainerDefinitionArgs']):
        pulumi.set(self, "container", value)

    @_builtins.property
    @pulumi.getter
    def containers(self) -> Optional[Mapping[str, 'TaskDefinitionContainerDefinitionArgs']]:
        """
        All the containers to make a TaskDefinition from.  Useful when creating a Service that will
        contain many containers within.

        Either [container] or [containers] must be provided.
        """
        return pulumi.get(self, "containers")

    @containers.setter
    def containers(self, value: Optional[Mapping[str, 'TaskDefinitionContainerDefinitionArgs']]):
        pulumi.set(self, "containers", value)

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The number of cpu units used by the task. If not provided, a default will be computed based on the cumulative needs specified by [containerDefinitions]
        """
        return pulumi.get(self, "cpu")

    @cpu.setter
    def cpu(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cpu", value)

    @_builtins.property
    @pulumi.getter(name="enableFaultInjection")
    def enable_fault_injection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables fault injection and allows for fault injection requests to be accepted from the task's containers. Default is `false`.
        """
        return pulumi.get(self, "enable_fault_injection")

    @enable_fault_injection.setter
    def enable_fault_injection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_fault_injection", value)

    @_builtins.property
    @pulumi.getter(name="ephemeralStorage")
    def ephemeral_storage(self) -> Optional[pulumi.Input['pulumi_aws.ecs.TaskDefinitionEphemeralStorageArgs']]:
        """
        The amount of ephemeral storage to allocate for the task. This parameter is used to expand the total amount of ephemeral storage available, beyond the default amount, for tasks hosted on AWS Fargate. See Ephemeral Storage.
        """
        return pulumi.get(self, "ephemeral_storage")

    @ephemeral_storage.setter
    def ephemeral_storage(self, value: Optional[pulumi.Input['pulumi_aws.ecs.TaskDefinitionEphemeralStorageArgs']]):
        pulumi.set(self, "ephemeral_storage", value)

    @_builtins.property
    @pulumi.getter(name="executionRole")
    def execution_role(self) -> Optional['_awsx.DefaultRoleWithPolicyArgs']:
        """
        The execution role that the Amazon ECS container agent and the Docker daemon can assume.
        Will be created automatically if not defined.
        """
        return pulumi.get(self, "execution_role")

    @execution_role.setter
    def execution_role(self, value: Optional['_awsx.DefaultRoleWithPolicyArgs']):
        pulumi.set(self, "execution_role", value)

    @_builtins.property
    @pulumi.getter
    def family(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An optional unique name for your task definition. If not specified, then a default will be created.
        """
        return pulumi.get(self, "family")

    @family.setter
    def family(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "family", value)

    @_builtins.property
    @pulumi.getter(name="ipcMode")
    def ipc_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IPC resource namespace to be used for the containers in the task The valid values are `host`, `task`, and `none`.
        """
        return pulumi.get(self, "ipc_mode")

    @ipc_mode.setter
    def ipc_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipc_mode", value)

    @_builtins.property
    @pulumi.getter(name="logGroup")
    def log_group(self) -> Optional['_awsx.DefaultLogGroupArgs']:
        """
        A set of volume blocks that containers in your task may use.
        """
        return pulumi.get(self, "log_group")

    @log_group.setter
    def log_group(self, value: Optional['_awsx.DefaultLogGroupArgs']):
        pulumi.set(self, "log_group", value)

    @_builtins.property
    @pulumi.getter
    def memory(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The amount (in MiB) of memory used by the task.  If not provided, a default will be computed
        based on the cumulative needs specified by [containerDefinitions]
        """
        return pulumi.get(self, "memory")

    @memory.setter
    def memory(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "memory", value)

    @_builtins.property
    @pulumi.getter(name="pidMode")
    def pid_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Process namespace to use for the containers in the task. The valid values are `host` and `task`.
        """
        return pulumi.get(self, "pid_mode")

    @pid_mode.setter
    def pid_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pid_mode", value)

    @_builtins.property
    @pulumi.getter(name="placementConstraints")
    def placement_constraints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ecs.TaskDefinitionPlacementConstraintArgs']]]]:
        """
        Configuration block for rules that are taken into consideration during task placement. Maximum number of `placement_constraints` is `10`. Detailed below.
        """
        return pulumi.get(self, "placement_constraints")

    @placement_constraints.setter
    def placement_constraints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ecs.TaskDefinitionPlacementConstraintArgs']]]]):
        pulumi.set(self, "placement_constraints", value)

    @_builtins.property
    @pulumi.getter(name="proxyConfiguration")
    def proxy_configuration(self) -> Optional[pulumi.Input['pulumi_aws.ecs.TaskDefinitionProxyConfigurationArgs']]:
        """
        Configuration block for the App Mesh proxy. Detailed below.
        """
        return pulumi.get(self, "proxy_configuration")

    @proxy_configuration.setter
    def proxy_configuration(self, value: Optional[pulumi.Input['pulumi_aws.ecs.TaskDefinitionProxyConfigurationArgs']]):
        pulumi.set(self, "proxy_configuration", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="runtimePlatform")
    def runtime_platform(self) -> Optional[pulumi.Input['pulumi_aws.ecs.TaskDefinitionRuntimePlatformArgs']]:
        """
        Configuration block for runtime_platform that containers in your task may use.
        """
        return pulumi.get(self, "runtime_platform")

    @runtime_platform.setter
    def runtime_platform(self, value: Optional[pulumi.Input['pulumi_aws.ecs.TaskDefinitionRuntimePlatformArgs']]):
        pulumi.set(self, "runtime_platform", value)

    @_builtins.property
    @pulumi.getter(name="skipDestroy")
    def skip_destroy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to retain the old revision when the resource is destroyed or replacement is necessary. Default is `false`.
        """
        return pulumi.get(self, "skip_destroy")

    @skip_destroy.setter
    def skip_destroy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_destroy", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="taskRole")
    def task_role(self) -> Optional['_awsx.DefaultRoleWithPolicyArgs']:
        """
        IAM role that allows your Amazon ECS container task to make calls to other AWS services.
        Will be created automatically if not defined.
        """
        return pulumi.get(self, "task_role")

    @task_role.setter
    def task_role(self, value: Optional['_awsx.DefaultRoleWithPolicyArgs']):
        pulumi.set(self, "task_role", value)

    @_builtins.property
    @pulumi.getter(name="trackLatest")
    def track_latest(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether should track latest `ACTIVE` task definition on AWS or the one created with the resource stored in state. Default is `false`. Useful in the event the task definition is modified outside of this resource.
        """
        return pulumi.get(self, "track_latest")

    @track_latest.setter
    def track_latest(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "track_latest", value)

    @_builtins.property
    @pulumi.getter
    def volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ecs.TaskDefinitionVolumeArgs']]]]:
        """
        Configuration block for volumes that containers in your task may use. Detailed below.

        > **NOTE:** Proper escaping is required for JSON field values containing quotes (`"`) such as `environment` values. If directly setting the JSON, they should be escaped as `\\"` in the JSON,  e.g., `"value": "I \\"love\\" escaped quotes"`. If using a variable value, they should be escaped as `\\\\\\"` in the variable, e.g., `value = "I \\\\\\"love\\\\\\" escaped quotes"` in the variable and `"value": "${var.myvariable}"` in the JSON.

        > **Note:** Fault injection only works with tasks using the `awsvpc` or `host` network modes. Fault injection isn't available on Windows.
        """
        return pulumi.get(self, "volumes")

    @volumes.setter
    def volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ecs.TaskDefinitionVolumeArgs']]]]):
        pulumi.set(self, "volumes", value)


if not MYPY:
    class TaskDefinitionContainerDefinitionArgsDict(TypedDict):
        """
        List of container definitions that are passed to the Docker daemon on a container instance
        """
        image: pulumi.Input[_builtins.str]
        """
        The image used to start a container. This string is passed directly to the Docker daemon.
        """
        name: pulumi.Input[_builtins.str]
        """
        The name of a container. Up to 255 letters (uppercase and lowercase), numbers, hyphens, and underscores are allowed
        """
        command: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        cpu: NotRequired[pulumi.Input[_builtins.int]]
        depends_on: NotRequired[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionContainerDependencyArgsDict']]]]
        disable_networking: NotRequired[pulumi.Input[_builtins.bool]]
        dns_search_domains: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        dns_servers: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        docker_labels: NotRequired[Any]
        docker_security_options: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        entry_point: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        environment: NotRequired[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionKeyValuePairArgsDict']]]]
        """
        The environment variables to pass to a container
        """
        environment_files: NotRequired[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionEnvironmentFileArgsDict']]]]
        """
        The list of one or more files that contain the environment variables to pass to a container
        """
        essential: NotRequired[pulumi.Input[_builtins.bool]]
        extra_hosts: NotRequired[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionHostEntryArgsDict']]]]
        firelens_configuration: NotRequired[pulumi.Input['TaskDefinitionFirelensConfigurationArgsDict']]
        health_check: NotRequired[pulumi.Input['TaskDefinitionHealthCheckArgsDict']]
        hostname: NotRequired[pulumi.Input[_builtins.str]]
        interactive: NotRequired[pulumi.Input[_builtins.bool]]
        links: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        linux_parameters: NotRequired[pulumi.Input['TaskDefinitionLinuxParametersArgsDict']]
        log_configuration: NotRequired[pulumi.Input['TaskDefinitionLogConfigurationArgsDict']]
        memory: NotRequired[pulumi.Input[_builtins.int]]
        """
        The amount (in MiB) of memory to present to the container. If your container attempts to exceed the memory specified here, the container is killed.
        """
        memory_reservation: NotRequired[pulumi.Input[_builtins.int]]
        mount_points: NotRequired[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionMountPointArgsDict']]]]
        port_mappings: NotRequired[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionPortMappingArgsDict']]]]
        """
        Port mappings allow containers to access ports on the host container instance to send or receive traffic.
        """
        privileged: NotRequired[pulumi.Input[_builtins.bool]]
        pseudo_terminal: NotRequired[pulumi.Input[_builtins.bool]]
        readonly_root_filesystem: NotRequired[pulumi.Input[_builtins.bool]]
        repository_credentials: NotRequired[pulumi.Input['TaskDefinitionRepositoryCredentialsArgsDict']]
        resource_requirements: NotRequired[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionResourceRequirementArgsDict']]]]
        secrets: NotRequired[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionSecretArgsDict']]]]
        start_timeout: NotRequired[pulumi.Input[_builtins.int]]
        stop_timeout: NotRequired[pulumi.Input[_builtins.int]]
        system_controls: NotRequired[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionSystemControlArgsDict']]]]
        ulimits: NotRequired[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionUlimitArgsDict']]]]
        user: NotRequired[pulumi.Input[_builtins.str]]
        volumes_from: NotRequired[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionVolumeFromArgsDict']]]]
        working_directory: NotRequired[pulumi.Input[_builtins.str]]
elif False:
    TaskDefinitionContainerDefinitionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TaskDefinitionContainerDefinitionArgs:
    def __init__(__self__, *,
                 image: pulumi.Input[_builtins.str],
                 name: pulumi.Input[_builtins.str],
                 command: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 cpu: Optional[pulumi.Input[_builtins.int]] = None,
                 depends_on: Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionContainerDependencyArgs']]]] = None,
                 disable_networking: Optional[pulumi.Input[_builtins.bool]] = None,
                 dns_search_domains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 docker_labels: Optional[Any] = None,
                 docker_security_options: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 entry_point: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 environment: Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionKeyValuePairArgs']]]] = None,
                 environment_files: Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionEnvironmentFileArgs']]]] = None,
                 essential: Optional[pulumi.Input[_builtins.bool]] = None,
                 extra_hosts: Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionHostEntryArgs']]]] = None,
                 firelens_configuration: Optional[pulumi.Input['TaskDefinitionFirelensConfigurationArgs']] = None,
                 health_check: Optional[pulumi.Input['TaskDefinitionHealthCheckArgs']] = None,
                 hostname: Optional[pulumi.Input[_builtins.str]] = None,
                 interactive: Optional[pulumi.Input[_builtins.bool]] = None,
                 links: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 linux_parameters: Optional[pulumi.Input['TaskDefinitionLinuxParametersArgs']] = None,
                 log_configuration: Optional[pulumi.Input['TaskDefinitionLogConfigurationArgs']] = None,
                 memory: Optional[pulumi.Input[_builtins.int]] = None,
                 memory_reservation: Optional[pulumi.Input[_builtins.int]] = None,
                 mount_points: Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionMountPointArgs']]]] = None,
                 port_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionPortMappingArgs']]]] = None,
                 privileged: Optional[pulumi.Input[_builtins.bool]] = None,
                 pseudo_terminal: Optional[pulumi.Input[_builtins.bool]] = None,
                 readonly_root_filesystem: Optional[pulumi.Input[_builtins.bool]] = None,
                 repository_credentials: Optional[pulumi.Input['TaskDefinitionRepositoryCredentialsArgs']] = None,
                 resource_requirements: Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionResourceRequirementArgs']]]] = None,
                 secrets: Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionSecretArgs']]]] = None,
                 start_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 stop_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 system_controls: Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionSystemControlArgs']]]] = None,
                 ulimits: Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionUlimitArgs']]]] = None,
                 user: Optional[pulumi.Input[_builtins.str]] = None,
                 volumes_from: Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionVolumeFromArgs']]]] = None,
                 working_directory: Optional[pulumi.Input[_builtins.str]] = None):
        """
        List of container definitions that are passed to the Docker daemon on a container instance
        :param pulumi.Input[_builtins.str] image: The image used to start a container. This string is passed directly to the Docker daemon.
        :param pulumi.Input[_builtins.str] name: The name of a container. Up to 255 letters (uppercase and lowercase), numbers, hyphens, and underscores are allowed
        :param pulumi.Input[Sequence[pulumi.Input['TaskDefinitionKeyValuePairArgs']]] environment: The environment variables to pass to a container
        :param pulumi.Input[Sequence[pulumi.Input['TaskDefinitionEnvironmentFileArgs']]] environment_files: The list of one or more files that contain the environment variables to pass to a container
        :param pulumi.Input[_builtins.int] memory: The amount (in MiB) of memory to present to the container. If your container attempts to exceed the memory specified here, the container is killed.
        :param pulumi.Input[Sequence[pulumi.Input['TaskDefinitionPortMappingArgs']]] port_mappings: Port mappings allow containers to access ports on the host container instance to send or receive traffic.
        """
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "name", name)
        if command is not None:
            pulumi.set(__self__, "command", command)
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if depends_on is not None:
            pulumi.set(__self__, "depends_on", depends_on)
        if disable_networking is not None:
            pulumi.set(__self__, "disable_networking", disable_networking)
        if dns_search_domains is not None:
            pulumi.set(__self__, "dns_search_domains", dns_search_domains)
        if dns_servers is not None:
            pulumi.set(__self__, "dns_servers", dns_servers)
        if docker_labels is not None:
            pulumi.set(__self__, "docker_labels", docker_labels)
        if docker_security_options is not None:
            pulumi.set(__self__, "docker_security_options", docker_security_options)
        if entry_point is not None:
            pulumi.set(__self__, "entry_point", entry_point)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if environment_files is not None:
            pulumi.set(__self__, "environment_files", environment_files)
        if essential is not None:
            pulumi.set(__self__, "essential", essential)
        if extra_hosts is not None:
            pulumi.set(__self__, "extra_hosts", extra_hosts)
        if firelens_configuration is not None:
            pulumi.set(__self__, "firelens_configuration", firelens_configuration)
        if health_check is not None:
            pulumi.set(__self__, "health_check", health_check)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if interactive is not None:
            pulumi.set(__self__, "interactive", interactive)
        if links is not None:
            pulumi.set(__self__, "links", links)
        if linux_parameters is not None:
            pulumi.set(__self__, "linux_parameters", linux_parameters)
        if log_configuration is not None:
            pulumi.set(__self__, "log_configuration", log_configuration)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)
        if memory_reservation is not None:
            pulumi.set(__self__, "memory_reservation", memory_reservation)
        if mount_points is not None:
            pulumi.set(__self__, "mount_points", mount_points)
        if port_mappings is not None:
            pulumi.set(__self__, "port_mappings", port_mappings)
        if privileged is not None:
            pulumi.set(__self__, "privileged", privileged)
        if pseudo_terminal is not None:
            pulumi.set(__self__, "pseudo_terminal", pseudo_terminal)
        if readonly_root_filesystem is not None:
            pulumi.set(__self__, "readonly_root_filesystem", readonly_root_filesystem)
        if repository_credentials is not None:
            pulumi.set(__self__, "repository_credentials", repository_credentials)
        if resource_requirements is not None:
            pulumi.set(__self__, "resource_requirements", resource_requirements)
        if secrets is not None:
            pulumi.set(__self__, "secrets", secrets)
        if start_timeout is not None:
            pulumi.set(__self__, "start_timeout", start_timeout)
        if stop_timeout is not None:
            pulumi.set(__self__, "stop_timeout", stop_timeout)
        if system_controls is not None:
            pulumi.set(__self__, "system_controls", system_controls)
        if ulimits is not None:
            pulumi.set(__self__, "ulimits", ulimits)
        if user is not None:
            pulumi.set(__self__, "user", user)
        if volumes_from is not None:
            pulumi.set(__self__, "volumes_from", volumes_from)
        if working_directory is not None:
            pulumi.set(__self__, "working_directory", working_directory)

    @_builtins.property
    @pulumi.getter
    def image(self) -> pulumi.Input[_builtins.str]:
        """
        The image used to start a container. This string is passed directly to the Docker daemon.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "image", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of a container. Up to 255 letters (uppercase and lowercase), numbers, hyphens, and underscores are allowed
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def command(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "command")

    @command.setter
    def command(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "command", value)

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "cpu")

    @cpu.setter
    def cpu(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cpu", value)

    @_builtins.property
    @pulumi.getter(name="dependsOn")
    def depends_on(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionContainerDependencyArgs']]]]:
        return pulumi.get(self, "depends_on")

    @depends_on.setter
    def depends_on(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionContainerDependencyArgs']]]]):
        pulumi.set(self, "depends_on", value)

    @_builtins.property
    @pulumi.getter(name="disableNetworking")
    def disable_networking(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "disable_networking")

    @disable_networking.setter
    def disable_networking(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_networking", value)

    @_builtins.property
    @pulumi.getter(name="dnsSearchDomains")
    def dns_search_domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "dns_search_domains")

    @dns_search_domains.setter
    def dns_search_domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "dns_search_domains", value)

    @_builtins.property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "dns_servers")

    @dns_servers.setter
    def dns_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "dns_servers", value)

    @_builtins.property
    @pulumi.getter(name="dockerLabels")
    def docker_labels(self) -> Optional[Any]:
        return pulumi.get(self, "docker_labels")

    @docker_labels.setter
    def docker_labels(self, value: Optional[Any]):
        pulumi.set(self, "docker_labels", value)

    @_builtins.property
    @pulumi.getter(name="dockerSecurityOptions")
    def docker_security_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "docker_security_options")

    @docker_security_options.setter
    def docker_security_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "docker_security_options", value)

    @_builtins.property
    @pulumi.getter(name="entryPoint")
    def entry_point(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "entry_point")

    @entry_point.setter
    def entry_point(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "entry_point", value)

    @_builtins.property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionKeyValuePairArgs']]]]:
        """
        The environment variables to pass to a container
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionKeyValuePairArgs']]]]):
        pulumi.set(self, "environment", value)

    @_builtins.property
    @pulumi.getter(name="environmentFiles")
    def environment_files(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionEnvironmentFileArgs']]]]:
        """
        The list of one or more files that contain the environment variables to pass to a container
        """
        return pulumi.get(self, "environment_files")

    @environment_files.setter
    def environment_files(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionEnvironmentFileArgs']]]]):
        pulumi.set(self, "environment_files", value)

    @_builtins.property
    @pulumi.getter
    def essential(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "essential")

    @essential.setter
    def essential(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "essential", value)

    @_builtins.property
    @pulumi.getter(name="extraHosts")
    def extra_hosts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionHostEntryArgs']]]]:
        return pulumi.get(self, "extra_hosts")

    @extra_hosts.setter
    def extra_hosts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionHostEntryArgs']]]]):
        pulumi.set(self, "extra_hosts", value)

    @_builtins.property
    @pulumi.getter(name="firelensConfiguration")
    def firelens_configuration(self) -> Optional[pulumi.Input['TaskDefinitionFirelensConfigurationArgs']]:
        return pulumi.get(self, "firelens_configuration")

    @firelens_configuration.setter
    def firelens_configuration(self, value: Optional[pulumi.Input['TaskDefinitionFirelensConfigurationArgs']]):
        pulumi.set(self, "firelens_configuration", value)

    @_builtins.property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> Optional[pulumi.Input['TaskDefinitionHealthCheckArgs']]:
        return pulumi.get(self, "health_check")

    @health_check.setter
    def health_check(self, value: Optional[pulumi.Input['TaskDefinitionHealthCheckArgs']]):
        pulumi.set(self, "health_check", value)

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hostname", value)

    @_builtins.property
    @pulumi.getter
    def interactive(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "interactive")

    @interactive.setter
    def interactive(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "interactive", value)

    @_builtins.property
    @pulumi.getter
    def links(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "links")

    @links.setter
    def links(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "links", value)

    @_builtins.property
    @pulumi.getter(name="linuxParameters")
    def linux_parameters(self) -> Optional[pulumi.Input['TaskDefinitionLinuxParametersArgs']]:
        return pulumi.get(self, "linux_parameters")

    @linux_parameters.setter
    def linux_parameters(self, value: Optional[pulumi.Input['TaskDefinitionLinuxParametersArgs']]):
        pulumi.set(self, "linux_parameters", value)

    @_builtins.property
    @pulumi.getter(name="logConfiguration")
    def log_configuration(self) -> Optional[pulumi.Input['TaskDefinitionLogConfigurationArgs']]:
        return pulumi.get(self, "log_configuration")

    @log_configuration.setter
    def log_configuration(self, value: Optional[pulumi.Input['TaskDefinitionLogConfigurationArgs']]):
        pulumi.set(self, "log_configuration", value)

    @_builtins.property
    @pulumi.getter
    def memory(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount (in MiB) of memory to present to the container. If your container attempts to exceed the memory specified here, the container is killed.
        """
        return pulumi.get(self, "memory")

    @memory.setter
    def memory(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "memory", value)

    @_builtins.property
    @pulumi.getter(name="memoryReservation")
    def memory_reservation(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "memory_reservation")

    @memory_reservation.setter
    def memory_reservation(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "memory_reservation", value)

    @_builtins.property
    @pulumi.getter(name="mountPoints")
    def mount_points(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionMountPointArgs']]]]:
        return pulumi.get(self, "mount_points")

    @mount_points.setter
    def mount_points(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionMountPointArgs']]]]):
        pulumi.set(self, "mount_points", value)

    @_builtins.property
    @pulumi.getter(name="portMappings")
    def port_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionPortMappingArgs']]]]:
        """
        Port mappings allow containers to access ports on the host container instance to send or receive traffic.
        """
        return pulumi.get(self, "port_mappings")

    @port_mappings.setter
    def port_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionPortMappingArgs']]]]):
        pulumi.set(self, "port_mappings", value)

    @_builtins.property
    @pulumi.getter
    def privileged(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "privileged")

    @privileged.setter
    def privileged(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "privileged", value)

    @_builtins.property
    @pulumi.getter(name="pseudoTerminal")
    def pseudo_terminal(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "pseudo_terminal")

    @pseudo_terminal.setter
    def pseudo_terminal(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "pseudo_terminal", value)

    @_builtins.property
    @pulumi.getter(name="readonlyRootFilesystem")
    def readonly_root_filesystem(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "readonly_root_filesystem")

    @readonly_root_filesystem.setter
    def readonly_root_filesystem(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "readonly_root_filesystem", value)

    @_builtins.property
    @pulumi.getter(name="repositoryCredentials")
    def repository_credentials(self) -> Optional[pulumi.Input['TaskDefinitionRepositoryCredentialsArgs']]:
        return pulumi.get(self, "repository_credentials")

    @repository_credentials.setter
    def repository_credentials(self, value: Optional[pulumi.Input['TaskDefinitionRepositoryCredentialsArgs']]):
        pulumi.set(self, "repository_credentials", value)

    @_builtins.property
    @pulumi.getter(name="resourceRequirements")
    def resource_requirements(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionResourceRequirementArgs']]]]:
        return pulumi.get(self, "resource_requirements")

    @resource_requirements.setter
    def resource_requirements(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionResourceRequirementArgs']]]]):
        pulumi.set(self, "resource_requirements", value)

    @_builtins.property
    @pulumi.getter
    def secrets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionSecretArgs']]]]:
        return pulumi.get(self, "secrets")

    @secrets.setter
    def secrets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionSecretArgs']]]]):
        pulumi.set(self, "secrets", value)

    @_builtins.property
    @pulumi.getter(name="startTimeout")
    def start_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "start_timeout")

    @start_timeout.setter
    def start_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "start_timeout", value)

    @_builtins.property
    @pulumi.getter(name="stopTimeout")
    def stop_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "stop_timeout")

    @stop_timeout.setter
    def stop_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "stop_timeout", value)

    @_builtins.property
    @pulumi.getter(name="systemControls")
    def system_controls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionSystemControlArgs']]]]:
        return pulumi.get(self, "system_controls")

    @system_controls.setter
    def system_controls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionSystemControlArgs']]]]):
        pulumi.set(self, "system_controls", value)

    @_builtins.property
    @pulumi.getter
    def ulimits(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionUlimitArgs']]]]:
        return pulumi.get(self, "ulimits")

    @ulimits.setter
    def ulimits(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionUlimitArgs']]]]):
        pulumi.set(self, "ulimits", value)

    @_builtins.property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user", value)

    @_builtins.property
    @pulumi.getter(name="volumesFrom")
    def volumes_from(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionVolumeFromArgs']]]]:
        return pulumi.get(self, "volumes_from")

    @volumes_from.setter
    def volumes_from(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionVolumeFromArgs']]]]):
        pulumi.set(self, "volumes_from", value)

    @_builtins.property
    @pulumi.getter(name="workingDirectory")
    def working_directory(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "working_directory")

    @working_directory.setter
    def working_directory(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "working_directory", value)


if not MYPY:
    class TaskDefinitionContainerDependencyArgsDict(TypedDict):
        condition: NotRequired[pulumi.Input[_builtins.str]]
        container_name: NotRequired[pulumi.Input[_builtins.str]]
elif False:
    TaskDefinitionContainerDependencyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TaskDefinitionContainerDependencyArgs:
    def __init__(__self__, *,
                 condition: Optional[pulumi.Input[_builtins.str]] = None,
                 container_name: Optional[pulumi.Input[_builtins.str]] = None):
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)

    @_builtins.property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "condition", value)

    @_builtins.property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "container_name")

    @container_name.setter
    def container_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "container_name", value)


if not MYPY:
    class TaskDefinitionDeviceArgsDict(TypedDict):
        container_path: NotRequired[pulumi.Input[_builtins.str]]
        host_path: NotRequired[pulumi.Input[_builtins.str]]
        permissions: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
elif False:
    TaskDefinitionDeviceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TaskDefinitionDeviceArgs:
    def __init__(__self__, *,
                 container_path: Optional[pulumi.Input[_builtins.str]] = None,
                 host_path: Optional[pulumi.Input[_builtins.str]] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        if container_path is not None:
            pulumi.set(__self__, "container_path", container_path)
        if host_path is not None:
            pulumi.set(__self__, "host_path", host_path)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)

    @_builtins.property
    @pulumi.getter(name="containerPath")
    def container_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "container_path")

    @container_path.setter
    def container_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "container_path", value)

    @_builtins.property
    @pulumi.getter(name="hostPath")
    def host_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "host_path")

    @host_path.setter
    def host_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_path", value)

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "permissions", value)


if not MYPY:
    class TaskDefinitionEnvironmentFileArgsDict(TypedDict):
        type: NotRequired[pulumi.Input[_builtins.str]]
        value: NotRequired[pulumi.Input[_builtins.str]]
elif False:
    TaskDefinitionEnvironmentFileArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TaskDefinitionEnvironmentFileArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None):
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "value", value)


if not MYPY:
    class TaskDefinitionFirelensConfigurationArgsDict(TypedDict):
        options: NotRequired[Any]
        type: NotRequired[pulumi.Input[_builtins.str]]
elif False:
    TaskDefinitionFirelensConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TaskDefinitionFirelensConfigurationArgs:
    def __init__(__self__, *,
                 options: Optional[Any] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        if options is not None:
            pulumi.set(__self__, "options", options)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def options(self) -> Optional[Any]:
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[Any]):
        pulumi.set(self, "options", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


if not MYPY:
    class TaskDefinitionHealthCheckArgsDict(TypedDict):
        """
        The health check command and associated configuration parameters for the container.
        """
        command: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        A string array representing the command that the container runs to determine if it is healthy.
        """
        interval: NotRequired[pulumi.Input[_builtins.int]]
        """
        The time period in seconds between each health check execution. You may specify between 5 and 300 seconds. The default value is 30 seconds.
        """
        retries: NotRequired[pulumi.Input[_builtins.int]]
        """
        The number of times to retry a failed health check before the container is considered unhealthy. You may specify between 1 and 10 retries. The default value is three retries.
        """
        start_period: NotRequired[pulumi.Input[_builtins.int]]
        """
        The optional grace period within which to provide containers time to bootstrap before failed health checks count towards the maximum number of retries. You may specify between 0 and 300 seconds. The startPeriod is disabled by default.
        """
        timeout: NotRequired[pulumi.Input[_builtins.int]]
        """
        The time period in seconds to wait for a health check to succeed before it is considered a failure. You may specify between 2 and 60 seconds. The default value is 5 seconds.
        """
elif False:
    TaskDefinitionHealthCheckArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TaskDefinitionHealthCheckArgs:
    def __init__(__self__, *,
                 command: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 interval: Optional[pulumi.Input[_builtins.int]] = None,
                 retries: Optional[pulumi.Input[_builtins.int]] = None,
                 start_period: Optional[pulumi.Input[_builtins.int]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The health check command and associated configuration parameters for the container.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] command: A string array representing the command that the container runs to determine if it is healthy.
        :param pulumi.Input[_builtins.int] interval: The time period in seconds between each health check execution. You may specify between 5 and 300 seconds. The default value is 30 seconds.
        :param pulumi.Input[_builtins.int] retries: The number of times to retry a failed health check before the container is considered unhealthy. You may specify between 1 and 10 retries. The default value is three retries.
        :param pulumi.Input[_builtins.int] start_period: The optional grace period within which to provide containers time to bootstrap before failed health checks count towards the maximum number of retries. You may specify between 0 and 300 seconds. The startPeriod is disabled by default.
        :param pulumi.Input[_builtins.int] timeout: The time period in seconds to wait for a health check to succeed before it is considered a failure. You may specify between 2 and 60 seconds. The default value is 5 seconds.
        """
        if command is not None:
            pulumi.set(__self__, "command", command)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if retries is not None:
            pulumi.set(__self__, "retries", retries)
        if start_period is not None:
            pulumi.set(__self__, "start_period", start_period)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @_builtins.property
    @pulumi.getter
    def command(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A string array representing the command that the container runs to determine if it is healthy.
        """
        return pulumi.get(self, "command")

    @command.setter
    def command(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "command", value)

    @_builtins.property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The time period in seconds between each health check execution. You may specify between 5 and 300 seconds. The default value is 30 seconds.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "interval", value)

    @_builtins.property
    @pulumi.getter
    def retries(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of times to retry a failed health check before the container is considered unhealthy. You may specify between 1 and 10 retries. The default value is three retries.
        """
        return pulumi.get(self, "retries")

    @retries.setter
    def retries(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "retries", value)

    @_builtins.property
    @pulumi.getter(name="startPeriod")
    def start_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The optional grace period within which to provide containers time to bootstrap before failed health checks count towards the maximum number of retries. You may specify between 0 and 300 seconds. The startPeriod is disabled by default.
        """
        return pulumi.get(self, "start_period")

    @start_period.setter
    def start_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "start_period", value)

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The time period in seconds to wait for a health check to succeed before it is considered a failure. You may specify between 2 and 60 seconds. The default value is 5 seconds.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout", value)


if not MYPY:
    class TaskDefinitionHostEntryArgsDict(TypedDict):
        hostname: NotRequired[pulumi.Input[_builtins.str]]
        ip_address: NotRequired[pulumi.Input[_builtins.str]]
elif False:
    TaskDefinitionHostEntryArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TaskDefinitionHostEntryArgs:
    def __init__(__self__, *,
                 hostname: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_address: Optional[pulumi.Input[_builtins.str]] = None):
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hostname", value)

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_address", value)


if not MYPY:
    class TaskDefinitionKernelCapabilitiesArgsDict(TypedDict):
        add: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        drop: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
elif False:
    TaskDefinitionKernelCapabilitiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TaskDefinitionKernelCapabilitiesArgs:
    def __init__(__self__, *,
                 add: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 drop: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        if add is not None:
            pulumi.set(__self__, "add", add)
        if drop is not None:
            pulumi.set(__self__, "drop", drop)

    @_builtins.property
    @pulumi.getter
    def add(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "add")

    @add.setter
    def add(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "add", value)

    @_builtins.property
    @pulumi.getter
    def drop(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "drop")

    @drop.setter
    def drop(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "drop", value)


if not MYPY:
    class TaskDefinitionKeyValuePairArgsDict(TypedDict):
        name: NotRequired[pulumi.Input[_builtins.str]]
        value: NotRequired[pulumi.Input[_builtins.str]]
elif False:
    TaskDefinitionKeyValuePairArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TaskDefinitionKeyValuePairArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None):
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "value", value)


if not MYPY:
    class TaskDefinitionLinuxParametersArgsDict(TypedDict):
        capabilities: NotRequired[pulumi.Input['TaskDefinitionKernelCapabilitiesArgsDict']]
        devices: NotRequired[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionDeviceArgsDict']]]]
        init_process_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        max_swap: NotRequired[pulumi.Input[_builtins.int]]
        shared_memory_size: NotRequired[pulumi.Input[_builtins.int]]
        swappiness: NotRequired[pulumi.Input[_builtins.int]]
        tmpfs: NotRequired[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionTmpfsArgsDict']]]]
elif False:
    TaskDefinitionLinuxParametersArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TaskDefinitionLinuxParametersArgs:
    def __init__(__self__, *,
                 capabilities: Optional[pulumi.Input['TaskDefinitionKernelCapabilitiesArgs']] = None,
                 devices: Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionDeviceArgs']]]] = None,
                 init_process_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_swap: Optional[pulumi.Input[_builtins.int]] = None,
                 shared_memory_size: Optional[pulumi.Input[_builtins.int]] = None,
                 swappiness: Optional[pulumi.Input[_builtins.int]] = None,
                 tmpfs: Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionTmpfsArgs']]]] = None):
        if capabilities is not None:
            pulumi.set(__self__, "capabilities", capabilities)
        if devices is not None:
            pulumi.set(__self__, "devices", devices)
        if init_process_enabled is not None:
            pulumi.set(__self__, "init_process_enabled", init_process_enabled)
        if max_swap is not None:
            pulumi.set(__self__, "max_swap", max_swap)
        if shared_memory_size is not None:
            pulumi.set(__self__, "shared_memory_size", shared_memory_size)
        if swappiness is not None:
            pulumi.set(__self__, "swappiness", swappiness)
        if tmpfs is not None:
            pulumi.set(__self__, "tmpfs", tmpfs)

    @_builtins.property
    @pulumi.getter
    def capabilities(self) -> Optional[pulumi.Input['TaskDefinitionKernelCapabilitiesArgs']]:
        return pulumi.get(self, "capabilities")

    @capabilities.setter
    def capabilities(self, value: Optional[pulumi.Input['TaskDefinitionKernelCapabilitiesArgs']]):
        pulumi.set(self, "capabilities", value)

    @_builtins.property
    @pulumi.getter
    def devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionDeviceArgs']]]]:
        return pulumi.get(self, "devices")

    @devices.setter
    def devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionDeviceArgs']]]]):
        pulumi.set(self, "devices", value)

    @_builtins.property
    @pulumi.getter(name="initProcessEnabled")
    def init_process_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "init_process_enabled")

    @init_process_enabled.setter
    def init_process_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "init_process_enabled", value)

    @_builtins.property
    @pulumi.getter(name="maxSwap")
    def max_swap(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "max_swap")

    @max_swap.setter
    def max_swap(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_swap", value)

    @_builtins.property
    @pulumi.getter(name="sharedMemorySize")
    def shared_memory_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "shared_memory_size")

    @shared_memory_size.setter
    def shared_memory_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "shared_memory_size", value)

    @_builtins.property
    @pulumi.getter
    def swappiness(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "swappiness")

    @swappiness.setter
    def swappiness(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "swappiness", value)

    @_builtins.property
    @pulumi.getter
    def tmpfs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionTmpfsArgs']]]]:
        return pulumi.get(self, "tmpfs")

    @tmpfs.setter
    def tmpfs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionTmpfsArgs']]]]):
        pulumi.set(self, "tmpfs", value)


if not MYPY:
    class TaskDefinitionLogConfigurationArgsDict(TypedDict):
        log_driver: pulumi.Input[_builtins.str]
        options: NotRequired[Any]
        secret_options: NotRequired[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionSecretArgsDict']]]]
elif False:
    TaskDefinitionLogConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TaskDefinitionLogConfigurationArgs:
    def __init__(__self__, *,
                 log_driver: pulumi.Input[_builtins.str],
                 options: Optional[Any] = None,
                 secret_options: Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionSecretArgs']]]] = None):
        pulumi.set(__self__, "log_driver", log_driver)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if secret_options is not None:
            pulumi.set(__self__, "secret_options", secret_options)

    @_builtins.property
    @pulumi.getter(name="logDriver")
    def log_driver(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "log_driver")

    @log_driver.setter
    def log_driver(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "log_driver", value)

    @_builtins.property
    @pulumi.getter
    def options(self) -> Optional[Any]:
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[Any]):
        pulumi.set(self, "options", value)

    @_builtins.property
    @pulumi.getter(name="secretOptions")
    def secret_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionSecretArgs']]]]:
        return pulumi.get(self, "secret_options")

    @secret_options.setter
    def secret_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionSecretArgs']]]]):
        pulumi.set(self, "secret_options", value)


if not MYPY:
    class TaskDefinitionMountPointArgsDict(TypedDict):
        container_path: NotRequired[pulumi.Input[_builtins.str]]
        read_only: NotRequired[pulumi.Input[_builtins.bool]]
        source_volume: NotRequired[pulumi.Input[_builtins.str]]
elif False:
    TaskDefinitionMountPointArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TaskDefinitionMountPointArgs:
    def __init__(__self__, *,
                 container_path: Optional[pulumi.Input[_builtins.str]] = None,
                 read_only: Optional[pulumi.Input[_builtins.bool]] = None,
                 source_volume: Optional[pulumi.Input[_builtins.str]] = None):
        if container_path is not None:
            pulumi.set(__self__, "container_path", container_path)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if source_volume is not None:
            pulumi.set(__self__, "source_volume", source_volume)

    @_builtins.property
    @pulumi.getter(name="containerPath")
    def container_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "container_path")

    @container_path.setter
    def container_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "container_path", value)

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "read_only", value)

    @_builtins.property
    @pulumi.getter(name="sourceVolume")
    def source_volume(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "source_volume")

    @source_volume.setter
    def source_volume(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_volume", value)


if not MYPY:
    class TaskDefinitionPortMappingArgsDict(TypedDict):
        app_protocol: NotRequired[pulumi.Input['TaskDefinitionPortMappingAppProtocol']]
        container_port: NotRequired[pulumi.Input[_builtins.int]]
        container_port_range: NotRequired[pulumi.Input[_builtins.str]]
        host_port: NotRequired[pulumi.Input[_builtins.int]]
        name: NotRequired[pulumi.Input[_builtins.str]]
        protocol: NotRequired[pulumi.Input[_builtins.str]]
        target_group: NotRequired[pulumi.Input['pulumi_aws.lb.TargetGroup']]
elif False:
    TaskDefinitionPortMappingArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TaskDefinitionPortMappingArgs:
    def __init__(__self__, *,
                 app_protocol: Optional[pulumi.Input['TaskDefinitionPortMappingAppProtocol']] = None,
                 container_port: Optional[pulumi.Input[_builtins.int]] = None,
                 container_port_range: Optional[pulumi.Input[_builtins.str]] = None,
                 host_port: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 target_group: Optional[pulumi.Input['pulumi_aws.lb.TargetGroup']] = None):
        if app_protocol is not None:
            pulumi.set(__self__, "app_protocol", app_protocol)
        if container_port is not None:
            pulumi.set(__self__, "container_port", container_port)
        if container_port_range is not None:
            pulumi.set(__self__, "container_port_range", container_port_range)
        if host_port is not None:
            pulumi.set(__self__, "host_port", host_port)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if target_group is not None:
            pulumi.set(__self__, "target_group", target_group)

    @_builtins.property
    @pulumi.getter(name="appProtocol")
    def app_protocol(self) -> Optional[pulumi.Input['TaskDefinitionPortMappingAppProtocol']]:
        return pulumi.get(self, "app_protocol")

    @app_protocol.setter
    def app_protocol(self, value: Optional[pulumi.Input['TaskDefinitionPortMappingAppProtocol']]):
        pulumi.set(self, "app_protocol", value)

    @_builtins.property
    @pulumi.getter(name="containerPort")
    def container_port(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "container_port")

    @container_port.setter
    def container_port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "container_port", value)

    @_builtins.property
    @pulumi.getter(name="containerPortRange")
    def container_port_range(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "container_port_range")

    @container_port_range.setter
    def container_port_range(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "container_port_range", value)

    @_builtins.property
    @pulumi.getter(name="hostPort")
    def host_port(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "host_port")

    @host_port.setter
    def host_port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "host_port", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter(name="targetGroup")
    def target_group(self) -> Optional[pulumi.Input['pulumi_aws.lb.TargetGroup']]:
        return pulumi.get(self, "target_group")

    @target_group.setter
    def target_group(self, value: Optional[pulumi.Input['pulumi_aws.lb.TargetGroup']]):
        pulumi.set(self, "target_group", value)


if not MYPY:
    class TaskDefinitionRepositoryCredentialsArgsDict(TypedDict):
        credentials_parameter: NotRequired[pulumi.Input[_builtins.str]]
elif False:
    TaskDefinitionRepositoryCredentialsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TaskDefinitionRepositoryCredentialsArgs:
    def __init__(__self__, *,
                 credentials_parameter: Optional[pulumi.Input[_builtins.str]] = None):
        if credentials_parameter is not None:
            pulumi.set(__self__, "credentials_parameter", credentials_parameter)

    @_builtins.property
    @pulumi.getter(name="credentialsParameter")
    def credentials_parameter(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "credentials_parameter")

    @credentials_parameter.setter
    def credentials_parameter(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "credentials_parameter", value)


if not MYPY:
    class TaskDefinitionResourceRequirementArgsDict(TypedDict):
        type: pulumi.Input[_builtins.str]
        value: pulumi.Input[_builtins.str]
elif False:
    TaskDefinitionResourceRequirementArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TaskDefinitionResourceRequirementArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[_builtins.str],
                 value: pulumi.Input[_builtins.str]):
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class TaskDefinitionSecretArgsDict(TypedDict):
        name: pulumi.Input[_builtins.str]
        value_from: pulumi.Input[_builtins.str]
elif False:
    TaskDefinitionSecretArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TaskDefinitionSecretArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 value_from: pulumi.Input[_builtins.str]):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value_from", value_from)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="valueFrom")
    def value_from(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "value_from")

    @value_from.setter
    def value_from(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "value_from", value)


if not MYPY:
    class TaskDefinitionSystemControlArgsDict(TypedDict):
        namespace: NotRequired[pulumi.Input[_builtins.str]]
        value: NotRequired[pulumi.Input[_builtins.str]]
elif False:
    TaskDefinitionSystemControlArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TaskDefinitionSystemControlArgs:
    def __init__(__self__, *,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None):
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "value", value)


if not MYPY:
    class TaskDefinitionTmpfsArgsDict(TypedDict):
        size: pulumi.Input[_builtins.int]
        container_path: NotRequired[pulumi.Input[_builtins.str]]
        mount_options: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
elif False:
    TaskDefinitionTmpfsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TaskDefinitionTmpfsArgs:
    def __init__(__self__, *,
                 size: pulumi.Input[_builtins.int],
                 container_path: Optional[pulumi.Input[_builtins.str]] = None,
                 mount_options: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        pulumi.set(__self__, "size", size)
        if container_path is not None:
            pulumi.set(__self__, "container_path", container_path)
        if mount_options is not None:
            pulumi.set(__self__, "mount_options", mount_options)

    @_builtins.property
    @pulumi.getter
    def size(self) -> pulumi.Input[_builtins.int]:
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "size", value)

    @_builtins.property
    @pulumi.getter(name="containerPath")
    def container_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "container_path")

    @container_path.setter
    def container_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "container_path", value)

    @_builtins.property
    @pulumi.getter(name="mountOptions")
    def mount_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "mount_options")

    @mount_options.setter
    def mount_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "mount_options", value)


if not MYPY:
    class TaskDefinitionUlimitArgsDict(TypedDict):
        hard_limit: pulumi.Input[_builtins.int]
        name: pulumi.Input[_builtins.str]
        soft_limit: pulumi.Input[_builtins.int]
elif False:
    TaskDefinitionUlimitArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TaskDefinitionUlimitArgs:
    def __init__(__self__, *,
                 hard_limit: pulumi.Input[_builtins.int],
                 name: pulumi.Input[_builtins.str],
                 soft_limit: pulumi.Input[_builtins.int]):
        pulumi.set(__self__, "hard_limit", hard_limit)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "soft_limit", soft_limit)

    @_builtins.property
    @pulumi.getter(name="hardLimit")
    def hard_limit(self) -> pulumi.Input[_builtins.int]:
        return pulumi.get(self, "hard_limit")

    @hard_limit.setter
    def hard_limit(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "hard_limit", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="softLimit")
    def soft_limit(self) -> pulumi.Input[_builtins.int]:
        return pulumi.get(self, "soft_limit")

    @soft_limit.setter
    def soft_limit(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "soft_limit", value)


if not MYPY:
    class TaskDefinitionVolumeFromArgsDict(TypedDict):
        read_only: NotRequired[pulumi.Input[_builtins.bool]]
        source_container: NotRequired[pulumi.Input[_builtins.str]]
elif False:
    TaskDefinitionVolumeFromArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TaskDefinitionVolumeFromArgs:
    def __init__(__self__, *,
                 read_only: Optional[pulumi.Input[_builtins.bool]] = None,
                 source_container: Optional[pulumi.Input[_builtins.str]] = None):
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if source_container is not None:
            pulumi.set(__self__, "source_container", source_container)

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "read_only", value)

    @_builtins.property
    @pulumi.getter(name="sourceContainer")
    def source_container(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "source_container")

    @source_container.setter
    def source_container(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_container", value)


