# EduLinq Python Utilities

Common utilities used by EduLinq Python projects.

## Installation / Requirements

This project requires [Python](https://www.python.org/) >= 3.8.

The project can be installed from PyPi with:
```
pip3 install edq-utils
```

Standard Python requirements are listed in `pyproject.toml`.
The project and Python dependencies can be installed from source with:
```
pip3 install .
```

## Configuration System

This project provides a configuration system that supplies options (e.g., username, password) to a command-line interface (CLI) tool.
The configuration system follows a tiered order, allowing options to be specified and overridden from both files and command-line options.

### Configuration Sources

In addition to CLI options, the configuration system loads options from [JSON](https://en.wikipedia.org/wiki/JSON) files located across multiple directories.
By default, configuration files are named `edq-config.json`.
This value is customizable, but this document will assume the default is used.

For example, a configuration file containing the `user` and `pass` options might look like this:
```json
{
    "user": "alice",
    "pass": "password123"
}
```

The table below summarizes the configuration sources in the order they are evaluated.
Values from earlier sources can be overwritten by values from later sources.

| Source   | Description |
| :-----   | :---------- |
| Global   | Loaded from a file in a user-specific location, which is platform-dependent. |
| Local    | Loaded from a file in the current or nearest ancestor directory. |
| CLI File | Loaded from one or more explicitly provided configuration files through the CLI. |
| CLI      | Loaded from the command line. |

The system produces an error if a global or local configuration file is unreadable (but not missing), or if a CLI-specified file is unreadable or missing.

#### Global Configuration

Global configuration are options that are user specific and stick with the user between projects, these are well suited for options like login credentials.
The global configuration file defaults to `<platform-specific user configuration location>/edq-config.json`.
The configuration location is chosen according to the [XDG standard](https://en.wikipedia.org/wiki/Freedesktop.org#Base_Directory_Specification) (implemented by [platformdirs](https://github.com/tox-dev/platformdirs)).
Below are examples of user-specific configuration file paths for different operating systems:
 - Linux -- `/home/<user>/.config/edq-config.json`
 - Mac -- `/Users/<user>/Library/Application Support/edq-config.json`
 - Windows -- `C:\Users\<user>\AppData\Local\edq-config.json`

The default global configuration location can be changed by passing a path to `--config-global` through the command line.

Below is an example command for specifying a global configuration path from the CLI:
```sh
python3 -m edq.cli.config.list --config-global  ~/.config/custom-config.json
```

#### Local Configuration

Local configuration are options that are specific to a project or directory, like a project's build directory.
Local configuration files are searched in multiple locations, the first file found is used.
The local config search order is:
1. `edq-config.json` in the current directory.
2. A legacy file in the current directory (only if a legacy file is preconfigured).
3. `edq-config.json` in any ancestor directory on the path to root (including root itself).

#### CLI-Specified Config Files

CLI config files are options specified on the command line via a file.
These are useful for a common set of options you don’t need every time, such as login credentials for different user.
Any files passed via `--config-file` will be loaded in the order they appear on the command line.
Options from later files override options from previous files.

Below is an example of a CLI specified configuration paths:
```sh
python3 -m edq.cli.config.list --config-file ./edq-config.json --config-file ~/.secrets/edq-config.json
```

#### CLI Configuration

CLI configurations are options specified directly on the command line, these are useful for quick option overrides without editing config files.
Configuration options are passed to the command line by the `--config` flag in this format `<key>=<value>`.
The provided values overrides the values from configuration files.
Configuration options are structured as key value pairs and keys cannot contain the "=" character.

Below is an example of specifying a configuration option directly from the CLI:
```sh
python3 -m edq.cli.config.list --config user=alice --config pass=password123
```

#### CLI Config Options

The table below lists common configuration CLI options available for CLI tools using this library.

| CLI Option       | Description |
| :--------------  | :---------- |
|`--config-global` | Override the global config file location. |
|`--config-file`   | Load configuration options from a CLI specified file. |
| `--config`       | Provide additional options to a CLI command. |
| `--help`         | Display standard help text and the default global configuration file path for the current platform. |
