# emacs: -*- mode: python; py-indent-offset: 4; indent-tabs-mode: nil -*-
# vi: set ft=python sts=4 ts=4 sw=4 et:
#
# Copyright 2021 The NiPreps Developers <nipreps@gmail.com>
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# We support and encourage derived works from this project, please read
# about our expectations at
#
#     https://www.nipreps.org/community/licensing/
#
"""
These pipelines are developed by the Poldrack lab at Stanford University
(https://nipreps.stanford.edu/) for use at
the Center for Reproducible Neuroscience (http://reproducibility.stanford.edu/),
as well as for open-source software distribution.
"""
from datetime import datetime
from . import _version
__version__ = _version.get_versions()['version']

__packagename__ = "niworkflows"
__copyright__ = "Copyright {}, The NiPreps Developers".format(
    datetime.now().year
)
__credits__ = [
    "Oscar Esteban",
    "Ross Blair",
    "Shoshana L. Berleant",
    "Christopher J. Markiewicz",
    "Chris Gorgolewski",
    "Russell A. Poldrack",
]
