# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import utilities, tables

class Datacenter(pulumi.CustomResource):
    custom_attributes: pulumi.Output[dict]
    """
    Map of custom attribute ids to value 
    strings to set for datacenter resource. See
    [here][docs-setting-custom-attributes] for a reference on how to set values
    for custom attributes.
    """
    folder: pulumi.Output[str]
    """
    The folder where the datacenter should be created.
    Forces a new resource if changed.
    """
    moid: pulumi.Output[str]
    """
    Managed object ID of this datacenter.
    """
    name: pulumi.Output[str]
    """
    The name of the datacenter. This name needs to be unique
    within the folder. Forces a new resource if changed.
    """
    tags: pulumi.Output[list]
    """
    The IDs of any tags to attach to this resource.
    """
    def __init__(__self__, resource_name, opts=None, custom_attributes=None, folder=None, name=None, tags=None, __props__=None, __name__=None, __opts__=None):
        """
        Provides a VMware vSphere datacenter resource. This can be used as the primary
        container of inventory objects such as hosts and virtual machines.

        ## Example Usage

        ### Create datacenter on the root folder

        ```python
        import pulumi
        import pulumi_vsphere as vsphere

        prod_datacenter = vsphere.Datacenter("prodDatacenter")
        ```

        ### Create datacenter on a subfolder

        ```python
        import pulumi
        import pulumi_vsphere as vsphere

        research_datacenter = vsphere.Datacenter("researchDatacenter", folder="/research/")
        ```


        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[dict] custom_attributes: Map of custom attribute ids to value 
               strings to set for datacenter resource. See
               [here][docs-setting-custom-attributes] for a reference on how to set values
               for custom attributes.
        :param pulumi.Input[str] folder: The folder where the datacenter should be created.
               Forces a new resource if changed.
        :param pulumi.Input[str] name: The name of the datacenter. This name needs to be unique
               within the folder. Forces a new resource if changed.
        :param pulumi.Input[list] tags: The IDs of any tags to attach to this resource.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['custom_attributes'] = custom_attributes
            __props__['folder'] = folder
            __props__['name'] = name
            __props__['tags'] = tags
            __props__['moid'] = None
        super(Datacenter, __self__).__init__(
            'vsphere:index/datacenter:Datacenter',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, custom_attributes=None, folder=None, moid=None, name=None, tags=None):
        """
        Get an existing Datacenter resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[dict] custom_attributes: Map of custom attribute ids to value 
               strings to set for datacenter resource. See
               [here][docs-setting-custom-attributes] for a reference on how to set values
               for custom attributes.
        :param pulumi.Input[str] folder: The folder where the datacenter should be created.
               Forces a new resource if changed.
        :param pulumi.Input[str] moid: Managed object ID of this datacenter.
        :param pulumi.Input[str] name: The name of the datacenter. This name needs to be unique
               within the folder. Forces a new resource if changed.
        :param pulumi.Input[list] tags: The IDs of any tags to attach to this resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["custom_attributes"] = custom_attributes
        __props__["folder"] = folder
        __props__["moid"] = moid
        __props__["name"] = name
        __props__["tags"] = tags
        return Datacenter(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

