# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import utilities, tables

class GetResourcePoolResult:
    """
    A collection of values returned by getResourcePool.
    """
    def __init__(__self__, datacenter_id=None, id=None, name=None):
        if datacenter_id and not isinstance(datacenter_id, str):
            raise TypeError("Expected argument 'datacenter_id' to be a str")
        __self__.datacenter_id = datacenter_id
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        __self__.id = id
        """
        The provider-assigned unique ID for this managed resource.
        """
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        __self__.name = name
class AwaitableGetResourcePoolResult(GetResourcePoolResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetResourcePoolResult(
            datacenter_id=self.datacenter_id,
            id=self.id,
            name=self.name)

def get_resource_pool(datacenter_id=None,name=None,opts=None):
    """
    The `.ResourcePool` data source can be used to discover the ID of a
    resource pool in vSphere. This is useful to fetch the ID of a resource pool
    that you want to use to create virtual machines in using the
    `.VirtualMachine` resource. 

    ## Example Usage



    ```python
    import pulumi
    import pulumi_vsphere as vsphere

    datacenter = vsphere.get_datacenter(name="dc1")
    pool = vsphere.get_resource_pool(datacenter_id=datacenter.id,
        name="resource-pool-1")
    ```

    ### Specifying the root resource pool for a standalone host

    ```python
    import pulumi
    import pulumi_vsphere as vsphere

    pool = vsphere.get_resource_pool(datacenter_id=data[".Datacenter"]["dc"]["id"],
        name="esxi1/Resources")
    ```



    :param str datacenter_id: The managed object reference
           ID of the datacenter the resource pool is located in.
           This can be omitted if the search path used in `name` is an absolute path.
           For default datacenters, use the id attribute from an empty
           `.Datacenter` data source.
    :param str name: The name of the resource pool. This can be a name or
           path. This is required when using vCenter.
    """
    __args__ = dict()


    __args__['datacenterId'] = datacenter_id
    __args__['name'] = name
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = utilities.get_version()
    __ret__ = pulumi.runtime.invoke('vsphere:index/getResourcePool:getResourcePool', __args__, opts=opts).value

    return AwaitableGetResourcePoolResult(
        datacenter_id=__ret__.get('datacenterId'),
        id=__ret__.get('id'),
        name=__ret__.get('name'))
