# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import utilities, tables

class Provider(pulumi.ProviderResource):
    def __init__(__self__, resource_name, opts=None, allow_unverified_ssl=None, client_debug=None, client_debug_path=None, client_debug_path_run=None, password=None, persist_session=None, rest_session_path=None, user=None, vcenter_server=None, vim_keep_alive=None, vim_session_path=None, vsphere_server=None, __props__=None, __name__=None, __opts__=None):
        """
        The provider type for the vsphere package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] allow_unverified_ssl: If set, VMware vSphere client will permit unverifiable SSL certificates.
        :param pulumi.Input[bool] client_debug: govmomi debug
        :param pulumi.Input[str] client_debug_path: govmomi debug path for debug
        :param pulumi.Input[str] client_debug_path_run: govmomi debug path for a single run
        :param pulumi.Input[str] password: The user password for vSphere API operations.
        :param pulumi.Input[bool] persist_session: Persist vSphere client sessions to disk
        :param pulumi.Input[str] rest_session_path: The directory to save vSphere REST API sessions to
        :param pulumi.Input[str] user: The user name for vSphere API operations.
        :param pulumi.Input[float] vim_keep_alive: Keep alive interval for the VIM session in minutes
        :param pulumi.Input[str] vim_session_path: The directory to save vSphere SOAP API sessions to
        :param pulumi.Input[str] vsphere_server: The vSphere Server name for vSphere API operations.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if allow_unverified_ssl is None:
                allow_unverified_ssl = utilities.get_env_bool('VSPHERE_ALLOW_UNVERIFIED_SSL')
            __props__['allow_unverified_ssl'] = pulumi.Output.from_input(allow_unverified_ssl).apply(json.dumps) if allow_unverified_ssl is not None else None
            if client_debug is None:
                client_debug = utilities.get_env_bool('VSPHERE_CLIENT_DEBUG')
            __props__['client_debug'] = pulumi.Output.from_input(client_debug).apply(json.dumps) if client_debug is not None else None
            if client_debug_path is None:
                client_debug_path = utilities.get_env('VSPHERE_CLIENT_DEBUG_PATH')
            __props__['client_debug_path'] = client_debug_path
            if client_debug_path_run is None:
                client_debug_path_run = utilities.get_env('VSPHERE_CLIENT_DEBUG_PATH_RUN')
            __props__['client_debug_path_run'] = client_debug_path_run
            if password is None:
                password = utilities.get_env('VSPHERE_PASSWORD')
            __props__['password'] = password
            if persist_session is None:
                persist_session = utilities.get_env_bool('VSPHERE_PERSIST_SESSION')
            __props__['persist_session'] = pulumi.Output.from_input(persist_session).apply(json.dumps) if persist_session is not None else None
            if rest_session_path is None:
                rest_session_path = utilities.get_env('VSPHERE_REST_SESSION_PATH')
            __props__['rest_session_path'] = rest_session_path
            if user is None:
                user = utilities.get_env('VSPHERE_USER')
            __props__['user'] = user
            if vcenter_server is not None:
                warnings.warn("This field has been renamed to vsphere_server.", DeprecationWarning)
                pulumi.log.warn("vcenter_server is deprecated: This field has been renamed to vsphere_server.")
            __props__['vcenter_server'] = vcenter_server
            if vim_keep_alive is None:
                vim_keep_alive = utilities.get_env_int('VSPHERE_VIM_KEEP_ALIVE')
            __props__['vim_keep_alive'] = pulumi.Output.from_input(vim_keep_alive).apply(json.dumps) if vim_keep_alive is not None else None
            if vim_session_path is None:
                vim_session_path = utilities.get_env('VSPHERE_VIM_SESSION_PATH')
            __props__['vim_session_path'] = vim_session_path
            if vsphere_server is None:
                vsphere_server = utilities.get_env('VSPHERE_SERVER')
            __props__['vsphere_server'] = vsphere_server
        super(Provider, __self__).__init__(
            'vsphere',
            resource_name,
            __props__,
            opts)

    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

