# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import utilities, tables

class StorageDrsVmOverride(pulumi.CustomResource):
    datastore_cluster_id: pulumi.Output[str]
    """
    The managed object reference
    ID of the datastore cluster to put the override in.
    Forces a new resource if changed.
    """
    sdrs_automation_level: pulumi.Output[str]
    """
    Overrides any Storage DRS automation
    levels for this virtual machine. Can be one of `automated` or `manual`. When
    not specified, the datastore cluster's settings are used according to the
    specific SDRS subsystem.
    """
    sdrs_enabled: pulumi.Output[str]
    """
    Overrides the default Storage DRS setting for
    this virtual machine. When not specified, the datastore cluster setting is
    used.
    """
    sdrs_intra_vm_affinity: pulumi.Output[str]
    """
    Overrides the intra-VM affinity setting
    for this virtual machine. When `true`, all disks for this virtual machine
    will be kept on the same datastore. When `false`, Storage DRS may locate
    individual disks on different datastores if it helps satisfy cluster
    requirements. When not specified, the datastore cluster's settings are used.
    """
    virtual_machine_id: pulumi.Output[str]
    """
    The UUID of the virtual machine to create
    the override for.  Forces a new resource if changed.
    """
    def __init__(__self__, resource_name, opts=None, datastore_cluster_id=None, sdrs_automation_level=None, sdrs_enabled=None, sdrs_intra_vm_affinity=None, virtual_machine_id=None, __props__=None, __name__=None, __opts__=None):
        """
        The `.StorageDrsVmOverride` resource can be used to add a Storage DRS
        override to a datastore cluster for a specific virtual machine. With this
        resource, one can enable or disable Storage DRS, and control the automation
        level and disk affinity for a single virtual machine without affecting the rest
        of the datastore cluster.

        For more information on vSphere datastore clusters and Storage DRS, see [this
        page][ref-vsphere-datastore-clusters].

        [ref-vsphere-datastore-clusters]: https://docs.vmware.com/en/VMware-vSphere/6.5/com.vmware.vsphere.resmgmt.doc/GUID-598DF695-107E-406B-9C95-0AF961FC227A.html

        ## Example Usage



        ```python
        import pulumi
        import pulumi_vsphere as vsphere

        dc = vsphere.get_datacenter(name="dc1")
        datastore_cluster = vsphere.get_datastore_cluster(datacenter_id=dc.id,
            name="datastore-cluster1")
        member_datastore = vsphere.get_datastore(datacenter_id=dc.id,
            name="datastore-cluster1-member1")
        pool = vsphere.get_resource_pool(datacenter_id=dc.id,
            name="cluster1/Resources")
        network = vsphere.get_network(datacenter_id=dc.id,
            name="public")
        vm = vsphere.VirtualMachine("vm",
            datastore_id=member_datastore.id,
            disks=[{
                "label": "disk0",
                "size": 20,
            }],
            guest_id="other3xLinux64Guest",
            memory=1024,
            network_interfaces=[{
                "networkId": network.id,
            }],
            num_cpus=2,
            resource_pool_id=pool.id)
        drs_vm_override = vsphere.StorageDrsVmOverride("drsVmOverride",
            datastore_cluster_id=datastore_cluster.id,
            sdrs_enabled=False,
            virtual_machine_id=vm.id)
        ```


        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] datastore_cluster_id: The managed object reference
               ID of the datastore cluster to put the override in.
               Forces a new resource if changed.
        :param pulumi.Input[str] sdrs_automation_level: Overrides any Storage DRS automation
               levels for this virtual machine. Can be one of `automated` or `manual`. When
               not specified, the datastore cluster's settings are used according to the
               specific SDRS subsystem.
        :param pulumi.Input[str] sdrs_enabled: Overrides the default Storage DRS setting for
               this virtual machine. When not specified, the datastore cluster setting is
               used.
        :param pulumi.Input[str] sdrs_intra_vm_affinity: Overrides the intra-VM affinity setting
               for this virtual machine. When `true`, all disks for this virtual machine
               will be kept on the same datastore. When `false`, Storage DRS may locate
               individual disks on different datastores if it helps satisfy cluster
               requirements. When not specified, the datastore cluster's settings are used.
        :param pulumi.Input[str] virtual_machine_id: The UUID of the virtual machine to create
               the override for.  Forces a new resource if changed.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if datastore_cluster_id is None:
                raise TypeError("Missing required property 'datastore_cluster_id'")
            __props__['datastore_cluster_id'] = datastore_cluster_id
            __props__['sdrs_automation_level'] = sdrs_automation_level
            __props__['sdrs_enabled'] = sdrs_enabled
            __props__['sdrs_intra_vm_affinity'] = sdrs_intra_vm_affinity
            if virtual_machine_id is None:
                raise TypeError("Missing required property 'virtual_machine_id'")
            __props__['virtual_machine_id'] = virtual_machine_id
        super(StorageDrsVmOverride, __self__).__init__(
            'vsphere:index/storageDrsVmOverride:StorageDrsVmOverride',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, datastore_cluster_id=None, sdrs_automation_level=None, sdrs_enabled=None, sdrs_intra_vm_affinity=None, virtual_machine_id=None):
        """
        Get an existing StorageDrsVmOverride resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] datastore_cluster_id: The managed object reference
               ID of the datastore cluster to put the override in.
               Forces a new resource if changed.
        :param pulumi.Input[str] sdrs_automation_level: Overrides any Storage DRS automation
               levels for this virtual machine. Can be one of `automated` or `manual`. When
               not specified, the datastore cluster's settings are used according to the
               specific SDRS subsystem.
        :param pulumi.Input[str] sdrs_enabled: Overrides the default Storage DRS setting for
               this virtual machine. When not specified, the datastore cluster setting is
               used.
        :param pulumi.Input[str] sdrs_intra_vm_affinity: Overrides the intra-VM affinity setting
               for this virtual machine. When `true`, all disks for this virtual machine
               will be kept on the same datastore. When `false`, Storage DRS may locate
               individual disks on different datastores if it helps satisfy cluster
               requirements. When not specified, the datastore cluster's settings are used.
        :param pulumi.Input[str] virtual_machine_id: The UUID of the virtual machine to create
               the override for.  Forces a new resource if changed.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["datastore_cluster_id"] = datastore_cluster_id
        __props__["sdrs_automation_level"] = sdrs_automation_level
        __props__["sdrs_enabled"] = sdrs_enabled
        __props__["sdrs_intra_vm_affinity"] = sdrs_intra_vm_affinity
        __props__["virtual_machine_id"] = virtual_machine_id
        return StorageDrsVmOverride(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

