# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import utilities, tables

class TagCategory(pulumi.CustomResource):
    associable_types: pulumi.Output[list]
    """
    A list object types that this category is
    valid to be assigned to. For a full list, click
    here.
    """
    cardinality: pulumi.Output[str]
    """
    The number of tags that can be assigned from this
    category to a single object at once. Can be one of `SINGLE` (object can only
    be assigned one tag in this category), to `MULTIPLE` (object can be assigned
    multiple tags in this category). Forces a new resource if changed.
    """
    description: pulumi.Output[str]
    """
    A description for the category.
    """
    name: pulumi.Output[str]
    """
    The name of the category.
    """
    def __init__(__self__, resource_name, opts=None, associable_types=None, cardinality=None, description=None, name=None, __props__=None, __name__=None, __opts__=None):
        """
        Create a TagCategory resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[list] associable_types: A list object types that this category is
               valid to be assigned to. For a full list, click
               here.
        :param pulumi.Input[str] cardinality: The number of tags that can be assigned from this
               category to a single object at once. Can be one of `SINGLE` (object can only
               be assigned one tag in this category), to `MULTIPLE` (object can be assigned
               multiple tags in this category). Forces a new resource if changed.
        :param pulumi.Input[str] description: A description for the category.
        :param pulumi.Input[str] name: The name of the category.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if associable_types is None:
                raise TypeError("Missing required property 'associable_types'")
            __props__['associable_types'] = associable_types
            if cardinality is None:
                raise TypeError("Missing required property 'cardinality'")
            __props__['cardinality'] = cardinality
            __props__['description'] = description
            __props__['name'] = name
        super(TagCategory, __self__).__init__(
            'vsphere:index/tagCategory:TagCategory',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, associable_types=None, cardinality=None, description=None, name=None):
        """
        Get an existing TagCategory resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[list] associable_types: A list object types that this category is
               valid to be assigned to. For a full list, click
               here.
        :param pulumi.Input[str] cardinality: The number of tags that can be assigned from this
               category to a single object at once. Can be one of `SINGLE` (object can only
               be assigned one tag in this category), to `MULTIPLE` (object can be assigned
               multiple tags in this category). Forces a new resource if changed.
        :param pulumi.Input[str] description: A description for the category.
        :param pulumi.Input[str] name: The name of the category.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["associable_types"] = associable_types
        __props__["cardinality"] = cardinality
        __props__["description"] = description
        __props__["name"] = name
        return TagCategory(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

