# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import utilities, tables

class VappEntity(pulumi.CustomResource):
    container_id: pulumi.Output[str]
    """
    Managed object ID of the vApp
    container the entity is a member of.
    """
    custom_attributes: pulumi.Output[dict]
    """
    A list of custom attributes to set on this resource.
    """
    start_action: pulumi.Output[str]
    """
    How to start the entity. Valid settings are none
    or powerOn. If set to none, then the entity does not participate in auto-start.
    Default: powerOn
    """
    start_delay: pulumi.Output[float]
    """
    Delay in seconds before continuing with the next
    entity in the order of entities to be started. Default: 120
    """
    start_order: pulumi.Output[float]
    """
    Order to start and stop target in vApp. Default: 1
    """
    stop_action: pulumi.Output[str]
    """
    Defines the stop action for the entity. Can be set
    to none, powerOff, guestShutdown, or suspend. If set to none, then the entity
    does not participate in auto-stop. Default: powerOff
    """
    stop_delay: pulumi.Output[float]
    """
    Delay in seconds before continuing with the next
    entity in the order sequence. This is only used if the stopAction is
    guestShutdown. Default: 120
    """
    tags: pulumi.Output[list]
    """
    A list of tag IDs to apply to this object.
    """
    target_id: pulumi.Output[str]
    """
    Managed object ID of the entity
    to power on or power off. This can be a virtual machine or a vApp.
    """
    wait_for_guest: pulumi.Output[bool]
    """
    Determines if the VM should be marked as being
    started when VMware Tools are ready instead of waiting for `start_delay`. This
    property has no effect for vApps. Default: false
    """
    def __init__(__self__, resource_name, opts=None, container_id=None, custom_attributes=None, start_action=None, start_delay=None, start_order=None, stop_action=None, stop_delay=None, tags=None, target_id=None, wait_for_guest=None, __props__=None, __name__=None, __opts__=None):
        """
        Create a VappEntity resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] container_id: Managed object ID of the vApp
               container the entity is a member of.
        :param pulumi.Input[dict] custom_attributes: A list of custom attributes to set on this resource.
        :param pulumi.Input[str] start_action: How to start the entity. Valid settings are none
               or powerOn. If set to none, then the entity does not participate in auto-start.
               Default: powerOn
        :param pulumi.Input[float] start_delay: Delay in seconds before continuing with the next
               entity in the order of entities to be started. Default: 120
        :param pulumi.Input[float] start_order: Order to start and stop target in vApp. Default: 1
        :param pulumi.Input[str] stop_action: Defines the stop action for the entity. Can be set
               to none, powerOff, guestShutdown, or suspend. If set to none, then the entity
               does not participate in auto-stop. Default: powerOff
        :param pulumi.Input[float] stop_delay: Delay in seconds before continuing with the next
               entity in the order sequence. This is only used if the stopAction is
               guestShutdown. Default: 120
        :param pulumi.Input[list] tags: A list of tag IDs to apply to this object.
        :param pulumi.Input[str] target_id: Managed object ID of the entity
               to power on or power off. This can be a virtual machine or a vApp.
        :param pulumi.Input[bool] wait_for_guest: Determines if the VM should be marked as being
               started when VMware Tools are ready instead of waiting for `start_delay`. This
               property has no effect for vApps. Default: false
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if container_id is None:
                raise TypeError("Missing required property 'container_id'")
            __props__['container_id'] = container_id
            __props__['custom_attributes'] = custom_attributes
            __props__['start_action'] = start_action
            __props__['start_delay'] = start_delay
            __props__['start_order'] = start_order
            __props__['stop_action'] = stop_action
            __props__['stop_delay'] = stop_delay
            __props__['tags'] = tags
            if target_id is None:
                raise TypeError("Missing required property 'target_id'")
            __props__['target_id'] = target_id
            __props__['wait_for_guest'] = wait_for_guest
        super(VappEntity, __self__).__init__(
            'vsphere:index/vappEntity:VappEntity',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, container_id=None, custom_attributes=None, start_action=None, start_delay=None, start_order=None, stop_action=None, stop_delay=None, tags=None, target_id=None, wait_for_guest=None):
        """
        Get an existing VappEntity resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] container_id: Managed object ID of the vApp
               container the entity is a member of.
        :param pulumi.Input[dict] custom_attributes: A list of custom attributes to set on this resource.
        :param pulumi.Input[str] start_action: How to start the entity. Valid settings are none
               or powerOn. If set to none, then the entity does not participate in auto-start.
               Default: powerOn
        :param pulumi.Input[float] start_delay: Delay in seconds before continuing with the next
               entity in the order of entities to be started. Default: 120
        :param pulumi.Input[float] start_order: Order to start and stop target in vApp. Default: 1
        :param pulumi.Input[str] stop_action: Defines the stop action for the entity. Can be set
               to none, powerOff, guestShutdown, or suspend. If set to none, then the entity
               does not participate in auto-stop. Default: powerOff
        :param pulumi.Input[float] stop_delay: Delay in seconds before continuing with the next
               entity in the order sequence. This is only used if the stopAction is
               guestShutdown. Default: 120
        :param pulumi.Input[list] tags: A list of tag IDs to apply to this object.
        :param pulumi.Input[str] target_id: Managed object ID of the entity
               to power on or power off. This can be a virtual machine or a vApp.
        :param pulumi.Input[bool] wait_for_guest: Determines if the VM should be marked as being
               started when VMware Tools are ready instead of waiting for `start_delay`. This
               property has no effect for vApps. Default: false
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["container_id"] = container_id
        __props__["custom_attributes"] = custom_attributes
        __props__["start_action"] = start_action
        __props__["start_delay"] = start_delay
        __props__["start_order"] = start_order
        __props__["stop_action"] = stop_action
        __props__["stop_delay"] = stop_delay
        __props__["tags"] = tags
        __props__["target_id"] = target_id
        __props__["wait_for_guest"] = wait_for_guest
        return VappEntity(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

