# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import utilities, tables

class VirtualMachine(pulumi.CustomResource):
    alternate_guest_name: pulumi.Output[str]
    """
    The guest name for the operating system
    when `guest_id` is `other` or `other-64`.
    """
    annotation: pulumi.Output[str]
    """
    A user-provided description of the virtual machine.
    The default is no annotation.
    """
    boot_delay: pulumi.Output[float]
    """
    The number of milliseconds to wait before starting
    the boot sequence. The default is no delay.
    """
    boot_retry_delay: pulumi.Output[float]
    """
    The number of milliseconds to wait before
    retrying the boot sequence. This only valid if `boot_retry_enabled` is true.
    Default: `10000` (10 seconds).
    """
    boot_retry_enabled: pulumi.Output[bool]
    """
    If set to true, a virtual machine that
    fails to boot will try again after the delay defined in `boot_retry_delay`.
    Default: `false`.
    """
    cdrom: pulumi.Output[dict]
    """
    A specification for a CDROM device on this virtual
    machine. See CDROM options below.

      * `clientDevice` (`bool`) - Indicates whether the device should be backed by
        remote client device. Conflicts with `datastore_id` and `path`.
      * `datastore_id` (`str`) - The datastore ID that the ISO is located in.
        Requried for using a datastore ISO. Conflicts with `client_device`.
      * `deviceAddress` (`str`) - An address internal to this provider that helps locate the
        device when `key` is unavailable. This follows a convention of
        `CONTROLLER_TYPE:BUS_NUMBER:UNIT_NUMBER`. Example: `scsi:0:1` means device
        unit 1 on SCSI bus 0.
      * `key` (`float`) - The ID of the device within the virtual machine.
      * `path` (`str`) - The path to the ISO file. Required for using a datastore
        ISO. Conflicts with `client_device`.
    """
    change_version: pulumi.Output[str]
    """
    A unique identifier for a given version of the last
    configuration applied, such the timestamp of the last update to the
    configuration.
    """
    clone: pulumi.Output[dict]
    """
    When specified, the VM will be created as a clone of a
    specified template. Optional customization options can be submitted as well.
    See creating a virtual machine from a
    template for more details.

      * `customize` (`dict`)
        * `dnsServerLists` (`list`)
        * `dnsSuffixLists` (`list`)
        * `ipv4Gateway` (`str`)
        * `ipv6Gateway` (`str`)
        * `linuxOptions` (`dict`)
          * `domain` (`str`)
          * `hostName` (`str`)
          * `hwClockUtc` (`bool`)
          * `timeZone` (`str`)

        * `network_interfaces` (`list`) - A specification for a virtual NIC on this
          virtual machine. See network interface options
          below.
          * `dnsDomain` (`str`)
          * `dnsServerLists` (`list`)
          * `ipv4_address` (`str`)
          * `ipv4Netmask` (`float`)
          * `ipv6Address` (`str`)
          * `ipv6Netmask` (`float`)

        * `timeout` (`float`)
        * `windowsOptions` (`dict`)
          * `adminPassword` (`str`)
          * `autoLogon` (`bool`)
          * `autoLogonCount` (`float`)
          * `computerName` (`str`)
          * `domainAdminPassword` (`str`)
          * `domainAdminUser` (`str`)
          * `fullName` (`str`)
          * `joinDomain` (`str`)
          * `organizationName` (`str`)
          * `productKey` (`str`)
          * `runOnceCommandLists` (`list`)
          * `timeZone` (`float`)
          * `workgroup` (`str`)

        * `windowsSysprepText` (`str`)

      * `linkedClone` (`bool`)
      * `ovfNetworkMap` (`dict`)
      * `ovfStorageMap` (`dict`)
      * `templateUuid` (`str`)
      * `timeout` (`float`)
    """
    cpu_hot_add_enabled: pulumi.Output[bool]
    """
    Allow CPUs to be added to this virtual
    machine while it is running.
    """
    cpu_hot_remove_enabled: pulumi.Output[bool]
    """
    Allow CPUs to be removed to this
    virtual machine while it is running.
    """
    cpu_limit: pulumi.Output[float]
    """
    The maximum amount of CPU (in MHz) that this virtual
    machine can consume, regardless of available resources. The default is no
    limit.
    """
    cpu_performance_counters_enabled: pulumi.Output[bool]
    """
    Enable CPU performance
    counters on this virtual machine. Default: `false`.
    """
    cpu_reservation: pulumi.Output[float]
    """
    The amount of CPU (in MHz) that this virtual
    machine is guaranteed. The default is no reservation.
    """
    cpu_share_count: pulumi.Output[float]
    """
    The number of CPU shares allocated to the
    virtual machine when the `cpu_share_level` is `custom`.
    """
    cpu_share_level: pulumi.Output[str]
    """
    The allocation level for CPU resources. Can be
    one of `high`, `low`, `normal`, or `custom`. Default: `custom`.
    """
    custom_attributes: pulumi.Output[dict]
    """
    Map of custom attribute ids to attribute
    value strings to set for virtual machine.
    """
    datacenter_id: pulumi.Output[str]
    """
    The datacenter id. Required only when deploying
    an ovf template.
    """
    datastore_cluster_id: pulumi.Output[str]
    """
    The managed object reference
    ID of the datastore cluster ID to use. This setting
    applies to entire virtual machine and implies that you wish to use Storage
    DRS with this virtual machine. See the section on virtual machine
    migration for details on changing this value.
    """
    datastore_id: pulumi.Output[str]
    """
    The datastore ID that the ISO is located in.
    Requried for using a datastore ISO. Conflicts with `client_device`.
    """
    default_ip_address: pulumi.Output[str]
    """
    The IP address selected by the provider to be used with
    any provisioners configured on this resource.
    Whenever possible, this is the first IPv4 address that is reachable through
    the default gateway configured on the machine, then the first reachable IPv6
    address, and then the first general discovered address if neither exist. If
    VMware tools is not running on the virtual machine, or if the VM is powered
    off, this value will be blank.
    """
    disks: pulumi.Output[list]
    """
    A specification for a virtual disk device on this virtual
    machine. See disk options below.

      * `attach` (`bool`) - Attach an external disk instead of creating a new one.
        Implies and conflicts with `keep_on_remove`. If set, you cannot set `size`,
        `eagerly_scrub`, or `thin_provisioned`. Must set `path` if used.
      * `datastore_id` (`str`) - The datastore ID that the ISO is located in.
        Requried for using a datastore ISO. Conflicts with `client_device`.
      * `deviceAddress` (`str`) - An address internal to this provider that helps locate the
        device when `key` is unavailable. This follows a convention of
        `CONTROLLER_TYPE:BUS_NUMBER:UNIT_NUMBER`. Example: `scsi:0:1` means device
        unit 1 on SCSI bus 0.
      * `diskMode` (`str`) - The mode of this this virtual disk for purposes of
        writes and snapshotting. Can be one of `append`, `independent_nonpersistent`,
        `independent_persistent`, `nonpersistent`, `persistent`, or `undoable`.
        Default: `persistent`. For an explanation of options, click
        [here][vmware-docs-disk-mode].
      * `diskSharing` (`str`) - The sharing mode of this virtual disk. Can be one
        of `sharingMultiWriter` or `sharingNone`. Default: `sharingNone`.
      * `eagerlyScrub` (`bool`) - If set to `true`, the disk space is zeroed out
        on VM creation. This will delay the creation of the disk or virtual machine.
        Cannot be set to `true` when `thin_provisioned` is `true`.  See the section
        on picking a disk type.  Default: `false`.
      * `ioLimit` (`float`) - The upper limit of IOPS that this disk can use. The
        default is no limit.
      * `ioReservation` (`float`) - The I/O reservation (guarantee) that this disk
        has, in IOPS.  The default is no reservation.
      * `ioShareCount` (`float`) - The share count for this disk when the share
        level is `custom`.
      * `ioShareLevel` (`str`) - The share allocation level for this disk. Can
        be one of `low`, `normal`, `high`, or `custom`. Default: `normal`.
      * `keepOnRemove` (`bool`) - Keep this disk when removing the device or
        destroying the virtual machine. Default: `false`.
      * `key` (`float`) - The ID of the device within the virtual machine.
      * `label` (`str`) - A label for the disk. Forces a new disk if changed.
      * `name` (`str`) - An alias for both `label` and `path`, the latter when
        using `attach`. Required if not using `label`.
      * `path` (`str`) - The path to the ISO file. Required for using a datastore
        ISO. Conflicts with `client_device`.
      * `size` (`float`) - The size of the disk, in GB.
      * `storage_policy_id` (`str`) - The UUID of the storage policy to assign to this disk.
      * `thinProvisioned` (`bool`) - If `true`, this disk is thin provisioned,
        with space for the file being allocated on an as-needed basis. Cannot be set
        to `true` when `eagerly_scrub` is `true`. See the section on picking a disk
        type. Default: `true`.
      * `unitNumber` (`float`) - The disk number on the SCSI bus. The maximum value
        for this setting is the value of
        `scsi_controller_count` times 15, minus 1 (so `14`,
        `29`, `44`, and `59`, for 1-4 controllers respectively). The default is `0`,
        for which one disk must be set to. Duplicate unit numbers are not allowed.
      * `uuid` (`str`) - The UUID of the virtual disk's VMDK file. This is used to track the
        virtual disk on the virtual machine.
      * `writeThrough` (`bool`) - If `true`, writes for this disk are sent
        directly to the filesystem immediately instead of being buffered. Default:
        `false`.
    """
    efi_secure_boot_enabled: pulumi.Output[bool]
    """
    When the `firmware` type is set to is
    `efi`, this enables EFI secure boot. Default: `false`.
    """
    enable_disk_uuid: pulumi.Output[bool]
    """
    Expose the UUIDs of attached virtual disks to
    the virtual machine, allowing access to them in the guest. Default: `false`.
    """
    enable_logging: pulumi.Output[bool]
    """
    Enable logging of virtual machine events to a
    log file stored in the virtual machine directory. Default: `false`.
    """
    ept_rvi_mode: pulumi.Output[str]
    """
    The EPT/RVI (hardware memory virtualization)
    setting for this virtual machine. Can be one of `automatic`, `on`, or `off`.
    Default: `automatic`.
    """
    extra_config: pulumi.Output[dict]
    """
    Extra configuration data for this virtual
    machine. Can be used to supply advanced parameters not normally in
    configuration, such as instance metadata.
    """
    firmware: pulumi.Output[str]
    """
    The firmware interface to use on the virtual machine.
    Can be one of `bios` or `EFI`. Default: `bios`.
    """
    folder: pulumi.Output[str]
    """
    The path to the folder to put this virtual machine in,
    relative to the datacenter that the resource pool is in.
    """
    force_power_off: pulumi.Output[bool]
    """
    If a guest shutdown failed or timed out while
    updating or destroying (see
    `shutdown_wait_timeout`), force the power-off of
    the virtual machine. Default: `true`.
    """
    guest_id: pulumi.Output[str]
    """
    The guest ID for the operating system type. For a
    full list of possible values, see [here][vmware-docs-guest-ids]. Default: `other-64`.
    """
    guest_ip_addresses: pulumi.Output[list]
    """
    The current list of IP addresses on this machine,
    including the value of `default_ip_address`. If VMware tools is not running
    on the virtual machine, or if the VM is powered off, this list will be empty.
    * `moid`: The managed object reference ID of the created
    virtual machine.
    """
    hardware_version: pulumi.Output[float]
    """
    The hardware version number. Valid range
    is from 4 to 15. The hardware version cannot be downgraded. See [virtual
    machine hardware compatibility][virtual-machine-hardware-compatibility] for
    more details.
    """
    host_system_id: pulumi.Output[str]
    """
    An optional managed object reference
    ID of a host to put this virtual machine on. See the
    section on virtual machine migration for
    details on changing this value. If a `host_system_id` is not supplied,
    vSphere will select a host in the resource pool to place the virtual machine,
    according to any defaults or DRS policies in place.
    """
    hv_mode: pulumi.Output[str]
    """
    The (non-nested) hardware virtualization setting for
    this virtual machine. Can be one of `hvAuto`, `hvOn`, or `hvOff`. Default:
    `hvAuto`.
    """
    ignored_guest_ips: pulumi.Output[list]
    """
    List of IP addresses and CIDR networks to
    ignore while waiting for an available IP address using either of the waiters.
    Any IP addresses in this list will be ignored if they show up so that the
    waiter will continue to wait for a real IP address. Default: [].
    """
    imported: pulumi.Output[bool]
    """
    This is flagged if the virtual machine has been imported, or the
    state has been migrated from a previous version of the resource. It
    influences the behavior of the first post-import apply operation. See the
    section on importing below.
    """
    latency_sensitivity: pulumi.Output[str]
    """
    Controls the scheduling delay of the
    virtual machine. Use a higher sensitivity for applications that require lower
    latency, such as VOIP, media player applications, or applications that
    require frequent access to mouse or keyboard devices. Can be one of `low`,
    `normal`, `medium`, or `high`.
    """
    memory: pulumi.Output[float]
    """
    The size of the virtual machine's memory, in MB.
    Default: `1024` (1 GB).
    """
    memory_hot_add_enabled: pulumi.Output[bool]
    """
    Allow memory to be added to this
    virtual machine while it is running.
    """
    memory_limit: pulumi.Output[float]
    """
    The maximum amount of memory (in MB) that this
    virtual machine can consume, regardless of available resources. The default
    is no limit.
    """
    memory_reservation: pulumi.Output[float]
    """
    The amount of memory (in MB) that this
    virtual machine is guaranteed. The default is no reservation.
    """
    memory_share_count: pulumi.Output[float]
    """
    The number of memory shares allocated to
    the virtual machine when the `memory_share_level` is `custom`.
    """
    memory_share_level: pulumi.Output[str]
    """
    The allocation level for memory resources.
    Can be one of `high`, `low`, `normal`, or `custom`. Default: `custom`.
    """
    migrate_wait_timeout: pulumi.Output[float]
    """
    The amount of time, in minutes, to wait
    for a virtual machine migration to complete before failing. Default: 10
    minutes. Also see the section on virtual machine
    migration.
    """
    moid: pulumi.Output[str]
    """
    The machine object ID from VMWare
    """
    name: pulumi.Output[str]
    """
    An alias for both `label` and `path`, the latter when
    using `attach`. Required if not using `label`.
    """
    nested_hv_enabled: pulumi.Output[bool]
    """
    Enable nested hardware virtualization on
    this virtual machine, facilitating nested virtualization in the guest.
    Default: `false`.
    """
    network_interfaces: pulumi.Output[list]
    """
    A specification for a virtual NIC on this
    virtual machine. See network interface options
    below.

      * `adapter_type` (`str`) - The network interface type. Can be one of
        `e1000`, `e1000e`, or `vmxnet3`. Default: `vmxnet3`.
      * `bandwidthLimit` (`float`) - The upper bandwidth limit of this network
        interface, in Mbits/sec. The default is no limit.
      * `bandwidthReservation` (`float`) - The bandwidth reservation of this
        network interface, in Mbits/sec. The default is no reservation.
      * `bandwidthShareCount` (`float`) - The share count for this network
        interface when the share level is `custom`.
      * `bandwidthShareLevel` (`str`) - The bandwidth share allocation level for
        this interface. Can be one of `low`, `normal`, `high`, or `custom`. Default:
        `normal`.
      * `deviceAddress` (`str`) - An address internal to this provider that helps locate the
        device when `key` is unavailable. This follows a convention of
        `CONTROLLER_TYPE:BUS_NUMBER:UNIT_NUMBER`. Example: `scsi:0:1` means device
        unit 1 on SCSI bus 0.
      * `key` (`float`) - The ID of the device within the virtual machine.
      * `macAddress` (`str`) - The MAC address of this network interface. Can
        only be manually set if `use_static_mac` is true, otherwise this is a
        computed value that gives the current MAC address of this interface.
      * `networkId` (`str`) - The managed object reference
        ID of the network to connect this interface to.
      * `ovfMapping` (`str`) - Specifies which OVF NIC the `network_interface`
        should be associated with. Only applies at creation and only when deploying
        from an OVF source.
      * `useStaticMac` (`bool`) - If true, the `mac_address` field is treated as
        a static MAC address and set accordingly. Setting this to `true` requires
        `mac_address` to be set. Default: `false`.
    """
    num_cores_per_socket: pulumi.Output[float]
    """
    The number of cores per socket in this
    virtual machine. The number of vCPUs on the virtual machine will be
    `num_cpus` divided by `num_cores_per_socket`. If specified, the value
    supplied to `num_cpus` must be evenly divisible by this value. Default: `1`.
    """
    num_cpus: pulumi.Output[float]
    """
    The total number of virtual processor cores to assign
    to this virtual machine. Default: `1`.
    """
    ovf_deploy: pulumi.Output[dict]
    """
    When specified, the VM will be deployed from the
    provided ovf template. See creating a virtual machine from a
    ovf template for more details.

      * `diskProvisioning` (`str`)
      * `ipAllocationPolicy` (`str`)
      * `ipProtocol` (`str`)
      * `localOvfPath` (`str`)
      * `ovfNetworkMap` (`dict`)
      * `remoteOvfUrl` (`str`)
    """
    poweron_timeout: pulumi.Output[float]
    """
    The amount of time, in seconds, that we will be trying to power on a VM
    """
    reboot_required: pulumi.Output[bool]
    """
    Value internal to the provider used to determine if a
    configuration set change requires a reboot. This value is only useful during
    an update process and gets reset on refresh.
    """
    resource_pool_id: pulumi.Output[str]
    """
    The managed object reference
    ID of the resource pool to put this virtual machine in.
    See the section on virtual machine migration
    for details on changing this value.
    """
    run_tools_scripts_after_power_on: pulumi.Output[bool]
    """
    Enable the execution of
    post-power-on scripts when VMware tools is installed. Default: `true`.
    """
    run_tools_scripts_after_resume: pulumi.Output[bool]
    """
    Enable the execution of
    post-resume scripts when VMware tools is installed. Default: `true`.
    """
    run_tools_scripts_before_guest_reboot: pulumi.Output[bool]
    """
    Enable the execution of
    pre-reboot scripts when VMware tools is installed. Default: `false`.
    """
    run_tools_scripts_before_guest_shutdown: pulumi.Output[bool]
    """
    Enable the execution
    of pre-shutdown scripts when VMware tools is installed. Default: `true`.
    """
    run_tools_scripts_before_guest_standby: pulumi.Output[bool]
    """
    Enable the execution of
    pre-standby scripts when VMware tools is installed. Default: `true`.
    """
    scsi_bus_sharing: pulumi.Output[str]
    """
    Mode for sharing the SCSI bus. The modes are
    physicalSharing, virtualSharing, and noSharing. Default: `noSharing`.
    """
    scsi_controller_count: pulumi.Output[float]
    """
    The number of SCSI controllers that
    this provider manages on this virtual machine. This directly affects the amount
    of disks you can add to the virtual machine and the maximum disk unit number.
    Note that lowering this value does not remove controllers. Default: `1`.
    """
    scsi_type: pulumi.Output[str]
    """
    The type of SCSI bus this virtual machine will have.
    Can be one of lsilogic (LSI Logic Parallel), lsilogic-sas (LSI Logic SAS) or
    pvscsi (VMware Paravirtual). Defualt: `pvscsi`.
    """
    shutdown_wait_timeout: pulumi.Output[float]
    """
    The amount of time, in minutes, to wait
    for a graceful guest shutdown when making necessary updates to the virtual
    machine. If `force_power_off` is set to true, the VM will be force powered-off
    after this timeout, otherwise an error is returned. Default: 3 minutes.
    """
    storage_policy_id: pulumi.Output[str]
    """
    The UUID of the storage policy to assign to this disk.
    """
    swap_placement_policy: pulumi.Output[str]
    """
    The swap file placement policy for this
    virtual machine. Can be one of `inherit`, `hostLocal`, or `vmDirectory`.
    Default: `inherit`.
    """
    sync_time_with_host: pulumi.Output[bool]
    """
    Enable guest clock synchronization with
    the host. Requires VMware tools to be installed. Default: `false`.
    """
    tags: pulumi.Output[list]
    """
    The IDs of any tags to attach to this resource. 
    """
    uuid: pulumi.Output[str]
    """
    The UUID of the virtual disk's VMDK file. This is used to track the
    virtual disk on the virtual machine.
    """
    vapp: pulumi.Output[dict]
    """
    Optional vApp configuration. The only sub-key available
    is `properties`, which is a key/value map of properties for virtual machines
    imported from OVF or OVA files. See Using vApp properties to supply OVF/OVA
    configuration for
    more details.

      * `properties` (`dict`)
    """
    vapp_transports: pulumi.Output[list]
    """
    Computed value which is only valid for cloned virtual
    machines. A list of vApp transport methods supported by the source virtual
    machine or template.
    """
    vmware_tools_status: pulumi.Output[str]
    """
    The state of VMware tools in the guest. This will
    determine the proper course of action for some device operations.
    """
    vmx_path: pulumi.Output[str]
    """
    The path of the virtual machine's configuration file in the VM's
    datastore.
    """
    wait_for_guest_ip_timeout: pulumi.Output[float]
    """
    The amount of time, in minutes, to
    wait for an available guest IP address on this virtual machine. This should
    only be used if your version of VMware Tools does not allow the
    `wait_for_guest_net_timeout` waiter to be
    used. A value less than 1 disables the waiter. Default: 0.
    """
    wait_for_guest_net_routable: pulumi.Output[bool]
    """
    Controls whether or not the guest
    network waiter waits for a routable address. When `false`, the waiter does
    not wait for a default gateway, nor are IP addresses checked against any
    discovered default gateways as part of its success criteria. This property is
    ignored if the `wait_for_guest_ip_timeout`
    waiter is used. Default: `true`.
    """
    wait_for_guest_net_timeout: pulumi.Output[float]
    """
    The amount of time, in minutes, to
    wait for an available IP address on this virtual machine's NICs. Older
    versions of VMware Tools do not populate this property. In those cases, this
    waiter can be disabled and the
    `wait_for_guest_ip_timeout` waiter can be used
    instead. A value less than 1 disables the waiter. Default: 5 minutes.
    """
    def __init__(__self__, resource_name, opts=None, alternate_guest_name=None, annotation=None, boot_delay=None, boot_retry_delay=None, boot_retry_enabled=None, cdrom=None, clone=None, cpu_hot_add_enabled=None, cpu_hot_remove_enabled=None, cpu_limit=None, cpu_performance_counters_enabled=None, cpu_reservation=None, cpu_share_count=None, cpu_share_level=None, custom_attributes=None, datacenter_id=None, datastore_cluster_id=None, datastore_id=None, disks=None, efi_secure_boot_enabled=None, enable_disk_uuid=None, enable_logging=None, ept_rvi_mode=None, extra_config=None, firmware=None, folder=None, force_power_off=None, guest_id=None, hardware_version=None, host_system_id=None, hv_mode=None, ignored_guest_ips=None, latency_sensitivity=None, memory=None, memory_hot_add_enabled=None, memory_limit=None, memory_reservation=None, memory_share_count=None, memory_share_level=None, migrate_wait_timeout=None, name=None, nested_hv_enabled=None, network_interfaces=None, num_cores_per_socket=None, num_cpus=None, ovf_deploy=None, poweron_timeout=None, resource_pool_id=None, run_tools_scripts_after_power_on=None, run_tools_scripts_after_resume=None, run_tools_scripts_before_guest_reboot=None, run_tools_scripts_before_guest_shutdown=None, run_tools_scripts_before_guest_standby=None, scsi_bus_sharing=None, scsi_controller_count=None, scsi_type=None, shutdown_wait_timeout=None, storage_policy_id=None, swap_placement_policy=None, sync_time_with_host=None, tags=None, vapp=None, wait_for_guest_ip_timeout=None, wait_for_guest_net_routable=None, wait_for_guest_net_timeout=None, __props__=None, __name__=None, __opts__=None):
        """
        Create a VirtualMachine resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] alternate_guest_name: The guest name for the operating system
               when `guest_id` is `other` or `other-64`.
        :param pulumi.Input[str] annotation: A user-provided description of the virtual machine.
               The default is no annotation.
        :param pulumi.Input[float] boot_delay: The number of milliseconds to wait before starting
               the boot sequence. The default is no delay.
        :param pulumi.Input[float] boot_retry_delay: The number of milliseconds to wait before
               retrying the boot sequence. This only valid if `boot_retry_enabled` is true.
               Default: `10000` (10 seconds).
        :param pulumi.Input[bool] boot_retry_enabled: If set to true, a virtual machine that
               fails to boot will try again after the delay defined in `boot_retry_delay`.
               Default: `false`.
        :param pulumi.Input[dict] cdrom: A specification for a CDROM device on this virtual
               machine. See CDROM options below.
        :param pulumi.Input[dict] clone: When specified, the VM will be created as a clone of a
               specified template. Optional customization options can be submitted as well.
               See creating a virtual machine from a
               template for more details.
        :param pulumi.Input[bool] cpu_hot_add_enabled: Allow CPUs to be added to this virtual
               machine while it is running.
        :param pulumi.Input[bool] cpu_hot_remove_enabled: Allow CPUs to be removed to this
               virtual machine while it is running.
        :param pulumi.Input[float] cpu_limit: The maximum amount of CPU (in MHz) that this virtual
               machine can consume, regardless of available resources. The default is no
               limit.
        :param pulumi.Input[bool] cpu_performance_counters_enabled: Enable CPU performance
               counters on this virtual machine. Default: `false`.
        :param pulumi.Input[float] cpu_reservation: The amount of CPU (in MHz) that this virtual
               machine is guaranteed. The default is no reservation.
        :param pulumi.Input[float] cpu_share_count: The number of CPU shares allocated to the
               virtual machine when the `cpu_share_level` is `custom`.
        :param pulumi.Input[str] cpu_share_level: The allocation level for CPU resources. Can be
               one of `high`, `low`, `normal`, or `custom`. Default: `custom`.
        :param pulumi.Input[dict] custom_attributes: Map of custom attribute ids to attribute
               value strings to set for virtual machine.
        :param pulumi.Input[str] datacenter_id: The datacenter id. Required only when deploying
               an ovf template.
        :param pulumi.Input[str] datastore_cluster_id: The managed object reference
               ID of the datastore cluster ID to use. This setting
               applies to entire virtual machine and implies that you wish to use Storage
               DRS with this virtual machine. See the section on virtual machine
               migration for details on changing this value.
        :param pulumi.Input[str] datastore_id: The datastore ID that the ISO is located in.
               Requried for using a datastore ISO. Conflicts with `client_device`.
        :param pulumi.Input[list] disks: A specification for a virtual disk device on this virtual
               machine. See disk options below.
        :param pulumi.Input[bool] efi_secure_boot_enabled: When the `firmware` type is set to is
               `efi`, this enables EFI secure boot. Default: `false`.
        :param pulumi.Input[bool] enable_disk_uuid: Expose the UUIDs of attached virtual disks to
               the virtual machine, allowing access to them in the guest. Default: `false`.
        :param pulumi.Input[bool] enable_logging: Enable logging of virtual machine events to a
               log file stored in the virtual machine directory. Default: `false`.
        :param pulumi.Input[str] ept_rvi_mode: The EPT/RVI (hardware memory virtualization)
               setting for this virtual machine. Can be one of `automatic`, `on`, or `off`.
               Default: `automatic`.
        :param pulumi.Input[dict] extra_config: Extra configuration data for this virtual
               machine. Can be used to supply advanced parameters not normally in
               configuration, such as instance metadata.
        :param pulumi.Input[str] firmware: The firmware interface to use on the virtual machine.
               Can be one of `bios` or `EFI`. Default: `bios`.
        :param pulumi.Input[str] folder: The path to the folder to put this virtual machine in,
               relative to the datacenter that the resource pool is in.
        :param pulumi.Input[bool] force_power_off: If a guest shutdown failed or timed out while
               updating or destroying (see
               `shutdown_wait_timeout`), force the power-off of
               the virtual machine. Default: `true`.
        :param pulumi.Input[str] guest_id: The guest ID for the operating system type. For a
               full list of possible values, see [here][vmware-docs-guest-ids]. Default: `other-64`.
        :param pulumi.Input[float] hardware_version: The hardware version number. Valid range
               is from 4 to 15. The hardware version cannot be downgraded. See [virtual
               machine hardware compatibility][virtual-machine-hardware-compatibility] for
               more details.
        :param pulumi.Input[str] host_system_id: An optional managed object reference
               ID of a host to put this virtual machine on. See the
               section on virtual machine migration for
               details on changing this value. If a `host_system_id` is not supplied,
               vSphere will select a host in the resource pool to place the virtual machine,
               according to any defaults or DRS policies in place.
        :param pulumi.Input[str] hv_mode: The (non-nested) hardware virtualization setting for
               this virtual machine. Can be one of `hvAuto`, `hvOn`, or `hvOff`. Default:
               `hvAuto`.
        :param pulumi.Input[list] ignored_guest_ips: List of IP addresses and CIDR networks to
               ignore while waiting for an available IP address using either of the waiters.
               Any IP addresses in this list will be ignored if they show up so that the
               waiter will continue to wait for a real IP address. Default: [].
        :param pulumi.Input[str] latency_sensitivity: Controls the scheduling delay of the
               virtual machine. Use a higher sensitivity for applications that require lower
               latency, such as VOIP, media player applications, or applications that
               require frequent access to mouse or keyboard devices. Can be one of `low`,
               `normal`, `medium`, or `high`.
        :param pulumi.Input[float] memory: The size of the virtual machine's memory, in MB.
               Default: `1024` (1 GB).
        :param pulumi.Input[bool] memory_hot_add_enabled: Allow memory to be added to this
               virtual machine while it is running.
        :param pulumi.Input[float] memory_limit: The maximum amount of memory (in MB) that this
               virtual machine can consume, regardless of available resources. The default
               is no limit.
        :param pulumi.Input[float] memory_reservation: The amount of memory (in MB) that this
               virtual machine is guaranteed. The default is no reservation.
        :param pulumi.Input[float] memory_share_count: The number of memory shares allocated to
               the virtual machine when the `memory_share_level` is `custom`.
        :param pulumi.Input[str] memory_share_level: The allocation level for memory resources.
               Can be one of `high`, `low`, `normal`, or `custom`. Default: `custom`.
        :param pulumi.Input[float] migrate_wait_timeout: The amount of time, in minutes, to wait
               for a virtual machine migration to complete before failing. Default: 10
               minutes. Also see the section on virtual machine
               migration.
        :param pulumi.Input[str] name: An alias for both `label` and `path`, the latter when
               using `attach`. Required if not using `label`.
        :param pulumi.Input[bool] nested_hv_enabled: Enable nested hardware virtualization on
               this virtual machine, facilitating nested virtualization in the guest.
               Default: `false`.
        :param pulumi.Input[list] network_interfaces: A specification for a virtual NIC on this
               virtual machine. See network interface options
               below.
        :param pulumi.Input[float] num_cores_per_socket: The number of cores per socket in this
               virtual machine. The number of vCPUs on the virtual machine will be
               `num_cpus` divided by `num_cores_per_socket`. If specified, the value
               supplied to `num_cpus` must be evenly divisible by this value. Default: `1`.
        :param pulumi.Input[float] num_cpus: The total number of virtual processor cores to assign
               to this virtual machine. Default: `1`.
        :param pulumi.Input[dict] ovf_deploy: When specified, the VM will be deployed from the
               provided ovf template. See creating a virtual machine from a
               ovf template for more details.
        :param pulumi.Input[float] poweron_timeout: The amount of time, in seconds, that we will be trying to power on a VM
        :param pulumi.Input[str] resource_pool_id: The managed object reference
               ID of the resource pool to put this virtual machine in.
               See the section on virtual machine migration
               for details on changing this value.
        :param pulumi.Input[bool] run_tools_scripts_after_power_on: Enable the execution of
               post-power-on scripts when VMware tools is installed. Default: `true`.
        :param pulumi.Input[bool] run_tools_scripts_after_resume: Enable the execution of
               post-resume scripts when VMware tools is installed. Default: `true`.
        :param pulumi.Input[bool] run_tools_scripts_before_guest_reboot: Enable the execution of
               pre-reboot scripts when VMware tools is installed. Default: `false`.
        :param pulumi.Input[bool] run_tools_scripts_before_guest_shutdown: Enable the execution
               of pre-shutdown scripts when VMware tools is installed. Default: `true`.
        :param pulumi.Input[bool] run_tools_scripts_before_guest_standby: Enable the execution of
               pre-standby scripts when VMware tools is installed. Default: `true`.
        :param pulumi.Input[str] scsi_bus_sharing: Mode for sharing the SCSI bus. The modes are
               physicalSharing, virtualSharing, and noSharing. Default: `noSharing`.
        :param pulumi.Input[float] scsi_controller_count: The number of SCSI controllers that
               this provider manages on this virtual machine. This directly affects the amount
               of disks you can add to the virtual machine and the maximum disk unit number.
               Note that lowering this value does not remove controllers. Default: `1`.
        :param pulumi.Input[str] scsi_type: The type of SCSI bus this virtual machine will have.
               Can be one of lsilogic (LSI Logic Parallel), lsilogic-sas (LSI Logic SAS) or
               pvscsi (VMware Paravirtual). Defualt: `pvscsi`.
        :param pulumi.Input[float] shutdown_wait_timeout: The amount of time, in minutes, to wait
               for a graceful guest shutdown when making necessary updates to the virtual
               machine. If `force_power_off` is set to true, the VM will be force powered-off
               after this timeout, otherwise an error is returned. Default: 3 minutes.
        :param pulumi.Input[str] storage_policy_id: The UUID of the storage policy to assign to this disk.
        :param pulumi.Input[str] swap_placement_policy: The swap file placement policy for this
               virtual machine. Can be one of `inherit`, `hostLocal`, or `vmDirectory`.
               Default: `inherit`.
        :param pulumi.Input[bool] sync_time_with_host: Enable guest clock synchronization with
               the host. Requires VMware tools to be installed. Default: `false`.
        :param pulumi.Input[list] tags: The IDs of any tags to attach to this resource. 
        :param pulumi.Input[dict] vapp: Optional vApp configuration. The only sub-key available
               is `properties`, which is a key/value map of properties for virtual machines
               imported from OVF or OVA files. See Using vApp properties to supply OVF/OVA
               configuration for
               more details.
        :param pulumi.Input[float] wait_for_guest_ip_timeout: The amount of time, in minutes, to
               wait for an available guest IP address on this virtual machine. This should
               only be used if your version of VMware Tools does not allow the
               `wait_for_guest_net_timeout` waiter to be
               used. A value less than 1 disables the waiter. Default: 0.
        :param pulumi.Input[bool] wait_for_guest_net_routable: Controls whether or not the guest
               network waiter waits for a routable address. When `false`, the waiter does
               not wait for a default gateway, nor are IP addresses checked against any
               discovered default gateways as part of its success criteria. This property is
               ignored if the `wait_for_guest_ip_timeout`
               waiter is used. Default: `true`.
        :param pulumi.Input[float] wait_for_guest_net_timeout: The amount of time, in minutes, to
               wait for an available IP address on this virtual machine's NICs. Older
               versions of VMware Tools do not populate this property. In those cases, this
               waiter can be disabled and the
               `wait_for_guest_ip_timeout` waiter can be used
               instead. A value less than 1 disables the waiter. Default: 5 minutes.

        The **cdrom** object supports the following:

          * `clientDevice` (`pulumi.Input[bool]`) - Indicates whether the device should be backed by
            remote client device. Conflicts with `datastore_id` and `path`.
          * `datastore_id` (`pulumi.Input[str]`) - The datastore ID that the ISO is located in.
            Requried for using a datastore ISO. Conflicts with `client_device`.
          * `deviceAddress` (`pulumi.Input[str]`) - An address internal to this provider that helps locate the
            device when `key` is unavailable. This follows a convention of
            `CONTROLLER_TYPE:BUS_NUMBER:UNIT_NUMBER`. Example: `scsi:0:1` means device
            unit 1 on SCSI bus 0.
          * `key` (`pulumi.Input[float]`) - The ID of the device within the virtual machine.
          * `path` (`pulumi.Input[str]`) - The path to the ISO file. Required for using a datastore
            ISO. Conflicts with `client_device`.

        The **clone** object supports the following:

          * `customize` (`pulumi.Input[dict]`)
            * `dnsServerLists` (`pulumi.Input[list]`)
            * `dnsSuffixLists` (`pulumi.Input[list]`)
            * `ipv4Gateway` (`pulumi.Input[str]`)
            * `ipv6Gateway` (`pulumi.Input[str]`)
            * `linuxOptions` (`pulumi.Input[dict]`)
              * `domain` (`pulumi.Input[str]`)
              * `hostName` (`pulumi.Input[str]`)
              * `hwClockUtc` (`pulumi.Input[bool]`)
              * `timeZone` (`pulumi.Input[str]`)

            * `network_interfaces` (`pulumi.Input[list]`) - A specification for a virtual NIC on this
              virtual machine. See network interface options
              below.
              * `dnsDomain` (`pulumi.Input[str]`)
              * `dnsServerLists` (`pulumi.Input[list]`)
              * `ipv4_address` (`pulumi.Input[str]`)
              * `ipv4Netmask` (`pulumi.Input[float]`)
              * `ipv6Address` (`pulumi.Input[str]`)
              * `ipv6Netmask` (`pulumi.Input[float]`)

            * `timeout` (`pulumi.Input[float]`)
            * `windowsOptions` (`pulumi.Input[dict]`)
              * `adminPassword` (`pulumi.Input[str]`)
              * `autoLogon` (`pulumi.Input[bool]`)
              * `autoLogonCount` (`pulumi.Input[float]`)
              * `computerName` (`pulumi.Input[str]`)
              * `domainAdminPassword` (`pulumi.Input[str]`)
              * `domainAdminUser` (`pulumi.Input[str]`)
              * `fullName` (`pulumi.Input[str]`)
              * `joinDomain` (`pulumi.Input[str]`)
              * `organizationName` (`pulumi.Input[str]`)
              * `productKey` (`pulumi.Input[str]`)
              * `runOnceCommandLists` (`pulumi.Input[list]`)
              * `timeZone` (`pulumi.Input[float]`)
              * `workgroup` (`pulumi.Input[str]`)

            * `windowsSysprepText` (`pulumi.Input[str]`)

          * `linkedClone` (`pulumi.Input[bool]`)
          * `ovfNetworkMap` (`pulumi.Input[dict]`)
          * `ovfStorageMap` (`pulumi.Input[dict]`)
          * `templateUuid` (`pulumi.Input[str]`)
          * `timeout` (`pulumi.Input[float]`)

        The **disks** object supports the following:

          * `attach` (`pulumi.Input[bool]`) - Attach an external disk instead of creating a new one.
            Implies and conflicts with `keep_on_remove`. If set, you cannot set `size`,
            `eagerly_scrub`, or `thin_provisioned`. Must set `path` if used.
          * `datastore_id` (`pulumi.Input[str]`) - The datastore ID that the ISO is located in.
            Requried for using a datastore ISO. Conflicts with `client_device`.
          * `deviceAddress` (`pulumi.Input[str]`) - An address internal to this provider that helps locate the
            device when `key` is unavailable. This follows a convention of
            `CONTROLLER_TYPE:BUS_NUMBER:UNIT_NUMBER`. Example: `scsi:0:1` means device
            unit 1 on SCSI bus 0.
          * `diskMode` (`pulumi.Input[str]`) - The mode of this this virtual disk for purposes of
            writes and snapshotting. Can be one of `append`, `independent_nonpersistent`,
            `independent_persistent`, `nonpersistent`, `persistent`, or `undoable`.
            Default: `persistent`. For an explanation of options, click
            [here][vmware-docs-disk-mode].
          * `diskSharing` (`pulumi.Input[str]`) - The sharing mode of this virtual disk. Can be one
            of `sharingMultiWriter` or `sharingNone`. Default: `sharingNone`.
          * `eagerlyScrub` (`pulumi.Input[bool]`) - If set to `true`, the disk space is zeroed out
            on VM creation. This will delay the creation of the disk or virtual machine.
            Cannot be set to `true` when `thin_provisioned` is `true`.  See the section
            on picking a disk type.  Default: `false`.
          * `ioLimit` (`pulumi.Input[float]`) - The upper limit of IOPS that this disk can use. The
            default is no limit.
          * `ioReservation` (`pulumi.Input[float]`) - The I/O reservation (guarantee) that this disk
            has, in IOPS.  The default is no reservation.
          * `ioShareCount` (`pulumi.Input[float]`) - The share count for this disk when the share
            level is `custom`.
          * `ioShareLevel` (`pulumi.Input[str]`) - The share allocation level for this disk. Can
            be one of `low`, `normal`, `high`, or `custom`. Default: `normal`.
          * `keepOnRemove` (`pulumi.Input[bool]`) - Keep this disk when removing the device or
            destroying the virtual machine. Default: `false`.
          * `key` (`pulumi.Input[float]`) - The ID of the device within the virtual machine.
          * `label` (`pulumi.Input[str]`) - A label for the disk. Forces a new disk if changed.
          * `name` (`pulumi.Input[str]`) - An alias for both `label` and `path`, the latter when
            using `attach`. Required if not using `label`.
          * `path` (`pulumi.Input[str]`) - The path to the ISO file. Required for using a datastore
            ISO. Conflicts with `client_device`.
          * `size` (`pulumi.Input[float]`) - The size of the disk, in GB.
          * `storage_policy_id` (`pulumi.Input[str]`) - The UUID of the storage policy to assign to this disk.
          * `thinProvisioned` (`pulumi.Input[bool]`) - If `true`, this disk is thin provisioned,
            with space for the file being allocated on an as-needed basis. Cannot be set
            to `true` when `eagerly_scrub` is `true`. See the section on picking a disk
            type. Default: `true`.
          * `unitNumber` (`pulumi.Input[float]`) - The disk number on the SCSI bus. The maximum value
            for this setting is the value of
            `scsi_controller_count` times 15, minus 1 (so `14`,
            `29`, `44`, and `59`, for 1-4 controllers respectively). The default is `0`,
            for which one disk must be set to. Duplicate unit numbers are not allowed.
          * `uuid` (`pulumi.Input[str]`) - The UUID of the virtual disk's VMDK file. This is used to track the
            virtual disk on the virtual machine.
          * `writeThrough` (`pulumi.Input[bool]`) - If `true`, writes for this disk are sent
            directly to the filesystem immediately instead of being buffered. Default:
            `false`.

        The **network_interfaces** object supports the following:

          * `adapter_type` (`pulumi.Input[str]`) - The network interface type. Can be one of
            `e1000`, `e1000e`, or `vmxnet3`. Default: `vmxnet3`.
          * `bandwidthLimit` (`pulumi.Input[float]`) - The upper bandwidth limit of this network
            interface, in Mbits/sec. The default is no limit.
          * `bandwidthReservation` (`pulumi.Input[float]`) - The bandwidth reservation of this
            network interface, in Mbits/sec. The default is no reservation.
          * `bandwidthShareCount` (`pulumi.Input[float]`) - The share count for this network
            interface when the share level is `custom`.
          * `bandwidthShareLevel` (`pulumi.Input[str]`) - The bandwidth share allocation level for
            this interface. Can be one of `low`, `normal`, `high`, or `custom`. Default:
            `normal`.
          * `deviceAddress` (`pulumi.Input[str]`) - An address internal to this provider that helps locate the
            device when `key` is unavailable. This follows a convention of
            `CONTROLLER_TYPE:BUS_NUMBER:UNIT_NUMBER`. Example: `scsi:0:1` means device
            unit 1 on SCSI bus 0.
          * `key` (`pulumi.Input[float]`) - The ID of the device within the virtual machine.
          * `macAddress` (`pulumi.Input[str]`) - The MAC address of this network interface. Can
            only be manually set if `use_static_mac` is true, otherwise this is a
            computed value that gives the current MAC address of this interface.
          * `networkId` (`pulumi.Input[str]`) - The managed object reference
            ID of the network to connect this interface to.
          * `ovfMapping` (`pulumi.Input[str]`) - Specifies which OVF NIC the `network_interface`
            should be associated with. Only applies at creation and only when deploying
            from an OVF source.
          * `useStaticMac` (`pulumi.Input[bool]`) - If true, the `mac_address` field is treated as
            a static MAC address and set accordingly. Setting this to `true` requires
            `mac_address` to be set. Default: `false`.

        The **ovf_deploy** object supports the following:

          * `diskProvisioning` (`pulumi.Input[str]`)
          * `ipAllocationPolicy` (`pulumi.Input[str]`)
          * `ipProtocol` (`pulumi.Input[str]`)
          * `localOvfPath` (`pulumi.Input[str]`)
          * `ovfNetworkMap` (`pulumi.Input[dict]`)
          * `remoteOvfUrl` (`pulumi.Input[str]`)

        The **vapp** object supports the following:

          * `properties` (`pulumi.Input[dict]`)
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['alternate_guest_name'] = alternate_guest_name
            __props__['annotation'] = annotation
            __props__['boot_delay'] = boot_delay
            __props__['boot_retry_delay'] = boot_retry_delay
            __props__['boot_retry_enabled'] = boot_retry_enabled
            __props__['cdrom'] = cdrom
            __props__['clone'] = clone
            __props__['cpu_hot_add_enabled'] = cpu_hot_add_enabled
            __props__['cpu_hot_remove_enabled'] = cpu_hot_remove_enabled
            __props__['cpu_limit'] = cpu_limit
            __props__['cpu_performance_counters_enabled'] = cpu_performance_counters_enabled
            __props__['cpu_reservation'] = cpu_reservation
            __props__['cpu_share_count'] = cpu_share_count
            __props__['cpu_share_level'] = cpu_share_level
            __props__['custom_attributes'] = custom_attributes
            __props__['datacenter_id'] = datacenter_id
            __props__['datastore_cluster_id'] = datastore_cluster_id
            __props__['datastore_id'] = datastore_id
            __props__['disks'] = disks
            __props__['efi_secure_boot_enabled'] = efi_secure_boot_enabled
            __props__['enable_disk_uuid'] = enable_disk_uuid
            __props__['enable_logging'] = enable_logging
            __props__['ept_rvi_mode'] = ept_rvi_mode
            __props__['extra_config'] = extra_config
            __props__['firmware'] = firmware
            __props__['folder'] = folder
            __props__['force_power_off'] = force_power_off
            __props__['guest_id'] = guest_id
            __props__['hardware_version'] = hardware_version
            __props__['host_system_id'] = host_system_id
            __props__['hv_mode'] = hv_mode
            __props__['ignored_guest_ips'] = ignored_guest_ips
            __props__['latency_sensitivity'] = latency_sensitivity
            __props__['memory'] = memory
            __props__['memory_hot_add_enabled'] = memory_hot_add_enabled
            __props__['memory_limit'] = memory_limit
            __props__['memory_reservation'] = memory_reservation
            __props__['memory_share_count'] = memory_share_count
            __props__['memory_share_level'] = memory_share_level
            __props__['migrate_wait_timeout'] = migrate_wait_timeout
            __props__['name'] = name
            __props__['nested_hv_enabled'] = nested_hv_enabled
            __props__['network_interfaces'] = network_interfaces
            __props__['num_cores_per_socket'] = num_cores_per_socket
            __props__['num_cpus'] = num_cpus
            __props__['ovf_deploy'] = ovf_deploy
            __props__['poweron_timeout'] = poweron_timeout
            if resource_pool_id is None:
                raise TypeError("Missing required property 'resource_pool_id'")
            __props__['resource_pool_id'] = resource_pool_id
            __props__['run_tools_scripts_after_power_on'] = run_tools_scripts_after_power_on
            __props__['run_tools_scripts_after_resume'] = run_tools_scripts_after_resume
            __props__['run_tools_scripts_before_guest_reboot'] = run_tools_scripts_before_guest_reboot
            __props__['run_tools_scripts_before_guest_shutdown'] = run_tools_scripts_before_guest_shutdown
            __props__['run_tools_scripts_before_guest_standby'] = run_tools_scripts_before_guest_standby
            __props__['scsi_bus_sharing'] = scsi_bus_sharing
            __props__['scsi_controller_count'] = scsi_controller_count
            __props__['scsi_type'] = scsi_type
            __props__['shutdown_wait_timeout'] = shutdown_wait_timeout
            __props__['storage_policy_id'] = storage_policy_id
            __props__['swap_placement_policy'] = swap_placement_policy
            __props__['sync_time_with_host'] = sync_time_with_host
            __props__['tags'] = tags
            __props__['vapp'] = vapp
            __props__['wait_for_guest_ip_timeout'] = wait_for_guest_ip_timeout
            __props__['wait_for_guest_net_routable'] = wait_for_guest_net_routable
            __props__['wait_for_guest_net_timeout'] = wait_for_guest_net_timeout
            __props__['change_version'] = None
            __props__['default_ip_address'] = None
            __props__['guest_ip_addresses'] = None
            __props__['imported'] = None
            __props__['moid'] = None
            __props__['reboot_required'] = None
            __props__['uuid'] = None
            __props__['vapp_transports'] = None
            __props__['vmware_tools_status'] = None
            __props__['vmx_path'] = None
        super(VirtualMachine, __self__).__init__(
            'vsphere:index/virtualMachine:VirtualMachine',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, alternate_guest_name=None, annotation=None, boot_delay=None, boot_retry_delay=None, boot_retry_enabled=None, cdrom=None, change_version=None, clone=None, cpu_hot_add_enabled=None, cpu_hot_remove_enabled=None, cpu_limit=None, cpu_performance_counters_enabled=None, cpu_reservation=None, cpu_share_count=None, cpu_share_level=None, custom_attributes=None, datacenter_id=None, datastore_cluster_id=None, datastore_id=None, default_ip_address=None, disks=None, efi_secure_boot_enabled=None, enable_disk_uuid=None, enable_logging=None, ept_rvi_mode=None, extra_config=None, firmware=None, folder=None, force_power_off=None, guest_id=None, guest_ip_addresses=None, hardware_version=None, host_system_id=None, hv_mode=None, ignored_guest_ips=None, imported=None, latency_sensitivity=None, memory=None, memory_hot_add_enabled=None, memory_limit=None, memory_reservation=None, memory_share_count=None, memory_share_level=None, migrate_wait_timeout=None, moid=None, name=None, nested_hv_enabled=None, network_interfaces=None, num_cores_per_socket=None, num_cpus=None, ovf_deploy=None, poweron_timeout=None, reboot_required=None, resource_pool_id=None, run_tools_scripts_after_power_on=None, run_tools_scripts_after_resume=None, run_tools_scripts_before_guest_reboot=None, run_tools_scripts_before_guest_shutdown=None, run_tools_scripts_before_guest_standby=None, scsi_bus_sharing=None, scsi_controller_count=None, scsi_type=None, shutdown_wait_timeout=None, storage_policy_id=None, swap_placement_policy=None, sync_time_with_host=None, tags=None, uuid=None, vapp=None, vapp_transports=None, vmware_tools_status=None, vmx_path=None, wait_for_guest_ip_timeout=None, wait_for_guest_net_routable=None, wait_for_guest_net_timeout=None):
        """
        Get an existing VirtualMachine resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] alternate_guest_name: The guest name for the operating system
               when `guest_id` is `other` or `other-64`.
        :param pulumi.Input[str] annotation: A user-provided description of the virtual machine.
               The default is no annotation.
        :param pulumi.Input[float] boot_delay: The number of milliseconds to wait before starting
               the boot sequence. The default is no delay.
        :param pulumi.Input[float] boot_retry_delay: The number of milliseconds to wait before
               retrying the boot sequence. This only valid if `boot_retry_enabled` is true.
               Default: `10000` (10 seconds).
        :param pulumi.Input[bool] boot_retry_enabled: If set to true, a virtual machine that
               fails to boot will try again after the delay defined in `boot_retry_delay`.
               Default: `false`.
        :param pulumi.Input[dict] cdrom: A specification for a CDROM device on this virtual
               machine. See CDROM options below.
        :param pulumi.Input[str] change_version: A unique identifier for a given version of the last
               configuration applied, such the timestamp of the last update to the
               configuration.
        :param pulumi.Input[dict] clone: When specified, the VM will be created as a clone of a
               specified template. Optional customization options can be submitted as well.
               See creating a virtual machine from a
               template for more details.
        :param pulumi.Input[bool] cpu_hot_add_enabled: Allow CPUs to be added to this virtual
               machine while it is running.
        :param pulumi.Input[bool] cpu_hot_remove_enabled: Allow CPUs to be removed to this
               virtual machine while it is running.
        :param pulumi.Input[float] cpu_limit: The maximum amount of CPU (in MHz) that this virtual
               machine can consume, regardless of available resources. The default is no
               limit.
        :param pulumi.Input[bool] cpu_performance_counters_enabled: Enable CPU performance
               counters on this virtual machine. Default: `false`.
        :param pulumi.Input[float] cpu_reservation: The amount of CPU (in MHz) that this virtual
               machine is guaranteed. The default is no reservation.
        :param pulumi.Input[float] cpu_share_count: The number of CPU shares allocated to the
               virtual machine when the `cpu_share_level` is `custom`.
        :param pulumi.Input[str] cpu_share_level: The allocation level for CPU resources. Can be
               one of `high`, `low`, `normal`, or `custom`. Default: `custom`.
        :param pulumi.Input[dict] custom_attributes: Map of custom attribute ids to attribute
               value strings to set for virtual machine.
        :param pulumi.Input[str] datacenter_id: The datacenter id. Required only when deploying
               an ovf template.
        :param pulumi.Input[str] datastore_cluster_id: The managed object reference
               ID of the datastore cluster ID to use. This setting
               applies to entire virtual machine and implies that you wish to use Storage
               DRS with this virtual machine. See the section on virtual machine
               migration for details on changing this value.
        :param pulumi.Input[str] datastore_id: The datastore ID that the ISO is located in.
               Requried for using a datastore ISO. Conflicts with `client_device`.
        :param pulumi.Input[str] default_ip_address: The IP address selected by the provider to be used with
               any provisioners configured on this resource.
               Whenever possible, this is the first IPv4 address that is reachable through
               the default gateway configured on the machine, then the first reachable IPv6
               address, and then the first general discovered address if neither exist. If
               VMware tools is not running on the virtual machine, or if the VM is powered
               off, this value will be blank.
        :param pulumi.Input[list] disks: A specification for a virtual disk device on this virtual
               machine. See disk options below.
        :param pulumi.Input[bool] efi_secure_boot_enabled: When the `firmware` type is set to is
               `efi`, this enables EFI secure boot. Default: `false`.
        :param pulumi.Input[bool] enable_disk_uuid: Expose the UUIDs of attached virtual disks to
               the virtual machine, allowing access to them in the guest. Default: `false`.
        :param pulumi.Input[bool] enable_logging: Enable logging of virtual machine events to a
               log file stored in the virtual machine directory. Default: `false`.
        :param pulumi.Input[str] ept_rvi_mode: The EPT/RVI (hardware memory virtualization)
               setting for this virtual machine. Can be one of `automatic`, `on`, or `off`.
               Default: `automatic`.
        :param pulumi.Input[dict] extra_config: Extra configuration data for this virtual
               machine. Can be used to supply advanced parameters not normally in
               configuration, such as instance metadata.
        :param pulumi.Input[str] firmware: The firmware interface to use on the virtual machine.
               Can be one of `bios` or `EFI`. Default: `bios`.
        :param pulumi.Input[str] folder: The path to the folder to put this virtual machine in,
               relative to the datacenter that the resource pool is in.
        :param pulumi.Input[bool] force_power_off: If a guest shutdown failed or timed out while
               updating or destroying (see
               `shutdown_wait_timeout`), force the power-off of
               the virtual machine. Default: `true`.
        :param pulumi.Input[str] guest_id: The guest ID for the operating system type. For a
               full list of possible values, see [here][vmware-docs-guest-ids]. Default: `other-64`.
        :param pulumi.Input[list] guest_ip_addresses: The current list of IP addresses on this machine,
               including the value of `default_ip_address`. If VMware tools is not running
               on the virtual machine, or if the VM is powered off, this list will be empty.
               * `moid`: The managed object reference ID of the created
               virtual machine.
        :param pulumi.Input[float] hardware_version: The hardware version number. Valid range
               is from 4 to 15. The hardware version cannot be downgraded. See [virtual
               machine hardware compatibility][virtual-machine-hardware-compatibility] for
               more details.
        :param pulumi.Input[str] host_system_id: An optional managed object reference
               ID of a host to put this virtual machine on. See the
               section on virtual machine migration for
               details on changing this value. If a `host_system_id` is not supplied,
               vSphere will select a host in the resource pool to place the virtual machine,
               according to any defaults or DRS policies in place.
        :param pulumi.Input[str] hv_mode: The (non-nested) hardware virtualization setting for
               this virtual machine. Can be one of `hvAuto`, `hvOn`, or `hvOff`. Default:
               `hvAuto`.
        :param pulumi.Input[list] ignored_guest_ips: List of IP addresses and CIDR networks to
               ignore while waiting for an available IP address using either of the waiters.
               Any IP addresses in this list will be ignored if they show up so that the
               waiter will continue to wait for a real IP address. Default: [].
        :param pulumi.Input[bool] imported: This is flagged if the virtual machine has been imported, or the
               state has been migrated from a previous version of the resource. It
               influences the behavior of the first post-import apply operation. See the
               section on importing below.
        :param pulumi.Input[str] latency_sensitivity: Controls the scheduling delay of the
               virtual machine. Use a higher sensitivity for applications that require lower
               latency, such as VOIP, media player applications, or applications that
               require frequent access to mouse or keyboard devices. Can be one of `low`,
               `normal`, `medium`, or `high`.
        :param pulumi.Input[float] memory: The size of the virtual machine's memory, in MB.
               Default: `1024` (1 GB).
        :param pulumi.Input[bool] memory_hot_add_enabled: Allow memory to be added to this
               virtual machine while it is running.
        :param pulumi.Input[float] memory_limit: The maximum amount of memory (in MB) that this
               virtual machine can consume, regardless of available resources. The default
               is no limit.
        :param pulumi.Input[float] memory_reservation: The amount of memory (in MB) that this
               virtual machine is guaranteed. The default is no reservation.
        :param pulumi.Input[float] memory_share_count: The number of memory shares allocated to
               the virtual machine when the `memory_share_level` is `custom`.
        :param pulumi.Input[str] memory_share_level: The allocation level for memory resources.
               Can be one of `high`, `low`, `normal`, or `custom`. Default: `custom`.
        :param pulumi.Input[float] migrate_wait_timeout: The amount of time, in minutes, to wait
               for a virtual machine migration to complete before failing. Default: 10
               minutes. Also see the section on virtual machine
               migration.
        :param pulumi.Input[str] moid: The machine object ID from VMWare
        :param pulumi.Input[str] name: An alias for both `label` and `path`, the latter when
               using `attach`. Required if not using `label`.
        :param pulumi.Input[bool] nested_hv_enabled: Enable nested hardware virtualization on
               this virtual machine, facilitating nested virtualization in the guest.
               Default: `false`.
        :param pulumi.Input[list] network_interfaces: A specification for a virtual NIC on this
               virtual machine. See network interface options
               below.
        :param pulumi.Input[float] num_cores_per_socket: The number of cores per socket in this
               virtual machine. The number of vCPUs on the virtual machine will be
               `num_cpus` divided by `num_cores_per_socket`. If specified, the value
               supplied to `num_cpus` must be evenly divisible by this value. Default: `1`.
        :param pulumi.Input[float] num_cpus: The total number of virtual processor cores to assign
               to this virtual machine. Default: `1`.
        :param pulumi.Input[dict] ovf_deploy: When specified, the VM will be deployed from the
               provided ovf template. See creating a virtual machine from a
               ovf template for more details.
        :param pulumi.Input[float] poweron_timeout: The amount of time, in seconds, that we will be trying to power on a VM
        :param pulumi.Input[bool] reboot_required: Value internal to the provider used to determine if a
               configuration set change requires a reboot. This value is only useful during
               an update process and gets reset on refresh.
        :param pulumi.Input[str] resource_pool_id: The managed object reference
               ID of the resource pool to put this virtual machine in.
               See the section on virtual machine migration
               for details on changing this value.
        :param pulumi.Input[bool] run_tools_scripts_after_power_on: Enable the execution of
               post-power-on scripts when VMware tools is installed. Default: `true`.
        :param pulumi.Input[bool] run_tools_scripts_after_resume: Enable the execution of
               post-resume scripts when VMware tools is installed. Default: `true`.
        :param pulumi.Input[bool] run_tools_scripts_before_guest_reboot: Enable the execution of
               pre-reboot scripts when VMware tools is installed. Default: `false`.
        :param pulumi.Input[bool] run_tools_scripts_before_guest_shutdown: Enable the execution
               of pre-shutdown scripts when VMware tools is installed. Default: `true`.
        :param pulumi.Input[bool] run_tools_scripts_before_guest_standby: Enable the execution of
               pre-standby scripts when VMware tools is installed. Default: `true`.
        :param pulumi.Input[str] scsi_bus_sharing: Mode for sharing the SCSI bus. The modes are
               physicalSharing, virtualSharing, and noSharing. Default: `noSharing`.
        :param pulumi.Input[float] scsi_controller_count: The number of SCSI controllers that
               this provider manages on this virtual machine. This directly affects the amount
               of disks you can add to the virtual machine and the maximum disk unit number.
               Note that lowering this value does not remove controllers. Default: `1`.
        :param pulumi.Input[str] scsi_type: The type of SCSI bus this virtual machine will have.
               Can be one of lsilogic (LSI Logic Parallel), lsilogic-sas (LSI Logic SAS) or
               pvscsi (VMware Paravirtual). Defualt: `pvscsi`.
        :param pulumi.Input[float] shutdown_wait_timeout: The amount of time, in minutes, to wait
               for a graceful guest shutdown when making necessary updates to the virtual
               machine. If `force_power_off` is set to true, the VM will be force powered-off
               after this timeout, otherwise an error is returned. Default: 3 minutes.
        :param pulumi.Input[str] storage_policy_id: The UUID of the storage policy to assign to this disk.
        :param pulumi.Input[str] swap_placement_policy: The swap file placement policy for this
               virtual machine. Can be one of `inherit`, `hostLocal`, or `vmDirectory`.
               Default: `inherit`.
        :param pulumi.Input[bool] sync_time_with_host: Enable guest clock synchronization with
               the host. Requires VMware tools to be installed. Default: `false`.
        :param pulumi.Input[list] tags: The IDs of any tags to attach to this resource. 
        :param pulumi.Input[str] uuid: The UUID of the virtual disk's VMDK file. This is used to track the
               virtual disk on the virtual machine.
        :param pulumi.Input[dict] vapp: Optional vApp configuration. The only sub-key available
               is `properties`, which is a key/value map of properties for virtual machines
               imported from OVF or OVA files. See Using vApp properties to supply OVF/OVA
               configuration for
               more details.
        :param pulumi.Input[list] vapp_transports: Computed value which is only valid for cloned virtual
               machines. A list of vApp transport methods supported by the source virtual
               machine or template.
        :param pulumi.Input[str] vmware_tools_status: The state of VMware tools in the guest. This will
               determine the proper course of action for some device operations.
        :param pulumi.Input[str] vmx_path: The path of the virtual machine's configuration file in the VM's
               datastore.
        :param pulumi.Input[float] wait_for_guest_ip_timeout: The amount of time, in minutes, to
               wait for an available guest IP address on this virtual machine. This should
               only be used if your version of VMware Tools does not allow the
               `wait_for_guest_net_timeout` waiter to be
               used. A value less than 1 disables the waiter. Default: 0.
        :param pulumi.Input[bool] wait_for_guest_net_routable: Controls whether or not the guest
               network waiter waits for a routable address. When `false`, the waiter does
               not wait for a default gateway, nor are IP addresses checked against any
               discovered default gateways as part of its success criteria. This property is
               ignored if the `wait_for_guest_ip_timeout`
               waiter is used. Default: `true`.
        :param pulumi.Input[float] wait_for_guest_net_timeout: The amount of time, in minutes, to
               wait for an available IP address on this virtual machine's NICs. Older
               versions of VMware Tools do not populate this property. In those cases, this
               waiter can be disabled and the
               `wait_for_guest_ip_timeout` waiter can be used
               instead. A value less than 1 disables the waiter. Default: 5 minutes.

        The **cdrom** object supports the following:

          * `clientDevice` (`pulumi.Input[bool]`) - Indicates whether the device should be backed by
            remote client device. Conflicts with `datastore_id` and `path`.
          * `datastore_id` (`pulumi.Input[str]`) - The datastore ID that the ISO is located in.
            Requried for using a datastore ISO. Conflicts with `client_device`.
          * `deviceAddress` (`pulumi.Input[str]`) - An address internal to this provider that helps locate the
            device when `key` is unavailable. This follows a convention of
            `CONTROLLER_TYPE:BUS_NUMBER:UNIT_NUMBER`. Example: `scsi:0:1` means device
            unit 1 on SCSI bus 0.
          * `key` (`pulumi.Input[float]`) - The ID of the device within the virtual machine.
          * `path` (`pulumi.Input[str]`) - The path to the ISO file. Required for using a datastore
            ISO. Conflicts with `client_device`.

        The **clone** object supports the following:

          * `customize` (`pulumi.Input[dict]`)
            * `dnsServerLists` (`pulumi.Input[list]`)
            * `dnsSuffixLists` (`pulumi.Input[list]`)
            * `ipv4Gateway` (`pulumi.Input[str]`)
            * `ipv6Gateway` (`pulumi.Input[str]`)
            * `linuxOptions` (`pulumi.Input[dict]`)
              * `domain` (`pulumi.Input[str]`)
              * `hostName` (`pulumi.Input[str]`)
              * `hwClockUtc` (`pulumi.Input[bool]`)
              * `timeZone` (`pulumi.Input[str]`)

            * `network_interfaces` (`pulumi.Input[list]`) - A specification for a virtual NIC on this
              virtual machine. See network interface options
              below.
              * `dnsDomain` (`pulumi.Input[str]`)
              * `dnsServerLists` (`pulumi.Input[list]`)
              * `ipv4_address` (`pulumi.Input[str]`)
              * `ipv4Netmask` (`pulumi.Input[float]`)
              * `ipv6Address` (`pulumi.Input[str]`)
              * `ipv6Netmask` (`pulumi.Input[float]`)

            * `timeout` (`pulumi.Input[float]`)
            * `windowsOptions` (`pulumi.Input[dict]`)
              * `adminPassword` (`pulumi.Input[str]`)
              * `autoLogon` (`pulumi.Input[bool]`)
              * `autoLogonCount` (`pulumi.Input[float]`)
              * `computerName` (`pulumi.Input[str]`)
              * `domainAdminPassword` (`pulumi.Input[str]`)
              * `domainAdminUser` (`pulumi.Input[str]`)
              * `fullName` (`pulumi.Input[str]`)
              * `joinDomain` (`pulumi.Input[str]`)
              * `organizationName` (`pulumi.Input[str]`)
              * `productKey` (`pulumi.Input[str]`)
              * `runOnceCommandLists` (`pulumi.Input[list]`)
              * `timeZone` (`pulumi.Input[float]`)
              * `workgroup` (`pulumi.Input[str]`)

            * `windowsSysprepText` (`pulumi.Input[str]`)

          * `linkedClone` (`pulumi.Input[bool]`)
          * `ovfNetworkMap` (`pulumi.Input[dict]`)
          * `ovfStorageMap` (`pulumi.Input[dict]`)
          * `templateUuid` (`pulumi.Input[str]`)
          * `timeout` (`pulumi.Input[float]`)

        The **disks** object supports the following:

          * `attach` (`pulumi.Input[bool]`) - Attach an external disk instead of creating a new one.
            Implies and conflicts with `keep_on_remove`. If set, you cannot set `size`,
            `eagerly_scrub`, or `thin_provisioned`. Must set `path` if used.
          * `datastore_id` (`pulumi.Input[str]`) - The datastore ID that the ISO is located in.
            Requried for using a datastore ISO. Conflicts with `client_device`.
          * `deviceAddress` (`pulumi.Input[str]`) - An address internal to this provider that helps locate the
            device when `key` is unavailable. This follows a convention of
            `CONTROLLER_TYPE:BUS_NUMBER:UNIT_NUMBER`. Example: `scsi:0:1` means device
            unit 1 on SCSI bus 0.
          * `diskMode` (`pulumi.Input[str]`) - The mode of this this virtual disk for purposes of
            writes and snapshotting. Can be one of `append`, `independent_nonpersistent`,
            `independent_persistent`, `nonpersistent`, `persistent`, or `undoable`.
            Default: `persistent`. For an explanation of options, click
            [here][vmware-docs-disk-mode].
          * `diskSharing` (`pulumi.Input[str]`) - The sharing mode of this virtual disk. Can be one
            of `sharingMultiWriter` or `sharingNone`. Default: `sharingNone`.
          * `eagerlyScrub` (`pulumi.Input[bool]`) - If set to `true`, the disk space is zeroed out
            on VM creation. This will delay the creation of the disk or virtual machine.
            Cannot be set to `true` when `thin_provisioned` is `true`.  See the section
            on picking a disk type.  Default: `false`.
          * `ioLimit` (`pulumi.Input[float]`) - The upper limit of IOPS that this disk can use. The
            default is no limit.
          * `ioReservation` (`pulumi.Input[float]`) - The I/O reservation (guarantee) that this disk
            has, in IOPS.  The default is no reservation.
          * `ioShareCount` (`pulumi.Input[float]`) - The share count for this disk when the share
            level is `custom`.
          * `ioShareLevel` (`pulumi.Input[str]`) - The share allocation level for this disk. Can
            be one of `low`, `normal`, `high`, or `custom`. Default: `normal`.
          * `keepOnRemove` (`pulumi.Input[bool]`) - Keep this disk when removing the device or
            destroying the virtual machine. Default: `false`.
          * `key` (`pulumi.Input[float]`) - The ID of the device within the virtual machine.
          * `label` (`pulumi.Input[str]`) - A label for the disk. Forces a new disk if changed.
          * `name` (`pulumi.Input[str]`) - An alias for both `label` and `path`, the latter when
            using `attach`. Required if not using `label`.
          * `path` (`pulumi.Input[str]`) - The path to the ISO file. Required for using a datastore
            ISO. Conflicts with `client_device`.
          * `size` (`pulumi.Input[float]`) - The size of the disk, in GB.
          * `storage_policy_id` (`pulumi.Input[str]`) - The UUID of the storage policy to assign to this disk.
          * `thinProvisioned` (`pulumi.Input[bool]`) - If `true`, this disk is thin provisioned,
            with space for the file being allocated on an as-needed basis. Cannot be set
            to `true` when `eagerly_scrub` is `true`. See the section on picking a disk
            type. Default: `true`.
          * `unitNumber` (`pulumi.Input[float]`) - The disk number on the SCSI bus. The maximum value
            for this setting is the value of
            `scsi_controller_count` times 15, minus 1 (so `14`,
            `29`, `44`, and `59`, for 1-4 controllers respectively). The default is `0`,
            for which one disk must be set to. Duplicate unit numbers are not allowed.
          * `uuid` (`pulumi.Input[str]`) - The UUID of the virtual disk's VMDK file. This is used to track the
            virtual disk on the virtual machine.
          * `writeThrough` (`pulumi.Input[bool]`) - If `true`, writes for this disk are sent
            directly to the filesystem immediately instead of being buffered. Default:
            `false`.

        The **network_interfaces** object supports the following:

          * `adapter_type` (`pulumi.Input[str]`) - The network interface type. Can be one of
            `e1000`, `e1000e`, or `vmxnet3`. Default: `vmxnet3`.
          * `bandwidthLimit` (`pulumi.Input[float]`) - The upper bandwidth limit of this network
            interface, in Mbits/sec. The default is no limit.
          * `bandwidthReservation` (`pulumi.Input[float]`) - The bandwidth reservation of this
            network interface, in Mbits/sec. The default is no reservation.
          * `bandwidthShareCount` (`pulumi.Input[float]`) - The share count for this network
            interface when the share level is `custom`.
          * `bandwidthShareLevel` (`pulumi.Input[str]`) - The bandwidth share allocation level for
            this interface. Can be one of `low`, `normal`, `high`, or `custom`. Default:
            `normal`.
          * `deviceAddress` (`pulumi.Input[str]`) - An address internal to this provider that helps locate the
            device when `key` is unavailable. This follows a convention of
            `CONTROLLER_TYPE:BUS_NUMBER:UNIT_NUMBER`. Example: `scsi:0:1` means device
            unit 1 on SCSI bus 0.
          * `key` (`pulumi.Input[float]`) - The ID of the device within the virtual machine.
          * `macAddress` (`pulumi.Input[str]`) - The MAC address of this network interface. Can
            only be manually set if `use_static_mac` is true, otherwise this is a
            computed value that gives the current MAC address of this interface.
          * `networkId` (`pulumi.Input[str]`) - The managed object reference
            ID of the network to connect this interface to.
          * `ovfMapping` (`pulumi.Input[str]`) - Specifies which OVF NIC the `network_interface`
            should be associated with. Only applies at creation and only when deploying
            from an OVF source.
          * `useStaticMac` (`pulumi.Input[bool]`) - If true, the `mac_address` field is treated as
            a static MAC address and set accordingly. Setting this to `true` requires
            `mac_address` to be set. Default: `false`.

        The **ovf_deploy** object supports the following:

          * `diskProvisioning` (`pulumi.Input[str]`)
          * `ipAllocationPolicy` (`pulumi.Input[str]`)
          * `ipProtocol` (`pulumi.Input[str]`)
          * `localOvfPath` (`pulumi.Input[str]`)
          * `ovfNetworkMap` (`pulumi.Input[dict]`)
          * `remoteOvfUrl` (`pulumi.Input[str]`)

        The **vapp** object supports the following:

          * `properties` (`pulumi.Input[dict]`)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["alternate_guest_name"] = alternate_guest_name
        __props__["annotation"] = annotation
        __props__["boot_delay"] = boot_delay
        __props__["boot_retry_delay"] = boot_retry_delay
        __props__["boot_retry_enabled"] = boot_retry_enabled
        __props__["cdrom"] = cdrom
        __props__["change_version"] = change_version
        __props__["clone"] = clone
        __props__["cpu_hot_add_enabled"] = cpu_hot_add_enabled
        __props__["cpu_hot_remove_enabled"] = cpu_hot_remove_enabled
        __props__["cpu_limit"] = cpu_limit
        __props__["cpu_performance_counters_enabled"] = cpu_performance_counters_enabled
        __props__["cpu_reservation"] = cpu_reservation
        __props__["cpu_share_count"] = cpu_share_count
        __props__["cpu_share_level"] = cpu_share_level
        __props__["custom_attributes"] = custom_attributes
        __props__["datacenter_id"] = datacenter_id
        __props__["datastore_cluster_id"] = datastore_cluster_id
        __props__["datastore_id"] = datastore_id
        __props__["default_ip_address"] = default_ip_address
        __props__["disks"] = disks
        __props__["efi_secure_boot_enabled"] = efi_secure_boot_enabled
        __props__["enable_disk_uuid"] = enable_disk_uuid
        __props__["enable_logging"] = enable_logging
        __props__["ept_rvi_mode"] = ept_rvi_mode
        __props__["extra_config"] = extra_config
        __props__["firmware"] = firmware
        __props__["folder"] = folder
        __props__["force_power_off"] = force_power_off
        __props__["guest_id"] = guest_id
        __props__["guest_ip_addresses"] = guest_ip_addresses
        __props__["hardware_version"] = hardware_version
        __props__["host_system_id"] = host_system_id
        __props__["hv_mode"] = hv_mode
        __props__["ignored_guest_ips"] = ignored_guest_ips
        __props__["imported"] = imported
        __props__["latency_sensitivity"] = latency_sensitivity
        __props__["memory"] = memory
        __props__["memory_hot_add_enabled"] = memory_hot_add_enabled
        __props__["memory_limit"] = memory_limit
        __props__["memory_reservation"] = memory_reservation
        __props__["memory_share_count"] = memory_share_count
        __props__["memory_share_level"] = memory_share_level
        __props__["migrate_wait_timeout"] = migrate_wait_timeout
        __props__["moid"] = moid
        __props__["name"] = name
        __props__["nested_hv_enabled"] = nested_hv_enabled
        __props__["network_interfaces"] = network_interfaces
        __props__["num_cores_per_socket"] = num_cores_per_socket
        __props__["num_cpus"] = num_cpus
        __props__["ovf_deploy"] = ovf_deploy
        __props__["poweron_timeout"] = poweron_timeout
        __props__["reboot_required"] = reboot_required
        __props__["resource_pool_id"] = resource_pool_id
        __props__["run_tools_scripts_after_power_on"] = run_tools_scripts_after_power_on
        __props__["run_tools_scripts_after_resume"] = run_tools_scripts_after_resume
        __props__["run_tools_scripts_before_guest_reboot"] = run_tools_scripts_before_guest_reboot
        __props__["run_tools_scripts_before_guest_shutdown"] = run_tools_scripts_before_guest_shutdown
        __props__["run_tools_scripts_before_guest_standby"] = run_tools_scripts_before_guest_standby
        __props__["scsi_bus_sharing"] = scsi_bus_sharing
        __props__["scsi_controller_count"] = scsi_controller_count
        __props__["scsi_type"] = scsi_type
        __props__["shutdown_wait_timeout"] = shutdown_wait_timeout
        __props__["storage_policy_id"] = storage_policy_id
        __props__["swap_placement_policy"] = swap_placement_policy
        __props__["sync_time_with_host"] = sync_time_with_host
        __props__["tags"] = tags
        __props__["uuid"] = uuid
        __props__["vapp"] = vapp
        __props__["vapp_transports"] = vapp_transports
        __props__["vmware_tools_status"] = vmware_tools_status
        __props__["vmx_path"] = vmx_path
        __props__["wait_for_guest_ip_timeout"] = wait_for_guest_ip_timeout
        __props__["wait_for_guest_net_routable"] = wait_for_guest_net_routable
        __props__["wait_for_guest_net_timeout"] = wait_for_guest_net_timeout
        return VirtualMachine(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

