# mypy-boto3-config

[![PyPI - mypy-boto3-config](https://img.shields.io/pypi/v/mypy-boto3-config.svg?color=blue)](https://pypi.org/project/mypy-boto3-config)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-config.svg?color=blue)](https://pypi.org/project/mypy-boto3-config)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-config?color=blue)](https://pypistats.org/packages/mypy-boto3-config)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.ConfigService 1.17.66](https://boto3.amazonaws.com/v1/documentation/api/1.17.66/reference/services/config.html#ConfigService)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-buider 4.10.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-config docs](https://github.com/vemel/mypy_boto3_builder/service_docs/mypy_boto3_config/README.md)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-config](#mypy-boto3-config)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)

## How to install

Install `boto3-stubs` for `ConfigService` service.

```bash
python -m pip install boto3-stubs[config]
```

## Usage

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[config]` in your environment:
  `python -m pip install 'boto3-stubs[config]'`

Both type checking and auto-complete should work for `ConfigService` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[config]` in your environment:
  `python -m pip install 'boto3-stubs[config]'`

Both type checking and auto-complete should work for `ConfigService` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything
should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[config]` in your environment:
  `python -m pip install 'boto3-stubs[config]'`
- Run `mypy` as usual

Type checking should work for `ConfigService` service. No explicit type
annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[config]` in your environment:
  `python -m pip install 'boto3-stubs[config]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `ConfigService` service. No explicit type
annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`ConfigServiceClient` provides annotations for `boto3.client("config")`.

```python
import boto3

from mypy_boto3_config import ConfigServiceClient

client: ConfigServiceClient = boto3.client("config")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: ConfigServiceClient = session.client("config")
```

### Paginators annotations

`mypy_boto3_config.paginator` module contains type annotations for all
paginators.

```python
from mypy_boto3_config import ConfigServiceClient
from mypy_boto3_config.paginator import (
    DescribeAggregateComplianceByConfigRulesPaginator,
    DescribeAggregationAuthorizationsPaginator,
    DescribeComplianceByConfigRulePaginator,
    DescribeComplianceByResourcePaginator,
    DescribeConfigRuleEvaluationStatusPaginator,
    DescribeConfigRulesPaginator,
    DescribeConfigurationAggregatorSourcesStatusPaginator,
    DescribeConfigurationAggregatorsPaginator,
    DescribePendingAggregationRequestsPaginator,
    DescribeRemediationExecutionStatusPaginator,
    DescribeRetentionConfigurationsPaginator,
    GetAggregateComplianceDetailsByConfigRulePaginator,
    GetComplianceDetailsByConfigRulePaginator,
    GetComplianceDetailsByResourcePaginator,
    GetResourceConfigHistoryPaginator,
    ListAggregateDiscoveredResourcesPaginator,
    ListDiscoveredResourcesPaginator,
)

client: ConfigServiceClient = boto3.client("config")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
describe_aggregate_compliance_by_config_rules_paginator: DescribeAggregateComplianceByConfigRulesPaginator = client.get_paginator("describe_aggregate_compliance_by_config_rules")
describe_aggregation_authorizations_paginator: DescribeAggregationAuthorizationsPaginator = client.get_paginator("describe_aggregation_authorizations")
describe_compliance_by_config_rule_paginator: DescribeComplianceByConfigRulePaginator = client.get_paginator("describe_compliance_by_config_rule")
describe_compliance_by_resource_paginator: DescribeComplianceByResourcePaginator = client.get_paginator("describe_compliance_by_resource")
describe_config_rule_evaluation_status_paginator: DescribeConfigRuleEvaluationStatusPaginator = client.get_paginator("describe_config_rule_evaluation_status")
describe_config_rules_paginator: DescribeConfigRulesPaginator = client.get_paginator("describe_config_rules")
describe_configuration_aggregator_sources_status_paginator: DescribeConfigurationAggregatorSourcesStatusPaginator = client.get_paginator("describe_configuration_aggregator_sources_status")
describe_configuration_aggregators_paginator: DescribeConfigurationAggregatorsPaginator = client.get_paginator("describe_configuration_aggregators")
describe_pending_aggregation_requests_paginator: DescribePendingAggregationRequestsPaginator = client.get_paginator("describe_pending_aggregation_requests")
describe_remediation_execution_status_paginator: DescribeRemediationExecutionStatusPaginator = client.get_paginator("describe_remediation_execution_status")
describe_retention_configurations_paginator: DescribeRetentionConfigurationsPaginator = client.get_paginator("describe_retention_configurations")
get_aggregate_compliance_details_by_config_rule_paginator: GetAggregateComplianceDetailsByConfigRulePaginator = client.get_paginator("get_aggregate_compliance_details_by_config_rule")
get_compliance_details_by_config_rule_paginator: GetComplianceDetailsByConfigRulePaginator = client.get_paginator("get_compliance_details_by_config_rule")
get_compliance_details_by_resource_paginator: GetComplianceDetailsByResourcePaginator = client.get_paginator("get_compliance_details_by_resource")
get_resource_config_history_paginator: GetResourceConfigHistoryPaginator = client.get_paginator("get_resource_config_history")
list_aggregate_discovered_resources_paginator: ListAggregateDiscoveredResourcesPaginator = client.get_paginator("list_aggregate_discovered_resources")
list_discovered_resources_paginator: ListDiscoveredResourcesPaginator = client.get_paginator("list_discovered_resources")
```

### Literals

`mypy_boto3_config.literals` module contains literals extracted from shapes
that can be used in user code for type checking.

```python
from mypy_boto3_config.literals import (
    AggregateConformancePackComplianceSummaryGroupKey,
    AggregatedSourceStatusType,
    AggregatedSourceType,
    ChronologicalOrder,
    ComplianceType,
    ConfigRuleComplianceSummaryGroupKey,
    ConfigRuleState,
    ConfigurationItemStatus,
    ConformancePackComplianceType,
    ConformancePackState,
    DeliveryStatus,
    DescribeAggregateComplianceByConfigRulesPaginatorName,
    DescribeAggregationAuthorizationsPaginatorName,
    DescribeComplianceByConfigRulePaginatorName,
    DescribeComplianceByResourcePaginatorName,
    DescribeConfigRuleEvaluationStatusPaginatorName,
    DescribeConfigRulesPaginatorName,
    DescribeConfigurationAggregatorSourcesStatusPaginatorName,
    DescribeConfigurationAggregatorsPaginatorName,
    DescribePendingAggregationRequestsPaginatorName,
    DescribeRemediationExecutionStatusPaginatorName,
    DescribeRetentionConfigurationsPaginatorName,
    EventSource,
    GetAggregateComplianceDetailsByConfigRulePaginatorName,
    GetComplianceDetailsByConfigRulePaginatorName,
    GetComplianceDetailsByResourcePaginatorName,
    GetResourceConfigHistoryPaginatorName,
    ListAggregateDiscoveredResourcesPaginatorName,
    ListDiscoveredResourcesPaginatorName,
    MaximumExecutionFrequency,
    MemberAccountRuleStatus,
    MessageType,
    OrganizationConfigRuleTriggerType,
    OrganizationResourceDetailedStatus,
    OrganizationResourceStatus,
    OrganizationRuleStatus,
    Owner,
    RecorderStatus,
    RemediationExecutionState,
    RemediationExecutionStepState,
    RemediationTargetType,
    ResourceCountGroupKey,
    ResourceType,
    ResourceValueType,
)

def check_value(value: AggregateConformancePackComplianceSummaryGroupKey) -> bool:
    ...
```

### Typed dictionaries

`mypy_boto3_config.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_config.type_defs import (
    AccountAggregationSourceTypeDef,
    AggregateComplianceByConfigRuleTypeDef,
    AggregateComplianceByConformancePackTypeDef,
    AggregateComplianceCountTypeDef,
    AggregateConformancePackComplianceCountTypeDef,
    AggregateConformancePackComplianceFiltersTypeDef,
    AggregateConformancePackComplianceSummaryFiltersTypeDef,
    AggregateConformancePackComplianceSummaryTypeDef,
    AggregateConformancePackComplianceTypeDef,
    AggregateEvaluationResultTypeDef,
    AggregateResourceIdentifierTypeDef,
    AggregatedSourceStatusTypeDef,
    AggregationAuthorizationTypeDef,
    BaseConfigurationItemTypeDef,
    BatchGetAggregateResourceConfigResponseTypeDef,
    BatchGetResourceConfigResponseTypeDef,
    ComplianceByConfigRuleTypeDef,
    ComplianceByResourceTypeDef,
    ComplianceContributorCountTypeDef,
    ComplianceSummaryByResourceTypeTypeDef,
    ComplianceSummaryTypeDef,
    ComplianceTypeDef,
    ConfigExportDeliveryInfoTypeDef,
    ConfigRuleComplianceFiltersTypeDef,
    ConfigRuleComplianceSummaryFiltersTypeDef,
    ConfigRuleEvaluationStatusTypeDef,
    ConfigRuleTypeDef,
    ConfigSnapshotDeliveryPropertiesTypeDef,
    ConfigStreamDeliveryInfoTypeDef,
    ConfigurationAggregatorTypeDef,
    ConfigurationItemTypeDef,
    ConfigurationRecorderStatusTypeDef,
    ConfigurationRecorderTypeDef,
    ConformancePackComplianceFiltersTypeDef,
    ConformancePackComplianceSummaryTypeDef,
    ConformancePackDetailTypeDef,
    ConformancePackEvaluationFiltersTypeDef,
    ConformancePackEvaluationResultTypeDef,
    ConformancePackInputParameterTypeDef,
    ConformancePackRuleComplianceTypeDef,
    ConformancePackStatusDetailTypeDef,
    DeleteRemediationExceptionsResponseTypeDef,
    DeliverConfigSnapshotResponseTypeDef,
    DeliveryChannelStatusTypeDef,
    DeliveryChannelTypeDef,
    DescribeAggregateComplianceByConfigRulesResponseTypeDef,
    DescribeAggregateComplianceByConformancePacksResponseTypeDef,
    DescribeAggregationAuthorizationsResponseTypeDef,
    DescribeComplianceByConfigRuleResponseTypeDef,
    DescribeComplianceByResourceResponseTypeDef,
    DescribeConfigRuleEvaluationStatusResponseTypeDef,
    DescribeConfigRulesResponseTypeDef,
    DescribeConfigurationAggregatorSourcesStatusResponseTypeDef,
    DescribeConfigurationAggregatorsResponseTypeDef,
    DescribeConfigurationRecorderStatusResponseTypeDef,
    DescribeConfigurationRecordersResponseTypeDef,
    DescribeConformancePackComplianceResponseTypeDef,
    DescribeConformancePackStatusResponseTypeDef,
    DescribeConformancePacksResponseTypeDef,
    DescribeDeliveryChannelStatusResponseTypeDef,
    DescribeDeliveryChannelsResponseTypeDef,
    DescribeOrganizationConfigRuleStatusesResponseTypeDef,
    DescribeOrganizationConfigRulesResponseTypeDef,
    DescribeOrganizationConformancePackStatusesResponseTypeDef,
    DescribeOrganizationConformancePacksResponseTypeDef,
    DescribePendingAggregationRequestsResponseTypeDef,
    DescribeRemediationConfigurationsResponseTypeDef,
    DescribeRemediationExceptionsResponseTypeDef,
    DescribeRemediationExecutionStatusResponseTypeDef,
    DescribeRetentionConfigurationsResponseTypeDef,
    EvaluationResultIdentifierTypeDef,
    EvaluationResultQualifierTypeDef,
    EvaluationResultTypeDef,
    EvaluationTypeDef,
    ExecutionControlsTypeDef,
    ExternalEvaluationTypeDef,
    FailedDeleteRemediationExceptionsBatchTypeDef,
    FailedRemediationBatchTypeDef,
    FailedRemediationExceptionBatchTypeDef,
    FieldInfoTypeDef,
    GetAggregateComplianceDetailsByConfigRuleResponseTypeDef,
    GetAggregateConfigRuleComplianceSummaryResponseTypeDef,
    GetAggregateConformancePackComplianceSummaryResponseTypeDef,
    GetAggregateDiscoveredResourceCountsResponseTypeDef,
    GetAggregateResourceConfigResponseTypeDef,
    GetComplianceDetailsByConfigRuleResponseTypeDef,
    GetComplianceDetailsByResourceResponseTypeDef,
    GetComplianceSummaryByConfigRuleResponseTypeDef,
    GetComplianceSummaryByResourceTypeResponseTypeDef,
    GetConformancePackComplianceDetailsResponseTypeDef,
    GetConformancePackComplianceSummaryResponseTypeDef,
    GetDiscoveredResourceCountsResponseTypeDef,
    GetOrganizationConfigRuleDetailedStatusResponseTypeDef,
    GetOrganizationConformancePackDetailedStatusResponseTypeDef,
    GetResourceConfigHistoryResponseTypeDef,
    GetStoredQueryResponseTypeDef,
    GroupedResourceCountTypeDef,
    ListAggregateDiscoveredResourcesResponseTypeDef,
    ListDiscoveredResourcesResponseTypeDef,
    ListStoredQueriesResponseTypeDef,
    ListTagsForResourceResponseTypeDef,
    MemberAccountStatusTypeDef,
    OrganizationAggregationSourceTypeDef,
    OrganizationConfigRuleStatusTypeDef,
    OrganizationConfigRuleTypeDef,
    OrganizationConformancePackDetailedStatusTypeDef,
    OrganizationConformancePackStatusTypeDef,
    OrganizationConformancePackTypeDef,
    OrganizationCustomRuleMetadataTypeDef,
    OrganizationManagedRuleMetadataTypeDef,
    OrganizationResourceDetailedStatusFiltersTypeDef,
    PaginatorConfigTypeDef,
    PendingAggregationRequestTypeDef,
    PutAggregationAuthorizationResponseTypeDef,
    PutConfigurationAggregatorResponseTypeDef,
    PutConformancePackResponseTypeDef,
    PutEvaluationsResponseTypeDef,
    PutOrganizationConfigRuleResponseTypeDef,
    PutOrganizationConformancePackResponseTypeDef,
    PutRemediationConfigurationsResponseTypeDef,
    PutRemediationExceptionsResponseTypeDef,
    PutRetentionConfigurationResponseTypeDef,
    PutStoredQueryResponseTypeDef,
    QueryInfoTypeDef,
    RecordingGroupTypeDef,
    RelationshipTypeDef,
    RemediationConfigurationTypeDef,
    RemediationExceptionResourceKeyTypeDef,
    RemediationExceptionTypeDef,
    RemediationExecutionStatusTypeDef,
    RemediationExecutionStepTypeDef,
    RemediationParameterValueTypeDef,
    ResourceCountFiltersTypeDef,
    ResourceCountTypeDef,
    ResourceFiltersTypeDef,
    ResourceIdentifierTypeDef,
    ResourceKeyTypeDef,
    ResourceValueTypeDef,
    RetentionConfigurationTypeDef,
    ScopeTypeDef,
    SelectAggregateResourceConfigResponseTypeDef,
    SelectResourceConfigResponseTypeDef,
    SourceDetailTypeDef,
    SourceTypeDef,
    SsmControlsTypeDef,
    StartRemediationExecutionResponseTypeDef,
    StaticValueTypeDef,
    StatusDetailFiltersTypeDef,
    StoredQueryMetadataTypeDef,
    StoredQueryTypeDef,
    TagTypeDef,
)

def get_structure() -> AccountAggregationSourceTypeDef:
    return {
      ...
    }
```
