import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CertificateConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/acme/r/certificate#account_key_pem Certificate#account_key_pem}
    */
    readonly accountKeyPem: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/acme/r/certificate#certificate_p12_password Certificate#certificate_p12_password}
    */
    readonly certificateP12Password?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/acme/r/certificate#certificate_request_pem Certificate#certificate_request_pem}
    */
    readonly certificateRequestPem?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/acme/r/certificate#common_name Certificate#common_name}
    */
    readonly commonName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/acme/r/certificate#disable_complete_propagation Certificate#disable_complete_propagation}
    */
    readonly disableCompletePropagation?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/acme/r/certificate#id Certificate#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/acme/r/certificate#key_type Certificate#key_type}
    */
    readonly keyType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/acme/r/certificate#min_days_remaining Certificate#min_days_remaining}
    */
    readonly minDaysRemaining?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/acme/r/certificate#must_staple Certificate#must_staple}
    */
    readonly mustStaple?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/acme/r/certificate#pre_check_delay Certificate#pre_check_delay}
    */
    readonly preCheckDelay?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/acme/r/certificate#preferred_chain Certificate#preferred_chain}
    */
    readonly preferredChain?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/acme/r/certificate#recursive_nameservers Certificate#recursive_nameservers}
    */
    readonly recursiveNameservers?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/acme/r/certificate#revoke_certificate_on_destroy Certificate#revoke_certificate_on_destroy}
    */
    readonly revokeCertificateOnDestroy?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/acme/r/certificate#subject_alternative_names Certificate#subject_alternative_names}
    */
    readonly subjectAlternativeNames?: string[];
    /**
    * dns_challenge block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/acme/r/certificate#dns_challenge Certificate#dns_challenge}
    */
    readonly dnsChallenge?: CertificateDnsChallenge[] | cdktf.IResolvable;
    /**
    * http_challenge block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/acme/r/certificate#http_challenge Certificate#http_challenge}
    */
    readonly httpChallenge?: CertificateHttpChallenge;
    /**
    * http_memcached_challenge block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/acme/r/certificate#http_memcached_challenge Certificate#http_memcached_challenge}
    */
    readonly httpMemcachedChallenge?: CertificateHttpMemcachedChallenge;
    /**
    * http_webroot_challenge block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/acme/r/certificate#http_webroot_challenge Certificate#http_webroot_challenge}
    */
    readonly httpWebrootChallenge?: CertificateHttpWebrootChallenge;
    /**
    * tls_challenge block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/acme/r/certificate#tls_challenge Certificate#tls_challenge}
    */
    readonly tlsChallenge?: CertificateTlsChallenge;
}
export interface CertificateDnsChallenge {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/acme/r/certificate#config Certificate#config}
    */
    readonly config?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/acme/r/certificate#provider Certificate#provider}
    */
    readonly provider: string;
}
export declare function certificateDnsChallengeToTerraform(struct?: CertificateDnsChallenge | cdktf.IResolvable): any;
export declare class CertificateDnsChallengeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CertificateDnsChallenge | cdktf.IResolvable | undefined;
    set internalValue(value: CertificateDnsChallenge | cdktf.IResolvable | undefined);
    private _config?;
    get config(): {
        [key: string]: string;
    };
    set config(value: {
        [key: string]: string;
    });
    resetConfig(): void;
    get configInput(): {
        [key: string]: string;
    } | undefined;
    private _provider?;
    get provider(): string;
    set provider(value: string);
    get providerInput(): string | undefined;
}
export declare class CertificateDnsChallengeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CertificateDnsChallenge[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CertificateDnsChallengeOutputReference;
}
export interface CertificateHttpChallenge {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/acme/r/certificate#port Certificate#port}
    */
    readonly port?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/acme/r/certificate#proxy_header Certificate#proxy_header}
    */
    readonly proxyHeader?: string;
}
export declare function certificateHttpChallengeToTerraform(struct?: CertificateHttpChallengeOutputReference | CertificateHttpChallenge): any;
export declare class CertificateHttpChallengeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CertificateHttpChallenge | undefined;
    set internalValue(value: CertificateHttpChallenge | undefined);
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _proxyHeader?;
    get proxyHeader(): string;
    set proxyHeader(value: string);
    resetProxyHeader(): void;
    get proxyHeaderInput(): string | undefined;
}
export interface CertificateHttpMemcachedChallenge {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/acme/r/certificate#hosts Certificate#hosts}
    */
    readonly hosts: string[];
}
export declare function certificateHttpMemcachedChallengeToTerraform(struct?: CertificateHttpMemcachedChallengeOutputReference | CertificateHttpMemcachedChallenge): any;
export declare class CertificateHttpMemcachedChallengeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CertificateHttpMemcachedChallenge | undefined;
    set internalValue(value: CertificateHttpMemcachedChallenge | undefined);
    private _hosts?;
    get hosts(): string[];
    set hosts(value: string[]);
    get hostsInput(): string[] | undefined;
}
export interface CertificateHttpWebrootChallenge {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/acme/r/certificate#directory Certificate#directory}
    */
    readonly directory: string;
}
export declare function certificateHttpWebrootChallengeToTerraform(struct?: CertificateHttpWebrootChallengeOutputReference | CertificateHttpWebrootChallenge): any;
export declare class CertificateHttpWebrootChallengeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CertificateHttpWebrootChallenge | undefined;
    set internalValue(value: CertificateHttpWebrootChallenge | undefined);
    private _directory?;
    get directory(): string;
    set directory(value: string);
    get directoryInput(): string | undefined;
}
export interface CertificateTlsChallenge {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/acme/r/certificate#port Certificate#port}
    */
    readonly port?: number;
}
export declare function certificateTlsChallengeToTerraform(struct?: CertificateTlsChallengeOutputReference | CertificateTlsChallenge): any;
export declare class CertificateTlsChallengeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CertificateTlsChallenge | undefined;
    set internalValue(value: CertificateTlsChallenge | undefined);
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/acme/r/certificate acme_certificate}
*/
export declare class Certificate extends cdktf.TerraformResource {
    static readonly tfResourceType = "acme_certificate";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/acme/r/certificate acme_certificate} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CertificateConfig
    */
    constructor(scope: Construct, id: string, config: CertificateConfig);
    private _accountKeyPem?;
    get accountKeyPem(): string;
    set accountKeyPem(value: string);
    get accountKeyPemInput(): string | undefined;
    get certificateDomain(): string;
    get certificateP12(): string;
    private _certificateP12Password?;
    get certificateP12Password(): string;
    set certificateP12Password(value: string);
    resetCertificateP12Password(): void;
    get certificateP12PasswordInput(): string | undefined;
    get certificatePem(): string;
    private _certificateRequestPem?;
    get certificateRequestPem(): string;
    set certificateRequestPem(value: string);
    resetCertificateRequestPem(): void;
    get certificateRequestPemInput(): string | undefined;
    get certificateUrl(): string;
    private _commonName?;
    get commonName(): string;
    set commonName(value: string);
    resetCommonName(): void;
    get commonNameInput(): string | undefined;
    private _disableCompletePropagation?;
    get disableCompletePropagation(): boolean | cdktf.IResolvable;
    set disableCompletePropagation(value: boolean | cdktf.IResolvable);
    resetDisableCompletePropagation(): void;
    get disableCompletePropagationInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get issuerPem(): string;
    private _keyType?;
    get keyType(): string;
    set keyType(value: string);
    resetKeyType(): void;
    get keyTypeInput(): string | undefined;
    private _minDaysRemaining?;
    get minDaysRemaining(): number;
    set minDaysRemaining(value: number);
    resetMinDaysRemaining(): void;
    get minDaysRemainingInput(): number | undefined;
    private _mustStaple?;
    get mustStaple(): boolean | cdktf.IResolvable;
    set mustStaple(value: boolean | cdktf.IResolvable);
    resetMustStaple(): void;
    get mustStapleInput(): boolean | cdktf.IResolvable | undefined;
    private _preCheckDelay?;
    get preCheckDelay(): number;
    set preCheckDelay(value: number);
    resetPreCheckDelay(): void;
    get preCheckDelayInput(): number | undefined;
    private _preferredChain?;
    get preferredChain(): string;
    set preferredChain(value: string);
    resetPreferredChain(): void;
    get preferredChainInput(): string | undefined;
    get privateKeyPem(): string;
    private _recursiveNameservers?;
    get recursiveNameservers(): string[];
    set recursiveNameservers(value: string[]);
    resetRecursiveNameservers(): void;
    get recursiveNameserversInput(): string[] | undefined;
    private _revokeCertificateOnDestroy?;
    get revokeCertificateOnDestroy(): boolean | cdktf.IResolvable;
    set revokeCertificateOnDestroy(value: boolean | cdktf.IResolvable);
    resetRevokeCertificateOnDestroy(): void;
    get revokeCertificateOnDestroyInput(): boolean | cdktf.IResolvable | undefined;
    private _subjectAlternativeNames?;
    get subjectAlternativeNames(): string[];
    set subjectAlternativeNames(value: string[]);
    resetSubjectAlternativeNames(): void;
    get subjectAlternativeNamesInput(): string[] | undefined;
    private _dnsChallenge;
    get dnsChallenge(): CertificateDnsChallengeList;
    putDnsChallenge(value: CertificateDnsChallenge[] | cdktf.IResolvable): void;
    resetDnsChallenge(): void;
    get dnsChallengeInput(): cdktf.IResolvable | CertificateDnsChallenge[] | undefined;
    private _httpChallenge;
    get httpChallenge(): CertificateHttpChallengeOutputReference;
    putHttpChallenge(value: CertificateHttpChallenge): void;
    resetHttpChallenge(): void;
    get httpChallengeInput(): CertificateHttpChallenge | undefined;
    private _httpMemcachedChallenge;
    get httpMemcachedChallenge(): CertificateHttpMemcachedChallengeOutputReference;
    putHttpMemcachedChallenge(value: CertificateHttpMemcachedChallenge): void;
    resetHttpMemcachedChallenge(): void;
    get httpMemcachedChallengeInput(): CertificateHttpMemcachedChallenge | undefined;
    private _httpWebrootChallenge;
    get httpWebrootChallenge(): CertificateHttpWebrootChallengeOutputReference;
    putHttpWebrootChallenge(value: CertificateHttpWebrootChallenge): void;
    resetHttpWebrootChallenge(): void;
    get httpWebrootChallengeInput(): CertificateHttpWebrootChallenge | undefined;
    private _tlsChallenge;
    get tlsChallenge(): CertificateTlsChallengeOutputReference;
    putTlsChallenge(value: CertificateTlsChallenge): void;
    resetTlsChallenge(): void;
    get tlsChallengeInput(): CertificateTlsChallenge | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
