"""Funcy Bear: A collection of functional programming utilities."""

from funcy_bear.ops.collections_ops.dict_stuffs import basic_merge as fast_dict_merge, key_counts, merge as merge_dicts
from funcy_bear.ops.collections_ops.iter_stuffs import (
    diff,
    drop,
    dupes,
    head,
    is_iter,
    merge,
    merge_lists,
    merge_sets,
    merge_tuples,
    pairwise,
    tail,
    uniqueify,
    window,
)
from funcy_bear.ops.curried_ops import (
    abs,  # noqa: A004
    add,
    append,
    clamp,
    decrement,
    default,
    delete,
    div,
    extend,
    format,  # noqa: A004
    if_else,
    increment,
    lower,
    mod,
    multiply,
    pop,
    pow,  # noqa: A004
    prepend,
    push,
    replace,
    setter,
    subtract,
    toggle,
    upper,
)
from funcy_bear.ops.dispatch import format_default_value, mini_dispatch, to_int
from funcy_bear.ops.func_stuffs import (
    a_or_b,
    all_of,
    any_of,
    complement,
    compose,
    const,
    if_in_list,
    is_mapping,
    is_object,
    monkey,
    one_of,
    pipe,
)
from funcy_bear.ops.value_stuffs import (
    always_false,
    always_true,
    equal_value,
    get_instance,
    has_exception,
    not_equal_value,
)
from funcy_bear.type_stuffs.constants import (
    LitBool,
    LitBytes,
    LitDict,
    LitFalse,
    LitFloat,
    LitInt,
    LitList,
    LitPath,
    LitSet,
    LitStr,
    LitTrue,
    LitTuple,
    SupportsBool,
    SupportsTruthiness,
    TruthReturnedCall,
)

__all__ = [
    "LitBool",
    "LitBytes",
    "LitDict",
    "LitFalse",
    "LitFloat",
    "LitInt",
    "LitList",
    "LitPath",
    "LitSet",
    "LitStr",
    "LitTrue",
    "LitTuple",
    "SupportsBool",
    "SupportsTruthiness",
    "TruthReturnedCall",
    "a_or_b",
    "abs",
    "add",
    "all_of",
    "always_false",
    "always_true",
    "any_of",
    "append",
    "clamp",
    "complement",
    "compose",
    "const",
    "decrement",
    "default",
    "delete",
    "diff",
    "div",
    "drop",
    "dupes",
    "equal_value",
    "extend",
    "fast_dict_merge",
    "format",
    "format_default_value",
    "get_instance",
    "has_exception",
    "head",
    "if_else",
    "if_in_list",
    "increment",
    "is_iter",
    "is_mapping",
    "is_object",
    "key_counts",
    "lower",
    "merge",
    "merge_dicts",
    "merge_lists",
    "merge_sets",
    "merge_tuples",
    "mini_dispatch",
    "mod",
    "monkey",
    "multiply",
    "not_equal_value",
    "one_of",
    "pairwise",
    "pipe",
    "pop",
    "pow",
    "prepend",
    "push",
    "replace",
    "setter",
    "subtract",
    "tail",
    "to_int",
    "toggle",
    "uniqueify",
    "upper",
    "window",
]
