"""String and type conversion utilities."""

from .str_to_bool import parse_bool
from .string_eval import eval_to_native, eval_to_type_str
from .to_type import STR_TO_TYPE, StrTypeHelper, cached_str_to_type, coerce_to_type, str_to_type, value_to_type
from .type_to_string import CollectionCheck, PossibleStrs, type_to_str

str_to_bool = parse_bool

__all__ = [
    "STR_TO_TYPE",
    "CollectionCheck",
    "PossibleStrs",
    "StrTypeHelper",
    "cached_str_to_type",
    "coerce_to_type",
    "eval_to_native",
    "eval_to_type_str",
    "parse_bool",
    "str_to_bool",
    "str_to_type",
    "type_to_str",
    "value_to_type",
]
