"""
Constants
=========

System-wide constants for the reasoning kernel.
"""

# Error codes
ERROR_CODE_PLUGIN_INITIALIZATION_FAILED = "PLUGIN_INIT_FAILED"
ERROR_CODE_PLUGIN_EXECUTION_FAILED = "PLUGIN_EXEC_FAILED"
ERROR_CODE_CLOUD_SERVICE_UNAVAILABLE = "CLOUD_SERVICE_UNAVAILABLE"
ERROR_CODE_INVALID_INPUT = "INVALID_INPUT"
ERROR_CODE_TIMEOUT = "TIMEOUT"
ERROR_CODE_CONFIGURATION_ERROR = "CONFIG_ERROR"
ERROR_CODE_DEPENDENCY_MISSING = "DEPENDENCY_MISSING"
ERROR_CODE_AUTHENTICATION_FAILED = "AUTH_FAILED"
ERROR_CODE_RATE_LIMIT_EXCEEDED = "RATE_LIMIT_EXCEEDED"
ERROR_CODE_INSUFFICIENT_RESOURCES = "INSUFFICIENT_RESOURCES"
ERROR_VALIDATION_FAILED = "VALIDATION_FAILED"
ERROR_PROCESSING_FAILED = "PROCESSING_FAILED"
ERROR_NETWORK_FAILED = "NETWORK_FAILED"
ERROR_SERIALIZATION_FAILED = "SERIALIZATION_FAILED"
ERROR_AUTHENTICATION_FAILED = "AUTHENTICATION_FAILED"
ERROR_AUTHORIZATION_FAILED = "AUTHORIZATION_FAILED"
ERROR_RATE_LIMITED = "RATE_LIMITED"
ERROR_INTERNAL_SERVER = "INTERNAL_SERVER_ERROR"
ERROR_SERVICE_UNAVAILABLE = "SERVICE_UNAVAILABLE"
ERROR_TIMEOUT = "TIMEOUT"
ERROR_INVALID_REQUEST = "INVALID_REQUEST"

# HTTP status codes
HTTP_BAD_REQUEST = 400
HTTP_UNAUTHORIZED = 401
HTTP_FORBIDDEN = 403
HTTP_TOO_MANY_REQUESTS = 429
HTTP_INTERNAL_SERVER_ERROR = 500
HTTP_SERVICE_UNAVAILABLE = 503

# Default timeouts (seconds)
DEFAULT_PLUGIN_TIMEOUT = 300
DEFAULT_CLOUD_SERVICE_TIMEOUT = 60
DEFAULT_CACHE_TTL = 3600
DEFAULT_REQUEST_TIMEOUT = 30
SHORT_CACHE_TTL = 300
REASONING_RESULT_TTL = 7200

# Default retry settings
DEFAULT_MAX_RETRIES = 3
DEFAULT_RETRY_DELAY = 1.0
DEFAULT_BACKOFF_MULTIPLIER = 2.0

# Cache settings
DEFAULT_CACHE_SIZE = 1000
DEFAULT_CACHE_CLEANUP_INTERVAL = 300

# Performance thresholds
PERFORMANCE_THRESHOLD_RESPONSE_TIME = 5.0
PERFORMANCE_THRESHOLD_SUCCESS_RATE = 0.95
PERFORMANCE_THRESHOLD_CACHE_HIT_RATE = 0.7

# MSA stage names
MSA_STAGE_PARSE = "parse"
MSA_STAGE_KNOWLEDGE = "knowledge"
MSA_STAGE_GRAPH = "graph"
MSA_STAGE_SYNTHESIS = "synthesis"
MSA_STAGE_INFERENCE = "inference"

# Backward-compatibility aliases for legacy stage names used in tests and older APIs
# These map to human-readable identifiers expected by external integrations.
STAGE_PARSE = MSA_STAGE_PARSE
STAGE_RETRIEVE = "retrieve"
STAGE_GRAPH = MSA_STAGE_GRAPH
STAGE_SYNTHESIZE = "synthesize"
STAGE_INFER = "infer"

# Plugin types
PLUGIN_TYPE_MSA_STAGE = "msa_stage"
PLUGIN_TYPE_UTILITY = "utility"
PLUGIN_TYPE_CONNECTOR = "connector"

# Cloud service types
CLOUD_SERVICE_GPT5 = "gpt5"
CLOUD_SERVICE_REDIS = "redis"
CLOUD_SERVICE_DAYTONA = "daytona"

# API versions
API_VERSION_V1 = "v1"
API_VERSION_V2 = "v2"

# Logging levels
LOG_LEVEL_DEBUG = "DEBUG"
LOG_LEVEL_INFO = "INFO"
LOG_LEVEL_WARNING = "WARNING"
LOG_LEVEL_ERROR = "ERROR"
LOG_LEVEL_CRITICAL = "CRITICAL"

# Environment types
ENVIRONMENT_DEVELOPMENT = "development"
ENVIRONMENT_STAGING = "staging"
ENVIRONMENT_PRODUCTION = "production"

# Configuration keys
CONFIG_KEY_CLOUD_GPT5_API_KEY = "cloud.gpt5_api_key"
CONFIG_KEY_CLOUD_REDIS_CONNECTION = "cloud.redis_connection_string"
CONFIG_KEY_CLOUD_DAYTONA_API_KEY = "cloud.daytona_api_key"
CONFIG_KEY_PERFORMANCE_ENABLE_CACHING = "performance.enable_caching"
CONFIG_KEY_MSA_ENABLE_PARALLEL = "msa.enable_parallel_stages"

# Status codes
STATUS_SUCCESS = "success"
STATUS_ERROR = "error"
STATUS_PENDING = "pending"
STATUS_TIMEOUT = "timeout"
STATUS_CANCELLED = "cancelled"

# Quality thresholds
QUALITY_THRESHOLD_HIGH = 0.8
QUALITY_THRESHOLD_MEDIUM = 0.6
QUALITY_THRESHOLD_LOW = 0.4

# Confidence levels
CONFIDENCE_LEVEL_HIGH = 0.9
CONFIDENCE_LEVEL_MEDIUM = 0.7
CONFIDENCE_LEVEL_LOW = 0.5

# Confidence attributes for stage results
CONFIDENCE_ATTR_PARSING = "parsing_confidence"
CONFIDENCE_ATTR_RETRIEVAL = "retrieval_confidence"
CONFIDENCE_ATTR_GRAPH = "graph_confidence"
CONFIDENCE_ATTR_GENERIC = "confidence"

# Default confidence values
DEFAULT_CONFIDENCE = 0.5
PARTIAL_SUCCESS_CONFIDENCE = 0.6
DEFAULT_CONFIDENCE_THRESHOLD = 0.7
