#
# This file is part of Invenio.
# Copyright (C) 2025 CERN.
#
# Invenio is free software; you can redistribute it and/or modify it
# under the terms of the MIT License; see LICENSE file for more details.

"""Create base tables."""

import sqlalchemy as sa
import sqlalchemy_utils
from alembic import op
from sqlalchemy.dialects import postgresql
from sqlalchemy_utils import JSONType

from invenio_checks.models import CheckRunStatus, Severity

# revision identifiers, used by Alembic.
revision = "1742549302"
down_revision = "1742548610"
branch_labels = ()
depends_on = "de9c14cbb0b2"


def upgrade():
    """Upgrade database."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "checks_config",
        sa.Column("id", sqlalchemy_utils.types.uuid.UUIDType(), nullable=False),
        sa.Column(
            "community_id", sqlalchemy_utils.types.uuid.UUIDType(), nullable=False
        ),
        sa.Column("check_id", sa.String(length=255), nullable=False),
        sa.Column(
            "params",
            sa.JSON()
            .with_variant(JSONType(), "mysql")
            .with_variant(
                postgresql.JSONB(none_as_null=True, astext_type=sa.Text()), "postgresql"
            )
            .with_variant(JSONType(), "sqlite"),
            nullable=False,
        ),
        sa.Column(
            "severity",
            sqlalchemy_utils.types.choice.ChoiceType(Severity, impl=sa.String(1)),
            nullable=False,
        ),
        sa.Column("enabled", sa.Boolean(), nullable=False),
        sa.Column("created", sa.DateTime(), nullable=False),
        sa.Column("updated", sa.DateTime(), nullable=False),
        sa.ForeignKeyConstraint(
            ["community_id"],
            ["communities_metadata.id"],
            name=op.f("fk_checks_config_community_id_communities_metadata"),
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_checks_config")),
    )
    op.create_table(
        "checks_run",
        sa.Column("id", sqlalchemy_utils.types.uuid.UUIDType(), nullable=False),
        sa.Column("config_id", sqlalchemy_utils.types.uuid.UUIDType(), nullable=False),
        sa.Column("record_id", sqlalchemy_utils.types.uuid.UUIDType(), nullable=False),
        sa.Column("is_draft", sa.Boolean(), nullable=False),
        sa.Column("revision_id", sa.Integer(), nullable=False),
        sa.Column("start_time", sa.DateTime(), nullable=True),
        sa.Column("end_time", sa.DateTime(), nullable=True),
        sa.Column(
            "status",
            sqlalchemy_utils.types.choice.ChoiceType(CheckRunStatus, impl=sa.String(1)),
            nullable=False,
        ),
        sa.Column(
            "state",
            sa.JSON()
            .with_variant(JSONType(), "mysql")
            .with_variant(
                postgresql.JSONB(none_as_null=True, astext_type=sa.Text()), "postgresql"
            )
            .with_variant(JSONType(), "sqlite"),
            nullable=False,
        ),
        sa.Column(
            "result",
            sa.JSON()
            .with_variant(JSONType(), "mysql")
            .with_variant(
                postgresql.JSONB(none_as_null=True, astext_type=sa.Text()), "postgresql"
            )
            .with_variant(JSONType(), "sqlite"),
            nullable=False,
        ),
        sa.Column("created", sa.DateTime(), nullable=False),
        sa.Column("updated", sa.DateTime(), nullable=False),
        sa.ForeignKeyConstraint(
            ["config_id"],
            ["checks_config.id"],
            name=op.f("fk_checks_run_config_id_checks_config"),
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_checks_run")),
    )
    op.create_index(
        op.f("ix_checks_run_record_id"),
        "checks_run",
        ["record_id"],
        unique=False,
    )
    op.create_index(
        op.f("idx_checks_run_config_id_record_id"),
        "checks_run",
        ["config_id", "record_id"],
        unique=False,
    )
    # ### end Alembic commands ###


def downgrade():
    """Downgrade database."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f("idx_checks_run_config_id_record_id"), table_name="checks_run")
    op.drop_index(op.f("ix_checks_run_record_id"), table_name="checks_run")
    op.drop_table("checks_run")
    op.drop_table("checks_config")
    # ### end Alembic commands ###
