# Code of Conduct

## Our Pledge

We as members, contributors, and leaders pledge to make participation in our
community a harassment-free experience for everyone, regardless of age, body
size, visible or invisible disability, ethnicity, sex characteristics, gender
identity and expression, level of experience, education, socio-economic status,
nationality, personal appearance, race, religion, or sexual identity
and orientation.

We pledge to act and interact in ways that contribute to an open, welcoming,
diverse, inclusive, and healthy community.

## Our Standards

Examples of behavior that contributes to a positive environment for our
community include:

* Demonstrating empathy and kindness toward other people
* Being respectful of differing opinions, viewpoints, and experiences
* Giving and gracefully accepting constructive feedback
* Accepting responsibility and apologizing to those affected by our mistakes,
  and learning from the experience
* Focusing on what is best not just for us as individuals, but for the
  overall community

Examples of unacceptable behavior include:

* The use of sexualized language or imagery, and sexual attention or
  advances of any kind
* Trolling, insulting or derogatory comments, and personal or political attacks
* Public or private harassment
* Publishing others' private information, such as a physical or email
  address, without their explicit permission
* Other conduct which could reasonably be considered inappropriate in a
  professional setting

## Enforcement Responsibilities

Community leaders are responsible for clarifying and enforcing our standards of
acceptable behavior and will take appropriate and fair corrective action in
response to any behavior that they deem inappropriate, threatening, offensive,
or harmful.

Community leaders have the right and responsibility to remove, edit, or reject
comments, commits, code, wiki edits, issues, and other contributions that are
not aligned to this Code of Conduct, and will communicate reasons for moderation
decisions when appropriate.

## Scope

This Code of Conduct applies within all community spaces, and also applies when
an individual is officially representing the community in public spaces.
Examples of representing our community include using an official e-mail address,
posting via an official social media account, or acting as an appointed
representative at an online or offline event.

## Enforcement

Instances of abusive, harassing, or otherwise unacceptable behavior may be
reported to the community leaders responsible for enforcement at
<support@arklex.ai>. All complaints will be reviewed and investigated promptly and fairly.

All community leaders are obligated to respect the privacy and security of the
reporter of any incident.

## Enforcement Guidelines

Community leaders will follow these Community Impact Guidelines in determining
the consequences for any action they deem in violation of this Code of Conduct:

### 1. Correction

**Community Impact**: Use of inappropriate language or other behavior deemed
unprofessional or unwelcome in the community.

**Consequence**: A private, written warning from community leaders, providing
clarity around the nature of the violation and an explanation of why the
behavior was inappropriate. A public apology may be requested.

### 2. Warning

**Community Impact**: A violation through a single incident or series of
actions.

**Consequence**: A warning with consequences for continued behavior. No
interaction with the people involved, including unsolicited interaction with
those enforcing the Code of Conduct, for a specified period of time. This
includes avoiding interactions in community spaces as well as external channels
like social media. Violating these terms may lead to a temporary or permanent
ban.

### 3. Temporary Ban

**Community Impact**: A serious violation of community standards, including
sustained inappropriate behavior.

**Consequence**: A temporary ban from any sort of interaction or public
communication with the community for a specified period of time. No public or
private interaction with the people involved, including unsolicited interaction
with those enforcing the Code of Conduct, is allowed during this period.
Violating these terms may lead to a permanent ban.

### 4. Permanent Ban

**Community Impact**: Demonstrating a pattern of violation of community
standards, including sustained inappropriate behavior, harassment of an
individual, or aggression toward or disparagement of classes of individuals.

**Consequence**: A permanent ban from any sort of public interaction within the
community.

## Reporting Guidelines

If you believe someone is violating the Code of Conduct, we ask that you report
it by emailing <support@arklex.ai>. All reports will be kept confidential.

In your report, please include:

* Your contact information (so we can get in touch with you if we need to
  follow up)
* Names (real, nicknames, or pseudonyms) of any individuals involved. If there
  were other witnesses besides you, please try to include them as well
* When and where the incident occurred. Please be as specific as possible
* Your account of what occurred. If there is a publicly available record (e.g.
  a mailing list archive or a public IRC logger), please include a link
* Any extra context you believe existed for the incident
* If you believe this incident is ongoing
* Any other information you believe we should have

### What happens after you file a report?

You will receive an email from the Code of Conduct committee acknowledging
receipt within 24 hours (and will aim for much quicker than that).

The committee will immediately meet to review the incident and determine:

* What happened
* Whether this event constitutes a Code of Conduct violation
* Who the bad actor was
* Whether this is an ongoing situation, or if there is a threat to anyone's
  physical safety

If this is determined to be an ongoing incident or a threat to physical safety,
the committee's immediate priority will be to protect everyone involved. This
means we may delay an "official" response until we believe that the situation
has ended and that everyone is physically safe.

Once the committee has a complete account of the events, they will make a
decision as to how to respond. Responses might include:

* Nothing (if we determine no violation occurred)
* A private reprimand from the committee to the individual(s) involved
* A public reprimand
* An imposed vacation (for instance, asking someone to "take a week off" from a
  mailing list or IRC)
* A permanent or temporary ban from some or all community spaces (GitHub
  repositories, IRC channels, etc.)
* A request for a public or private apology

We'll respond within one week to the person who filed the report with either a
resolution or an explanation of why the situation is not yet resolved.

Once we've determined our final action, we'll contact the original reporter to
let them know what action (if any) we'll be taking. We'll take into account
feedback from the reporter on the appropriateness of our response, but we don't
guarantee we'll act on it.

Finally, if the committee believes that the situation is not resolved, or if
for any reason the committee is not satisfied with the resolution, the
committee may take further action.

## Addressing Grievances

If you feel you have been falsely or unfairly accused of violating this Code of
Conduct, you should notify the Code of Conduct committee with a concise
description of your grievance. Your grievance will be handled in accordance with
our existing governing policies.

## Questions and Feedback

This Code of Conduct is adapted from the [Contributor Covenant](https://www.contributor-covenant.org/),
version 2.0, available at
<https://www.contributor-covenant.org/version/2/0/code_of_conduct.html>.

Community Impact Guidelines were inspired by [Mozilla's code of conduct
enforcement ladder](https://github.com/mozilla/diversity).

For answers to common questions about this code of conduct, see the FAQ at
<https://www.contributor-covenant.org/faq>. Translations are available at
<https://www.contributor-covenant.org/translations>.

If you have questions or feedback about this Code of Conduct, please contact us
at <support@arklex.ai>.

## Community Values

### Inclusivity

We strive to create an environment where everyone feels welcome and valued,
regardless of their background, experience level, or identity. We actively work
to remove barriers to participation and ensure diverse perspectives are heard
and respected.

### Collaboration

We believe that the best solutions come from working together. We encourage
open communication, constructive feedback, and mutual support among community
members.

### Learning

We recognize that everyone is on a learning journey. We encourage questions,
experimentation, and sharing knowledge. Mistakes are opportunities for growth,
not reasons for criticism.

### Respect

We treat each other with respect and dignity. We listen to different viewpoints,
acknowledge contributions, and give credit where it's due. We disagree
constructively and focus on ideas rather than individuals.

### Safety

We prioritize the safety and well-being of all community members. We do not
tolerate harassment, intimidation, or any behavior that makes others feel
unsafe or unwelcome.

## Community Spaces

This Code of Conduct applies to all community spaces, including but not limited
to:

* GitHub repositories and discussions
* Discord servers and channels
* Mailing lists and forums
* Social media accounts
* Meetups and conferences
* Code reviews and pull requests
* Issue trackers and bug reports
* Documentation and wikis

## Recognition and Appreciation

We believe in recognizing and appreciating the contributions of all community
members. We encourage:

* Thanking contributors for their work
* Highlighting positive contributions
* Celebrating milestones and achievements
* Providing constructive and encouraging feedback
* Mentoring and supporting new contributors

## Continuous Improvement

This Code of Conduct is a living document that will evolve as our community
grows and learns. We welcome feedback and suggestions for improvement. Please
share your thoughts with us at <support@arklex.ai>.

---

**Thank you for helping make Arklex AI a welcoming and inclusive community for everyone!** 🚀
