# -*- coding: UTF-8 -*-

# GNU General Public License v3.0
#
# Permissions of this strong copyleft license are conditioned on making available
# complete source code of licensed works and modifications, which include larger works
# using a licensed work, under the same license. Copyright and license notices must be
# preserved. Contributors provide an express grant of patent rights.
#
# For more information on this, and how to apply and follow theGNU GPL, see:
# http://www.gnu.org/licenses
#
# (ɔ) Iván Rincón 2018


# Arabic

transliteration = {
    # ICAO specifications
    u"\u0027": "",     # '
    u"\u0628": "B",    # ب
    u"\u062B": "XTH",  # ث
    u"\u062C": "J",    # ج
    u"\u062D": "XH",   # ح
    u"\u062E": "XKH",  # خ
    u"\u062F": "D",    # د
    u"\u0630": "XDH",  # ذ
    u"\u0631": "R",    # ر
    u"\u0632": "Z",    # ز
    u"\u0633": "S",    # س
    u"\u0634": "XSH",  # ش
    u"\u0635": "XSS",  # ص
    u"\u0636": "XDZ",  # ض
    u"\u0637": "XTT",  # ط
    u"\u0638": "XZZ",  # ظ
    u"\u0639": "E",    # ع
    u"\u063A": "G",    # غ
    u"\u0641": "F",    # ف
    u"\u0642": "Q",    # ق
    u"\u0643": "K",    # ك
    u"\u0644": "L",    # ل
    u"\u0645": "M",    # م
    u"\u0646": "N",    # ن
    u"\u0647": "H",    # ه
    u"\u0648": "W",    # و
    u"\u0649": "XAY",  # ى
    u"\u064A": "Y",    # ي
    u"\u0671": "XXA",  # ٱ
    u"\u0679": "XXT",  # ٹ
    u"\u067E": "P",    # پ
    u"\u067C": "XRT",  # ټ
    u"\u0681": "XKE",  # ځ
    u"\u0685": "XXH",  # څ
    u"\u0686": "XC",   # چ
    u"\u0688": "XXD",  # ڈ
    u"\u0689": "XDR",  # ډ
    u"\u0691": "XXR",  # ڑ
    u"\u0693": "XRR",  # ړ
    u"\u0696": "XRX",  # ږ
    u"\u0698": "XJ",   # ژ
    u"\u069A": "XXS",  # ښ
    u"\u06A9": "XKK",  # ک
    u"\u06AB": "XXK",  # ګ
    u"\u06AD": "XNG",  # ڭ
    u"\u06AF": "XGG",  # گ
    u"\u06BA": "XNN",  # ں
    u"\u06BC": "XXN",  # ڼ
    u"\u06BE": "XDO",  # ھ
    u"\u06C0": "XYH",  # ۀ
    u"\u06C1": "XXG",  # ہ
    u"\u06C2": "XGE",  # ۂ
    u"\u06C3": "XTG",  # ۃ
    u"\u06CC": "XYA",  # ی
    u"\u06CD": "XXY",  # ۍ
    u"\u06D0": "Y",    # ې
    u"\u06D2": "XYB",  # ے
    u"\u06D3": "XBE",  # ۓ

    # Some experimental additions (It seems to work well)
    u"\u0621": "",     # ء
    u"\u0670": "",     # '
    u"\u0627": "A",    # ا
    u"\u064E": "A",    # َ
    u"\u064B": "F",    # ً
    u"\u0650": "I",    # ِ
    u"\u0629": "P",    # ة
    u"\u062A": "T",    # ت
    u"\u064C": "N",    # ٌ
    u"\u064D": "K",    # ٍ
    u"\u064F": "U",    # ُ
    u"\u0652": "O",    # ْ

}

# https://www.icao.int/publications/Documents/9303_p3_cons_en.pdf
# https://en.wikipedia.org/wiki/Romanization_of_Arabic
