# -*- coding: UTF-8 -*-

# GNU General Public License v3.0
#
# Permissions of this strong copyleft license are conditioned on making available
# complete source code of licensed works and modifications, which include larger works
# using a licensed work, under the same license. Copyright and license notices must be
# preserved. Contributors provide an express grant of patent rights.
#
# For more information on this, and how to apply and follow theGNU GPL, see:
# http://www.gnu.org/licenses
#
# (ɔ) Iván Rincón 2018


# Cyrillic (macedonian transliteration)

transliteration = {
    u"\u0027": "",                         # '
    u"\u0410": "A",    u"\u0430": "a",     # А, а
    u"\u0411": "B",    u"\u0431": "b",     # Б, б
    u"\u0414": "D",    u"\u0434": "d",     # Д, д
    u"\u0401": "E",    u"\u0451": "e",     # Ё, ё
    u"\u0415": "E",    u"\u0435": "e",     # Е, e
    u"\u042D": "E",    u"\u044D": "e",     # Э, э
    u"\u0424": "F",    u"\u0444": "f",     # Ф, ф
    u"\u0413": "G",    u"\u0433": "g",     # Г, г
    u"\u0418": "I",    u"\u0438": "i",     # И, и
    u"\u0419": "I",    u"\u0439": "i",     # Й, й
    u"\u041A": "KJ",   u"\u043A": "kj",    # К, к
    u"\u041B": "L",    u"\u043B": "l",     # Л, л
    u"\u041C": "M",    u"\u043C": "m",     # М, м
    u"\u041D": "N",    u"\u043D": "n",     # Н, н
    u"\u041E": "O",    u"\u043E": "o",     # О, о
    u"\u041F": "P",    u"\u043F": "p",     # П, п
    u"\u0420": "R",    u"\u0440": "r",     # Р, р
    u"\u0421": "S",    u"\u0441": "s",     # С, с
    u"\u0422": "T",    u"\u0442": "t",     # Т, т
    u"\u0423": "U",    u"\u0443": "u",     # У, у
    u"\u0412": "V",    u"\u0432": "v",     # В, в
    u"\u042B": "Y",    u"\u044B": "y",     # Ы, ы
    u"\u0417": "Z",    u"\u0437": "z",     # З, з
    u"\u0427": "CH",   u"\u0447": "ch",    # Ч, ч
    u"\u042F": "IA",   u"\u044F": "ia",    # Я, я
    u"\u042E": "IU",   u"\u044E": "iu",    # Ю, ю
    u"\u0425": "H",    u"\u0445": "h",     # Х, х
    u"\u0428": "SH",   u"\u0448": "sh",    # Ш, ш
    u"\u0429": "SHCH", u"\u0449": "shch",  # Щ, щ
    u"\u0426": "C",    u"\u0446": "c",     # Ц, ц
    u"\u0416": "ZH",   u"\u0436": "zh",    # Ж, ж
    u"\u0490": "G",    u"\u0491": "g",     # Ґ, ґ
    u"\u040E": "U",    u"\u045E": "u",     # Ў, ў
    u"\u046A": "U",    u"\u046B": "u",     # Ѫ, ѫ
    u"\u0402": "D",    u"\u0452": "d",     # Ђ, ђ
    u"\u0405": "DZ",   u"\u0455": "dz",    # Ѕ, ѕ
    u"\u0408": "J",    u"\u0458": "j",     # Ј, ј
    u"\u0409": "LJ",   u"\u0459": "lj",    # Љ, љ
    u"\u040A": "NJ",   u"\u045A": "nj",    # Њ, њ
    u"\u04BA": "C",    u"\u04BB": "c",     # Һ, һ
    u"\u040F": "DJ",   u"\u045F": "dj",    # Џ, џ
    u"\u0404": "IE",   u"\u0454": "ie",    # Є, є
    u"\u0407": "I",    u"\u0457": "i",     # Ї, ї
    u"\u0403": "GJ",   u"\u0453": "gj"     # Ѓ, ѓ
}

# https://www.icao.int/publications/Documents/9303_p3_cons_en.pdf
# https://en.wikipedia.org/wiki/Cyrillic_script_in_Unicode
