# This file was auto-generated by Fern from our API Definition.

import typing

from ... import core
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.document_read import DocumentRead
from ...types.document_status import DocumentStatus
from ...types.paginated_slim_document_list import PaginatedSlimDocumentList
from ...types.upload_document_response import UploadDocumentResponse
from .raw_client import AsyncRawDocumentsClient, RawDocumentsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class DocumentsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawDocumentsClient(client_wrapper=client_wrapper)

    @property
    def _client_wrapper(self) -> SyncClientWrapper:
        return self._raw_client._client_wrapper

    @property
    def with_raw_response(self) -> RawDocumentsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawDocumentsClient
        """
        return self._raw_client

    def list(
        self,
        *,
        document_index_id: typing.Optional[str] = None,
        limit: typing.Optional[int] = None,
        offset: typing.Optional[int] = None,
        ordering: typing.Optional[str] = None,
        search: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaginatedSlimDocumentList:
        """
        Used to list documents. Optionally filter on supported fields.

        Parameters
        ----------
        document_index_id : typing.Optional[str]
            Filter down to only those documents that are included in the specified index. You may provide either the Vellum-generated ID or the unique name of the index specified upon initial creation.

        limit : typing.Optional[int]
            Number of results to return per page.

        offset : typing.Optional[int]
            The initial index from which to return the results.

        ordering : typing.Optional[str]
            Which field to use when ordering the results.

        search : typing.Optional[str]
            A search term.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaginatedSlimDocumentList


        Examples
        --------
        from vellum import Vellum

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.documents.list()
        """
        _response = self._raw_client.list(
            document_index_id=document_index_id,
            limit=limit,
            offset=offset,
            ordering=ordering,
            search=search,
            request_options=request_options,
        )
        return _response.data

    def retrieve(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> DocumentRead:
        """
        Retrieve a Document, keying off of either its Vellum-generated ID or its external ID.

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DocumentRead


        Examples
        --------
        from vellum import Vellum

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.documents.retrieve(
            id="id",
        )
        """
        _response = self._raw_client.retrieve(id, request_options=request_options)
        return _response.data

    def destroy(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete a Document, keying off of either its Vellum-generated ID or its external ID.

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from vellum import Vellum

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.documents.destroy(
            id="id",
        )
        """
        _response = self._raw_client.destroy(id, request_options=request_options)
        return _response.data

    def partial_update(
        self,
        id: str,
        *,
        label: typing.Optional[str] = OMIT,
        status: typing.Optional[DocumentStatus] = OMIT,
        keywords: typing.Optional[typing.Sequence[str]] = OMIT,
        metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DocumentRead:
        """
        Update a Document, keying off of either its Vellum-generated ID or its external ID. Particularly useful for updating its metadata.

        Parameters
        ----------
        id : str

        label : typing.Optional[str]
            A human-readable label for the document. Defaults to the originally uploaded file's file name.

        status : typing.Optional[DocumentStatus]
            The current status of the document

            * `ACTIVE` - Active

        keywords : typing.Optional[typing.Sequence[str]]
            A list of keywords that'll be associated with the document. Used as part of keyword search.

        metadata : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            A JSON object containing any metadata associated with the document that you'd like to filter upon later.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DocumentRead


        Examples
        --------
        from vellum import Vellum

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.documents.partial_update(
            id="id",
        )
        """
        _response = self._raw_client.partial_update(
            id, label=label, status=status, keywords=keywords, metadata=metadata, request_options=request_options
        )
        return _response.data

    def upload(
        self,
        *,
        label: str,
        add_to_index_names: typing.Optional[typing.List[str]] = OMIT,
        external_id: typing.Optional[str] = OMIT,
        contents: typing.Optional[core.File] = OMIT,
        url: typing.Optional[str] = OMIT,
        keywords: typing.Optional[typing.List[str]] = OMIT,
        metadata: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UploadDocumentResponse:
        """
        Upload a document to be indexed and used for search.

        **Note:** Uses a base url of `https://documents.vellum.ai`.

        Parameters
        ----------
        label : str
            A human-friendly name for this document. Typically the filename.

        add_to_index_names : typing.Optional[typing.List[str]]
            Optionally include the names of all indexes that you'd like this document to be included in

        external_id : typing.Optional[str]
            Optionally include an external ID for this document. This is useful if you want to re-upload the same document later when its contents change and would like it to be re-indexed.

        contents : typing.Optional[core.File]
            See core.File for more documentation

        url : typing.Optional[str]
            A URL from which the document can be downloaded. Either contents or url must be provided.

        keywords : typing.Optional[typing.List[str]]
            Optionally include a list of keywords that'll be associated with this document. Used when performing keyword searches.

        metadata : typing.Optional[str]
            A stringified JSON object containing any metadata associated with the document that you'd like to filter upon later.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UploadDocumentResponse

        """
        _response = self._raw_client.upload(
            label=label,
            add_to_index_names=add_to_index_names,
            external_id=external_id,
            contents=contents,
            url=url,
            keywords=keywords,
            metadata=metadata,
            request_options=request_options,
        )
        return _response.data


class AsyncDocumentsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawDocumentsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawDocumentsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawDocumentsClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        document_index_id: typing.Optional[str] = None,
        limit: typing.Optional[int] = None,
        offset: typing.Optional[int] = None,
        ordering: typing.Optional[str] = None,
        search: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaginatedSlimDocumentList:
        """
        Used to list documents. Optionally filter on supported fields.

        Parameters
        ----------
        document_index_id : typing.Optional[str]
            Filter down to only those documents that are included in the specified index. You may provide either the Vellum-generated ID or the unique name of the index specified upon initial creation.

        limit : typing.Optional[int]
            Number of results to return per page.

        offset : typing.Optional[int]
            The initial index from which to return the results.

        ordering : typing.Optional[str]
            Which field to use when ordering the results.

        search : typing.Optional[str]
            A search term.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaginatedSlimDocumentList


        Examples
        --------
        import asyncio

        from vellum import AsyncVellum

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.documents.list()


        asyncio.run(main())
        """
        _response = await self._raw_client.list(
            document_index_id=document_index_id,
            limit=limit,
            offset=offset,
            ordering=ordering,
            search=search,
            request_options=request_options,
        )
        return _response.data

    async def retrieve(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> DocumentRead:
        """
        Retrieve a Document, keying off of either its Vellum-generated ID or its external ID.

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DocumentRead


        Examples
        --------
        import asyncio

        from vellum import AsyncVellum

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.documents.retrieve(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.retrieve(id, request_options=request_options)
        return _response.data

    async def destroy(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete a Document, keying off of either its Vellum-generated ID or its external ID.

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from vellum import AsyncVellum

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.documents.destroy(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.destroy(id, request_options=request_options)
        return _response.data

    async def partial_update(
        self,
        id: str,
        *,
        label: typing.Optional[str] = OMIT,
        status: typing.Optional[DocumentStatus] = OMIT,
        keywords: typing.Optional[typing.Sequence[str]] = OMIT,
        metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DocumentRead:
        """
        Update a Document, keying off of either its Vellum-generated ID or its external ID. Particularly useful for updating its metadata.

        Parameters
        ----------
        id : str

        label : typing.Optional[str]
            A human-readable label for the document. Defaults to the originally uploaded file's file name.

        status : typing.Optional[DocumentStatus]
            The current status of the document

            * `ACTIVE` - Active

        keywords : typing.Optional[typing.Sequence[str]]
            A list of keywords that'll be associated with the document. Used as part of keyword search.

        metadata : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            A JSON object containing any metadata associated with the document that you'd like to filter upon later.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DocumentRead


        Examples
        --------
        import asyncio

        from vellum import AsyncVellum

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.documents.partial_update(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.partial_update(
            id, label=label, status=status, keywords=keywords, metadata=metadata, request_options=request_options
        )
        return _response.data

    async def upload(
        self,
        *,
        label: str,
        add_to_index_names: typing.Optional[typing.List[str]] = OMIT,
        external_id: typing.Optional[str] = OMIT,
        contents: typing.Optional[core.File] = OMIT,
        url: typing.Optional[str] = OMIT,
        keywords: typing.Optional[typing.List[str]] = OMIT,
        metadata: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UploadDocumentResponse:
        """
        Upload a document to be indexed and used for search.

        **Note:** Uses a base url of `https://documents.vellum.ai`.

        Parameters
        ----------
        label : str
            A human-friendly name for this document. Typically the filename.

        add_to_index_names : typing.Optional[typing.List[str]]
            Optionally include the names of all indexes that you'd like this document to be included in

        external_id : typing.Optional[str]
            Optionally include an external ID for this document. This is useful if you want to re-upload the same document later when its contents change and would like it to be re-indexed.

        contents : typing.Optional[core.File]
            See core.File for more documentation

        url : typing.Optional[str]
            A URL from which the document can be downloaded. Either contents or url must be provided.

        keywords : typing.Optional[typing.List[str]]
            Optionally include a list of keywords that'll be associated with this document. Used when performing keyword searches.

        metadata : typing.Optional[str]
            A stringified JSON object containing any metadata associated with the document that you'd like to filter upon later.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UploadDocumentResponse

        """
        _response = await self._raw_client.upload(
            label=label,
            add_to_index_names=add_to_index_names,
            external_id=external_id,
            contents=contents,
            url=url,
            keywords=keywords,
            metadata=metadata,
            request_options=request_options,
        )
        return _response.data
