# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel, update_forward_refs
from .workflow_event_error import WorkflowEventError
from .workflow_node_result_data import WorkflowNodeResultData


class RejectedWorkflowNodeResultEvent(UniversalBaseModel):
    """
    An event that indicates that the node has rejected its execution.
    """

    id: str
    node_id: str
    node_result_id: str
    state: typing.Literal["REJECTED"] = "REJECTED"
    ts: typing.Optional[dt.datetime] = None
    data: typing.Optional[WorkflowNodeResultData] = None
    source_execution_id: typing.Optional[str] = None
    error: WorkflowEventError

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .array_vellum_value import ArrayVellumValue  # noqa: E402, F401, I001

update_forward_refs(RejectedWorkflowNodeResultEvent)
