import pytest


@pytest.fixture
def graph_sentence():
    return 'The police commander of Ninevah Province announced that bombings had declined 80 percent in Mosul , whereas there had been a big jump in the number of kidnappings .'


# fixtures moved to conftest.py


@pytest.fixture
def graph_syntax_nodes():
    return {'tree1-syntax-1': {'Definite': 'Def',
                               'PronType': 'Art',
                               'domain': 'syntax',
                               'form': 'The',
                               'lemma': 'the',
                               'position': 1,
                               'type': 'token',
                               'upos': 'DET',
                               'xpos': 'DT'},
            'tree1-syntax-10': {'Mood': 'Ind',
                                'Tense': 'Past',
                                'VerbForm': 'Fin',
                                'domain': 'syntax',
                                'form': 'had',
                                'lemma': 'have',
                                'position': 10,
                                'type': 'token',
                                'upos': 'AUX',
                                'xpos': 'VBD'},
            'tree1-syntax-11': {'Tense': 'Past',
                                'VerbForm': 'Part',
                                'domain': 'syntax',
                                'form': 'declined',
                                'lemma': 'decline',
                                'position': 11,
                                'type': 'token',
                                'upos': 'VERB',
                                'xpos': 'VBN'},
            'tree1-syntax-12': {'NumType': 'Card',
                                'domain': 'syntax',
                                'form': '80',
                                'lemma': '80',
                                'position': 12,
                                'type': 'token',
                                'upos': 'NUM',
                                'xpos': 'CD'},
            'tree1-syntax-13': {'Number': 'Sing',
                                'domain': 'syntax',
                                'form': 'percent',
                                'lemma': 'percent',
                                'position': 13,
                                'type': 'token',
                                'upos': 'NOUN',
                                'xpos': 'NN'},
            'tree1-syntax-14': {'domain': 'syntax',
                                'form': 'in',
                                'lemma': 'in',
                                'position': 14,
                                'type': 'token',
                                'upos': 'ADP',
                                'xpos': 'IN'},
            'tree1-syntax-15': {'Number': 'Sing',
                                'domain': 'syntax',
                                'form': 'Mosul',
                                'lemma': 'Mosul',
                                'position': 15,
                                'type': 'token',
                                'upos': 'PROPN',
                                'xpos': 'NNP'},
            'tree1-syntax-16': {'domain': 'syntax',
                                'form': ',',
                                'lemma': ',',
                                'position': 16,
                                'type': 'token',
                                'upos': 'PUNCT',
                                'xpos': ','},
            'tree1-syntax-17': {'domain': 'syntax',
                                'form': 'whereas',
                                'lemma': 'whereas',
                                'position': 17,
                                'type': 'token',
                                'upos': 'SCONJ',
                                'xpos': 'IN'},
            'tree1-syntax-18': {'domain': 'syntax',
                                'form': 'there',
                                'lemma': 'there',
                                'position': 18,
                                'type': 'token',
                                'upos': 'PRON',
                                'xpos': 'EX'},
            'tree1-syntax-19': {'Mood': 'Ind',
                                'Tense': 'Past',
                                'VerbForm': 'Fin',
                                'domain': 'syntax',
                                'form': 'had',
                                'lemma': 'have',
                                'position': 19,
                                'type': 'token',
                                'upos': 'AUX',
                                'xpos': 'VBD'},
            'tree1-syntax-2': {'Number': 'Sing',
                               'domain': 'syntax',
                               'form': 'police',
                               'lemma': 'police',
                               'position': 2,
                               'type': 'token',
                               'upos': 'NOUN',
                               'xpos': 'NN'},
            'tree1-syntax-20': {'Tense': 'Past',
                                'VerbForm': 'Part',
                                'domain': 'syntax',
                                'form': 'been',
                                'lemma': 'be',
                                'position': 20,
                                'type': 'token',
                                'upos': 'VERB',
                                'xpos': 'VBN'},
            'tree1-syntax-21': {'Definite': 'Ind',
                                'PronType': 'Art',
                                'domain': 'syntax',
                                'form': 'a',
                                'lemma': 'a',
                                'position': 21,
                                'type': 'token',
                                'upos': 'DET',
                                'xpos': 'DT'},
            'tree1-syntax-22': {'Degree': 'Pos',
                                'domain': 'syntax',
                                'form': 'big',
                                'lemma': 'big',
                                'position': 22,
                                'type': 'token',
                                'upos': 'ADJ',
                                'xpos': 'JJ'},
            'tree1-syntax-23': {'Number': 'Sing',
                                'domain': 'syntax',
                                'form': 'jump',
                                'lemma': 'jump',
                                'position': 23,
                                'type': 'token',
                                'upos': 'NOUN',
                                'xpos': 'NN'},
            'tree1-syntax-24': {'domain': 'syntax',
                                'form': 'in',
                                'lemma': 'in',
                                'position': 24,
                                'type': 'token',
                                'upos': 'ADP',
                                'xpos': 'IN'},
            'tree1-syntax-25': {'Definite': 'Def',
                                'PronType': 'Art',
                                'domain': 'syntax',
                                'form': 'the',
                                'lemma': 'the',
                                'position': 25,
                                'type': 'token',
                                'upos': 'DET',
                                'xpos': 'DT'},
            'tree1-syntax-26': {'Number': 'Sing',
                                'domain': 'syntax',
                                'form': 'number',
                                'lemma': 'number',
                                'position': 26,
                                'type': 'token',
                                'upos': 'NOUN',
                                'xpos': 'NN'},
            'tree1-syntax-27': {'domain': 'syntax',
                                'form': 'of',
                                'lemma': 'of',
                                'position': 27,
                                'type': 'token',
                                'upos': 'ADP',
                                'xpos': 'IN'},
            'tree1-syntax-28': {'Number': 'Plur',
                                'domain': 'syntax',
                                'form': 'kidnappings',
                                'lemma': 'kidnapping',
                                'position': 28,
                                'type': 'token',
                                'upos': 'NOUN',
                                'xpos': 'NNS'},
            'tree1-syntax-29': {'domain': 'syntax',
                                'form': '.',
                                'lemma': '.',
                                'position': 29,
                                'type': 'token',
                                'upos': 'PUNCT',
                                'xpos': '.'},
            'tree1-syntax-3': {'Number': 'Sing',
                               'domain': 'syntax',
                               'form': 'commander',
                               'lemma': 'commander',
                               'position': 3,
                               'type': 'token',
                               'upos': 'NOUN',
                               'xpos': 'NN'},
            'tree1-syntax-4': {'domain': 'syntax',
                               'form': 'of',
                               'lemma': 'of',
                               'position': 4,
                               'type': 'token',
                               'upos': 'ADP',
                               'xpos': 'IN'},
            'tree1-syntax-5': {'Number': 'Sing',
                               'domain': 'syntax',
                               'form': 'Ninevah',
                               'lemma': 'Ninevah',
                               'position': 5,
                               'type': 'token',
                               'upos': 'PROPN',
                               'xpos': 'NNP'},
            'tree1-syntax-6': {'Number': 'Sing',
                               'domain': 'syntax',
                               'form': 'Province',
                               'lemma': 'Province',
                               'position': 6,
                               'type': 'token',
                               'upos': 'PROPN',
                               'xpos': 'NNP'},
            'tree1-syntax-7': {'Mood': 'Ind',
                               'Tense': 'Past',
                               'VerbForm': 'Fin',
                               'domain': 'syntax',
                               'form': 'announced',
                               'lemma': 'announce',
                               'position': 7,
                               'type': 'token',
                               'upos': 'VERB',
                               'xpos': 'VBD'},
            'tree1-syntax-8': {'domain': 'syntax',
                               'form': 'that',
                               'lemma': 'that',
                               'position': 8,
                               'type': 'token',
                               'upos': 'SCONJ',
                               'xpos': 'IN'},
            'tree1-syntax-9': {'Number': 'Plur',
                               'domain': 'syntax',
                               'form': 'bombings',
                               'lemma': 'bombing',
                               'position': 9,
                               'type': 'token',
                               'upos': 'NOUN',
                               'xpos': 'NNS'}}

@pytest.fixture
def graph_normalized_semantics_nodes():
    return {'tree1-semantics-arg-0': {'domain': 'semantics',
                                      'frompredpatt': False,
                                      'type': 'argument'},
            'tree1-semantics-arg-11': {'domain': 'semantics',
                                       'frompredpatt': True,
                                       'type': 'argument'},
            'tree1-semantics-arg-13': {'domain': 'semantics',
                                       'frompredpatt': True,
                                       'genericity': {'arg-abstract': {'confidence': 1.0,
                                                                       'value': -1.147},
                                                      'arg-kind': {'confidence': 1.0,
                                                                   'value': -1.147},
                                                      'arg-particular': {'confidence': 1.0,
                                                                         'value': 1.1619}},
                                       'type': 'argument'},
            'tree1-semantics-arg-15': {'domain': 'semantics',
                                       'frompredpatt': True,
                                       'genericity': {'arg-abstract': {'confidence': 1.0,
                                                                       'value': -1.147},
                                                      'arg-kind': {'confidence': 1.0,
                                                                   'value': 1.1619},
                                                      'arg-particular': {'confidence': 1.0,
                                                                         'value': 1.1619}},
                                       'type': 'argument'},
            'tree1-semantics-arg-23': {'domain': 'semantics',
                                       'frompredpatt': True,
                                       'genericity': {'arg-abstract': {'confidence': 1.0,
                                                                       'value': -1.147},
                                                      'arg-kind': {'confidence': 1.0,
                                                                   'value': -1.147},
                                                      'arg-particular': {'confidence': 1.0,
                                                                         'value': 1.1619}},
                                       'type': 'argument'},
            'tree1-semantics-arg-3': {'domain': 'semantics',
                                      'frompredpatt': True,
                                      'genericity': {'arg-abstract': {'confidence': 1.0,
                                                                      'value': -1.147},
                                                     'arg-kind': {'confidence': 1.0,
                                                                  'value': -1.147},
                                                     'arg-particular': {'confidence': 1.0,
                                                                        'value': 1.1619}},
                                      'type': 'argument'},
            'tree1-semantics-arg-9': {'domain': 'semantics',
                                      'frompredpatt': True,
                                      'genericity': {'arg-abstract': {'confidence': 1.0,
                                                                      'value': -1.147},
                                                     'arg-kind': {'confidence': 1.0,
                                                                  'value': -1.147},
                                                     'arg-particular': {'confidence': 1.0,
                                                                        'value': 1.1619}},
                                      'type': 'argument'},
            'tree1-semantics-arg-author': {'domain': 'semantics', 'frompredpatt': False, 'type': 'argument'},
            'tree1-semantics-arg-addressee': {'domain': 'semantics',
                                              'frompredpatt': False,
                                              'type': 'argument'},
            'tree1-semantics-pred-11': {'domain': 'semantics',
                                        'frompredpatt': True,
                                        'genericity': {'pred-dynamic': {'confidence': 1.0,
                                                                        'value': 0.7748},
                                                       'pred-hypothetical': {'confidence': 1.0,
                                                                             'value': -1.5399},
                                                       'pred-particular': {'confidence': 1.0,
                                                                           'value': 0.7748}},
                                        'type': 'predicate'},
            'tree1-semantics-pred-20': {'domain': 'semantics',
                                        'frompredpatt': True,
                                        'genericity': {'pred-dynamic': {'confidence': 1.0,
                                                                        'value': -1.5399},
                                                       'pred-hypothetical': {'confidence': 1.0,
                                                                             'value': 0.7748},
                                                       'pred-particular': {'confidence': 1.0,
                                                                           'value': -1.54}},
                                        'type': 'predicate'},
            'tree1-semantics-pred-7': {'domain': 'semantics',
                                       'frompredpatt': True,
                                       'genericity': {'pred-dynamic': {'confidence': 1.0,
                                                                       'value': 0.7748},
                                                      'pred-hypothetical': {'confidence': 1.0,
                                                                            'value': -1.54},
                                                      'pred-particular': {'confidence': 1.0,
                                                                          'value': 0.7748}},
                                       'type': 'predicate'},
            'tree1-semantics-pred-root': {'domain': 'semantics',
                                          'frompredpatt': False,
                                          'type': 'predicate'}}

@pytest.fixture
def graph_raw_semantics_nodes():
    return {'tree1-semantics-arg-0': {'domain': 'semantics',
                                      'frompredpatt': False,
                                      'type': 'argument'},
            'tree1-semantics-arg-11': {'domain': 'semantics',
                                       'frompredpatt': True,
                                       'type': 'argument'},
            'tree1-semantics-arg-13': {'domain': 'semantics',
                                       'frompredpatt': True,
                                       'genericity': {'arg-abstract': {'confidence': {'genericity-arg-annotator-103': 4},
                                                                       'value': {'genericity-arg-annotator-103': 0}},
                                                      'arg-kind': {'confidence': {'genericity-arg-annotator-103': 4},
                                                                   'value': {'genericity-arg-annotator-103': 0}},
                                                      'arg-particular': {'confidence': {'genericity-arg-annotator-103': 4},
                                                                         'value': {'genericity-arg-annotator-103': 0}}},
                                       'type': 'argument'},
            'tree1-semantics-arg-15': {'domain': 'semantics',
                                       'frompredpatt': True,
                                       'genericity': {'arg-abstract': {'confidence': {'genericity-arg-annotator-103': 4},
                                                                       'value': {'genericity-arg-annotator-103': 0}},
                                                      'arg-kind': {'confidence': {'genericity-arg-annotator-103': 4},
                                                                   'value': {'genericity-arg-annotator-103': 0}},
                                                      'arg-particular': {'confidence': {'genericity-arg-annotator-103': 4},
                                                                         'value': {'genericity-arg-annotator-103': 0}}},
                                       'type': 'argument'},
            'tree1-semantics-arg-23': {'domain': 'semantics',
                                       'frompredpatt': True,
                                       'genericity': {'arg-abstract': {'confidence': {'genericity-arg-annotator-103': 4},
                                                                       'value': {'genericity-arg-annotator-103': 0}},
                                                      'arg-kind': {'confidence': {'genericity-arg-annotator-103': 4},
                                                                   'value': {'genericity-arg-annotator-103': 0}},
                                                      'arg-particular': {'confidence': {'genericity-arg-annotator-103': 4},
                                                                         'value': {'genericity-arg-annotator-103': 0}}},
                                       'type': 'argument'},
            'tree1-semantics-arg-3': {'domain': 'semantics',
                                      'frompredpatt': True,
                                      'genericity': {'arg-abstract': {'confidence': {'genericity-arg-annotator-103': 4},
                                                                      'value': {'genericity-arg-annotator-103': 0}},
                                                     'arg-kind': {'confidence': {'genericity-arg-annotator-103': 4},
                                                                  'value': {'genericity-arg-annotator-103': 0}},
                                                     'arg-particular': {'confidence': {'genericity-arg-annotator-103': 4},
                                                                        'value': {'genericity-arg-annotator-103': 0}}},
                                      'type': 'argument'},
            'tree1-semantics-arg-9': {'domain': 'semantics',
                                      'frompredpatt': True,
                                      'genericity': {'arg-abstract': {'confidence': {'genericity-arg-annotator-103': 4},
                                                                      'value': {'genericity-arg-annotator-103': 0}},
                                                     'arg-kind': {'confidence': {'genericity-arg-annotator-103': 4},
                                                                  'value': {'genericity-arg-annotator-103': 0}},
                                                     'arg-particular': {'confidence': {'genericity-arg-annotator-103': 4},
                                                                        'value': {'genericity-arg-annotator-103': 0}}},
                                      'type': 'argument'},
            'tree1-semantics-arg-addressee': {'domain': 'semantics',
                                              'frompredpatt': False,
                                              'type': 'argument'},
            'tree1-semantics-arg-author': {'domain': 'semantics',
                                           'frompredpatt': False,
                                           'type': 'argument'},
            'tree1-semantics-pred-11': {'domain': 'semantics',
                                        'frompredpatt': True,
                                        'genericity': {'pred-dynamic': {'confidence': {'genericity-pred-annotator-88': 4},
                                                                        'value': {'genericity-pred-annotator-88': 0}},
                                                       'pred-hypothetical': {'confidence': {'genericity-pred-annotator-88': 4},
                                                                             'value': {'genericity-pred-annotator-88': 0}},
                                                       'pred-particular': {'confidence': {'genericity-pred-annotator-88': 4},
                                                                           'value': {'genericity-pred-annotator-88': 0}}},
                                        'type': 'predicate'},
            'tree1-semantics-pred-20': {'domain': 'semantics',
                                        'frompredpatt': True,
                                        'genericity': {'pred-dynamic': {'confidence': {'genericity-pred-annotator-88': 0},
                                                                        'value': {'genericity-pred-annotator-88': 1}},
                                                       'pred-hypothetical': {'confidence': {'genericity-pred-annotator-88': 0},
                                                                             'value': {'genericity-pred-annotator-88': 1}},
                                                       'pred-particular': {'confidence': {'genericity-pred-annotator-88': 0},
                                                                           'value': {'genericity-pred-annotator-88': 1}}},
                                        'type': 'predicate'},
            'tree1-semantics-pred-7': {'domain': 'semantics',
                                       'frompredpatt': True,
                                       'genericity': {'pred-dynamic': {'confidence': {'genericity-pred-annotator-88': 4},
                                                                       'value': {'genericity-pred-annotator-88': 0}},
                                                      'pred-hypothetical': {'confidence': {'genericity-pred-annotator-88': 4},
                                                                            'value': {'genericity-pred-annotator-88': 0}},
                                                      'pred-particular': {'confidence': {'genericity-pred-annotator-88': 4},
                                                                          'value': {'genericity-pred-annotator-88': 0}}},
                                       'type': 'predicate'},
            'tree1-semantics-pred-root': {'domain': 'semantics',
                                          'frompredpatt': False,
                                          'type': 'predicate'}}

@pytest.fixture
def graph_normalized_semantics_edges():
    return {('tree1-semantics-arg-0', 'tree1-semantics-pred-20'): {'domain': 'semantics',
                                                                   'frompredpatt': False,
                                                                   'type': 'head'},
            ('tree1-semantics-arg-0', 'tree1-semantics-pred-7'): {'domain': 'semantics',
                                                                  'frompredpatt': False,
                                                                  'type': 'head'},
            ('tree1-semantics-arg-11', 'tree1-semantics-pred-11'): {'domain': 'semantics',
                                                                    'frompredpatt': True,
                                                                    'type': 'head'},
            ('tree1-semantics-pred-11', 'tree1-semantics-arg-13'): {'domain': 'semantics',
                                                                    'frompredpatt': True,
                                                                    'protoroles': {'awareness': {'confidence': 1.0,
                                                                                                 'value': -0.0},
                                                                                   'change_of_location': {'confidence': 1.0,
                                                                                                          'value': -0.0},
                                                                                   'change_of_possession': {'confidence': 1.0,
                                                                                                            'value': -0.0},
                                                                                   'change_of_state': {'confidence': 0.1675,
                                                                                                       'value': 0.0032},
                                                                                   'change_of_state_continuous': {'confidence': 0.1675,
                                                                                                                  'value': 0.0032},
                                                                                   'existed_after': {'confidence': 0.6796,
                                                                                                     'value': 0.0111},
                                                                                   'existed_before': {'confidence': 0.6796,
                                                                                                      'value': 0.0111},
                                                                                   'existed_during': {'confidence': 1.0,
                                                                                                      'value': 1.3421},
                                                                                   'instigation': {'confidence': 1.0,
                                                                                                   'value': -0.0},
                                                                                   'partitive': {'confidence': 0.564,
                                                                                                 'value': -0.0941},
                                                                                   'sentient': {'confidence': 1.0,
                                                                                                'value': -0.9348},
                                                                                   'volition': {'confidence': 1.0,
                                                                                                'value': -0.0},
                                                                                   'was_for_benefit': {'confidence': 1.0,
                                                                                                       'value': -0.0},
                                                                                   'was_used': {'confidence': 0.564,
                                                                                                'value': -0.0}},
                                                                    'type': 'dependency'},
            ('tree1-semantics-pred-11', 'tree1-semantics-arg-15'): {'domain': 'semantics',
                                                                    'frompredpatt': True,
                                                                    'type': 'dependency'},
            ('tree1-semantics-pred-11', 'tree1-semantics-arg-9'): {'domain': 'semantics',
                                                                   'frompredpatt': True,
                                                                   'protoroles': {'awareness': {'confidence': 0.1395,
                                                                                                'value': -0.0549},
                                                                                  'change_of_location': {'confidence': 0.1395,
                                                                                                         'value': -0.0549},
                                                                                  'change_of_possession': {'confidence': 1.0,
                                                                                                           'value': -0.3909},
                                                                                  'change_of_state': {'confidence': 0.3333,
                                                                                                      'value': -0.0085},
                                                                                  'change_of_state_continuous': {'confidence': 0.0791,
                                                                                                                 'value': -0.0351},
                                                                                  'existed_after': {'confidence': 0.6567,
                                                                                                    'value': 0.124},
                                                                                  'existed_before': {'confidence': 1.0,
                                                                                                     'value': 1.3954},
                                                                                  'existed_during': {'confidence': 1.0,
                                                                                                     'value': 1.3959},
                                                                                  'instigation': {'confidence': 1.0,
                                                                                                  'value': -1.5074},
                                                                                  'partitive': {'confidence': 0.0791,
                                                                                                'value': -0.1354},
                                                                                  'sentient': {'confidence': 1.0,
                                                                                               'value': -1.508},
                                                                                  'volition': {'confidence': 1.0,
                                                                                               'value': -0.3909},
                                                                                  'was_for_benefit': {'confidence': 0.3418,
                                                                                                      'value': 0.0008},
                                                                                  'was_used': {'confidence': 0.3333,
                                                                                               'value': -0.0085}},
                                                                   'type': 'dependency'},
            ('tree1-semantics-pred-20', 'tree1-semantics-arg-23'): {'domain': 'semantics',
                                                                    'frompredpatt': True,
                                                                    'type': 'dependency'},
            ('tree1-semantics-pred-7', 'tree1-semantics-arg-11'): {'domain': 'semantics',
                                                                   'frompredpatt': True,
                                                                   'type': 'dependency'},
            ('tree1-semantics-pred-7', 'tree1-semantics-arg-3'): {'domain': 'semantics',
                                                                  'frompredpatt': True,
                                                                  'protoroles': {'awareness': {'confidence': 1.0,
                                                                                               'value': 1.3526},
                                                                                 'change_of_location': {'confidence': 0.272,
                                                                                                        'value': -0.0922},
                                                                                 'change_of_possession': {'confidence': 0.7724,
                                                                                                          'value': -0.0},
                                                                                 'change_of_state': {'confidence': 0.2067,
                                                                                                     'value': -0.0548},
                                                                                 'change_of_state_continuous': {'confidence': 1.0,
                                                                                                                'value': -0.0},
                                                                                 'existed_after': {'confidence': 1.0,
                                                                                                   'value': 1.3527},
                                                                                 'existed_before': {'confidence': 1.0,
                                                                                                    'value': 1.3527},
                                                                                 'existed_during': {'confidence': 1.0,
                                                                                                    'value': 1.3557},
                                                                                 'instigation': {'confidence': 1.0,
                                                                                                 'value': 1.3557},
                                                                                 'partitive': {'confidence': 0.1148,
                                                                                               'value': -0.0018},
                                                                                 'sentient': {'confidence': 1.0,
                                                                                              'value': 1.354},
                                                                                 'volition': {'confidence': 1.0,
                                                                                              'value': 1.3545},
                                                                                 'was_for_benefit': {'confidence': 0.1976,
                                                                                                     'value': -0.0504},
                                                                                 'was_used': {'confidence': 0.4373,
                                                                                              'value': -0.0207}},
                                                                  'type': 'dependency'},
            ('tree1-semantics-pred-root', 'tree1-semantics-arg-0'): {'domain': 'semantics',
                                                                     'frompredpatt': False,
                                                                     'type': 'dependency'},
            ('tree1-semantics-pred-root', 'tree1-semantics-arg-addressee'): {'domain': 'semantics',
                                                                             'frompredpatt': False,
                                                                             'type': 'dependency'},
            ('tree1-semantics-pred-root', 'tree1-semantics-arg-author'): {'domain': 'semantics',
                                                                          'frompredpatt': False,
                                                                          'type': 'dependency'}}

@pytest.fixture
def graph_raw_semantics_edges():
    return {('tree1-semantics-arg-0', 'tree1-semantics-pred-20'): {'domain': 'semantics',
                                                                   'frompredpatt': False,
                                                                   'type': 'head'},
            ('tree1-semantics-arg-0', 'tree1-semantics-pred-7'): {'domain': 'semantics',
                                                                  'frompredpatt': False,
                                                                  'type': 'head'},
            ('tree1-semantics-arg-11', 'tree1-semantics-pred-11'): {'domain': 'semantics',
                                                                    'frompredpatt': True,
                                                                    'type': 'head'},
            ('tree1-semantics-pred-11', 'tree1-semantics-arg-13'): {'domain': 'semantics',
                                                                    'frompredpatt': True,
                                                                    'protoroles': {'awareness': {'confidence': {'protoroles-annotator-13': 0,
                                                                                                                'protoroles-annotator-20': 0},
                                                                                                 'value': {'protoroles-annotator-13': 2,
                                                                                                           'protoroles-annotator-20': 0}},
                                                                                   'change_of_location': {'confidence': {'protoroles-annotator-13': 0,
                                                                                                                         'protoroles-annotator-20': 0},
                                                                                                          'value': {'protoroles-annotator-13': 2,
                                                                                                                    'protoroles-annotator-20': 0}},
                                                                                   'change_of_possession': {'confidence': {'protoroles-annotator-13': 0,
                                                                                                                           'protoroles-annotator-20': 0},
                                                                                                            'value': {'protoroles-annotator-13': 2,
                                                                                                                      'protoroles-annotator-20': 0}},
                                                                                   'change_of_state': {'confidence': {'protoroles-annotator-13': 0,
                                                                                                                      'protoroles-annotator-20': 0},
                                                                                                       'value': {'protoroles-annotator-13': 2,
                                                                                                                 'protoroles-annotator-20': 0}},
                                                                                   'change_of_state_continuous': {'confidence': {'protoroles-annotator-13': 0,
                                                                                                                                 'protoroles-annotator-20': 0},
                                                                                                                  'value': {'protoroles-annotator-13': 2,
                                                                                                                            'protoroles-annotator-20': 0}},
                                                                                   'existed_after': {'confidence': {'protoroles-annotator-13': 0,
                                                                                                                    'protoroles-annotator-20': 0},
                                                                                                     'value': {'protoroles-annotator-13': 2,
                                                                                                               'protoroles-annotator-20': 0}},
                                                                                   'existed_before': {'confidence': {'protoroles-annotator-13': 0,
                                                                                                                     'protoroles-annotator-20': 0},
                                                                                                      'value': {'protoroles-annotator-13': 2,
                                                                                                                'protoroles-annotator-20': 0}},
                                                                                   'existed_during': {'confidence': {'protoroles-annotator-13': 0,
                                                                                                                     'protoroles-annotator-20': 0},
                                                                                                      'value': {'protoroles-annotator-13': 2,
                                                                                                                'protoroles-annotator-20': 0}},
                                                                                   'instigation': {'confidence': {'protoroles-annotator-13': 0,
                                                                                                                  'protoroles-annotator-20': 0},
                                                                                                   'value': {'protoroles-annotator-13': 2,
                                                                                                             'protoroles-annotator-20': 0}},
                                                                                   'partitive': {'confidence': {'protoroles-annotator-13': 0,
                                                                                                                'protoroles-annotator-20': 0},
                                                                                                 'value': {'protoroles-annotator-13': 2,
                                                                                                           'protoroles-annotator-20': 0}},
                                                                                   'sentient': {'confidence': {'protoroles-annotator-13': 0,
                                                                                                               'protoroles-annotator-20': 0},
                                                                                                'value': {'protoroles-annotator-13': 2,
                                                                                                          'protoroles-annotator-20': 0}},
                                                                                   'volition': {'confidence': {'protoroles-annotator-13': 0,
                                                                                                               'protoroles-annotator-20': 0},
                                                                                                'value': {'protoroles-annotator-13': 2,
                                                                                                          'protoroles-annotator-20': 0}},
                                                                                   'was_for_benefit': {'confidence': {'protoroles-annotator-13': 0,
                                                                                                                      'protoroles-annotator-20': 0},
                                                                                                       'value': {'protoroles-annotator-13': 2,
                                                                                                                 'protoroles-annotator-20': 0}},
                                                                                   'was_used': {'confidence': {'protoroles-annotator-13': 0,
                                                                                                               'protoroles-annotator-20': 0},
                                                                                                'value': {'protoroles-annotator-13': 2,
                                                                                                          'protoroles-annotator-20': 0}}},
                                                                    'type': 'dependency'},
            ('tree1-semantics-pred-11', 'tree1-semantics-arg-15'): {'domain': 'semantics',
                                                                    'frompredpatt': True,
                                                                    'type': 'dependency'},
            ('tree1-semantics-pred-11', 'tree1-semantics-arg-9'): {'domain': 'semantics',
                                                                   'frompredpatt': True,
                                                                   'protoroles': {'awareness': {'confidence': {'protoroles-annotator-14': 1,
                                                                                                               'protoroles-annotator-16': 1},
                                                                                                'value': {'protoroles-annotator-14': 4,
                                                                                                          'protoroles-annotator-16': 1}},
                                                                                  'change_of_location': {'confidence': {'protoroles-annotator-14': 1,
                                                                                                                        'protoroles-annotator-16': 1},
                                                                                                         'value': {'protoroles-annotator-14': 4,
                                                                                                                   'protoroles-annotator-16': 1}},
                                                                                  'change_of_possession': {'confidence': {'protoroles-annotator-14': 1,
                                                                                                                          'protoroles-annotator-16': 1},
                                                                                                           'value': {'protoroles-annotator-14': 4,
                                                                                                                     'protoroles-annotator-16': 1}},
                                                                                  'change_of_state': {'confidence': {'protoroles-annotator-14': 1,
                                                                                                                     'protoroles-annotator-16': 1},
                                                                                                      'value': {'protoroles-annotator-14': 4,
                                                                                                                'protoroles-annotator-16': 1}},
                                                                                  'change_of_state_continuous': {'confidence': {'protoroles-annotator-14': 1,
                                                                                                                                'protoroles-annotator-16': 1},
                                                                                                                 'value': {'protoroles-annotator-14': 4,
                                                                                                                           'protoroles-annotator-16': 1}},
                                                                                  'existed_after': {'confidence': {'protoroles-annotator-14': 1,
                                                                                                                   'protoroles-annotator-16': 1},
                                                                                                    'value': {'protoroles-annotator-14': 4,
                                                                                                              'protoroles-annotator-16': 1}},
                                                                                  'existed_before': {'confidence': {'protoroles-annotator-14': 1,
                                                                                                                    'protoroles-annotator-16': 1},
                                                                                                     'value': {'protoroles-annotator-14': 4,
                                                                                                               'protoroles-annotator-16': 1}},
                                                                                  'existed_during': {'confidence': {'protoroles-annotator-14': 1,
                                                                                                                    'protoroles-annotator-16': 1},
                                                                                                     'value': {'protoroles-annotator-14': 4,
                                                                                                               'protoroles-annotator-16': 1}},
                                                                                  'instigation': {'confidence': {'protoroles-annotator-14': 1,
                                                                                                                 'protoroles-annotator-16': 1},
                                                                                                  'value': {'protoroles-annotator-14': 4,
                                                                                                            'protoroles-annotator-16': 1}},
                                                                                  'partitive': {'confidence': {'protoroles-annotator-14': 1,
                                                                                                               'protoroles-annotator-16': 1},
                                                                                                'value': {'protoroles-annotator-14': 4,
                                                                                                          'protoroles-annotator-16': 1}},
                                                                                  'sentient': {'confidence': {'protoroles-annotator-14': 1,
                                                                                                              'protoroles-annotator-16': 1},
                                                                                               'value': {'protoroles-annotator-14': 4,
                                                                                                         'protoroles-annotator-16': 1}},
                                                                                  'volition': {'confidence': {'protoroles-annotator-14': 1,
                                                                                                              'protoroles-annotator-16': 1},
                                                                                               'value': {'protoroles-annotator-14': 4,
                                                                                                         'protoroles-annotator-16': 1}},
                                                                                  'was_for_benefit': {'confidence': {'protoroles-annotator-14': 1,
                                                                                                                     'protoroles-annotator-16': 1},
                                                                                                      'value': {'protoroles-annotator-14': 4,
                                                                                                                'protoroles-annotator-16': 1}},
                                                                                  'was_used': {'confidence': {'protoroles-annotator-14': 1,
                                                                                                              'protoroles-annotator-16': 1},
                                                                                               'value': {'protoroles-annotator-14': 4,
                                                                                                         'protoroles-annotator-16': 1}}},
                                                                   'type': 'dependency'},
            ('tree1-semantics-pred-20', 'tree1-semantics-arg-23'): {'domain': 'semantics',
                                                                    'frompredpatt': True,
                                                                    'type': 'dependency'},
            ('tree1-semantics-pred-7', 'tree1-semantics-arg-11'): {'domain': 'semantics',
                                                                   'frompredpatt': True,
                                                                   'type': 'dependency'},
            ('tree1-semantics-pred-7', 'tree1-semantics-arg-3'): {'domain': 'semantics',
                                                                  'frompredpatt': True,
                                                                  'protoroles': {'awareness': {'confidence': {'protoroles-annotator-34': 0,
                                                                                                              'protoroles-annotator-44': 1},
                                                                                               'value': {'protoroles-annotator-34': 0,
                                                                                                         'protoroles-annotator-44': 4}},
                                                                                 'change_of_location': {'confidence': {'protoroles-annotator-34': 0,
                                                                                                                       'protoroles-annotator-44': 1},
                                                                                                        'value': {'protoroles-annotator-34': 0,
                                                                                                                  'protoroles-annotator-44': 4}},
                                                                                 'change_of_possession': {'confidence': {'protoroles-annotator-34': 0,
                                                                                                                         'protoroles-annotator-44': 1},
                                                                                                          'value': {'protoroles-annotator-34': 0,
                                                                                                                    'protoroles-annotator-44': 4}},
                                                                                 'change_of_state': {'confidence': {'protoroles-annotator-34': 0,
                                                                                                                    'protoroles-annotator-44': 1},
                                                                                                     'value': {'protoroles-annotator-34': 0,
                                                                                                               'protoroles-annotator-44': 4}},
                                                                                 'change_of_state_continuous': {'confidence': {'protoroles-annotator-34': 0,
                                                                                                                               'protoroles-annotator-44': 1},
                                                                                                                'value': {'protoroles-annotator-34': 0,
                                                                                                                          'protoroles-annotator-44': 4}},
                                                                                 'existed_after': {'confidence': {'protoroles-annotator-34': 0,
                                                                                                                  'protoroles-annotator-44': 1},
                                                                                                   'value': {'protoroles-annotator-34': 0,
                                                                                                             'protoroles-annotator-44': 4}},
                                                                                 'existed_before': {'confidence': {'protoroles-annotator-34': 0,
                                                                                                                   'protoroles-annotator-44': 1},
                                                                                                    'value': {'protoroles-annotator-34': 0,
                                                                                                              'protoroles-annotator-44': 4}},
                                                                                 'existed_during': {'confidence': {'protoroles-annotator-34': 0,
                                                                                                                   'protoroles-annotator-44': 1},
                                                                                                    'value': {'protoroles-annotator-34': 0,
                                                                                                              'protoroles-annotator-44': 4}},
                                                                                 'instigation': {'confidence': {'protoroles-annotator-34': 0,
                                                                                                                'protoroles-annotator-44': 1},
                                                                                                 'value': {'protoroles-annotator-34': 0,
                                                                                                           'protoroles-annotator-44': 4}},
                                                                                 'partitive': {'confidence': {'protoroles-annotator-34': 0,
                                                                                                              'protoroles-annotator-44': 1},
                                                                                               'value': {'protoroles-annotator-34': 0,
                                                                                                         'protoroles-annotator-44': 4}},
                                                                                 'sentient': {'confidence': {'protoroles-annotator-34': 0,
                                                                                                             'protoroles-annotator-44': 1},
                                                                                              'value': {'protoroles-annotator-34': 0,
                                                                                                        'protoroles-annotator-44': 4}},
                                                                                 'volition': {'confidence': {'protoroles-annotator-34': 0,
                                                                                                             'protoroles-annotator-44': 1},
                                                                                              'value': {'protoroles-annotator-34': 0,
                                                                                                        'protoroles-annotator-44': 4}},
                                                                                 'was_for_benefit': {'confidence': {'protoroles-annotator-34': 0,
                                                                                                                    'protoroles-annotator-44': 1},
                                                                                                     'value': {'protoroles-annotator-34': 0,
                                                                                                               'protoroles-annotator-44': 4}},
                                                                                 'was_used': {'confidence': {'protoroles-annotator-34': 0,
                                                                                                             'protoroles-annotator-44': 1},
                                                                                              'value': {'protoroles-annotator-34': 0,
                                                                                                        'protoroles-annotator-44': 4}}},
                                                                  'type': 'dependency'},
            ('tree1-semantics-pred-root', 'tree1-semantics-arg-0'): {'domain': 'semantics',
                                                                     'frompredpatt': False,
                                                                     'type': 'dependency'},
            ('tree1-semantics-pred-root', 'tree1-semantics-arg-addressee'): {'domain': 'semantics',
                                                                             'frompredpatt': False,
                                                                             'type': 'dependency'},
            ('tree1-semantics-pred-root', 'tree1-semantics-arg-author'): {'domain': 'semantics',
                                                                          'frompredpatt': False,
                                                                          'type': 'dependency'}}

@pytest.fixture
def graph_syntax_edges():
    return {('tree1-root-0', 'tree1-syntax-7'): {'deprel': 'root',
                                                 'domain': 'syntax',
                                                 'type': 'dependency'},
            ('tree1-syntax-11', 'tree1-syntax-10'): {'deprel': 'aux',
                                                     'domain': 'syntax',
                                                     'type': 'dependency'},
            ('tree1-syntax-11', 'tree1-syntax-13'): {'deprel': 'dobj',
                                                     'domain': 'syntax',
                                                     'type': 'dependency'},
            ('tree1-syntax-11', 'tree1-syntax-15'): {'deprel': 'nmod',
                                                     'domain': 'syntax',
                                                     'type': 'dependency'},
            ('tree1-syntax-11', 'tree1-syntax-16'): {'deprel': 'punct',
                                                     'domain': 'syntax',
                                                     'type': 'dependency'},
            ('tree1-syntax-11', 'tree1-syntax-20'): {'deprel': 'advcl',
                                                     'domain': 'syntax',
                                                     'type': 'dependency'},
            ('tree1-syntax-11', 'tree1-syntax-8'): {'deprel': 'mark',
                                                    'domain': 'syntax',
                                                    'type': 'dependency'},
            ('tree1-syntax-11', 'tree1-syntax-9'): {'deprel': 'nsubj',
                                                    'domain': 'syntax',
                                                    'type': 'dependency'},
            ('tree1-syntax-13', 'tree1-syntax-12'): {'deprel': 'nummod',
                                                     'domain': 'syntax',
                                                     'type': 'dependency'},
            ('tree1-syntax-15', 'tree1-syntax-14'): {'deprel': 'case',
                                                     'domain': 'syntax',
                                                     'type': 'dependency'},
            ('tree1-syntax-20', 'tree1-syntax-17'): {'deprel': 'mark',
                                                     'domain': 'syntax',
                                                     'type': 'dependency'},
            ('tree1-syntax-20', 'tree1-syntax-18'): {'deprel': 'expl',
                                                     'domain': 'syntax',
                                                     'type': 'dependency'},
            ('tree1-syntax-20', 'tree1-syntax-19'): {'deprel': 'aux',
                                                     'domain': 'syntax',
                                                     'type': 'dependency'},
            ('tree1-syntax-20', 'tree1-syntax-23'): {'deprel': 'nsubj',
                                                     'domain': 'syntax',
                                                     'type': 'dependency'},
            ('tree1-syntax-23', 'tree1-syntax-21'): {'deprel': 'det',
                                                     'domain': 'syntax',
                                                     'type': 'dependency'},
            ('tree1-syntax-23', 'tree1-syntax-22'): {'deprel': 'amod',
                                                     'domain': 'syntax',
                                                     'type': 'dependency'},
            ('tree1-syntax-23', 'tree1-syntax-26'): {'deprel': 'nmod',
                                                     'domain': 'syntax',
                                                     'type': 'dependency'},
            ('tree1-syntax-26', 'tree1-syntax-24'): {'deprel': 'case',
                                                     'domain': 'syntax',
                                                     'type': 'dependency'},
            ('tree1-syntax-26', 'tree1-syntax-25'): {'deprel': 'det',
                                                     'domain': 'syntax',
                                                     'type': 'dependency'},
            ('tree1-syntax-26', 'tree1-syntax-28'): {'deprel': 'nmod',
                                                     'domain': 'syntax',
                                                     'type': 'dependency'},
            ('tree1-syntax-28', 'tree1-syntax-27'): {'deprel': 'case',
                                                     'domain': 'syntax',
                                                     'type': 'dependency'},
            ('tree1-syntax-3', 'tree1-syntax-1'): {'deprel': 'det',
                                                   'domain': 'syntax',
                                                   'type': 'dependency'},
            ('tree1-syntax-3', 'tree1-syntax-2'): {'deprel': 'compound',
                                                   'domain': 'syntax',
                                                   'type': 'dependency'},
            ('tree1-syntax-3', 'tree1-syntax-6'): {'deprel': 'nmod',
                                                   'domain': 'syntax',
                                                   'type': 'dependency'},
            ('tree1-syntax-6', 'tree1-syntax-4'): {'deprel': 'case',
                                                   'domain': 'syntax',
                                                   'type': 'dependency'},
            ('tree1-syntax-6', 'tree1-syntax-5'): {'deprel': 'compound',
                                                   'domain': 'syntax',
                                                   'type': 'dependency'},
            ('tree1-syntax-7', 'tree1-syntax-11'): {'deprel': 'ccomp',
                                                    'domain': 'syntax',
                                                    'type': 'dependency'},
            ('tree1-syntax-7', 'tree1-syntax-29'): {'deprel': 'punct',
                                                    'domain': 'syntax',
                                                    'type': 'dependency'},
            ('tree1-syntax-7', 'tree1-syntax-3'): {'deprel': 'nsubj',
                                                   'domain': 'syntax',
                                                   'type': 'dependency'}}

@pytest.fixture
def graph_query_results():
    return {('tree1-semantics-pred-7', 'tree1-semantics-arg-3'): {'domain': 'semantics',
                                                                  'frompredpatt': True,
                                                                  'protoroles': {'awareness': {'confidence': 1.0,
                                                                                               'value': 1.3526},
                                                                                 'change_of_location': {'confidence': 0.272,
                                                                                                        'value': -0.0922},
                                                                                 'change_of_possession': {'confidence': 0.7724,
                                                                                                          'value': -0.0},
                                                                                 'change_of_state': {'confidence': 0.2067,
                                                                                                     'value': -0.0548},
                                                                                 'change_of_state_continuous': {'confidence': 1.0,
                                                                                                                'value': -0.0},
                                                                                 'existed_after': {'confidence': 1.0,
                                                                                                   'value': 1.3527},
                                                                                 'existed_before': {'confidence': 1.0,
                                                                                                    'value': 1.3527},
                                                                                 'existed_during': {'confidence': 1.0,
                                                                                                    'value': 1.3557},
                                                                                 'instigation': {'confidence': 1.0,
                                                                                                 'value': 1.3557},
                                                                                 'partitive': {'confidence': 0.1148,
                                                                                               'value': -0.0018},
                                                                                 'sentient': {'confidence': 1.0,
                                                                                              'value': 1.354},
                                                                                 'volition': {'confidence': 1.0,
                                                                                              'value': 1.3545},
                                                                                 'was_for_benefit': {'confidence': 0.1976,
                                                                                                     'value': -0.0504},
                                                                                 'was_used': {'confidence': 0.4373,
                                                                                              'value': -0.0207}},
                                                                  'type': 'dependency'}}


class TestUDSSentenceGraph:

    def test_sentence(self, normalized_sentence_graph,
                      raw_sentence_graph, graph_sentence):
        assert normalized_sentence_graph.sentence == graph_sentence
        assert raw_sentence_graph.sentence == graph_sentence

    def test_syntax_nodes(self, normalized_sentence_graph, raw_sentence_graph, graph_syntax_nodes):
        assert normalized_sentence_graph.syntax_nodes == graph_syntax_nodes
        assert raw_sentence_graph.syntax_nodes == graph_syntax_nodes

    def test_normalized_semantics_nodes(self, normalized_sentence_graph,
                                        graph_normalized_semantics_nodes):
        assert normalized_sentence_graph.semantics_nodes ==\
               graph_normalized_semantics_nodes

    def test_raw_semantics_nodes(self, raw_sentence_graph,
                                 graph_raw_semantics_nodes):
        assert raw_sentence_graph.semantics_nodes ==\
               graph_raw_semantics_nodes

    def test_syntax_edges(self, normalized_sentence_graph,
                          raw_sentence_graph, graph_syntax_edges):
        assert normalized_sentence_graph.syntax_edges() == graph_syntax_edges
        assert raw_sentence_graph.syntax_edges() == graph_syntax_edges

    def test_normalized_semantics_edges(self, normalized_sentence_graph,
                                        graph_normalized_semantics_edges):
        assert normalized_sentence_graph.semantics_edges() ==\
               graph_normalized_semantics_edges

    def test_raw_semantics_edges(self, raw_sentence_graph, graph_raw_semantics_edges):
        assert raw_sentence_graph.semantics_edges() ==\
               graph_raw_semantics_edges

    def test_maxima(self, normalized_sentence_graph, raw_sentence_graph):
        normalized_sentence_graph.maxima() == ['tree1-semantics-pred-root']
        raw_sentence_graph.maxima() == ['tree1-semantics-pred-root']

        noroot_normalized = [nid for nid in normalized_sentence_graph.nodes
                             if nid != 'tree1-semantics-pred-root']
        noroot_raw = [nid for nid in raw_sentence_graph.nodes
                      if nid != 'tree1-semantics-pred-root']
        assert normalized_sentence_graph.maxima(noroot_normalized) == ['tree1-semantics-arg-0',
                                                                       'tree1-semantics-arg-author',
                                                                       'tree1-semantics-arg-addressee']
        assert raw_sentence_graph.maxima(noroot_raw) == ['tree1-semantics-arg-0',
                                                     'tree1-semantics-arg-author',
                                                     'tree1-semantics-arg-addressee']

        noperformative_normalized = [nid for nid in normalized_sentence_graph.nodes
                                     if nid not in ['tree1-semantics-pred-root',
                                                    'tree1-semantics-arg-0',
                                                    'tree1-semantics-arg-author',
                                                    'tree1-semantics-arg-addressee']]
        noperformative_raw = [nid for nid in raw_sentence_graph.nodes
                              if nid not in ['tree1-semantics-pred-root',
                                             'tree1-semantics-arg-0',
                                             'tree1-semantics-arg-author',
                                             'tree1-semantics-arg-addressee']]
        assert normalized_sentence_graph.maxima(noperformative_normalized) == ['tree1-root-0',
                                                                               'tree1-semantics-pred-7',
                                                                               'tree1-semantics-pred-20']
        assert raw_sentence_graph.maxima(noperformative_raw) == ['tree1-root-0',
                                                                 'tree1-semantics-pred-7',
                                                                 'tree1-semantics-pred-20']

    def test_minima(self, normalized_sentence_graph, raw_sentence_graph):
        normalized_sentence_graph.minima() == ['tree1-syntax-1',
                                               'tree1-syntax-2',
                                               'tree1-syntax-4',
                                               'tree1-syntax-5',
                                               'tree1-syntax-8',
                                               'tree1-syntax-9',
                                               'tree1-syntax-10',
                                               'tree1-syntax-12',
                                               'tree1-syntax-14',
                                               'tree1-syntax-16',
                                               'tree1-syntax-17',
                                               'tree1-syntax-18',
                                               'tree1-syntax-19',
                                               'tree1-syntax-21',
                                               'tree1-syntax-22',
                                               'tree1-syntax-24',
                                               'tree1-syntax-25',
                                               'tree1-syntax-27',
                                               'tree1-syntax-29',
                                               'tree1-semantics-arg-author',
                                               'tree1-semantics-arg-addressee']

        raw_sentence_graph.minima() == ['tree1-syntax-1',
                                        'tree1-syntax-2',
                                        'tree1-syntax-4',
                                        'tree1-syntax-5',
                                        'tree1-syntax-8',
                                        'tree1-syntax-9',
                                        'tree1-syntax-10',
                                        'tree1-syntax-12',
                                        'tree1-syntax-14',
                                        'tree1-syntax-16',
                                        'tree1-syntax-17',
                                        'tree1-syntax-18',
                                        'tree1-syntax-19',
                                        'tree1-syntax-21',
                                        'tree1-syntax-22',
                                        'tree1-syntax-24',
                                        'tree1-syntax-25',
                                        'tree1-syntax-27',
                                        'tree1-syntax-29',
                                        'tree1-semantics-arg-author',
                                        'tree1-semantics-arg-addressee']

    def test_query(self, normalized_sentence_graph, graph_query_results):
        querystr = """
                  SELECT ?edge
                  WHERE { ?node ?edge ?arg ;
                                <domain> <semantics> ;
                                <type>   <predicate> ;
                                <pred-particular> ?predparticular
                                FILTER ( ?predparticular > 0 ) .
                          ?arg  <domain> <semantics> ;
                                <type>   <argument>  ;
                                <arg-particular> ?argparticular
                                FILTER ( ?argparticular > 0 ) .
                          { ?edge <volition> ?volition
                                  FILTER ( ?volition > 0 )
                          } UNION
                          { ?edge <sentient> ?sentient
                                  FILTER ( ?sentient > 0 )
                          }
                        }
                  """

        assert normalized_sentence_graph.query(querystr, query_type='edge') == graph_query_results

    def test_to_from_dict(self, normalized_sentence_graph, raw_sentence_graph):
        in_then_out = normalized_sentence_graph.from_dict(normalized_sentence_graph.to_dict(), 'tree1').to_dict()
        assert normalized_sentence_graph.to_dict() == in_then_out
        assert in_then_out == normalized_sentence_graph.from_dict(in_then_out, 'tree1').to_dict()


def test_constructing_rdf_for_graph_with_raw_annotations_fails(raw_sentence_graph):
    graph = raw_sentence_graph
    assert graph._rdf is None  # RDF not yet built

    # attempt to build RDF
    with pytest.raises(TypeError):
        graph.rdf
