# DifferentialAlgebra Package

The DifferentialAlgebra package implements symbolic computation methods
related to Ritt and Kolchin Differential Algebra.

- Joseph Fels Ritt, Differential Algebra, volume 33 of AMS Colloquium 
    Publications, New York, 1950

- Ellis Robert Kolchin, Differential Algebra and Algebraic Groups, 
    Academic Press, 1973

It mostly provides an implementation of a differential elimination algorithm
which is a general simplification method for systems of polynomial differential
equations (ordinary or with partial derivatives).

# Notes

The actual source code is hosted at 

    https://codeberg.org/francois.boulier/DifferentialAlgebra

The source distribution contains the C code of the BLAD and BMI libraries
as well as the file DifferentialAlgebra.c generated by Cython over 

    bmi/sympy/DifferentialAlgebra.pyx

# Dependencies

The package involves an embedded version of mini-gmp.
It depends on the Python sympy package.

