from setuptools import setup, Extension
 
# To build and install from the source distribution
# python3 setup.py build
# python3 -m pip install . --upgrade

setup(
  name="DifferentialAlgebra",
  version="5.0",
  ext_modules=[
    Extension("DifferentialAlgebra",
      define_macros=[("BMI_BUILDING",1),    # Windows
                     ("BLAD_BUILDING",1),   # Windows
                     ("BA0_MEMCHECK",1),    # Could be avoided
                     ("GMP_DECL",""),       # for bmi / Maple / Windows
                     ("BMI_SYMPY",1)],      # for use with sympy
      include_dirs=[".", "./src"],
      extra_compile_args=["-std=c99"],
      libraries=[],
      sources=[
"src/ba0_analex.c",
"src/ba0_array.c",
"src/ba0_basic_io.c",
"src/ba0_common.c",
"src/ba0_copy.c",
"src/ba0_dictionary.c",
"src/ba0_dictionary_string.c",
"src/ba0_dictionary_typed_string.c",
"src/ba0_double.c",
"src/ba0_exception.c",
"src/ba0_format.c",
"src/ba0_garbage.c",
"src/ba0_global.c",
"src/ba0_gmp.c",
"src/ba0_indexed_string.c",
"src/ba0_interval_mpq.c",
"src/ba0_int_p.c",
"src/ba0_list.c",
"src/ba0_matrix.c",
"src/ba0_mesgerr.c",
"src/ba0_mint_hp.c",
"src/ba0_mpzm.c",
"src/ba0_point.c",
"src/ba0_printf.c",
"src/ba0_range_indexed_group.c",
"src/ba0_scanf.c",
"src/ba0_scanf_printf.c",
"src/ba0_small_p.c",
"src/ba0_stack.c",
"src/ba0_string.c",
"src/ba0_table.c",
"src/bad_attchain.c",
"src/bad_base_field.c",
"src/bad_common.c",
"src/bad_critical_pair.c",
"src/bad_global.c",
"src/bad_intersectof_regchain.c",
"src/bad_invert.c",
"src/bad_low_power_theorem.c",
"src/bad_mesgerr.c",
"src/bad_pardi.c",
"src/bad_quadruple.c",
"src/bad_quench_map.c",
"src/bad_quench_regchain.c",
"src/bad_reduced_form.c",
"src/bad_reduction.c",
"src/bad_regchain.c",
"src/bad_regularize.c",
"src/bad_resultant.c",
"src/bad_Rosenfeld_Groebner.c",
"src/bad_selection_strategy.c",
"src/bad_splitting_control.c",
"src/bad_splitting_edge.c",
"src/bad_splitting_tree.c",
"src/bad_splitting_vertex.c",
"src/bad_stats.c",
"src/bai_common.c",
"src/bai_dop853.c",
"src/bai_global.c",
"src/bai_mesgerr.c",
"src/bai_odex.c",
"src/bai_params.c",
"src/bap_add_polynom_mint_hp.c",
"src/bap_add_polynom_mpq.c",
"src/bap_add_polynom_mpz.c",
"src/bap_add_polynom_mpzm.c",
"src/bap__check_mint_hp.c",
"src/bap__check_mpq.c",
"src/bap__check_mpz.c",
"src/bap__check_mpzm.c",
"src/bap_clot_mint_hp.c",
"src/bap_clot_mpq.c",
"src/bap_clot_mpz.c",
"src/bap_clot_mpzm.c",
"src/bap_common.c",
"src/bap_creator_mint_hp.c",
"src/bap_creator_mpq.c",
"src/bap_creator_mpz.c",
"src/bap_creator_mpzm.c",
"src/bap_diff_polynom_mint_hp.c",
"src/bap_diff_polynom_mpq.c",
"src/bap_diff_polynom_mpz.c",
"src/bap_diff_polynom_mpzm.c",
"src/bap_Ducos_mint_hp.c",
"src/bap_Ducos_mpq.c",
"src/bap_Ducos_mpz.c",
"src/bap_Ducos_mpzm.c",
"src/bap_eval_polynom_mint_hp.c",
"src/bap_eval_polynom_mpq.c",
"src/bap_eval_polynom_mpz.c",
"src/bap_eval_polynom_mpzm.c",
"src/bap_geobucket_mint_hp.c",
"src/bap_geobucket_mpq.c",
"src/bap_geobucket_mpz.c",
"src/bap_geobucket_mpzm.c",
"src/bap_indexed_access.c",
"src/bap_invert_mint_hp.c",
"src/bap_invert_mpq.c",
"src/bap_invert_mpzm.c",
"src/bap_iterator_indexed_access.c",
"src/bap_itercoeff_mint_hp.c",
"src/bap_itercoeff_mpq.c",
"src/bap_itercoeff_mpz.c",
"src/bap_itercoeff_mpzm.c",
"src/bap_itermon_mint_hp.c",
"src/bap_itermon_mpq.c",
"src/bap_itermon_mpz.c",
"src/bap_itermon_mpzm.c",
"src/bap_mesgerr.c",
"src/bap_mul_polynom_mint_hp.c",
"src/bap_mul_polynom_mpq.c",
"src/bap_mul_polynom_mpz.c",
"src/bap_mul_polynom_mpzm.c",
"src/bap_parse_polynom_mint_hp.c",
"src/bap_parse_polynom_mpq.c",
"src/bap_parse_polynom_mpz.c",
"src/bap_parse_polynom_mpzm.c",
"src/bap_polynom_mint_hp.c",
"src/bap_polynom_mpq.c",
"src/bap_polynom_mpz.c",
"src/bap_polynom_mpzm.c",
"src/bap_polyspec_mint_hp.c",
"src/bap_polyspec_mpq.c",
"src/bap_polyspec_mpz.c",
"src/bap_polyspec_mpzm.c",
"src/bap_prem_polynom_mint_hp.c",
"src/bap_prem_polynom_mpq.c",
"src/bap_prem_polynom_mpz.c",
"src/bap_prem_polynom_mpzm.c",
"src/bap_product_mint_hp.c",
"src/bap_product_mpq.c",
"src/bap_product_mpz.c",
"src/bap_product_mpzm.c",
"src/bap_termanager.c",
"src/bap_termstripper.c",
"src/bas_beta.c",
"src/bas_common.c",
"src/bas_Denef_Lipshitz.c",
"src/bas_DL_edge.c",
"src/bas_DL_tree.c",
"src/bas_DLuple.c",
"src/bas_DL_vertex.c",
"src/bas_Hurwitz.c",
"src/bas_mesgerr.c",
"src/bas_positive_integer_roots.c",
"src/bas_Yuple.c",
"src/bas_Zuple.c",
"src/bav_block.c",
"src/bav_common.c",
"src/bav_dictionary_symbol.c",
"src/bav_dictionary_variable.c",
"src/bav_differential_ring.c",
"src/bav_global.c",
"src/bav_mesgerr.c",
"src/bav_operator.c",
"src/bav_ordering.c",
"src/bav_parameter.c",
"src/bav_parameters.c",
"src/bav_point.c",
"src/bav_point_interval_mpq.c",
"src/bav_rank.c",
"src/bav_subranking.c",
"src/bav_symbol.c",
"src/bav_term.c",
"src/bav_term_ordering.c",
"src/bav_typed_ident.c",
"src/bav_variable.c",
"src/baz_collect_terms_ratfrac.c",
"src/baz_common.c",
"src/baz_eval_polyspec_mpz.c",
"src/baz_eval_ratfrac.c",
"src/baz_factor_polynom_mpq.c",
"src/baz_factor_polynom_mpz.c",
"src/baz_gcd_polynom_mpz.c",
"src/baz_global.c",
"src/baz_mesgerr.c",
"src/baz_point_ratfrac.c",
"src/baz_polyspec_mpz.c",
"src/baz_prolongation_pattern.c",
"src/baz_prospec_mpz.c",
"src/baz_rat_bilge_mpz.c",
"src/baz_ratfrac.c",
"src/baz_realroot_mpq.c",
"src/baz_rel_ratfrac.c",
"src/bmi_all_derivatives.c",
"src/bmi_attributes.c",
"src/bmi_balsa.c",
"src/bmi_base_field_generators.c",
"src/bmi_belongs_to.c",
"src/bmi_blad_eval.c",
"src/bmi_callback.c",
"src/bmi_coeffs.c",
"src/bmi_dapyx.c",
"src/bmi_delta_polynomial.c",
"src/bmi_Denef_Lipshitz.c",
"src/bmi_Denef_Lipshitz_constraints.c",
"src/bmi_Denef_Lipshitz_leading_polynomial.c",
"src/bmi_Denef_Lipshitz_series.c",
"src/bmi_differential_prem.c",
"src/bmi_differential_ring.c",
"src/bmi_differentiate.c",
"src/bmi_equations.c",
"src/bmi_exported.c",
"src/bmi_factor_derivative.c",
"src/bmi_field_element.c",
"src/bmi_frozen_symbols.c",
"src/bmi_gmp.c",
"src/bmi_indets.c",
"src/bmi_is_constant.c",
"src/bmi_is_orthonomic.c",
"src/bmi_is_reduced.c",
"src/bmi_leading_coefficient.c",
"src/bmi_leading_derivative.c",
"src/bmi_leading_rank.c",
"src/bmi_max_rank_element.c",
"src/bmi_memory.c",
"src/bmi_mesgerr.c",
"src/bmi_min_rank_element.c",
"src/bmi_normal_form.c",
"src/bmi_normal_form_ext.c",
"src/bmi_number_of_equations.c",
"src/bmi_options.c",
"src/bmi_parameters.c",
"src/bmi_pardi.c",
"src/bmi_prem.c",
"src/bmi_preparation_equation.c",
"src/bmi_pretend_regchain.c",
"src/bmi_process_equations.c",
"src/bmi_process_expansion_point.c",
"src/bmi_ranking.c",
"src/bmi_rat_bilge.c",
"src/bmi_reduced_form.c",
"src/bmi_resultant.c",
"src/bmi_Rosenfeld_Groebner.c",
"src/bmi_rtable.c",
"src/bmi_separant.c",
"src/bmi_sort_by_rank.c",
"src/bmi_tail.c",
"src/DifferentialAlgebra.c",
"src/mini-gmp.c",
"src/mini-mpq.c"
      ],
      headers=[
"src/ba0_analex.h",
"src/ba0_array.h",
"src/ba0_basic_io.h",
"src/ba0_common.h",
"src/ba0_config.h",
"src/ba0_copy.h",
"src/ba0_dictionary.h",
"src/ba0_dictionary_string.h",
"src/ba0_dictionary_typed_string.h",
"src/ba0_double.h",
"src/ba0_exception.h",
"src/ba0_format.h",
"src/ba0_garbage.h",
"src/ba0_global.h",
"src/ba0_gmp.h",
"src/ba0.h",
"src/ba0_indexed_string.h",
"src/ba0_interval_mpq.h",
"src/ba0_int_p.h",
"src/ba0_list.h",
"src/ba0_macros_interval_mpq.h",
"src/ba0_macros_mint_hp.h",
"src/ba0_macros_mpq.h",
"src/ba0_macros_mpz.h",
"src/ba0_macros_mpzm.h",
"src/ba0_matrix.h",
"src/ba0_mesgerr.h",
"src/ba0_mint_hp.h",
"src/ba0_mpzm.h",
"src/ba0_point.h",
"src/ba0_printf.h",
"src/ba0_range_indexed_group.h",
"src/ba0_scanf.h",
"src/ba0_scanf_printf.h",
"src/ba0_small_p.h",
"src/ba0_stack.h",
"src/ba0_string.h",
"src/ba0_table.h",
"src/bad_attchain.h",
"src/bad_base_field.h",
"src/bad_common.h",
"src/bad_critical_pair.h",
"src/bad_global.h",
"src/bad.h",
"src/bad_intersectof_regchain.h",
"src/bad_invert.h",
"src/bad_low_power_theorem.h",
"src/bad_mesgerr.h",
"src/bad_pardi.h",
"src/bad_quadruple.h",
"src/bad_quench_map.h",
"src/bad_quench_regchain.h",
"src/bad_reduced_form.h",
"src/bad_reduction.h",
"src/bad_regchain.h",
"src/bad_regularize.h",
"src/bad_resultant.h",
"src/bad_Rosenfeld_Groebner.h",
"src/bad_selection_strategy.h",
"src/bad_splitting_control.h",
"src/bad_splitting_edge.h",
"src/bad_splitting_tree.h",
"src/bad_splitting_vertex.h",
"src/bad_stats.h",
"src/bai_common.h",
"src/bai_dop853_coeffs.h",
"src/bai_dop853.h",
"src/bai_global.h",
"src/bai.h",
"src/bai_mesgerr.h",
"src/bai_odex_function.h",
"src/bai_odex.h",
"src/bai_odex_integrated_function.h",
"src/bai_params.h",
"src/bap_add_polynom_mint_hp.h",
"src/bap_add_polynom_mpq.h",
"src/bap_add_polynom_mpz.h",
"src/bap_add_polynom_mpzm.h",
"src/bap__check_mint_hp.h",
"src/bap__check_mpq.h",
"src/bap__check_mpz.h",
"src/bap__check_mpzm.h",
"src/bap_clot_mint_hp.h",
"src/bap_clot_mpq.h",
"src/bap_clot_mpz.h",
"src/bap_clot_mpzm.h",
"src/bap_common.h",
"src/bap_creator_mint_hp.h",
"src/bap_creator_mpq.h",
"src/bap_creator_mpz.h",
"src/bap_creator_mpzm.h",
"src/bap_diff_polynom_mint_hp.h",
"src/bap_diff_polynom_mpq.h",
"src/bap_diff_polynom_mpz.h",
"src/bap_diff_polynom_mpzm.h",
"src/bap_Ducos_mint_hp.h",
"src/bap_Ducos_mpq.h",
"src/bap_Ducos_mpz.h",
"src/bap_Ducos_mpzm.h",
"src/bap_eval_polynom_mint_hp.h",
"src/bap_eval_polynom_mpq.h",
"src/bap_eval_polynom_mpz.h",
"src/bap_eval_polynom_mpzm.h",
"src/bap_geobucket_mint_hp.h",
"src/bap_geobucket_mpq.h",
"src/bap_geobucket_mpz.h",
"src/bap_geobucket_mpzm.h",
"src/bap.h",
"src/bap_indexed_access.h",
"src/bap_invert_mint_hp.h",
"src/bap_invert_mpq.h",
"src/bap_invert_mpzm.h",
"src/bap_iterator_indexed_access.h",
"src/bap_itercoeff_mint_hp.h",
"src/bap_itercoeff_mpq.h",
"src/bap_itercoeff_mpz.h",
"src/bap_itercoeff_mpzm.h",
"src/bap_itermon_mint_hp.h",
"src/bap_itermon_mpq.h",
"src/bap_itermon_mpz.h",
"src/bap_itermon_mpzm.h",
"src/bap_mesgerr.h",
"src/bap_mul_polynom_mint_hp.h",
"src/bap_mul_polynom_mpq.h",
"src/bap_mul_polynom_mpz.h",
"src/bap_mul_polynom_mpzm.h",
"src/bap_parse_polynom_mint_hp.h",
"src/bap_parse_polynom_mpq.h",
"src/bap_parse_polynom_mpz.h",
"src/bap_parse_polynom_mpzm.h",
"src/bap_polynom_mint_hp.h",
"src/bap_polynom_mpq.h",
"src/bap_polynom_mpz.h",
"src/bap_polynom_mpzm.h",
"src/bap_polyspec_mint_hp.h",
"src/bap_polyspec_mpq.h",
"src/bap_polyspec_mpz.h",
"src/bap_polyspec_mpzm.h",
"src/bap_prem_polynom_mint_hp.h",
"src/bap_prem_polynom_mpq.h",
"src/bap_prem_polynom_mpz.h",
"src/bap_prem_polynom_mpzm.h",
"src/bap_product_mint_hp.h",
"src/bap_product_mpq.h",
"src/bap_product_mpz.h",
"src/bap_product_mpzm.h",
"src/bap_sequential_access.h",
"src/bap_termanager.h",
"src/bap_termstripper.h",
"src/bas_beta.h",
"src/bas_common.h",
"src/bas_Denef_Lipshitz.h",
"src/bas_DL_edge.h",
"src/bas_DL_tree.h",
"src/bas_DLuple.h",
"src/bas_DL_vertex.h",
"src/bas.h",
"src/bas_Hurwitz.h",
"src/bas_mesgerr.h",
"src/bas_positive_integer_roots.h",
"src/bas_Yuple.h",
"src/bas_Zuple.h",
"src/bav_block.h",
"src/bav_common.h",
"src/bav_dictionary_symbol.h",
"src/bav_dictionary_variable.h",
"src/bav_differential_ring.h",
"src/bav_global.h",
"src/bav.h",
"src/bav_mesgerr.h",
"src/bav_operator.h",
"src/bav_ordering.h",
"src/bav_parameter.h",
"src/bav_parameters.h",
"src/bav_point.h",
"src/bav_point_interval_mpq.h",
"src/bav_point_int_p.h",
"src/bav_rank.h",
"src/bav_subranking.h",
"src/bav_symbol.h",
"src/bav_term.h",
"src/bav_term_ordering.h",
"src/bav_typed_ident.h",
"src/bav_variable.h",
"src/baz_collect_terms_ratfrac.h",
"src/baz_common.h",
"src/baz_eval_polyspec_mpz.h",
"src/baz_eval_ratfrac.h",
"src/baz_factor_polynom_mpq.h",
"src/baz_factor_polynom_mpz.h",
"src/baz_gcd_polynom_mpz.h",
"src/baz_global.h",
"src/baz.h",
"src/baz_mesgerr.h",
"src/baz_point_ratfrac.h",
"src/baz_polyspec_mpz.h",
"src/baz_prolongation_pattern.h",
"src/baz_prospec_mpz.h",
"src/baz_rat_bilge_mpz.h",
"src/baz_ratfrac.h",
"src/baz_realroot_mpq.h",
"src/baz_rel_ratfrac.h",
"src/blad.h",
"src/bmi_all_derivatives.h",
"src/bmi_attributes.h",
"src/bmi_balsa.h",
"src/bmi_base_field_generators.h",
"src/bmi_belongs_to.h",
"src/bmi_blad_eval.h",
"src/bmi_callback.h",
"src/bmi_coeffs.h",
"src/bmi_common.h",
"src/bmi_dapyx.h",
"src/bmi_delta_polynomial.h",
"src/bmi_Denef_Lipshitz_constraints.h",
"src/bmi_Denef_Lipshitz.h",
"src/bmi_Denef_Lipshitz_leading_polynomial.h",
"src/bmi_Denef_Lipshitz_series.h",
"src/bmi_differential_prem.h",
"src/bmi_differential_ring.h",
"src/bmi_differentiate.h",
"src/bmi_equations.h",
"src/bmi_exported.h",
"src/bmi_factor_derivative.h",
"src/bmi_field_element.h",
"src/bmi_frozen_symbols.h",
"src/bmi_gmp.h",
"src/bmi.h",
"src/bmi_indets.h",
"src/bmi_indices.h",
"src/bmi_is_constant.h",
"src/bmi_is_orthonomic.h",
"src/bmi_is_reduced.h",
"src/bmi_leading_coefficient.h",
"src/bmi_leading_derivative.h",
"src/bmi_leading_rank.h",
"src/bmi_max_rank_element.h",
"src/bmi_memory.h",
"src/bmi_mesgerr.h",
"src/bmi_min_rank_element.h",
"src/bmi_normal_form_ext.h",
"src/bmi_normal_form.h",
"src/bmi_number_of_equations.h",
"src/bmi_options.h",
"src/bmi_parameters.h",
"src/bmi_pardi.h",
"src/bmi_prem.h",
"src/bmi_preparation_equation.h",
"src/bmi_pretend_regchain.h",
"src/bmi_process_equations.h",
"src/bmi_process_expansion_point.h",
"src/bmi_ranking.h",
"src/bmi_rat_bilge.h",
"src/bmi_reduced_form.h",
"src/bmi_resultant.h",
"src/bmi_Rosenfeld_Groebner.h",
"src/bmi_rtable.h",
"src/bmi_separant.h",
"src/bmi_sort_by_rank.h",
"src/bmi_tail.h",
"src/config.h",
"src/mini-gmp.h",
"src/mini-mpq.h"
      ])
])

