#if !defined (BAD_SPLITTING_EDGE)
#   define BAD_SPLITTING_EDGE 1

#   include "bad_common.h"

BEGIN_C_DECLS

/*
 * texinfo: bad_typeof_splitting_edge
 * This data type is a subtype of @code{bad_splitting_edge}.
 * It permits to associate a type to an edge in the splitting tree
 * generated by @code{bad_Rosenfeld_Groebner}.
 */

enum bad_typeof_splitting_edge
{
// not an edge
  bad_none_edge,
// critical pair leading to a non trivial differential polynomial
  bad_critical_pair_edge,
  bad_critical_pair_novar_edge, // result is base field element
// reduction to zero
  bad_redzero_edge,
// splittings introducing an inequation at each edge
  bad_zero_nonzero_first_edge,  // processing the initial equations
  bad_zero_nonzero_factor_edge, // plain factorization
  bad_zero_nonzero_initial_edge,        // initial
  bad_zero_nonzero_gcd_edge,    // gcd
  bad_zero_nonzero_separant_edge,       // separant
// splittings not introducing inequations
  bad_regularize_edge,          // complete
  bad_reg_characteristic_edge   // reg_characteristic
};

/*
 * texinfo: bad_splitting_edge
 * This data type is a subtype of @code{bad_splitting_vertex}.
 * It permits to describe an edge of the splitting tree
 * generated by a differential elimination algorithm. 
 *
 * The fields @code{src} and @code{dst} contain the @emph{numbers}
 * of the vertices connected by the edge.
 *
 * For some values of the @code{type} field, the leaders of the
 * involved polynomials are provided in the @code{leaders} field.
 * The entry @code{leaders.tab[0]} contains the leader of the
 * polynomial over which the edge operation has been applied.
 * The entries @code{leaders.tab[k]} for @math{k \geq 1} contain 
 * the leaders of the resulting polynomials.
 * 
 * For the type @code{bad_zero_nonzero_separant_edge}, the field @code{leaders}
 * has size @math{2} and @code{leaders.tab[1]} contains the 
 * leader of one of the factors of the separant.
 * The same description holds for the types @code{bad_zero_nonzero_initial_edge}
 * and @code{bad_zero_nonzero_factor_edge}.
 * 
 * For the type @code{bad_zero_nonzero_gcd_edge}, the field @code{leaders}
 * has size greater than or equal to @math{2}. The entries
 * @code{leaders.tab[k]} for @math{k \geq 1} contain the leaders
 * of the polynomials the vanishing of which has been considered
 * in order to secure some gcd.
 *
 * For all other types, the field @code{leaders} has size zero.
 */

struct bad_splitting_edge
{
// the type of the edge
  enum bad_typeof_splitting_edge type;
// the number of the source vertex
  ba0_int_p src;
// the number of the target vertex
  ba0_int_p dst;
// the leaders of the involved polynomials
  struct bav_tableof_variable leaders;
};

struct bad_tableof_splitting_edge
{
  ba0_int_p alloc;
  ba0_int_p size;
  struct bad_splitting_edge **tab;
};


extern BAD_DLL void bad_init_splitting_edge (
    struct bad_splitting_edge *);

extern BAD_DLL struct bad_splitting_edge *bad_new_splitting_edge (
    void);

extern BAD_DLL char *bad_typeof_splitting_edge_to_string (
    enum bad_typeof_splitting_edge);

extern BAD_DLL void bad_set_splitting_edge (
    struct bad_splitting_edge *,
    struct bad_splitting_edge *);

extern BAD_DLL bool bad_has_var_typeof_splitting_edge (
    enum bad_typeof_splitting_edge);

extern BAD_DLL bool bad_zero_nonzero_typeof_splitting_edge (
    enum bad_typeof_splitting_edge);

extern BAD_DLL struct bav_symbol *bad_src_symbol_splitting_edge (
    struct bad_splitting_edge *);

extern BAD_DLL void bad_set_tvsd_splitting_edge (
    struct bad_splitting_edge *,
    enum bad_typeof_splitting_edge,
    ba0_int_p,
    struct bav_variable *,
    ba0_int_p,
    struct bav_variable *);

extern BAD_DLL void bad_set_tsdl_splitting_edge (
    struct bad_splitting_edge *,
    enum bad_typeof_splitting_edge,
    ba0_int_p,
    ba0_int_p,
    struct bav_tableof_variable *);

extern BAD_DLL ba0_scanf_function bad_scanf_splitting_edge;

extern BAD_DLL ba0_printf_function bad_printf_splitting_edge;

extern BAD_DLL ba0_garbage1_function bad_garbage1_splitting_edge;

extern BAD_DLL ba0_garbage2_function bad_garbage2_splitting_edge;

extern BAD_DLL ba0_copy_function bad_copy_splitting_edge;


END_C_DECLS
#endif
