#if !defined (BAI_ODEX_INTEGRATED_FUNCTION_H)
#   define BAI_ODEX_INTEGRATED_FUNCTION_H 1

/* 
 * The signatures of the function which evaluate the righthand side
 * of the ODE system to be integrated by explicit ODE integrators and 
 * its jacobian matrix.
 *
 * Signatures are compatible with that defined in the Gnu Scientific Library.
 */

#   include "bai_common.h"
#   include "bai_odex_function.h"

BEGIN_C_DECLS

typedef enum bai_exit_code bai_odex_integrated_function (
// the independent variable
    double t,
// the current values of the dependent variables
    double *x,
// the output vector f(x)
    double *f,
// if the function is generated by bai_odex_generate_C_code,
// params points to a struct bai_parameters
    void *params);

typedef enum bai_exit_code bai_odex_jacobianof_integrated_function (
// the independent variable
    double t,
// the current values of the dependent variables
    double *x,
// the output row-ordered Jacobian matrix
// same convention as the GSL
    double *J,
// the output vector df/dt (x)
    double *K,
// if the function is generated by bai_odex_generate_C_code,
// params points to a struct bai_parameters
    void *params);

END_C_DECLS
#endif /* !BAI_ODEX_INTEGRATED_FUNCTION_H */
