#if ! defined (BAS_DL_EDGE_H)
#   define BAS_DL_EDGE_H 1

#   include "bas_common.h"

BEGIN_C_DECLS

/*
 * texinfo: bas_typeof_DL_edge
 * This data type is a subtype of @code{bas_DL_edge}.
 * It permits to associate a type to an edge in the DL tree
 * generated by the @code{DenefLipshitz_leaf} algorithm.
 */

enum bas_typeof_DL_edge
{
// not an edge
  bas_none_edge,
// investigation of some coefficient being zero
  bas_vanishing_edge,
// investigation of some coefficient being nonzero
  bas_non_vanishing_edge,
// splitting due to regular chain decomposition
  bas_RG_edge
};

/*
 * texinfo: bas_DL_edge
 * This data type is a subtype of @code{struct bas_DL_vertex} and
 * @code{struct bas_DL_tree}. The @code{bas_DenefLipshitz_leaf}
 * function is led to consider some polynomials which may possibly
 * vanish. In such cases, two cases are generated: the one in which
 * the polynomial under consideration vanish and the one in which
 * it does not. 
 * The two corresponding types are @code{bas_vanishing_edge} and
 * @code{bas_non_vanishing_edge}.
 * The @code{bas_DenefLipshitz_leaf} function is also
 * led to generate prolongation equations, which are simplified by
 * a regular chain decomposition algorithm, possibly yielding some
 * case discussion. The corresponding branches have type
 * @code{bas_RG_edge}.
 */

struct bas_DL_edge
{
// the type of the edge
  enum bas_typeof_DL_edge type;
// the number of the source vertex
  ba0_int_p src;
// the number of the target vertex
  ba0_int_p dst;
};

struct bas_tableof_DL_edge
{
  ba0_int_p alloc;
  ba0_int_p size;
  struct bas_DL_edge **tab;
};


extern BAS_DLL void bas_init_DL_edge (
    struct bas_DL_edge *);

extern BAS_DLL struct bas_DL_edge *bas_new_DL_edge (
    void);

extern BAS_DLL char *bas_typeof_DL_edge_to_string (
    enum bas_typeof_DL_edge);

extern BAS_DLL void bas_set_DL_edge (
    struct bas_DL_edge *,
    struct bas_DL_edge *);

extern BAS_DLL void bas_set_tsd_DL_edge (
    struct bas_DL_edge *,
    enum bas_typeof_DL_edge,
    ba0_int_p,
    ba0_int_p);

extern BAS_DLL ba0_scanf_function bas_scanf_DL_edge;

extern BAS_DLL ba0_printf_function bas_printf_DL_edge;

extern BAS_DLL ba0_garbage1_function bas_garbage1_DL_edge;

extern BAS_DLL ba0_garbage2_function bas_garbage2_DL_edge;

extern BAS_DLL ba0_copy_function bas_copy_DL_edge;

END_C_DECLS
#endif /* !BAS_DL_EDGE_H */
