#if !defined (BAS_DL_TREE_H)
#   define BAS_DL_TREE_H 1

#   include "bas_DL_vertex.h"

BEGIN_C_DECLS

/*
 * texinfo: bas_activity_level_DL_tree
 * This data type is a subtype of @code{bas_DL_tree}.
 */

enum bas_activity_level_DL_tree
{
// the DL tree is not generated
  bas_inactive_DL_tree,
// the DL tree is generated
  bas_quiet_DL_tree,
// the DL tree is generated and messages are printed
  bas_verbose_DL_tree
};

/*
 * texinfo: bas_DL_tree
 * This data type permits to describe the DL tree generated by the
 * @code{bas_Denef_Lipshitz_leaf} function.
 *
 * The field @code{roots} contains the numbers of the different
 * roots of the different trees (the data structure actually contains
 * a forrest rather than a single tree).
 *
 * The field @code{vertices} contains the table of the tree vertices.
 * Each vertex is associated to one Zuple, identified
 * by its @emph{number}. This @emph{number} is moreover equal to
 * the index of the vertex in the table. 
 *
 * The field @code{number} contains the next free vertex number.
 * It may be greater than the @code{alloc} field of the @code{vertices}
 * table.
 *
 * The field @code{activity} provides the level of activity of the
 * tree. It may have three values:
 * @itemize
 * @item @code{bas_inactive_DL_tree} then the only active field
 * if @code{number} and the two tables remain empty~;
 * @item @code{bas_quiet_DL_tree} then the DL tree is generated
 * @item @code{bas_verbose_DL_tree} same as above but the
 * the @code{bas_Denef_Lipshitz_leaf} function may print some 
 * further data on the standard output.
 * @end itemize
 */

struct bas_DL_tree
{
  enum bas_activity_level_DL_tree activity;
// the table of the roots
  struct ba0_tableof_int_p roots;
// the table of vertices
  struct bas_tableof_DL_vertex vertices;
// the next free vertex number
  ba0_int_p number;
};

extern BAS_DLL void bas_init_DL_tree (
    struct bas_DL_tree *);

extern BAS_DLL struct bas_DL_tree *bas_new_DL_tree (
    void);

extern BAS_DLL void bas_reset_DL_tree (
    struct bas_DL_tree *,
    enum bas_activity_level_DL_tree);

extern BAS_DLL void bas_set_DL_tree (
    struct bas_DL_tree *,
    struct bas_DL_tree *);

extern BAS_DLL void bas_add_root_DL_tree (
    struct bas_DL_tree *,
    ba0_int_p);

extern BAS_DLL ba0_int_p bas_next_number_DL_tree (
    struct bas_DL_tree *);

extern BAS_DLL struct bas_DL_vertex *bas_ith_vertex_DL_tree (
    struct bas_DL_tree *,
    ba0_int_p);

extern BAS_DLL void bas_set_vertex_consistency_DL_tree (
    struct bas_DL_tree *,
    ba0_int_p,
    enum bas_typeof_consistency_vertex);

extern BAS_DLL void bas_set_aykrd_vertex_DL_tree (
    struct bas_DL_tree *,
    ba0_int_p,
    enum bas_typeof_action_on_Zuple,
    struct bav_symbol *,
    ba0_int_p,
    ba0_int_p,
    ba0_int_p);

extern BAS_DLL void bas_add_edge_DL_tree (
    struct bas_DL_tree *,
    enum bas_typeof_DL_edge,
    ba0_int_p,
    ba0_int_p);

extern BAS_DLL void bas_dot_DL_tree (
    struct bas_DL_tree *);

extern BAS_DLL ba0_scanf_function bas_scanf_DL_tree;

extern BAS_DLL ba0_printf_function bas_printf_DL_tree;

extern BAS_DLL ba0_garbage1_function bas_garbage1_DL_tree;

extern BAS_DLL ba0_garbage2_function bas_garbage2_DL_tree;

extern BAS_DLL ba0_copy_function bas_copy_DL_tree;

END_C_DECLS
#endif
