/* ba0/src/config.h.  Generated from config-h.in by configure.  */
/* ba0/src/config-h.in.  Generated from configure.ac by autoheader.  */

/* If defined, compile for a 64 bits architecture */
#define BA0_64BITS 1

/* To be defined when generating Apple Universal OSX code */
/* #undef BA0_APPLE_UNIVERSAL_OSX */

/* If defined, force the value of BA0_ALIGN */
/* #undef BA0_FORCE_ALIGN */

/* If defined, use GMP rather than MINI-GMP */
/* #undef BA0_USE_GMP */

/* If defined, use sigsetjmp rather than setjmp */
/* #undef BA0_USE_SIGSETJMP */

/* Define to 1 if you have the <ctype.h> header file. */
#define HAVE_CTYPE_H 1

/* Define to 1 if you have the <dlfcn.h> header file. */
#define HAVE_DLFCN_H 1

/* The GNU SCIENTIFIC LIBRARY If defined, some tests relying on the GSL are
   performed */
/* #undef HAVE_GSL_H */

/* Define to 1 if you have the <ieeefp.h> header file. */
/* #undef HAVE_IEEEFP_H */

/* Define to 1 if you have the <inttypes.h> header file. */
#define HAVE_INTTYPES_H 1

/* Define to 1 if you have the <io.h> header file. */
/* #undef HAVE_IO_H */

/* Define to 1 if you have the <limits.h> header file. */
#define HAVE_LIMITS_H 1

/* Define to 1 if you have the <math.h> header file. */
#define HAVE_MATH_H 1

/* Define to 1 if you have the <setjmp.h> header file. */
#define HAVE_SETJMP_H 1

/* Define to 1 if you have the <stdarg.h> header file. */
#define HAVE_STDARG_H 1

/* Define to 1 if you have the <stdbool.h> header file. */
#define HAVE_STDBOOL_H 1

/* Define to 1 if you have the <stdint.h> header file. */
#define HAVE_STDINT_H 1

/* Define to 1 if you have the <stdio.h> header file. */
#define HAVE_STDIO_H 1

/* Define to 1 if you have the <stdlib.h> header file. */
#define HAVE_STDLIB_H 1

/* Define to 1 if you have the <strings.h> header file. */
#define HAVE_STRINGS_H 1

/* Define to 1 if you have the <string.h> header file. */
#define HAVE_STRING_H 1

/* Define to 1 if you have the <sys/stat.h> header file. */
#define HAVE_SYS_STAT_H 1

/* Define to 1 if you have the <sys/types.h> header file. */
#define HAVE_SYS_TYPES_H 1

/* Define to 1 if you have the <time.h> header file. */
#define HAVE_TIME_H 1

/* Define to 1 if you have the <unistd.h> header file. */
#define HAVE_UNISTD_H 1

/* Define to the sub-directory where libtool stores uninstalled libraries. */
#define LT_OBJDIR ".libs/"

/* Name of package */

/* Define to the address where bug reports for this package should be sent. */
#define BLAD_BUGREPORT ""

/* Define to the full name of this package. */
#define BLAD_NAME "blad"

/* Define to the full name and version of this package. */
#define BLAD_STRING "blad 5.0"

/* Define to the one symbol short name of this package. */
#define BLAD_TARNAME "blad"

/* Define to the home page for this package. */
#define BLAD_URL ""

/* Define to the version of this package. */
#define BLAD_VERSION "5.0"

/* Define to 1 if all of the C89 standard headers exist (not just the ones
   required in a freestanding environment). This macro is provided for
   backward compatibility; new code need not use it. */
#define STDC_HEADERS 1

/* Version number of package */
#if !defined (BA0_COMMON_H)
#   define BA0_COMMON_H 1

/* 
 * The _MSC_VER flag is set if the code is compiled under WINDOWS
 * by using Microsoft Visual C (through Visual Studio 2008).
 *
 * In that case, some specific annotations must be added for DLL exports
 * Beware to the fact that this header file is going to be used either
 * for/while building BLAD or for using BLAD from an outer software.
 *
 * In the first case, functions are exported.
 * In the second one, they are imported.
 *
 * The flag BA0_BLAD_BUILDING must thus be set in the Makefile and passed 
 * to the C preprocessor at BA0 building time. Do not set it when using BA0.
 *
 * When compiling static libraries under Windows, set BA0_STATIC.
 */

#   if defined (_MSC_VER) && ! defined (BA0_STATIC)
#      if defined (BLAD_BUILDING) || defined (BA0_BLAD_BUILDING)
#         	define BA0_DLL	__declspec(dllexport)
#      else
#         define BA0_DLL	__declspec(dllimport)
#      endif
#   else
#      define BA0_DLL
#   endif

/* 
 * The __cplusplus flag is set if the code is compiled by a C++ compiler
 */

#   if defined (__cplusplus) && !defined (BEGIN_C_DECLS)
#      define BEGIN_C_DECLS   extern "C" {
#      define END_C_DECLS     }
#   else
#      define BEGIN_C_DECLS
#      define END_C_DECLS
#   endif

/* 
 * This one we generate
 */

/* #   include "ba0_config.h" */

/* 
 * Windows setting
 */

#   if defined (_MSC_VER)
#      undef  HAVE_DLFCN_H
#      undef  HAVE_INTTYPES_H
#      undef  HAVE_STDINT_H
#      undef  HAVE_STRINGS_H
#      undef  HAVE_SYS_STAT_H
#      undef  HAVE_SYS_TYPES_H
#      undef  HAVE_UNISTD_H

#      undef  BA0_USE_SIGSETJMP

#      define HAVE_IO_H 1
#      define HAVE_FLOAT_H 1

#      undef  HAVE_GSL_H
#      undef  HAVE_MPFR_H
#   endif

#   if HAVE_STDIO_H
#      include <stdio.h>
#   endif

#   if HAVE_STDLIB_H
#      include <stdlib.h>
#   endif

#   if HAVE_UNISTD_H
#      include <unistd.h>
#   endif

#   if HAVE_STDARG_H
#      include <stdarg.h>
#   endif

#   if HAVE_STDBOOL_H
#      include <stdbool.h>
#   else
#      define bool	int
#      define false	0
#      define true	1
#   endif

#   if HAVE_LIMITS_H
#      include <limits.h>
#   endif

#   if HAVE_STRINGS_H
#      include <strings.h>
#   endif

#   if HAVE_STRING_H
#      include <string.h>
#   endif

#   if HAVE_CTYPE_H
#      include <ctype.h>
#   endif

#   if HAVE_TIME_H
#      include <time.h>
#   endif

#   if HAVE_MATH_H
#      include <math.h>
#   endif

#   if HAVE_FLOAT_H
#      include <float.h>
#   endif

#   if HAVE_SETJMP_H
#      include <setjmp.h>
#   endif
#   if BA0_USE_SIGSETJMP
#      define ba0_jmp_buf sigjmp_buf
#      define ba0_setjmp(env,flag) sigsetjmp(env,flag)
#      define ba0_longjmp(env,sig) siglongjmp(env,sig)
#   else
#      define ba0_jmp_buf jmp_buf
#      define ba0_setjmp(env,flag) setjmp(env)
#      define ba0_longjmp(env,sig) longjmp(env,sig)
#   endif

/* 
 * io.h is Windows specific
 */

#   if !defined (HAVE_IO_H)

/*
 * header undefined with -std=c99
 */

extern int fileno (
    FILE *);

#      define ba0_isatty isatty
#      define ba0_fileno fileno
#   else
#      include <io.h>
#      define ba0_isatty _isatty
#      define ba0_fileno _fileno
#   endif

#   if defined (BA0_FORCE_64BITS)
#      undef BA0_64BITS
#      define BA0_64BITS 1
#   else
#      if defined (BA0_FORCE_32BITS)
#         undef BA0_64BITS
#      endif
#   endif

/* 
 * Largest small prime numbers
 */

#   define BA0_MAX_PRIME_32BITS    4294967291
#   define BA0_MAX_PRIME_16BITS    65521

/* 
 * Used to be: _MSC_VER + BA0_64BITS ==> BA0_USE_X64_GMP
 */

/* 
 * ba0_int_p integer of the size of a pointer 
 * ba0_int_hp of the size of half a pointer (except for APPLE_UNIVERSAL_OSX)
 */

#   if defined (BA0_64BITS)
#      if defined (_MSC_VER)
#         define ba0_int_p long long
#         define ba0_int_hp	int
#         define ba0_mint_hp	unsigned ba0_int_hp
#         define BA0_FORMAT_INT_P	"%lld"
#         define BA0_FORMAT_HEXINT_P	"0x%llx"
#         define BA0_ALIGN	8
#         define BA0_MAX_INT_P	LLONG_MAX
#         define BA0_MAX_INT_HP	INT_MAX
#         define BA0_MAX_MINT_HP	UINT_MAX
#         define BA0_MAX_PRIME_MINT_HP	BA0_MAX_PRIME_32BITS
#      else
#         define ba0_int_p	long int
#         define ba0_int_hp	int
#         define ba0_mint_hp	unsigned ba0_int_hp
#         define BA0_FORMAT_INT_P	"%ld"
#         define BA0_FORMAT_HEXINT_P	"0x%lx"
#         define BA0_ALIGN	8
#         define BA0_MAX_INT_P	LONG_MAX
#         define BA0_MAX_INT_HP	INT_MAX
#         define BA0_MAX_MINT_HP	UINT_MAX
#         define BA0_MAX_PRIME_MINT_HP	BA0_MAX_PRIME_32BITS
#      endif
#   else
#      define ba0_int_p	int
#      define ba0_int_hp	short int
#      define ba0_mint_hp	unsigned ba0_int_hp
#      define BA0_FORMAT_INT_P        "%d"
#      define BA0_FORMAT_HEXINT_P	"0x%x"
#      define BA0_ALIGN	4
#      define BA0_MAX_INT_P	INT_MAX
#      define BA0_MAX_INT_HP	SHRT_MAX
#      define BA0_MAX_MINT_HP	USHRT_MAX
#      define BA0_MAX_PRIME_MINT_HP	BA0_MAX_PRIME_16BITS
#   endif

/* 
 * On 32 bits Solaris, 64 bits alignment is mandatory for double 
 * BA0_FORCE_ALIGN=8 is used in that case.
 */

#   if defined (BA0_FORCE_ALIGN)
#      undef BA0_ALIGN
#      define BA0_ALIGN BA0_FORCE_ALIGN
#   endif

#   define BA0_BUFSIZE	256

#   define BA0_NBBITS_INT_P	(CHAR_BIT * sizeof(ba0_int_p))
#   define BA0_NBBITS_INT_HP	(CHAR_BIT * sizeof(ba0_int_hp))

#   define BA0_ABS(z) ((z) >= 0 ? (z) : - (z))
#   define BA0_MAX(x,y) ((x) >= (y) ? (x) : (y))
#   define BA0_MIN(x,y) ((x) >= (y) ? (y) : (x))
#   define BA0_SWAP(type,x,y) do { type _bunk_ = x; x = y; y = _bunk_; } while (0)

#   define BA0_NOT_AN_INDEX -1

/* 
 * Type declarations
 */

BEGIN_C_DECLS

enum ba0_compare_code
{
  ba0_lt,
  ba0_eq,
  ba0_equiv,
  ba0_gt
};

enum ba0_sort_mode
{
  ba0_descending_mode,
  ba0_ascending_mode
};

/*
 * texinfo: ba0_garbage_code
 * This data type is passed as an argument to @code{ba0_garbage1_function}
 * and @code{ba0_garbage2_function} functions when applying the garbage
 * collector to a data structure. 
 */

enum ba0_garbage_code
{
// the data structure stands alone
  ba0_isolated,
// the data structure is a field of a bigger data structure
  ba0_embedded
};

enum ba0_restart_level
{
  ba0_init_level = 1,
  ba0_reset_level,
  ba0_done_level
};

enum ba0_wang_code
{
  ba0_rational_found,
  ba0_rational_not_found,
  ba0_zero_divisor
};

typedef void *ba0_scanf_function (
    void *);

typedef void ba0_printf_function (
    void *);

typedef ba0_int_p ba0_garbage1_function (
    void *,
    enum ba0_garbage_code);

typedef void *ba0_garbage2_function (
    void *,
    enum ba0_garbage_code);

typedef void *ba0_copy_function (
    void *);

typedef void *ba0_unary_function (
    void *);

typedef bool ba0_cmp_function (
    void *,
    void *);

typedef bool ba0_cmp2_function (
    void *,
    void *,
    void *);

typedef bool ba0_unary_predicate (
    void *);

typedef void *ba0_new_function (
    void);

typedef void ba0_set_function (
    void *,
    void *);

typedef void ba0_init_function (
    void *);

typedef void ba0_unary_operation (
    void *);

typedef void ba0_binary_operation (
    void *,
    void *);

typedef void ba0_ternary_operation (
    void *,
    void *,
    void *);

extern BA0_DLL void ba0_reset_all_settings (
    void);

extern BA0_DLL void ba0_set_settings_interrupt (
    void (*)(void),
    time_t);

extern BA0_DLL void ba0_set_settings_common (
    enum ba0_restart_level);

extern BA0_DLL void ba0_get_settings_interrupt (
    void (**)(void),
    time_t *);

extern BA0_DLL void ba0_set_settings_no_oot (
    bool);

extern BA0_DLL void ba0_get_settings_no_oot (
    bool *);

extern BA0_DLL void ba0_get_settings_common (
    enum ba0_restart_level *);

struct ba0_PFE_settings;

extern BA0_DLL void ba0_cancel_PFE_settings (
    struct ba0_PFE_settings *);

extern BA0_DLL void ba0_restore_PFE_settings (
    struct ba0_PFE_settings *);

extern BA0_DLL void ba0_process_check_interrupt (
    void);

extern BA0_DLL char *ba0_get_version (
    void);

extern BA0_DLL void ba0_restart (
    ba0_int_p,
    ba0_int_p);

extern BA0_DLL void ba0_terminate (
    enum ba0_restart_level);

END_C_DECLS
#endif /* !BA0_COMMON_H */
/* mini-gmp, a minimalistic implementation of a GNU GMP subset.

Copyright 2011-2015, 2017, 2019-2021 Free Software Foundation, Inc.

This file is part of the GNU MP Library.

The GNU MP Library is free software; you can redistribute it and/or modify
it under the terms of either:

  * the GNU Lesser General Public License as published by the Free
    Software Foundation; either version 3 of the License, or (at your
    option) any later version.

or

  * the GNU General Public License as published by the Free Software
    Foundation; either version 2 of the License, or (at your option) any
    later version.

or both in parallel, as here.

The GNU MP Library is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received copies of the GNU General Public License and the
GNU Lesser General Public License aba0_int_p with the GNU MP Library.  If not,
see https://www.gnu.org/licenses/.  */

/* About mini-gmp: This is a minimal implementation of a subset of the
   GMP interface. It is intended for inclusion into applications which
   have modest bignums needs, as a fallback when the real GMP library
   is not installed.

   This file defines the public interface. */

#if !defined (__MINI_GMP_H__)
#define __MINI_GMP_H__
/* #include "ba0_common.h" */

/* For size_t */
#include <stddef.h>

#if defined (__cplusplus)
extern "C" {
#endif

void bam_mp_set_memory_functions (void *(*) (size_t),
                  void *(*) (void *, size_t, size_t),
                  void (*) (void *, size_t));

void bam_mp_get_memory_functions (void *(**) (size_t),
                  void *(**) (void *, size_t, size_t),
                  void (**) (void *, size_t));

#if !defined (MINI_GMP_LIMB_TYPE)
#define MINI_GMP_LIMB_TYPE ba0_int_p
#endif

typedef unsigned MINI_GMP_LIMB_TYPE bam_mp_limb_t;
typedef ba0_int_p bam_mp_size_t;
typedef unsigned ba0_int_p bam_mp_bitcnt_t;

typedef bam_mp_limb_t *bam_mp_ptr;
typedef const bam_mp_limb_t *bam_mp_srcptr;

typedef struct
{
  int _mp_alloc;        /* Number of *limbs* allocated and pointed
                   to by the _mp_d field.  */
  int _mp_size;            /* abs(_mp_size) is the number of limbs the
                   last field points to.  If _mp_size is
                   negative this is a negative number.  */
  bam_mp_limb_t *_mp_d;        /* Pointer to the limbs.  */
} bam__mpz_struct;

typedef bam__mpz_struct bam_mpz_t[1];

typedef bam__mpz_struct *bam_mpz_ptr;
typedef const bam__mpz_struct *bam_mpz_srcptr;

extern const int bam_mp_bits_per_limb;

void bam_mpn_copyi (bam_mp_ptr, bam_mp_srcptr, bam_mp_size_t);
void bam_mpn_copyd (bam_mp_ptr, bam_mp_srcptr, bam_mp_size_t);
void bam_mpn_zero (bam_mp_ptr, bam_mp_size_t);

int bam_mpn_cmp (bam_mp_srcptr, bam_mp_srcptr, bam_mp_size_t);
int bam_mpn_zero_p (bam_mp_srcptr, bam_mp_size_t);

bam_mp_limb_t bam_mpn_add_1 (bam_mp_ptr, bam_mp_srcptr, bam_mp_size_t, bam_mp_limb_t);
bam_mp_limb_t bam_mpn_add_n (bam_mp_ptr, bam_mp_srcptr, bam_mp_srcptr, bam_mp_size_t);
bam_mp_limb_t bam_mpn_add (bam_mp_ptr, bam_mp_srcptr, bam_mp_size_t, bam_mp_srcptr, bam_mp_size_t);

bam_mp_limb_t bam_mpn_sub_1 (bam_mp_ptr, bam_mp_srcptr, bam_mp_size_t, bam_mp_limb_t);
bam_mp_limb_t bam_mpn_sub_n (bam_mp_ptr, bam_mp_srcptr, bam_mp_srcptr, bam_mp_size_t);
bam_mp_limb_t bam_mpn_sub (bam_mp_ptr, bam_mp_srcptr, bam_mp_size_t, bam_mp_srcptr, bam_mp_size_t);

bam_mp_limb_t bam_mpn_mul_1 (bam_mp_ptr, bam_mp_srcptr, bam_mp_size_t, bam_mp_limb_t);
bam_mp_limb_t bam_mpn_addmul_1 (bam_mp_ptr, bam_mp_srcptr, bam_mp_size_t, bam_mp_limb_t);
bam_mp_limb_t bam_mpn_submul_1 (bam_mp_ptr, bam_mp_srcptr, bam_mp_size_t, bam_mp_limb_t);

bam_mp_limb_t bam_mpn_mul (bam_mp_ptr, bam_mp_srcptr, bam_mp_size_t, bam_mp_srcptr, bam_mp_size_t);
void bam_mpn_mul_n (bam_mp_ptr, bam_mp_srcptr, bam_mp_srcptr, bam_mp_size_t);
void bam_mpn_sqr (bam_mp_ptr, bam_mp_srcptr, bam_mp_size_t);
int bam_mpn_perfect_square_p (bam_mp_srcptr, bam_mp_size_t);
bam_mp_size_t bam_mpn_sqrtrem (bam_mp_ptr, bam_mp_ptr, bam_mp_srcptr, bam_mp_size_t);

bam_mp_limb_t bam_mpn_lshift (bam_mp_ptr, bam_mp_srcptr, bam_mp_size_t, unsigned int);
bam_mp_limb_t bam_mpn_rshift (bam_mp_ptr, bam_mp_srcptr, bam_mp_size_t, unsigned int);

bam_mp_bitcnt_t bam_mpn_scan0 (bam_mp_srcptr, bam_mp_bitcnt_t);
bam_mp_bitcnt_t bam_mpn_scan1 (bam_mp_srcptr, bam_mp_bitcnt_t);

void bam_mpn_com (bam_mp_ptr, bam_mp_srcptr, bam_mp_size_t);
bam_mp_limb_t bam_mpn_neg (bam_mp_ptr, bam_mp_srcptr, bam_mp_size_t);

bam_mp_bitcnt_t bam_mpn_popcount (bam_mp_srcptr, bam_mp_size_t);

bam_mp_limb_t bam_mpn_invert_3by2 (bam_mp_limb_t, bam_mp_limb_t);
#define bam_mpn_invert_limb(x) bam_mpn_invert_3by2 ((x), 0)

size_t bam_mpn_get_str (unsigned char *, int, bam_mp_ptr, bam_mp_size_t);
bam_mp_size_t bam_mpn_set_str (bam_mp_ptr, const unsigned char *, size_t, int);

void bam_mpz_init (bam_mpz_t);
void bam_mpz_init2 (bam_mpz_t, bam_mp_bitcnt_t);
void bam_mpz_clear (bam_mpz_t);

#define bam_mpz_odd_p(z)   (((z)->_mp_size != 0) & (int) (z)->_mp_d[0])
#define bam_mpz_even_p(z)  (! bam_mpz_odd_p (z))

int bam_mpz_sgn (const bam_mpz_t);
int bam_mpz_cmp_si (const bam_mpz_t, ba0_int_p);
int bam_mpz_cmp_ui (const bam_mpz_t, unsigned ba0_int_p);
int bam_mpz_cmp (const bam_mpz_t, const bam_mpz_t);
int bam_mpz_cmpabs_ui (const bam_mpz_t, unsigned ba0_int_p);
int bam_mpz_cmpabs (const bam_mpz_t, const bam_mpz_t);
int bam_mpz_cmp_d (const bam_mpz_t, double);
int bam_mpz_cmpabs_d (const bam_mpz_t, double);

void bam_mpz_abs (bam_mpz_t, const bam_mpz_t);
void bam_mpz_neg (bam_mpz_t, const bam_mpz_t);
void bam_mpz_swap (bam_mpz_t, bam_mpz_t);

void bam_mpz_add_ui (bam_mpz_t, const bam_mpz_t, unsigned ba0_int_p);
void bam_mpz_add (bam_mpz_t, const bam_mpz_t, const bam_mpz_t);
void bam_mpz_sub_ui (bam_mpz_t, const bam_mpz_t, unsigned ba0_int_p);
void bam_mpz_ui_sub (bam_mpz_t, unsigned ba0_int_p, const bam_mpz_t);
void bam_mpz_sub (bam_mpz_t, const bam_mpz_t, const bam_mpz_t);

void bam_mpz_mul_si (bam_mpz_t, const bam_mpz_t, ba0_int_p);
void bam_mpz_mul_ui (bam_mpz_t, const bam_mpz_t, unsigned ba0_int_p);
void bam_mpz_mul (bam_mpz_t, const bam_mpz_t, const bam_mpz_t);
void bam_mpz_mul_2exp (bam_mpz_t, const bam_mpz_t, bam_mp_bitcnt_t);
void bam_mpz_addmul_ui (bam_mpz_t, const bam_mpz_t, unsigned ba0_int_p);
void bam_mpz_addmul (bam_mpz_t, const bam_mpz_t, const bam_mpz_t);
void bam_mpz_submul_ui (bam_mpz_t, const bam_mpz_t, unsigned ba0_int_p);
void bam_mpz_submul (bam_mpz_t, const bam_mpz_t, const bam_mpz_t);

void bam_mpz_cdiv_qr (bam_mpz_t, bam_mpz_t, const bam_mpz_t, const bam_mpz_t);
void bam_mpz_fdiv_qr (bam_mpz_t, bam_mpz_t, const bam_mpz_t, const bam_mpz_t);
void bam_mpz_tdiv_qr (bam_mpz_t, bam_mpz_t, const bam_mpz_t, const bam_mpz_t);
void bam_mpz_cdiv_q (bam_mpz_t, const bam_mpz_t, const bam_mpz_t);
void bam_mpz_fdiv_q (bam_mpz_t, const bam_mpz_t, const bam_mpz_t);
void bam_mpz_tdiv_q (bam_mpz_t, const bam_mpz_t, const bam_mpz_t);
void bam_mpz_cdiv_r (bam_mpz_t, const bam_mpz_t, const bam_mpz_t);
void bam_mpz_fdiv_r (bam_mpz_t, const bam_mpz_t, const bam_mpz_t);
void bam_mpz_tdiv_r (bam_mpz_t, const bam_mpz_t, const bam_mpz_t);

void bam_mpz_cdiv_q_2exp (bam_mpz_t, const bam_mpz_t, bam_mp_bitcnt_t);
void bam_mpz_fdiv_q_2exp (bam_mpz_t, const bam_mpz_t, bam_mp_bitcnt_t);
void bam_mpz_tdiv_q_2exp (bam_mpz_t, const bam_mpz_t, bam_mp_bitcnt_t);
void bam_mpz_cdiv_r_2exp (bam_mpz_t, const bam_mpz_t, bam_mp_bitcnt_t);
void bam_mpz_fdiv_r_2exp (bam_mpz_t, const bam_mpz_t, bam_mp_bitcnt_t);
void bam_mpz_tdiv_r_2exp (bam_mpz_t, const bam_mpz_t, bam_mp_bitcnt_t);

void bam_mpz_mod (bam_mpz_t, const bam_mpz_t, const bam_mpz_t);

void bam_mpz_divexact (bam_mpz_t, const bam_mpz_t, const bam_mpz_t);

int bam_mpz_divisible_p (const bam_mpz_t, const bam_mpz_t);
int bam_mpz_congruent_p (const bam_mpz_t, const bam_mpz_t, const bam_mpz_t);

unsigned ba0_int_p bam_mpz_cdiv_qr_ui (bam_mpz_t, bam_mpz_t, const bam_mpz_t, unsigned ba0_int_p);
unsigned ba0_int_p bam_mpz_fdiv_qr_ui (bam_mpz_t, bam_mpz_t, const bam_mpz_t, unsigned ba0_int_p);
unsigned ba0_int_p bam_mpz_tdiv_qr_ui (bam_mpz_t, bam_mpz_t, const bam_mpz_t, unsigned ba0_int_p);
unsigned ba0_int_p bam_mpz_cdiv_q_ui (bam_mpz_t, const bam_mpz_t, unsigned ba0_int_p);
unsigned ba0_int_p bam_mpz_fdiv_q_ui (bam_mpz_t, const bam_mpz_t, unsigned ba0_int_p);
unsigned ba0_int_p bam_mpz_tdiv_q_ui (bam_mpz_t, const bam_mpz_t, unsigned ba0_int_p);
unsigned ba0_int_p bam_mpz_cdiv_r_ui (bam_mpz_t, const bam_mpz_t, unsigned ba0_int_p);
unsigned ba0_int_p bam_mpz_fdiv_r_ui (bam_mpz_t, const bam_mpz_t, unsigned ba0_int_p);
unsigned ba0_int_p bam_mpz_tdiv_r_ui (bam_mpz_t, const bam_mpz_t, unsigned ba0_int_p);
unsigned ba0_int_p bam_mpz_cdiv_ui (const bam_mpz_t, unsigned ba0_int_p);
unsigned ba0_int_p bam_mpz_fdiv_ui (const bam_mpz_t, unsigned ba0_int_p);
unsigned ba0_int_p bam_mpz_tdiv_ui (const bam_mpz_t, unsigned ba0_int_p);

unsigned ba0_int_p bam_mpz_mod_ui (bam_mpz_t, const bam_mpz_t, unsigned ba0_int_p);

void bam_mpz_divexact_ui (bam_mpz_t, const bam_mpz_t, unsigned ba0_int_p);

int bam_mpz_divisible_ui_p (const bam_mpz_t, unsigned ba0_int_p);

unsigned ba0_int_p bam_mpz_gcd_ui (bam_mpz_t, const bam_mpz_t, unsigned ba0_int_p);
void bam_mpz_gcd (bam_mpz_t, const bam_mpz_t, const bam_mpz_t);
void bam_mpz_gcdext (bam_mpz_t, bam_mpz_t, bam_mpz_t, const bam_mpz_t, const bam_mpz_t);
void bam_mpz_lcm_ui (bam_mpz_t, const bam_mpz_t, unsigned ba0_int_p);
void bam_mpz_lcm (bam_mpz_t, const bam_mpz_t, const bam_mpz_t);
int bam_mpz_invert (bam_mpz_t, const bam_mpz_t, const bam_mpz_t);

void bam_mpz_sqrtrem (bam_mpz_t, bam_mpz_t, const bam_mpz_t);
void bam_mpz_sqrt (bam_mpz_t, const bam_mpz_t);
int bam_mpz_perfect_square_p (const bam_mpz_t);

void bam_mpz_pow_ui (bam_mpz_t, const bam_mpz_t, unsigned ba0_int_p);
void bam_mpz_ui_pow_ui (bam_mpz_t, unsigned ba0_int_p, unsigned ba0_int_p);
void bam_mpz_powm (bam_mpz_t, const bam_mpz_t, const bam_mpz_t, const bam_mpz_t);
void bam_mpz_powm_ui (bam_mpz_t, const bam_mpz_t, unsigned ba0_int_p, const bam_mpz_t);

void bam_mpz_rootrem (bam_mpz_t, bam_mpz_t, const bam_mpz_t, unsigned ba0_int_p);
int bam_mpz_root (bam_mpz_t, const bam_mpz_t, unsigned ba0_int_p);

void bam_mpz_fac_ui (bam_mpz_t, unsigned ba0_int_p);
void bam_mpz_2fac_ui (bam_mpz_t, unsigned ba0_int_p);
void bam_mpz_mfac_uiui (bam_mpz_t, unsigned ba0_int_p, unsigned ba0_int_p);
void bam_mpz_bin_uiui (bam_mpz_t, unsigned ba0_int_p, unsigned ba0_int_p);

int bam_mpz_probab_prime_p (const bam_mpz_t, int);

int bam_mpz_tstbit (const bam_mpz_t, bam_mp_bitcnt_t);
void bam_mpz_setbit (bam_mpz_t, bam_mp_bitcnt_t);
void bam_mpz_clrbit (bam_mpz_t, bam_mp_bitcnt_t);
void bam_mpz_combit (bam_mpz_t, bam_mp_bitcnt_t);

void bam_mpz_com (bam_mpz_t, const bam_mpz_t);
void bam_mpz_and (bam_mpz_t, const bam_mpz_t, const bam_mpz_t);
void bam_mpz_ior (bam_mpz_t, const bam_mpz_t, const bam_mpz_t);
void bam_mpz_xor (bam_mpz_t, const bam_mpz_t, const bam_mpz_t);

bam_mp_bitcnt_t bam_mpz_popcount (const bam_mpz_t);
bam_mp_bitcnt_t bam_mpz_hamdist (const bam_mpz_t, const bam_mpz_t);
bam_mp_bitcnt_t bam_mpz_scan0 (const bam_mpz_t, bam_mp_bitcnt_t);
bam_mp_bitcnt_t bam_mpz_scan1 (const bam_mpz_t, bam_mp_bitcnt_t);

int bam_mpz_fits_sba0_int_p_p (const bam_mpz_t);
int bam_mpz_fits_uba0_int_p_p (const bam_mpz_t);
int bam_mpz_fits_sint_p (const bam_mpz_t);
int bam_mpz_fits_uint_p (const bam_mpz_t);
int bam_mpz_fits_sshort_p (const bam_mpz_t);
int bam_mpz_fits_ushort_p (const bam_mpz_t);
ba0_int_p bam_mpz_get_si (const bam_mpz_t);
unsigned ba0_int_p bam_mpz_get_ui (const bam_mpz_t);
double bam_mpz_get_d (const bam_mpz_t);
size_t bam_mpz_size (const bam_mpz_t);
bam_mp_limb_t bam_mpz_getlimbn (const bam_mpz_t, bam_mp_size_t);

void bam_mpz_realloc2 (bam_mpz_t, bam_mp_bitcnt_t);
bam_mp_srcptr bam_mpz_limbs_read (bam_mpz_srcptr);
bam_mp_ptr bam_mpz_limbs_modify (bam_mpz_t, bam_mp_size_t);
bam_mp_ptr bam_mpz_limbs_write (bam_mpz_t, bam_mp_size_t);
void bam_mpz_limbs_finish (bam_mpz_t, bam_mp_size_t);
bam_mpz_srcptr bam_mpz_roinit_n (bam_mpz_t, bam_mp_srcptr, bam_mp_size_t);

#define MPZ_ROINIT_N(xp, xs) {{0, (xs),(xp) }}

void bam_mpz_set_si (bam_mpz_t, signed ba0_int_p);
void bam_mpz_set_ui (bam_mpz_t, unsigned ba0_int_p);
void bam_mpz_set (bam_mpz_t, const bam_mpz_t);
void bam_mpz_set_d (bam_mpz_t, double);

void bam_mpz_init_set_si (bam_mpz_t, signed ba0_int_p);
void bam_mpz_init_set_ui (bam_mpz_t, unsigned ba0_int_p);
void bam_mpz_init_set (bam_mpz_t, const bam_mpz_t);
void bam_mpz_init_set_d (bam_mpz_t, double);

size_t bam_mpz_sizeinbase (const bam_mpz_t, int);
char *bam_mpz_get_str (char *, int, const bam_mpz_t);
int bam_mpz_set_str (bam_mpz_t, const char *, int);
int bam_mpz_init_set_str (bam_mpz_t, const char *, int);

/* This ba0_int_p list taken from gmp.h. */
/* For reference, "defined(EOF)" cannot be used here.  In g++ 2.95.4,
   <iostream> defines EOF but not FILE.  */
#if defined (FILE)                                              \
  || defined (H_STDIO)                                          \
  || defined (_H_STDIO)               /* AIX */                 \
  || defined (_STDIO_H)               /* glibc, Sun, SCO */     \
  || defined (_STDIO_H_)              /* BSD, OSF */            \
  || defined (__STDIO_H)              /* Borland */             \
  || defined (__STDIO_H__)            /* IRIX */                \
  || defined (_STDIO_INCLUDED)        /* HPUX */                \
  || defined (__dj_include_stdio_h_)  /* DJGPP */               \
  || defined (_FILE_DEFINED)          /* Microsoft */           \
  || defined (__STDIO__)              /* Apple MPW MrC */       \
  || defined (_MSL_STDIO_H)           /* Metrowerks */          \
  || defined (_STDIO_H_INCLUDED)      /* QNX4 */        \
  || defined (_ISO_STDIO_ISO_H)       /* Sun C++ */        \
  || defined (__STDIO_LOADED)         /* VMS */            \
  || defined (_STDIO)                 /* HPE NonStop */         \
  || defined (__DEFINED_FILE)         /* musl */
size_t bam_mpz_out_str (FILE *, int, const bam_mpz_t);
#endif

void bam_mpz_import (bam_mpz_t, size_t, int, size_t, int, size_t, const void *);
void *bam_mpz_export (void *, size_t *, int, size_t, int, size_t, const bam_mpz_t);

#if defined (__cplusplus)
}
#endif
#endif /* __MINI_GMP_H__ */
/* mini-mpq, a minimalistic implementation of a GNU GMP subset.

Copyright 2018, 2019 Free Software Foundation, Inc.

This file is part of the GNU MP Library.

The GNU MP Library is free software; you can redistribute it and/or modify
it under the terms of either:

  * the GNU Lesser General Public License as published by the Free
    Software Foundation; either version 3 of the License, or (at your
    option) any later version.

or

  * the GNU General Public License as published by the Free Software
    Foundation; either version 2 of the License, or (at your option) any
    later version.

or both in parallel, as here.

The GNU MP Library is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received copies of the GNU General Public License and the
GNU Lesser General Public License aba0_int_p with the GNU MP Library.  If not,
see https://www.gnu.org/licenses/.  */

/* Header */

#if !defined (__MINI_MPQ_H__)
#define __MINI_MPQ_H__

/* #include "mini-gmp.h" */

#if defined (__cplusplus)
extern "C" {
#endif

typedef struct
{
  bam__mpz_struct _mp_num;
  bam__mpz_struct _mp_den;
} bam__mpq_struct;

typedef bam__mpq_struct bam_mpq_t[1];

typedef const bam__mpq_struct *bam_mpq_srcptr;
typedef bam__mpq_struct *bam_mpq_ptr;

#define bam_mpq_numref(Q) (&((Q)->_mp_num))
#define bam_mpq_denref(Q) (&((Q)->_mp_den))

void bam_mpq_abs (bam_mpq_t, const bam_mpq_t);
void bam_mpq_add (bam_mpq_t, const bam_mpq_t, const bam_mpq_t);
void bam_mpq_canonicalize (bam_mpq_t);
void bam_mpq_clear (bam_mpq_t);
int bam_mpq_cmp (const bam_mpq_t, const bam_mpq_t);
int bam_mpq_cmp_si (const bam_mpq_t, signed ba0_int_p, unsigned ba0_int_p);
int bam_mpq_cmp_ui (const bam_mpq_t, unsigned ba0_int_p, unsigned ba0_int_p);
int bam_mpq_cmp_z (const bam_mpq_t, const bam_mpz_t);
void bam_mpq_div (bam_mpq_t, const bam_mpq_t, const bam_mpq_t);
void bam_mpq_div_2exp (bam_mpq_t, const bam_mpq_t, bam_mp_bitcnt_t);
int bam_mpq_equal (const bam_mpq_t, const bam_mpq_t);
double bam_mpq_get_d (const bam_mpq_t);
void bam_mpq_get_den (bam_mpz_t, const bam_mpq_t);
void bam_mpq_get_num (bam_mpz_t, const bam_mpq_t);
char * bam_mpq_get_str (char *, int, const bam_mpq_t q);
void bam_mpq_init (bam_mpq_t);
void bam_mpq_inv (bam_mpq_t, const bam_mpq_t);
void bam_mpq_mul (bam_mpq_t, const bam_mpq_t, const bam_mpq_t);
void bam_mpq_mul_2exp (bam_mpq_t, const bam_mpq_t, bam_mp_bitcnt_t);
void bam_mpq_neg (bam_mpq_t, const bam_mpq_t);
void bam_mpq_set (bam_mpq_t, const bam_mpq_t);
void bam_mpq_set_d (bam_mpq_t, double);
void bam_mpq_set_den (bam_mpq_t, const bam_mpz_t);
void bam_mpq_set_num (bam_mpq_t, const bam_mpz_t);
void bam_mpq_set_si (bam_mpq_t, signed ba0_int_p, unsigned ba0_int_p);
int bam_mpq_set_str (bam_mpq_t, const char *, int);
void bam_mpq_set_ui (bam_mpq_t, unsigned ba0_int_p, unsigned ba0_int_p);
void bam_mpq_set_z (bam_mpq_t, const bam_mpz_t);
int bam_mpq_sgn (const bam_mpq_t);
void bam_mpq_sub (bam_mpq_t, const bam_mpq_t, const bam_mpq_t);
void bam_mpq_swap (bam_mpq_t, bam_mpq_t);

/* This ba0_int_p list taken from gmp.h. */
/* For reference, "defined(EOF)" cannot be used here.  In g++ 2.95.4,
   <iostream> defines EOF but not FILE.  */
#if defined (FILE)                                              \
  || defined (H_STDIO)                                          \
  || defined (_H_STDIO)               /* AIX */                 \
  || defined (_STDIO_H)               /* glibc, Sun, SCO */     \
  || defined (_STDIO_H_)              /* BSD, OSF */            \
  || defined (__STDIO_H)              /* Borland */             \
  || defined (__STDIO_H__)            /* IRIX */                \
  || defined (_STDIO_INCLUDED)        /* HPUX */                \
  || defined (__dj_include_stdio_h_)  /* DJGPP */               \
  || defined (_FILE_DEFINED)          /* Microsoft */           \
  || defined (__STDIO__)              /* Apple MPW MrC */       \
  || defined (_MSL_STDIO_H)           /* Metrowerks */          \
  || defined (_STDIO_H_INCLUDED)      /* QNX4 */                \
  || defined (_ISO_STDIO_ISO_H)       /* Sun C++ */             \
  || defined (__STDIO_LOADED)         /* VMS */
size_t bam_mpq_out_str (FILE *, int, const bam_mpq_t);
#endif

void bam_mpz_set_q (bam_mpz_t, const bam_mpq_t);

#if defined (__cplusplus)
}
#endif
#endif /* __MINI_MPQ_H__ */
#if ! defined (BA0_MESGERR_H)
#   define BA0_MESGERR_H

/* #   include "ba0_common.h" */

BEGIN_C_DECLS
/* 
 * A bug is discovered in the library (should not happen error).
 *  Repair: fix the bug.
 */
extern BA0_DLL char BA0_ERRALG[];

extern BA0_DLL char BA0_ERRNYP[];

extern BA0_DLL char BA0_ERRNCE[];

/* 
 * Memory problems.
 * Repair: reconfigure the library (resize some constants).
 */

extern BA0_DLL char BA0_ERROOM[];

extern BA0_DLL char BA0_ERRSOV[];

extern BA0_DLL char BA0_ERRMFR[];

/* 
 * Giving up computations because of a signal.
 */

extern BA0_DLL char BA0_ERRSIG[];

extern BA0_DLL char BA0_ERRALR[];

extern BA0_DLL char BA0_ERRNCI[];

/* 
 * Mathematical errors
 */

extern BA0_DLL char BA0_ERRIVZ[];

extern BA0_DLL char BA0_ERRDDZ[];

extern BA0_DLL char BA0_EXWRNT[];

extern BA0_DLL char BA0_EXWDDZ[];

extern BA0_DLL char BA0_ERRMAT[];

extern BA0_DLL char BA0_ERRNIL[];

extern BA0_DLL char BA0_ERRZCI[];

/* 
 * Parser errors
 */

extern BA0_DLL char BA0_ERREOF[];

extern BA0_DLL char BA0_ERRSYN[];

extern BA0_DLL char BA0_ERRSTR[];

extern BA0_DLL char BA0_ERRINT[];

extern BA0_DLL char BA0_ERRFLT[];

extern BA0_DLL char BA0_ERRRAT[];

extern BA0_DLL char BA0_ERRAMB[];

/*
 * Other errors
 */

extern BA0_DLL char BA0_ERRKEY[];

END_C_DECLS
#endif /* !BA0_MESGERR_H */
#if !defined (BA0_TABLE_H)
#   define BA0_TABLE_H 1

/* #   include "ba0_common.h" */

BEGIN_C_DECLS

struct ba0_table
{
  ba0_int_p alloc;
  ba0_int_p size;
  void **tab;
};

struct ba0_tableof_table
{
  ba0_int_p alloc;
  ba0_int_p size;
  struct ba0_table **tab;
};

extern BA0_DLL unsigned ba0_int_p ba0_sizeof_table (
    struct ba0_table *,
    enum ba0_garbage_code);

extern BA0_DLL void ba0_re_malloc_table (
    struct ba0_table *,
    ba0_int_p);

extern BA0_DLL void ba0_realloc_table (
    struct ba0_table *,
    ba0_int_p);

extern BA0_DLL void ba0_realloc2_table (
    struct ba0_table *,
    ba0_int_p,
    ba0_new_function *);

extern BA0_DLL void ba0_init_table (
    struct ba0_table *);

extern BA0_DLL void ba0_reset_table (
    struct ba0_table *);

extern BA0_DLL struct ba0_table *ba0_new_table (
    void);

extern BA0_DLL void ba0_set_table (
    struct ba0_table *,
    struct ba0_table *);

extern BA0_DLL void ba0_set2_table (
    struct ba0_table *,
    struct ba0_table *,
    ba0_new_function *,
    ba0_set_function *);

extern BA0_DLL void ba0_delete_table (
    struct ba0_table *,
    ba0_int_p);

extern BA0_DLL void ba0_insert_table (
    struct ba0_table *,
    ba0_int_p,
    void *);

extern BA0_DLL bool ba0_member_table (
    void *,
    struct ba0_table *);

extern BA0_DLL bool ba0_member2_table (
    void *,
    struct ba0_table *,
    ba0_int_p *);

extern BA0_DLL bool ba0_equal_table (
    struct ba0_table *,
    struct ba0_table *);

extern BA0_DLL void ba0_sort_table (
    struct ba0_table *,
    struct ba0_table *);

extern BA0_DLL void ba0_unique_table (
    struct ba0_table *,
    struct ba0_table *);

extern BA0_DLL bool ba0_is_unique_table (
    struct ba0_table *);

extern BA0_DLL void ba0_reverse_table (
    struct ba0_table *,
    struct ba0_table *);

extern BA0_DLL void ba0_concat_table (
    struct ba0_table *,
    struct ba0_table *,
    struct ba0_table *);

extern BA0_DLL void ba0_move_to_tail_table (
    struct ba0_table *,
    struct ba0_table *,
    ba0_int_p);

extern BA0_DLL void ba0_move_from_tail_table (
    struct ba0_table *,
    struct ba0_table *,
    ba0_int_p);

struct ba0_list;

extern BA0_DLL void ba0_append_table_list (
    struct ba0_table *,
    struct ba0_list *);

extern BA0_DLL void ba0_set_table_list (
    struct ba0_table *,
    struct ba0_list *);

END_C_DECLS
#endif /* ! BA0_TABLE_H */
#if !defined (BA0_ARRAY_H)
#   define BA0_ARRAY_H 1

/* #   include "ba0_common.h" */

BEGIN_C_DECLS

struct ba0_array
{
  ba0_int_p alloc;
  ba0_int_p size;
  char *tab;
  ba0_int_p sizelt;
};


#   define BA0_ARRAY(A,i) ((A)->tab + (i)*  (A)->sizelt)

extern BA0_DLL void ba0_realloc_array (
    struct ba0_array *,
    ba0_int_p,
    ba0_int_p);

extern BA0_DLL void ba0_realloc2_array (
    struct ba0_array *,
    ba0_int_p,
    ba0_int_p,
    ba0_init_function *);

extern BA0_DLL void ba0_init_array (
    struct ba0_array *);

extern BA0_DLL void ba0_reset_array (
    struct ba0_array *);

extern BA0_DLL struct ba0_array *ba0_new_array (
    void);

extern BA0_DLL void ba0_set_array (
    struct ba0_array *,
    struct ba0_array *);

extern BA0_DLL void ba0_delete_array (
    struct ba0_array *,
    ba0_int_p);

extern BA0_DLL void ba0_reverse_array (
    struct ba0_array *,
    struct ba0_array *);

extern BA0_DLL void ba0_concat_array (
    struct ba0_array *,
    struct ba0_array *,
    struct ba0_array *);

END_C_DECLS
#endif /* ! BA0_ARRAY_H */
#if !defined (BA0_LIST_H)
#   define BA0_LIST_H

/* #   include "ba0_common.h" */

BEGIN_C_DECLS

struct ba0_list
{
  void *value;
  struct ba0_list *next;
};


extern BA0_DLL struct ba0_list *ba0_sort_list (
    struct ba0_list *,
    ba0_cmp_function *);

extern BA0_DLL struct ba0_list *ba0_sort2_list (
    struct ba0_list *,
    ba0_cmp2_function *,
    void *);

extern BA0_DLL struct ba0_list *ba0_select_list (
    struct ba0_list *,
    ba0_unary_predicate *);

extern BA0_DLL struct ba0_list *ba0_delete_list (
    struct ba0_list *,
    ba0_unary_predicate *);

extern BA0_DLL struct ba0_list *ba0_insert_list (
    void *,
    struct ba0_list *,
    ba0_cmp_function *);

extern BA0_DLL struct ba0_list *ba0_insert2_list (
    void *,
    struct ba0_list *,
    ba0_cmp2_function *,
    void *);

extern BA0_DLL bool ba0_member_list (
    void *,
    struct ba0_list *);

extern BA0_DLL void *ba0_last_list (
    struct ba0_list *);

extern BA0_DLL struct ba0_list *ba0_butlast_list (
    struct ba0_list *);

extern BA0_DLL struct ba0_list *ba0_copy_list (
    struct ba0_list *);

extern BA0_DLL struct ba0_list *ba0_cons_list (
    void *,
    struct ba0_list *);

extern BA0_DLL struct ba0_list *ba0_endcons_list (
    void *,
    struct ba0_list *);

extern BA0_DLL struct ba0_list *ba0_reverse_list (
    struct ba0_list *);

extern BA0_DLL struct ba0_list *ba0_concat_list (
    struct ba0_list *,
    struct ba0_list *);

extern BA0_DLL void ba0_move_to_head_list (
    struct ba0_list *,
    ba0_int_p);

extern BA0_DLL ba0_int_p ba0_length_list (
    struct ba0_list *);

extern BA0_DLL void *ba0_ith_list (
    struct ba0_list *,
    ba0_int_p);

extern BA0_DLL struct ba0_list *ba0_map_list (
    ba0_unary_function *,
    struct ba0_list *);

END_C_DECLS
#endif /* !BA0_LIST_H */
#if !defined (BA0_MATRIX_H)
#   define BA0_MATRIX_H 1

/* #   include "ba0_common.h" */

BEGIN_C_DECLS

struct ba0_matrix
{
  ba0_int_p alloc;
  ba0_int_p nrow;
  ba0_int_p ncol;
  void **entry;
};


#   define BA0_MAT(M,i,j) (M)->entry [(M)->ncol*  (i) + j]

extern BA0_DLL void ba0_realloc_matrix (
    struct ba0_matrix *,
    ba0_int_p,
    ba0_int_p);

extern BA0_DLL void ba0_realloc2_matrix (
    struct ba0_matrix *,
    ba0_int_p,
    ba0_int_p,
    ba0_new_function *);

extern BA0_DLL void ba0_init_matrix (
    struct ba0_matrix *);

extern BA0_DLL void ba0_reset_matrix (
    struct ba0_matrix *);

extern BA0_DLL struct ba0_matrix *ba0_new_matrix (
    void);

extern BA0_DLL void ba0_set_matrix_unity (
    struct ba0_matrix *,
    ba0_int_p,
    ba0_new_function *,
    ba0_unary_operation *,
    ba0_unary_operation *);

extern BA0_DLL void ba0_set_matrix (
    struct ba0_matrix *,
    struct ba0_matrix *);

extern BA0_DLL void ba0_set_matrix2 (
    struct ba0_matrix *,
    struct ba0_matrix *,
    ba0_new_function *,
    ba0_binary_operation *);

extern BA0_DLL void ba0_set_matrix_unity (
    struct ba0_matrix *,
    ba0_int_p,
    ba0_new_function *,
    ba0_unary_operation *,
    ba0_unary_operation *);

extern BA0_DLL bool ba0_is_zero_matrix (
    struct ba0_matrix *,
    ba0_unary_predicate *);

extern BA0_DLL bool ba0_is_unity_matrix (
    struct ba0_matrix *,
    ba0_unary_predicate *,
    ba0_unary_predicate *);

extern BA0_DLL void ba0_swap_rows_matrix (
    struct ba0_matrix *,
    ba0_int_p,
    ba0_int_p);

extern BA0_DLL void ba0_swap_columns_matrix (
    struct ba0_matrix *,
    ba0_int_p,
    ba0_int_p);

extern BA0_DLL void ba0_add_matrix (
    struct ba0_matrix *,
    struct ba0_matrix *,
    struct ba0_matrix *,
    ba0_new_function *,
    ba0_ternary_operation *);

extern BA0_DLL void ba0_mul_matrix (
    struct ba0_matrix *,
    struct ba0_matrix *,
    struct ba0_matrix *,
    ba0_new_function *,
    ba0_unary_operation *,
    ba0_binary_operation *,
    ba0_ternary_operation *,
    ba0_ternary_operation *);

END_C_DECLS
#endif /* !BA0_MATRIX_H */
#if ! defined (BA0_POINT_H)
#   define BA0_POINT_H 1

/* #   include "ba0_common.h" */

BEGIN_C_DECLS

/*
 * texinfo: ba0_value
 * This data type permits to associate a value to a variable
 * (variables are defined in the @code{bav} library).
 *
 * It can be parsed and printed using formats of the form
 * @code{%value(%something)}. The input output syntax for values
 * is @code{var = value}. The equality sign can be customized
 * (see @code{ba0_set_settings_value}).
 */

struct ba0_value
{
  void *var;
  void *value;
};

#   define BA0_NOT_A_VALUE (struct ba0_value *)0

#   define BA0_NOT_A_VARIABLE 0

#   define BA0_POINT_OPER "="

/*
 * texinfo: ba0_point
 * This data type permits to associate values to many different variables.
 * It actually is a duplicate of @code{struct ba0_table} so that many
 * table functions may be applied to points.
 * Many functions require the @code{tab} field to be
 * sorted (see @code{ba0_sort_point}).
 *
 * It can be parsed and printed using formats of the form 
 * @code{%point(%something)} which is more precise than
 * @code{%t(%value(%something))} since parsed points are sorted
 * and tested against ambiguity (exception @code{BA0_ERRAMB} is
 * raised by the parser if the variables are not pairwise distinct).
 *
 * This data type gets specialized as @code{struct bav_point_int_p}
 * and @code{struct bav_point_interval_mpq} in the @code{bav} library
 * and as @code{baz_point_ratfrac} in the @code{baz} library.
 */

struct ba0_point
{
  ba0_int_p alloc;
  ba0_int_p size;
  struct ba0_value **tab;
};


extern BA0_DLL void ba0_set_settings_value (
    char *);

extern BA0_DLL void ba0_get_settings_value (
    char **);

extern BA0_DLL void ba0_init_value (
    struct ba0_value *);

extern BA0_DLL struct ba0_value *ba0_new_value (
    void);

extern BA0_DLL void ba0_init_point (
    struct ba0_point *);

extern BA0_DLL struct ba0_point *ba0_new_point (
    void);

extern BA0_DLL void ba0_set_point (
    struct ba0_point *,
    struct ba0_point *);

extern BA0_DLL void ba0_sort_point (
    struct ba0_point *,
    struct ba0_point *);

extern BA0_DLL bool ba0_is_sorted_point (
    struct ba0_point *);

extern BA0_DLL bool ba0_is_ambiguous_point (
    struct ba0_point *);

extern BA0_DLL void ba0_delete_point (
    struct ba0_point *,
    struct ba0_point *,
    ba0_int_p);

extern BA0_DLL struct ba0_value *ba0_bsearch_point (
    void *,
    struct ba0_point *,
    ba0_int_p *);

extern BA0_DLL struct ba0_value *ba0_assoc_point (
    void *,
    struct ba0_point *,
    ba0_int_p *);

END_C_DECLS
#endif /* !BA0_POINT_H */
#if !defined (BA0_INT_P)
#   define BA0_INT_P 1

/* #   include "ba0_common.h" */

BEGIN_C_DECLS

struct ba0_tableof_int_p
{
  ba0_int_p alloc;
  ba0_int_p size;
  ba0_int_p *tab;
};

struct ba0_tableof_unsigned_int_p
{
  ba0_int_p alloc;
  ba0_int_p size;
  unsigned ba0_int_p *tab;
};

struct ba0_matrixof_int_p
{
  ba0_int_p alloc;
  ba0_int_p nrow;
  ba0_int_p ncol;
  ba0_int_p *entry;
};

struct ba0_listof_int_p
{
  ba0_int_p value;
  struct ba0_listof_int_p *next;
};

struct ba0_tableof_tableof_int_p
{
  ba0_int_p alloc;
  ba0_int_p size;
  struct ba0_tableof_int_p **tab;
};

extern BA0_DLL ba0_int_p ba0_log2_int_p (
    ba0_int_p);

extern BA0_DLL ba0_scanf_function ba0_scanf_int_p;

extern BA0_DLL ba0_printf_function ba0_printf_int_p;

extern BA0_DLL ba0_scanf_function ba0_scanf_hexint_p;

extern BA0_DLL ba0_printf_function ba0_printf_hexint_p;

END_C_DECLS
#endif /* !BA0_INT_P */
#if !defined (BA0_STACK_H)
#   define BA0_STACK_H

/* #   include "ba0_common.h" */
/* #   include "ba0_table.h" */
/* #   include "ba0_int_p.h" */

BEGIN_C_DECLS

/*
 * texinfo: ba0_mark
 * The data structure @code{ba0_mark} implements marks.
 * From the user point of view, a @dfn{mark} is a pointer in a stack.
 * Marks are used for garbage collection.
 */

struct ba0_mark
{
// the stack the address belongs to
  struct ba0_stack *stack;      // the stack the address belongs to 
// the index of the stack cell the address belongs to
  ba0_int_p index_in_cells;
  void *address;                // the address
// the number of free bytes in the cell, after the mark
  unsigned ba0_int_p memory_left;
};

/* texinfo: ba0_stack
 * The data structure @code{ba0_stack} mplements stacks.
 * From the user point of view, a stack is a huge piece of memory in
 * which memory allocation is possible.
 * A stack is implemented as an array of cells.
 * Cells are blocks of memory allocated in the process heap via
 * @code{ba0_alloc}.
 */

struct ba0_stack
{
// the identifier (nickname) of the stack
  char *ident;
// the array of cells and the corresponding array of cell sizes
  struct ba0_table cells;
  struct ba0_tableof_unsigned_int_p sizes;
// the default size of cells (may increase during computations)
  unsigned ba0_int_p default_size;
// default value is true (if false, cell sizes do not increase)
  bool resizable;
// the border between the used and the free parts of the stack
  struct ba0_mark free;
// the max address reached by the free pointer
  struct ba0_mark max_alloc;
// counts the number of allocations in the process heap
  ba0_int_p nb_calls_to_alloc;
// for debugging purposes
  ba0_int_p *bound;
};

struct ba0_tableof_stack
{
  ba0_int_p alloc;
  ba0_int_p size;
  struct ba0_stack **tab;
};


/* 
 * Some default values
 */

#   define BA0_SIZE_CELL_MAIN_STACK   0x20000
#   define BA0_SIZE_CELL_QUIET_STACK  0x20000
#   define BA0_SIZE_CELL_ANALEX_STACK 0x10000
#   define BA0_NB_CELLS_PER_STACK       0x100
#   define BA0_SIZE_STACK_OF_STACK      0x100

extern BA0_DLL void ba0_set_settings_no_oom (
    bool);

extern BA0_DLL void ba0_get_settings_no_oom (
    bool *);

extern BA0_DLL void ba0_set_settings_stack (
    ba0_int_p,
    ba0_int_p,
    ba0_int_p,
    ba0_int_p,
    ba0_int_p);

extern BA0_DLL void ba0_get_settings_stack (
    ba0_int_p *,
    ba0_int_p *,
    ba0_int_p *,
    ba0_int_p *,
    ba0_int_p *);

extern BA0_DLL void ba0_init_stack_of_stacks (
    void);

extern BA0_DLL void ba0_reset_stack_of_stacks (
    void);

extern BA0_DLL void ba0_clear_stack_of_stacks (
    void);

#   define ba0_alloc_counter	ba0_global.stack.alloc_counter
#   define ba0_malloc_counter	ba0_global.stack.malloc_counter
#   define ba0_malloc_nbcalls	ba0_global.stack.malloc_nbcalls

extern BA0_DLL void ba0_set_settings_memory_functions (
    void *(*)(size_t),
    void (*)(void *));

extern BA0_DLL void ba0_get_settings_memory_functions (
    void *(**)(size_t),
    void (**)(void *));

extern BA0_DLL unsigned ba0_int_p ba0_ceil_align (
    unsigned ba0_int_p);

extern BA0_DLL unsigned ba0_int_p ba0_allocated_size (
    unsigned ba0_int_p);

extern BA0_DLL void *ba0_malloc (
    ba0_int_p);

extern BA0_DLL void *ba0_persistent_malloc (
    ba0_int_p);

extern BA0_DLL void ba0_free (
    void *);

extern BA0_DLL ba0_int_p ba0_cell_index_mark (
    void *,
    struct ba0_mark *);

extern BA0_DLL bool ba0_in_stack (
    void *,
    struct ba0_stack *);

extern BA0_DLL struct ba0_stack *ba0_which_stack (
    void *);

extern BA0_DLL struct ba0_stack *ba0_current_stack (
    void);

extern BA0_DLL unsigned ba0_int_p ba0_max_alloc_stack (
    struct ba0_stack *);

extern BA0_DLL void ba0_push_stack (
    struct ba0_stack *);

extern BA0_DLL void ba0_pull_stack (
    void);

extern BA0_DLL void ba0_push_another_stack (
    void);

extern BA0_DLL void ba0_init_stack (
    struct ba0_stack *);

extern BA0_DLL void ba0_init_one_cell_stack (
    struct ba0_stack *,
    char *,
    void *,
    ba0_int_p);

extern BA0_DLL void ba0_reset_stack (
    struct ba0_stack *);

extern BA0_DLL void ba0_reset_cell_stack (
    struct ba0_stack *);

extern BA0_DLL void ba0_clear_cells_stack (
    struct ba0_stack *);

extern BA0_DLL void ba0_clear_one_cell_stack (
    struct ba0_stack *);

extern BA0_DLL void ba0_clear_stack (
    struct ba0_stack *);

extern BA0_DLL void *ba0_alloc_but_do_not_set_magic (
    unsigned ba0_int_p);

extern BA0_DLL void ba0_alloc_set_magic (
    void);

extern BA0_DLL void *ba0_alloc (
    unsigned ba0_int_p);

extern BA0_DLL unsigned ba0_int_p ba0_memory_left_in_cell (
    void);

extern BA0_DLL void ba0_t1_alloc (
    unsigned ba0_int_p,
    unsigned ba0_int_p,
    void **,
    unsigned ba0_int_p *);

extern BA0_DLL void ba0_t2_alloc (
    unsigned ba0_int_p,
    unsigned ba0_int_p,
    unsigned ba0_int_p,
    void **,
    void **,
    unsigned ba0_int_p *);

extern BA0_DLL void ba0_rotate_cells (
    ba0_int_p);

extern BA0_DLL void *ba0_alloc_mark (
    struct ba0_mark *,
    unsigned ba0_int_p);

extern BA0_DLL void ba0_record (
    struct ba0_mark *);

extern BA0_DLL void ba0_restore (
    struct ba0_mark *);

extern BA0_DLL unsigned ba0_int_p ba0_range_mark (
    struct ba0_mark *,
    struct ba0_mark *);

END_C_DECLS
#endif /* !BA0_STACK_H */
#if !defined (BA0_EXCEPTION_H)
#   define BA0_EXCEPTION_H

/* #   include "ba0_common.h" */
/* #   include "ba0_stack.h" */
/* #   include "ba0_analex.h" */
/* #   include "ba0_mesgerr.h" */

BEGIN_C_DECLS

/*
 * Depending on the architecture, the implementation differs.
 * It is simpler to bundle jmpbuf in a struct
 */

struct ba0_jmp_buf_struct
{
  ba0_jmp_buf data;
};

/* 
 * Used by ba0_global.exception
 * The size of the exception stack.
 * The size of the exception log fifo.
 * The size of the extra stack is used also in ba0_exception_code
 */

#   define BA0_SIZE_EXCEPTION_STACK	100
#   define BA0_SIZE_EXCEPTION_LOG	10
#   define	BA0_SIZE_EXCEPTION_EXTRA_STACK 10

/* 
 * texinfo: ba0_exception
 * This data type implements the data stored in the entries of
 * @code{ba0_global.exception.stack}. These entries are filled when an
 * exception catching point is set. They are used for restoring
 * values when an exception is caught.
 */

struct ba0_exception
{
  struct ba0_jmp_buf_struct jmp_b;      // for setjmp/longjmp
// a pointer to the local variable __code__ set by BA0_TRY
  struct ba0_exception_code *code;
};

/* 
 * texinfo: ba0_exception_code
 * The data type for local variables @code{__code__} set by @code{BA0_TRY}.
 */

struct ba0_exception_code
{
// a copy of ba0_global.exception.stack.size for debugging purpose
  ba0_int_p exception_stack_size;
  bool cancelled;               // set to true by BA0_ENDTRY
  int jmp_code;                 // the returned value of setjmp
// values recorded when an exception catching point is set
  struct ba0_mark main;         // the free pointer of the main stack
  struct ba0_mark second;       // the one of the second stack
  ba0_int_p stack_of_stacks_size;       // the field size of the stack of stacks
// values of extra variables to be saved/restored
// the pointers to the variables are in ba0_global.exception.extra_stack
  struct
  {
    ba0_int_p tab[BA0_SIZE_EXCEPTION_EXTRA_STACK];
    ba0_int_p size;
  } extra_stack;
};

/* 
 * The macros for throwing exceptions
 */

#   define BA0_RAISE_EXCEPTION(msg) ba0_raise_exception (__FILE__, __LINE__, msg)

#   define BA0_RE_RAISE_EXCEPTION ba0_raise_exception (__FILE__, __LINE__, ba0_global.exception.raised)

#   define BA0_RAISE_PARSER_EXCEPTION(msg) do { \
    ba0_write_context_analex ();	      \
    ba0_raise_exception (__FILE__, __LINE__, msg); \
    } while (0)

#   define BA0_RAISE_EXCEPTION2(msg,f,o) \
	ba0_raise_exception2 (__FILE__, __LINE__, msg, f, (void **) o)

#   define BA0_CERR(msg) ba0_cerr (__FILE__, __LINE__, msg)

#   define BA0_ASSERT(condition) do { \
      if (!(condition)) BA0_RAISE_EXCEPTION (BA0_ERRALG) ; \
    } while (0)

/*
 * The macros for catching exceptions
 */

#   define BA0_TRY \
    { \
      struct ba0_exception_code __code__; \
      ba0_push_exception (&__code__);			\
      __code__.jmp_code = ba0_setjmp (ba0_global.exception.stack.tab [ba0_global.exception.stack.size-1].jmp_b.data,1);\
      if (ba0_exception_is_set (&__code__))

#   define BA0_CANCEL_EXCEPTION \
      ba0_pull_exception (&__code__);

#   define BA0_CATCH else

#   define BA0_ENDTRY \
      ba0_pull_exception (&__code__); \
    }

extern BA0_DLL void ba0_reset_exception_extra_stack (
    void);

extern BA0_DLL void ba0_push_exception_extra_stack (
    ba0_int_p *,
    void (*)(ba0_int_p));

extern BA0_DLL void ba0_pull_exception_extra_stack (
    void);

extern BA0_DLL void ba0_reset_exception (
    void);

extern BA0_DLL void ba0_push_exception (
    struct ba0_exception_code *);

extern BA0_DLL void ba0_pull_exception (
    struct ba0_exception_code *);

extern BA0_DLL bool ba0_exception_is_raised (
    struct ba0_exception_code *);

extern BA0_DLL bool ba0_exception_is_set (
    struct ba0_exception_code *);

extern BA0_DLL void ba0_raise_exception (
    char *,
    int,
    char *);

extern BA0_DLL void ba0_raise_exception2 (
    char *,
    int,
    char *,
    char *,
    void **);

extern BA0_DLL void ba0_cerr (
    char *,
    int,
    char *);

END_C_DECLS
#endif /* !BA0_EXCEPTION_H */
#if !defined (BA0_MACROS_MINT_HP_H)
#   define BA0_MACROS_MINT_HP_H 1

/* #   include "ba0_common.h" */

/* Macros for ba0_mint_hp */

#   define ba0_mint_hp_t ba0_mint_hp
#   define ba0_mint_hp_init(rop)            rop = 0
#   define ba0_mint_hp_set(rop,op)          rop = op
#   define ba0_mint_hp_affect(rop,op)       rop = op
#   define ba0_mint_hp_swap(opa,opb)        BA0_SWAP (ba0_mint_hp, opa, opb)

#   define ba0_mint_hp_set_si(rop,op)                    \
    rop = op > 0 ? op % ba0_mint_hp_module :             \
            (op + ba0_mint_hp_module) % ba0_mint_hp_module    \

#   define ba0_mint_hp_set_ui(rop,op)       rop = op % ba0_mint_hp_module

#   define ba0_mint_hp_init_set(rop,op)     rop = op

#   define ba0_mint_hp_init_set_si(rop,op)               \
    rop = op > 0 ? op % ba0_mint_hp_module :             \
            (op + ba0_mint_hp_module) % ba0_mint_hp_module

#   define ba0_mint_hp_init_set_ui(rop,op) rop = op % ba0_mint_hp_module

#   define ba0_mint_hp_is_zero(op)          ((op) == 0)
#   define ba0_mint_hp_is_one(op)           ((op) == 1)

#   define ba0_mint_hp_is_negative(op)      ((op) < 0)
#   define ba0_mint_hp_are_equal(opa,opb)   ((opa) == (opb))

#   define ba0_mint_hp_neg(rop,op)          rop = ba0_mint_hp_module - op

#   define ba0_mint_hp_add(rop,opa,opb)                  \
    rop = (ba0_mint_hp)(((unsigned ba0_int_p)(opa) +     \
                (unsigned ba0_int_p)(opb))               \
                % (unsigned ba0_int_p)ba0_mint_hp_module)

#   define ba0_mint_hp_sub(rop,opa,opb)                  \
    rop = (ba0_mint_hp)(((unsigned ba0_int_p)ba0_mint_hp_module + \
                (unsigned ba0_int_p)(opa) -              \
                (unsigned ba0_int_p)(opb))               \
                % (unsigned ba0_int_p)ba0_mint_hp_module)

#   define ba0_mint_hp_mul(rop,opa,opb)                  \
    rop = (ba0_mint_hp)(((unsigned ba0_int_p)(opa)*      \
                (unsigned ba0_int_p)(opb))               \
                % (unsigned ba0_int_p)ba0_mint_hp_module)

#   define ba0_mint_hp_mul_ui(rop,opa,opb)               \
    rop = (ba0_mint_hp)(((unsigned ba0_int_p)(opa)*      \
                (unsigned ba0_int_p)(opb))               \
                % (unsigned ba0_int_p)ba0_mint_hp_module)

#   define ba0_mint_hp_mul_si(rop,opa,opb)               \
    rop = (ba0_mint_hp)(((ba0_int_p)(opa)*((opb) > 0 ? (opb) : \
            ba0_mint_hp_module - (opb)))                 \
            % (unsigned ba0_int_p)ba0_mint_hp_module)

#   define ba0_mint_hp_pow_ui(rop,opa,opb)    rop = ba0_pow_mint_hp(opa,opb)

#   define ba0_mint_hp_div(rop,opa,opb)                  \
    rop = (ba0_mint_hp)(((unsigned ba0_int_p)(opa)*      \
            (unsigned ba0_int_p)ba0_invert_mint_hp(opb)) \
            % (unsigned ba0_int_p)ba0_mint_hp_module)

#   define ba0_mint_hp_invert(rop,op)    rop = ba0_invert_mint_hp (op)

#endif /* !BA0_MACROS_MINT_HP_H */
#if ! defined (BA0_MACROS_MPZ_H)
#   define BA0_MACROS_MPZ_H 1

/* #   include "ba0_common.h" */

/*
 * Macros for mpz_t
 *
 * These macros are mostly needed for generic code in the bap library
 */

#   if defined (BA0_USE_GMP)

/*
 * All ba0_functions are mapped to the GMP ones
 */

#      define ba0_mp_set_memory_functions mp_set_memory_functions
#      define ba0_mp_get_memory_functions mp_get_memory_functions

#      define ba0_mpz_t                   mpz_t
#      define ba0__mpz_struct             __mpz_struct
#      define ba0_mp_limb_t               mp_limb_t

#      define ba0_mpz_affect(rop,op)      rop [0] = op [0]
#      define ba0_mpz_init(rop)           mpz_init(rop)
#      define ba0_mpz_clear(rop)          mpz_clear(rop)
#      define ba0_mpz_set(rop,op)         mpz_set(rop,op)
#      define ba0_mpz_swap(rop,op)        mpz_swap(rop,op)
#      define ba0_mpz_init_set(rop,op)    mpz_init_set(rop,op)
#      define ba0_mpz_get_si(op)          mpz_get_si(op)
#      define ba0_mpz_set_str(rop,opa,opb) mpz_set_str(rop,opa,opb)
#      define ba0_mpz_get_str(rop,opa,opb) mpz_get_str(rop,opa,opb)
#      define ba0_mpz_size(op)            mpz_size(op)
#      define ba0_mpz_sizeinbase(opa,opb) mpz_sizeinbase(opa,opb)

#      if ! defined (BA0_USE_X64_GMP)

/*
 * The Linux / MacOS case
 */

#         define ba0_mpz_set_si(rop,op)         mpz_set_si(rop,op)
#         define ba0_mpz_set_ui(rop,op)         mpz_set_ui(rop,op)
#         define ba0_mpz_init_set_si(rop,op)    mpz_init_set_si(rop,op)
#         define ba0_mpz_init_set_ui(rop,op)    mpz_init_set_ui(rop,op)
#         define ba0_mpz_mul_si(rop,opa,opb)    mpz_mul_si(rop,opa,opb)
#         define ba0_mpz_mul_ui(rop,opa,opb)    mpz_mul_ui(rop,opa,opb)
#         define ba0_mpz_mul_2exp(rop,opa,opb)  mpz_mul_2exp(rop,opa,opb)
#         define ba0_mpz_pow_ui(rop,opa,opb)    mpz_pow_ui(rop,opa,opb)
#         define ba0_mpz_ui_pow_ui(rop,opa,opb) mpz_ui_pow_ui(rop,opa,opb)
#         define ba0_mpz_si_pow_ui(rop,opa,opb) \
                    ba0_x64_mpz_si_pow_ui(rop,opa,opb)

#      else
      /*
       * BA0_USE_X64_GMP 
       */

/*
 * The Windows case
 */

#         define ba0_mpz_set_si(rop,op)        ba0_x64_mpz_set_si(rop,op)
#         define ba0_mpz_set_ui(rop,op)        ba0_x64_mpz_set_ui(rop,op)

#         define ba0_mpz_init_set_si(rop,op)    do { \
                    mpz_init(rop);                \
                    ba0_x64_mpz_set_si(rop,op);   \
                    } while (0)

#         define ba0_mpz_init_set_ui(rop,op)    do { \
                    mpz_init(rop);                \
                    ba0_x64_mpz_set_ui(rop,op);   \
                    } while (0)

#         define ba0_mpz_mul_si(rop,opa,opb)    ba0_x64_mpz_mul_si(rop,opa,opb)
#         define ba0_mpz_mul_ui(rop,opa,opb)    ba0_x64_mpz_mul_ui(rop,opa,opb)
#         define ba0_mpz_mul_2exp(rop,opa,opb) \
                    ba0_x64_mpz_mul_2exp(rop,opa,opb)
#         define ba0_mpz_pow_ui(rop,opa,opb)    ba0_x64_mpz_pow_ui(rop,opa,opb)
#         define ba0_mpz_ui_pow_ui(rop,opa,opb) \
                    ba0_x64_mpz_ui_pow_ui(rop,opa,opb)
#         define ba0_mpz_si_pow_ui(rop,opa,opb) \
                    ba0_x64_mpz_si_pow_ui(rop,opa,opb)

#      endif
       /*
        * BA0_USE_X64_GMP 
        */

#      define ba0_mpz_sgn(op)               mpz_sgn(op)
#      define ba0_mpz_is_zero(op)           (mpz_sgn(op) == 0)
#      define ba0_mpz_is_nonzero(op)        (mpz_sgn(op) != 0)
#      define ba0_mpz_is_one(op)            (mpz_cmp_ui(op,1) == 0)
#      define ba0_mpz_is_negative(op)       (mpz_sgn(op) < 0)
#      define ba0_mpz_are_equal(opa,opb)    (mpz_cmp((opa),(opb)) == 0)
#      define ba0_mpz_neg(opa,opb)          mpz_neg(opa,opb)
#      define ba0_mpz_abs(rop,op)           mpz_abs(rop,op)
#      define ba0_mpz_fac_ui(rop,op)        mpz_fac_ui(rop,op)
#      define ba0_mpz_add(rop,opa,opb)      mpz_add(rop,opa,opb)
#      define ba0_mpz_add_ui(rop,opa,opb)   mpz_add_ui(rop,opa,opb)
#      define ba0_mpz_sub(rop,opa,opb)      mpz_sub(rop,opa,opb)
#      define ba0_mpz_sub_ui(rop,opa,opb)   mpz_sub_ui(rop,opa,opb)
#      define ba0_mpz_mul(rop,opa,opb)      mpz_mul(rop,opa,opb)
#      define ba0_mpz_div(rop,opa,opb)      mpz_fdiv_q(rop,opa,opb)
#      define ba0_mpz_mod(rop,opa,opb)      mpz_mod(rop,opa,opb)
#      define ba0_mpz_mod_ui(rop,opa,opb)   mpz_mod_ui(rop,opa,opb)
#      define ba0_mpz_powm(rop,opa,opb,opc) mpz_powm(rop,opa,opb,opc)
#      define ba0_mpz_powm_ui(rop,opa,opb,opc) mpz_powm_ui(rop,opa,opb,opc)
#      define ba0_mpz_cmpabs(opa,opb)       mpz_cmpabs(opa,opb)
#      define ba0_mpz_cmp_si(opa,opb)       mpz_cmp_si(opa,opb)
#      define ba0_mpz_cmp_ui(opa,opb)       mpz_cmp_ui(opa,opb)
#      define ba0_mpz_cmp(opa,opb)          mpz_cmp(opa,opb)
#      define ba0_mpz_invert(rop,opa,opb)   mpz_invert(rop,opa,opb)
#      define ba0_mpz_fdiv_ui(rop,op)       mpz_fdiv_ui(rop,op)
#      define ba0_mpz_fdiv_q_2exp(rop,opa,opb) mpz_fdiv_q_2exp(rop,opa,opb)
#      define ba0_mpz_tdiv_q_2exp(rop,opa,opb) mpz_tdiv_q_2exp(rop,opa,opb)
#      define ba0_mpz_tdiv_qr(ropa,ropb,opa,opb) mpz_tdiv_qr(ropa,ropb,opa,opb)
#      define ba0_mpz_tdiv_q(rop,opa,opb)   mpz_tdiv_q(rop,opa,opb)
#      define ba0_mpz_tdiv_q_ui(rop,opa,opb) mpz_tdiv_q_ui(rop,opa,opb)
#      define ba0_mpz_tdiv_r_ui(rop,opa,opb) mpz_tdiv_r_ui(rop,opa,opb)
#      define ba0_mpz_gcd(rop,opa,opb)      mpz_gcd(rop,opa,opb)
#      define ba0_mpz_gcdext(rop,opa,opb,opc,opd) mpz_gcdext(rop,opa,opb,opc,opd)
#      define ba0_mpz_lcm(rop,opa,opb)      mpz_lcm(rop,opa,opb)
#      define ba0_mpz_divexact(rop,opa,opb) mpz_divexact(rop,opa,opb)
#      define ba0_mpz_sqrt(rop,op)          mpz_sqrt(rop,op)
#      define ba0_mpz_bin_uiui(rop,opa,opb) mpz_bin_uiui(rop,opa,opb)
#      define ba0_mpz_tstbit(opa,opb)       mpz_tstbit(opa,opb)
#      define ba0_mpz_even_p(op)            mpz_even_p(op)

#   else
      /*
       * BA0_USE_GMP 
       */

/*
 * All ba0_functions are mapped to the mini-gmp ones
 */

#      define ba0_mp_set_memory_functions bam_mp_set_memory_functions
#      define ba0_mp_get_memory_functions bam_mp_get_memory_functions

#      define ba0_mpz_t                   bam_mpz_t
#      define ba0__mpz_struct             bam__mpz_struct
#      define ba0_mp_limb_t               bam_mp_limb_t

#      define ba0_mpz_affect(rop,op)      rop [0] = op [0]
#      define ba0_mpz_init(rop)           bam_mpz_init(rop)
#      define ba0_mpz_clear(rop)          bam_mpz_clear(rop)
#      define ba0_mpz_set(rop,op)         bam_mpz_set(rop,op)
#      define ba0_mpz_swap(rop,op)        bam_mpz_swap(rop,op)
#      define ba0_mpz_init_set(rop,op)    bam_mpz_init_set(rop,op)
#      define ba0_mpz_set_str(rop,opa,opb) bam_mpz_set_str(rop,opa,opb)
#      define ba0_mpz_get_str(rop,opa,opb) bam_mpz_get_str(rop,opa,opb)
#      define ba0_mpz_get_si(op)          bam_mpz_get_si(op)
#      define ba0_mpz_size(op)            bam_mpz_size(op)
#      define ba0_mpz_sizeinbase(opa,opb) bam_mpz_sizeinbase(opa,opb)

#      if ! defined (BA0_USE_X64_GMP)

/*
 * The Linux / MacOS case
 */

#         define ba0_mpz_set_si(rop,op)         bam_mpz_set_si(rop,op)
#         define ba0_mpz_set_ui(rop,op)         bam_mpz_set_ui(rop,op)
#         define ba0_mpz_init_set_si(rop,op)    bam_mpz_init_set_si(rop,op)
#         define ba0_mpz_init_set_ui(rop,op)    bam_mpz_init_set_ui(rop,op)
#         define ba0_mpz_mul_si(rop,opa,opb)    bam_mpz_mul_si(rop,opa,opb)
#         define ba0_mpz_mul_ui(rop,opa,opb)    bam_mpz_mul_ui(rop,opa,opb)
#         define ba0_mpz_mul_2exp(rop,opa,opb)  bam_mpz_mul_2exp(rop,opa,opb)
#         define ba0_mpz_pow_ui(rop,opa,opb)    bam_mpz_pow_ui(rop,opa,opb)
#         define ba0_mpz_ui_pow_ui(rop,opa,opb) bam_mpz_ui_pow_ui(rop,opa,opb)

#      else
      /*
       * BA0_USE_X64_GMP 
       */

/*
 * The Windows case
 */

#         define ba0_mpz_set_si(rop,op)        ba0_x64_mpz_set_si(rop,op)
#         define ba0_mpz_set_ui(rop,op)        ba0_x64_mpz_set_ui(rop,op)

#         define ba0_mpz_init_set_si(rop,op)    do { \
                    bam_mpz_init(rop);                \
                    ba0_x64_mpz_set_si(rop,op);   \
                    } while (0)

#         define ba0_mpz_init_set_ui(rop,op)    do { \
                    bam_mpz_init(rop);                \
                    ba0_x64_mpz_set_ui(rop,op);   \
                    } while (0)

#         define ba0_mpz_mul_si(rop,opa,opb)    ba0_x64_mpz_mul_si(rop,opa,opb)
#         define ba0_mpz_mul_ui(rop,opa,opb)    ba0_x64_mpz_mul_ui(rop,opa,opb)
#         define ba0_mpz_mul_2exp(rop,opa,opb) \
                    ba0_x64_mpz_mul_2exp(rop,opa,opb)
#         define ba0_mpz_pow_ui(rop,opa,opb)    ba0_x64_mpz_pow_ui(rop,opa,opb)
#         define ba0_mpz_ui_pow_ui(rop,opa,opb) \
                    ba0_x64_mpz_ui_pow_ui(rop,opa,opb)

#      endif
       /*
        * BA0_USE_X64_GMP 
        */

#      define ba0_mpz_sgn(op)               bam_mpz_sgn(op)
#      define ba0_mpz_is_zero(op)           (bam_mpz_sgn(op) == 0)
#      define ba0_mpz_is_nonzero(op)        (bam_mpz_sgn(op) != 0)
#      define ba0_mpz_is_one(op)            (bam_mpz_cmp_ui(op,1) == 0)
#      define ba0_mpz_is_negative(op)       (bam_mpz_sgn(op) < 0)
#      define ba0_mpz_are_equal(opa,opb)    (bam_mpz_cmp((opa),(opb)) == 0)
#      define ba0_mpz_neg(opa,opb)          bam_mpz_neg(opa,opb)
#      define ba0_mpz_abs(rop,op)           bam_mpz_abs(rop,op)
#      define ba0_mpz_fac_ui(rop,op)        bam_mpz_fac_ui(rop,op)
#      define ba0_mpz_add(rop,opa,opb)      bam_mpz_add(rop,opa,opb)
#      define ba0_mpz_add_ui(rop,opa,opb)   bam_mpz_add_ui(rop,opa,opb)
#      define ba0_mpz_sub(rop,opa,opb)      bam_mpz_sub(rop,opa,opb)
#      define ba0_mpz_sub_ui(rop,opa,opb)   bam_mpz_sub_ui(rop,opa,opb)
#      define ba0_mpz_mul(rop,opa,opb)      bam_mpz_mul(rop,opa,opb)
#      define ba0_mpz_div(rop,opa,opb)      bam_mpz_fdiv_q(rop,opa,opb)
#      define ba0_mpz_mod(rop,opa,opb)      bam_mpz_mod(rop,opa,opb)
#      define ba0_mpz_mod_ui(rop,opa,opb)   bam_mpz_mod_ui(rop,opa,opb)
#      define ba0_mpz_powm(rop,opa,opb,opc) bam_mpz_powm(rop,opa,opb,opc)
#      define ba0_mpz_powm_ui(rop,opa,opb,opc) bam_mpz_powm_ui(rop,opa,opb,opc)
#      define ba0_mpz_cmpabs(opa,opb)       bam_mpz_cmpabs(opa,opb)
#      define ba0_mpz_cmp_si(opa,opb)       bam_mpz_cmp_si(opa,opb)
#      define ba0_mpz_cmp_ui(opa,opb)       bam_mpz_cmp_ui(opa,opb)
#      define ba0_mpz_cmp(opa,opb)          bam_mpz_cmp(opa,opb)
#      define ba0_mpz_invert(rop,opa,opb)   bam_mpz_invert(rop,opa,opb)
#      define ba0_mpz_fdiv_ui(rop,op)       bam_mpz_fdiv_ui(rop,op)
#      define ba0_mpz_fdiv_q_2exp(rop,opa,opb) bam_mpz_fdiv_q_2exp(rop,opa,opb)
#      define ba0_mpz_tdiv_q_2exp(rop,opa,opb) bam_mpz_tdiv_q_2exp(rop,opa,opb)
#      define ba0_mpz_tdiv_qr(ropa,ropb,opa,opb) bam_mpz_tdiv_qr(ropa,ropb,opa,opb)
#      define ba0_mpz_tdiv_q(rop,opa,opb)   bam_mpz_tdiv_q(rop,opa,opb)
#      define ba0_mpz_tdiv_q_ui(rop,opa,opb) bam_mpz_tdiv_q_ui(rop,opa,opb)
#      define ba0_mpz_tdiv_r_ui(rop,opa,opb) bam_mpz_tdiv_r_ui(rop,opa,opb)
#      define ba0_mpz_gcd(rop,opa,opb)      bam_mpz_gcd(rop,opa,opb)
#      define ba0_mpz_gcdext(rop,opa,opb,opc,opd) bam_mpz_gcdext(rop,opa,opb,opc,opd)
#      define ba0_mpz_lcm(rop,opa,opb)      bam_mpz_lcm(rop,opa,opb)
#      define ba0_mpz_divexact(rop,opa,opb) bam_mpz_divexact(rop,opa,opb)
#      define ba0_mpz_sqrt(rop,op)          bam_mpz_sqrt(rop,op)
#      define ba0_mpz_bin_uiui(rop,opa,opb) bam_mpz_bin_uiui(rop,opa,opb)
#      define ba0_mpz_tstbit(opa,opb)       bam_mpz_tstbit(opa,opb)
#      define ba0_mpz_even_p(op)            bam_mpz_even_p(op)

#   endif
       /*
        * BA0_USE_GMP 
        */

#endif /* !BA0_MACROS_MPZ_H */
#if !defined (BA0_MACROS_MPQ_H)
#   define BA0_MACROS_MPQ_H 1

/* #   include "ba0_common.h" */
/* #   include "ba0_macros_mpz.h" */

/* 
 * Macros for mpq_t
 */

#   if defined (BA0_USE_GMP)

#      define ba0_mpq_t                            mpq_t
#      define ba0__mpq_struct                      __mpq_struct

#      define ba0_mpq_affect(rop,op)               rop [0] = op [0]
#      define ba0_mpq_init(rop)                    mpq_init(rop)
#      define ba0_mpq_clear(rop)                   mpq_clear(rop)
#      define ba0_mpq_set(rop,op)                  mpq_set(rop,op)
#      define ba0_mpq_swap(rop,op)                 mpq_swap(rop,op)

#      if ! defined (BA0_USE_X64_GMP)
/*
 * The Linux / Mac OS case
 */
#         define ba0_mpq_set_si(rop,op)            mpq_set_si(rop,op,1)
#         define ba0_mpq_set_si_si(rop,opa,opb)    mpq_set_si(rop,opa,opb)
#         define ba0_mpq_set_ui(rop,op)            mpq_set_ui(rop,op,1)

#      else
/*
 * The Windows case
 */
#         define ba0_mpq_set_si(rop,op)            ba0_x64_mpq_set_si(rop,op,1)
#         define ba0_mpq_set_si_si(rop,opa,opb)    ba0_x64_mpq_set_si(rop,opa,opb)
#         define ba0_mpq_set_ui(rop,op)            ba0_x64_mpq_set_ui(rop,op,1)

#      endif
       /*
        * BA0_USE_X64_GMP 
        */

#      define ba0_mpq_sgn(op)                      mpq_sgn(op)
#      define ba0_mpq_cmp(opa,opb)                 mpq_cmp(opa,opb)
#      define ba0_mpq_cmp_si(opa,opb,opc)          mpq_cmp_si((opa),(opb),(opc))
#      define ba0_mpq_is_zero(op)                  (mpq_cmp_ui((op),0,1) == 0)
#      define ba0_mpq_is_one(op)                   (mpq_cmp_ui((op),1,1) == 0)
#      define ba0_mpq_is_negative(op)              (mpq_cmp_ui((op),0,1) < 0)
#      define ba0_mpq_are_equal(opa,opb)           (mpq_cmp((opa),(opb)) == 0)
#      define ba0_mpq_neg(opa,opb)                 mpq_neg(opa,opb)
#      define ba0_mpq_add(rop,opa,opb)             mpq_add(rop,opa,opb)
#      define ba0_mpq_sub(rop,opa,opb)             mpq_sub(rop,opa,opb)
#      define ba0_mpq_mul(rop,opa,opb)             mpq_mul(rop,opa,opb)

#      define ba0_mpq_canonicalize(rop)            mpq_canonicalize(rop)
#      define ba0_mpq_numref(rop)                  mpq_numref(rop)
#      define ba0_mpq_denref(rop)                  mpq_denref(rop)
#      define ba0_mpq_get_d(rop)                   mpq_get_d(rop)
#      define ba0_mpq_set_d(rop,op)                mpq_set_d(rop,op)
#      define ba0_mpq_set_num(rop,op)              mpq_set_num(rop,op)
#      define ba0_mpq_set_den(rop,op)              mpq_set_den(rop,op)
#      define ba0_mpq_set_z(rop,op)                mpq_set_z(rop,op)

#      define ba0_mpq_div(rop,opa,opb)             mpq_div(rop,opa,opb)
#      define ba0_mpq_invert(rop,op)               mpq_inv(rop,op)

#   else
      /*
       * BA0_USE_GMP 
       */

#      define ba0_mpq_t                            bam_mpq_t
#      define ba0__mpq_struct                      bam__mpq_struct

#      define ba0_mpq_affect(rop,op)               rop [0] = op [0]
#      define ba0_mpq_init(rop)                    bam_mpq_init(rop)
#      define ba0_mpq_clear(rop)                   bam_mpq_clear(rop)
#      define ba0_mpq_set(rop,op)                  bam_mpq_set(rop,op)
#      define ba0_mpq_swap(rop,op)                 bam_mpq_swap(rop,op)

#      if ! defined (BA0_USE_X64_GMP)
/*
 * The Linux / Mac OS case
 */
#         define ba0_mpq_set_si(rop,op)            bam_mpq_set_si(rop,op,1)
#         define ba0_mpq_set_si_si(rop,opa,opb)    bam_mpq_set_si(rop,opa,opb)
#         define ba0_mpq_set_ui(rop,op)            bam_mpq_set_ui(rop,op,1)

#      else
/*
 * The Windows case
 */
#         define ba0_mpq_set_si(rop,op)            ba0_x64_mpq_set_si(rop,op,1)
#         define ba0_mpq_set_si_si(rop,opa,opb)    ba0_x64_mpq_set_si(rop,opa,opb)
#         define ba0_mpq_set_ui(rop,op)            ba0_x64_mpq_set_ui(rop,op,1)

#      endif
       /*
        * BA0_USE_X64_GMP 
        */

#      define ba0_mpq_sgn(op)                      bam_mpq_sgn(op)
#      define ba0_mpq_cmp(opa,opb)                 bam_mpq_cmp(opa,opb)
#      define ba0_mpq_cmp_si(opa,opb,opc)          bam_mpq_cmp_si((opa),(opb),(opc))
#      define ba0_mpq_is_zero(op)                  (bam_mpq_cmp_ui((op),0,1) == 0)
#      define ba0_mpq_is_one(op)                   (bam_mpq_cmp_ui((op),1,1) == 0)
#      define ba0_mpq_is_negative(op)              (bam_mpq_cmp_ui((op),0,1) < 0)
#      define ba0_mpq_are_equal(opa,opb)           (bam_mpq_cmp((opa),(opb)) == 0)
#      define ba0_mpq_neg(opa,opb)                 bam_mpq_neg(opa,opb)
#      define ba0_mpq_add(rop,opa,opb)             bam_mpq_add(rop,opa,opb)
#      define ba0_mpq_sub(rop,opa,opb)             bam_mpq_sub(rop,opa,opb)
#      define ba0_mpq_mul(rop,opa,opb)             bam_mpq_mul(rop,opa,opb)

#      define ba0_mpq_canonicalize(rop)            bam_mpq_canonicalize(rop)
#      define ba0_mpq_numref(rop)                  bam_mpq_numref(rop)
#      define ba0_mpq_denref(rop)                  bam_mpq_denref(rop)
#      define ba0_mpq_get_d(rop)                   bam_mpq_get_d(rop)
#      define ba0_mpq_set_d(rop,op)                bam_mpq_set_d(rop,op)
#      define ba0_mpq_set_num(rop,op)              bam_mpq_set_num(rop,op)
#      define ba0_mpq_set_den(rop,op)              bam_mpq_set_den(rop,op)
#      define ba0_mpq_set_z(rop,op)                bam_mpq_set_z(rop,op)

#      define ba0_mpq_div(rop,opa,opb)             bam_mpq_div(rop,opa,opb)
#      define ba0_mpq_invert(rop,op)               bam_mpq_inv(rop,op)

#   endif
       /*
        * BA0_USE_GMP 
        */

/*
 * Generic macros
 */

#   define ba0_mpq_init_set(rop,op)             \
        do {                                    \
          ba0_mpq_init(rop);                    \
          ba0_mpq_set(rop,op);                  \
        } while (0)

#   define ba0_mpq_init_set_si(rop,op)          \
        do {                                    \
          ba0_mpq_init(rop);                    \
          ba0_mpq_set_si(rop,op);               \
        } while (0)

#   define ba0_mpq_init_set_ui(rop,op)          \
        do {                                    \
          ba0_mpq_init(rop);                    \
          ba0_mpq_set_ui(rop,op);               \
        } while (0)

#   define ba0_mpq_mul_ui(rop,opa,opb)          \
        do {                                    \
          ba0_mpq_set(rop,opa);                 \
          ba0_mpz_mul_ui(ba0_mpq_numref(rop),ba0_mpq_numref(opa),opb); \
          ba0_mpq_canonicalize(rop);            \
        } while (0)

#   define ba0_mpq_mul_si(rop,opa,opb)          \
        do {                                    \
          ba0_mpq_set(rop,opa);                 \
          ba0_mpz_mul_si(ba0_mpq_numref(rop),ba0_mpq_numref(rop),opb); \
          ba0_mpq_canonicalize(rop);            \
        } while (0)

#   define ba0_mpq_pow_ui(rop,opa,opb)          \
        do {                                    \
          ba0_mpz_pow_ui(ba0_mpq_numref(rop),ba0_mpq_numref(opa),opb); \
          ba0_mpz_pow_ui(ba0_mpq_denref(rop),ba0_mpq_denref(opa),opb); \
        } while (0)

#endif /* !BA0_MACROS_MPQ_H */
#if !defined (BA0_MACROS_MPZM_H)
#   define BA0_MACROS_MPZM_H 1

/* #   include "ba0_common.h" */
/* #   include "ba0_macros_mpz.h" */

/* 
 * Macros for ba0_mpzm
 */

#   define ba0_mpzm_t                           ba0_mpz_t
#   define ba0_mpzm_module                      ba0_global.mpzm.module
#   define ba0_mpzm_init(rop)                   ba0_mpz_init(rop)
#   define ba0_mpzm_set(rop,op)                 ba0_mpz_set(rop,op)
#   define ba0_mpzm_affect(rop,op)              rop [0] = op [0]
#   define ba0_mpzm_swap(opa,opb)               ba0_mpz_swap(opa,opb)

#   define ba0_mpzm_set_si(rop,op)              \
        do {                                    \
          ba0_mpz_set_si(rop,op);               \
          ba0_mpz_mod(rop,rop,ba0_mpzm_module); \
        } while (0)

#   define ba0_mpzm_init_set(rop,op)    ba0_mpz_init_set(rop,op)

#   define ba0_mpzm_init_set_si(rop,op)         \
        do {                                    \
          ba0_mpz_init_set_si(rop,op);          \
          ba0_mpz_mod(rop,rop,ba0_mpzm_module); \
        } while (0)

#   define ba0_mpzm_init_set_ui(rop,op)         \
        do {                                    \
          ba0_mpz_init_set_ui(rop,op);          \
          ba0_mpz_mod(rop,rop,ba0_mpzm_module); \
        } while (0)

#   define ba0_mpzm_is_zero(op)                 (ba0_mpz_cmp_ui((op),0) == 0)
#   define ba0_mpzm_is_one(op)                  (ba0_mpz_cmp_ui((op),1) == 0)
#   define ba0_mpzm_is_negative(op)             false
#   define ba0_mpzm_are_equal(opa,opb)          (ba0_mpz_cmp((opa),(opb)) == 0)

#   define ba0_mpzm_neg(rop,op)                 \
        do {                                    \
          ba0_mpz_neg(rop,op);                  \
          ba0_mpz_mod(rop,rop,ba0_mpzm_module); \
        } while (0)

#   define ba0_mpzm_add(rop,opa,opb)            \
        do {                                    \
          ba0_mpz_add(rop,opa,opb);             \
          ba0_mpz_mod(rop,rop,ba0_mpzm_module); \
        } while (0)

#   define ba0_mpzm_sub(rop,opa,opb)            \
        do {                                    \
          ba0_mpz_sub(rop,opa,opb);             \
          ba0_mpz_mod(rop,rop,ba0_mpzm_module); \
        } while (0)

#   define ba0_mpzm_mul(rop,opa,opb)            \
        do {                                    \
          ba0_push_stack (&ba0_global.stack.quiet); \
          ba0_mpz_mul(ba0_mpzm_accum,opa,opb);  \
          ba0_pull_stack ();                    \
          ba0_mpz_mod(rop,ba0_mpzm_accum,ba0_mpzm_module); \
        } while (0)

#   define ba0_mpzm_mul_ui(rop,opa,opb)         \
        do {                                    \
          ba0_push_stack (&ba0_global.stack.quiet); \
          ba0_mpz_mul_ui(ba0_mpzm_accum,opa,opb);   \
          ba0_pull_stack ();                    \
          ba0_mpz_mod(rop,ba0_mpzm_accum,ba0_mpzm_module); \
        } while (0)

#   define ba0_mpzm_mul_si(rop,opa,opb)         \
        do {                                    \
          ba0_mpz_mul_si(rop,opa,opb);          \
          ba0_mpz_mod(rop,rop,ba0_mpzm_module); \
        } while (0)

#   if ! defined (BA0_USE_X64_GMP)
/*
 * The Linux / Mac OS Case
 */
#      define ba0_mpzm_pow_ui(rop,opa,opb)      \
        ba0_mpz_powm_ui(rop,opa,opb,ba0_mpzm_module)
#   else
/*
 * The Windows case
 */
#      define ba0_mpzm_pow_ui(rop,opa,opb)      \
        do {                                    \
          ba0_mpz_t bunk;                       \
          ba0_push_another_stack ();            \
          ba0_mpz_set_ui(bunk,opb);             \
          ba0_pull_stack ();                    \
          ba0_mpz_powm(rop,opa,bunk,ba0_mpzm_module); \
        } while (0)
#   endif

#   define ba0_mpzm_div(rop,opa,opb)            \
        do {                                    \
          ba0_push_stack (&ba0_global.stack.quiet);           \
          ba0_mpz_invert(ba0_mpzm_accum,opb,ba0_mpzm_module); \
          ba0_mpz_mul(ba0_mpzm_accum,ba0_mpzm_accum,opa);     \
          ba0_pull_stack ();                    \
          ba0_mpz_mod(rop,ba0_mpzm_accum,ba0_mpzm_module);    \
        } while (0)

#   define ba0_mpzm_invert(rop,op)              \
      ba0_mpz_invert(rop,op,ba0_mpzm_module)

#endif /* !BA0_MACROS_MPZM_H */
#if !defined (BA0_DOUBLE_H)
#   define BA0_DOUBLE_H 1

/* #   include "ba0_common.h" */

BEGIN_C_DECLS

typedef double *ba0_double;

struct ba0_tableof_double
{
  ba0_int_p alloc;
  ba0_int_p size;
  ba0_double *tab;
};

struct ba0_arrayof_double
{
  ba0_int_p alloc;
  ba0_int_p size;
  double *tab;
  ba0_int_p sizelt;
};

struct ba0_matrixof_double
{
  ba0_int_p alloc;
  ba0_int_p nrow;
  ba0_int_p ncol;
  ba0_double *entry;
};

extern BA0_DLL ba0_double ba0_new_double (
    void);

extern BA0_DLL ba0_scanf_function ba0_scanf_double;

extern BA0_DLL ba0_printf_function ba0_printf_double;

extern BA0_DLL ba0_garbage1_function ba0_garbage1_double;

extern BA0_DLL ba0_garbage2_function ba0_garbage2_double;

extern BA0_DLL ba0_copy_function ba0_copy_double;

extern BA0_DLL int ba0_isnan (
    double);

extern BA0_DLL int ba0_isinf (
    double);

extern BA0_DLL double ba0_atof (
    char *);

extern BA0_DLL unsigned ba0_int_p ba0_sizeof_arrayof_double (
    struct ba0_arrayof_double *,
    enum ba0_garbage_code);

END_C_DECLS
#endif /* !BA0_DOUBLE_H */
#if ! defined (BA0_GMP_H)
#   define BA0_GMP_H 1

/* #   include "ba0_common.h" */

#   if defined (BA0_USE_GMP)
#      include <gmp.h>
#   else
/* #      include "mini-gmp.h" */
/* #      include "mini-mpq.h" */
#   endif

/* #   include "ba0_macros_mpz.h" */
/* #   include "ba0_macros_mpq.h" */

BEGIN_C_DECLS

struct ba0_tableof_mpz
{
  ba0_int_p alloc;
  ba0_int_p size;
  ba0__mpz_struct **tab;
};

struct ba0_tableof_tableof_mpz
{
  ba0_int_p alloc;
  ba0_int_p size;
  struct ba0_tableof_mpz **tab;
};

struct ba0_listof_mpz
{
  ba0__mpz_struct *value;
  struct ba0_listof_mpz *next;
};

struct ba0_tableof_mpq
{
  ba0_int_p alloc;
  ba0_int_p size;
  ba0__mpq_struct **tab;
};

struct ba0_listof_mpq
{
  ba0__mpq_struct *value;
  struct ba0_listof_mpq *next;
};

typedef void ba0_set_memory_functions_function (
    void *(*)(size_t),
    void *(*)(void *,
        size_t,
        size_t),
    void (*)(void *,
        size_t));


extern BA0_DLL void ba0_set_settings_gmp (
    ba0_set_memory_functions_function *,
    char *);

extern BA0_DLL void ba0_get_settings_gmp (
    ba0_set_memory_functions_function **,
    char **);

extern BA0_DLL void ba0_record_gmp_memory_functions (
    void);

extern BA0_DLL void ba0_restore_gmp_memory_functions (
    void);

extern BA0_DLL bool ba0_domain_mpz (
    void);

extern BA0_DLL bool ba0_domain_mpq (
    void);

extern BA0_DLL void *ba0_gmp_alloc (
    size_t);

extern BA0_DLL void *ba0_gmp_realloc (
    void *,
    size_t,
    size_t);

extern BA0_DLL void ba0_gmp_free (
    void *,
    size_t);

extern BA0_DLL void ba0_set_tableof_mpz (
    struct ba0_tableof_mpz *,
    struct ba0_tableof_mpz *);

extern BA0_DLL void ba0_set_tableof_tableof_mpz (
    struct ba0_tableof_tableof_mpz *,
    struct ba0_tableof_tableof_mpz *);

extern BA0_DLL ba0__mpq_struct *ba0_new_mpq (
    void);

extern BA0_DLL ba0__mpz_struct *ba0_new_mpz (
    void);

extern BA0_DLL void ba0_mpz_si_pow_ui (
    ba0__mpz_struct *,
    ba0_int_p,
    unsigned ba0_int_p);

extern BA0_DLL void ba0_mpz_nextprime (
    ba0__mpz_struct *,
    ba0__mpz_struct *);

extern BA0_DLL ba0_scanf_function ba0_scanf_mpz;

extern BA0_DLL ba0_printf_function ba0_printf_mpz;

extern BA0_DLL ba0_garbage1_function ba0_garbage1_mpz;

extern BA0_DLL ba0_garbage2_function ba0_garbage2_mpz;

extern BA0_DLL ba0_copy_function ba0_copy_mpz;

extern BA0_DLL ba0_scanf_function ba0_scanf_mpq;

extern BA0_DLL ba0_printf_function ba0_printf_mpq;

extern BA0_DLL ba0_garbage1_function ba0_garbage1_mpq;

extern BA0_DLL ba0_garbage2_function ba0_garbage2_mpq;

extern BA0_DLL ba0_copy_function ba0_copy_mpq;

END_C_DECLS
#endif /* !BA0_GMP_H */
#if ! defined (BA0_INTERVAL_MPQ_H)
#   define BA0_INTERVAL_MPQ_H 1

/* #   include "ba0_common.h" */
/* #   include "ba0_gmp.h" */
/* #   include "ba0_macros_mpq.h" */

BEGIN_C_DECLS

enum ba0_typeof_interval
{
  ba0_closed_interval,
  ba0_open_interval,
  ba0_empty_interval,
  ba0_infinite_interval,
  ba0_left_infinite_interval,
  ba0_right_infinite_interval
};

struct ba0_interval_mpq
{
  ba0_mpq_t a;
  ba0_mpq_t b;
  enum ba0_typeof_interval type;
};


struct ba0_tableof_interval_mpq
{
  ba0_int_p alloc;
  ba0_int_p size;
  struct ba0_interval_mpq **tab;
};


struct ba0_listof_interval_mpq
{
  struct ba0_interval_mpq *value;
  struct ba0_listof_interval_mpq *next;
};


extern BA0_DLL bool ba0_domain_interval_mpq (
    void);

extern BA0_DLL void ba0_init_interval_mpq (
    struct ba0_interval_mpq *);

extern BA0_DLL struct ba0_interval_mpq *ba0_new_interval_mpq (
    void);

extern BA0_DLL void ba0_set_interval_mpq_si (
    struct ba0_interval_mpq *,
    ba0_int_p);

extern BA0_DLL void ba0_set_interval_mpq_ui (
    struct ba0_interval_mpq *,
    unsigned ba0_int_p);

extern BA0_DLL void ba0_set_interval_mpq_double (
    struct ba0_interval_mpq *,
    double);

extern BA0_DLL void ba0_set_interval_mpq_mpq (
    struct ba0_interval_mpq *,
    ba0_mpq_t,
    ba0_mpq_t);

extern BA0_DLL void ba0_set_interval_mpq_type_mpq (
    struct ba0_interval_mpq *,
    enum ba0_typeof_interval,
    ba0_mpq_t,
    ba0_mpq_t);

extern BA0_DLL void ba0_set_interval_mpq (
    struct ba0_interval_mpq *,
    struct ba0_interval_mpq *);

extern BA0_DLL bool ba0_is_empty_interval_mpq (
    struct ba0_interval_mpq *);

extern BA0_DLL bool ba0_is_closed_interval_mpq (
    struct ba0_interval_mpq *);

extern BA0_DLL bool ba0_is_open_interval_mpq (
    struct ba0_interval_mpq *);

extern BA0_DLL bool ba0_is_unbounded_interval_mpq (
    struct ba0_interval_mpq *);

extern BA0_DLL bool ba0_is_zero_interval_mpq (
    struct ba0_interval_mpq *);

extern BA0_DLL bool ba0_is_one_interval_mpq (
    struct ba0_interval_mpq *);

extern BA0_DLL bool ba0_are_equal_interval_mpq (
    struct ba0_interval_mpq *,
    struct ba0_interval_mpq *);

extern BA0_DLL bool ba0_contains_zero_interval_mpq (
    struct ba0_interval_mpq *);

extern BA0_DLL bool ba0_is_positive_interval_mpq (
    struct ba0_interval_mpq *);

extern BA0_DLL bool ba0_is_negative_interval_mpq (
    struct ba0_interval_mpq *);

extern BA0_DLL bool ba0_is_nonpositive_interval_mpq (
    struct ba0_interval_mpq *);

extern BA0_DLL bool ba0_is_nonnegative_interval_mpq (
    struct ba0_interval_mpq *);

extern BA0_DLL bool ba0_is_less_interval_mpq (
    struct ba0_interval_mpq *,
    struct ba0_interval_mpq *);

extern BA0_DLL bool ba0_are_disjoint_interval_mpq (
    struct ba0_interval_mpq *,
    struct ba0_interval_mpq *);

extern BA0_DLL bool ba0_member_interval_mpq (
    ba0_mpq_t,
    struct ba0_interval_mpq *);

extern BA0_DLL bool ba0_is_subset_interval_mpq (
    struct ba0_interval_mpq *,
    struct ba0_interval_mpq *);

extern BA0_DLL void ba0_element_interval_mpq (
    ba0_mpq_t,
    struct ba0_interval_mpq *,
    unsigned ba0_int_p);

extern BA0_DLL void ba0_middle_interval_mpq (
    ba0_mpq_t,
    struct ba0_interval_mpq *);

extern BA0_DLL double ba0_middle_interval_mpq_double (
    struct ba0_interval_mpq *);

extern BA0_DLL void ba0_width_interval_mpq (
    ba0_mpq_t,
    struct ba0_interval_mpq *);

extern BA0_DLL double ba0_width_interval_mpq_double (
    struct ba0_interval_mpq *);

extern BA0_DLL void ba0_middle_interval_mpq (
    ba0_mpq_t,
    struct ba0_interval_mpq *);

extern BA0_DLL void ba0_intersect_interval_mpq (
    struct ba0_interval_mpq *,
    struct ba0_interval_mpq *,
    struct ba0_interval_mpq *);

extern BA0_DLL void ba0_abs_interval_mpq (
    struct ba0_interval_mpq *,
    struct ba0_interval_mpq *);

extern BA0_DLL void ba0_neg_interval_mpq (
    struct ba0_interval_mpq *,
    struct ba0_interval_mpq *);

extern BA0_DLL void ba0_add_interval_mpq (
    struct ba0_interval_mpq *,
    struct ba0_interval_mpq *,
    struct ba0_interval_mpq *);

extern BA0_DLL void ba0_add_interval_mpq_mpq (
    struct ba0_interval_mpq *,
    struct ba0_interval_mpq *,
    ba0_mpq_t);

extern BA0_DLL void ba0_sub_interval_mpq (
    struct ba0_interval_mpq *,
    struct ba0_interval_mpq *,
    struct ba0_interval_mpq *);

extern BA0_DLL void ba0_sub_mpq_interval_mpq (
    struct ba0_interval_mpq *,
    ba0_mpq_t,
    struct ba0_interval_mpq *);

extern BA0_DLL void ba0_sub_interval_mpq_mpq (
    struct ba0_interval_mpq *,
    struct ba0_interval_mpq *,
    ba0_mpq_t);

extern BA0_DLL void ba0_mul_interval_mpq (
    struct ba0_interval_mpq *,
    struct ba0_interval_mpq *,
    struct ba0_interval_mpq *);

extern BA0_DLL void ba0_mul_interval_mpq_mpq (
    struct ba0_interval_mpq *,
    struct ba0_interval_mpq *,
    ba0_mpq_t);

extern BA0_DLL void ba0_mul_interval_mpq_si (
    struct ba0_interval_mpq *,
    struct ba0_interval_mpq *,
    ba0_int_p);

extern BA0_DLL void ba0_mul_interval_mpq_ui (
    struct ba0_interval_mpq *,
    struct ba0_interval_mpq *,
    unsigned ba0_int_p);

extern BA0_DLL void ba0_pow_interval_mpq (
    struct ba0_interval_mpq *,
    struct ba0_interval_mpq *,
    ba0_int_p);

extern BA0_DLL void ba0_pow_interval_mpq_mpq (
    struct ba0_interval_mpq *,
    ba0_mpq_t,
    ba0_int_p n);

extern BA0_DLL void ba0_div_interval_mpq (
    struct ba0_tableof_interval_mpq *,
    struct ba0_interval_mpq *,
    struct ba0_interval_mpq *);

extern BA0_DLL void ba0_div_mpq_interval_mpq (
    struct ba0_tableof_interval_mpq *,
    ba0_mpq_t,
    struct ba0_interval_mpq *);

extern BA0_DLL void ba0_div_interval_mpq_mpq (
    struct ba0_interval_mpq *,
    struct ba0_interval_mpq *,
    ba0_mpq_t);

extern BA0_DLL ba0_scanf_function ba0_scanf_interval_mpq;

extern BA0_DLL ba0_printf_function ba0_printf_interval_mpq;

extern BA0_DLL ba0_garbage1_function ba0_garbage1_interval_mpq;

extern BA0_DLL ba0_garbage2_function ba0_garbage2_interval_mpq;

extern BA0_DLL ba0_copy_function ba0_copy_interval_mpq;

END_C_DECLS
#endif
#if ! defined (BA0_MACROS_INTERVAL_MPQ_H)
#   define BA0_MACROS_INTERVAL_MPQ_H 1

/* #   include "ba0_common.h" */
/* #   include "ba0_interval_mpq.h" */

/* 
 * Macros for ba0_interval_mpq 
 */

typedef struct ba0_interval_mpq ba0_interval_mpq_t[1];

#   define ba0_interval_mpq_affect(rop,op)      ba0_set_interval_mpq (rop, op)
#   define ba0_interval_mpq_init(rop)           ba0_init_interval_mpq (rop)
#   define ba0_interval_mpq_set(rop,op)         ba0_set_interval_mpq (rop, op)
#   define ba0_interval_mpq_swap(rop,op)        BA0_SWAP(struct ba0_interval_mpq,rop[0],op[0])
#   define ba0_interval_mpq_set_si(rop,op)      ba0_set_interval_mpq_si (rop, op)
#   define ba0_interval_mpq_set_ui(rop,op)      ba0_set_interval_mpq_ui (rop, op)
#   define ba0_interval_mpq_init_set(rop,op)    ba0_set_interval_mpq (rop, op)

#   define ba0_interval_mpq_init_set_si(rop,op) \
       do {                                     \
         ba0_interval_mpq_init(rop);            \
         ba0_set_interval_mpq_si (rop, op);     \
       } while (0)

#   define ba0_interval_mpq_init_set_ui(rop,op) \
       do {                                     \
         ba0_interval_mpq_init(rop);            \
         ba0_set_interval_mpq_ui (rop, op);     \
       } while (0)

#   define ba0_interval_mpq_is_zero(op)         ba0_is_zero_interval_mpq (op)
#   define ba0_interval_mpq_is_one(op)          ba0_is_one_interval_mpq (op)
#   define ba0_interval_mpq_is_negative(op)     ba0_is_negative_interval_mpq (op)
#   define ba0_interval_mpq_are_equal(opa,opb)  ba0_are_equal_interval_mpq (opa, opb)
#   define ba0_interval_mpq_neg(rop,op)         ba0_neg_interval_mpq (rop, op)
#   define ba0_interval_mpq_add(rop,opa,opb)    ba0_add_interval_mpq (rop, opa, opb)
#   define ba0_interval_mpq_sub(rop,opa,opb)    ba0_sub_interval_mpq (rop, opa, opb)
#   define ba0_interval_mpq_mul(rop,opa,opb)    ba0_mul_interval_mpq (rop, opa, opb)
#   define ba0_interval_mpq_mul_ui(rop,opa,opb) ba0_mul_interval_mpq_ui (rop, opa, opb)
#   define ba0_interval_mpq_mul_si(rop,opa,opb) ba0_mul_interval_mpq_si (rop, opa, opb)
#   define ba0_interval_mpq_pow_ui(rop,opa,opb) ba0_pow_interval_mpq (rop, opa, (ba0_int_p)opb)

#endif
#if !defined (BA0_STRING_H)
#   define BA0_STRING_H 1

/* #   include "ba0_common.h" */

BEGIN_C_DECLS

struct ba0_tableof_string
{
  ba0_int_p alloc;
  ba0_int_p size;
  char **tab;
};

struct ba0_matrixof_string
{
  ba0_int_p alloc;
  ba0_int_p nrow;
  ba0_int_p ncol;
  char **entry;
};

struct ba0_listof_string
{
  char *value;
  struct ba0_listof_string *next;
};

struct ba0_tableof_tableof_string
{
  ba0_int_p alloc;
  ba0_int_p size;
  struct ba0_tableof_string **tab;
};

extern BA0_DLL char *ba0_not_a_string (
    void);

extern BA0_DLL char *ba0_new_string (
    void);

extern BA0_DLL char *ba0_strdup (
    char *);

extern BA0_DLL char *ba0_strcat (
    struct ba0_tableof_string *);

/* 
 * redefined since they are not ANSI */

extern BA0_DLL int ba0_strcasecmp (
    char *,
    char *);

extern BA0_DLL int ba0_strncasecmp (
    char *,
    char *,
    size_t);

extern BA0_DLL ba0_scanf_function ba0_scanf_string;

extern BA0_DLL ba0_printf_function ba0_printf_string;

extern BA0_DLL ba0_garbage1_function ba0_garbage1_string;

extern BA0_DLL ba0_garbage2_function ba0_garbage2_string;

extern BA0_DLL ba0_copy_function ba0_copy_string;

extern BA0_DLL void ba0_set_tableof_string (
    struct ba0_tableof_string *,
    struct ba0_tableof_string *);

extern BA0_DLL bool ba0_member2_tableof_string (
    char *,
    struct ba0_tableof_string *,
    ba0_int_p *);

extern BA0_DLL unsigned ba0_int_p ba0_sizeof_tableof_string (
    struct ba0_tableof_string *,
    enum ba0_garbage_code);

END_C_DECLS
#endif /* !BA0_STRING_H */
#if !defined (BA0_DICTIONARY_H)
#   define BA0_DICTIONARY_H 1

/* #   include "ba0_common.h" */
/* #   include "ba0_int_p.h" */
/* #   include "ba0_table.h" */

BEGIN_C_DECLS

/*
 * texinfo: ba0_dictionary
 * This data structure implements generic dictionaries which map 
 * @code{void *} pointers or @code{ba0_int_p} to other objects.
 * In this implementation, the values associated to the keys are integers, 
 * which are supposed to be indices in some table of objects of unspecified 
 * type.
 * It is implemented using the double hash strategy.
 * The entries of the field @code{area} contain either @math{-1} or 
 * the index, in some unspecified table, of some object.
 * The size of @code{area} is a power of two given by @code{log2_size}.
 *
 * For computing hash values, keys are first shifted @code{shift} bits
 * to the right. For a dictionary of integers @code{shift} should be zero.
 * For a dictionary of pointers to objects of type @var{T}, 
 * @code{shift} should be the highest exponent @math{e} such that 
 * @math{2^e} is less than or equal to the size in bytes of
 * the objects to type @var{T}.
 */

struct ba0_dictionary
{
// each entry contains either -1 or an index in some table of variables
  struct ba0_tableof_int_p area;
// the shift applied on keys before hashing them
  ba0_int_p shift;
// the base-2 logarithm of the size/alloc field of area if area is nonempty
  ba0_int_p log2_size;
// the number of used entries in area
  ba0_int_p used_entries;
};

extern BA0_DLL void ba0_init_dictionary (
    struct ba0_dictionary *,
    ba0_int_p,
    ba0_int_p);

extern BA0_DLL void ba0_reset_dictionary (
    struct ba0_dictionary *);

extern BA0_DLL unsigned ba0_int_p ba0_sizeof_dictionary (
    struct ba0_dictionary *,
    enum ba0_garbage_code);

extern BA0_DLL void ba0_set_dictionary (
    struct ba0_dictionary *,
    struct ba0_dictionary *);

extern BA0_DLL ba0_int_p ba0_get_dictionary (
    struct ba0_dictionary *,
    struct ba0_table *,
    void *);

extern BA0_DLL void ba0_add_dictionary (
    struct ba0_dictionary *,
    struct ba0_table *,
    void *,
    ba0_int_p);

END_C_DECLS
#endif /* !BA0_DICTIONARY_H */
#if !defined (BA0_DICTIONARY_STRING_H)
#   define BA0_DICTIONARY_STRING_H 1

/* #   include "ba0_common.h" */
/* #   include "ba0_int_p.h" */
/* #   include "ba0_table.h" */

BEGIN_C_DECLS

/*
 * texinfo: ba0_dictionary_string
 * This data structure implements generic dictionaries which map strings
 * to other objects. In this implementation, the values associated
 * to the keys are integers, which are supposed to be indices in some 
 * table of objects of unspecified type.
 * It is implemented using the double hash strategy.
 * The entries of the field @code{area} contain either @math{-1} or 
 * the index, in some unspecified table, of some object.
 * The size of @code{area} is a power of two given by @code{log2_size}.
 */

struct ba0_dictionary_string
{
// each entry contains either -1 or an index in some table of variables
  struct ba0_tableof_int_p area;
// the base-2 logarithm of the size/alloc field of area if area is nonempty
  ba0_int_p log2_size;
// the number of used entries in area
  ba0_int_p used_entries;
// a function which associates an identifier to an object
  char *(
      *object_to_ident) (
      void *);
};

extern BA0_DLL void ba0_init_dictionary_string (
    struct ba0_dictionary_string *,
    char *(*)(void *),
    ba0_int_p);

extern BA0_DLL void ba0_reset_dictionary_string (
    struct ba0_dictionary_string *);

extern BA0_DLL unsigned ba0_int_p ba0_sizeof_dictionary_string (
    struct ba0_dictionary_string *,
    enum ba0_garbage_code);

extern BA0_DLL void ba0_set_dictionary_string (
    struct ba0_dictionary_string *,
    struct ba0_dictionary_string *);

extern BA0_DLL ba0_int_p ba0_get_dictionary_string (
    struct ba0_dictionary_string *,
    struct ba0_table *,
    char *);

extern BA0_DLL void ba0_add_dictionary_string (
    struct ba0_dictionary_string *,
    struct ba0_table *,
    char *,
    ba0_int_p);

END_C_DECLS
#endif /* !BA0_DICTIONARY_STRING_H */
#if !defined (BA0_DICTIONARY_TYPED_STRING_H)
#   define BA0_DICTIONARY_TYPED_STRING_H 1

/* #   include "ba0_common.h" */
/* #   include "ba0_int_p.h" */
/* #   include "ba0_table.h" */

BEGIN_C_DECLS

/*
 * texinfo: ba0_dictionary_typed_string
 * Variant of the data structure @code{ba0_dictionary_string} where
 * keys are couples formed by a string and a type rather than simply
 * a string.
 */

struct ba0_dictionary_typed_string
{
// each entry contains either -1 or an index in some table of variables
  struct ba0_tableof_int_p area;
// the base-2 logarithm of the size/alloc field of area if area is nonempty
  ba0_int_p log2_size;
// the number of used entries in area
  ba0_int_p used_entries;
// a function which associates an identifier to an object
  char *(
      *object_to_ident) (
      void *);
// a function which associates a type to an object
    ba0_int_p (
      *object_to_type) (
      void *);
};

extern BA0_DLL void ba0_init_dictionary_typed_string (
    struct ba0_dictionary_typed_string *,
    char *(*)(void *),
    ba0_int_p (*)(void *),
    ba0_int_p);

extern BA0_DLL void ba0_reset_dictionary_typed_string (
    struct ba0_dictionary_typed_string *);

extern BA0_DLL unsigned ba0_int_p ba0_sizeof_dictionary_typed_string (
    struct ba0_dictionary_typed_string *,
    enum ba0_garbage_code);

extern BA0_DLL void ba0_set_dictionary_typed_string (
    struct ba0_dictionary_typed_string *,
    struct ba0_dictionary_typed_string *);

extern BA0_DLL ba0_int_p ba0_get_dictionary_typed_string (
    struct ba0_dictionary_typed_string *,
    struct ba0_table *,
    char *,
    ba0_int_p);

extern BA0_DLL void ba0_add_dictionary_typed_string (
    struct ba0_dictionary_typed_string *,
    struct ba0_table *,
    char *,
    ba0_int_p,
    ba0_int_p);

END_C_DECLS
#endif /* !BA0_DICTIONARY_TYPED_STRING_H */
#if !defined (BA0_BASIC_IO_H)
#   define BA0_BASIC_IO_H 1

/* #   include "ba0_common.h" */

BEGIN_C_DECLS

/*
 * texinfo: ba0_typeof_device
 * This data type permits to specify the device from/to which
 * the input is read of the output is written.
 */

enum ba0_typeof_device
{
  ba0_string_device,
  ba0_file_device,
  ba0_counter_device
};

/*
 * texinfo: ba0_output_device
 * This data type the device to which output is written.
 */

struct ba0_output_device
{
  enum ba0_typeof_device vers;
// if vers is equal to ba0_file_device
  FILE *file_flux;
// if vers is equal to ba0_string_device
  char *string_flux;
// index in string_flux
  ba0_int_p indice;
// if vers is equal to ba0_counter_device (number of output characters)
  ba0_int_p counter;
};

#   define BA0_DEFAULT_OUTPUT_LINE_LENGTH	80
#   define ba0_output_line_length ba0_global.basic_io.output_line_length

extern BA0_DLL void ba0_set_output_FILE (
    FILE *);

extern BA0_DLL void ba0_set_output_string (
    char *);

extern BA0_DLL void ba0_set_output_counter (
    void);

#   define BA0_BASIC_IO_SIZE_STACK 10

extern BA0_DLL void ba0_record_output (
    void);

extern BA0_DLL void ba0_restore_output (
    void);

extern BA0_DLL void ba0_reset_output (
    void);

extern BA0_DLL void ba0_put_char (
    char);

extern BA0_DLL void ba0_put_int_p (
    ba0_int_p);

extern BA0_DLL void ba0_put_hexint_p (
    ba0_int_p);

extern BA0_DLL ba0_printf_function ba0_put_string;

extern BA0_DLL ba0_int_p ba0_output_counter (
    void);

/*
 * texinfo: ba0_input_device
 * This data type the device from which input is read.
 */

struct ba0_input_device
{
  enum ba0_typeof_device from;
// if from == ba0_file_device
  FILE *file_flux;
// if from == ba0_string_device
  char *string_flux;
  ba0_int_p indice;
};

extern BA0_DLL void ba0_set_input_FILE (
    FILE *);

extern BA0_DLL void ba0_set_input_string (
    char *);

extern BA0_DLL bool ba0_isatty_input (
    void);

extern BA0_DLL void ba0_reset_input (
    void);

extern BA0_DLL void ba0_record_input (
    void);

extern BA0_DLL void ba0_restore_input (
    void);

extern BA0_DLL int ba0_get_char (
    void);

extern BA0_DLL void ba0_unget_char (
    int);

END_C_DECLS
#endif /* !BA0_BASIC_IO_H */
#if !defined (BA0_ANALEX_H)
#   define BA0_ANALEX_H 1

/* 
 * Lexical analyzer.
 */

/* #   include "ba0_common.h" */
/* #   include "ba0_string.h" */
/* #   include "ba0_dictionary_string.h" */

BEGIN_C_DECLS

/*
 * texinfo: ba0_typeof_token
 * This data type permits to assign a type to a token.
 */

enum ba0_typeof_token
{
// Special value
  ba0_no_token,
// The token is an integer starting with a digit (unsigned)
  ba0_integer_token,
// The token is a sign. Signs are single characters
  ba0_sign_token,
// The token is a string. 
// Any sequence of characters delimited by quotes is a string
  ba0_string_token
};

/* 
 * texinfo: ba0_token
 * This data type permits to store one token.
 */

struct ba0_token
{
// The type of the token
  enum ba0_typeof_token type;
// At least one space was present before the first token character
  bool spaces_before;
// The value of the token, stored in the analex stack.
  char *value;
};

/* 
 * texinfo: ba0_analex_token_fifo
 * This data type describes a FIFO of tokens implemented as a
 * circular array.
 * The only variables of this type are fields of @code{ba0_global}.
 */

struct ba0_analex_token_fifo
{
// The array of token containing the FIFO.
// Its length is stored in ba0_initialized_global.analex.nb_tokens
  struct ba0_token *fifo;
// The index of the first token in the FIFO i.e the current token
  ba0_int_p first;
// The index of the last token present in the FIFO
// It is usually equal to first unless a token has been "ungot"
  ba0_int_p last;
// The number of calls to ba0_get_token_analex since the last reset
  ba0_int_p counter;
};

/* 
 * The default max length of the FIFO
 * The characters that can be used for quoting
 */

#   define BA0_NBTOKENS    20
#   define BA0_QUOTES      "'\""

/* 
 * The length of the error context string (see ba0_global)
 */

#   define BA0_CONTEXT_LMAX 60

/*
 * The size of the substitution dictionary stack (see ba0_global)
 */

#   define BA0_SIZE_SUBS_DICT_STACK 4

extern BA0_DLL void ba0_set_settings_analex (
    ba0_int_p,
    char *);

extern BA0_DLL void ba0_get_settings_analex (
    ba0_int_p *,
    char **);

extern BA0_DLL char *ba0_get_context_analex (
    void);

extern BA0_DLL void ba0_write_context_analex (
    void);

extern BA0_DLL void ba0_init_analex (
    void);

extern BA0_DLL void ba0_clear_analex (
    void);

extern BA0_DLL void ba0_reset_analex (
    void);

extern BA0_DLL void ba0_record_analex (
    void);

extern BA0_DLL void ba0_restore_analex (
    void);

extern BA0_DLL void ba0_reset_subs_dict_analex (
    void);

extern BA0_DLL void ba0_push_subs_dict_analex (
    struct ba0_dictionary_string *,
    struct ba0_tableof_string *,
    struct ba0_tableof_string *);

extern BA0_DLL void ba0_pull_subs_dict_analex (
    void);

extern BA0_DLL void ba0_set_analex_FILE (
    FILE *);

extern BA0_DLL void ba0_set_analex_string (
    char *);

extern BA0_DLL ba0_int_p ba0_get_counter_analex (
    void);

extern BA0_DLL void ba0_get_token_analex (
    void);

extern BA0_DLL void ba0_unget_token_analex (
    ba0_int_p);

extern BA0_DLL void ba0_unget_given_token_analex (
    char *,
    enum ba0_typeof_token,
    bool);

extern BA0_DLL bool ba0_sign_token_analex (
    char *);

extern BA0_DLL bool ba0_spaces_before_token_analex (
    void);

extern BA0_DLL enum ba0_typeof_token ba0_type_token_analex (
    void);

extern BA0_DLL char *ba0_value_token_analex (
    void);

END_C_DECLS
#endif /* !BA0_ANALEX_H */
#if !defined (BA0_FORMAT_H)
#   define BA0_FORMAT_H 1

/* #   include "ba0_common.h" */

BEGIN_C_DECLS

/* 
 * The size of the H-Table for formats.
 * Should be a prime number.
 */

#   define BA0_SIZE_HTABLE_FORMAT      8009

/*
 * texinfo: ba0_typeof_format
 * This data type is a subtype of @code{ba0_subformat}.
 */

enum ba0_typeof_format
{
  ba0_leaf_format,
  ba0_table_format,
  ba0_list_format,
  ba0_matrix_format,
  ba0_array_format,
  ba0_value_format,
  ba0_point_format
};

struct ba0_format;

/*
 * texinfo: ba0_subformat
 * This data type is a subtype of @code{ba0_format}.
 * An element of this type describes a @code{%something}
 * substring of a format. Such substrings may have parameters.
 * Examples are: @code{%t[%v]} (tables of variables), 
 * @code{%l[%t[%z]]} (lists of tables of big integers).
 */

struct ba0_subformat
{
// The type of the subformat
  enum ba0_typeof_format code;
  union
  {
// If type is different from ba0_leaf_format
    struct _node
    {
// The format
      struct ba0_format *op;
// The opening parenthesis of the subformat parameter
      char po;
// The closing parenthesis
      char pf;
    } node;
// If type is ba0_leaf_format
    struct _leaf
    {
// The size of one data structure associated to the type
// and pointers towards associated functions
      ba0_int_p sizelt;
      ba0_scanf_function *scanf;
      ba0_printf_function *printf;
      ba0_garbage1_function *garbage1;
      ba0_garbage2_function *garbage2;
      ba0_copy_function *copy;
    } leaf;
  } u;
};


/*
 * texinfo: ba0_format
 * This data type describes a format, which is a string that can
 * be passed to functions such as @code{ba0_scanf}, @code{ba0_printf},
 * @code{ba0_copy} or @code{ba0_garbage}. Examples are:
 * @code{"poly = %Az\n"} or @code{"%t[%v], %qi"}.
 *
 * The subformats @code{%something} which occur in such strings
 * are preprocessed. 
 *
 * Each format is stored in a hash table of
 * formats, stored in the format stack whenever it is encountered.
 * Note that the addresses of the strings are hashed, not the
 * strings themselves.
 */

struct ba0_format
{
// the string
  char *text;
// an array of pointers towards the subformats of the string
  struct ba0_subformat **link;
// the number of subformats and the size of link
  ba0_int_p linknmb;
};


extern BA0_DLL void ba0_initialize_format (
    void);

extern BA0_DLL void ba0_define_format (
    char *,
    ba0_scanf_function *,
    ba0_printf_function *,
    ba0_garbage1_function *,
    ba0_garbage2_function *,
    ba0_copy_function *);

extern BA0_DLL void ba0_define_format_with_sizelt (
    char *,
    ba0_int_p,
    ba0_scanf_function *,
    ba0_printf_function *,
    ba0_garbage1_function *,
    ba0_garbage2_function *,
    ba0_copy_function *);

extern BA0_DLL struct ba0_format *ba0_get_format (
    char *);

extern BA0_DLL ba0_garbage1_function ba0_empty_garbage1;

extern BA0_DLL ba0_garbage2_function ba0_empty_garbage2;

struct ba0_pair
{
  char *identificateur;
  void *value;
};

struct ba0_tableof_pair
{
  ba0_int_p alloc;
  ba0_int_p size;
  struct ba0_pair **tab;
};

END_C_DECLS
#endif /* !BA0_FORMAT_H */
#if !defined (BA0_GARBAGE_H)
#   define BA0_GARBAGE_H 1

/* #   include "ba0_common.h" */
/* #   include "ba0_stack.h" */
/* #   include "ba0_list.h" */
/* #   include "ba0_table.h" */
/* #   include "ba0_format.h" */

/* Garbage collector of J.-C. Faugere */

BEGIN_C_DECLS

/*
 * texinfo: ba0_gc_info
 * Structures of this data type are created by @code{ba0_garbage1_function}
 * and read by @code{ba0_garbage2_function} functions. They permit to
 * move data structures involving pointers.
 */

struct ba0_gc_info
{
// the index of the stack cell which contains the garbaged data structure
  ba0_int_p old_index_in_cells;
// the old address of the data structure
  void *old_addr;
  union
  {
// the size in bytes of the data structure (set at garbage1 pass)
    unsigned ba0_int_p size;
// the new address of the data structure (set at garbage2 pass)
    void *new_addr;
  } u;
// a readonly string describing the structure for debugging purposes
  char *text;
};


extern BA0_DLL void ba0_garbage (
    char *,
    struct ba0_mark *,
    ...);

extern BA0_DLL ba0_int_p ba0_garbage1 (
    char *,
    void *,
    enum ba0_garbage_code);

extern BA0_DLL void *ba0_garbage2 (
    char *,
    void *,
    enum ba0_garbage_code);

extern BA0_DLL ba0_int_p ba0_new_gc_info (
    void *,
    unsigned ba0_int_p,
    char *);

extern BA0_DLL void *ba0_new_addr_gc_info (
    void *,
    char *);

END_C_DECLS
#endif /* !BA0_GARBAGE_H */
#if !defined (BA0_COPY_H)
#   define BA0_COPY_H 1

/* #   include "ba0_common.h" */

BEGIN_C_DECLS

extern BA0_DLL void *ba0_copy (
    char *,
    void *);

END_C_DECLS
#endif /* !BA0_COPY_H */
#if !defined (BA0_SCANF_H)
#   define BA0_SCANF_H 1

/* #   include "ba0_common.h" */
/* #   include "ba0_format.h" */

BEGIN_C_DECLS

extern BA0_DLL void ba0__scanf__ (
    struct ba0_format *,
    void **,
    bool);

extern BA0_DLL void ba0_scanf (
    char *,
    ...);

extern BA0_DLL void ba0_scanf2 (
    char *,
    ...);

extern BA0_DLL void ba0_sscanf (
    char *,
    char *,
    ...);

extern BA0_DLL void ba0_sscanf2 (
    char *,
    char *,
    ...);

extern BA0_DLL void ba0_fscanf (
    FILE *,
    char *,
    ...);

extern BA0_DLL void ba0_fscanf2 (
    FILE *,
    char *,
    ...);

END_C_DECLS
#endif /* !BA0_SCANF_H */
#if !defined (BA0_PRINTF_H)
#   define BA0_PRINTF_H 1

/* #   include "ba0_common.h" */
/* #   include "ba0_format.h" */

BEGIN_C_DECLS

extern BA0_DLL void ba0__printf__ (
    struct ba0_format *,
    void **);

extern BA0_DLL void ba0_printf (
    char *,
    ...);

extern BA0_DLL void ba0_sprintf (
    char *,
    char *,
    ...);

extern BA0_DLL void ba0_fprintf (
    FILE *,
    char *,
    ...);

extern BA0_DLL char *ba0_new_printf (
    char *,
    ...);

END_C_DECLS
#endif /* !BA0_PRINTF_H */
#if !defined (BA0_SCANF_PRINTF_H)
#   define BA0_SCANF_PRINTF_H 1

/* #   include "ba0_common.h" */

BEGIN_C_DECLS

extern BA0_DLL void ba0_scanf_printf (
    char *,
    char *,
    ...);

END_C_DECLS
#endif /* !BA0_SCANF_PRINTF_H */
#if !defined (BA0_SMALL_P_H)
#   define BA0_SMALL_P_H 1

/* #   include "ba0_common.h" */

BEGIN_C_DECLS

extern BA0_DLL ba0_mint_hp ba0_largest_small_prime (
    void);

extern BA0_DLL ba0_mint_hp ba0_smallest_small_prime (
    void);

extern BA0_DLL ba0_mint_hp ba0_next_small_prime (
    ba0_mint_hp);

extern BA0_DLL ba0_mint_hp ba0_previous_small_prime (
    ba0_mint_hp);

END_C_DECLS
#endif /* !BA0_SMALL_P_H */
#if ! defined (BA0_MINT_HP_H)
#   define BA0_MINT_HP_H 1

/* #   include "ba0_common.h" */
/* #   include "ba0_gmp.h" */
/* #   include "ba0_macros_mint_hp.h" */
/* #   include "ba0_macros_mpq.h" */

BEGIN_C_DECLS

struct ba0_tableof_mint_hp
{
  ba0_int_p alloc;
  ba0_int_p size;
  ba0_int_p **tab;              /* not ba0_mint_hp ! */
};


struct ba0_listof_mint_hp
{
  ba0_int_p value;              /* not ba0_mint_hp ! */
  struct ba0_listof_mint_hp *next;
};


#   define ba0_mint_hp_module		ba0_global.mint_hp.module
#   define ba0_mint_hp_module_is_prime	ba0_global.mint_hp.module_is_prime

extern BA0_DLL void ba0_reset_mint_hp_module (
    void);

extern BA0_DLL bool ba0_domain_mint_hp (
    void);

extern BA0_DLL void ba0_mint_hp_module_set (
    ba0_mint_hp,
    bool);

extern BA0_DLL ba0_mint_hp ba0_pow_mint_hp (
    ba0_mint_hp,
    ba0_int_p);

extern BA0_DLL ba0_scanf_function ba0_scanf_mint_hp;

extern BA0_DLL ba0_printf_function ba0_printf_mint_hp;

extern BA0_DLL ba0_mint_hp ba0_invert_mint_hp (
    ba0_mint_hp);

extern BA0_DLL enum ba0_wang_code ba0_wang_mint_hp (
    ba0_mpq_t,
    ba0_mint_hp,
    ba0_int_hp *);

END_C_DECLS
#endif /* !BA0_MINT_HP_H */
#if !defined (BA0_MPZM_H)
#   define BA0_MPZM_H 1

/* #   include "ba0_common.h" */
/* #   include "ba0_macros_mpzm.h" */

BEGIN_C_DECLS

struct ba0_tableof_mpzm
{
  ba0_int_p alloc;
  ba0_int_p size;
  ba0__mpz_struct **tab;
};


struct ba0_listof_mpzm
{
  ba0__mpz_struct *value;
  struct ba0_listof_mpzm *next;
};


#   define ba0_mpzm_module_is_prime        ba0_global.mpzm.module_is_prime
#   define ba0_mpzm_module			ba0_global.mpzm.module
#   define ba0_mpzm_half_module		ba0_global.mpzm.half_module
#   define ba0_mpzm_accum			ba0_global.mpzm.accum

extern BA0_DLL void ba0_init_mpzm_module (
    void);

extern BA0_DLL void ba0_reset_mpzm_module (
    void);

extern BA0_DLL bool ba0_domain_mpzm (
    void);

extern BA0_DLL void ba0_mpzm_module_set_ui (
    unsigned ba0_int_p,
    bool);

extern BA0_DLL void ba0_mpzm_module_set (
    ba0_mpz_t,
    bool);

extern BA0_DLL void ba0_mpzm_module_mul (
    ba0_mpz_t);

extern BA0_DLL void ba0_mpzm_module_pow_ui (
    ba0_mpz_t,
    unsigned ba0_int_p,
    bool);

extern BA0_DLL ba0__mpz_struct *ba0_new_mpzm (
    void);

extern BA0_DLL ba0_scanf_function ba0_scanf_mpzm;

extern BA0_DLL ba0_printf_function ba0_printf_mpzm;

extern BA0_DLL ba0_garbage1_function ba0_garbage1_mpzm;

extern BA0_DLL ba0_garbage2_function ba0_garbage2_mpzm;

extern BA0_DLL ba0_copy_function ba0_copy_mpzm;

extern BA0_DLL enum ba0_wang_code ba0_wang_mpzm (
    ba0_mpq_t,
    ba0_mpz_t,
    ba0_mpz_t);

END_C_DECLS
#endif /* !BA0_MPZM_H */
#if !defined (BA0_INDEXED_STRING_H)
#   define BA0_INDEXED_STRING_H 1

/* #   include "ba0_common.h" */

/*
 * blad_indent: -l120
 */

BEGIN_C_DECLS

struct ba0_indexed_string;

struct ba0_indexed_string_indices;

struct ba0_tableof_indexed_string
{
  ba0_int_p alloc;
  ba0_int_p size;
  struct ba0_indexed_string **tab;
};

struct ba0_tableof_indexed_string_indices
{
  ba0_int_p alloc;
  ba0_int_p size;
  struct ba0_indexed_string_indices **tab;
};


/*
 * texinfo: ba0_indexed_string_indices
 * This data type is a subtype of @code{struct ba0_indexed_string}.
 * It permits to store @dfn{indexed string indices}.
 */

struct ba0_indexed_string_indices
{
// the opening and closing parenthesis
  char po, pf;
  struct ba0_tableof_indexed_string Tindex;
};


/*
 * texinfo: ba0_indexed_string
 * This data type permits to represent @dfn{indexed strings}
 * which are strings endowed with indexed string indices.
 * It is used for parsing symbols and variables.
 * Here are a few examples of indexed strings accepted by parsers:
 * @code{u}, @code{u[1]}, @code{u[[1],-4,[[3]]]}, @code{u[x[e]]}.
 * @verbatim
 * INDEXED ::= string INDICES ... INDICES              (*)
 *         ::= signed integer INDICES ... INDICES
 *         ::= INDICES ... INDICES
 *
 * INDICES ::= (INDEXED, ..., INDEXED)
 *         ::= [INDEXED, ..., INDEXED]
 *
 * (*) At top level, this form is the only one accepted.
 * @end verbatim
 */

struct ba0_indexed_string
{
// the string or the signed integer as a string or (char *)0
  char *string;
// the table of the indexed string indices
  struct ba0_tableof_indexed_string_indices Tindic;
};


typedef void ba0_indexed_string_function (
    struct ba0_indexed_string *);

extern BA0_DLL void ba0_init_indexed_string (
    struct ba0_indexed_string *);

extern BA0_DLL void ba0_reset_indexed_string (
    struct ba0_indexed_string *);

extern BA0_DLL struct ba0_indexed_string *ba0_new_indexed_string (
    void);

extern BA0_DLL void ba0_set_indexed_string (
    struct ba0_indexed_string *,
    struct ba0_indexed_string *);

extern BA0_DLL char *ba0_indexed_string_to_string (
    struct ba0_indexed_string *);

extern BA0_DLL char *ba0_stripped_indexed_string_to_string (
    struct ba0_indexed_string *);

extern BA0_DLL bool ba0_has_empty_trailing_indices_indexed_string (
    struct ba0_indexed_string *,
    char);

extern BA0_DLL bool ba0_has_trailing_indices_indexed_string (
    struct ba0_indexed_string *,
    bool (*)(char *));

extern BA0_DLL bool ba0_has_numeric_trailing_indices_indexed_string (
    struct ba0_indexed_string *,
    struct ba0_tableof_int_p *);

extern BA0_DLL ba0_garbage1_function ba0_garbage1_indexed_string;

extern BA0_DLL ba0_garbage2_function ba0_garbage2_indexed_string;

extern BA0_DLL ba0_copy_function ba0_copy_indexed_string;

extern BA0_DLL ba0_printf_function ba0_printf_indexed_string;

/* 
 * The first one returns the struct ba0_indexed_string* data structure
 * The second one converts the data structure into a string
 */

extern BA0_DLL ba0_scanf_function ba0_scanf_indexed_string;

extern BA0_DLL ba0_scanf_function ba0_scanf_indexed_string_as_a_string;

extern BA0_DLL struct ba0_indexed_string *ba0_scanf_indexed_string_with_counter (
    struct ba0_indexed_string *,
    ba0_int_p *);

END_C_DECLS
#endif /* !BA0_INDEXED_STRING_H */
#if !defined (BA0_RANGE_INDEXED_GROUP)
#   define BA0_RANGE_INDEXED_GROUP 1

/* #   include "ba0_common.h" */
/* #   include "ba0_double.h" */
/* #   include "ba0_string.h" */

BEGIN_C_DECLS

/*
 * texinfo: ba0_range_indexed_group
 * This data structure permits to describe a group of 
 * @dfn{range indexed strings}, which are strings indexed by integer numbers 
 * running over ranges. These strings (without their indices) are called
 * the @dfn{radicals} of the range indexed strings.
 * The arrays @code{lhs} and @code{rhs} have the same size, which
 * give the number of @dfn{range indices}.
 * Though stored in doubles, the left-hand and right-hand sides
 * of the ranges are either signed integers or @code{inf} or @code{-inf}.
 * The left-hand side of a range may be greater than, equal to or
 * lower than the right-hand side.
 * Here are a few examples: 
 * @verbatim
 * 1. y
 * 2. (x)[17:-3]
 * 3. (y,z)[0:inf,inf:-1]
 * @end verbatim
 * The radicals of the range indexed strings are @code{y}, @code{x}, 
 * @code{y} and @code{z}.
 * In Example 1, the range indexed group involves a single
 * range indexed string which has no range indices.
 * The range indexed group is said to describe a @dfn{plain string}.
 * In Example 2, the range indexed group involves a single
 * range indexed string which has a single range index.
 * In Example 3, the range indexed group involves two
 * range indexed strings; each of them admits two range indices.
 *
 * The aim of this data structure is to describe possibly infinite
 * ordered sets of variables. 
 * The range indexed group of Example 2
 * describes the ordered set: @code{x[17] > x[16] > ... > x[-2]} 
 * (the least index of the range is assumed to be excluded, as in Python,
 *  but this behaviour can be customized).
 * The variable @code{x[16]} is said to @dfn{fit} the range indexed string
 * @code{(x)[17:-3]}. The variables @code{x[18]} or @code{z[0]} do not.
 * In Example 3, the set of variables which fit the range indexed group is 
 * made of @code{y} and @code{z}, indexed by two nonnegative integers.
 */

struct ba0_range_indexed_group
{
// The left-hand sides of the ranges
  struct ba0_arrayof_double lhs;
// The right-hand sides of the ranges
  struct ba0_arrayof_double rhs;
// The table of the radicals of the range indexed strings
  struct ba0_tableof_string strs;
};

#   define BA0_NOT_A_RANGE_INDEXED_GROUP (struct ba0_range_indexed_group *)0

struct ba0_tableof_range_indexed_group
{
  ba0_int_p alloc;
  ba0_int_p size;
  struct ba0_range_indexed_group **tab;
};

/*
 * Default values for entries in ba0_initialized_global
 */

#   define BA0_RANGE_INDEXED_GROUP_OPER ":"
#   define BA0_RANGE_INDEXED_GROUP_INFINITY "inf"

struct ba0_dictionary_string;

extern BA0_DLL void ba0_set_settings_range_indexed_group (
    char *,
    char *,
    bool,
    bool);

extern BA0_DLL void ba0_get_settings_range_indexed_group (
    char **,
    char **,
    bool *,
    bool *);

extern BA0_DLL unsigned ba0_int_p ba0_sizeof_range_indexed_group (
    struct ba0_range_indexed_group *,
    enum ba0_garbage_code,
    bool);

extern BA0_DLL unsigned ba0_int_p ba0_sizeof_tableof_range_indexed_group (
    struct ba0_tableof_range_indexed_group *,
    enum ba0_garbage_code,
    bool);

extern BA0_DLL void ba0_set_tableof_string_tableof_range_indexed_group (
    struct ba0_tableof_string *,
    struct ba0_tableof_range_indexed_group *);

extern BA0_DLL void ba0_set_range_indexed_group_with_tableof_string (
    struct ba0_range_indexed_group *,
    struct ba0_range_indexed_group *,
    struct ba0_dictionary_string *,
    struct ba0_tableof_string *);

extern BA0_DLL void ba0_set_tableof_range_indexed_group_with_tableof_string (
    struct ba0_tableof_range_indexed_group *,
    struct ba0_tableof_range_indexed_group *,
    struct ba0_dictionary_string *,
    struct ba0_tableof_string *);

extern BA0_DLL void ba0_init_range_indexed_group (
    struct ba0_range_indexed_group *);

extern BA0_DLL void ba0_reset_range_indexed_group (
    struct ba0_range_indexed_group *);

extern BA0_DLL struct ba0_range_indexed_group *ba0_new_range_indexed_group (
    void);

extern BA0_DLL void ba0_set_range_indexed_group (
    struct ba0_range_indexed_group *,
    struct ba0_range_indexed_group *);

extern BA0_DLL void ba0_set_range_indexed_group_string (
    struct ba0_range_indexed_group *,
    char *);

extern BA0_DLL bool ba0_is_plain_string_range_indexed_group (
    struct ba0_range_indexed_group *,
    char **);

extern BA0_DLL bool ba0_compatible_indices_range_indexed_group (
    struct ba0_range_indexed_group *,
    struct ba0_range_indexed_group *);

extern BA0_DLL bool ba0_fit_range_indexed_group (
    struct ba0_range_indexed_group *,
    char *,
    struct ba0_tableof_int_p *,
    ba0_int_p *);

extern BA0_DLL bool ba0_fit_indices_range_indexed_group (
    struct ba0_range_indexed_group *,
    struct ba0_tableof_int_p *);

extern BA0_DLL ba0_garbage1_function ba0_garbage1_range_indexed_group;

extern BA0_DLL ba0_garbage2_function ba0_garbage2_range_indexed_group;

extern BA0_DLL ba0_copy_function ba0_copy_range_indexed_group;

extern BA0_DLL ba0_scanf_function ba0_scanf_range_indexed_group;

extern BA0_DLL ba0_printf_function ba0_printf_range_indexed_group;

END_C_DECLS
#endif /* !BA0_RANGE_INDEXED_GROUP */
#if ! defined (BA0_GLOBAL_H)
#   define BA0_GLOBAL_H 1

/* #   include "ba0_common.h" */
/* #   include "ba0_exception.h" */
/* #   include "ba0_garbage.h" */
/* #   include "ba0_stack.h" */
/* #   include "ba0_format.h" */
/* #   include "ba0_basic_io.h" */
/* #   include "ba0_analex.h" */
/* #   include "ba0_gmp.h" */
/* #   include "ba0_point.h" */
/* #   include "ba0_range_indexed_group.h" */
/* #   include "ba0_dictionary_string.h" */

BEGIN_C_DECLS

/* 
 * texinfo: ba0_global
 * This data type is used for a single global variable.
 * Each field aims at customizing the behaviour of the @code{ba0} library.
 */

struct ba0_global
{
  struct
  {
/* 
 * Deprecated control for printing in LaTeX.
 * Used in ba0, bav and bap.
 */
    bool LaTeX;
/* 
 * Time out + Memory out + Interrupt checking
 *
 * time_limit           = the absolute value of the input time limit (restart)
 * memory_limit         = the input memory limit (restart)
 * switch_on_interrupt  = *check_interrupt should be called
 * within_interrupt     = bool to avoid self interruption
 * delay_interrupt      = the length of a time interval between two calls
 * before_timeout       = the overall remaining time before timeout
 * previous_time        = the value of time() when interrupt was last called
 */
    ba0_int_p time_limit;       /* local to ba0_common */
    ba0_int_p memory_limit;     /* local to ba0_common and ba0_stack */
    bool switch_on_interrupt;   /* local to ba0_common */
    bool within_interrupt;      /* local to ba0_common */
    time_t before_timeout;      /* local to ba0_common */
    time_t previous_time;       /* local to ba0_common */
  } common;
  struct
  {
/* 
 * The error/exception message.
 * Only set when raising an exception. Read everywhere.
 */
    char *raised;
    char mesg_cerr[BA0_BUFSIZE];
/* 
 * The stack of exception catching points.
 * Only set by the exception setting/raising MACROS.
 */
    struct
    {
      struct ba0_exception tab[BA0_SIZE_EXCEPTION_STACK];
      ba0_int_p size;
    } stack;
/* 
 * The stack of extra variables to be saved/restored when setting
 *      an exception point/raising an exception.
 * The field pointer points to the extra variable to be restored.
 * If the field restore is nonzero then it points to a function which is
 *      called in order to restore the extra variable with the value passed
 *      as a parameter.
 * The saved value is stored in a local variable at the catching point.
 */
    struct
    {
      struct
      {
        ba0_int_p *pointer;
        void (
            *restore) (
            ba0_int_p);
      } tab[BA0_SIZE_EXCEPTION_EXTRA_STACK];
      ba0_int_p size;
    } extra_stack;
/* 
 * bool to avoid self interruption
 */
    bool within_push_exception;
/*
 * A log fifo for debugging purposes
 * The entries of tab provide the sequence of file/line/exception raised
 *      since the last exception catching point was set.
 * The field qp contains the first free entry in tab
 */
    struct
    {
      struct
      {
        char *file;
        int line;
        char *raised;
      } tab[BA0_SIZE_EXCEPTION_LOG];
      ba0_int_p qp;
    } log;
  } exception;
  struct
  {
/* 
 * The garbage collector
 * tab                = an array for old->new addresses of areas
 * user_provided_mark = the mark M provided by garbage (format, M, ...)
 * ba0_current        = a running mark on struct ba0_gc_info(s)
 * old_free           = the value of the free pointer when garbage is called.
 *
 * All local to ba0_garbage. 
 * The values kept between two calls to ba0_garbage are meaningless.
 */
    struct ba0_gc_info **tab;
    struct ba0_mark user_provided_mark;
    struct ba0_mark current;
    struct ba0_mark old_free;
  } garbage;
  struct
  {
/* 
 * The predefined stacks. Used everywhere.
 */
    struct ba0_stack main;
    struct ba0_stack second;
    struct ba0_stack analex;
    struct ba0_stack quiet;
    struct ba0_stack format;
/* 
 * The current stack is the one on the top of stack_of_stacks.
 */
    struct ba0_tableof_stack stack_of_stacks;
/* 
 * For stats and debugging purposes.
 * Local to ba0_common, ba0_stack and ba0_analex.
 */
    ba0_int_p alloc_counter;
    ba0_int_p malloc_counter;
    ba0_int_p malloc_nbcalls;
  } stack;
  struct
  {
/* 
 * leaf_subformat = The formats defined by the library, such as %s, %d ...
 *                  Non-leaf formats are %t (tables) or %l (lists), .
 * htable         = The H-table of all the encountered formats.
 *                  Its size is a prime number. 
 * nbelem_htable  = The number of its elements.
 *
 * All are local to ba0_format.
 */
    struct ba0_tableof_pair leaf_subformat;
    struct ba0_tableof_pair htable;
    ba0_int_p nbelem_htable;
/* 
 * Management of the variables (scanf, printf) for the %value format.
 * Eventually, these pointers will point to bav_scanf_variable and
 * bav_printf_variable ... whenever these functions are defined (in bav).
 * Meanwhile, calling them raises BA0_ERRNYP
 */
    ba0_scanf_function *scanf_value_var;
    ba0_printf_function *printf_value_var;
  } format;
  struct
  {
/* 
 * output, input      = descriptions of the device in use.
 * output_line_length = to insert carriage returns. 
 *                      Reset by ba0_restart. Can be modified at runtime.
 *
 * All variables (except output_line_length) are local to ba0_basic_io.
 */
    struct ba0_output_device output_stack[BA0_BASIC_IO_SIZE_STACK];
    ba0_int_p output_sp;
    struct ba0_output_device output;
    ba0_int_p output_line_length;

    struct ba0_input_device input_stack[BA0_BASIC_IO_SIZE_STACK];
    ba0_int_p input_sp;
    struct ba0_input_device input;
  } basic_io;
  struct
  {
/* 
 * analex           = the FIFO of tokens
 * analex_save      = permits to record/restore analex (up to some point)
 * analex_save_full = indicates if analex_save is used
 * context          = an elaborated error message for parser errors
 *
 * subs_dict        = a pointer to a dictionary for performing token substitutions
 * subs_keys        = a pointer to the table which contains the dictionary keys
 * subs_vals        = a pointer to the table which contains the dictionary values
 */
    bool analex_save_full;
    struct ba0_analex_token_fifo analex;
    struct ba0_analex_token_fifo analex_save;

    char context[BA0_CONTEXT_LMAX];

    struct ba0_dictionary_string *subs_dict;
    struct ba0_tableof_string *subs_keys;
    struct ba0_tableof_string *subs_vals;
  } analex;
  struct
  {
/* 
 * These variables receive the values of the GMP memory functions before 
 * they get modified by BLAD.
 *
 * Set by ba0_restart. Read by ba0_terminate.
 * Set by ba0_process_check_interrupt before calling *check_interrupt
 * and restored afterwards.
 */
    bool alloc_function_called;
    void *(
        *alloc_function) (
        size_t);
    void *(
        *realloc_function) (
        void *,
        size_t,
        size_t);
    void (
        *free_function) (
        void *,
        size_t);
  } gmp;
  struct
  {
/* 
 * For computing in Z / module Z. Read everywhere.
 */
    bool module_is_prime;
    unsigned ba0_int_hp module;
  } mint_hp;
  struct
  {
/* 
 * For computing in Z / module Z with a GMP module. Read everywhere.
 */
    bool module_is_prime;
    ba0_mpz_t module;
    ba0_mpz_t half_module;
    ba0_mpz_t accum;
  } mpzm;
};

/*
 * texinfo: ba0_initialized_global
 * This data type is used by a single global variable.
 * It is decomposed into fields.
 * The values it contains permit to tune the library behaviour.
 */

struct ba0_initialized_global
{
  struct
  {
/* 
 * The only settings variable which is modified by ba0_restart/ba0_terminate.
 * Set by ba0_terminate. Read by all ba__restart functions.
 */
    enum ba0_restart_level restart_level;
/* 
 * check_interrupt = the pointer to the external check interrupt function,
 *                   called by ba0_process_check_interrupt.
 * delay_interrupt = the delay (in sec.) between two calls to *check_interrupt.
 * no_oot          = if true, ERRALR is disabled.
 */
    void (
        *check_interrupt) (
        void);
    time_t delay_interrupt;
    bool no_oot;
  } common;
  struct
  {
/* 
 * If true, the BLAD memory limit does not raise BA0_ERROOM.
 * Temporarily modified by all blad_restart functions.
 */
    bool no_oom;
  } malloc;
  struct
  {
    ba0_int_p sizeof_main_cell;
    ba0_int_p sizeof_quiet_cell;
    ba0_int_p sizeof_analex_cell;
    ba0_int_p nb_cells_per_stack;
    ba0_int_p sizeof_stack_of_stack;
/* 
 * Pointers to the functions that are called by BLAD for allocating/freeing
 * memory (mostly cells in stacks).
 */
    void *(
        *system_malloc) (
        size_t);
    void (
        *system_free) (
        void *);
  } stack;
  struct
  {
    ba0_set_memory_functions_function *set_memory_functions;
/*
 * If Integer_PFE is not (char *)0, every mpz_t z is printed Integer_PFE(z).
 * This mechanism prevents floating point evaluation of rational numbers
 *  in Python. Default value is (char *)0
 */
    char *Integer_PFE;
  } gmp;
  struct
  {
/* 
 * nb_tokens = the number of tokens in the analex FIFO
 * quotes    = a string containing the characters that can be used
 *              for quoting tokens
 */
    ba0_int_p nb_tokens;
    char *quotes;
  } analex;
  struct
  {
/*
 * The operator used for separating variable from values. Default "="
 */
    char *equal_sign;
  } value;
  struct
  {
/*
 * oper     = the range operator
 * infinity = the symbol for infinity
 * rhs_included = determines whether the right-hand side of range 
 *                indices should be included or not in the ranges
 * quote_PFE = if set to true, the range indexed groups which are not plain 
 *                strings are quoted when printed; this mechanism prevents 
 *                from evaluation failures in Python; default (char *)0
 */
    char *oper;
    char *infinity;
    bool rhs_included;
    bool quote_PFE;
  } range_indexed_group;
};

extern BA0_DLL struct ba0_global ba0_global;

extern BA0_DLL struct ba0_initialized_global ba0_initialized_global;

/*
 * texinfo: ba0_PFE_settings
 * This data structure is used to store copies of the settings variables
 * contained in the fields of @code{ba0_initialized_global} which
 * contain @code{PFE} variables.
 */

struct ba0_PFE_settings
{
  ba0_set_memory_functions_function *set_memory_functions;
  char *Integer_PFE;
  char *oper;
  char *infinity;
  bool rhs_included;
  bool quote_PFE;
};

END_C_DECLS
#endif /* !BA0_GLOBAL_H */
#if !defined (BAV_COMMON_H)
#   define BAV_COMMON_H 1

/* #   include <ba0.h> */

/* 
 * The _MSC_VER flag is set if the code is compiled under WINDOWS
 * by using Microsoft Visual C (through Visual Studio 2008).
 *
 * In that case, some specific annotations must be added for DLL exports
 * Beware to the fact that this header file is going to be used either
 * for/while building BLAD or for using BLAD from an outer software.
 *
 * In the first case, functions are exported.
 * In the second one, they are imported.
 *
 * The flag BAV_BLAD_BUILDING must thus be set in the Makefile and passed
 * to the C preprocessor at BAV building time. Do not set it when using BAV.
 *
 * When compiling static libraries under Windows, set BA0_STATIC.
 */

#   if defined (_MSC_VER) && ! defined (BA0_STATIC)
#      if defined (BLAD_BUILDING) || defined (BAV_BLAD_BUILDING)
#         define BAV_DLL  __declspec(dllexport)
#      else
#         define BAV_DLL  __declspec(dllimport)
#      endif
#   else
#      define BAV_DLL
#   endif

/* #   include "bav_mesgerr.h" */

BEGIN_C_DECLS

/*
 * texinfo: bav_Idegree
 * This is the integer type for degrees.
 */

typedef ba0_int_p bav_Idegree;

#   define BAV_MAX_IDEGRE BA0_MAX_INT_P

/*
 * texinfo: bav_Iorder
 * This is the integer type for differentiation orders.
 */

typedef ba0_int_p bav_Iorder;

/*
 * texinfo: bav_Iordering
 * This is the integer type for ordering numbers.
 */

typedef ba0_int_p bav_Iordering;

/*
 * texinfo: bav_Inumber
 * This is the integer type for variable numbers.
 */

typedef ba0_int_p bav_Inumber;

struct bav_tableof_Inumber
{
  ba0_int_p alloc;
  ba0_int_p size;
  bav_Inumber *tab;
};

struct bav_tableof_Iorder
{
  ba0_int_p alloc;
  ba0_int_p size;
  bav_Iorder *tab;
};

struct bav_tableof_Iordering
{
  ba0_int_p alloc;
  ba0_int_p size;
  bav_Iordering *tab;
};

struct bav_tableof_Idegree
{
  ba0_int_p alloc;
  ba0_int_p size;
  bav_Idegree *tab;
};

/* 
 * struct ba0_indexed_string* not recognized by parsers.
 * The function pointer, a buffer and the default value for the pointer
 */

extern BAV_DLL ba0_indexed_string_function bav_unknown_default;

extern BAV_DLL void bav_set_settings_common (
    ba0_indexed_string_function *);

extern BAV_DLL void bav_get_settings_common (
    ba0_indexed_string_function **);

extern BAV_DLL void bav_reset_all_settings (
    void);

struct bav_PFE_settings;

extern BAV_DLL void bav_cancel_PFE_settings (
    struct bav_PFE_settings *);

extern BAV_DLL void bav_restore_PFE_settings (
    struct bav_PFE_settings *);

extern BAV_DLL void bav_restart (
    ba0_int_p,
    ba0_int_p);

extern BAV_DLL void bav_terminate (
    enum ba0_restart_level);

END_C_DECLS
#endif /* !BAV_COMMON_H */
#if !defined (BAV_MESGERR_H)
#   define BAV_MESGERR_H 1

/* #   include "bav_common.h" */

BEGIN_C_DECLS

extern BAV_DLL char BAV_ERRUSY[];

extern BAV_DLL char BAV_ERRDSY[];

extern BAV_DLL char BAV_ERRRIG[];

extern BAV_DLL char BAV_ERRBSD[];

extern BAV_DLL char BAV_ERRPAO[];

extern BAV_DLL char BAV_ERRPAR[];

extern BAV_DLL char BAV_ERRDIF[];

extern BAV_DLL char BAV_ERRDVR[];

extern BAV_DLL char BAV_ERRSPY[];

extern BAV_DLL char BAV_ERRDFV[];

extern BAV_DLL char BAV_ERRBLO[];

extern BAV_DLL char BAV_ERRBOR[];

extern BAV_DLL char BAV_ERRTER[];

extern BAV_DLL char BAV_ERRRGZ[];

extern BAV_DLL char BAV_ERRTEU[];

extern BAV_DLL char BAV_EXEXQO[];

END_C_DECLS
#endif /* !BAV_MESGERR_H */
#if !defined (BAV_SYMBOL_H)
#   define BAV_SYMBOL_H 1

/* #   include "bav_common.h" */

BEGIN_C_DECLS

/*
 * texinfo: bav_typeof_symbol
 * Independent symbols are used to build derivations.
 * Dependent symbols are used to build differential indeterminates.
 * Operator symbols are used to build differential operators.
 * Temporary symbols are used to build temporary variables.
 */

enum bav_typeof_symbol
{
  bav_independent_symbol,
  bav_dependent_symbol,
  bav_operator_symbol,
  bav_temporary_symbol
};

/*
 * texinfo: bav_symbol
 * A @dfn{symbol} mostly is an identifier endowed with a type.
 * Symbols are used to define variables.
 * In the case of an @dfn{independent symbol} or 
 * a @dfn{temporary symbol}, the symbol is associated to a
 * unique corresponding variable.
 * In the case of a @dfn{dependent symbol} or an 
 * @dfn{operator symbol}, the symbol is shared by many different 
 * variables, corresponding to its derivatives.
 *
 * Symbols are not duplicated. 
 * They are allocated in @code{ba0_global.stack.quiet} and
 * stored in the table @code{bav_global.R.syms}.
 *
 * A symbol may be a @dfn{plain symbol} or a symbol which
 * fits a range indexed string. The latter case can only occur
 * if the symbol is dependent.
 *
 * If the symbol is a plain symbol then its field
 * @code{index_in_rigs} contains @code{BA0_NOT_AN_INDEX}
 * and the field @code{subscripts} is empty.
 * If it fits a range indexed string then its field @code{index_in_rigs}
 * contains the index in @code{bav_global.R.rigs} of the radical
 * of its identifier and the field @code{subscripts} contains its
 * subscripts.
 *
 * A symbol may be a parameter or not.
 * Only dependent symbols may be parameters.
 * If the symbol is a parameter then its field @code{index_in_pars} contains
 * the index in @code{bav_global.pars.pars} of its parameter description.
 * If the symbol is not a parameter, its field @code{index_in_pars} contains
 * @code{BA0_NOT_AN_INDEX}.
 */

struct bav_symbol
{
// the identifier of the symbol
  char *ident;
// its type
  enum bav_typeof_symbol type;
// the index of the symbol in bav_global.R.syms
  ba0_int_p index_in_syms;
// if ident fits a range indexed string, an index in bav_global.R.rigs
  ba0_int_p index_in_rigs;
// if ident fits a range indexed string, the table of its subscripts
  struct ba0_tableof_int_p subscripts;
// if the symbol is independent, its index in bav_global.R.ders 
  ba0_int_p derivation_index;
// if the symbol is a parameter, its index in bav_global.R.pars.pars 
  ba0_int_p index_in_pars;
};

#   define BAV_NOT_A_SYMBOL	(struct bav_symbol*)0

struct bav_tableof_symbol
{
  ba0_int_p alloc;
  ba0_int_p size;
  struct bav_symbol **tab;
};

extern BAV_DLL void bav_set_settings_symbol (
    ba0_scanf_function *,
    ba0_printf_function *,
    char *);

extern BAV_DLL void bav_get_settings_symbol (
    ba0_scanf_function **,
    ba0_printf_function **,
    char **);

extern BAV_DLL void bav_init_symbol (
    struct bav_symbol *);

extern BAV_DLL struct bav_symbol *bav_new_symbol (
    void);

extern BAV_DLL struct bav_symbol *bav_not_a_symbol (
    void);

extern BAV_DLL unsigned ba0_int_p bav_sizeof_symbol (
    struct bav_symbol *,
    enum ba0_garbage_code,
    bool);

extern BAV_DLL void bav_R_set_symbol (
    struct bav_symbol *,
    struct bav_symbol *,
    char *);

extern BAV_DLL bool bav_is_a_derivation (
    char *);

extern BAV_DLL bool bav_is_subscripted_symbol (
    struct bav_symbol *);

extern BAV_DLL ba0_int_p bav_subscript_of_symbol (
    struct bav_symbol *);

extern BAV_DLL ba0_scanf_function bav_scanf_symbol;

extern BAV_DLL ba0_scanf_function bav_scanf_default_symbol;

extern BAV_DLL ba0_scanf_function bav_scanf2_symbol;

extern BAV_DLL ba0_printf_function bav_printf_symbol;

extern BAV_DLL ba0_printf_function bav_printf_default_symbol;

extern BAV_DLL ba0_printf_function bav_printf_numbered_symbol;

struct bav_differential_ring;

extern BAV_DLL struct bav_symbol *bav_switch_ring_symbol (
    struct bav_symbol *,
    struct bav_differential_ring *);

END_C_DECLS
#endif /* ! BAV_SYMBOL_H */
#if !defined (BAV_DICTIONARY_SYMBOL_H)
#   define BAV_DICTIONARY_SYMBOL_H 1

/* #   include "bav_symbol.h" */

BEGIN_C_DECLS

/*
 * texinfo: bav_dictionary_symbol
 * This data structure implements dictionaries which map 
 * @code{struct bav_symbol *} to other objects.
 * In this implementation, the values associated to the keys are integers, 
 * which are supposed to be indices in some table of objects of unspecified 
 * type.
 * This data structure actually is as an alias for
 * @code{struct ba0_dictionary}. 
 */

struct bav_dictionary_symbol
{
// each entry contains either -1 or an index in some table of symbols
  struct ba0_tableof_int_p area;
// the shift applied on keys before hashing them
  ba0_int_p shift;
// the base-2 logarithm of the size/alloc field of area if area is nonempty
  ba0_int_p log2_size;
// the number of used entries in area
  ba0_int_p used_entries;
};

extern BAV_DLL void bav_init_dictionary_symbol (
    struct bav_dictionary_symbol *,
    ba0_int_p);

extern BAV_DLL void bav_reset_dictionary_symbol (
    struct bav_dictionary_symbol *);

extern BAV_DLL unsigned ba0_int_p bav_sizeof_dictionary_symbol (
    struct bav_dictionary_symbol *,
    enum ba0_garbage_code);

extern BAV_DLL void bav_set_dictionary_symbol (
    struct bav_dictionary_symbol *,
    struct bav_dictionary_symbol *);

extern BAV_DLL ba0_int_p bav_get_dictionary_symbol (
    struct bav_dictionary_symbol *,
    struct bav_tableof_symbol *,
    struct bav_symbol *);

extern BAV_DLL void bav_add_dictionary_symbol (
    struct bav_dictionary_symbol *,
    struct bav_tableof_symbol *,
    struct bav_symbol *,
    ba0_int_p);

END_C_DECLS
#endif /* !BAV_DICTIONARY_SYMBOL_H */
#if !defined (BAV_PARAMETER_H)
#   define BAV_PARAMETER_H 1

/* #   include "bav_symbol.h" */

BEGIN_C_DECLS

/*
 * texinfo: bav_parameter
 * This data structure permits to represent a @dfn{parameter} i.e. a dependent
 * symbol / order zero dependent variable for which some derivatives
 * are supposed to simplify to zero (the notion of parameter is here
 * more general than the usual one).
 *
 * A parameter may be a @dfn{plain parameter} or a parameter which
 * fits a range indexed group.
 * If the parameter is a plain one, then its identifier is the identifier 
 * of a dependent symbol / order zero dependent variable. 
 * If it fits a range indexed group, it describes a set of parameters 
 * which is made of all the symbols which fit the group.
 *
 * The field @code{dependencies} contains the derivation indices of the
 * derivations / independent variables the parameter depends on. 
 * If this field is empty, every derivative of the parameter is zero.
 * The order of appearance of the derivations in this field is followed
 * by some printing functions.
 */

struct bav_parameter
{
// the range indexed group which describes the parameter identifiers
  struct ba0_range_indexed_group rig;
// the table of the derivation indices the parameter depends on
  struct ba0_tableof_int_p dependencies;
};

struct bav_tableof_parameter
{
  ba0_int_p alloc;
  ba0_int_p size;
  struct bav_parameter **tab;
};

struct bav_variable;

extern BAV_DLL void bav_set_settings_parameter (
    char *);

extern BAV_DLL void bav_get_settings_parameter (
    char * *);

extern BAV_DLL void bav_init_parameter (
    struct bav_parameter *);

extern BAV_DLL struct bav_parameter *bav_new_parameter (
    void);

extern BAV_DLL void bav_set_parameter (
    struct bav_parameter *,
    struct bav_parameter *);

extern BAV_DLL void bav_set_parameter_with_tableof_string (
    struct bav_parameter *,
    struct bav_parameter *,
    struct ba0_dictionary_string *,
    struct ba0_tableof_string *);

extern BAV_DLL void bav_set_tableof_parameter_with_tableof_string (
    struct bav_tableof_parameter *,
    struct bav_tableof_parameter *,
    struct ba0_dictionary_string *,
    struct ba0_tableof_string *);

extern BAV_DLL unsigned ba0_int_p bav_sizeof_parameter (
    struct bav_parameter *,
    enum ba0_garbage_code,
    bool);

extern BAV_DLL unsigned ba0_int_p bav_sizeof_tableof_parameter (
    struct bav_tableof_parameter *,
    enum ba0_garbage_code,
    bool);

extern BAV_DLL bool bav_is_a_parameter (
    struct bav_symbol *,
    struct bav_parameter **);

extern BAV_DLL void bav_annihilating_derivations_of_parameter (
    struct bav_tableof_symbol *,
    struct bav_parameter *);

extern BAV_DLL bool bav_is_constant_variable (
    struct bav_variable *,
    struct bav_symbol *);

extern BAV_DLL bool bav_is_zero_derivative_of_parameter (
    struct bav_variable *);

extern BAV_DLL void *bav_scanf_parameter (
    void *z);

extern BAV_DLL void bav_printf_parameter_dependencies (
    struct bav_parameter *);

extern BAV_DLL void bav_printf_parameter (
    void *z);

END_C_DECLS
#endif /* ! extern BAV_PARAMETER_H */
#if !defined (BAV_PARAMETERS_H)
#   define BAV_PARAMETERS_H

/* #   include "bav_parameter.h" */

BEGIN_C_DECLS

/*
 * texinfo: bav_parameters
 * This data type is only used to form the field @code{pars}
 * of the @code{bav_differential_ring} structure. It handles
 * the parameters of the differential ring.
 *
 * The field @code{pars} contains the table of all parameters.
 * Each range indexed group occurring in any element of the
 * table actually is a range indexed string i.e. has a single radical.
 *
 * The field @code{dict} maps strings to non-plain parameters in @code{pars}. 
 * The keys are the radicals of the range indexed strings. 
 * The dictionary does not contain any entry corresponding to plain parameters.
 */

struct bav_parameters
{
// maps strings to radicals of range indexed strings for non-plain parameters
  struct ba0_dictionary_string dict;
// the table of parameters - range indexed groups are range indexed strings
  struct bav_tableof_parameter pars;
};

extern BAV_DLL void bav_init_parameters (
    struct bav_parameters *);

extern BAV_DLL unsigned ba0_int_p bav_sizeof_parameters (
    struct bav_parameters *,
    enum ba0_garbage_code,
    bool);

extern BAV_DLL void bav_R_set_parameters (
    struct bav_parameters *,
    struct bav_parameters *,
    struct bav_differential_ring *);

extern BAV_DLL void bav_R_set_parameters_tableof_parameter (
    struct bav_parameters *,
    struct bav_tableof_parameter *);

END_C_DECLS
#endif /* !BAV_PARAMETERS_H */
#if !defined (BAV_VARIABLE_H)
#   define BAV_VARIABLE_H 1

/* #   include "bav_common.h" */
/* #   include "bav_symbol.h" */

BEGIN_C_DECLS

struct bav_variable;

struct bav_tableof_variable
{
  ba0_int_p alloc;
  ba0_int_p size;
  struct bav_variable **tab;
};

struct bav_tableof_tableof_variable
{
  ba0_int_p alloc;
  ba0_int_p size;
  struct bav_tableof_variable **tab;
};

/*
 * texinfo: bav_variable
 * A @dfn{variable} is a basic objects which permits to form terms and
 * polynomials. A variable which is not a proper derivative of
 * some differential indeterminate is said to be a @dfn{radical variable}
 * (this includes independent variables, order zero derivatives).
 * Variables are allocated in @code{ba0_global.stack.quiet} and
 * are stored in the array @code{bav_global.R.vars}.
 *
 * The field @code{number} contains the number of the variable
 * with respect to each ordering occurring in @code{bav_global.R.ords}.
 * The greater the number, the greater the variables.
 * Numbers change when new variables are created
 * (by differentiation of existing variables).
 *
 * The fields @code{order} and @code{derivative} are only meaningful
 * for derivatives of differential indeterminates.
 * The sizes of these tables are equal to the number of derivations.
 * The @math{i}th entry of each of these tables is associated to
 * the @math{i}th derivation i.e. the @math{i}th element of the
 * table @code{bav_global.R.ders}.
 */

struct bav_variable
{
// the symbol at the root of the variable
  struct bav_symbol *root;
// the index of the variable in bav_global.R.vars
  ba0_int_p index_in_vars;
// the size of number is equal to bav_global.R.ords.size
  struct bav_tableof_Inumber number;
// the two next fields are for derivatives of differential indeterminates
// or differential operators. Their size is equal to bav_global.R.ders.size
  struct bav_tableof_Iorder order;
  struct bav_tableof_variable derivative;
};


#   define BAV_NOT_A_VARIABLE	BA0_NOT_A_VARIABLE
#   define BAV_TEMP_STRING		"_"
#   define BAV_JET0_INPUT_STRING      "_"
#   define BAV_JET0_OUTPUT_STRING     "_"

struct bav_term;

struct bav_tableof_parameter;

extern BAV_DLL void bav_set_settings_variable (
    ba0_scanf_function *,
    ba0_printf_function *,
    char *,
    char *,
    char *);

extern BAV_DLL void bav_get_settings_variable (
    ba0_scanf_function **,
    ba0_printf_function **,
    char **,
    char **,
    char **);

extern BAV_DLL struct bav_variable *bav_new_variable (
    void);

extern BAV_DLL struct bav_variable *bav_not_a_variable (
    void);

extern BAV_DLL void bav_R_set_variable (
    struct bav_variable *,
    struct bav_variable *,
    struct bav_differential_ring *);

extern BAV_DLL bav_Iorder bav_order_variable (
    struct bav_variable *,
    struct bav_symbol *);

extern BAV_DLL bav_Iorder bav_total_order_variable (
    struct bav_variable *);

extern BAV_DLL struct bav_variable *bav_diff_variable (
    struct bav_variable *,
    struct bav_symbol *);

extern BAV_DLL struct bav_variable *bav_diff2_variable (
    struct bav_variable *,
    struct bav_term *);

extern BAV_DLL struct bav_variable *bav_int_variable (
    struct bav_variable *,
    struct bav_symbol *);

extern BAV_DLL enum bav_typeof_symbol bav_symbol_type_variable (
    struct bav_variable *);

extern BAV_DLL struct bav_variable *bav_order_zero_variable (
    struct bav_variable *);

extern BAV_DLL struct bav_variable *bav_lcd_variable (
    struct bav_variable *,
    struct bav_variable *);

extern BAV_DLL bool bav_disjoint_variables (
    struct bav_variable *,
    struct bav_variable *);

extern BAV_DLL bool bav_is_derivative (
    struct bav_variable *,
    struct bav_variable *);

extern BAV_DLL bool bav_is_proper_derivative (
    struct bav_variable *,
    struct bav_variable *);

extern BAV_DLL bool bav_is_d_derivative (
    struct bav_variable *,
    struct bav_variable *,
    struct bav_symbol *);

extern BAV_DLL struct bav_variable *bav_derivation_between_derivatives (
    struct bav_variable *,
    struct bav_variable *);

extern BAV_DLL void bav_operator_between_derivatives (
    struct bav_term *,
    struct bav_variable *,
    struct bav_variable *);

extern BAV_DLL struct bav_variable *bav_next_derivative (
    struct bav_variable *,
    struct bav_tableof_variable *);

extern BAV_DLL ba0_mint_hp bav_random_eval_variable_to_mint_hp (
    struct bav_variable *);

extern BAV_DLL struct bav_variable *bav_indexed_string_to_variable (
    struct ba0_indexed_string *);

#   define BAV_jet_FLAG          1
#   define BAV_tjet_FLAG         2
#   define BAV_jet0_FLAG         4
#   define BAV_diff_FLAG         8
#   define BAV_inert_diff_FLAG  16
#   define BAV_Derivative_FLAG  32
#   define BAV_D_FLAG           64

extern BAV_DLL ba0_scanf_function bav_scanf_jet_variable;

extern BAV_DLL ba0_scanf_function bav_scanf_jet0_variable;

extern BAV_DLL ba0_scanf_function bav_scanf_diff_variable;

extern BAV_DLL ba0_scanf_function bav_scanf_inert_diff_variable;

extern BAV_DLL ba0_scanf_function bav_scanf_python_D_variable;

extern BAV_DLL ba0_scanf_function bav_scanf_maple_D_variable;

extern BAV_DLL ba0_scanf_function bav_scanf_python_all_variable;

extern BAV_DLL ba0_scanf_function bav_scanf_maple_all_variable;

extern BAV_DLL ba0_scanf_function bav_scanf_python_Derivative_variable;

extern BAV_DLL void bav_reset_notations (
    void);

extern BAV_DLL ba0_int_p bav_get_notations (
    void);

extern BAV_DLL ba0_printf_function bav_printf_jet_variable;

extern BAV_DLL ba0_printf_function bav_printf_jet_wesb_variable;

extern BAV_DLL ba0_printf_function bav_printf_jet0_variable;

extern BAV_DLL ba0_printf_function bav_printf_LaTeX_variable;

extern BAV_DLL ba0_printf_function bav_printf_diff_variable;

extern BAV_DLL ba0_printf_function bav_printf_inert_diff_variable;

extern BAV_DLL ba0_printf_function bav_printf_maple_D_variable;

extern BAV_DLL ba0_printf_function bav_printf_python_Derivative_variable;

extern BAV_DLL ba0_scanf_function bav_scanf_variable;

extern BAV_DLL ba0_printf_function bav_printf_variable;

extern BAV_DLL ba0_cmp_function bav_gt_index_variable;

extern BAV_DLL ba0_cmp_function bav_gt_variable;

extern BAV_DLL void bav_sort_tableof_variable (
    struct bav_tableof_variable *,
    enum ba0_sort_mode);

extern BAV_DLL void bav_independent_variables (
    struct bav_tableof_variable *);

struct bav_differential_ring;

extern BAV_DLL struct bav_variable *bav_switch_ring_variable (
    struct bav_variable *,
    struct bav_differential_ring *);

END_C_DECLS
#endif /* !BAV_VARIABLE_H */
#if !defined (BAV_DICTIONARY_VARIABLE_H)
#   define BAV_DICTIONARY_VARIABLE_H 1

/* #   include "bav_variable.h" */

BEGIN_C_DECLS

/*
 * texinfo: bav_dictionary_variable
 * This data structure implements dictionaries which map 
 * @code{struct bav_variable *} to other objects.
 * In this implementation, the values associated to the keys are integers, 
 * which are supposed to be indices in some table of objects of unspecified 
 * type.
 * This data structure actually is as an alias for
 * @code{struct ba0_dictionary}. 
 */

struct bav_dictionary_variable
{
// each entry contains either -1 or an index in some table of variables
  struct ba0_tableof_int_p area;
// the shift applied on keys before hashing them
  ba0_int_p shift;
// the base-2 logarithm of the size/alloc field of area if area is nonempty
  ba0_int_p log2_size;
// the number of used entries in area
  ba0_int_p used_entries;
};

extern BAV_DLL void bav_init_dictionary_variable (
    struct bav_dictionary_variable *,
    ba0_int_p);

extern BAV_DLL void bav_reset_dictionary_variable (
    struct bav_dictionary_variable *);

extern BAV_DLL unsigned ba0_int_p bav_sizeof_dictionary_variable (
    struct bav_dictionary_variable *,
    enum ba0_garbage_code);

extern BAV_DLL void bav_set_dictionary_variable (
    struct bav_dictionary_variable *,
    struct bav_dictionary_variable *);

extern BAV_DLL ba0_int_p bav_get_dictionary_variable (
    struct bav_dictionary_variable *,
    struct bav_tableof_variable *,
    struct bav_variable *);

extern BAV_DLL void bav_add_dictionary_variable (
    struct bav_dictionary_variable *,
    struct bav_tableof_variable *,
    struct bav_variable *,
    ba0_int_p);

END_C_DECLS
#endif /* !BAV_DICTIONARY_VARIABLE_H */
#if !defined (BAV_OPERATOR_H)
#   define BAV_OPERATOR_H 1

/* #   include "bav_common.h" */
/* #   include "bav_variable.h" */


BEGIN_C_DECLS

END_C_DECLS
#endif /* !BAV_OPERATOR_H */
#if !defined (BAV_SUBRANKING_H)
#   define BAV_SUBRANKING_H 1

/* #   include "bav_common.h" */
/* #   include "bav_variable.h" */
/* #   include "bav_typed_ident.h" */


BEGIN_C_DECLS

/*
 * texinfo: bav_subranking
 * This data type implements subrankings.
 * A @dfn{subranking} permits to
 * compare derivatives of differential indeterminates.
 * Subrankings form a subtype of the @code{bav_block} data type.
 *
 * There are five predefined subrankings:
 * @code{lex}, @code{grlexA}, @code{grlexB}, @code{degrevlexA}
 * and @code{degrevlexB}.
 * The difference between them is actually only meaningful in the case of
 * partial derivatives.
 * Consider two different derivatives @math{u = \theta\,y} and 
 * @math{v = \phi\,z} to be compared.
 * View the @dfn{derivative operators} @math{\theta,\phi} as power products 
 * of derivations. 
 *
 * Among themselves, differential indeterminates are ordered by their
 * order of appearance in the block.
 * Among themselves, derivations are ordered by their order of
 * appearance in the derivation list:
 * this permits to compare derivative operators.
 * For details, see the @code{bav_ordering} data structure.
 *
 * In the @code{lex} ordering, derivative operators 
 * are first compared with respect to the lexicographic order; in case
 * of equality, differential indeterminates are compared.
 *
 * In all other subrankings, derivative operators are first compared
 * with respect to their total order. In the sequel, it is assumed
 * that @math{\theta} and @math{\phi} have the same total order.
 *
 * In the @code{grlexA} and @code{degrevlexA} subrankings, 
 * the second comparison criterion is given by the differential 
 * indeterminates i.e. @math{u > v} if @math{y > z}.
 * In the case of equality, the derivative operators are compared
 * either with respect to the lexicographic ordering (@code{grlexA})
 * or with respect to the reverse lexicographic ordering (@code{degrevlexA}).
 *
 * In the @code{grlexB} and @code{degrevlexB} subrankings, 
 * the second comparison criterion is given by the derivative operators,
 * which are compared either with respect to the lexicographic ordering 
 * (@code{grlexB}) or with respect to the reverse lexicographic ordering 
 * (@code{degrevlexB}). In the case of equality, the differential 
 * indeterminates are compared.
 *
 * To each subranking, a comparison function @code{inf} is associated.
 * This function is called when a new ordering or a new variable are
 * created. It is involved in the comparison process of two variables,
 * in order to determine their numbers, with respect to some ordering
 * @var{ord}.
 *
 * This function takes as input two different variables @var{v} and @var{w}
 * belonging to some same block of @var{ord}, their typed ident
 * @var{tid_v} and @var{tid_w}, picked 
 * from the @code{typed_idents} field of @var{ord} and the address
 * of the @code{ders} field of @var{ord}. It returns @code{true} if 
 * @math{v < w} with respect to the subranking (hence the ordering),
 * @code{false} otherwise.
 */

struct bav_typed_ident;

struct bav_subranking
{
// The identifier of the subranking (grlexA, degrevlexB, ...)
// This identifier is a readonly global string.
  char *ident;
  bool (
      *inf) (
      struct bav_variable * v,
      struct bav_variable * w,
      struct bav_typed_ident * tid_v,
      struct bav_typed_ident * tid_w,
      struct bav_tableof_symbol * ders);
};

extern BAV_DLL bool bav_is_subranking (
    char *,
    struct bav_subranking **);

END_C_DECLS
#endif /* !BAV_SUBRANKING_H */
#if !defined (BAV_BLOCK_H)
#   define BAV_BLOCK_H 1

/* #   include "bav_common.h" */
/* #   include "bav_symbol.h" */
/* #   include "bav_subranking.h" */

BEGIN_C_DECLS

/*
 * texinfo: bav_block
 * A @dfn{block} is a list of range indexed groups defining differential
 * indeterminates (possibly also a single differential operator) 
 * ordered with respect to some common subranking. See the description 
 * of the data types @code{bav_subranking} and @code{bav_ordering}.
 */

struct bav_block
{
// the subranking which applies to the block
  struct bav_subranking *subr;
// the table of the range indexed groups of the block
  struct ba0_tableof_range_indexed_group rigs;
};

#   define BAV_NOT_A_BLOCK (struct bav_block*)0

struct bav_tableof_block
{
  ba0_int_p alloc;
  ba0_int_p size;
  struct bav_block **tab;
};

extern BAV_DLL void bav_init_block (
    struct bav_block *);

extern BAV_DLL void bav_reset_block (
    struct bav_block *);

extern BAV_DLL struct bav_block *bav_new_block (
    void);

extern BAV_DLL unsigned ba0_int_p bav_sizeof_block (
    struct bav_block *,
    enum ba0_garbage_code,
    bool);

extern BAV_DLL unsigned ba0_int_p bav_sizeof_tableof_block (
    struct bav_tableof_block *,
    enum ba0_garbage_code,
    bool);

struct bav_differential_ring;

extern BAV_DLL void bav_R_set_block (
    struct bav_block *,
    struct bav_block *,
    struct bav_differential_ring *);

extern BAV_DLL void bav_R_set_tableof_block (
    struct bav_tableof_block *,
    struct bav_tableof_block *,
    struct bav_differential_ring *);

extern BAV_DLL bool bav_is_empty_block (
    struct bav_block *);

extern BAV_DLL ba0_scanf_function bav_scanf_block;

extern BAV_DLL ba0_printf_function bav_printf_block;

END_C_DECLS
#endif /* !BAV_BLOCK_H */
#if !defined (BAV_TYPED_IDENT_H)
#   define BAV_TYPED_IDENT_H 1

/* #   include "bav_common.h" */

BEGIN_C_DECLS

/*
 * texinfo: bav_typeof_ident
 * This data type is a subtype of @code{bav_typed_ident}.
 */

enum bav_typeof_ident
{
// The identifier is a plain string
  bav_plain_ident,
// The identifier is the radical of a range indexed string
  bav_range_indexed_string_radical_ident
};

/*
 * texinfo: bav_typed_ident
 * This data structure permits to associate a table of indices
 * to typed identifiers. 
 * As a substructure of @code{bav_ordering}, it associates to
 * any typed identifier three indices: the index of the block which
 * contains the identifier; the index of the identifier within
 * the block; the index of the identifier in the group (this last
 * index is only meaningful if the type is 
 * @code{bav_range_indexed_string_radical_ident}).
 */

struct bav_typed_ident
{
// the string - possibly (char *)0
  char *ident;
// its type
  enum bav_typeof_ident type;
// the indices associated to the typed ident
  struct ba0_tableof_int_p indices;
};

struct bav_tableof_typed_ident
{
  ba0_int_p alloc;
  ba0_int_p size;
  struct bav_typed_ident **tab;
};

struct bav_symbol;
struct bav_block;
struct bav_tableof_block;

extern BAV_DLL void bav_init_typed_ident (
    struct bav_typed_ident *);

extern BAV_DLL struct bav_typed_ident *bav_new_typed_ident (
    void);

extern BAV_DLL unsigned ba0_int_p bav_sizeof_typed_ident (
    struct bav_typed_ident *,
    enum ba0_garbage_code,
    bool);

extern BAV_DLL unsigned ba0_int_p bav_sizeof_tableof_typed_ident (
    struct bav_tableof_typed_ident *,
    enum ba0_garbage_code,
    bool);

struct bav_differential_ring;

extern BAV_DLL void bav_R_set_typed_ident (
    struct bav_typed_ident *,
    struct bav_typed_ident *,
    struct bav_differential_ring *);

extern BAV_DLL void bav_R_set_tableof_typed_ident (
    struct bav_tableof_typed_ident *,
    struct bav_tableof_typed_ident *,
    struct bav_differential_ring *);

extern BAV_DLL void bav_R_append_tableof_typed_ident_block (
    struct bav_tableof_typed_ident *,
    ba0_int_p,
    struct bav_block *,
    struct bav_differential_ring *);

extern BAV_DLL void bav_R_set_tableof_typed_ident_tableof_block (
    struct bav_tableof_typed_ident *,
    struct bav_tableof_block *,
    struct bav_differential_ring *);

extern BAV_DLL ba0_int_p bav_get_typed_ident_from_symbol (
    struct ba0_dictionary_typed_string *,
    struct bav_tableof_typed_ident *,
    struct bav_symbol *);

END_C_DECLS
#endif /* !BAV_TYPED_IDENT_H */
#if !defined (BAV_ORDERING_H)
#   define BAV_ORDERING_H 1

/* #   include "bav_common.h" */
/* #   include "bav_symbol.h" */
/* #   include "bav_block.h" */
/* #   include "bav_variable.h" */
/* #   include "bav_operator.h" */
/* #   include "bav_typed_ident.h" */

BEGIN_C_DECLS

/*
 * texinfo: bav_ordering
 * This data type is a subtype of @code{bav_differential_ring}
 * used to describe orderings. 
 * In differential algebra, derivatives of differential indeterminates
 * are ordered with respect to a @dfn{ranking}. In the software, the
 * notion of ranking is generalized to the one of @dfn{ordering}, to take
 * into account independent variables, temporary variables or derivatives 
 * temporarily considered as maximal or minimal variables.
 * The simplest method to define an ordering in the @code{bav} library
 * consists in using the parser. Let us thus have a look to a few
 * different definitions of orderings, accepted by the parser.
 * @verbatim
 * 1. ordering (derivations = [t], blocks = [[u,v], grlexB[w]])
 * 2. ordering (derivations = [], blocks = [w,v,u])
 * 3. ordering (derivations = [x,y], blocks = [degrevlexA[u]],
 *              operator = [D], varmax = [u[x,x]])
 * 4. ordering (derivations = [x,y], blocks = [degrevlexB[u],v], 
 *              varmax = [u[x],u[x,x,x]], varmin = [u[x,x]])
 * @end verbatim
 * An ordering is first defined by a list of blocks @math{[b_1,\ldots,b_n]}.
 * Leftmost blocks are considered as greater than rightmost ones i.e.
 * every derivative of any differential indeterminate present in @math{b_i}
 * is greater than any derivative of any differential indeterminate present 
 * in @math{b_{i+k}} (with @math{k > 0}).
 * In Example 1, we have @math{v_t > w_{t,t,t}}.
 * In Example 2, we have @math{w > v > u}.
 *
 * Within a fixed block, derivatives are ordered with respect to a 
 * @dfn{subranking} (see the description of the data 
 * type @code{bav_subranking}).
 * The default subranking is @code{grlexA}.
 * Other subrankings such as @code{grlexB}, @code{degrevlexA} or
 * @code{degrevlexB} appear in the above examples.
 * Subrankings are only meaningful in the partial case.
 * In the ordinary case everything simplifies as follows.
 * Consider a block @math{[u_1,\ldots,u_n]} of differential indeterminates.
 * Derivatives of the @math{u_i} are first compared with respect to their
 * @dfn{order}. In the case of two derivatives with the same order,
 * leftmost differential indeterminates are considered as greater than 
 * rightmost ones. 
 * 
 * Independent variables / derivations are considered as lower than derivatives.
 * In the partial case, leftmost derivations are considered as greater
 * than rightmost ones, in the list of derivations.
 * In Examples 3 and 4, we have @math{x > y}.
 *
 * The orderings defined so far mostly are rankings (slightly generalized
 * to cover the case of independent variables). They are suitable for
 * differential elimination algorithms. However, it is also sometimes
 * useful to use orderings which are not rankings by specifying 
 * variables considered as greater than or lower than any other variable
 * (such orderings should only be used when no differentiation process
 * is involved). This is achieved by means of the @code{varmax} and the
 * @code{varmin} lists.
 * In Example 3, @math{u_{x,x}} is greater than any other variable.
 * In Example 4, @math{u_x} and @math{u_{x,x,x}} are greater than
 * any other variable. Moreover @math{u_x > u_{x,x,x}} and @math{u_{x,x}}
 * is lower than any other variable.
 *
 * In principle, it is also possible to define a @dfn{differential operator}.
 * Derivatives of the differential operator are ordered as variables,
 * using a block description. Any derivative of the differential operator is
 * greater than any derivative of any differential indeterminate.
 * However, derivatives listed in the @code{varmax} list are considered
 * as greater than derivatives of the differential operator.
 * 
 * It is moreover possible to define temporary variables.
 * These variables are considered as lower than any other variable.
 * Among themselves, temporary variables are ordered according
 * to some session dependent unspecified ordering.
 * These temporary variables are handled in the @code{bav_differential_ring}
 * data structure.
 *
 * The fields @code{typed_ident} and @code{dict} permit to associate
 * a triple @math{(i,j,k)} of indices to a typed identifier @var{ident}. 
 * They are used for computing variable numbers.
 * The first index @math{i} is the block number of @var{ident} in the sense
 * that @var{ident} belongs to the @math{i}th entry of the @code{blocks}
 * table. The second index @math{j} is the index of @var{ident} within
 * the @math{i}th block.
 * The third index @math{k} is is meaningful in the case of range indexed 
 * groups which are not plain strings. It gives the index of @var{ident}
 * in the group.
 * Consider the following example, featuring a table of two blocks.
 * @verbatim
 * blocks = [[z], [(y,z)[inf:-1], t, (u)[3:5]]]
 * @end verbatim
 * Then the @code{typed_ident} field contains the three following entries:
 * @verbatim
 * typed_ident = [
 *  ['z', bav_plain_ident, 0, 0, -1],
 *  ['y', bav_range_indexed_string_radical_ident, 1, 0, 0], 
 *  ['z', bav_range_indexed_string_radical_ident, 1, 0, 1],
 *  ['t', bav_plain_ident, 1, 1, -1],
 *  ['u', bav_range_indexed_string_radical_ident, 1, 2, 0]]
 * @end verbatim
 */

struct bav_ordering
{
// the table of derivations - the order matters for some subrankings
  struct bav_tableof_symbol ders;
// the table of blocks
  struct bav_tableof_block blocks;
// the array of typed ident and its associated dictionary.
  struct bav_tableof_typed_ident typed_idents;
  struct ba0_dictionary_typed_string dict;
// the block for the differential operator - if any
  struct bav_block operator_block;
// the variables set as maximal variables
  struct bav_tableof_variable varmax;
// the variables set as minimal variables
  struct bav_tableof_variable varmin;
};

struct bav_tableof_ordering
{
  ba0_int_p alloc;
  ba0_int_p size;
  struct bav_ordering **tab;
};

struct bav_parameter;

extern BAV_DLL void bav_set_settings_ordering (
    char *);

extern BAV_DLL void bav_get_settings_ordering (
    char **);

extern BAV_DLL unsigned ba0_int_p bav_sizeof_ordering (
    struct bav_ordering *,
    enum ba0_garbage_code,
    bool);

extern BAV_DLL unsigned ba0_int_p bav_sizeof_tableof_ordering (
    struct bav_tableof_ordering *,
    enum ba0_garbage_code,
    bool);

extern BAV_DLL void bav_R_set_ordering (
    struct bav_ordering *,
    struct bav_ordering *,
    struct bav_differential_ring *);

extern BAV_DLL void bav_R_set_tableof_ordering (
    struct bav_tableof_ordering *,
    struct bav_tableof_ordering *,
    struct bav_differential_ring *);

extern BAV_DLL void bav_init_ordering (
    struct bav_ordering *);

extern BAV_DLL void bav_reset_ordering (
    struct bav_ordering *);

extern BAV_DLL struct bav_ordering *bav_new_ordering (
    void);

extern BAV_DLL void bav_set_ordering (
    struct bav_ordering *,
    struct bav_ordering *);

extern BAV_DLL ba0_scanf_function bav_scanf_ordering;

extern BAV_DLL ba0_printf_function bav_printf_ordering;

extern BAV_DLL int bav_R_compare_variable (
    struct bav_variable *,
    struct bav_variable *);

extern BAV_DLL void bav_block_sort_tableof_variable (
    struct bav_tableof_tableof_variable *,
    struct bav_tableof_variable *,
    struct bav_tableof_variable *);

extern BAV_DLL void bav_R_sort_tableof_variable (
    struct bav_tableof_variable *);

extern BAV_DLL void bav_R_lower_block_range_indexed_strings (
    struct ba0_tableof_range_indexed_group *,
    ba0_int_p);

extern BAV_DLL ba0_int_p bav_block_index_symbol (
    struct bav_symbol *);

extern BAV_DLL ba0_int_p bav_block_index_range_indexed_group (
    struct ba0_range_indexed_group *);

extern BAV_DLL ba0_int_p bav_block_index_parameter (
    struct bav_parameter *);

extern BAV_DLL bool bav_has_varmax_current_ordering (
    void);

END_C_DECLS
#endif /* !BAV_ORDERING_H */
#if !defined (BAV_DIFFERENTIAL_RING_H)
#   define BAV_DIFFERENTIAL_RING_H 1

/* #   include "bav_common.h" */
/* #   include "bav_block.h" */
/* #   include "bav_symbol.h" */
/* #   include "bav_variable.h" */
/* #   include "bav_operator.h" */
/* #   include "bav_parameters.h" */
/* #   include "bav_ordering.h" */

BEGIN_C_DECLS

/*
 * texinfo: bav_differential_ring
 * This data type implements one mathematical differential ring
 * endowed with many different orderings. It is completely
 * stored in @code{ba0_global.stack.quiet} (the quiet stack).
 *
 * The field @code{strs} contains all the strings used as identifiers
 * of symbols or as radicals of range indexed strings. Note 1: identifiers of
 * symbols involve identifiers of variables which fit range indexed strings.
 * Note 2: the same string may be both the radical of a range indexed string
 * and the identifier of a differential indeterminate.
 *
 * The @code{syms} table contains all the symbols. 
 * The @code{vars} table contains all the variables.
 *
 * The dictionary @code{dict_str_to_var} maps strings to variables
 * of the @code{vars} table.
 * Only the radical variables are stored in this dictionary.
 *
 * The dictionary @code{dict_str_to_rig} maps strings to range indexed
 * strings of the @code{rigs} table. The keys are the radicals of the
 * range indexed strings.
 *
 * The table @code{ders} contains the indices in @code{vars} of the
 * derivations / independent variables. The index in @code{ders}
 * of a derivation is called its @dfn{derivation index}.
 * This table thus maps derivation indices to the corresponding
 * independent variables.
 *
 * The field @code{ords} contains all the defined orderings.
 * They all refer to the same mathematical differential ring
 * hence must order the same set of symbols.
 * It actually associates an index to each ordering and permits
 * to interpret the table @code{number} of the variables.
 *
 * The field @code{ord_stack} implements a stack of indices
 * in @code{ords}. Its top element is the @dfn{current ordering}.
 *
 * The field @code{pars} contains the description of the parameters
 * of the differential ring i.e. dependent symbols some derivatives
 * of which simplifying to zero.
 *
 * Many functions of the @code{bav} library hold identifiers
 * starting with @code{bav_R}. These are low level functions,
 * performing critical operations of the @code{bav_global.R}
 * structure.
 */

struct bav_differential_ring
{
// true if the differential ring is empty
  bool empty;
// the table of all ident of symbols, radicals of range indexed strings
  struct ba0_tableof_string strs;
// the table of the range indexed strings
  struct ba0_tableof_range_indexed_group rigs;
// the table of symbols
  struct bav_tableof_symbol syms;
// the table of variables
  struct bav_tableof_variable vars;
// maps strings to strings in strs
  struct ba0_dictionary_string dict_str_to_str;
// maps strings to variables in vars
  struct ba0_dictionary_string dict_str_to_var;
// maps strings (radicals) to range indexed strings in rigs
  struct ba0_dictionary_string dict_str_to_rig;
// the indices in vars of the derivations 
  struct ba0_tableof_int_p ders;
// the indices in vars of the temporary variables 
  struct ba0_tableof_int_p tmps;
// tmps_in_use[i] is nonzero iff tmps[i] is in use
  struct ba0_tableof_int_p tmps_in_use;
//  -1 or the index in vars of the symbol used for differential operators
  ba0_int_p opra;
// all the defined orderings
  struct bav_tableof_ordering ords;
// a stack of indices in ords
  struct bav_tableof_Iordering ord_stack;
// the parameters
  struct bav_parameters pars;
};


extern BAV_DLL void bav_init_differential_ring (
    struct bav_differential_ring *);

extern BAV_DLL struct bav_differential_ring *bav_new_differential_ring (
    void);

extern BAV_DLL unsigned ba0_int_p bav_sizeof_differential_ring (
    struct bav_differential_ring *,
    enum ba0_garbage_code);

extern BAV_DLL bool bav_is_empty_differential_ring (
    struct bav_differential_ring *);

extern BAV_DLL void bav_R_set_differential_ring (
    struct bav_differential_ring *,
    struct bav_differential_ring *);

extern BAV_DLL void bav_R_create_differential_ring (
    struct ba0_tableof_string *,
    struct bav_tableof_block *,
    struct bav_block *);

extern BAV_DLL bav_Iordering bav_R_new_ranking (
    struct ba0_tableof_string *,
    struct bav_tableof_block *,
    struct bav_block *);

extern BAV_DLL void bav_R_add_block_to_all_orderings (
    struct bav_block *,
    ba0_int_p);

extern BAV_DLL bool bav_R_ambiguous_symbols (
    void);

extern BAV_DLL bav_Iordering bav_R_copy_ordering (
    bav_Iordering);

extern BAV_DLL struct bav_variable *bav_R_new_symbol_and_variable (
    char *,
    enum bav_typeof_symbol,
    ba0_int_p,
    struct ba0_tableof_int_p *);

extern BAV_DLL struct bav_variable *bav_R_new_temporary_variable (
    void);

extern BAV_DLL void bav_R_free_temporary_variable (
    struct bav_variable *);

extern BAV_DLL void bav_R_set_maximal_variable (
    struct bav_variable *);

extern BAV_DLL void bav_R_set_minimal_variable (
    struct bav_variable *);

extern BAV_DLL void bav_R_swap_ordering (
    bav_Iordering,
    bav_Iordering);

extern BAV_DLL void bav_R_free_ordering (
    bav_Iordering);

extern BAV_DLL void bav_R_restore_ords_size (
    ba0_int_p);

extern BAV_DLL void bav_push_ordering (
    bav_Iordering);

extern BAV_DLL void bav_pull_ordering (
    void);

extern BAV_DLL bav_Iordering bav_current_ordering (
    void);

extern BAV_DLL bav_Inumber bav_variable_number (
    struct bav_variable *);

extern BAV_DLL struct bav_variable *bav_smallest_greater_variable (
    struct bav_variable *);

extern BAV_DLL bav_Inumber bav_R_symbol_block_number (
    struct bav_symbol *,
    ba0_int_p *);

extern BAV_DLL struct bav_variable *bav_R_new_derivative (
    struct bav_variable *,
    struct bav_symbol *);

extern BAV_DLL struct bav_variable *bav_symbol_to_variable (
    struct bav_symbol *);

extern BAV_DLL struct bav_symbol *bav_R_string_to_existing_symbol (
    char *);

extern BAV_DLL struct bav_symbol *bav_R_string_to_existing_derivation (
    char *);

extern BAV_DLL struct bav_variable *bav_R_string_to_existing_variable (
    char *);

extern BAV_DLL struct bav_variable *bav_derivation_index_to_derivation (
    ba0_int_p);

END_C_DECLS
#endif /* !BAV_DIFFERENTIAL_RING_H */
#if !defined (BAV_POINT_H)
#   define BAV_POINT_H

/* #   include "bav_common.h" */

BEGIN_C_DECLS

extern BAV_DLL bool bav_is_differentially_ambiguous_point (
    struct ba0_point *);

extern BAV_DLL void bav_delete_independent_values_point (
    struct ba0_point *,
    struct ba0_point *);

END_C_DECLS
#endif /* !BAV_POINT */
#if !defined (BAV_POINT_INT_P_H)
#   define BAV_POINT_INT_P_H 1

/* #   include "bav_common.h" */
/* #   include "bav_variable.h" */

BEGIN_C_DECLS

/*
 * texinfo: bav_value_int_p
 * This data type permits to associate a @code{ba0_int_p} value
 * to a variable. It can be parsed and printed using the
 * format @code{%value(%d)}.
 */

struct bav_value_int_p
{
  struct bav_variable *var;
  ba0_int_p value;
};


/*
 * texinfo: bav_point_int_p
 * This data type is a particular case of the type @code{struct ba0_point}.
 * It permits to associate @code{ba0_int_p} values to
 * many different variables. 
 * Many functions assume the @code{tab} field to be sorted
 * (see @code{ba0_sort_point}).
 * They can be parsed using @code{ba0_scanf/%point(%d)} and
 * printed by @code{ba0_printf/%point(%d)}.
 */

struct bav_point_int_p
{
  ba0_int_p alloc;
  ba0_int_p size;
  struct bav_value_int_p **tab;
};


END_C_DECLS
#endif /* !BAV_POINT_INT_P_H */
#if !defined (BAV_POINT_INTERVAL_MPQ_H)
#   define BAV_POINT_INTERVAL_MPQ_H 1

/* #   include "bav_common.h" */
/* #   include "bav_variable.h" */

BEGIN_C_DECLS

/*
 * texinfo: bav_value_interval_mpq
 * This data type associates an interval with @code{mpq_t} ends
 * to a variable. It can be parsed and printed using the
 * format @code{%value(%qi)}.
 */

struct bav_value_interval_mpq
{
  struct bav_variable *var;
  struct ba0_interval_mpq *value;
};


/* In the next one, all variables might be equal */

struct bav_tableof_value_interval_mpq
{
  ba0_int_p alloc;
  ba0_int_p size;
  struct bav_value_interval_mpq **tab;
};



/*
 * texinfo: bav_point_interval_mpq
 * This data type is a particular case of the type @code{struct ba0_point}.
 * It permits to associate @code{ba0_interval_mpq} values to
 * many different variables.
 * They can be parsed by @code{ba0_scanf/%point(%qi)} and printed
 * by @code{ba0_printf/%point(%qi)}.
 * Many functions assume the @code{tab} field to be sorted
 * (see @code{ba0_sort_point}).
 */

struct bav_point_interval_mpq
{
  ba0_int_p alloc;
  ba0_int_p size;
  struct bav_value_interval_mpq **tab;
};


struct bav_tableof_point_interval_mpq
{
  ba0_int_p alloc;
  ba0_int_p size;
  struct bav_point_interval_mpq **tab;
};


extern BAV_DLL struct bav_value_interval_mpq *bav_new_value_interval_mpq (
    void);

extern BAV_DLL void bav_set_value_interval_mpq (
    struct bav_value_interval_mpq *,
    struct bav_value_interval_mpq *);

extern BAV_DLL void bav_init_point_interval_mpq (
    struct bav_point_interval_mpq *);

extern BAV_DLL struct bav_point_interval_mpq *bav_new_point_interval_mpq (
    void);

extern BAV_DLL void bav_realloc_point_interval_mpq (
    struct bav_point_interval_mpq *,
    ba0_int_p);

extern BAV_DLL void bav_set_point_interval_mpq (
    struct bav_point_interval_mpq *,
    struct bav_point_interval_mpq *);

extern BAV_DLL void bav_set_coord_point_interval_mpq (
    struct bav_point_interval_mpq *,
    struct bav_variable *,
    struct ba0_interval_mpq *);

extern BAV_DLL void bav_intersect_coord_point_interval_mpq (
    struct bav_point_interval_mpq *,
    struct bav_point_interval_mpq *,
    struct bav_variable *,
    struct ba0_interval_mpq *);

extern BAV_DLL void bav_intersect_point_interval_mpq (
    struct bav_point_interval_mpq *,
    struct bav_point_interval_mpq *,
    struct bav_point_interval_mpq *);

extern BAV_DLL bool bav_is_empty_point_interval_mpq (
    struct bav_point_interval_mpq *);

extern BAV_DLL void bav_bisect_point_interval_mpq (
    struct bav_tableof_point_interval_mpq *,
    struct bav_point_interval_mpq *,
    ba0_int_p);

extern BAV_DLL void bav_set_tableof_point_interval_mpq (
    struct bav_tableof_point_interval_mpq *,
    struct bav_tableof_point_interval_mpq *);

END_C_DECLS
#endif /* !BAV_POINT_INTERVAL_MPQ_H */
#if !defined (BAV_RANK_H)
#   define BAV_RANK_H 1

/* #   include "bav_common.h" */
/* #   include "bav_variable.h" */

BEGIN_C_DECLS

/*
 * texinfo: bav_rank
 * A @dfn{rank} is a variable raised to some degree.
 * Some special ranks are also defined such as the
 * rank of zero and the one of nonzero constants.
 * The rank of zero is encoded by 
 * (@code{BAV_NOT_A_VARIABLE}, @math{-1}).
 * The rank of nonzero constants is encoded by a field @code{deg}
 * equal to @math{0} (the field @code{var} is unspecified).
 */

struct bav_rank
{
// possibly BAV_NOT_A_VARIABLE
  struct bav_variable *var;
// possibly zero or a negative integer
  bav_Idegree deg;
};


extern BAV_DLL void bav_init_rank (
    struct bav_rank *);

extern BAV_DLL struct bav_rank *bav_new_rank (
    void);

extern BAV_DLL bool bav_is_zero_rank (
    struct bav_rank *);

extern BAV_DLL bool bav_is_constant_rank (
    struct bav_rank *);

extern BAV_DLL bool bav_lt_rank (
    struct bav_rank *,
    struct bav_rank *);

extern BAV_DLL bool bav_gt_rank (
    struct bav_rank *,
    struct bav_rank *);

extern BAV_DLL bool bav_equal_rank (
    struct bav_rank *,
    struct bav_rank *);

extern BAV_DLL int bav_compare_rank (
    const void *,
    const void *);

extern BAV_DLL struct bav_rank bav_zero_rank (
    void);

extern BAV_DLL struct bav_rank bav_constant_rank (
    void);

extern BAV_DLL struct bav_rank bav_constant_rank2 (
    struct bav_variable *);

extern BAV_DLL void bav_set_settings_rank (
    ba0_printf_function *);

extern BAV_DLL void bav_get_settings_rank (
    ba0_printf_function **);

extern BAV_DLL ba0_scanf_function bav_scanf_rank;

extern BAV_DLL ba0_printf_function bav_printf_rank;

extern BAV_DLL ba0_printf_function bav_printf_default_rank;

extern BAV_DLL ba0_printf_function bav_printf_stars_rank;

extern BAV_DLL ba0_printf_function bav_printf_list_rank;

struct bav_tableof_rank
{
  ba0_int_p alloc;
  ba0_int_p size;
  struct bav_rank **tab;
};


END_C_DECLS
#endif /* !BAV_RANK_H */
#if !defined (BAV_TERM_H)
#   define BAV_TERM_H 1

/* #   include "bav_common.h" */
/* #   include "bav_rank.h" */
/* #   include "bav_point_int_p.h" */
/* #   include "bav_parameter.h" */
/* #   include "bav_point_interval_mpq.h" */

BEGIN_C_DECLS

/*
 * texinfo: bav_term
 * A @dfn{term} is a product of ranks (the ranks of zero and of nonzero
 * constants are forbidden) sorted by decreasing order with respect to the
 * current ordering.
 * The empty product encodes the term @math{1}.
 * The leading rank of a nonempty product is the leading rank of the term.
 */

struct bav_term
{
// number of entries allocated to rg
  ba0_int_p alloc;
// number of entries used in rg
  ba0_int_p size;
// the array of ranks, by decreasing order with respect to the current ordering
  struct bav_rank *rg;
};

struct bav_listof_term
{
  struct bav_term *value;
  struct bav_listof_term *next;
};

struct bav_tableof_term
{
  ba0_int_p alloc;
  ba0_int_p size;
  struct bav_term **tab;
};

extern BAV_DLL void bav_realloc_term (
    struct bav_term *,
    ba0_int_p);

extern BAV_DLL void bav_init_term (
    struct bav_term *);

extern BAV_DLL struct bav_term *bav_new_term (
    void);

extern BAV_DLL void bav_set_term_one (
    struct bav_term *);

extern BAV_DLL void bav_set_term_variable (
    struct bav_term *,
    struct bav_variable *,
    bav_Idegree);

extern BAV_DLL void bav_set_term_rank (
    struct bav_term *,
    struct bav_rank *);

extern BAV_DLL void bav_set_term (
    struct bav_term *,
    struct bav_term *);

extern BAV_DLL void bav_set_tableof_term (
    struct bav_tableof_term *,
    struct bav_tableof_term *);

extern BAV_DLL void bav_lcm_tableof_term (
    struct bav_tableof_term *,
    struct bav_tableof_term *,
    struct bav_tableof_term *);

extern BAV_DLL void bav_shift_term (
    struct bav_term *,
    struct bav_term *);

extern BAV_DLL void bav_strip_term (
    struct bav_term *,
    struct bav_term *,
    bav_Inumber);

extern BAV_DLL bool bav_is_one_term (
    struct bav_term *);

extern BAV_DLL struct bav_variable *bav_leader_term (
    struct bav_term *);

extern BAV_DLL bav_Idegree bav_leading_degree_term (
    struct bav_term *);

extern BAV_DLL bav_Idegree bav_total_degree_term (
    struct bav_term *);

extern BAV_DLL bav_Idegree bav_degree_term (
    struct bav_term *,
    struct bav_variable *);

extern BAV_DLL bav_Iorder bav_total_order_term (
    struct bav_term *);

extern BAV_DLL bav_Idegree bav_maximal_degree_term (
    struct bav_term *);

extern BAV_DLL struct bav_rank bav_leading_rank_term (
    struct bav_term *);

extern BAV_DLL bool bav_disjoint_term (
    struct bav_term *,
    struct bav_term *);

extern BAV_DLL bool bav_equal_term (
    struct bav_term *,
    struct bav_term *);

extern BAV_DLL bool bav_gt_term (
    struct bav_term *,
    struct bav_term *);

extern BAV_DLL bool bav_lt_term (
    struct bav_term *,
    struct bav_term *);

extern BAV_DLL void bav_sort_term (
    struct bav_term *);

extern BAV_DLL void bav_sort_tableof_term (
    struct bav_tableof_term *);

extern BAV_DLL void bav_lcm_term (
    struct bav_term *,
    struct bav_term *,
    struct bav_term *);

extern BAV_DLL void bav_gcd_term (
    struct bav_term *,
    struct bav_term *,
    struct bav_term *);

extern BAV_DLL void bav_mul_term (
    struct bav_term *,
    struct bav_term *,
    struct bav_term *);

extern BAV_DLL void bav_mul_term_rank (
    struct bav_term *,
    struct bav_term *,
    struct bav_rank *);

extern BAV_DLL void bav_mul_term_variable (
    struct bav_term *,
    struct bav_term *,
    struct bav_variable *,
    bav_Idegree);

extern BAV_DLL void bav_pow_term (
    struct bav_term *,
    struct bav_term *,
    bav_Idegree);

extern BAV_DLL void bav_exquo_term (
    struct bav_term *,
    struct bav_term *,
    struct bav_term *);

extern BAV_DLL void bav_exquo_term_variable (
    struct bav_term *,
    struct bav_term *,
    struct bav_variable *,
    bav_Idegree);

extern BAV_DLL bool bav_is_factor_term (
    struct bav_term *,
    struct bav_term *,
    struct bav_term *);

extern BAV_DLL void bav_diff_term (
    struct bav_term *,
    struct bav_term *,
    struct bav_symbol *);

extern BAV_DLL void bav_set_term_tableof_variable (
    struct bav_term *,
    struct bav_tableof_variable *,
    struct ba0_tableof_int_p *);

extern BAV_DLL void bav_term_at_point_int_p (
    ba0_mpz_t,
    struct bav_term *,
    struct bav_point_int_p *);

extern BAV_DLL void bav_term_at_point_interval_mpq (
    struct ba0_interval_mpq *,
    struct bav_term *,
    struct bav_point_interval_mpq *);

extern BAV_DLL ba0_garbage1_function bav_garbage1_term;

extern BAV_DLL ba0_garbage2_function bav_garbage2_term;

extern BAV_DLL ba0_scanf_function bav_scanf_term;

extern BAV_DLL ba0_printf_function bav_printf_term;

extern BAV_DLL ba0_copy_function bav_copy_term;

struct bav_differential_ring;

extern BAV_DLL void bav_switch_ring_term (
    struct bav_term *,
    struct bav_differential_ring *);

extern BAV_DLL bool bav_depends_on_zero_derivatives_of_parameter_term (
    struct bav_term *);

END_C_DECLS
#endif /* !BAV_TERM_H */
#if !defined (BAV_TERM_ORDERING_H)
#   define BAV_TERM_ORDERING_H 1

/* #   include "bav_term.h" */

BEGIN_C_DECLS

extern BAV_DLL enum ba0_compare_code bav_compare_term (
    struct bav_term *,
    struct bav_term *);

extern BAV_DLL enum ba0_compare_code bav_compare_stripped_term (
    struct bav_term *,
    struct bav_term *,
    bav_Inumber);

extern BAV_DLL void bav_set_term_ordering (
    char *);

END_C_DECLS
#endif /* !BAV_TERM_ORDERING_H */
#if !defined (BAV_GLOBAL_H)
#   define BAV_GLOBAL_H 1

/* #   include "bav_common.h" */
/* #   include "bav_differential_ring.h" */
/* #   include "bav_term.h" */


BEGIN_C_DECLS

struct bav_global
{
  struct
  {
/* 
 * Receives the faulty string when an unknown variable/symbol is parsed
 */
    char unknown[BA0_BUFSIZE];
  } common;
  struct bav_differential_ring R;
  struct
  {
/*
 * Flags indicating which input notation was used
 */
    ba0_int_p notations;
/* 
 * "diff" or "Diff" to display derivatives
 */
    char *diff_string;
  } variable;
  struct
  {
/* 
 * Comparison functions w.r.t. term orderings
 */
    enum ba0_compare_code (
        *compare) (
        struct bav_term *,
        struct bav_term *);
    enum ba0_compare_code (
        *compare_stripped) (
        struct bav_term *,
        struct bav_term *,
        bav_Inumber);
  } term_ordering;
};

struct bav_initialized_global
{
  struct
  {
/* 
 * Function called when an unknown symbol/variable/parameter is parsed.
 * Default bav_unknown_default
 */
    ba0_indexed_string_function *unknown;
  } common;
  struct
  {
/* 
 * Functions pointers for customizing symbol parsing and printing
 */
    ba0_scanf_function *scanf;
    ba0_printf_function *printf;
/*
 * If IndexedBase_PFE is not (char *)0, the radical z of every symbol
 * z[something] which fits some range indexed group is printed 
 * IndexedBase_PFE('z') leading to a symbol IndexedBase_PFE('z')[something].
 * This mechanism prevents some evaluation failures in Python. Default 0
 */
    char *IndexedBase_PFE;
  } symbol;
  struct
  {
/*
 * If Function_PFE is not (char *)0, every parameter p with nonempty
 * dependencies is printed Function_PFE('p')(dependencies).
 * This mechanism prevents some evaluation failures in Python. Default 0.
 */
    char *Function_PFE;
  } parameter;
  struct
  {
/* 
 * Functions pointers for customizing variable parsing and printing
 */
    ba0_scanf_function *scanf;
    ba0_printf_function *printf;
/*
 * The strings which stand for no derivation in the jet0 notation
 */
    char *jet0_input_string;
    char *jet0_output_string;
/* 
 * The prefix of temporary variables
 */
    char *temp_string;
  } variable;
  struct
  {
/* 
 * Function pointer for customizing the way ranks are printed.
 */
    ba0_printf_function *printf;
  } rank;
  struct
  {
/* 
 * The string for displaying orderings
 */
    char *string;
  } ordering;
};

extern BAV_DLL struct bav_global bav_global;

extern BAV_DLL struct bav_initialized_global bav_initialized_global;

/*
 * texinfo: bav_PFE_settings
 * This data structure is used to store copies of the settings variables
 * contained in the fields of @code{bav_initialized_global} which
 * contain @code{PFE} variables.
 */

struct bav_PFE_settings
{
  struct ba0_PFE_settings ba0;
  ba0_scanf_function *scanf;
  ba0_printf_function *printf;
  char *IndexedBase_PFE;
  char *Function_PFE;
};

END_C_DECLS
#endif /* !BAV_GLOBAL_H */
#if !defined (BAP_COMMON_H)
#   define BAP_COMMON_H 1

/* #   include <bav.h> */

/* 
 * The _MSC_VER flag is set if the code is compiled under WINDOWS
 * by using Microsoft Visual C (through Visual Studio 2008).
 *
 * In that case, some specific annotations must be added for DLL exports
 * Beware to the fact that this header file is going to be used either
 * for/while building BLAD or for using BLAD from an outer software.
 *
 * In the first case, functions are exported.
 * In the second one, they are imported.
 *
 * The flag BAP_BLAD_BUILDING must thus be set in the Makefile and passed
 * to the C preprocessor at BAP building time. Do not set it when using BAP.
 *
 * When compiling static libraries under Windows, set BA0_STATIC.
 */

#   if defined (_MSC_VER) && ! defined (BA0_STATIC)
#      if defined (BLAD_BUILDING) || defined (BAP_BLAD_BUILDING)
#         define BAP_DLL  __declspec(dllexport)
#      else
#         define BAP_DLL  __declspec(dllimport)
#      endif
#   else
#      define BAP_DLL
#   endif

/* #   include "bap_mesgerr.h" */

BEGIN_C_DECLS

/*
 * texinfo: bap_composite_number
 * This data structure aims at numbering elements which belong to
 * a sequence of elements implemented by means of tables of tables. 
 * Assume an element lies in @code{T->tab[i]->tab[j]}. Then 
 * @code{primary} is equal to @math{i}, 
 * @code{secondary} is equal to @math{j} and 
 * @code{combined}, the index of the element in the sequence, 
 * is equal to @math{j} plus the sum, for @math{0 \leq k < i} of 
 * @code{T->tab[k]->size}.
 */

struct bap_composite_number
{
  ba0_int_p primary;
  ba0_int_p secondary;
  ba0_int_p combined;
};

/*
 * texinfo: bap_typeof_monom_access
 * This data type permits to indicate the access which applies
 * to a polynomial.
 */

enum bap_typeof_monom_access
{
  bap_sequential_monom_access,
  bap_indexed_monom_access
};

/*
 * texinfo: bap_typeof_total_rank
 * This data type provides information on a @code{total_rank} field
 * while creating a polynomial, monomial per monomial.
 */

enum bap_typeof_total_rank
{
  bap_exact_total_rank,
  bap_approx_total_rank
};

/*
 * texinfo: bap_rank_code
 * This data type is used as return code for comparing ranks.
 */

enum bap_rank_code
{
  bap_rank_too_low,
  bap_rank_ok,
  bap_rank_too_high
};

extern BAP_DLL void bap_reset_all_settings (
    void);

extern BAP_DLL void bap_restart (
    ba0_int_p,
    ba0_int_p);

extern BAP_DLL void bap_terminate (
    enum ba0_restart_level);

extern BAP_DLL ba0_int_p bap_ceil_log2 (
    ba0_int_p);

END_C_DECLS
#endif /* !BAP_COMMON_H */
#if !defined (BAP_MESGERR_H)
#   define BAP_MESGERR_H 1

/* #   include "bap_common.h" */

BEGIN_C_DECLS

extern BAP_DLL char BAP_ERRNUL[];

extern BAP_DLL char BAP_ERRCST[];

extern BAP_DLL char BAP_ERRIND[];

extern BAP_DLL char BAP_ERRTGS[];

extern BAP_DLL char BAP_EXHNCP[];

END_C_DECLS
#endif /* !BAP_MESGERR_H */
#if !defined (BAP_TERMANAGER_H)
#   define BAP_TERMANAGER_H 1

/* #   include "bap_common.h" */

BEGIN_C_DECLS

/*
 * texinfo: bap_zipterm
 * If the term fits in a single @code{ba0_int_p} when compressed
 * then the corresponding @code{bap_zipterm} is the compressed form
 * of the term. If it does not, the corresponding @code{bap_zipterm}
 * is a pointer towards a sufficiently large array of @code{ba0_int_p}.
 */

typedef ba0_int_p bap_zipterm;

/*
 * texinfo: bap_termanager
 * This data type is designed to store the terms of a polynomial
 * (more precisely, of a clot in compressed form.
 */

struct bap_termanager
{
// the total rank of all terms of the clot
  struct bav_term total_rank;
  struct _zipping
  {
// number of ba0_int_p allocated to each zipterm
    ba0_int_p alloc;
// number of ba0_int_p used by each zipterm
    ba0_int_p size;
// the number of allocated entries of nbbits and mask
//      is equal to total_rank.alloc
// nbbits[i] = the number of bits needed to store the degree of 
//      the ith variable in total_rank in any zipterm
// mask[i]   = the binary mask needed to extract this degree
    unsigned char *nbbits;
    unsigned ba0_int_p *mask;
  } zipping;
};


extern BAP_DLL void bap_init_termanager (
    struct bap_termanager *,
    struct bav_term *);

extern BAP_DLL void bap_reset_termanager (
    struct bap_termanager *,
    struct bav_term *,
    bool *);

extern BAP_DLL bool bap_equal_termanager (
    struct bap_termanager *,
    struct bap_termanager *);

extern BAP_DLL void bap_init_set_termanager (
    struct bap_termanager *,
    struct bap_termanager *);

extern BAP_DLL void bap_init_zipterm_array_termanager (
    struct bap_termanager *,
    bap_zipterm *,
    ba0_int_p);

extern BAP_DLL void bap_set_zipterm_zipterm_termanager (
    struct bap_termanager *,
    bap_zipterm *,
    struct bap_termanager *,
    bap_zipterm);

extern BAP_DLL void bap_set_zipterm_term_termanager (
    struct bap_termanager *,
    bap_zipterm *,
    struct bav_term *);

extern BAP_DLL void bap_set_term_zipterm_termanager (
    struct bap_termanager *,
    struct bav_term *,
    bap_zipterm);

extern BAP_DLL ba0_garbage1_function bap_garbage1_termanager;

extern BAP_DLL ba0_garbage2_function bap_garbage2_termanager;

/* 
 * Should be garbage1 and garbage2 functions.
 */

extern BAP_DLL bool bap_worth_garbage_zipterm_termanager (
    struct bap_termanager *);

extern BAP_DLL ba0_int_p bap_garbage1_zipterm_termanager (
    struct bap_termanager *,
    bap_zipterm,
    enum ba0_garbage_code);

extern BAP_DLL bap_zipterm bap_garbage2_zipterm_termanager (
    struct bap_termanager *,
    bap_zipterm,
    enum ba0_garbage_code);

extern BAP_DLL void bap_switch_ring_termanager (
    struct bap_termanager *,
    struct bav_differential_ring *);

END_C_DECLS
#endif /* !BAP_TERMANAGER_H */
#if !defined (BAP_CLOT_mpz_H)
#   define BAP_CLOT_mpz_H 1

/* #   include "bap_common.h" */
/* #   include "bap_termanager.h" */

#   define BAD_FLAG_mpz

BEGIN_C_DECLS

/*
 * texinfo: bap_table2of_monom_mpz
 * This data type implements a contiguous linear combination
 * of zipterms. 
 */

struct bap_table2of_monom_mpz
{
  ba0_int_p alloc;              // number of allocated entries for both arrays
  ba0_int_p size;               // number of used entries for both arrays
  bap_zipterm *zipterm;         // the array of zipterms
  ba0_mpz_t *coeff;               // the array of coefficients
};


/*
 * texinfo: bap_tableof_table2of_monom_mpz
 * This data type is a table of tables. 
 * However, if we forget technical details, it is a sequence of
 * pairs of the form (term, coefficient).
 * These pairs are called @dfn{monomials} in the documentation.
 */

struct bap_tableof_table2of_monom_mpz
{
  ba0_int_p alloc;              // the number of allocated entries of tab
  ba0_int_p size;               // the number of used entries in tab
  struct bap_table2of_monom_mpz **tab;
};


/*
 * texinfo: bap_clot_mpz
 * This data type implements a clot i.e. a sequence of monomials
 * sorted in decreasing order w.r.t. the lexicographic ordering
 * induced by the current ordering.
 * The coefficients of monomials are nonzero.
 * Monomials are sometimes considered as numbered starting from @math{0}
 * in the documentation.
 */

struct bap_clot_mpz
{
// the total number of allocated entries of (zipterm, coeff)
  ba0_int_p alloc;
// the total number of used entries i.e. of monomials
  ba0_int_p size;
// the termanager which handles zipterms
  struct bap_termanager tgest;
// the table of bap_table2of_monom_mpz 
  struct bap_tableof_table2of_monom_mpz tab;
// the ordering w.r.t. which zipterms are ordered
  bav_Iordering ordering;
};


extern BAP_DLL struct bap_clot_mpz *bap_new_clot_mpz (
    struct bav_term *);

extern BAP_DLL bool bap_is_zero_clot_mpz (
    struct bap_clot_mpz *);

extern BAP_DLL void bap_reverse_clot_mpz (
    struct bap_clot_mpz *);

extern BAP_DLL void bap_sort_clot_mpz (
    struct bap_clot_mpz *,
    ba0_int_p,
    ba0_int_p);

extern BAP_DLL void bap_change_ordering_clot_mpz (
    struct bap_clot_mpz *,
    bav_Iordering);

extern BAP_DLL ba0_garbage1_function bap_garbage1_clot_mpz;

extern BAP_DLL ba0_garbage2_function bap_garbage2_clot_mpz;

extern BAP_DLL ba0_copy_function bap_copy_clot_mpz;

/*
 * texinfo: bap_itermon_clot_mpz
 * This data type implements iterators of monomials over a clot.
 * In this context the monomial number @code{num.combined}
 * is located in @code{clot->tab[num.primary]->tab[num.secondary]}.
 * An iterator may be set outside a clot.
 */

struct bap_itermon_clot_mpz
{
  struct bap_clot_mpz *clot;
  struct bap_composite_number num;
};


extern BAP_DLL void bap_begin_itermon_clot_mpz (
    struct bap_itermon_clot_mpz *,
    struct bap_clot_mpz *);

extern BAP_DLL void bap_end_itermon_clot_mpz (
    struct bap_itermon_clot_mpz *,
    struct bap_clot_mpz *);

extern BAP_DLL bool bap_outof_itermon_clot_mpz (
    struct bap_itermon_clot_mpz *);

extern BAP_DLL void bap_next_itermon_clot_mpz (
    struct bap_itermon_clot_mpz *);

extern BAP_DLL void bap_prev_itermon_clot_mpz (
    struct bap_itermon_clot_mpz *);

extern BAP_DLL void bap_goto_itermon_clot_mpz (
    struct bap_itermon_clot_mpz *,
    ba0_int_p);

extern BAP_DLL ba0_int_p bap_number_itermon_clot_mpz (
    struct bap_itermon_clot_mpz *);

extern BAP_DLL void bap_term_itermon_clot_mpz (
    struct bav_term *,
    struct bap_itermon_clot_mpz *);

extern BAP_DLL ba0_mpz_t *bap_coeff_itermon_clot_mpz (
    struct bap_itermon_clot_mpz *);

extern BAP_DLL void bap_swap_itermon_clot_mpz (
    struct bap_itermon_clot_mpz *,
    struct bap_itermon_clot_mpz *);

/*
 * texinfo: bap_creator_clot_mpz
 * This data type permits to create a clot monomial per monomial.
 * Monomials are stored in the clot by increasing number.
 * The creator permits to create clots whose monomials are not
 * sorted by decreasing order w.r.t. the lexicographic ordering
 * defined by the ranking. 
 * Creators rely on iterators of monomials over an already existing
 * clot which is then overwritten.
 */

struct bap_creator_clot_mpz
{
  struct bap_itermon_clot_mpz iter;
// the number of entries allocated to any new bap_table2of_monom_mpz
  ba0_int_p table2of_monom_alloc;
};


extern BAP_DLL void bap_begin_creator_clot_mpz (
    struct bap_creator_clot_mpz *,
    struct bap_clot_mpz *,
    struct bav_term *,
    ba0_int_p);

extern BAP_DLL void bap_append_creator_clot_mpz (
    struct bap_creator_clot_mpz *,
    struct bap_clot_mpz *,
    ba0_int_p);

extern BAP_DLL void bap_write_creator_clot_mpz (
    struct bap_creator_clot_mpz *,
    struct bav_term *,
    ba0_mpz_t);

extern BAP_DLL void bap_write_neg_creator_clot_mpz (
    struct bap_creator_clot_mpz *,
    struct bav_term *,
    ba0_mpz_t);

extern BAP_DLL void bap_write_term_creator_clot_mpz (
    struct bap_creator_clot_mpz *,
    struct bav_term *);

extern BAP_DLL void bap_write_all_creator_clot_mpz (
    struct bap_creator_clot_mpz *,
    struct bap_clot_mpz *,
    ba0_int_p,
    ba0_int_p);

extern BAP_DLL void bap_write_neg_all_creator_clot_mpz (
    struct bap_creator_clot_mpz *,
    struct bap_clot_mpz *,
    ba0_int_p,
    ba0_int_p);

extern BAP_DLL void bap_write_mul_all_creator_clot_mpz (
    struct bap_creator_clot_mpz *,
    struct bap_clot_mpz *,
    ba0_mpz_t,
    ba0_int_p,
    ba0_int_p);

#   if defined BAD_FLAG_mpz

extern BAP_DLL void bap_write_exquo_all_creator_clot_mpz (
    struct bap_creator_clot_mpz *,
    struct bap_clot_mpz *,
    ba0_mpz_t,
    ba0_int_p,
    ba0_int_p);

#   endif

extern BAP_DLL void bap_close_creator_clot_mpz (
    struct bap_creator_clot_mpz *);

extern BAP_DLL void bap_goto_creator_clot_mpz (
    struct bap_creator_clot_mpz *,
    ba0_int_p);

extern BAP_DLL void bap_switch_ring_clot_mpz (
    struct bap_clot_mpz *,
    struct bav_differential_ring *);

END_C_DECLS
#   undef BAD_FLAG_mpz
#endif /* !BAP_CLOT_mpz_H */
#if !defined (BAP_CLOT_mpzm_H)
#   define BAP_CLOT_mpzm_H 1

/* #   include "bap_common.h" */
/* #   include "bap_termanager.h" */

#   define BAD_FLAG_mpzm

BEGIN_C_DECLS

/*
 * texinfo: bap_table2of_monom_mpzm
 * This data type implements a contiguous linear combination
 * of zipterms. 
 */

struct bap_table2of_monom_mpzm
{
  ba0_int_p alloc;              // number of allocated entries for both arrays
  ba0_int_p size;               // number of used entries for both arrays
  bap_zipterm *zipterm;         // the array of zipterms
  ba0_mpzm_t *coeff;               // the array of coefficients
};


/*
 * texinfo: bap_tableof_table2of_monom_mpzm
 * This data type is a table of tables. 
 * However, if we forget technical details, it is a sequence of
 * pairs of the form (term, coefficient).
 * These pairs are called @dfn{monomials} in the documentation.
 */

struct bap_tableof_table2of_monom_mpzm
{
  ba0_int_p alloc;              // the number of allocated entries of tab
  ba0_int_p size;               // the number of used entries in tab
  struct bap_table2of_monom_mpzm **tab;
};


/*
 * texinfo: bap_clot_mpzm
 * This data type implements a clot i.e. a sequence of monomials
 * sorted in decreasing order w.r.t. the lexicographic ordering
 * induced by the current ordering.
 * The coefficients of monomials are nonzero.
 * Monomials are sometimes considered as numbered starting from @math{0}
 * in the documentation.
 */

struct bap_clot_mpzm
{
// the total number of allocated entries of (zipterm, coeff)
  ba0_int_p alloc;
// the total number of used entries i.e. of monomials
  ba0_int_p size;
// the termanager which handles zipterms
  struct bap_termanager tgest;
// the table of bap_table2of_monom_mpzm 
  struct bap_tableof_table2of_monom_mpzm tab;
// the ordering w.r.t. which zipterms are ordered
  bav_Iordering ordering;
};


extern BAP_DLL struct bap_clot_mpzm *bap_new_clot_mpzm (
    struct bav_term *);

extern BAP_DLL bool bap_is_zero_clot_mpzm (
    struct bap_clot_mpzm *);

extern BAP_DLL void bap_reverse_clot_mpzm (
    struct bap_clot_mpzm *);

extern BAP_DLL void bap_sort_clot_mpzm (
    struct bap_clot_mpzm *,
    ba0_int_p,
    ba0_int_p);

extern BAP_DLL void bap_change_ordering_clot_mpzm (
    struct bap_clot_mpzm *,
    bav_Iordering);

extern BAP_DLL ba0_garbage1_function bap_garbage1_clot_mpzm;

extern BAP_DLL ba0_garbage2_function bap_garbage2_clot_mpzm;

extern BAP_DLL ba0_copy_function bap_copy_clot_mpzm;

/*
 * texinfo: bap_itermon_clot_mpzm
 * This data type implements iterators of monomials over a clot.
 * In this context the monomial number @code{num.combined}
 * is located in @code{clot->tab[num.primary]->tab[num.secondary]}.
 * An iterator may be set outside a clot.
 */

struct bap_itermon_clot_mpzm
{
  struct bap_clot_mpzm *clot;
  struct bap_composite_number num;
};


extern BAP_DLL void bap_begin_itermon_clot_mpzm (
    struct bap_itermon_clot_mpzm *,
    struct bap_clot_mpzm *);

extern BAP_DLL void bap_end_itermon_clot_mpzm (
    struct bap_itermon_clot_mpzm *,
    struct bap_clot_mpzm *);

extern BAP_DLL bool bap_outof_itermon_clot_mpzm (
    struct bap_itermon_clot_mpzm *);

extern BAP_DLL void bap_next_itermon_clot_mpzm (
    struct bap_itermon_clot_mpzm *);

extern BAP_DLL void bap_prev_itermon_clot_mpzm (
    struct bap_itermon_clot_mpzm *);

extern BAP_DLL void bap_goto_itermon_clot_mpzm (
    struct bap_itermon_clot_mpzm *,
    ba0_int_p);

extern BAP_DLL ba0_int_p bap_number_itermon_clot_mpzm (
    struct bap_itermon_clot_mpzm *);

extern BAP_DLL void bap_term_itermon_clot_mpzm (
    struct bav_term *,
    struct bap_itermon_clot_mpzm *);

extern BAP_DLL ba0_mpzm_t *bap_coeff_itermon_clot_mpzm (
    struct bap_itermon_clot_mpzm *);

extern BAP_DLL void bap_swap_itermon_clot_mpzm (
    struct bap_itermon_clot_mpzm *,
    struct bap_itermon_clot_mpzm *);

/*
 * texinfo: bap_creator_clot_mpzm
 * This data type permits to create a clot monomial per monomial.
 * Monomials are stored in the clot by increasing number.
 * The creator permits to create clots whose monomials are not
 * sorted by decreasing order w.r.t. the lexicographic ordering
 * defined by the ranking. 
 * Creators rely on iterators of monomials over an already existing
 * clot which is then overwritten.
 */

struct bap_creator_clot_mpzm
{
  struct bap_itermon_clot_mpzm iter;
// the number of entries allocated to any new bap_table2of_monom_mpzm
  ba0_int_p table2of_monom_alloc;
};


extern BAP_DLL void bap_begin_creator_clot_mpzm (
    struct bap_creator_clot_mpzm *,
    struct bap_clot_mpzm *,
    struct bav_term *,
    ba0_int_p);

extern BAP_DLL void bap_append_creator_clot_mpzm (
    struct bap_creator_clot_mpzm *,
    struct bap_clot_mpzm *,
    ba0_int_p);

extern BAP_DLL void bap_write_creator_clot_mpzm (
    struct bap_creator_clot_mpzm *,
    struct bav_term *,
    ba0_mpzm_t);

extern BAP_DLL void bap_write_neg_creator_clot_mpzm (
    struct bap_creator_clot_mpzm *,
    struct bav_term *,
    ba0_mpzm_t);

extern BAP_DLL void bap_write_term_creator_clot_mpzm (
    struct bap_creator_clot_mpzm *,
    struct bav_term *);

extern BAP_DLL void bap_write_all_creator_clot_mpzm (
    struct bap_creator_clot_mpzm *,
    struct bap_clot_mpzm *,
    ba0_int_p,
    ba0_int_p);

extern BAP_DLL void bap_write_neg_all_creator_clot_mpzm (
    struct bap_creator_clot_mpzm *,
    struct bap_clot_mpzm *,
    ba0_int_p,
    ba0_int_p);

extern BAP_DLL void bap_write_mul_all_creator_clot_mpzm (
    struct bap_creator_clot_mpzm *,
    struct bap_clot_mpzm *,
    ba0_mpzm_t,
    ba0_int_p,
    ba0_int_p);

#   if defined BAD_FLAG_mpz

extern BAP_DLL void bap_write_exquo_all_creator_clot_mpz (
    struct bap_creator_clot_mpz *,
    struct bap_clot_mpz *,
    ba0_mpz_t,
    ba0_int_p,
    ba0_int_p);

#   endif

extern BAP_DLL void bap_close_creator_clot_mpzm (
    struct bap_creator_clot_mpzm *);

extern BAP_DLL void bap_goto_creator_clot_mpzm (
    struct bap_creator_clot_mpzm *,
    ba0_int_p);

extern BAP_DLL void bap_switch_ring_clot_mpzm (
    struct bap_clot_mpzm *,
    struct bav_differential_ring *);

END_C_DECLS
#   undef BAD_FLAG_mpzm
#endif /* !BAP_CLOT_mpzm_H */
#if !defined (BAP_CLOT_mpq_H)
#   define BAP_CLOT_mpq_H 1

/* #   include "bap_common.h" */
/* #   include "bap_termanager.h" */

#   define BAD_FLAG_mpq

BEGIN_C_DECLS

/*
 * texinfo: bap_table2of_monom_mpq
 * This data type implements a contiguous linear combination
 * of zipterms. 
 */

struct bap_table2of_monom_mpq
{
  ba0_int_p alloc;              // number of allocated entries for both arrays
  ba0_int_p size;               // number of used entries for both arrays
  bap_zipterm *zipterm;         // the array of zipterms
  ba0_mpq_t *coeff;               // the array of coefficients
};


/*
 * texinfo: bap_tableof_table2of_monom_mpq
 * This data type is a table of tables. 
 * However, if we forget technical details, it is a sequence of
 * pairs of the form (term, coefficient).
 * These pairs are called @dfn{monomials} in the documentation.
 */

struct bap_tableof_table2of_monom_mpq
{
  ba0_int_p alloc;              // the number of allocated entries of tab
  ba0_int_p size;               // the number of used entries in tab
  struct bap_table2of_monom_mpq **tab;
};


/*
 * texinfo: bap_clot_mpq
 * This data type implements a clot i.e. a sequence of monomials
 * sorted in decreasing order w.r.t. the lexicographic ordering
 * induced by the current ordering.
 * The coefficients of monomials are nonzero.
 * Monomials are sometimes considered as numbered starting from @math{0}
 * in the documentation.
 */

struct bap_clot_mpq
{
// the total number of allocated entries of (zipterm, coeff)
  ba0_int_p alloc;
// the total number of used entries i.e. of monomials
  ba0_int_p size;
// the termanager which handles zipterms
  struct bap_termanager tgest;
// the table of bap_table2of_monom_mpq 
  struct bap_tableof_table2of_monom_mpq tab;
// the ordering w.r.t. which zipterms are ordered
  bav_Iordering ordering;
};


extern BAP_DLL struct bap_clot_mpq *bap_new_clot_mpq (
    struct bav_term *);

extern BAP_DLL bool bap_is_zero_clot_mpq (
    struct bap_clot_mpq *);

extern BAP_DLL void bap_reverse_clot_mpq (
    struct bap_clot_mpq *);

extern BAP_DLL void bap_sort_clot_mpq (
    struct bap_clot_mpq *,
    ba0_int_p,
    ba0_int_p);

extern BAP_DLL void bap_change_ordering_clot_mpq (
    struct bap_clot_mpq *,
    bav_Iordering);

extern BAP_DLL ba0_garbage1_function bap_garbage1_clot_mpq;

extern BAP_DLL ba0_garbage2_function bap_garbage2_clot_mpq;

extern BAP_DLL ba0_copy_function bap_copy_clot_mpq;

/*
 * texinfo: bap_itermon_clot_mpq
 * This data type implements iterators of monomials over a clot.
 * In this context the monomial number @code{num.combined}
 * is located in @code{clot->tab[num.primary]->tab[num.secondary]}.
 * An iterator may be set outside a clot.
 */

struct bap_itermon_clot_mpq
{
  struct bap_clot_mpq *clot;
  struct bap_composite_number num;
};


extern BAP_DLL void bap_begin_itermon_clot_mpq (
    struct bap_itermon_clot_mpq *,
    struct bap_clot_mpq *);

extern BAP_DLL void bap_end_itermon_clot_mpq (
    struct bap_itermon_clot_mpq *,
    struct bap_clot_mpq *);

extern BAP_DLL bool bap_outof_itermon_clot_mpq (
    struct bap_itermon_clot_mpq *);

extern BAP_DLL void bap_next_itermon_clot_mpq (
    struct bap_itermon_clot_mpq *);

extern BAP_DLL void bap_prev_itermon_clot_mpq (
    struct bap_itermon_clot_mpq *);

extern BAP_DLL void bap_goto_itermon_clot_mpq (
    struct bap_itermon_clot_mpq *,
    ba0_int_p);

extern BAP_DLL ba0_int_p bap_number_itermon_clot_mpq (
    struct bap_itermon_clot_mpq *);

extern BAP_DLL void bap_term_itermon_clot_mpq (
    struct bav_term *,
    struct bap_itermon_clot_mpq *);

extern BAP_DLL ba0_mpq_t *bap_coeff_itermon_clot_mpq (
    struct bap_itermon_clot_mpq *);

extern BAP_DLL void bap_swap_itermon_clot_mpq (
    struct bap_itermon_clot_mpq *,
    struct bap_itermon_clot_mpq *);

/*
 * texinfo: bap_creator_clot_mpq
 * This data type permits to create a clot monomial per monomial.
 * Monomials are stored in the clot by increasing number.
 * The creator permits to create clots whose monomials are not
 * sorted by decreasing order w.r.t. the lexicographic ordering
 * defined by the ranking. 
 * Creators rely on iterators of monomials over an already existing
 * clot which is then overwritten.
 */

struct bap_creator_clot_mpq
{
  struct bap_itermon_clot_mpq iter;
// the number of entries allocated to any new bap_table2of_monom_mpq
  ba0_int_p table2of_monom_alloc;
};


extern BAP_DLL void bap_begin_creator_clot_mpq (
    struct bap_creator_clot_mpq *,
    struct bap_clot_mpq *,
    struct bav_term *,
    ba0_int_p);

extern BAP_DLL void bap_append_creator_clot_mpq (
    struct bap_creator_clot_mpq *,
    struct bap_clot_mpq *,
    ba0_int_p);

extern BAP_DLL void bap_write_creator_clot_mpq (
    struct bap_creator_clot_mpq *,
    struct bav_term *,
    ba0_mpq_t);

extern BAP_DLL void bap_write_neg_creator_clot_mpq (
    struct bap_creator_clot_mpq *,
    struct bav_term *,
    ba0_mpq_t);

extern BAP_DLL void bap_write_term_creator_clot_mpq (
    struct bap_creator_clot_mpq *,
    struct bav_term *);

extern BAP_DLL void bap_write_all_creator_clot_mpq (
    struct bap_creator_clot_mpq *,
    struct bap_clot_mpq *,
    ba0_int_p,
    ba0_int_p);

extern BAP_DLL void bap_write_neg_all_creator_clot_mpq (
    struct bap_creator_clot_mpq *,
    struct bap_clot_mpq *,
    ba0_int_p,
    ba0_int_p);

extern BAP_DLL void bap_write_mul_all_creator_clot_mpq (
    struct bap_creator_clot_mpq *,
    struct bap_clot_mpq *,
    ba0_mpq_t,
    ba0_int_p,
    ba0_int_p);

#   if defined BAD_FLAG_mpz

extern BAP_DLL void bap_write_exquo_all_creator_clot_mpz (
    struct bap_creator_clot_mpz *,
    struct bap_clot_mpz *,
    ba0_mpz_t,
    ba0_int_p,
    ba0_int_p);

#   endif

extern BAP_DLL void bap_close_creator_clot_mpq (
    struct bap_creator_clot_mpq *);

extern BAP_DLL void bap_goto_creator_clot_mpq (
    struct bap_creator_clot_mpq *,
    ba0_int_p);

extern BAP_DLL void bap_switch_ring_clot_mpq (
    struct bap_clot_mpq *,
    struct bav_differential_ring *);

END_C_DECLS
#   undef BAD_FLAG_mpq
#endif /* !BAP_CLOT_mpq_H */
#if !defined (BAP_CLOT_mint_hp_H)
#   define BAP_CLOT_mint_hp_H 1

/* #   include "bap_common.h" */
/* #   include "bap_termanager.h" */

#   define BAD_FLAG_mint_hp

BEGIN_C_DECLS

/*
 * texinfo: bap_table2of_monom_mint_hp
 * This data type implements a contiguous linear combination
 * of zipterms. 
 */

struct bap_table2of_monom_mint_hp
{
  ba0_int_p alloc;              // number of allocated entries for both arrays
  ba0_int_p size;               // number of used entries for both arrays
  bap_zipterm *zipterm;         // the array of zipterms
  ba0_mint_hp_t *coeff;               // the array of coefficients
};


/*
 * texinfo: bap_tableof_table2of_monom_mint_hp
 * This data type is a table of tables. 
 * However, if we forget technical details, it is a sequence of
 * pairs of the form (term, coefficient).
 * These pairs are called @dfn{monomials} in the documentation.
 */

struct bap_tableof_table2of_monom_mint_hp
{
  ba0_int_p alloc;              // the number of allocated entries of tab
  ba0_int_p size;               // the number of used entries in tab
  struct bap_table2of_monom_mint_hp **tab;
};


/*
 * texinfo: bap_clot_mint_hp
 * This data type implements a clot i.e. a sequence of monomials
 * sorted in decreasing order w.r.t. the lexicographic ordering
 * induced by the current ordering.
 * The coefficients of monomials are nonzero.
 * Monomials are sometimes considered as numbered starting from @math{0}
 * in the documentation.
 */

struct bap_clot_mint_hp
{
// the total number of allocated entries of (zipterm, coeff)
  ba0_int_p alloc;
// the total number of used entries i.e. of monomials
  ba0_int_p size;
// the termanager which handles zipterms
  struct bap_termanager tgest;
// the table of bap_table2of_monom_mint_hp 
  struct bap_tableof_table2of_monom_mint_hp tab;
// the ordering w.r.t. which zipterms are ordered
  bav_Iordering ordering;
};


extern BAP_DLL struct bap_clot_mint_hp *bap_new_clot_mint_hp (
    struct bav_term *);

extern BAP_DLL bool bap_is_zero_clot_mint_hp (
    struct bap_clot_mint_hp *);

extern BAP_DLL void bap_reverse_clot_mint_hp (
    struct bap_clot_mint_hp *);

extern BAP_DLL void bap_sort_clot_mint_hp (
    struct bap_clot_mint_hp *,
    ba0_int_p,
    ba0_int_p);

extern BAP_DLL void bap_change_ordering_clot_mint_hp (
    struct bap_clot_mint_hp *,
    bav_Iordering);

extern BAP_DLL ba0_garbage1_function bap_garbage1_clot_mint_hp;

extern BAP_DLL ba0_garbage2_function bap_garbage2_clot_mint_hp;

extern BAP_DLL ba0_copy_function bap_copy_clot_mint_hp;

/*
 * texinfo: bap_itermon_clot_mint_hp
 * This data type implements iterators of monomials over a clot.
 * In this context the monomial number @code{num.combined}
 * is located in @code{clot->tab[num.primary]->tab[num.secondary]}.
 * An iterator may be set outside a clot.
 */

struct bap_itermon_clot_mint_hp
{
  struct bap_clot_mint_hp *clot;
  struct bap_composite_number num;
};


extern BAP_DLL void bap_begin_itermon_clot_mint_hp (
    struct bap_itermon_clot_mint_hp *,
    struct bap_clot_mint_hp *);

extern BAP_DLL void bap_end_itermon_clot_mint_hp (
    struct bap_itermon_clot_mint_hp *,
    struct bap_clot_mint_hp *);

extern BAP_DLL bool bap_outof_itermon_clot_mint_hp (
    struct bap_itermon_clot_mint_hp *);

extern BAP_DLL void bap_next_itermon_clot_mint_hp (
    struct bap_itermon_clot_mint_hp *);

extern BAP_DLL void bap_prev_itermon_clot_mint_hp (
    struct bap_itermon_clot_mint_hp *);

extern BAP_DLL void bap_goto_itermon_clot_mint_hp (
    struct bap_itermon_clot_mint_hp *,
    ba0_int_p);

extern BAP_DLL ba0_int_p bap_number_itermon_clot_mint_hp (
    struct bap_itermon_clot_mint_hp *);

extern BAP_DLL void bap_term_itermon_clot_mint_hp (
    struct bav_term *,
    struct bap_itermon_clot_mint_hp *);

extern BAP_DLL ba0_mint_hp_t *bap_coeff_itermon_clot_mint_hp (
    struct bap_itermon_clot_mint_hp *);

extern BAP_DLL void bap_swap_itermon_clot_mint_hp (
    struct bap_itermon_clot_mint_hp *,
    struct bap_itermon_clot_mint_hp *);

/*
 * texinfo: bap_creator_clot_mint_hp
 * This data type permits to create a clot monomial per monomial.
 * Monomials are stored in the clot by increasing number.
 * The creator permits to create clots whose monomials are not
 * sorted by decreasing order w.r.t. the lexicographic ordering
 * defined by the ranking. 
 * Creators rely on iterators of monomials over an already existing
 * clot which is then overwritten.
 */

struct bap_creator_clot_mint_hp
{
  struct bap_itermon_clot_mint_hp iter;
// the number of entries allocated to any new bap_table2of_monom_mint_hp
  ba0_int_p table2of_monom_alloc;
};


extern BAP_DLL void bap_begin_creator_clot_mint_hp (
    struct bap_creator_clot_mint_hp *,
    struct bap_clot_mint_hp *,
    struct bav_term *,
    ba0_int_p);

extern BAP_DLL void bap_append_creator_clot_mint_hp (
    struct bap_creator_clot_mint_hp *,
    struct bap_clot_mint_hp *,
    ba0_int_p);

extern BAP_DLL void bap_write_creator_clot_mint_hp (
    struct bap_creator_clot_mint_hp *,
    struct bav_term *,
    ba0_mint_hp_t);

extern BAP_DLL void bap_write_neg_creator_clot_mint_hp (
    struct bap_creator_clot_mint_hp *,
    struct bav_term *,
    ba0_mint_hp_t);

extern BAP_DLL void bap_write_term_creator_clot_mint_hp (
    struct bap_creator_clot_mint_hp *,
    struct bav_term *);

extern BAP_DLL void bap_write_all_creator_clot_mint_hp (
    struct bap_creator_clot_mint_hp *,
    struct bap_clot_mint_hp *,
    ba0_int_p,
    ba0_int_p);

extern BAP_DLL void bap_write_neg_all_creator_clot_mint_hp (
    struct bap_creator_clot_mint_hp *,
    struct bap_clot_mint_hp *,
    ba0_int_p,
    ba0_int_p);

extern BAP_DLL void bap_write_mul_all_creator_clot_mint_hp (
    struct bap_creator_clot_mint_hp *,
    struct bap_clot_mint_hp *,
    ba0_mint_hp_t,
    ba0_int_p,
    ba0_int_p);

#   if defined BAD_FLAG_mpz

extern BAP_DLL void bap_write_exquo_all_creator_clot_mpz (
    struct bap_creator_clot_mpz *,
    struct bap_clot_mpz *,
    ba0_mpz_t,
    ba0_int_p,
    ba0_int_p);

#   endif

extern BAP_DLL void bap_close_creator_clot_mint_hp (
    struct bap_creator_clot_mint_hp *);

extern BAP_DLL void bap_goto_creator_clot_mint_hp (
    struct bap_creator_clot_mint_hp *,
    ba0_int_p);

extern BAP_DLL void bap_switch_ring_clot_mint_hp (
    struct bap_clot_mint_hp *,
    struct bav_differential_ring *);

END_C_DECLS
#   undef BAD_FLAG_mint_hp
#endif /* !BAP_CLOT_mint_hp_H */
#if !defined (BAP_TERMSTRIPPER_H)
#   define BAP_TERMSTRIPPER_H 1

/* #   include "bap_common.h" */

#   define BAP_TERMSTRIPPER_SIZE 3

BEGIN_C_DECLS

/* 
 * texinfo: bap_termstripper
 * This data type is involved in the process of taking coefficients of 
 * polynomials w.r.t. any variable. 
 *
 * It aims at stripping terms i.e. at cutting, in terms, all ranks 
 * which depend on variables strictly greater than a given variable.
 * The ordering w.r.t. which variables are compared is often not
 * the ordering of the clot. A stripping operation is thus described
 * by a pair (@code{variable}, @code{ordering}).
 *
 * The variable is allowed to be @code{BAV_NOT_A_VARIABLE} (i.e. @math{0}).
 * In that case, all variables are cut.
 * It is allowed to be @math{-1}. In that case, no variables are cut.
 *
 * It happens that a polynomial is obtained by performing a sequence
 * of stripping operations. This sequence, which is necessary to
 * recover the right stripped terms, is recorded.
 */

struct bap_termstripper
{
// the number of stripping operations recorded in tab
  ba0_int_p size;
  struct _tab
  {
    bav_Iordering ordering;
    struct bav_variable *varmax;
  } tab[BAP_TERMSTRIPPER_SIZE];
};


extern BAP_DLL void bap_init_set_termstripper (
    struct bap_termstripper *,
    struct bav_variable *,
    bav_Iordering);

extern BAP_DLL void bap_set_termstripper (
    struct bap_termstripper *,
    struct bap_termstripper *);

extern BAP_DLL void bap_change_ordering_termstripper (
    struct bap_termstripper *,
    bav_Iordering);

extern BAP_DLL void bap_change_variable_termstripper (
    struct bap_termstripper *,
    struct bav_variable *);

extern BAP_DLL void bap_append_termstripper (
    struct bap_termstripper *,
    struct bav_variable *,
    bav_Iordering);

extern BAP_DLL bool bap_identity_termstripper (
    struct bap_termstripper *,
    bav_Iordering);

extern BAP_DLL void bap_strip_term_termstripper (
    struct bav_term *,
    bav_Iordering,
    struct bap_termstripper *);

extern BAP_DLL void bap_switch_ring_termstripper (
    struct bap_termstripper *,
    struct bav_differential_ring *);

END_C_DECLS
#endif /* !BAP_TERMSTRIPPER_H */
#if !defined (BAP_SEQUENTIAL_ACCESS_H)
#   define BAP_SEQUENTIAL_ACCESS_H 1

/* #   include "bap_common.h" */

BEGIN_C_DECLS

/*
 * texinfo: bap_sequential_access
 * This data type permits to define a subsequence of monomials in a clot. 
 */

struct bap_sequential_access
{
// the index of the first monomial of the subsequence
  ba0_int_p first;
// the index of the first monomial following the subsequence
  ba0_int_p after;
};


END_C_DECLS
#endif /* !BAP_SEQUENTIAL_ACCESS_H */
#if !defined (BAP_INDEXED_ACCESS_H)
#   define BAP_INDEXED_ACCESS_H 1

/* #   include "bap_common.h" */

BEGIN_C_DECLS

/*
 * texinfo: bap_indexed_access
 * This data type permits to define a sequence of non consecutive 
 * monomials in a clot or in a polynomial, in any order. 
 * It is a table of tables of monomial numbers.
 * From a logical point of view, it is a sequence of monomial numbers.
 */

struct bap_indexed_access
{
// the total number of entries allocated to tab
  ba0_int_p alloc;
// the total number of entries used in tab
  ba0_int_p size;
  struct ba0_tableof_tableof_int_p tab;
};


extern BAP_DLL void bap_init_indexed_access (
    struct bap_indexed_access *);

extern BAP_DLL void bap_realloc_indexed_access (
    struct bap_indexed_access *,
    ba0_int_p);

extern BAP_DLL void bap_reverse_indexed_access (
    struct bap_indexed_access *);

extern BAP_DLL ba0_garbage1_function bap_garbage1_indexed_access;

extern BAP_DLL ba0_garbage2_function bap_garbage2_indexed_access;

END_C_DECLS
#endif /* !BAP_INDEXED_ACCESS_H */
#if !defined (BAP_ITERATOR_INDEX_H)
#   define BAP_ITERATOR_INDEX_H 1

/* #   include "bap_common.h" */
/* #   include "bap_indexed_access.h" */

BEGIN_C_DECLS

/*
 * texinfo: bap_iterator_indexed_access
 * This data structure implements an iterator over 
 * a @code{bap_indexed_access} structure.
 */

struct bap_iterator_indexed_access
{
  struct bap_indexed_access *ind;       // the structure being read
  struct bap_composite_number num;      // the current index
};


extern BAP_DLL void bap_begin_iterator_indexed_access (
    struct bap_iterator_indexed_access *,
    struct bap_indexed_access *);

extern BAP_DLL void bap_end_iterator_indexed_access (
    struct bap_iterator_indexed_access *,
    struct bap_indexed_access *);

extern BAP_DLL bool bap_outof_iterator_indexed_access (
    struct bap_iterator_indexed_access *);

extern BAP_DLL void bap_next_iterator_indexed_access (
    struct bap_iterator_indexed_access *);

extern BAP_DLL void bap_prev_iterator_indexed_access (
    struct bap_iterator_indexed_access *);

extern BAP_DLL void bap_goto_iterator_indexed_access (
    struct bap_iterator_indexed_access *,
    ba0_int_p);

extern BAP_DLL ba0_int_p bap_index_iterator_indexed_access (
    struct bap_iterator_indexed_access *);

extern BAP_DLL ba0_int_p bap_read_iterator_indexed_access (
    struct bap_iterator_indexed_access *);

extern BAP_DLL void bap_swapindex_iterator_indexed_access (
    struct bap_iterator_indexed_access *,
    struct bap_iterator_indexed_access *);

extern BAP_DLL void bap_set_iterator_indexed_access (
    struct bap_iterator_indexed_access *,
    struct bap_iterator_indexed_access *);


/*
 * texinfo: bap_creator_indexed_access
 * This data structure permits to rewrite the content of a
 * @code{bap_indexed_access} structure, provided that the
 * already allocated tables are large enough.
 */

struct bap_creator_indexed_access
{
  struct bap_indexed_access *ind;       // the structure being rewritten
  struct bap_composite_number num;      // the current index
};


extern BAP_DLL void bap_begin_creator_indexed_access (
    struct bap_creator_indexed_access *,
    struct bap_indexed_access *);

extern BAP_DLL void bap_write_creator_indexed_access (
    struct bap_creator_indexed_access *,
    ba0_int_p);

extern BAP_DLL void bap_close_creator_indexed_access (
    struct bap_creator_indexed_access *);

END_C_DECLS
#endif /* !BAP_ITERATOR_INDEX_H */
#if !defined (BAP_POLYNOM_mpz_H)
#   define BAP_POLYNOM_mpz_H 1

/* #   include "bap_common.h" */
/* #   include "bap_clot_mpz.h" */
/* #   include "bap_sequential_access.h" */
/* #   include "bap_indexed_access.h" */
/* #   include "bap_termstripper.h" */

#   define BAD_FLAG_mpz

BEGIN_C_DECLS

/*
 * texinfo: bap_polynom_mpz
 * This data type implements polynomials.
 * Note that the @code{total_rank} field contains the exact
 * total rank of the polynomial while the @code{total_rank} field 
 * of the term manager of its clot only contains a multiple
 * of this total rank.
 */

struct bap_polynom_mpz
{
  struct bap_clot_mpz *clot;  // the underlying clot
  struct bav_term total_rank;   // the total rank of the polynomial
  bool readonly;                // true if modifications are forbidden
  enum bap_typeof_monom_access access;
  struct bap_sequential_access seq;     // in case of a sequential access
  struct bap_indexed_access ind;        // in case of an indexed access
  struct bap_termstripper tstrip;       // for stripping terms
};


#   define BAP_NOT_A_POLYNOM_mpz	(struct bap_polynom_mpz*)0

struct bap_tableof_polynom_mpz
{
  ba0_int_p alloc;
  ba0_int_p size;
  struct bap_polynom_mpz **tab;
};

struct bap_listof_polynom_mpz
{
  struct bap_polynom_mpz *value;
  struct bap_listof_polynom_mpz *next;
};

struct bap_tableof_tableof_polynom_mpz
{
  ba0_int_p alloc;
  ba0_int_p size;
  struct bap_tableof_polynom_mpz **tab;
};

struct bap_tableof_listof_polynom_mpz
{
  ba0_int_p alloc;
  ba0_int_p size;
  struct bap_listof_polynom_mpz **tab;
};

extern BAP_DLL void bap_init_polynom_mpz (
    struct bap_polynom_mpz *);

extern BAP_DLL void bap_init_readonly_polynom_mpz (
    struct bap_polynom_mpz *);

extern BAP_DLL void bap_init_polynom_one_mpz (
    struct bap_polynom_mpz *);

extern BAP_DLL void bap_init_polynom_crk_mpz (
    struct bap_polynom_mpz *,
    ba0_mpz_t,
    struct bav_rank *);

extern BAP_DLL struct bap_polynom_mpz *bap_new_polynom_mpz (
    void);

extern BAP_DLL struct bap_polynom_mpz *bap_new_readonly_polynom_mpz (
    void);

extern BAP_DLL struct bap_polynom_mpz *bap_new_polynom_one_mpz (
    void);

extern BAP_DLL struct bap_polynom_mpz *bap_new_polynom_crk_mpz (
    ba0_mpz_t,
    struct bav_rank *);

extern BAP_DLL void bap_set_polynom_zero_mpz (
    struct bap_polynom_mpz *);

extern BAP_DLL void bap_set_polynom_one_mpz (
    struct bap_polynom_mpz *);

extern BAP_DLL void bap_set_polynom_crk_mpz (
    struct bap_polynom_mpz *,
    ba0_mpz_t,
    struct bav_rank *);

extern BAP_DLL void bap_set_polynom_variable_mpz (
    struct bap_polynom_mpz *,
    struct bav_variable *,
    bav_Idegree);

extern BAP_DLL void bap_set_polynom_mpz (
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *);

extern BAP_DLL void bap_set_tableof_polynom_mpz (
    struct bap_tableof_polynom_mpz *,
    struct bap_tableof_polynom_mpz *);

extern BAP_DLL void bap_set_tableof_tableof_polynom_mpz (
    struct bap_tableof_tableof_polynom_mpz *,
    struct bap_tableof_tableof_polynom_mpz *);

extern BAP_DLL void bap_set_readonly_polynom_mpz (
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *);

extern BAP_DLL void bap_set_polynom_term_mpz (
    struct bap_polynom_mpz *,
    struct bav_term *);

extern BAP_DLL void bap_set_polynom_monom_mpz (
    struct bap_polynom_mpz *,
    ba0_mpz_t,
    struct bav_term *);

extern BAP_DLL void bap_set_total_rank_polynom_mpz (
    struct bap_polynom_mpz *);

extern BAP_DLL bool bap_is_zero_polynom_mpz (
    struct bap_polynom_mpz *);

extern BAP_DLL bool bap_is_one_polynom_mpz (
    struct bap_polynom_mpz *);

extern BAP_DLL bool bap_is_numeric_polynom_mpz (
    struct bap_polynom_mpz *);

extern BAP_DLL bool bap_is_univariate_polynom_mpz (
    struct bap_polynom_mpz *);

extern BAP_DLL bool bap_depend_polynom_mpz (
    struct bap_polynom_mpz *,
    struct bav_variable *);

extern BAP_DLL bool bap_depend_only_polynom_mpz (
    struct bap_polynom_mpz *,
    struct bav_tableof_variable *);

extern BAP_DLL bool bap_is_variable_polynom_mpz (
    struct bap_polynom_mpz *);

extern BAP_DLL bool bap_is_solved_polynom_mpz (
    struct bap_polynom_mpz *);

extern BAP_DLL bool bap_is_derivative_minus_independent_polynom_mpz (
    struct bap_polynom_mpz *);

extern BAP_DLL bool bap_is_rank_minus_monom_polynom_mpz (
    struct bap_polynom_mpz *);

extern BAP_DLL bool bap_are_disjoint_polynom_mpz (
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *);

extern BAP_DLL enum ba0_compare_code bap_compare_polynom_mpz (
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *);

extern BAP_DLL bool bap_equal_polynom_mpz (
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *);

extern BAP_DLL ba0_cmp_function bap_gt_rank_polynom_mpz;

extern BAP_DLL ba0_cmp_function bap_lt_rank_polynom_mpz;

extern BAP_DLL bool bap_equal_rank_polynom_mpz (
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *);

extern BAP_DLL int bap_compare_rank_polynom_mpz (
    const void *,
    const void *);

extern BAP_DLL void bap_reverse_polynom_mpz (
    struct bap_polynom_mpz *);

extern BAP_DLL void bap_mark_indets_polynom_mpz (
    struct bav_dictionary_variable *,
    struct bav_tableof_variable *,
    struct bap_polynom_mpz *);

extern BAP_DLL void bap_mark_indets_tableof_polynom_mpz (
    struct bav_dictionary_variable *,
    struct bav_tableof_variable *,
    struct bap_tableof_polynom_mpz *);

extern BAP_DLL void bap_mark_indets_listof_polynom_mpz (
    struct bav_dictionary_variable *,
    struct bav_tableof_variable *,
    struct bap_listof_polynom_mpz *);

extern BAP_DLL void bap_mark_ranks_polynom_mpz (
    struct bap_polynom_mpz *);

extern BAP_DLL void bap_sort_polynom_mpz (
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *);

extern BAP_DLL void bap_physort_polynom_mpz (
    struct bap_polynom_mpz *);

extern BAP_DLL ba0_int_p bap_nbmon_polynom_mpz (
    struct bap_polynom_mpz *);

extern BAP_DLL void bap_minimal_total_rank_polynom_mpz (
    struct bav_term *,
    struct bap_polynom_mpz *);

extern BAP_DLL void bap_leading_term_polynom_mpz (
    struct bav_term *,
    struct bap_polynom_mpz *);

extern BAP_DLL struct bav_variable *bap_leader_polynom_mpz (
    struct bap_polynom_mpz *);

extern BAP_DLL struct bav_rank bap_rank_polynom_mpz (
    struct bap_polynom_mpz *);

extern BAP_DLL bav_Idegree bap_leading_degree_polynom_mpz (
    struct bap_polynom_mpz *);

extern BAP_DLL bav_Idegree bap_degree_polynom_mpz (
    struct bap_polynom_mpz *,
    struct bav_variable *);

extern BAP_DLL bav_Idegree bap_total_degree_polynom_mpz (
    struct bap_polynom_mpz *);

extern BAP_DLL bav_Iorder bap_total_order_polynom_mpz (
    struct bap_polynom_mpz *);

extern BAP_DLL ba0_mpz_t *bap_numeric_initial_polynom_mpz (
    struct bap_polynom_mpz *);

extern BAP_DLL void bap_initial_and_reductum_polynom_mpz (
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *);

extern BAP_DLL void bap_initial_polynom_mpz (
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *);

extern BAP_DLL void bap_reductum_polynom_mpz (
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *);

extern BAP_DLL void bap_initial_and_reductum2_polynom_mpz (
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    struct bav_variable *);

extern BAP_DLL void bap_initial2_polynom_mpz (
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    struct bav_variable *);

extern BAP_DLL void bap_reductum2_polynom_mpz (
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    struct bav_variable *);

extern BAP_DLL void bap_coeff2_polynom_mpz (
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    struct bav_variable *,
    bav_Idegree);

extern BAP_DLL void bap_lcoeff_and_reductum_polynom_mpz (
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    struct bav_variable *);

extern BAP_DLL void bap_lcoeff_polynom_mpz (
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    struct bav_variable *);

extern BAP_DLL void bap_coeff_polynom_mpz (
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    struct bav_variable *,
    bav_Idegree);

extern BAP_DLL void bap_coeff_and_reductum_polynom_mpz (
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    struct bav_variable *,
    bav_Idegree);

extern BAP_DLL void bap_replace_initial_polynom_mpz (
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *);

extern BAP_DLL void bap_separant_polynom_mpz (
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *);

extern BAP_DLL void bap_separant2_polynom_mpz (
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    struct bav_variable *);

extern BAP_DLL void bap_sort_tableof_polynom_mpz (
    struct bap_tableof_polynom_mpz *,
    enum ba0_sort_mode);

extern BAP_DLL unsigned ba0_int_p bap_sizeof_polynom_mpz (
    struct bap_polynom_mpz *,
    enum ba0_garbage_code);

extern BAP_DLL void bap_switch_ring_polynom_mpz (
    struct bap_polynom_mpz *,
    struct bav_differential_ring *);

extern BAP_DLL ba0_garbage1_function bap_garbage1_polynom_mpz;

extern BAP_DLL ba0_garbage2_function bap_garbage2_polynom_mpz;

extern BAP_DLL ba0_copy_function bap_copy_polynom_mpz;

END_C_DECLS
#   undef  BAD_FLAG_mpz
#endif /* !BAP_POLYNOM_mpz_H */
#if !defined (BAP_POLYNOM_mpzm_H)
#   define BAP_POLYNOM_mpzm_H 1

/* #   include "bap_common.h" */
/* #   include "bap_clot_mpzm.h" */
/* #   include "bap_sequential_access.h" */
/* #   include "bap_indexed_access.h" */
/* #   include "bap_termstripper.h" */

#   define BAD_FLAG_mpzm

BEGIN_C_DECLS

/*
 * texinfo: bap_polynom_mpzm
 * This data type implements polynomials.
 * Note that the @code{total_rank} field contains the exact
 * total rank of the polynomial while the @code{total_rank} field 
 * of the term manager of its clot only contains a multiple
 * of this total rank.
 */

struct bap_polynom_mpzm
{
  struct bap_clot_mpzm *clot;  // the underlying clot
  struct bav_term total_rank;   // the total rank of the polynomial
  bool readonly;                // true if modifications are forbidden
  enum bap_typeof_monom_access access;
  struct bap_sequential_access seq;     // in case of a sequential access
  struct bap_indexed_access ind;        // in case of an indexed access
  struct bap_termstripper tstrip;       // for stripping terms
};


#   define BAP_NOT_A_POLYNOM_mpzm	(struct bap_polynom_mpzm*)0

struct bap_tableof_polynom_mpzm
{
  ba0_int_p alloc;
  ba0_int_p size;
  struct bap_polynom_mpzm **tab;
};

struct bap_listof_polynom_mpzm
{
  struct bap_polynom_mpzm *value;
  struct bap_listof_polynom_mpzm *next;
};

struct bap_tableof_tableof_polynom_mpzm
{
  ba0_int_p alloc;
  ba0_int_p size;
  struct bap_tableof_polynom_mpzm **tab;
};

struct bap_tableof_listof_polynom_mpzm
{
  ba0_int_p alloc;
  ba0_int_p size;
  struct bap_listof_polynom_mpzm **tab;
};

extern BAP_DLL void bap_init_polynom_mpzm (
    struct bap_polynom_mpzm *);

extern BAP_DLL void bap_init_readonly_polynom_mpzm (
    struct bap_polynom_mpzm *);

extern BAP_DLL void bap_init_polynom_one_mpzm (
    struct bap_polynom_mpzm *);

extern BAP_DLL void bap_init_polynom_crk_mpzm (
    struct bap_polynom_mpzm *,
    ba0_mpzm_t,
    struct bav_rank *);

extern BAP_DLL struct bap_polynom_mpzm *bap_new_polynom_mpzm (
    void);

extern BAP_DLL struct bap_polynom_mpzm *bap_new_readonly_polynom_mpzm (
    void);

extern BAP_DLL struct bap_polynom_mpzm *bap_new_polynom_one_mpzm (
    void);

extern BAP_DLL struct bap_polynom_mpzm *bap_new_polynom_crk_mpzm (
    ba0_mpzm_t,
    struct bav_rank *);

extern BAP_DLL void bap_set_polynom_zero_mpzm (
    struct bap_polynom_mpzm *);

extern BAP_DLL void bap_set_polynom_one_mpzm (
    struct bap_polynom_mpzm *);

extern BAP_DLL void bap_set_polynom_crk_mpzm (
    struct bap_polynom_mpzm *,
    ba0_mpzm_t,
    struct bav_rank *);

extern BAP_DLL void bap_set_polynom_variable_mpzm (
    struct bap_polynom_mpzm *,
    struct bav_variable *,
    bav_Idegree);

extern BAP_DLL void bap_set_polynom_mpzm (
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *);

extern BAP_DLL void bap_set_tableof_polynom_mpzm (
    struct bap_tableof_polynom_mpzm *,
    struct bap_tableof_polynom_mpzm *);

extern BAP_DLL void bap_set_tableof_tableof_polynom_mpzm (
    struct bap_tableof_tableof_polynom_mpzm *,
    struct bap_tableof_tableof_polynom_mpzm *);

extern BAP_DLL void bap_set_readonly_polynom_mpzm (
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *);

extern BAP_DLL void bap_set_polynom_term_mpzm (
    struct bap_polynom_mpzm *,
    struct bav_term *);

extern BAP_DLL void bap_set_polynom_monom_mpzm (
    struct bap_polynom_mpzm *,
    ba0_mpzm_t,
    struct bav_term *);

extern BAP_DLL void bap_set_total_rank_polynom_mpzm (
    struct bap_polynom_mpzm *);

extern BAP_DLL bool bap_is_zero_polynom_mpzm (
    struct bap_polynom_mpzm *);

extern BAP_DLL bool bap_is_one_polynom_mpzm (
    struct bap_polynom_mpzm *);

extern BAP_DLL bool bap_is_numeric_polynom_mpzm (
    struct bap_polynom_mpzm *);

extern BAP_DLL bool bap_is_univariate_polynom_mpzm (
    struct bap_polynom_mpzm *);

extern BAP_DLL bool bap_depend_polynom_mpzm (
    struct bap_polynom_mpzm *,
    struct bav_variable *);

extern BAP_DLL bool bap_depend_only_polynom_mpzm (
    struct bap_polynom_mpzm *,
    struct bav_tableof_variable *);

extern BAP_DLL bool bap_is_variable_polynom_mpzm (
    struct bap_polynom_mpzm *);

extern BAP_DLL bool bap_is_solved_polynom_mpzm (
    struct bap_polynom_mpzm *);

extern BAP_DLL bool bap_is_derivative_minus_independent_polynom_mpzm (
    struct bap_polynom_mpzm *);

extern BAP_DLL bool bap_is_rank_minus_monom_polynom_mpzm (
    struct bap_polynom_mpzm *);

extern BAP_DLL bool bap_are_disjoint_polynom_mpzm (
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *);

extern BAP_DLL enum ba0_compare_code bap_compare_polynom_mpzm (
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *);

extern BAP_DLL bool bap_equal_polynom_mpzm (
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *);

extern BAP_DLL ba0_cmp_function bap_gt_rank_polynom_mpzm;

extern BAP_DLL ba0_cmp_function bap_lt_rank_polynom_mpzm;

extern BAP_DLL bool bap_equal_rank_polynom_mpzm (
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *);

extern BAP_DLL int bap_compare_rank_polynom_mpzm (
    const void *,
    const void *);

extern BAP_DLL void bap_reverse_polynom_mpzm (
    struct bap_polynom_mpzm *);

extern BAP_DLL void bap_mark_indets_polynom_mpzm (
    struct bav_dictionary_variable *,
    struct bav_tableof_variable *,
    struct bap_polynom_mpzm *);

extern BAP_DLL void bap_mark_indets_tableof_polynom_mpzm (
    struct bav_dictionary_variable *,
    struct bav_tableof_variable *,
    struct bap_tableof_polynom_mpzm *);

extern BAP_DLL void bap_mark_indets_listof_polynom_mpzm (
    struct bav_dictionary_variable *,
    struct bav_tableof_variable *,
    struct bap_listof_polynom_mpzm *);

extern BAP_DLL void bap_mark_ranks_polynom_mpzm (
    struct bap_polynom_mpzm *);

extern BAP_DLL void bap_sort_polynom_mpzm (
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *);

extern BAP_DLL void bap_physort_polynom_mpzm (
    struct bap_polynom_mpzm *);

extern BAP_DLL ba0_int_p bap_nbmon_polynom_mpzm (
    struct bap_polynom_mpzm *);

extern BAP_DLL void bap_minimal_total_rank_polynom_mpzm (
    struct bav_term *,
    struct bap_polynom_mpzm *);

extern BAP_DLL void bap_leading_term_polynom_mpzm (
    struct bav_term *,
    struct bap_polynom_mpzm *);

extern BAP_DLL struct bav_variable *bap_leader_polynom_mpzm (
    struct bap_polynom_mpzm *);

extern BAP_DLL struct bav_rank bap_rank_polynom_mpzm (
    struct bap_polynom_mpzm *);

extern BAP_DLL bav_Idegree bap_leading_degree_polynom_mpzm (
    struct bap_polynom_mpzm *);

extern BAP_DLL bav_Idegree bap_degree_polynom_mpzm (
    struct bap_polynom_mpzm *,
    struct bav_variable *);

extern BAP_DLL bav_Idegree bap_total_degree_polynom_mpzm (
    struct bap_polynom_mpzm *);

extern BAP_DLL bav_Iorder bap_total_order_polynom_mpzm (
    struct bap_polynom_mpzm *);

extern BAP_DLL ba0_mpzm_t *bap_numeric_initial_polynom_mpzm (
    struct bap_polynom_mpzm *);

extern BAP_DLL void bap_initial_and_reductum_polynom_mpzm (
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *);

extern BAP_DLL void bap_initial_polynom_mpzm (
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *);

extern BAP_DLL void bap_reductum_polynom_mpzm (
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *);

extern BAP_DLL void bap_initial_and_reductum2_polynom_mpzm (
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *,
    struct bav_variable *);

extern BAP_DLL void bap_initial2_polynom_mpzm (
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *,
    struct bav_variable *);

extern BAP_DLL void bap_reductum2_polynom_mpzm (
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *,
    struct bav_variable *);

extern BAP_DLL void bap_coeff2_polynom_mpzm (
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *,
    struct bav_variable *,
    bav_Idegree);

extern BAP_DLL void bap_lcoeff_and_reductum_polynom_mpzm (
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *,
    struct bav_variable *);

extern BAP_DLL void bap_lcoeff_polynom_mpzm (
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *,
    struct bav_variable *);

extern BAP_DLL void bap_coeff_polynom_mpzm (
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *,
    struct bav_variable *,
    bav_Idegree);

extern BAP_DLL void bap_coeff_and_reductum_polynom_mpzm (
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *,
    struct bav_variable *,
    bav_Idegree);

extern BAP_DLL void bap_replace_initial_polynom_mpzm (
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *);

extern BAP_DLL void bap_separant_polynom_mpzm (
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *);

extern BAP_DLL void bap_separant2_polynom_mpzm (
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *,
    struct bav_variable *);

extern BAP_DLL void bap_sort_tableof_polynom_mpzm (
    struct bap_tableof_polynom_mpzm *,
    enum ba0_sort_mode);

extern BAP_DLL unsigned ba0_int_p bap_sizeof_polynom_mpzm (
    struct bap_polynom_mpzm *,
    enum ba0_garbage_code);

extern BAP_DLL void bap_switch_ring_polynom_mpzm (
    struct bap_polynom_mpzm *,
    struct bav_differential_ring *);

extern BAP_DLL ba0_garbage1_function bap_garbage1_polynom_mpzm;

extern BAP_DLL ba0_garbage2_function bap_garbage2_polynom_mpzm;

extern BAP_DLL ba0_copy_function bap_copy_polynom_mpzm;

END_C_DECLS
#   undef  BAD_FLAG_mpzm
#endif /* !BAP_POLYNOM_mpzm_H */
#if !defined (BAP_POLYNOM_mpq_H)
#   define BAP_POLYNOM_mpq_H 1

/* #   include "bap_common.h" */
/* #   include "bap_clot_mpq.h" */
/* #   include "bap_sequential_access.h" */
/* #   include "bap_indexed_access.h" */
/* #   include "bap_termstripper.h" */

#   define BAD_FLAG_mpq

BEGIN_C_DECLS

/*
 * texinfo: bap_polynom_mpq
 * This data type implements polynomials.
 * Note that the @code{total_rank} field contains the exact
 * total rank of the polynomial while the @code{total_rank} field 
 * of the term manager of its clot only contains a multiple
 * of this total rank.
 */

struct bap_polynom_mpq
{
  struct bap_clot_mpq *clot;  // the underlying clot
  struct bav_term total_rank;   // the total rank of the polynomial
  bool readonly;                // true if modifications are forbidden
  enum bap_typeof_monom_access access;
  struct bap_sequential_access seq;     // in case of a sequential access
  struct bap_indexed_access ind;        // in case of an indexed access
  struct bap_termstripper tstrip;       // for stripping terms
};


#   define BAP_NOT_A_POLYNOM_mpq	(struct bap_polynom_mpq*)0

struct bap_tableof_polynom_mpq
{
  ba0_int_p alloc;
  ba0_int_p size;
  struct bap_polynom_mpq **tab;
};

struct bap_listof_polynom_mpq
{
  struct bap_polynom_mpq *value;
  struct bap_listof_polynom_mpq *next;
};

struct bap_tableof_tableof_polynom_mpq
{
  ba0_int_p alloc;
  ba0_int_p size;
  struct bap_tableof_polynom_mpq **tab;
};

struct bap_tableof_listof_polynom_mpq
{
  ba0_int_p alloc;
  ba0_int_p size;
  struct bap_listof_polynom_mpq **tab;
};

extern BAP_DLL void bap_init_polynom_mpq (
    struct bap_polynom_mpq *);

extern BAP_DLL void bap_init_readonly_polynom_mpq (
    struct bap_polynom_mpq *);

extern BAP_DLL void bap_init_polynom_one_mpq (
    struct bap_polynom_mpq *);

extern BAP_DLL void bap_init_polynom_crk_mpq (
    struct bap_polynom_mpq *,
    ba0_mpq_t,
    struct bav_rank *);

extern BAP_DLL struct bap_polynom_mpq *bap_new_polynom_mpq (
    void);

extern BAP_DLL struct bap_polynom_mpq *bap_new_readonly_polynom_mpq (
    void);

extern BAP_DLL struct bap_polynom_mpq *bap_new_polynom_one_mpq (
    void);

extern BAP_DLL struct bap_polynom_mpq *bap_new_polynom_crk_mpq (
    ba0_mpq_t,
    struct bav_rank *);

extern BAP_DLL void bap_set_polynom_zero_mpq (
    struct bap_polynom_mpq *);

extern BAP_DLL void bap_set_polynom_one_mpq (
    struct bap_polynom_mpq *);

extern BAP_DLL void bap_set_polynom_crk_mpq (
    struct bap_polynom_mpq *,
    ba0_mpq_t,
    struct bav_rank *);

extern BAP_DLL void bap_set_polynom_variable_mpq (
    struct bap_polynom_mpq *,
    struct bav_variable *,
    bav_Idegree);

extern BAP_DLL void bap_set_polynom_mpq (
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *);

extern BAP_DLL void bap_set_tableof_polynom_mpq (
    struct bap_tableof_polynom_mpq *,
    struct bap_tableof_polynom_mpq *);

extern BAP_DLL void bap_set_tableof_tableof_polynom_mpq (
    struct bap_tableof_tableof_polynom_mpq *,
    struct bap_tableof_tableof_polynom_mpq *);

extern BAP_DLL void bap_set_readonly_polynom_mpq (
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *);

extern BAP_DLL void bap_set_polynom_term_mpq (
    struct bap_polynom_mpq *,
    struct bav_term *);

extern BAP_DLL void bap_set_polynom_monom_mpq (
    struct bap_polynom_mpq *,
    ba0_mpq_t,
    struct bav_term *);

extern BAP_DLL void bap_set_total_rank_polynom_mpq (
    struct bap_polynom_mpq *);

extern BAP_DLL bool bap_is_zero_polynom_mpq (
    struct bap_polynom_mpq *);

extern BAP_DLL bool bap_is_one_polynom_mpq (
    struct bap_polynom_mpq *);

extern BAP_DLL bool bap_is_numeric_polynom_mpq (
    struct bap_polynom_mpq *);

extern BAP_DLL bool bap_is_univariate_polynom_mpq (
    struct bap_polynom_mpq *);

extern BAP_DLL bool bap_depend_polynom_mpq (
    struct bap_polynom_mpq *,
    struct bav_variable *);

extern BAP_DLL bool bap_depend_only_polynom_mpq (
    struct bap_polynom_mpq *,
    struct bav_tableof_variable *);

extern BAP_DLL bool bap_is_variable_polynom_mpq (
    struct bap_polynom_mpq *);

extern BAP_DLL bool bap_is_solved_polynom_mpq (
    struct bap_polynom_mpq *);

extern BAP_DLL bool bap_is_derivative_minus_independent_polynom_mpq (
    struct bap_polynom_mpq *);

extern BAP_DLL bool bap_is_rank_minus_monom_polynom_mpq (
    struct bap_polynom_mpq *);

extern BAP_DLL bool bap_are_disjoint_polynom_mpq (
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *);

extern BAP_DLL enum ba0_compare_code bap_compare_polynom_mpq (
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *);

extern BAP_DLL bool bap_equal_polynom_mpq (
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *);

extern BAP_DLL ba0_cmp_function bap_gt_rank_polynom_mpq;

extern BAP_DLL ba0_cmp_function bap_lt_rank_polynom_mpq;

extern BAP_DLL bool bap_equal_rank_polynom_mpq (
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *);

extern BAP_DLL int bap_compare_rank_polynom_mpq (
    const void *,
    const void *);

extern BAP_DLL void bap_reverse_polynom_mpq (
    struct bap_polynom_mpq *);

extern BAP_DLL void bap_mark_indets_polynom_mpq (
    struct bav_dictionary_variable *,
    struct bav_tableof_variable *,
    struct bap_polynom_mpq *);

extern BAP_DLL void bap_mark_indets_tableof_polynom_mpq (
    struct bav_dictionary_variable *,
    struct bav_tableof_variable *,
    struct bap_tableof_polynom_mpq *);

extern BAP_DLL void bap_mark_indets_listof_polynom_mpq (
    struct bav_dictionary_variable *,
    struct bav_tableof_variable *,
    struct bap_listof_polynom_mpq *);

extern BAP_DLL void bap_mark_ranks_polynom_mpq (
    struct bap_polynom_mpq *);

extern BAP_DLL void bap_sort_polynom_mpq (
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *);

extern BAP_DLL void bap_physort_polynom_mpq (
    struct bap_polynom_mpq *);

extern BAP_DLL ba0_int_p bap_nbmon_polynom_mpq (
    struct bap_polynom_mpq *);

extern BAP_DLL void bap_minimal_total_rank_polynom_mpq (
    struct bav_term *,
    struct bap_polynom_mpq *);

extern BAP_DLL void bap_leading_term_polynom_mpq (
    struct bav_term *,
    struct bap_polynom_mpq *);

extern BAP_DLL struct bav_variable *bap_leader_polynom_mpq (
    struct bap_polynom_mpq *);

extern BAP_DLL struct bav_rank bap_rank_polynom_mpq (
    struct bap_polynom_mpq *);

extern BAP_DLL bav_Idegree bap_leading_degree_polynom_mpq (
    struct bap_polynom_mpq *);

extern BAP_DLL bav_Idegree bap_degree_polynom_mpq (
    struct bap_polynom_mpq *,
    struct bav_variable *);

extern BAP_DLL bav_Idegree bap_total_degree_polynom_mpq (
    struct bap_polynom_mpq *);

extern BAP_DLL bav_Iorder bap_total_order_polynom_mpq (
    struct bap_polynom_mpq *);

extern BAP_DLL ba0_mpq_t *bap_numeric_initial_polynom_mpq (
    struct bap_polynom_mpq *);

extern BAP_DLL void bap_initial_and_reductum_polynom_mpq (
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *);

extern BAP_DLL void bap_initial_polynom_mpq (
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *);

extern BAP_DLL void bap_reductum_polynom_mpq (
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *);

extern BAP_DLL void bap_initial_and_reductum2_polynom_mpq (
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *,
    struct bav_variable *);

extern BAP_DLL void bap_initial2_polynom_mpq (
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *,
    struct bav_variable *);

extern BAP_DLL void bap_reductum2_polynom_mpq (
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *,
    struct bav_variable *);

extern BAP_DLL void bap_coeff2_polynom_mpq (
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *,
    struct bav_variable *,
    bav_Idegree);

extern BAP_DLL void bap_lcoeff_and_reductum_polynom_mpq (
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *,
    struct bav_variable *);

extern BAP_DLL void bap_lcoeff_polynom_mpq (
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *,
    struct bav_variable *);

extern BAP_DLL void bap_coeff_polynom_mpq (
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *,
    struct bav_variable *,
    bav_Idegree);

extern BAP_DLL void bap_coeff_and_reductum_polynom_mpq (
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *,
    struct bav_variable *,
    bav_Idegree);

extern BAP_DLL void bap_replace_initial_polynom_mpq (
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *);

extern BAP_DLL void bap_separant_polynom_mpq (
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *);

extern BAP_DLL void bap_separant2_polynom_mpq (
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *,
    struct bav_variable *);

extern BAP_DLL void bap_sort_tableof_polynom_mpq (
    struct bap_tableof_polynom_mpq *,
    enum ba0_sort_mode);

extern BAP_DLL unsigned ba0_int_p bap_sizeof_polynom_mpq (
    struct bap_polynom_mpq *,
    enum ba0_garbage_code);

extern BAP_DLL void bap_switch_ring_polynom_mpq (
    struct bap_polynom_mpq *,
    struct bav_differential_ring *);

extern BAP_DLL ba0_garbage1_function bap_garbage1_polynom_mpq;

extern BAP_DLL ba0_garbage2_function bap_garbage2_polynom_mpq;

extern BAP_DLL ba0_copy_function bap_copy_polynom_mpq;

END_C_DECLS
#   undef  BAD_FLAG_mpq
#endif /* !BAP_POLYNOM_mpq_H */
#if !defined (BAP_POLYNOM_mint_hp_H)
#   define BAP_POLYNOM_mint_hp_H 1

/* #   include "bap_common.h" */
/* #   include "bap_clot_mint_hp.h" */
/* #   include "bap_sequential_access.h" */
/* #   include "bap_indexed_access.h" */
/* #   include "bap_termstripper.h" */

#   define BAD_FLAG_mint_hp

BEGIN_C_DECLS

/*
 * texinfo: bap_polynom_mint_hp
 * This data type implements polynomials.
 * Note that the @code{total_rank} field contains the exact
 * total rank of the polynomial while the @code{total_rank} field 
 * of the term manager of its clot only contains a multiple
 * of this total rank.
 */

struct bap_polynom_mint_hp
{
  struct bap_clot_mint_hp *clot;  // the underlying clot
  struct bav_term total_rank;   // the total rank of the polynomial
  bool readonly;                // true if modifications are forbidden
  enum bap_typeof_monom_access access;
  struct bap_sequential_access seq;     // in case of a sequential access
  struct bap_indexed_access ind;        // in case of an indexed access
  struct bap_termstripper tstrip;       // for stripping terms
};


#   define BAP_NOT_A_POLYNOM_mint_hp	(struct bap_polynom_mint_hp*)0

struct bap_tableof_polynom_mint_hp
{
  ba0_int_p alloc;
  ba0_int_p size;
  struct bap_polynom_mint_hp **tab;
};

struct bap_listof_polynom_mint_hp
{
  struct bap_polynom_mint_hp *value;
  struct bap_listof_polynom_mint_hp *next;
};

struct bap_tableof_tableof_polynom_mint_hp
{
  ba0_int_p alloc;
  ba0_int_p size;
  struct bap_tableof_polynom_mint_hp **tab;
};

struct bap_tableof_listof_polynom_mint_hp
{
  ba0_int_p alloc;
  ba0_int_p size;
  struct bap_listof_polynom_mint_hp **tab;
};

extern BAP_DLL void bap_init_polynom_mint_hp (
    struct bap_polynom_mint_hp *);

extern BAP_DLL void bap_init_readonly_polynom_mint_hp (
    struct bap_polynom_mint_hp *);

extern BAP_DLL void bap_init_polynom_one_mint_hp (
    struct bap_polynom_mint_hp *);

extern BAP_DLL void bap_init_polynom_crk_mint_hp (
    struct bap_polynom_mint_hp *,
    ba0_mint_hp_t,
    struct bav_rank *);

extern BAP_DLL struct bap_polynom_mint_hp *bap_new_polynom_mint_hp (
    void);

extern BAP_DLL struct bap_polynom_mint_hp *bap_new_readonly_polynom_mint_hp (
    void);

extern BAP_DLL struct bap_polynom_mint_hp *bap_new_polynom_one_mint_hp (
    void);

extern BAP_DLL struct bap_polynom_mint_hp *bap_new_polynom_crk_mint_hp (
    ba0_mint_hp_t,
    struct bav_rank *);

extern BAP_DLL void bap_set_polynom_zero_mint_hp (
    struct bap_polynom_mint_hp *);

extern BAP_DLL void bap_set_polynom_one_mint_hp (
    struct bap_polynom_mint_hp *);

extern BAP_DLL void bap_set_polynom_crk_mint_hp (
    struct bap_polynom_mint_hp *,
    ba0_mint_hp_t,
    struct bav_rank *);

extern BAP_DLL void bap_set_polynom_variable_mint_hp (
    struct bap_polynom_mint_hp *,
    struct bav_variable *,
    bav_Idegree);

extern BAP_DLL void bap_set_polynom_mint_hp (
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *);

extern BAP_DLL void bap_set_tableof_polynom_mint_hp (
    struct bap_tableof_polynom_mint_hp *,
    struct bap_tableof_polynom_mint_hp *);

extern BAP_DLL void bap_set_tableof_tableof_polynom_mint_hp (
    struct bap_tableof_tableof_polynom_mint_hp *,
    struct bap_tableof_tableof_polynom_mint_hp *);

extern BAP_DLL void bap_set_readonly_polynom_mint_hp (
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *);

extern BAP_DLL void bap_set_polynom_term_mint_hp (
    struct bap_polynom_mint_hp *,
    struct bav_term *);

extern BAP_DLL void bap_set_polynom_monom_mint_hp (
    struct bap_polynom_mint_hp *,
    ba0_mint_hp_t,
    struct bav_term *);

extern BAP_DLL void bap_set_total_rank_polynom_mint_hp (
    struct bap_polynom_mint_hp *);

extern BAP_DLL bool bap_is_zero_polynom_mint_hp (
    struct bap_polynom_mint_hp *);

extern BAP_DLL bool bap_is_one_polynom_mint_hp (
    struct bap_polynom_mint_hp *);

extern BAP_DLL bool bap_is_numeric_polynom_mint_hp (
    struct bap_polynom_mint_hp *);

extern BAP_DLL bool bap_is_univariate_polynom_mint_hp (
    struct bap_polynom_mint_hp *);

extern BAP_DLL bool bap_depend_polynom_mint_hp (
    struct bap_polynom_mint_hp *,
    struct bav_variable *);

extern BAP_DLL bool bap_depend_only_polynom_mint_hp (
    struct bap_polynom_mint_hp *,
    struct bav_tableof_variable *);

extern BAP_DLL bool bap_is_variable_polynom_mint_hp (
    struct bap_polynom_mint_hp *);

extern BAP_DLL bool bap_is_solved_polynom_mint_hp (
    struct bap_polynom_mint_hp *);

extern BAP_DLL bool bap_is_derivative_minus_independent_polynom_mint_hp (
    struct bap_polynom_mint_hp *);

extern BAP_DLL bool bap_is_rank_minus_monom_polynom_mint_hp (
    struct bap_polynom_mint_hp *);

extern BAP_DLL bool bap_are_disjoint_polynom_mint_hp (
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *);

extern BAP_DLL enum ba0_compare_code bap_compare_polynom_mint_hp (
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *);

extern BAP_DLL bool bap_equal_polynom_mint_hp (
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *);

extern BAP_DLL ba0_cmp_function bap_gt_rank_polynom_mint_hp;

extern BAP_DLL ba0_cmp_function bap_lt_rank_polynom_mint_hp;

extern BAP_DLL bool bap_equal_rank_polynom_mint_hp (
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *);

extern BAP_DLL int bap_compare_rank_polynom_mint_hp (
    const void *,
    const void *);

extern BAP_DLL void bap_reverse_polynom_mint_hp (
    struct bap_polynom_mint_hp *);

extern BAP_DLL void bap_mark_indets_polynom_mint_hp (
    struct bav_dictionary_variable *,
    struct bav_tableof_variable *,
    struct bap_polynom_mint_hp *);

extern BAP_DLL void bap_mark_indets_tableof_polynom_mint_hp (
    struct bav_dictionary_variable *,
    struct bav_tableof_variable *,
    struct bap_tableof_polynom_mint_hp *);

extern BAP_DLL void bap_mark_indets_listof_polynom_mint_hp (
    struct bav_dictionary_variable *,
    struct bav_tableof_variable *,
    struct bap_listof_polynom_mint_hp *);

extern BAP_DLL void bap_mark_ranks_polynom_mint_hp (
    struct bap_polynom_mint_hp *);

extern BAP_DLL void bap_sort_polynom_mint_hp (
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *);

extern BAP_DLL void bap_physort_polynom_mint_hp (
    struct bap_polynom_mint_hp *);

extern BAP_DLL ba0_int_p bap_nbmon_polynom_mint_hp (
    struct bap_polynom_mint_hp *);

extern BAP_DLL void bap_minimal_total_rank_polynom_mint_hp (
    struct bav_term *,
    struct bap_polynom_mint_hp *);

extern BAP_DLL void bap_leading_term_polynom_mint_hp (
    struct bav_term *,
    struct bap_polynom_mint_hp *);

extern BAP_DLL struct bav_variable *bap_leader_polynom_mint_hp (
    struct bap_polynom_mint_hp *);

extern BAP_DLL struct bav_rank bap_rank_polynom_mint_hp (
    struct bap_polynom_mint_hp *);

extern BAP_DLL bav_Idegree bap_leading_degree_polynom_mint_hp (
    struct bap_polynom_mint_hp *);

extern BAP_DLL bav_Idegree bap_degree_polynom_mint_hp (
    struct bap_polynom_mint_hp *,
    struct bav_variable *);

extern BAP_DLL bav_Idegree bap_total_degree_polynom_mint_hp (
    struct bap_polynom_mint_hp *);

extern BAP_DLL bav_Iorder bap_total_order_polynom_mint_hp (
    struct bap_polynom_mint_hp *);

extern BAP_DLL ba0_mint_hp_t *bap_numeric_initial_polynom_mint_hp (
    struct bap_polynom_mint_hp *);

extern BAP_DLL void bap_initial_and_reductum_polynom_mint_hp (
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *);

extern BAP_DLL void bap_initial_polynom_mint_hp (
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *);

extern BAP_DLL void bap_reductum_polynom_mint_hp (
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *);

extern BAP_DLL void bap_initial_and_reductum2_polynom_mint_hp (
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *,
    struct bav_variable *);

extern BAP_DLL void bap_initial2_polynom_mint_hp (
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *,
    struct bav_variable *);

extern BAP_DLL void bap_reductum2_polynom_mint_hp (
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *,
    struct bav_variable *);

extern BAP_DLL void bap_coeff2_polynom_mint_hp (
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *,
    struct bav_variable *,
    bav_Idegree);

extern BAP_DLL void bap_lcoeff_and_reductum_polynom_mint_hp (
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *,
    struct bav_variable *);

extern BAP_DLL void bap_lcoeff_polynom_mint_hp (
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *,
    struct bav_variable *);

extern BAP_DLL void bap_coeff_polynom_mint_hp (
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *,
    struct bav_variable *,
    bav_Idegree);

extern BAP_DLL void bap_coeff_and_reductum_polynom_mint_hp (
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *,
    struct bav_variable *,
    bav_Idegree);

extern BAP_DLL void bap_replace_initial_polynom_mint_hp (
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *);

extern BAP_DLL void bap_separant_polynom_mint_hp (
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *);

extern BAP_DLL void bap_separant2_polynom_mint_hp (
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *,
    struct bav_variable *);

extern BAP_DLL void bap_sort_tableof_polynom_mint_hp (
    struct bap_tableof_polynom_mint_hp *,
    enum ba0_sort_mode);

extern BAP_DLL unsigned ba0_int_p bap_sizeof_polynom_mint_hp (
    struct bap_polynom_mint_hp *,
    enum ba0_garbage_code);

extern BAP_DLL void bap_switch_ring_polynom_mint_hp (
    struct bap_polynom_mint_hp *,
    struct bav_differential_ring *);

extern BAP_DLL ba0_garbage1_function bap_garbage1_polynom_mint_hp;

extern BAP_DLL ba0_garbage2_function bap_garbage2_polynom_mint_hp;

extern BAP_DLL ba0_copy_function bap_copy_polynom_mint_hp;

END_C_DECLS
#   undef  BAD_FLAG_mint_hp
#endif /* !BAP_POLYNOM_mint_hp_H */
#if !defined (BAP__CHECK_mpz_H)
#   define BAP__CHECK_mpz_H 1

/* #   include "bap_common.h" */
/* #   include "bap_polynom_mpz.h" */

BEGIN_C_DECLS

#   define BAD_FLAG_mpz

extern BAP_DLL void bap__check_ordering_mpz (
    struct bap_polynom_mpz *);

extern BAP_DLL void bap__check_compatible_mpz (
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *);

#   undef BAD_FLAG_mpz

END_C_DECLS
#endif /* !BAP__CHECK_mpz_H */
#if !defined (BAP__CHECK_mpzm_H)
#   define BAP__CHECK_mpzm_H 1

/* #   include "bap_common.h" */
/* #   include "bap_polynom_mpzm.h" */

BEGIN_C_DECLS

#   define BAD_FLAG_mpzm

extern BAP_DLL void bap__check_ordering_mpzm (
    struct bap_polynom_mpzm *);

extern BAP_DLL void bap__check_compatible_mpzm (
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *);

#   undef BAD_FLAG_mpzm

END_C_DECLS
#endif /* !BAP__CHECK_mpzm_H */
#if !defined (BAP__CHECK_mpq_H)
#   define BAP__CHECK_mpq_H 1

/* #   include "bap_common.h" */
/* #   include "bap_polynom_mpq.h" */

BEGIN_C_DECLS

#   define BAD_FLAG_mpq

extern BAP_DLL void bap__check_ordering_mpq (
    struct bap_polynom_mpq *);

extern BAP_DLL void bap__check_compatible_mpq (
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *);

#   undef BAD_FLAG_mpq

END_C_DECLS
#endif /* !BAP__CHECK_mpq_H */
#if !defined (BAP__CHECK_mint_hp_H)
#   define BAP__CHECK_mint_hp_H 1

/* #   include "bap_common.h" */
/* #   include "bap_polynom_mint_hp.h" */

BEGIN_C_DECLS

#   define BAD_FLAG_mint_hp

extern BAP_DLL void bap__check_ordering_mint_hp (
    struct bap_polynom_mint_hp *);

extern BAP_DLL void bap__check_compatible_mint_hp (
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *);

#   undef BAD_FLAG_mint_hp

END_C_DECLS
#endif /* !BAP__CHECK_mint_hp_H */
#if !defined (BAP_ADD_POLYNOM_mpz_H)
#   define BAP_ADD_POLYNOM_mpz_H 1

/* #   include "bap_polynom_mpz.h" */

BEGIN_C_DECLS

#   define BAD_FLAG_mpz

extern BAP_DLL void bap_add_polynom_mpz (
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *);

extern BAP_DLL void bap_add_polynom_numeric_mpz (
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    ba0_mpz_t);

extern BAP_DLL void bap_sub_polynom_mpz (
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *);

extern BAP_DLL void bap_submulmon_polynom_mpz (
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    struct bav_term *,
    ba0_mpz_t);

extern BAP_DLL void bap_comblin_polynom_mpz (
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    ba0_int_p,
    struct bap_polynom_mpz *,
    ba0_int_p);

extern BAP_DLL void bap_addmulrk_polynom_mpz (
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    struct bav_rank *,
    struct bap_polynom_mpz *);

extern BAP_DLL void bap_submulrk_polynom_mpz (
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    struct bav_rank *,
    struct bap_polynom_mpz *);

#   undef  BAD_FLAG_mpz

END_C_DECLS
#endif /* !BAP_ADD_POLYNOM_mpz_H */
#if !defined (BAP_ADD_POLYNOM_mpzm_H)
#   define BAP_ADD_POLYNOM_mpzm_H 1

/* #   include "bap_polynom_mpzm.h" */

BEGIN_C_DECLS

#   define BAD_FLAG_mpzm

extern BAP_DLL void bap_add_polynom_mpzm (
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *);

extern BAP_DLL void bap_add_polynom_numeric_mpzm (
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *,
    ba0_mpzm_t);

extern BAP_DLL void bap_sub_polynom_mpzm (
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *);

extern BAP_DLL void bap_submulmon_polynom_mpzm (
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *,
    struct bav_term *,
    ba0_mpzm_t);

extern BAP_DLL void bap_comblin_polynom_mpzm (
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *,
    ba0_int_p,
    struct bap_polynom_mpzm *,
    ba0_int_p);

extern BAP_DLL void bap_addmulrk_polynom_mpzm (
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *,
    struct bav_rank *,
    struct bap_polynom_mpzm *);

extern BAP_DLL void bap_submulrk_polynom_mpzm (
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *,
    struct bav_rank *,
    struct bap_polynom_mpzm *);

#   undef  BAD_FLAG_mpzm

END_C_DECLS
#endif /* !BAP_ADD_POLYNOM_mpzm_H */
#if !defined (BAP_ADD_POLYNOM_mpq_H)
#   define BAP_ADD_POLYNOM_mpq_H 1

/* #   include "bap_polynom_mpq.h" */

BEGIN_C_DECLS

#   define BAD_FLAG_mpq

extern BAP_DLL void bap_add_polynom_mpq (
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *);

extern BAP_DLL void bap_add_polynom_numeric_mpq (
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *,
    ba0_mpq_t);

extern BAP_DLL void bap_sub_polynom_mpq (
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *);

extern BAP_DLL void bap_submulmon_polynom_mpq (
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *,
    struct bav_term *,
    ba0_mpq_t);

extern BAP_DLL void bap_comblin_polynom_mpq (
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *,
    ba0_int_p,
    struct bap_polynom_mpq *,
    ba0_int_p);

extern BAP_DLL void bap_addmulrk_polynom_mpq (
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *,
    struct bav_rank *,
    struct bap_polynom_mpq *);

extern BAP_DLL void bap_submulrk_polynom_mpq (
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *,
    struct bav_rank *,
    struct bap_polynom_mpq *);

#   undef  BAD_FLAG_mpq

END_C_DECLS
#endif /* !BAP_ADD_POLYNOM_mpq_H */
#if !defined (BAP_ADD_POLYNOM_mint_hp_H)
#   define BAP_ADD_POLYNOM_mint_hp_H 1

/* #   include "bap_polynom_mint_hp.h" */

BEGIN_C_DECLS

#   define BAD_FLAG_mint_hp

extern BAP_DLL void bap_add_polynom_mint_hp (
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *);

extern BAP_DLL void bap_add_polynom_numeric_mint_hp (
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *,
    ba0_mint_hp_t);

extern BAP_DLL void bap_sub_polynom_mint_hp (
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *);

extern BAP_DLL void bap_submulmon_polynom_mint_hp (
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *,
    struct bav_term *,
    ba0_mint_hp_t);

extern BAP_DLL void bap_comblin_polynom_mint_hp (
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *,
    ba0_int_p,
    struct bap_polynom_mint_hp *,
    ba0_int_p);

extern BAP_DLL void bap_addmulrk_polynom_mint_hp (
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *,
    struct bav_rank *,
    struct bap_polynom_mint_hp *);

extern BAP_DLL void bap_submulrk_polynom_mint_hp (
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *,
    struct bav_rank *,
    struct bap_polynom_mint_hp *);

#   undef  BAD_FLAG_mint_hp

END_C_DECLS
#endif /* !BAP_ADD_POLYNOM_mint_hp_H */
#if !defined (BAP_MUL_POLYNOM_mpz_H)
#   define BAP_MUL_POLYNOM_mpz_H 1

/* #   include "bap_polynom_mpz.h" */

BEGIN_C_DECLS

#   define BAD_FLAG_mpz

extern BAP_DLL void bap_neg_polynom_mpz (
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *);

extern BAP_DLL void bap_mul_polynom_mpz (
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *);

extern BAP_DLL void bap_mul_polynom_variable_mpz (
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    struct bav_variable *,
    bav_Idegree);

extern BAP_DLL void bap_mul_polynom_term_mpz (
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    struct bav_term *);

extern BAP_DLL void bap_mul_polynom_monom_mpz (
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    ba0_mpz_t,
    struct bav_term *);

extern BAP_DLL void bap_mul_polynom_numeric_mpz (
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    ba0_mpz_t);

extern BAP_DLL void bap_mul_polynom_value_int_p_mpz (
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    struct bav_value_int_p *);

extern BAP_DLL void bap_pow_polynom_mpz (
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    bav_Idegree);

#   undef  BAD_FLAG_mpz

END_C_DECLS
#endif /* !BAP_MUL_POLYNOM_mpz_H */
#if !defined (BAP_MUL_POLYNOM_mpzm_H)
#   define BAP_MUL_POLYNOM_mpzm_H 1

/* #   include "bap_polynom_mpzm.h" */

BEGIN_C_DECLS

#   define BAD_FLAG_mpzm

extern BAP_DLL void bap_neg_polynom_mpzm (
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *);

extern BAP_DLL void bap_mul_polynom_mpzm (
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *);

extern BAP_DLL void bap_mul_polynom_variable_mpzm (
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *,
    struct bav_variable *,
    bav_Idegree);

extern BAP_DLL void bap_mul_polynom_term_mpzm (
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *,
    struct bav_term *);

extern BAP_DLL void bap_mul_polynom_monom_mpzm (
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *,
    ba0_mpzm_t,
    struct bav_term *);

extern BAP_DLL void bap_mul_polynom_numeric_mpzm (
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *,
    ba0_mpzm_t);

extern BAP_DLL void bap_mul_polynom_value_int_p_mpzm (
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *,
    struct bav_value_int_p *);

extern BAP_DLL void bap_pow_polynom_mpzm (
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *,
    bav_Idegree);

#   undef  BAD_FLAG_mpzm

END_C_DECLS
#endif /* !BAP_MUL_POLYNOM_mpzm_H */
#if !defined (BAP_MUL_POLYNOM_mpq_H)
#   define BAP_MUL_POLYNOM_mpq_H 1

/* #   include "bap_polynom_mpq.h" */

BEGIN_C_DECLS

#   define BAD_FLAG_mpq

extern BAP_DLL void bap_neg_polynom_mpq (
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *);

extern BAP_DLL void bap_mul_polynom_mpq (
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *);

extern BAP_DLL void bap_mul_polynom_variable_mpq (
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *,
    struct bav_variable *,
    bav_Idegree);

extern BAP_DLL void bap_mul_polynom_term_mpq (
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *,
    struct bav_term *);

extern BAP_DLL void bap_mul_polynom_monom_mpq (
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *,
    ba0_mpq_t,
    struct bav_term *);

extern BAP_DLL void bap_mul_polynom_numeric_mpq (
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *,
    ba0_mpq_t);

extern BAP_DLL void bap_mul_polynom_value_int_p_mpq (
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *,
    struct bav_value_int_p *);

extern BAP_DLL void bap_pow_polynom_mpq (
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *,
    bav_Idegree);

#   undef  BAD_FLAG_mpq

END_C_DECLS
#endif /* !BAP_MUL_POLYNOM_mpq_H */
#if !defined (BAP_MUL_POLYNOM_mint_hp_H)
#   define BAP_MUL_POLYNOM_mint_hp_H 1

/* #   include "bap_polynom_mint_hp.h" */

BEGIN_C_DECLS

#   define BAD_FLAG_mint_hp

extern BAP_DLL void bap_neg_polynom_mint_hp (
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *);

extern BAP_DLL void bap_mul_polynom_mint_hp (
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *);

extern BAP_DLL void bap_mul_polynom_variable_mint_hp (
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *,
    struct bav_variable *,
    bav_Idegree);

extern BAP_DLL void bap_mul_polynom_term_mint_hp (
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *,
    struct bav_term *);

extern BAP_DLL void bap_mul_polynom_monom_mint_hp (
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *,
    ba0_mint_hp_t,
    struct bav_term *);

extern BAP_DLL void bap_mul_polynom_numeric_mint_hp (
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *,
    ba0_mint_hp_t);

extern BAP_DLL void bap_mul_polynom_value_int_p_mint_hp (
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *,
    struct bav_value_int_p *);

extern BAP_DLL void bap_pow_polynom_mint_hp (
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *,
    bav_Idegree);

#   undef  BAD_FLAG_mint_hp

END_C_DECLS
#endif /* !BAP_MUL_POLYNOM_mint_hp_H */
#if !defined (BAP_PREM_POLYNOM_mpz_H)
#   define BAP_PREM_POLYNOM_mpz_H 1

/* #   include "bap_polynom_mpz.h" */

BEGIN_C_DECLS

#   define BAD_FLAG_mpz

extern BAP_DLL bool bap_is_numeric_factor_polynom_mpz (
    struct bap_polynom_mpz *,
    ba0_mpz_t,
    struct bap_polynom_mpz *);

extern BAP_DLL bool bap_is_variable_factor_polynom_mpz (
    struct bap_polynom_mpz *,
    struct bav_variable *,
    bav_Idegree *);

extern BAP_DLL bool bap_is_factor_polynom_mpz (
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *);

extern BAP_DLL bool bap_is_factor_tableof_polynom_mpz (
    struct bap_polynom_mpz *,
    struct bap_tableof_polynom_mpz *);

extern BAP_DLL void bap_exquo_polynom_term_mpz (
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    struct bav_term *);

extern BAP_DLL void bap_exquo_polynom_mpz (
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *);

struct bap_product_mpz;

extern BAP_DLL void bap_exquo_polynom_product_mpz (
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    struct bap_product_mpz *);

extern BAP_DLL void bap_pseudo_division_polynom_mpz (
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    bav_Idegree *,
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    struct bav_variable *);

extern BAP_DLL void bap_prem_polynom_mpz (
    struct bap_polynom_mpz *,
    bav_Idegree *,
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    struct bav_variable *);

extern BAP_DLL void bap_pquo_polynom_mpz (
    struct bap_polynom_mpz *,
    bav_Idegree *,
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    struct bav_variable *);

extern BAP_DLL void bap_rem_polynom_mpz (
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    struct bav_variable *);

#   undef  BAD_FLAG_mpz

END_C_DECLS
#endif /* !BAP_PREM_POLYNOM_mpz_H */
#if !defined (BAP_PREM_POLYNOM_mpzm_H)
#   define BAP_PREM_POLYNOM_mpzm_H 1

/* #   include "bap_polynom_mpzm.h" */

BEGIN_C_DECLS

#   define BAD_FLAG_mpzm

extern BAP_DLL bool bap_is_numeric_factor_polynom_mpzm (
    struct bap_polynom_mpzm *,
    ba0_mpzm_t,
    struct bap_polynom_mpzm *);

extern BAP_DLL bool bap_is_variable_factor_polynom_mpzm (
    struct bap_polynom_mpzm *,
    struct bav_variable *,
    bav_Idegree *);

extern BAP_DLL bool bap_is_factor_polynom_mpzm (
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *);

extern BAP_DLL bool bap_is_factor_tableof_polynom_mpzm (
    struct bap_polynom_mpzm *,
    struct bap_tableof_polynom_mpzm *);

extern BAP_DLL void bap_exquo_polynom_term_mpzm (
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *,
    struct bav_term *);

extern BAP_DLL void bap_exquo_polynom_mpzm (
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *);

struct bap_product_mpzm;

extern BAP_DLL void bap_exquo_polynom_product_mpzm (
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *,
    struct bap_product_mpzm *);

extern BAP_DLL void bap_pseudo_division_polynom_mpzm (
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *,
    bav_Idegree *,
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *,
    struct bav_variable *);

extern BAP_DLL void bap_prem_polynom_mpzm (
    struct bap_polynom_mpzm *,
    bav_Idegree *,
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *,
    struct bav_variable *);

extern BAP_DLL void bap_pquo_polynom_mpzm (
    struct bap_polynom_mpzm *,
    bav_Idegree *,
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *,
    struct bav_variable *);

extern BAP_DLL void bap_rem_polynom_mpzm (
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *,
    struct bav_variable *);

#   undef  BAD_FLAG_mpzm

END_C_DECLS
#endif /* !BAP_PREM_POLYNOM_mpzm_H */
#if !defined (BAP_PREM_POLYNOM_mpq_H)
#   define BAP_PREM_POLYNOM_mpq_H 1

/* #   include "bap_polynom_mpq.h" */

BEGIN_C_DECLS

#   define BAD_FLAG_mpq

extern BAP_DLL bool bap_is_numeric_factor_polynom_mpq (
    struct bap_polynom_mpq *,
    ba0_mpq_t,
    struct bap_polynom_mpq *);

extern BAP_DLL bool bap_is_variable_factor_polynom_mpq (
    struct bap_polynom_mpq *,
    struct bav_variable *,
    bav_Idegree *);

extern BAP_DLL bool bap_is_factor_polynom_mpq (
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *);

extern BAP_DLL bool bap_is_factor_tableof_polynom_mpq (
    struct bap_polynom_mpq *,
    struct bap_tableof_polynom_mpq *);

extern BAP_DLL void bap_exquo_polynom_term_mpq (
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *,
    struct bav_term *);

extern BAP_DLL void bap_exquo_polynom_mpq (
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *);

struct bap_product_mpq;

extern BAP_DLL void bap_exquo_polynom_product_mpq (
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *,
    struct bap_product_mpq *);

extern BAP_DLL void bap_pseudo_division_polynom_mpq (
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *,
    bav_Idegree *,
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *,
    struct bav_variable *);

extern BAP_DLL void bap_prem_polynom_mpq (
    struct bap_polynom_mpq *,
    bav_Idegree *,
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *,
    struct bav_variable *);

extern BAP_DLL void bap_pquo_polynom_mpq (
    struct bap_polynom_mpq *,
    bav_Idegree *,
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *,
    struct bav_variable *);

extern BAP_DLL void bap_rem_polynom_mpq (
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *,
    struct bav_variable *);

#   undef  BAD_FLAG_mpq

END_C_DECLS
#endif /* !BAP_PREM_POLYNOM_mpq_H */
#if !defined (BAP_PREM_POLYNOM_mint_hp_H)
#   define BAP_PREM_POLYNOM_mint_hp_H 1

/* #   include "bap_polynom_mint_hp.h" */

BEGIN_C_DECLS

#   define BAD_FLAG_mint_hp

extern BAP_DLL bool bap_is_numeric_factor_polynom_mint_hp (
    struct bap_polynom_mint_hp *,
    ba0_mint_hp_t,
    struct bap_polynom_mint_hp *);

extern BAP_DLL bool bap_is_variable_factor_polynom_mint_hp (
    struct bap_polynom_mint_hp *,
    struct bav_variable *,
    bav_Idegree *);

extern BAP_DLL bool bap_is_factor_polynom_mint_hp (
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *);

extern BAP_DLL bool bap_is_factor_tableof_polynom_mint_hp (
    struct bap_polynom_mint_hp *,
    struct bap_tableof_polynom_mint_hp *);

extern BAP_DLL void bap_exquo_polynom_term_mint_hp (
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *,
    struct bav_term *);

extern BAP_DLL void bap_exquo_polynom_mint_hp (
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *);

struct bap_product_mint_hp;

extern BAP_DLL void bap_exquo_polynom_product_mint_hp (
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *,
    struct bap_product_mint_hp *);

extern BAP_DLL void bap_pseudo_division_polynom_mint_hp (
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *,
    bav_Idegree *,
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *,
    struct bav_variable *);

extern BAP_DLL void bap_prem_polynom_mint_hp (
    struct bap_polynom_mint_hp *,
    bav_Idegree *,
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *,
    struct bav_variable *);

extern BAP_DLL void bap_pquo_polynom_mint_hp (
    struct bap_polynom_mint_hp *,
    bav_Idegree *,
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *,
    struct bav_variable *);

extern BAP_DLL void bap_rem_polynom_mint_hp (
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *,
    struct bav_variable *);

#   undef  BAD_FLAG_mint_hp

END_C_DECLS
#endif /* !BAP_PREM_POLYNOM_mint_hp_H */
#if !defined (BAP_PARSE_POLYNOM_mpz_H)
#   define BAP_PARSE_POLYNOM_mpz_H 1

/* #   include "bap_common.h" */
/* #   include "bap_clot_mpz.h" */
/* #   include "bap_sequential_access.h" */
/* #   include "bap_indexed_access.h" */
/* #   include "bap_termstripper.h" */
/* #   include "bap_polynom_mpz.h" */

BEGIN_C_DECLS

#   define BAD_FLAG_mpz

extern BAP_DLL ba0_scanf_function bap_scanf_polynom_eqn_mpz;

extern BAP_DLL ba0_scanf_function bap_scanf_expanded_polynom_mpz;

extern BAP_DLL ba0_scanf_function bap_scanf_polynom_mpz;

extern BAP_DLL ba0_scanf_function bap_scanf_simplify_polynom_mpz;

extern BAP_DLL ba0_scanf_function bap_scanf_atomic_polynom_mpz;

extern BAP_DLL ba0_scanf_function bap_scanf_simplify_expanded_polynom_mpz;

extern BAP_DLL ba0_printf_function bap_printf_polynom_mpz;

extern BAP_DLL void bap_simplify_zero_derivatives_of_parameter_polynom_mpz (
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *);

#   undef  BAD_FLAG_mpz

END_C_DECLS
#endif /* !BAP_PARSE_POLYNOM_mpz_H */
#if !defined (BAP_PARSE_POLYNOM_mpzm_H)
#   define BAP_PARSE_POLYNOM_mpzm_H 1

/* #   include "bap_common.h" */
/* #   include "bap_clot_mpzm.h" */
/* #   include "bap_sequential_access.h" */
/* #   include "bap_indexed_access.h" */
/* #   include "bap_termstripper.h" */
/* #   include "bap_polynom_mpzm.h" */

BEGIN_C_DECLS

#   define BAD_FLAG_mpzm

extern BAP_DLL ba0_scanf_function bap_scanf_polynom_eqn_mpzm;

extern BAP_DLL ba0_scanf_function bap_scanf_expanded_polynom_mpzm;

extern BAP_DLL ba0_scanf_function bap_scanf_polynom_mpzm;

extern BAP_DLL ba0_scanf_function bap_scanf_simplify_polynom_mpzm;

extern BAP_DLL ba0_scanf_function bap_scanf_atomic_polynom_mpzm;

extern BAP_DLL ba0_scanf_function bap_scanf_simplify_expanded_polynom_mpzm;

extern BAP_DLL ba0_printf_function bap_printf_polynom_mpzm;

extern BAP_DLL void bap_simplify_zero_derivatives_of_parameter_polynom_mpzm (
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *);

#   undef  BAD_FLAG_mpzm

END_C_DECLS
#endif /* !BAP_PARSE_POLYNOM_mpzm_H */
#if !defined (BAP_PARSE_POLYNOM_mpq_H)
#   define BAP_PARSE_POLYNOM_mpq_H 1

/* #   include "bap_common.h" */
/* #   include "bap_clot_mpq.h" */
/* #   include "bap_sequential_access.h" */
/* #   include "bap_indexed_access.h" */
/* #   include "bap_termstripper.h" */
/* #   include "bap_polynom_mpq.h" */

BEGIN_C_DECLS

#   define BAD_FLAG_mpq

extern BAP_DLL ba0_scanf_function bap_scanf_polynom_eqn_mpq;

extern BAP_DLL ba0_scanf_function bap_scanf_expanded_polynom_mpq;

extern BAP_DLL ba0_scanf_function bap_scanf_polynom_mpq;

extern BAP_DLL ba0_scanf_function bap_scanf_simplify_polynom_mpq;

extern BAP_DLL ba0_scanf_function bap_scanf_atomic_polynom_mpq;

extern BAP_DLL ba0_scanf_function bap_scanf_simplify_expanded_polynom_mpq;

extern BAP_DLL ba0_printf_function bap_printf_polynom_mpq;

extern BAP_DLL void bap_simplify_zero_derivatives_of_parameter_polynom_mpq (
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *);

#   undef  BAD_FLAG_mpq

END_C_DECLS
#endif /* !BAP_PARSE_POLYNOM_mpq_H */
#if !defined (BAP_PARSE_POLYNOM_mint_hp_H)
#   define BAP_PARSE_POLYNOM_mint_hp_H 1

/* #   include "bap_common.h" */
/* #   include "bap_clot_mint_hp.h" */
/* #   include "bap_sequential_access.h" */
/* #   include "bap_indexed_access.h" */
/* #   include "bap_termstripper.h" */
/* #   include "bap_polynom_mint_hp.h" */

BEGIN_C_DECLS

#   define BAD_FLAG_mint_hp

extern BAP_DLL ba0_scanf_function bap_scanf_polynom_eqn_mint_hp;

extern BAP_DLL ba0_scanf_function bap_scanf_expanded_polynom_mint_hp;

extern BAP_DLL ba0_scanf_function bap_scanf_polynom_mint_hp;

extern BAP_DLL ba0_scanf_function bap_scanf_simplify_polynom_mint_hp;

extern BAP_DLL ba0_scanf_function bap_scanf_atomic_polynom_mint_hp;

extern BAP_DLL ba0_scanf_function bap_scanf_simplify_expanded_polynom_mint_hp;

extern BAP_DLL ba0_printf_function bap_printf_polynom_mint_hp;

extern BAP_DLL void bap_simplify_zero_derivatives_of_parameter_polynom_mint_hp (
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *);

#   undef  BAD_FLAG_mint_hp

END_C_DECLS
#endif /* !BAP_PARSE_POLYNOM_mint_hp_H */
#if !defined (BAP_DUCOS_mpz_H)
#   define BAP_DUCOS_mpz_H 1

/* #   include "bap_common.h" */
/* #   include "bap_polynom_mpz.h" */
/* #   include "bap_product_mpz.h" */

BEGIN_C_DECLS

#   define BAD_FLAG_mpz

extern BAP_DLL void bap_muldiv_Lazard_polynom_mpz (
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    bav_Idegree);

extern BAP_DLL void bap_muldiv2_Lazard_polynom_mpz (
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    bav_Idegree);

extern BAP_DLL void bap_muldiv3_Lazard_polynom_mpz (
    struct bap_tableof_polynom_mpz *,
    struct bap_tableof_polynom_mpz *,
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    bav_Idegree);

extern BAP_DLL void bap_nsr2_Ducos_polynom_mpz (
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    struct bav_variable *);

extern BAP_DLL void bap_nsr3_Ducos_polynom_mpz (
    struct bap_tableof_polynom_mpz *,
    struct bap_tableof_polynom_mpz *,
    struct bap_tableof_polynom_mpz *,
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    struct bav_variable *);

extern BAP_DLL void bap_resultant2_Ducos_polynom_mpz (
    struct bap_product_mpz *,
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    struct bav_variable *);

extern BAP_DLL void bap_lsr3_Ducos_polynom_mpz (
    struct bap_tableof_polynom_mpz *,
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    struct bav_variable *);

#   undef BAD_FLAG_mpz

END_C_DECLS
#endif /* !BAP_DUCOS_mpz_H */
#if !defined (BAP_DUCOS_mpzm_H)
#   define BAP_DUCOS_mpzm_H 1

/* #   include "bap_common.h" */
/* #   include "bap_polynom_mpzm.h" */
/* #   include "bap_product_mpzm.h" */

BEGIN_C_DECLS

#   define BAD_FLAG_mpzm

extern BAP_DLL void bap_muldiv_Lazard_polynom_mpzm (
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *,
    bav_Idegree);

extern BAP_DLL void bap_muldiv2_Lazard_polynom_mpzm (
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *,
    bav_Idegree);

extern BAP_DLL void bap_muldiv3_Lazard_polynom_mpzm (
    struct bap_tableof_polynom_mpzm *,
    struct bap_tableof_polynom_mpzm *,
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *,
    bav_Idegree);

extern BAP_DLL void bap_nsr2_Ducos_polynom_mpzm (
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *,
    struct bav_variable *);

extern BAP_DLL void bap_nsr3_Ducos_polynom_mpzm (
    struct bap_tableof_polynom_mpzm *,
    struct bap_tableof_polynom_mpzm *,
    struct bap_tableof_polynom_mpzm *,
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *,
    struct bav_variable *);

extern BAP_DLL void bap_resultant2_Ducos_polynom_mpzm (
    struct bap_product_mpzm *,
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *,
    struct bav_variable *);

extern BAP_DLL void bap_lsr3_Ducos_polynom_mpzm (
    struct bap_tableof_polynom_mpzm *,
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *,
    struct bav_variable *);

#   undef BAD_FLAG_mpzm

END_C_DECLS
#endif /* !BAP_DUCOS_mpzm_H */
#if !defined (BAP_DUCOS_mpq_H)
#   define BAP_DUCOS_mpq_H 1

/* #   include "bap_common.h" */
/* #   include "bap_polynom_mpq.h" */
/* #   include "bap_product_mpq.h" */

BEGIN_C_DECLS

#   define BAD_FLAG_mpq

extern BAP_DLL void bap_muldiv_Lazard_polynom_mpq (
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *,
    bav_Idegree);

extern BAP_DLL void bap_muldiv2_Lazard_polynom_mpq (
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *,
    bav_Idegree);

extern BAP_DLL void bap_muldiv3_Lazard_polynom_mpq (
    struct bap_tableof_polynom_mpq *,
    struct bap_tableof_polynom_mpq *,
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *,
    bav_Idegree);

extern BAP_DLL void bap_nsr2_Ducos_polynom_mpq (
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *,
    struct bav_variable *);

extern BAP_DLL void bap_nsr3_Ducos_polynom_mpq (
    struct bap_tableof_polynom_mpq *,
    struct bap_tableof_polynom_mpq *,
    struct bap_tableof_polynom_mpq *,
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *,
    struct bav_variable *);

extern BAP_DLL void bap_resultant2_Ducos_polynom_mpq (
    struct bap_product_mpq *,
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *,
    struct bav_variable *);

extern BAP_DLL void bap_lsr3_Ducos_polynom_mpq (
    struct bap_tableof_polynom_mpq *,
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *,
    struct bav_variable *);

#   undef BAD_FLAG_mpq

END_C_DECLS
#endif /* !BAP_DUCOS_mpq_H */
#if !defined (BAP_DUCOS_mint_hp_H)
#   define BAP_DUCOS_mint_hp_H 1

/* #   include "bap_common.h" */
/* #   include "bap_polynom_mint_hp.h" */
/* #   include "bap_product_mint_hp.h" */

BEGIN_C_DECLS

#   define BAD_FLAG_mint_hp

extern BAP_DLL void bap_muldiv_Lazard_polynom_mint_hp (
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *,
    bav_Idegree);

extern BAP_DLL void bap_muldiv2_Lazard_polynom_mint_hp (
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *,
    bav_Idegree);

extern BAP_DLL void bap_muldiv3_Lazard_polynom_mint_hp (
    struct bap_tableof_polynom_mint_hp *,
    struct bap_tableof_polynom_mint_hp *,
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *,
    bav_Idegree);

extern BAP_DLL void bap_nsr2_Ducos_polynom_mint_hp (
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *,
    struct bav_variable *);

extern BAP_DLL void bap_nsr3_Ducos_polynom_mint_hp (
    struct bap_tableof_polynom_mint_hp *,
    struct bap_tableof_polynom_mint_hp *,
    struct bap_tableof_polynom_mint_hp *,
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *,
    struct bav_variable *);

extern BAP_DLL void bap_resultant2_Ducos_polynom_mint_hp (
    struct bap_product_mint_hp *,
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *,
    struct bav_variable *);

extern BAP_DLL void bap_lsr3_Ducos_polynom_mint_hp (
    struct bap_tableof_polynom_mint_hp *,
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *,
    struct bav_variable *);

#   undef BAD_FLAG_mint_hp

END_C_DECLS
#endif /* !BAP_DUCOS_mint_hp_H */
#if !defined (BAP_EVAL_POLYNOM_mpz_H)
#   define BAP_EVAL_POLYNOM_mpz_H 1

/* #   include "bap_polynom_mpz.h" */

BEGIN_C_DECLS

#   define BAD_FLAG_mpz
#   if defined (BAD_FLAG_mpz) || defined (BAD_FLAG_mpzm) || defined (BAD_FLAG_mpq)

extern BAP_DLL void bap_set_point_polynom_mpz (
    struct ba0_point *,
    struct bap_polynom_mpz *,
    bool);

extern BAP_DLL void bap_eval_to_polynom_at_numeric_polynom_mpz (
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    struct bav_variable *,
    ba0_mpz_t);
#   endif

#   if defined (BAD_FLAG_mpz) || defined (BAD_FLAG_mpzm)
extern BAP_DLL void bap_eval_to_polynom_at_value_int_p_polynom_mpz (
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    struct bav_value_int_p *);

extern BAP_DLL void bap_eval_to_polynom_at_point_int_p_polynom_mpz (
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    struct bav_point_int_p *);

extern BAP_DLL void bap_eval_to_numeric_at_point_int_p_polynom_mpz (
    ba0_mpz_t *,
    struct bap_polynom_mpz *,
    struct bav_point_int_p *);

extern BAP_DLL void bap_evalcoeff_at_point_int_p_polynom_mpz (
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    struct bav_point_int_p *);
#   endif
#   undef  BAD_FLAG_mpz

END_C_DECLS
#endif /* !BAP_EVAL_POLYNOM_mpz_H */
#if !defined (BAP_EVAL_POLYNOM_mpzm_H)
#   define BAP_EVAL_POLYNOM_mpzm_H 1

/* #   include "bap_polynom_mpzm.h" */

BEGIN_C_DECLS

#   define BAD_FLAG_mpzm
#   if defined (BAD_FLAG_mpz) || defined (BAD_FLAG_mpzm) || defined (BAD_FLAG_mpq)

extern BAP_DLL void bap_set_point_polynom_mpzm (
    struct ba0_point *,
    struct bap_polynom_mpzm *,
    bool);

extern BAP_DLL void bap_eval_to_polynom_at_numeric_polynom_mpzm (
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *,
    struct bav_variable *,
    ba0_mpzm_t);
#   endif

#   if defined (BAD_FLAG_mpz) || defined (BAD_FLAG_mpzm)
extern BAP_DLL void bap_eval_to_polynom_at_value_int_p_polynom_mpzm (
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *,
    struct bav_value_int_p *);

extern BAP_DLL void bap_eval_to_polynom_at_point_int_p_polynom_mpzm (
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *,
    struct bav_point_int_p *);

extern BAP_DLL void bap_eval_to_numeric_at_point_int_p_polynom_mpzm (
    ba0_mpzm_t *,
    struct bap_polynom_mpzm *,
    struct bav_point_int_p *);

extern BAP_DLL void bap_evalcoeff_at_point_int_p_polynom_mpzm (
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *,
    struct bav_point_int_p *);
#   endif
#   undef  BAD_FLAG_mpzm

END_C_DECLS
#endif /* !BAP_EVAL_POLYNOM_mpzm_H */
#if !defined (BAP_EVAL_POLYNOM_mpq_H)
#   define BAP_EVAL_POLYNOM_mpq_H 1

/* #   include "bap_polynom_mpq.h" */

BEGIN_C_DECLS

#   define BAD_FLAG_mpq
#   if defined (BAD_FLAG_mpz) || defined (BAD_FLAG_mpzm) || defined (BAD_FLAG_mpq)

extern BAP_DLL void bap_set_point_polynom_mpq (
    struct ba0_point *,
    struct bap_polynom_mpq *,
    bool);

extern BAP_DLL void bap_eval_to_polynom_at_numeric_polynom_mpq (
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *,
    struct bav_variable *,
    ba0_mpq_t);
#   endif

#   if defined (BAD_FLAG_mpz) || defined (BAD_FLAG_mpzm)
extern BAP_DLL void bap_eval_to_polynom_at_value_int_p_polynom_mpq (
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *,
    struct bav_value_int_p *);

extern BAP_DLL void bap_eval_to_polynom_at_point_int_p_polynom_mpq (
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *,
    struct bav_point_int_p *);

extern BAP_DLL void bap_eval_to_numeric_at_point_int_p_polynom_mpq (
    ba0_mpq_t *,
    struct bap_polynom_mpq *,
    struct bav_point_int_p *);

extern BAP_DLL void bap_evalcoeff_at_point_int_p_polynom_mpq (
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *,
    struct bav_point_int_p *);
#   endif
#   undef  BAD_FLAG_mpq

END_C_DECLS
#endif /* !BAP_EVAL_POLYNOM_mpq_H */
#if !defined (BAP_EVAL_POLYNOM_mint_hp_H)
#   define BAP_EVAL_POLYNOM_mint_hp_H 1

/* #   include "bap_polynom_mint_hp.h" */

BEGIN_C_DECLS

#   define BAD_FLAG_mint_hp
#   if defined (BAD_FLAG_mpz) || defined (BAD_FLAG_mpzm) || defined (BAD_FLAG_mpq)

extern BAP_DLL void bap_set_point_polynom_mint_hp (
    struct ba0_point *,
    struct bap_polynom_mint_hp *,
    bool);

extern BAP_DLL void bap_eval_to_polynom_at_numeric_polynom_mint_hp (
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *,
    struct bav_variable *,
    ba0_mint_hp_t);
#   endif

#   if defined (BAD_FLAG_mpz) || defined (BAD_FLAG_mpzm)
extern BAP_DLL void bap_eval_to_polynom_at_value_int_p_polynom_mint_hp (
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *,
    struct bav_value_int_p *);

extern BAP_DLL void bap_eval_to_polynom_at_point_int_p_polynom_mint_hp (
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *,
    struct bav_point_int_p *);

extern BAP_DLL void bap_eval_to_numeric_at_point_int_p_polynom_mint_hp (
    ba0_mint_hp_t *,
    struct bap_polynom_mint_hp *,
    struct bav_point_int_p *);

extern BAP_DLL void bap_evalcoeff_at_point_int_p_polynom_mint_hp (
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *,
    struct bav_point_int_p *);
#   endif
#   undef  BAD_FLAG_mint_hp

END_C_DECLS
#endif /* !BAP_EVAL_POLYNOM_mint_hp_H */
#if !defined (BAP_DIFF_POLYNOM_mpz_H)
#   define BAP_DIFF_POLYNOM_mpz_H 1

/* #   include "bap_common.h" */

BEGIN_C_DECLS

#   define BAD_FLAG_mpz
extern BAP_DLL bool bap_is_constant_polynom_mpz (
    struct bap_polynom_mpz *,
    struct bav_symbol *);

extern BAP_DLL bool bap_is_polynomial_with_constant_coefficients_mpz (
    struct bap_polynom_mpz *,
    struct bav_variable *,
    struct bav_symbol *);

extern BAP_DLL bool bap_is_independent_polynom_mpz (
    struct bap_polynom_mpz *);

extern BAP_DLL void bap_diff_polynom_mpz (
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    struct bav_symbol *);

extern BAP_DLL void bap_diff2_polynom_mpz (
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    struct bav_term *);

extern BAP_DLL void bap_involved_derivations_polynom_mpz (
    struct bav_tableof_variable *,
    struct bap_polynom_mpz *);

extern BAP_DLL void bap_involved_parameters_polynom_mpz (
    struct bav_dictionary_symbol *,
    struct bav_tableof_symbol *,
    struct bap_polynom_mpz *);

#   undef  BAD_FLAG_mpz

END_C_DECLS
#endif /* !BAP_DIFF_POLYNOM_mpz_H */
#if !defined (BAP_DIFF_POLYNOM_mpzm_H)
#   define BAP_DIFF_POLYNOM_mpzm_H 1

/* #   include "bap_common.h" */

BEGIN_C_DECLS

#   define BAD_FLAG_mpzm
extern BAP_DLL bool bap_is_constant_polynom_mpzm (
    struct bap_polynom_mpzm *,
    struct bav_symbol *);

extern BAP_DLL bool bap_is_polynomial_with_constant_coefficients_mpzm (
    struct bap_polynom_mpzm *,
    struct bav_variable *,
    struct bav_symbol *);

extern BAP_DLL bool bap_is_independent_polynom_mpzm (
    struct bap_polynom_mpzm *);

extern BAP_DLL void bap_diff_polynom_mpzm (
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *,
    struct bav_symbol *);

extern BAP_DLL void bap_diff2_polynom_mpzm (
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *,
    struct bav_term *);

extern BAP_DLL void bap_involved_derivations_polynom_mpzm (
    struct bav_tableof_variable *,
    struct bap_polynom_mpzm *);

extern BAP_DLL void bap_involved_parameters_polynom_mpzm (
    struct bav_dictionary_symbol *,
    struct bav_tableof_symbol *,
    struct bap_polynom_mpzm *);

#   undef  BAD_FLAG_mpzm

END_C_DECLS
#endif /* !BAP_DIFF_POLYNOM_mpzm_H */
#if !defined (BAP_DIFF_POLYNOM_mpq_H)
#   define BAP_DIFF_POLYNOM_mpq_H 1

/* #   include "bap_common.h" */

BEGIN_C_DECLS

#   define BAD_FLAG_mpq
extern BAP_DLL bool bap_is_constant_polynom_mpq (
    struct bap_polynom_mpq *,
    struct bav_symbol *);

extern BAP_DLL bool bap_is_polynomial_with_constant_coefficients_mpq (
    struct bap_polynom_mpq *,
    struct bav_variable *,
    struct bav_symbol *);

extern BAP_DLL bool bap_is_independent_polynom_mpq (
    struct bap_polynom_mpq *);

extern BAP_DLL void bap_diff_polynom_mpq (
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *,
    struct bav_symbol *);

extern BAP_DLL void bap_diff2_polynom_mpq (
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *,
    struct bav_term *);

extern BAP_DLL void bap_involved_derivations_polynom_mpq (
    struct bav_tableof_variable *,
    struct bap_polynom_mpq *);

extern BAP_DLL void bap_involved_parameters_polynom_mpq (
    struct bav_dictionary_symbol *,
    struct bav_tableof_symbol *,
    struct bap_polynom_mpq *);

#   undef  BAD_FLAG_mpq

END_C_DECLS
#endif /* !BAP_DIFF_POLYNOM_mpq_H */
#if !defined (BAP_DIFF_POLYNOM_mint_hp_H)
#   define BAP_DIFF_POLYNOM_mint_hp_H 1

/* #   include "bap_common.h" */

BEGIN_C_DECLS

#   define BAD_FLAG_mint_hp
extern BAP_DLL bool bap_is_constant_polynom_mint_hp (
    struct bap_polynom_mint_hp *,
    struct bav_symbol *);

extern BAP_DLL bool bap_is_polynomial_with_constant_coefficients_mint_hp (
    struct bap_polynom_mint_hp *,
    struct bav_variable *,
    struct bav_symbol *);

extern BAP_DLL bool bap_is_independent_polynom_mint_hp (
    struct bap_polynom_mint_hp *);

extern BAP_DLL void bap_diff_polynom_mint_hp (
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *,
    struct bav_symbol *);

extern BAP_DLL void bap_diff2_polynom_mint_hp (
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *,
    struct bav_term *);

extern BAP_DLL void bap_involved_derivations_polynom_mint_hp (
    struct bav_tableof_variable *,
    struct bap_polynom_mint_hp *);

extern BAP_DLL void bap_involved_parameters_polynom_mint_hp (
    struct bav_dictionary_symbol *,
    struct bav_tableof_symbol *,
    struct bap_polynom_mint_hp *);

#   undef  BAD_FLAG_mint_hp

END_C_DECLS
#endif /* !BAP_DIFF_POLYNOM_mint_hp_H */
#if !defined (BAP_INVERT_mpzm_H)
#   define BAP_INVERT_mpzm_H 1

/* #   include "bap_common.h" */
/* #   include "bap_polynom_mpzm.h" */

BEGIN_C_DECLS

#   define BAD_FLAG_mpzm

extern BAP_DLL void bap_numeric_initial_one_polynom_mpzm (
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *);

extern BAP_DLL void bap_Euclidean_division_polynom_mpzm (
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *);

extern BAP_DLL void bap_Euclid_polynom_mpzm (
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *);

extern BAP_DLL void bap_extended_Euclid_polynom_mpzm (
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *);

#   undef BAD_FLAG_mpzm

END_C_DECLS
#endif /* !BAP_INVERT_mpzm_H */
#if !defined (BAP_INVERT_mpq_H)
#   define BAP_INVERT_mpq_H 1

/* #   include "bap_common.h" */
/* #   include "bap_polynom_mpq.h" */

BEGIN_C_DECLS

#   define BAD_FLAG_mpq

extern BAP_DLL void bap_numeric_initial_one_polynom_mpq (
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *);

extern BAP_DLL void bap_Euclidean_division_polynom_mpq (
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *);

extern BAP_DLL void bap_Euclid_polynom_mpq (
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *);

extern BAP_DLL void bap_extended_Euclid_polynom_mpq (
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *);

#   undef BAD_FLAG_mpq

END_C_DECLS
#endif /* !BAP_INVERT_mpq_H */
#if !defined (BAP_INVERT_mint_hp_H)
#   define BAP_INVERT_mint_hp_H 1

/* #   include "bap_common.h" */
/* #   include "bap_polynom_mint_hp.h" */

BEGIN_C_DECLS

#   define BAD_FLAG_mint_hp

extern BAP_DLL void bap_numeric_initial_one_polynom_mint_hp (
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *);

extern BAP_DLL void bap_Euclidean_division_polynom_mint_hp (
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *);

extern BAP_DLL void bap_Euclid_polynom_mint_hp (
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *);

extern BAP_DLL void bap_extended_Euclid_polynom_mint_hp (
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *);

#   undef BAD_FLAG_mint_hp

END_C_DECLS
#endif /* !BAP_INVERT_mint_hp_H */
#if !defined (BAP_CREATOR_mpz_H)
#   define BAP_CREATOR_mpz_H 1

/* #   include "bap_common.h" */
/* #   include "bap_clot_mpz.h" */
/* #   include "bap_polynom_mpz.h" */

#   define BAD_FLAG_mpz

BEGIN_C_DECLS

/*
 * texinfo: bap_creator_mpz
 * This data type permits to create a polynomial from scratch
 * by giving, in decreasing order, its terms and numerical
 * coefficients.
 */

struct bap_creator_mpz
{
// the polynomial to create
  struct bap_polynom_mpz *poly;
// a creator for the clot of the polynomial
  struct bap_creator_clot_mpz crea;
// the type of the total rank provided when initializing the process
  enum bap_typeof_total_rank type;
};


extern BAP_DLL void bap_begin_creator_mpz (
    struct bap_creator_mpz *,
    struct bap_polynom_mpz *,
    struct bav_term *,
    enum bap_typeof_total_rank,
    ba0_int_p);

extern BAP_DLL void bap_append_creator_mpz (
    struct bap_creator_mpz *,
    struct bap_polynom_mpz *,
    ba0_int_p);

extern BAP_DLL void bap_write_creator_mpz (
    struct bap_creator_mpz *,
    struct bav_term *,
    ba0_mpz_t);

extern BAP_DLL void bap_write_neg_creator_mpz (
    struct bap_creator_mpz *,
    struct bav_term *,
    ba0_mpz_t);

extern BAP_DLL bool bap_is_write_allable_creator_mpz (
    struct bap_creator_mpz *,
    struct bap_polynom_mpz *);

extern BAP_DLL void bap_write_all_creator_mpz (
    struct bap_creator_mpz *,
    struct bap_polynom_mpz *);

extern BAP_DLL void bap_write_neg_all_creator_mpz (
    struct bap_creator_mpz *,
    struct bap_polynom_mpz *);

extern BAP_DLL void bap_write_mul_all_creator_mpz (
    struct bap_creator_mpz *,
    struct bap_polynom_mpz *,
    ba0_mpz_t);

#   if defined BAD_FLAG_mpz

extern BAP_DLL void bap_write_exquo_all_creator_mpz (
    struct bap_creator_mpz *,
    struct bap_polynom_mpz *,
    ba0_mpz_t);

#   endif

extern BAP_DLL void bap_close_creator_mpz (
    struct bap_creator_mpz *);

END_C_DECLS
#   undef  BAD_FLAG_mpz
#endif /* !BAP_CREATOR_mpz_H */
#if !defined (BAP_CREATOR_mpzm_H)
#   define BAP_CREATOR_mpzm_H 1

/* #   include "bap_common.h" */
/* #   include "bap_clot_mpzm.h" */
/* #   include "bap_polynom_mpzm.h" */

#   define BAD_FLAG_mpzm

BEGIN_C_DECLS

/*
 * texinfo: bap_creator_mpzm
 * This data type permits to create a polynomial from scratch
 * by giving, in decreasing order, its terms and numerical
 * coefficients.
 */

struct bap_creator_mpzm
{
// the polynomial to create
  struct bap_polynom_mpzm *poly;
// a creator for the clot of the polynomial
  struct bap_creator_clot_mpzm crea;
// the type of the total rank provided when initializing the process
  enum bap_typeof_total_rank type;
};


extern BAP_DLL void bap_begin_creator_mpzm (
    struct bap_creator_mpzm *,
    struct bap_polynom_mpzm *,
    struct bav_term *,
    enum bap_typeof_total_rank,
    ba0_int_p);

extern BAP_DLL void bap_append_creator_mpzm (
    struct bap_creator_mpzm *,
    struct bap_polynom_mpzm *,
    ba0_int_p);

extern BAP_DLL void bap_write_creator_mpzm (
    struct bap_creator_mpzm *,
    struct bav_term *,
    ba0_mpzm_t);

extern BAP_DLL void bap_write_neg_creator_mpzm (
    struct bap_creator_mpzm *,
    struct bav_term *,
    ba0_mpzm_t);

extern BAP_DLL bool bap_is_write_allable_creator_mpzm (
    struct bap_creator_mpzm *,
    struct bap_polynom_mpzm *);

extern BAP_DLL void bap_write_all_creator_mpzm (
    struct bap_creator_mpzm *,
    struct bap_polynom_mpzm *);

extern BAP_DLL void bap_write_neg_all_creator_mpzm (
    struct bap_creator_mpzm *,
    struct bap_polynom_mpzm *);

extern BAP_DLL void bap_write_mul_all_creator_mpzm (
    struct bap_creator_mpzm *,
    struct bap_polynom_mpzm *,
    ba0_mpzm_t);

#   if defined BAD_FLAG_mpz

extern BAP_DLL void bap_write_exquo_all_creator_mpz (
    struct bap_creator_mpz *,
    struct bap_polynom_mpz *,
    ba0_mpz_t);

#   endif

extern BAP_DLL void bap_close_creator_mpzm (
    struct bap_creator_mpzm *);

END_C_DECLS
#   undef  BAD_FLAG_mpzm
#endif /* !BAP_CREATOR_mpzm_H */
#if !defined (BAP_CREATOR_mpq_H)
#   define BAP_CREATOR_mpq_H 1

/* #   include "bap_common.h" */
/* #   include "bap_clot_mpq.h" */
/* #   include "bap_polynom_mpq.h" */

#   define BAD_FLAG_mpq

BEGIN_C_DECLS

/*
 * texinfo: bap_creator_mpq
 * This data type permits to create a polynomial from scratch
 * by giving, in decreasing order, its terms and numerical
 * coefficients.
 */

struct bap_creator_mpq
{
// the polynomial to create
  struct bap_polynom_mpq *poly;
// a creator for the clot of the polynomial
  struct bap_creator_clot_mpq crea;
// the type of the total rank provided when initializing the process
  enum bap_typeof_total_rank type;
};


extern BAP_DLL void bap_begin_creator_mpq (
    struct bap_creator_mpq *,
    struct bap_polynom_mpq *,
    struct bav_term *,
    enum bap_typeof_total_rank,
    ba0_int_p);

extern BAP_DLL void bap_append_creator_mpq (
    struct bap_creator_mpq *,
    struct bap_polynom_mpq *,
    ba0_int_p);

extern BAP_DLL void bap_write_creator_mpq (
    struct bap_creator_mpq *,
    struct bav_term *,
    ba0_mpq_t);

extern BAP_DLL void bap_write_neg_creator_mpq (
    struct bap_creator_mpq *,
    struct bav_term *,
    ba0_mpq_t);

extern BAP_DLL bool bap_is_write_allable_creator_mpq (
    struct bap_creator_mpq *,
    struct bap_polynom_mpq *);

extern BAP_DLL void bap_write_all_creator_mpq (
    struct bap_creator_mpq *,
    struct bap_polynom_mpq *);

extern BAP_DLL void bap_write_neg_all_creator_mpq (
    struct bap_creator_mpq *,
    struct bap_polynom_mpq *);

extern BAP_DLL void bap_write_mul_all_creator_mpq (
    struct bap_creator_mpq *,
    struct bap_polynom_mpq *,
    ba0_mpq_t);

#   if defined BAD_FLAG_mpz

extern BAP_DLL void bap_write_exquo_all_creator_mpz (
    struct bap_creator_mpz *,
    struct bap_polynom_mpz *,
    ba0_mpz_t);

#   endif

extern BAP_DLL void bap_close_creator_mpq (
    struct bap_creator_mpq *);

END_C_DECLS
#   undef  BAD_FLAG_mpq
#endif /* !BAP_CREATOR_mpq_H */
#if !defined (BAP_CREATOR_mint_hp_H)
#   define BAP_CREATOR_mint_hp_H 1

/* #   include "bap_common.h" */
/* #   include "bap_clot_mint_hp.h" */
/* #   include "bap_polynom_mint_hp.h" */

#   define BAD_FLAG_mint_hp

BEGIN_C_DECLS

/*
 * texinfo: bap_creator_mint_hp
 * This data type permits to create a polynomial from scratch
 * by giving, in decreasing order, its terms and numerical
 * coefficients.
 */

struct bap_creator_mint_hp
{
// the polynomial to create
  struct bap_polynom_mint_hp *poly;
// a creator for the clot of the polynomial
  struct bap_creator_clot_mint_hp crea;
// the type of the total rank provided when initializing the process
  enum bap_typeof_total_rank type;
};


extern BAP_DLL void bap_begin_creator_mint_hp (
    struct bap_creator_mint_hp *,
    struct bap_polynom_mint_hp *,
    struct bav_term *,
    enum bap_typeof_total_rank,
    ba0_int_p);

extern BAP_DLL void bap_append_creator_mint_hp (
    struct bap_creator_mint_hp *,
    struct bap_polynom_mint_hp *,
    ba0_int_p);

extern BAP_DLL void bap_write_creator_mint_hp (
    struct bap_creator_mint_hp *,
    struct bav_term *,
    ba0_mint_hp_t);

extern BAP_DLL void bap_write_neg_creator_mint_hp (
    struct bap_creator_mint_hp *,
    struct bav_term *,
    ba0_mint_hp_t);

extern BAP_DLL bool bap_is_write_allable_creator_mint_hp (
    struct bap_creator_mint_hp *,
    struct bap_polynom_mint_hp *);

extern BAP_DLL void bap_write_all_creator_mint_hp (
    struct bap_creator_mint_hp *,
    struct bap_polynom_mint_hp *);

extern BAP_DLL void bap_write_neg_all_creator_mint_hp (
    struct bap_creator_mint_hp *,
    struct bap_polynom_mint_hp *);

extern BAP_DLL void bap_write_mul_all_creator_mint_hp (
    struct bap_creator_mint_hp *,
    struct bap_polynom_mint_hp *,
    ba0_mint_hp_t);

#   if defined BAD_FLAG_mpz

extern BAP_DLL void bap_write_exquo_all_creator_mpz (
    struct bap_creator_mpz *,
    struct bap_polynom_mpz *,
    ba0_mpz_t);

#   endif

extern BAP_DLL void bap_close_creator_mint_hp (
    struct bap_creator_mint_hp *);

END_C_DECLS
#   undef  BAD_FLAG_mint_hp
#endif /* !BAP_CREATOR_mint_hp_H */
#if !defined (BAP_ITERMON_mpz_H)
#   define BAP_ITERMON_mpz_H 1

/* #   include "bap_common.h" */
/* #   include "bap_polynom_mpz.h" */
/* #   include "bap_iterator_indexed_access.h" */

#   define BAD_FLAG_mpz

BEGIN_C_DECLS

/*
 * texinfo: bap_itermon_mpz
 * This data type implements an iterator of monomials of a
 * differential polynomials, viewed as multivariate polynomial
 * over the numerical coefficients.
 * The monomials of the polynomial may be accessed either in
 * sequential access as in indexed access.
 */

struct bap_itermon_mpz
{
  struct bap_polynom_mpz *poly;       // the polynomial
// an iterator of monomials of poly->clot
  struct bap_itermon_clot_mpz iter;
// an auxiliary data structure if access is indexed
// it provides the current index in poly->ind.tab
  struct bap_iterator_indexed_access iter_ix;
};


extern BAP_DLL void bap_begin_itermon_mpz (
    struct bap_itermon_mpz *,
    struct bap_polynom_mpz *);

extern BAP_DLL void bap_end_itermon_mpz (
    struct bap_itermon_mpz *,
    struct bap_polynom_mpz *);

extern BAP_DLL void bap_close_itermon_mpz (
    struct bap_itermon_mpz *);

extern BAP_DLL void bap_set_itermon_mpz (
    struct bap_itermon_mpz *,
    struct bap_itermon_mpz *);

extern BAP_DLL bool bap_outof_itermon_mpz (
    struct bap_itermon_mpz *);

extern BAP_DLL void bap_next_itermon_mpz (
    struct bap_itermon_mpz *);

extern BAP_DLL void bap_prev_itermon_mpz (
    struct bap_itermon_mpz *);

extern BAP_DLL void bap_goto_itermon_mpz (
    struct bap_itermon_mpz *,
    ba0_int_p);

extern BAP_DLL ba0_mpz_t *bap_coeff_itermon_mpz (
    struct bap_itermon_mpz *);

extern BAP_DLL void bap_term_itermon_mpz (
    struct bav_term *,
    struct bap_itermon_mpz *);

extern BAP_DLL void bap_reductum_itermon_mpz (
    struct bap_itermon_mpz *,
    struct bap_polynom_mpz *);

extern BAP_DLL void bap_seekfirst_itermon_mpz (
    struct bap_itermon_mpz *,
    enum bap_rank_code (*)(struct bav_term *,
        struct bav_term *,
        bav_Inumber),
    struct bav_term *,
    bav_Inumber);

extern BAP_DLL void bap_seeklast_itermon_mpz (
    struct bap_itermon_mpz *,
    enum bap_rank_code (*)(struct bav_term *,
        struct bav_term *,
        bav_Inumber),
    struct bav_term *,
    bav_Inumber);

END_C_DECLS
#   undef  BAD_FLAG_mpz
#endif /* !BAP_ITERMON_mpz_H */
#if !defined (BAP_ITERMON_mpzm_H)
#   define BAP_ITERMON_mpzm_H 1

/* #   include "bap_common.h" */
/* #   include "bap_polynom_mpzm.h" */
/* #   include "bap_iterator_indexed_access.h" */

#   define BAD_FLAG_mpzm

BEGIN_C_DECLS

/*
 * texinfo: bap_itermon_mpzm
 * This data type implements an iterator of monomials of a
 * differential polynomials, viewed as multivariate polynomial
 * over the numerical coefficients.
 * The monomials of the polynomial may be accessed either in
 * sequential access as in indexed access.
 */

struct bap_itermon_mpzm
{
  struct bap_polynom_mpzm *poly;       // the polynomial
// an iterator of monomials of poly->clot
  struct bap_itermon_clot_mpzm iter;
// an auxiliary data structure if access is indexed
// it provides the current index in poly->ind.tab
  struct bap_iterator_indexed_access iter_ix;
};


extern BAP_DLL void bap_begin_itermon_mpzm (
    struct bap_itermon_mpzm *,
    struct bap_polynom_mpzm *);

extern BAP_DLL void bap_end_itermon_mpzm (
    struct bap_itermon_mpzm *,
    struct bap_polynom_mpzm *);

extern BAP_DLL void bap_close_itermon_mpzm (
    struct bap_itermon_mpzm *);

extern BAP_DLL void bap_set_itermon_mpzm (
    struct bap_itermon_mpzm *,
    struct bap_itermon_mpzm *);

extern BAP_DLL bool bap_outof_itermon_mpzm (
    struct bap_itermon_mpzm *);

extern BAP_DLL void bap_next_itermon_mpzm (
    struct bap_itermon_mpzm *);

extern BAP_DLL void bap_prev_itermon_mpzm (
    struct bap_itermon_mpzm *);

extern BAP_DLL void bap_goto_itermon_mpzm (
    struct bap_itermon_mpzm *,
    ba0_int_p);

extern BAP_DLL ba0_mpzm_t *bap_coeff_itermon_mpzm (
    struct bap_itermon_mpzm *);

extern BAP_DLL void bap_term_itermon_mpzm (
    struct bav_term *,
    struct bap_itermon_mpzm *);

extern BAP_DLL void bap_reductum_itermon_mpzm (
    struct bap_itermon_mpzm *,
    struct bap_polynom_mpzm *);

extern BAP_DLL void bap_seekfirst_itermon_mpzm (
    struct bap_itermon_mpzm *,
    enum bap_rank_code (*)(struct bav_term *,
        struct bav_term *,
        bav_Inumber),
    struct bav_term *,
    bav_Inumber);

extern BAP_DLL void bap_seeklast_itermon_mpzm (
    struct bap_itermon_mpzm *,
    enum bap_rank_code (*)(struct bav_term *,
        struct bav_term *,
        bav_Inumber),
    struct bav_term *,
    bav_Inumber);

END_C_DECLS
#   undef  BAD_FLAG_mpzm
#endif /* !BAP_ITERMON_mpzm_H */
#if !defined (BAP_ITERMON_mpq_H)
#   define BAP_ITERMON_mpq_H 1

/* #   include "bap_common.h" */
/* #   include "bap_polynom_mpq.h" */
/* #   include "bap_iterator_indexed_access.h" */

#   define BAD_FLAG_mpq

BEGIN_C_DECLS

/*
 * texinfo: bap_itermon_mpq
 * This data type implements an iterator of monomials of a
 * differential polynomials, viewed as multivariate polynomial
 * over the numerical coefficients.
 * The monomials of the polynomial may be accessed either in
 * sequential access as in indexed access.
 */

struct bap_itermon_mpq
{
  struct bap_polynom_mpq *poly;       // the polynomial
// an iterator of monomials of poly->clot
  struct bap_itermon_clot_mpq iter;
// an auxiliary data structure if access is indexed
// it provides the current index in poly->ind.tab
  struct bap_iterator_indexed_access iter_ix;
};


extern BAP_DLL void bap_begin_itermon_mpq (
    struct bap_itermon_mpq *,
    struct bap_polynom_mpq *);

extern BAP_DLL void bap_end_itermon_mpq (
    struct bap_itermon_mpq *,
    struct bap_polynom_mpq *);

extern BAP_DLL void bap_close_itermon_mpq (
    struct bap_itermon_mpq *);

extern BAP_DLL void bap_set_itermon_mpq (
    struct bap_itermon_mpq *,
    struct bap_itermon_mpq *);

extern BAP_DLL bool bap_outof_itermon_mpq (
    struct bap_itermon_mpq *);

extern BAP_DLL void bap_next_itermon_mpq (
    struct bap_itermon_mpq *);

extern BAP_DLL void bap_prev_itermon_mpq (
    struct bap_itermon_mpq *);

extern BAP_DLL void bap_goto_itermon_mpq (
    struct bap_itermon_mpq *,
    ba0_int_p);

extern BAP_DLL ba0_mpq_t *bap_coeff_itermon_mpq (
    struct bap_itermon_mpq *);

extern BAP_DLL void bap_term_itermon_mpq (
    struct bav_term *,
    struct bap_itermon_mpq *);

extern BAP_DLL void bap_reductum_itermon_mpq (
    struct bap_itermon_mpq *,
    struct bap_polynom_mpq *);

extern BAP_DLL void bap_seekfirst_itermon_mpq (
    struct bap_itermon_mpq *,
    enum bap_rank_code (*)(struct bav_term *,
        struct bav_term *,
        bav_Inumber),
    struct bav_term *,
    bav_Inumber);

extern BAP_DLL void bap_seeklast_itermon_mpq (
    struct bap_itermon_mpq *,
    enum bap_rank_code (*)(struct bav_term *,
        struct bav_term *,
        bav_Inumber),
    struct bav_term *,
    bav_Inumber);

END_C_DECLS
#   undef  BAD_FLAG_mpq
#endif /* !BAP_ITERMON_mpq_H */
#if !defined (BAP_ITERMON_mint_hp_H)
#   define BAP_ITERMON_mint_hp_H 1

/* #   include "bap_common.h" */
/* #   include "bap_polynom_mint_hp.h" */
/* #   include "bap_iterator_indexed_access.h" */

#   define BAD_FLAG_mint_hp

BEGIN_C_DECLS

/*
 * texinfo: bap_itermon_mint_hp
 * This data type implements an iterator of monomials of a
 * differential polynomials, viewed as multivariate polynomial
 * over the numerical coefficients.
 * The monomials of the polynomial may be accessed either in
 * sequential access as in indexed access.
 */

struct bap_itermon_mint_hp
{
  struct bap_polynom_mint_hp *poly;       // the polynomial
// an iterator of monomials of poly->clot
  struct bap_itermon_clot_mint_hp iter;
// an auxiliary data structure if access is indexed
// it provides the current index in poly->ind.tab
  struct bap_iterator_indexed_access iter_ix;
};


extern BAP_DLL void bap_begin_itermon_mint_hp (
    struct bap_itermon_mint_hp *,
    struct bap_polynom_mint_hp *);

extern BAP_DLL void bap_end_itermon_mint_hp (
    struct bap_itermon_mint_hp *,
    struct bap_polynom_mint_hp *);

extern BAP_DLL void bap_close_itermon_mint_hp (
    struct bap_itermon_mint_hp *);

extern BAP_DLL void bap_set_itermon_mint_hp (
    struct bap_itermon_mint_hp *,
    struct bap_itermon_mint_hp *);

extern BAP_DLL bool bap_outof_itermon_mint_hp (
    struct bap_itermon_mint_hp *);

extern BAP_DLL void bap_next_itermon_mint_hp (
    struct bap_itermon_mint_hp *);

extern BAP_DLL void bap_prev_itermon_mint_hp (
    struct bap_itermon_mint_hp *);

extern BAP_DLL void bap_goto_itermon_mint_hp (
    struct bap_itermon_mint_hp *,
    ba0_int_p);

extern BAP_DLL ba0_mint_hp_t *bap_coeff_itermon_mint_hp (
    struct bap_itermon_mint_hp *);

extern BAP_DLL void bap_term_itermon_mint_hp (
    struct bav_term *,
    struct bap_itermon_mint_hp *);

extern BAP_DLL void bap_reductum_itermon_mint_hp (
    struct bap_itermon_mint_hp *,
    struct bap_polynom_mint_hp *);

extern BAP_DLL void bap_seekfirst_itermon_mint_hp (
    struct bap_itermon_mint_hp *,
    enum bap_rank_code (*)(struct bav_term *,
        struct bav_term *,
        bav_Inumber),
    struct bav_term *,
    bav_Inumber);

extern BAP_DLL void bap_seeklast_itermon_mint_hp (
    struct bap_itermon_mint_hp *,
    enum bap_rank_code (*)(struct bav_term *,
        struct bav_term *,
        bav_Inumber),
    struct bav_term *,
    bav_Inumber);

END_C_DECLS
#   undef  BAD_FLAG_mint_hp
#endif /* !BAP_ITERMON_mint_hp_H */
#if !defined (BAP_ITERKOEFF_mpz_H)
#   define BAP_ITERKOEFF_mpz_H 1

/* #   include "bap_common.h" */
/* #   include "bap_polynom_mpz.h" */
/* #   include "bap_itermon_mpz.h" */

#   define BAD_FLAG_mpz

BEGIN_C_DECLS

/*
 * texinfo: bap_itercoeff_mpz
 * This data type implements an iterator of coefficients of a 
 * differential polynomials, with respect to a given variable.
 * Let @var{A} be a polynomial and @math{X = x_1 < \cdots < x_n} be 
 * the alphabet of the variables it depends on. 
 * Let @math{1 \leq i \leq n} be an index.
 * The iterator permits to extract the coefficients of @var{A}, viewed as 
 * a polynomial over the alphabet @math{x_i, \ldots, x_n}, with 
 * coefficients in the ring of the polynomials over the alphabet 
 * @math{x_1, \ldots, x_{i-1}}.
 */

struct bap_itercoeff_mpz
{
  struct bap_polynom_mpz *poly;       // the polynomial
  struct bav_variable *last_variable;   // the lowest variable among the terms
// debut is set on the first monomial of the current coefficient
  struct bap_itermon_mpz debut;
// fin is set on the last monomial of the current coefficient
  struct bap_itermon_mpz fin;
  bool outof;                   // true if the iterator is outside the polynomial
};


extern BAP_DLL void bap_begin_itercoeff_mpz (
    struct bap_itercoeff_mpz *,
    struct bap_polynom_mpz *,
    struct bav_variable *);

extern BAP_DLL void bap_end_itercoeff_mpz (
    struct bap_itercoeff_mpz *,
    struct bap_polynom_mpz *,
    struct bav_variable *);

extern BAP_DLL bool bap_outof_itercoeff_mpz (
    struct bap_itercoeff_mpz *);

extern BAP_DLL void bap_close_itercoeff_mpz (
    struct bap_itercoeff_mpz *);

extern BAP_DLL void bap_next_itercoeff_mpz (
    struct bap_itercoeff_mpz *);

extern BAP_DLL void bap_prev_itercoeff_mpz (
    struct bap_itercoeff_mpz *);

extern BAP_DLL void bap_term_itercoeff_mpz (
    struct bav_term *,
    struct bap_itercoeff_mpz *);

extern BAP_DLL void bap_coeff_itercoeff_mpz (
    struct bap_polynom_mpz *,
    struct bap_itercoeff_mpz *);

extern BAP_DLL void bap_seek_coeff_itercoeff_mpz (
    struct bap_polynom_mpz *,
    struct bap_itercoeff_mpz *,
    struct bav_term *);

extern BAP_DLL void bap_split_polynom_mpz (
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    struct bav_term *);

END_C_DECLS
#   undef  BAD_FLAG_mpz
#endif /* !BAP_ITERKOEFF_mpz_H */
#if !defined (BAP_ITERKOEFF_mpzm_H)
#   define BAP_ITERKOEFF_mpzm_H 1

/* #   include "bap_common.h" */
/* #   include "bap_polynom_mpzm.h" */
/* #   include "bap_itermon_mpzm.h" */

#   define BAD_FLAG_mpzm

BEGIN_C_DECLS

/*
 * texinfo: bap_itercoeff_mpzm
 * This data type implements an iterator of coefficients of a 
 * differential polynomials, with respect to a given variable.
 * Let @var{A} be a polynomial and @math{X = x_1 < \cdots < x_n} be 
 * the alphabet of the variables it depends on. 
 * Let @math{1 \leq i \leq n} be an index.
 * The iterator permits to extract the coefficients of @var{A}, viewed as 
 * a polynomial over the alphabet @math{x_i, \ldots, x_n}, with 
 * coefficients in the ring of the polynomials over the alphabet 
 * @math{x_1, \ldots, x_{i-1}}.
 */

struct bap_itercoeff_mpzm
{
  struct bap_polynom_mpzm *poly;       // the polynomial
  struct bav_variable *last_variable;   // the lowest variable among the terms
// debut is set on the first monomial of the current coefficient
  struct bap_itermon_mpzm debut;
// fin is set on the last monomial of the current coefficient
  struct bap_itermon_mpzm fin;
  bool outof;                   // true if the iterator is outside the polynomial
};


extern BAP_DLL void bap_begin_itercoeff_mpzm (
    struct bap_itercoeff_mpzm *,
    struct bap_polynom_mpzm *,
    struct bav_variable *);

extern BAP_DLL void bap_end_itercoeff_mpzm (
    struct bap_itercoeff_mpzm *,
    struct bap_polynom_mpzm *,
    struct bav_variable *);

extern BAP_DLL bool bap_outof_itercoeff_mpzm (
    struct bap_itercoeff_mpzm *);

extern BAP_DLL void bap_close_itercoeff_mpzm (
    struct bap_itercoeff_mpzm *);

extern BAP_DLL void bap_next_itercoeff_mpzm (
    struct bap_itercoeff_mpzm *);

extern BAP_DLL void bap_prev_itercoeff_mpzm (
    struct bap_itercoeff_mpzm *);

extern BAP_DLL void bap_term_itercoeff_mpzm (
    struct bav_term *,
    struct bap_itercoeff_mpzm *);

extern BAP_DLL void bap_coeff_itercoeff_mpzm (
    struct bap_polynom_mpzm *,
    struct bap_itercoeff_mpzm *);

extern BAP_DLL void bap_seek_coeff_itercoeff_mpzm (
    struct bap_polynom_mpzm *,
    struct bap_itercoeff_mpzm *,
    struct bav_term *);

extern BAP_DLL void bap_split_polynom_mpzm (
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *,
    struct bav_term *);

END_C_DECLS
#   undef  BAD_FLAG_mpzm
#endif /* !BAP_ITERKOEFF_mpzm_H */
#if !defined (BAP_ITERKOEFF_mpq_H)
#   define BAP_ITERKOEFF_mpq_H 1

/* #   include "bap_common.h" */
/* #   include "bap_polynom_mpq.h" */
/* #   include "bap_itermon_mpq.h" */

#   define BAD_FLAG_mpq

BEGIN_C_DECLS

/*
 * texinfo: bap_itercoeff_mpq
 * This data type implements an iterator of coefficients of a 
 * differential polynomials, with respect to a given variable.
 * Let @var{A} be a polynomial and @math{X = x_1 < \cdots < x_n} be 
 * the alphabet of the variables it depends on. 
 * Let @math{1 \leq i \leq n} be an index.
 * The iterator permits to extract the coefficients of @var{A}, viewed as 
 * a polynomial over the alphabet @math{x_i, \ldots, x_n}, with 
 * coefficients in the ring of the polynomials over the alphabet 
 * @math{x_1, \ldots, x_{i-1}}.
 */

struct bap_itercoeff_mpq
{
  struct bap_polynom_mpq *poly;       // the polynomial
  struct bav_variable *last_variable;   // the lowest variable among the terms
// debut is set on the first monomial of the current coefficient
  struct bap_itermon_mpq debut;
// fin is set on the last monomial of the current coefficient
  struct bap_itermon_mpq fin;
  bool outof;                   // true if the iterator is outside the polynomial
};


extern BAP_DLL void bap_begin_itercoeff_mpq (
    struct bap_itercoeff_mpq *,
    struct bap_polynom_mpq *,
    struct bav_variable *);

extern BAP_DLL void bap_end_itercoeff_mpq (
    struct bap_itercoeff_mpq *,
    struct bap_polynom_mpq *,
    struct bav_variable *);

extern BAP_DLL bool bap_outof_itercoeff_mpq (
    struct bap_itercoeff_mpq *);

extern BAP_DLL void bap_close_itercoeff_mpq (
    struct bap_itercoeff_mpq *);

extern BAP_DLL void bap_next_itercoeff_mpq (
    struct bap_itercoeff_mpq *);

extern BAP_DLL void bap_prev_itercoeff_mpq (
    struct bap_itercoeff_mpq *);

extern BAP_DLL void bap_term_itercoeff_mpq (
    struct bav_term *,
    struct bap_itercoeff_mpq *);

extern BAP_DLL void bap_coeff_itercoeff_mpq (
    struct bap_polynom_mpq *,
    struct bap_itercoeff_mpq *);

extern BAP_DLL void bap_seek_coeff_itercoeff_mpq (
    struct bap_polynom_mpq *,
    struct bap_itercoeff_mpq *,
    struct bav_term *);

extern BAP_DLL void bap_split_polynom_mpq (
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *,
    struct bav_term *);

END_C_DECLS
#   undef  BAD_FLAG_mpq
#endif /* !BAP_ITERKOEFF_mpq_H */
#if !defined (BAP_ITERKOEFF_mint_hp_H)
#   define BAP_ITERKOEFF_mint_hp_H 1

/* #   include "bap_common.h" */
/* #   include "bap_polynom_mint_hp.h" */
/* #   include "bap_itermon_mint_hp.h" */

#   define BAD_FLAG_mint_hp

BEGIN_C_DECLS

/*
 * texinfo: bap_itercoeff_mint_hp
 * This data type implements an iterator of coefficients of a 
 * differential polynomials, with respect to a given variable.
 * Let @var{A} be a polynomial and @math{X = x_1 < \cdots < x_n} be 
 * the alphabet of the variables it depends on. 
 * Let @math{1 \leq i \leq n} be an index.
 * The iterator permits to extract the coefficients of @var{A}, viewed as 
 * a polynomial over the alphabet @math{x_i, \ldots, x_n}, with 
 * coefficients in the ring of the polynomials over the alphabet 
 * @math{x_1, \ldots, x_{i-1}}.
 */

struct bap_itercoeff_mint_hp
{
  struct bap_polynom_mint_hp *poly;       // the polynomial
  struct bav_variable *last_variable;   // the lowest variable among the terms
// debut is set on the first monomial of the current coefficient
  struct bap_itermon_mint_hp debut;
// fin is set on the last monomial of the current coefficient
  struct bap_itermon_mint_hp fin;
  bool outof;                   // true if the iterator is outside the polynomial
};


extern BAP_DLL void bap_begin_itercoeff_mint_hp (
    struct bap_itercoeff_mint_hp *,
    struct bap_polynom_mint_hp *,
    struct bav_variable *);

extern BAP_DLL void bap_end_itercoeff_mint_hp (
    struct bap_itercoeff_mint_hp *,
    struct bap_polynom_mint_hp *,
    struct bav_variable *);

extern BAP_DLL bool bap_outof_itercoeff_mint_hp (
    struct bap_itercoeff_mint_hp *);

extern BAP_DLL void bap_close_itercoeff_mint_hp (
    struct bap_itercoeff_mint_hp *);

extern BAP_DLL void bap_next_itercoeff_mint_hp (
    struct bap_itercoeff_mint_hp *);

extern BAP_DLL void bap_prev_itercoeff_mint_hp (
    struct bap_itercoeff_mint_hp *);

extern BAP_DLL void bap_term_itercoeff_mint_hp (
    struct bav_term *,
    struct bap_itercoeff_mint_hp *);

extern BAP_DLL void bap_coeff_itercoeff_mint_hp (
    struct bap_polynom_mint_hp *,
    struct bap_itercoeff_mint_hp *);

extern BAP_DLL void bap_seek_coeff_itercoeff_mint_hp (
    struct bap_polynom_mint_hp *,
    struct bap_itercoeff_mint_hp *,
    struct bav_term *);

extern BAP_DLL void bap_split_polynom_mint_hp (
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mint_hp *,
    struct bav_term *);

END_C_DECLS
#   undef  BAD_FLAG_mint_hp
#endif /* !BAP_ITERKOEFF_mint_hp_H */
#if !defined (BAP_PRODUCT_mpz_H)
#   define BAP_PRODUCT_mpz_H 1

/* #   include "bap_common.h" */
/* #   include "bap_polynom_mpz.h" */

#   define BAD_FLAG_mpz

BEGIN_C_DECLS

/*
 * texinfo: bap_power_mpz
 * This data type implements a polynomial raised to some power.
 */

struct bap_power_mpz
{
  struct bap_polynom_mpz factor;
  bav_Idegree exponent;
};


/*
 * texinfo: bap_product_mpz
 * This data type implements products of polynomials of the form
 * @math{c \, f_1^{a_1} \cdots f_t^{a_t}}
 * where @var{c} is the @dfn{numerical factor} of the product, 
 * the @math{f_i} are non numerical polynomials, not necessarily 
 * irreducible and not even necessarily pairwise distinct. 
 * The exponents @math{a_i} are allowed to be zero. 
 * The product one is coded by @math{c = 1} and @math{t = 0}. 
 * The product zero is coded by @math{c = 0}.  
 * Observe that in the context of rings which are not domains, 
 * zero and one are not necessarily automatically recognized.
 */

struct bap_product_mpz
{
// the numerical factor
  ba0_mpz_t num_factor;
// the number of allocated entries of tab
  ba0_int_p alloc;
// the number of used entries
  ba0_int_p size;
// the array of bap_power_mpz
  struct bap_power_mpz *tab;
};

struct bap_tableof_product_mpz
{
  ba0_int_p alloc;
  ba0_int_p size;
  struct bap_product_mpz **tab;
};

extern BAP_DLL void bap_init_power_mpz (
    struct bap_power_mpz *);

extern BAP_DLL struct bap_power_mpz *bap_new_power_mpz (
    void);

extern BAP_DLL void bap_set_power_mpz (
    struct bap_power_mpz *,
    struct bap_power_mpz *);

extern BAP_DLL void bap_set_power_polynom_mpz (
    struct bap_power_mpz *,
    struct bap_polynom_mpz *,
    bav_Idegree);

extern BAP_DLL void bap_pow_power_mpz (
    struct bap_power_mpz *,
    struct bap_power_mpz *,
    bav_Idegree);

extern BAP_DLL void bap_init_product_mpz (
    struct bap_product_mpz *);

extern BAP_DLL void bap_init_product_zero_mpz (
    struct bap_product_mpz *);

extern BAP_DLL void bap_realloc_product_mpz (
    struct bap_product_mpz *,
    ba0_int_p);

extern BAP_DLL struct bap_product_mpz *bap_new_product_mpz (
    void);

extern BAP_DLL struct bap_product_mpz *bap_new_product_zero_mpz (
    void);

extern BAP_DLL bool bap_is_zero_product_mpz (
    struct bap_product_mpz *);

extern BAP_DLL bool bap_is_one_product_mpz (
    struct bap_product_mpz *);

extern BAP_DLL bool bap_is_numeric_product_mpz (
    struct bap_product_mpz *);

extern BAP_DLL struct bav_variable * bap_leader_product_mpz (
    struct bap_product_mpz *);

extern BAP_DLL void bap_set_product_zero_mpz (
    struct bap_product_mpz *);

extern BAP_DLL void bap_set_product_one_mpz (
    struct bap_product_mpz *);

extern BAP_DLL void bap_set_product_numeric_mpz (
    struct bap_product_mpz *,
    ba0_mpz_t);

extern BAP_DLL void bap_set_product_polynom_mpz (
    struct bap_product_mpz *,
    struct bap_polynom_mpz *,
    bav_Idegree);

extern BAP_DLL void bap_set_product_mpz (
    struct bap_product_mpz *,
    struct bap_product_mpz *);

extern BAP_DLL void bap_expand_product_mpz (
    struct bap_polynom_mpz *,
    struct bap_product_mpz *);

extern BAP_DLL void bap_mul_product_polynom_mpz (
    struct bap_product_mpz *,
    struct bap_product_mpz *,
    struct bap_polynom_mpz *,
    bav_Idegree);

extern BAP_DLL void bap_neg_product_mpz (
    struct bap_product_mpz *,
    struct bap_product_mpz *);

extern BAP_DLL void bap_mul_product_numeric_mpz (
    struct bap_product_mpz *,
    struct bap_product_mpz *,
    ba0_mpz_t);

extern BAP_DLL void bap_mul_product_term_mpz (
    struct bap_product_mpz *,
    struct bap_product_mpz *,
    struct bav_term *);

extern BAP_DLL void bap_mul_product_mpz (
    struct bap_product_mpz *,
    struct bap_product_mpz *,
    struct bap_product_mpz *);

extern BAP_DLL void bap_pow_product_mpz (
    struct bap_product_mpz *,
    struct bap_product_mpz *,
    bav_Idegree);

extern BAP_DLL void bap_exquo_product_polynom_mpz (
    struct bap_product_mpz *,
    struct bap_product_mpz *,
    struct bap_polynom_mpz *,
    bav_Idegree);

extern BAP_DLL bav_Idegree bap_exponent_product_mpz (
    struct bap_product_mpz *,
    struct bap_polynom_mpz *);

extern BAP_DLL void bap_sort_product_mpz (
    struct bap_product_mpz *,
    struct bap_product_mpz *);

extern BAP_DLL void bap_physort_product_mpz (
    struct bap_product_mpz *);

extern BAP_DLL ba0_scanf_function bap_scanf_product_mpz;

extern BAP_DLL ba0_printf_function bap_printf_product_mpz;

extern BAP_DLL ba0_garbage1_function bap_garbage1_product_mpz;

extern BAP_DLL ba0_garbage2_function bap_garbage2_product_mpz;

extern BAP_DLL ba0_copy_function bap_copy_product_mpz;

END_C_DECLS
#   undef BAD_FLAG_mpz
#endif /* !BAP_PRODUCT_mpz_H */
#if !defined (BAP_PRODUCT_mpzm_H)
#   define BAP_PRODUCT_mpzm_H 1

/* #   include "bap_common.h" */
/* #   include "bap_polynom_mpzm.h" */

#   define BAD_FLAG_mpzm

BEGIN_C_DECLS

/*
 * texinfo: bap_power_mpzm
 * This data type implements a polynomial raised to some power.
 */

struct bap_power_mpzm
{
  struct bap_polynom_mpzm factor;
  bav_Idegree exponent;
};


/*
 * texinfo: bap_product_mpzm
 * This data type implements products of polynomials of the form
 * @math{c \, f_1^{a_1} \cdots f_t^{a_t}}
 * where @var{c} is the @dfn{numerical factor} of the product, 
 * the @math{f_i} are non numerical polynomials, not necessarily 
 * irreducible and not even necessarily pairwise distinct. 
 * The exponents @math{a_i} are allowed to be zero. 
 * The product one is coded by @math{c = 1} and @math{t = 0}. 
 * The product zero is coded by @math{c = 0}.  
 * Observe that in the context of rings which are not domains, 
 * zero and one are not necessarily automatically recognized.
 */

struct bap_product_mpzm
{
// the numerical factor
  ba0_mpzm_t num_factor;
// the number of allocated entries of tab
  ba0_int_p alloc;
// the number of used entries
  ba0_int_p size;
// the array of bap_power_mpzm
  struct bap_power_mpzm *tab;
};

struct bap_tableof_product_mpzm
{
  ba0_int_p alloc;
  ba0_int_p size;
  struct bap_product_mpzm **tab;
};

extern BAP_DLL void bap_init_power_mpzm (
    struct bap_power_mpzm *);

extern BAP_DLL struct bap_power_mpzm *bap_new_power_mpzm (
    void);

extern BAP_DLL void bap_set_power_mpzm (
    struct bap_power_mpzm *,
    struct bap_power_mpzm *);

extern BAP_DLL void bap_set_power_polynom_mpzm (
    struct bap_power_mpzm *,
    struct bap_polynom_mpzm *,
    bav_Idegree);

extern BAP_DLL void bap_pow_power_mpzm (
    struct bap_power_mpzm *,
    struct bap_power_mpzm *,
    bav_Idegree);

extern BAP_DLL void bap_init_product_mpzm (
    struct bap_product_mpzm *);

extern BAP_DLL void bap_init_product_zero_mpzm (
    struct bap_product_mpzm *);

extern BAP_DLL void bap_realloc_product_mpzm (
    struct bap_product_mpzm *,
    ba0_int_p);

extern BAP_DLL struct bap_product_mpzm *bap_new_product_mpzm (
    void);

extern BAP_DLL struct bap_product_mpzm *bap_new_product_zero_mpzm (
    void);

extern BAP_DLL bool bap_is_zero_product_mpzm (
    struct bap_product_mpzm *);

extern BAP_DLL bool bap_is_one_product_mpzm (
    struct bap_product_mpzm *);

extern BAP_DLL bool bap_is_numeric_product_mpzm (
    struct bap_product_mpzm *);

extern BAP_DLL struct bav_variable * bap_leader_product_mpzm (
    struct bap_product_mpzm *);

extern BAP_DLL void bap_set_product_zero_mpzm (
    struct bap_product_mpzm *);

extern BAP_DLL void bap_set_product_one_mpzm (
    struct bap_product_mpzm *);

extern BAP_DLL void bap_set_product_numeric_mpzm (
    struct bap_product_mpzm *,
    ba0_mpzm_t);

extern BAP_DLL void bap_set_product_polynom_mpzm (
    struct bap_product_mpzm *,
    struct bap_polynom_mpzm *,
    bav_Idegree);

extern BAP_DLL void bap_set_product_mpzm (
    struct bap_product_mpzm *,
    struct bap_product_mpzm *);

extern BAP_DLL void bap_expand_product_mpzm (
    struct bap_polynom_mpzm *,
    struct bap_product_mpzm *);

extern BAP_DLL void bap_mul_product_polynom_mpzm (
    struct bap_product_mpzm *,
    struct bap_product_mpzm *,
    struct bap_polynom_mpzm *,
    bav_Idegree);

extern BAP_DLL void bap_neg_product_mpzm (
    struct bap_product_mpzm *,
    struct bap_product_mpzm *);

extern BAP_DLL void bap_mul_product_numeric_mpzm (
    struct bap_product_mpzm *,
    struct bap_product_mpzm *,
    ba0_mpzm_t);

extern BAP_DLL void bap_mul_product_term_mpzm (
    struct bap_product_mpzm *,
    struct bap_product_mpzm *,
    struct bav_term *);

extern BAP_DLL void bap_mul_product_mpzm (
    struct bap_product_mpzm *,
    struct bap_product_mpzm *,
    struct bap_product_mpzm *);

extern BAP_DLL void bap_pow_product_mpzm (
    struct bap_product_mpzm *,
    struct bap_product_mpzm *,
    bav_Idegree);

extern BAP_DLL void bap_exquo_product_polynom_mpzm (
    struct bap_product_mpzm *,
    struct bap_product_mpzm *,
    struct bap_polynom_mpzm *,
    bav_Idegree);

extern BAP_DLL bav_Idegree bap_exponent_product_mpzm (
    struct bap_product_mpzm *,
    struct bap_polynom_mpzm *);

extern BAP_DLL void bap_sort_product_mpzm (
    struct bap_product_mpzm *,
    struct bap_product_mpzm *);

extern BAP_DLL void bap_physort_product_mpzm (
    struct bap_product_mpzm *);

extern BAP_DLL ba0_scanf_function bap_scanf_product_mpzm;

extern BAP_DLL ba0_printf_function bap_printf_product_mpzm;

extern BAP_DLL ba0_garbage1_function bap_garbage1_product_mpzm;

extern BAP_DLL ba0_garbage2_function bap_garbage2_product_mpzm;

extern BAP_DLL ba0_copy_function bap_copy_product_mpzm;

END_C_DECLS
#   undef BAD_FLAG_mpzm
#endif /* !BAP_PRODUCT_mpzm_H */
#if !defined (BAP_PRODUCT_mpq_H)
#   define BAP_PRODUCT_mpq_H 1

/* #   include "bap_common.h" */
/* #   include "bap_polynom_mpq.h" */

#   define BAD_FLAG_mpq

BEGIN_C_DECLS

/*
 * texinfo: bap_power_mpq
 * This data type implements a polynomial raised to some power.
 */

struct bap_power_mpq
{
  struct bap_polynom_mpq factor;
  bav_Idegree exponent;
};


/*
 * texinfo: bap_product_mpq
 * This data type implements products of polynomials of the form
 * @math{c \, f_1^{a_1} \cdots f_t^{a_t}}
 * where @var{c} is the @dfn{numerical factor} of the product, 
 * the @math{f_i} are non numerical polynomials, not necessarily 
 * irreducible and not even necessarily pairwise distinct. 
 * The exponents @math{a_i} are allowed to be zero. 
 * The product one is coded by @math{c = 1} and @math{t = 0}. 
 * The product zero is coded by @math{c = 0}.  
 * Observe that in the context of rings which are not domains, 
 * zero and one are not necessarily automatically recognized.
 */

struct bap_product_mpq
{
// the numerical factor
  ba0_mpq_t num_factor;
// the number of allocated entries of tab
  ba0_int_p alloc;
// the number of used entries
  ba0_int_p size;
// the array of bap_power_mpq
  struct bap_power_mpq *tab;
};

struct bap_tableof_product_mpq
{
  ba0_int_p alloc;
  ba0_int_p size;
  struct bap_product_mpq **tab;
};

extern BAP_DLL void bap_init_power_mpq (
    struct bap_power_mpq *);

extern BAP_DLL struct bap_power_mpq *bap_new_power_mpq (
    void);

extern BAP_DLL void bap_set_power_mpq (
    struct bap_power_mpq *,
    struct bap_power_mpq *);

extern BAP_DLL void bap_set_power_polynom_mpq (
    struct bap_power_mpq *,
    struct bap_polynom_mpq *,
    bav_Idegree);

extern BAP_DLL void bap_pow_power_mpq (
    struct bap_power_mpq *,
    struct bap_power_mpq *,
    bav_Idegree);

extern BAP_DLL void bap_init_product_mpq (
    struct bap_product_mpq *);

extern BAP_DLL void bap_init_product_zero_mpq (
    struct bap_product_mpq *);

extern BAP_DLL void bap_realloc_product_mpq (
    struct bap_product_mpq *,
    ba0_int_p);

extern BAP_DLL struct bap_product_mpq *bap_new_product_mpq (
    void);

extern BAP_DLL struct bap_product_mpq *bap_new_product_zero_mpq (
    void);

extern BAP_DLL bool bap_is_zero_product_mpq (
    struct bap_product_mpq *);

extern BAP_DLL bool bap_is_one_product_mpq (
    struct bap_product_mpq *);

extern BAP_DLL bool bap_is_numeric_product_mpq (
    struct bap_product_mpq *);

extern BAP_DLL struct bav_variable * bap_leader_product_mpq (
    struct bap_product_mpq *);

extern BAP_DLL void bap_set_product_zero_mpq (
    struct bap_product_mpq *);

extern BAP_DLL void bap_set_product_one_mpq (
    struct bap_product_mpq *);

extern BAP_DLL void bap_set_product_numeric_mpq (
    struct bap_product_mpq *,
    ba0_mpq_t);

extern BAP_DLL void bap_set_product_polynom_mpq (
    struct bap_product_mpq *,
    struct bap_polynom_mpq *,
    bav_Idegree);

extern BAP_DLL void bap_set_product_mpq (
    struct bap_product_mpq *,
    struct bap_product_mpq *);

extern BAP_DLL void bap_expand_product_mpq (
    struct bap_polynom_mpq *,
    struct bap_product_mpq *);

extern BAP_DLL void bap_mul_product_polynom_mpq (
    struct bap_product_mpq *,
    struct bap_product_mpq *,
    struct bap_polynom_mpq *,
    bav_Idegree);

extern BAP_DLL void bap_neg_product_mpq (
    struct bap_product_mpq *,
    struct bap_product_mpq *);

extern BAP_DLL void bap_mul_product_numeric_mpq (
    struct bap_product_mpq *,
    struct bap_product_mpq *,
    ba0_mpq_t);

extern BAP_DLL void bap_mul_product_term_mpq (
    struct bap_product_mpq *,
    struct bap_product_mpq *,
    struct bav_term *);

extern BAP_DLL void bap_mul_product_mpq (
    struct bap_product_mpq *,
    struct bap_product_mpq *,
    struct bap_product_mpq *);

extern BAP_DLL void bap_pow_product_mpq (
    struct bap_product_mpq *,
    struct bap_product_mpq *,
    bav_Idegree);

extern BAP_DLL void bap_exquo_product_polynom_mpq (
    struct bap_product_mpq *,
    struct bap_product_mpq *,
    struct bap_polynom_mpq *,
    bav_Idegree);

extern BAP_DLL bav_Idegree bap_exponent_product_mpq (
    struct bap_product_mpq *,
    struct bap_polynom_mpq *);

extern BAP_DLL void bap_sort_product_mpq (
    struct bap_product_mpq *,
    struct bap_product_mpq *);

extern BAP_DLL void bap_physort_product_mpq (
    struct bap_product_mpq *);

extern BAP_DLL ba0_scanf_function bap_scanf_product_mpq;

extern BAP_DLL ba0_printf_function bap_printf_product_mpq;

extern BAP_DLL ba0_garbage1_function bap_garbage1_product_mpq;

extern BAP_DLL ba0_garbage2_function bap_garbage2_product_mpq;

extern BAP_DLL ba0_copy_function bap_copy_product_mpq;

END_C_DECLS
#   undef BAD_FLAG_mpq
#endif /* !BAP_PRODUCT_mpq_H */
#if !defined (BAP_PRODUCT_mint_hp_H)
#   define BAP_PRODUCT_mint_hp_H 1

/* #   include "bap_common.h" */
/* #   include "bap_polynom_mint_hp.h" */

#   define BAD_FLAG_mint_hp

BEGIN_C_DECLS

/*
 * texinfo: bap_power_mint_hp
 * This data type implements a polynomial raised to some power.
 */

struct bap_power_mint_hp
{
  struct bap_polynom_mint_hp factor;
  bav_Idegree exponent;
};


/*
 * texinfo: bap_product_mint_hp
 * This data type implements products of polynomials of the form
 * @math{c \, f_1^{a_1} \cdots f_t^{a_t}}
 * where @var{c} is the @dfn{numerical factor} of the product, 
 * the @math{f_i} are non numerical polynomials, not necessarily 
 * irreducible and not even necessarily pairwise distinct. 
 * The exponents @math{a_i} are allowed to be zero. 
 * The product one is coded by @math{c = 1} and @math{t = 0}. 
 * The product zero is coded by @math{c = 0}.  
 * Observe that in the context of rings which are not domains, 
 * zero and one are not necessarily automatically recognized.
 */

struct bap_product_mint_hp
{
// the numerical factor
  ba0_mint_hp_t num_factor;
// the number of allocated entries of tab
  ba0_int_p alloc;
// the number of used entries
  ba0_int_p size;
// the array of bap_power_mint_hp
  struct bap_power_mint_hp *tab;
};

struct bap_tableof_product_mint_hp
{
  ba0_int_p alloc;
  ba0_int_p size;
  struct bap_product_mint_hp **tab;
};

extern BAP_DLL void bap_init_power_mint_hp (
    struct bap_power_mint_hp *);

extern BAP_DLL struct bap_power_mint_hp *bap_new_power_mint_hp (
    void);

extern BAP_DLL void bap_set_power_mint_hp (
    struct bap_power_mint_hp *,
    struct bap_power_mint_hp *);

extern BAP_DLL void bap_set_power_polynom_mint_hp (
    struct bap_power_mint_hp *,
    struct bap_polynom_mint_hp *,
    bav_Idegree);

extern BAP_DLL void bap_pow_power_mint_hp (
    struct bap_power_mint_hp *,
    struct bap_power_mint_hp *,
    bav_Idegree);

extern BAP_DLL void bap_init_product_mint_hp (
    struct bap_product_mint_hp *);

extern BAP_DLL void bap_init_product_zero_mint_hp (
    struct bap_product_mint_hp *);

extern BAP_DLL void bap_realloc_product_mint_hp (
    struct bap_product_mint_hp *,
    ba0_int_p);

extern BAP_DLL struct bap_product_mint_hp *bap_new_product_mint_hp (
    void);

extern BAP_DLL struct bap_product_mint_hp *bap_new_product_zero_mint_hp (
    void);

extern BAP_DLL bool bap_is_zero_product_mint_hp (
    struct bap_product_mint_hp *);

extern BAP_DLL bool bap_is_one_product_mint_hp (
    struct bap_product_mint_hp *);

extern BAP_DLL bool bap_is_numeric_product_mint_hp (
    struct bap_product_mint_hp *);

extern BAP_DLL struct bav_variable * bap_leader_product_mint_hp (
    struct bap_product_mint_hp *);

extern BAP_DLL void bap_set_product_zero_mint_hp (
    struct bap_product_mint_hp *);

extern BAP_DLL void bap_set_product_one_mint_hp (
    struct bap_product_mint_hp *);

extern BAP_DLL void bap_set_product_numeric_mint_hp (
    struct bap_product_mint_hp *,
    ba0_mint_hp_t);

extern BAP_DLL void bap_set_product_polynom_mint_hp (
    struct bap_product_mint_hp *,
    struct bap_polynom_mint_hp *,
    bav_Idegree);

extern BAP_DLL void bap_set_product_mint_hp (
    struct bap_product_mint_hp *,
    struct bap_product_mint_hp *);

extern BAP_DLL void bap_expand_product_mint_hp (
    struct bap_polynom_mint_hp *,
    struct bap_product_mint_hp *);

extern BAP_DLL void bap_mul_product_polynom_mint_hp (
    struct bap_product_mint_hp *,
    struct bap_product_mint_hp *,
    struct bap_polynom_mint_hp *,
    bav_Idegree);

extern BAP_DLL void bap_neg_product_mint_hp (
    struct bap_product_mint_hp *,
    struct bap_product_mint_hp *);

extern BAP_DLL void bap_mul_product_numeric_mint_hp (
    struct bap_product_mint_hp *,
    struct bap_product_mint_hp *,
    ba0_mint_hp_t);

extern BAP_DLL void bap_mul_product_term_mint_hp (
    struct bap_product_mint_hp *,
    struct bap_product_mint_hp *,
    struct bav_term *);

extern BAP_DLL void bap_mul_product_mint_hp (
    struct bap_product_mint_hp *,
    struct bap_product_mint_hp *,
    struct bap_product_mint_hp *);

extern BAP_DLL void bap_pow_product_mint_hp (
    struct bap_product_mint_hp *,
    struct bap_product_mint_hp *,
    bav_Idegree);

extern BAP_DLL void bap_exquo_product_polynom_mint_hp (
    struct bap_product_mint_hp *,
    struct bap_product_mint_hp *,
    struct bap_polynom_mint_hp *,
    bav_Idegree);

extern BAP_DLL bav_Idegree bap_exponent_product_mint_hp (
    struct bap_product_mint_hp *,
    struct bap_polynom_mint_hp *);

extern BAP_DLL void bap_sort_product_mint_hp (
    struct bap_product_mint_hp *,
    struct bap_product_mint_hp *);

extern BAP_DLL void bap_physort_product_mint_hp (
    struct bap_product_mint_hp *);

extern BAP_DLL ba0_scanf_function bap_scanf_product_mint_hp;

extern BAP_DLL ba0_printf_function bap_printf_product_mint_hp;

extern BAP_DLL ba0_garbage1_function bap_garbage1_product_mint_hp;

extern BAP_DLL ba0_garbage2_function bap_garbage2_product_mint_hp;

extern BAP_DLL ba0_copy_function bap_copy_product_mint_hp;

END_C_DECLS
#   undef BAD_FLAG_mint_hp
#endif /* !BAP_PRODUCT_mint_hp_H */
#if !defined (BAP_GEOBUCKET_mpz_H)
#   define BAP_GEOBUCKET_mpz_H 1

/* #   include "bap_common.h" */
/* #   include "bap_polynom_mpz.h" */

BEGIN_C_DECLS

#   define BAD_FLAG_mpz

/*
 * texinfo: bap_geobucket_mpz
 * A geobucket (JSC (1998) 25, 285-293, Thomas Yan) is a table of polynomials
 * representing the sum of these polynomials. This data structure
 * permits to improve the complexity of the sum of many different
 * polynomials.
 * The polynomial at index @var{i} is a sum of at most @var{2^i} 
 * monomials.
 * The data structure is a duplicate of @code{bap_tableof_polynomial}.
 */

struct bap_geobucket_mpz
{
// number of allocated entries
  ba0_int_p alloc;
// number of used entries
  ba0_int_p size;
// the array
  struct bap_polynom_mpz **tab;
};



extern BAP_DLL void bap_init_geobucket_mpz (
    struct bap_geobucket_mpz *);

extern BAP_DLL void bap_reset_geobucket_mpz (
    struct bap_geobucket_mpz *);

extern BAP_DLL void bap_mul_geobucket_mpz (
    struct bap_geobucket_mpz *,
    struct bap_polynom_mpz *);

extern BAP_DLL void bap_mul_geobucket_numeric_mpz (
    struct bap_geobucket_mpz *,
    ba0_mpz_t);

extern BAP_DLL void bap_add_geobucket_mpz (
    struct bap_geobucket_mpz *,
    struct bap_polynom_mpz *);

extern BAP_DLL void bap_sub_geobucket_mpz (
    struct bap_geobucket_mpz *,
    struct bap_polynom_mpz *);

extern BAP_DLL void bap_set_polynom_geobucket_mpz (
    struct bap_polynom_mpz *,
    struct bap_geobucket_mpz *);

#   undef BAD_FLAG_mpz

END_C_DECLS
#endif /* !BAP_GEOBUCKET_mpz_H */
#if !defined (BAP_GEOBUCKET_mpzm_H)
#   define BAP_GEOBUCKET_mpzm_H 1

/* #   include "bap_common.h" */
/* #   include "bap_polynom_mpzm.h" */

BEGIN_C_DECLS

#   define BAD_FLAG_mpzm

/*
 * texinfo: bap_geobucket_mpzm
 * A geobucket (JSC (1998) 25, 285-293, Thomas Yan) is a table of polynomials
 * representing the sum of these polynomials. This data structure
 * permits to improve the complexity of the sum of many different
 * polynomials.
 * The polynomial at index @var{i} is a sum of at most @var{2^i} 
 * monomials.
 * The data structure is a duplicate of @code{bap_tableof_polynomial}.
 */

struct bap_geobucket_mpzm
{
// number of allocated entries
  ba0_int_p alloc;
// number of used entries
  ba0_int_p size;
// the array
  struct bap_polynom_mpzm **tab;
};



extern BAP_DLL void bap_init_geobucket_mpzm (
    struct bap_geobucket_mpzm *);

extern BAP_DLL void bap_reset_geobucket_mpzm (
    struct bap_geobucket_mpzm *);

extern BAP_DLL void bap_mul_geobucket_mpzm (
    struct bap_geobucket_mpzm *,
    struct bap_polynom_mpzm *);

extern BAP_DLL void bap_mul_geobucket_numeric_mpzm (
    struct bap_geobucket_mpzm *,
    ba0_mpzm_t);

extern BAP_DLL void bap_add_geobucket_mpzm (
    struct bap_geobucket_mpzm *,
    struct bap_polynom_mpzm *);

extern BAP_DLL void bap_sub_geobucket_mpzm (
    struct bap_geobucket_mpzm *,
    struct bap_polynom_mpzm *);

extern BAP_DLL void bap_set_polynom_geobucket_mpzm (
    struct bap_polynom_mpzm *,
    struct bap_geobucket_mpzm *);

#   undef BAD_FLAG_mpzm

END_C_DECLS
#endif /* !BAP_GEOBUCKET_mpzm_H */
#if !defined (BAP_GEOBUCKET_mpq_H)
#   define BAP_GEOBUCKET_mpq_H 1

/* #   include "bap_common.h" */
/* #   include "bap_polynom_mpq.h" */

BEGIN_C_DECLS

#   define BAD_FLAG_mpq

/*
 * texinfo: bap_geobucket_mpq
 * A geobucket (JSC (1998) 25, 285-293, Thomas Yan) is a table of polynomials
 * representing the sum of these polynomials. This data structure
 * permits to improve the complexity of the sum of many different
 * polynomials.
 * The polynomial at index @var{i} is a sum of at most @var{2^i} 
 * monomials.
 * The data structure is a duplicate of @code{bap_tableof_polynomial}.
 */

struct bap_geobucket_mpq
{
// number of allocated entries
  ba0_int_p alloc;
// number of used entries
  ba0_int_p size;
// the array
  struct bap_polynom_mpq **tab;
};



extern BAP_DLL void bap_init_geobucket_mpq (
    struct bap_geobucket_mpq *);

extern BAP_DLL void bap_reset_geobucket_mpq (
    struct bap_geobucket_mpq *);

extern BAP_DLL void bap_mul_geobucket_mpq (
    struct bap_geobucket_mpq *,
    struct bap_polynom_mpq *);

extern BAP_DLL void bap_mul_geobucket_numeric_mpq (
    struct bap_geobucket_mpq *,
    ba0_mpq_t);

extern BAP_DLL void bap_add_geobucket_mpq (
    struct bap_geobucket_mpq *,
    struct bap_polynom_mpq *);

extern BAP_DLL void bap_sub_geobucket_mpq (
    struct bap_geobucket_mpq *,
    struct bap_polynom_mpq *);

extern BAP_DLL void bap_set_polynom_geobucket_mpq (
    struct bap_polynom_mpq *,
    struct bap_geobucket_mpq *);

#   undef BAD_FLAG_mpq

END_C_DECLS
#endif /* !BAP_GEOBUCKET_mpq_H */
#if !defined (BAP_GEOBUCKET_mint_hp_H)
#   define BAP_GEOBUCKET_mint_hp_H 1

/* #   include "bap_common.h" */
/* #   include "bap_polynom_mint_hp.h" */

BEGIN_C_DECLS

#   define BAD_FLAG_mint_hp

/*
 * texinfo: bap_geobucket_mint_hp
 * A geobucket (JSC (1998) 25, 285-293, Thomas Yan) is a table of polynomials
 * representing the sum of these polynomials. This data structure
 * permits to improve the complexity of the sum of many different
 * polynomials.
 * The polynomial at index @var{i} is a sum of at most @var{2^i} 
 * monomials.
 * The data structure is a duplicate of @code{bap_tableof_polynomial}.
 */

struct bap_geobucket_mint_hp
{
// number of allocated entries
  ba0_int_p alloc;
// number of used entries
  ba0_int_p size;
// the array
  struct bap_polynom_mint_hp **tab;
};



extern BAP_DLL void bap_init_geobucket_mint_hp (
    struct bap_geobucket_mint_hp *);

extern BAP_DLL void bap_reset_geobucket_mint_hp (
    struct bap_geobucket_mint_hp *);

extern BAP_DLL void bap_mul_geobucket_mint_hp (
    struct bap_geobucket_mint_hp *,
    struct bap_polynom_mint_hp *);

extern BAP_DLL void bap_mul_geobucket_numeric_mint_hp (
    struct bap_geobucket_mint_hp *,
    ba0_mint_hp_t);

extern BAP_DLL void bap_add_geobucket_mint_hp (
    struct bap_geobucket_mint_hp *,
    struct bap_polynom_mint_hp *);

extern BAP_DLL void bap_sub_geobucket_mint_hp (
    struct bap_geobucket_mint_hp *,
    struct bap_polynom_mint_hp *);

extern BAP_DLL void bap_set_polynom_geobucket_mint_hp (
    struct bap_polynom_mint_hp *,
    struct bap_geobucket_mint_hp *);

#   undef BAD_FLAG_mint_hp

END_C_DECLS
#endif /* !BAP_GEOBUCKET_mint_hp_H */
#if !defined (BAP_POLYSPEC_MPZ_H)
#   define BAP_POLYSPEC_MPZ_H 1

/* #   include "bap_common.h" */
/* #   include "bap_polynom_mpz.h" */
/* #   include "bap_product_mpz.h" */
/* #   include "bap_polynom_mpzm.h" */
/* #   include "bap_product_mpzm.h" */
/* #   include "bap_polynom_mpq.h" */

BEGIN_C_DECLS

extern BAP_DLL void bap_polynom_mpq_to_mpz (
    struct bap_polynom_mpz *,
    struct bap_polynom_mpq *);

extern BAP_DLL void bap_maxnorm_polynom_mpz (
    ba0_mpz_t,
    struct bap_polynom_mpz *);

extern BAP_DLL void bap_normal_sign_polynom_mpz (
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *);

extern BAP_DLL void bap_numeric_content_polynom_mpz (
    ba0_mpz_t,
    struct bap_polynom_mpz *);

extern BAP_DLL void bap_signed_numeric_content_polynom_mpz (
    ba0_mpz_t,
    struct bap_polynom_mpz *);

extern BAP_DLL void bap_numeric_primpart_polynom_mpz (
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *);

extern BAP_DLL void bap_normal_numeric_primpart_polynom_mpz (
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *);

extern BAP_DLL void bap_exquo_polynom_numeric_mpz (
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    ba0_mpz_t);

extern BAP_DLL bool bap_is_numeric_factor_polynom_mpz (
    struct bap_polynom_mpz *,
    ba0_mpz_t,
    struct bap_polynom_mpz *);

extern BAP_DLL void bap_replace_initial2_polynom_mpz (
    struct bap_polynom_mpz *,
    struct bap_product_mpz *,
    struct bap_product_mpz *,
    struct bap_polynom_mpz *);

extern BAP_DLL void bap_separant_and_sepuctum_polynom_mpz (
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *);

extern BAP_DLL void bap_sepuctum_polynom_mpz (
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *);

END_C_DECLS
#endif /* !BAP_POLYSPEC_MPZ_H */
#if !defined (BAP_POLYSPEC_MPZM_H)
#   define BAP_POLYSPEC_MPZM_H 1

/* #   include "bap_common.h" */
/* #   include "bap_polynom_mpz.h" */
/* #   include "bap_polynom_mpzm.h" */
/* #   include "bap_polynom_mpq.h" */
/* #   include "bap_polynom_mint_hp.h" */
/* #   include "bap_product_mpz.h" */
/* #   include "bap_product_mpzm.h" */

BEGIN_C_DECLS

extern BAP_DLL void bap_polynom_mpq_to_mpzm (
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpq *);

extern BAP_DLL void bap_polynom_mpz_to_mpzm (
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpz *);

extern BAP_DLL void bap_polynom_mint_hp_to_mpzm (
    struct bap_polynom_mpzm *,
    struct bap_polynom_mint_hp *);

extern BAP_DLL void bap_mods_polynom_mpzm (
    struct bap_polynom_mpz *,
    struct bap_polynom_mpzm *);

extern BAP_DLL void bap_mods_product_mpzm (
    struct bap_product_mpz *,
    struct bap_product_mpzm *);

extern BAP_DLL void bap_Bezout_polynom_mpzm (
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *,
    ba0_mpz_t,
    bav_Idegree);

extern BAP_DLL void bap_coeftayl_polynom_mpzm (
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *,
    struct bav_value_int_p *,
    bav_Idegree);

extern BAP_DLL void bap_quorem_polynom_mpzm (
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *,
    struct bav_rank *,
    struct bap_polynom_mpzm *,
    struct bap_polynom_mpzm *);

extern BAP_DLL void bap_uni_Diophante_polynom_mpzm (
    struct bap_polynom_mpzm *,
    struct bap_product_mpzm *,
    struct bav_rank *,
    ba0_mpz_t,
    bav_Idegree);

extern BAP_DLL void bap_multi_Diophante_polynom_mpzm (
    struct bap_polynom_mpzm *,
    struct bap_product_mpzm *,
    struct bap_polynom_mpzm *,
    struct bav_point_int_p *,
    bav_Idegree,
    ba0_mpz_t,
    bav_Idegree);

END_C_DECLS
#endif /* !BAP_POLYSPEC_MPZM_H */
#if !defined (BAP_POLYSPEC_MPQ_H)
#   define BAP_POLYSPEC_MPQ_H 1

/* #   include "bap_common.h" */
/* #   include "bap_polynom_mpq.h" */
/* #   include "bap_polynom_mpz.h" */
/* #   include "bap_product_mpq.h" */

BEGIN_C_DECLS

extern BAP_DLL void bap_polynom_mpq_to_mpq (
    struct bap_polynom_mpq *,
    struct bap_polynom_mpq *);

extern BAP_DLL void bap_polynom_mpz_to_mpq (
    struct bap_polynom_mpq *,
    struct bap_polynom_mpz *);

extern BAP_DLL void bap_set_polynom_numer_denom_mpq (
    struct bap_polynom_mpq *,
    struct bap_polynom_mpz *,
    ba0_mpz_t);

extern BAP_DLL void bap_product_mpz_to_mpq (
    struct bap_product_mpq *,
    struct bap_product_mpz *);

extern BAP_DLL void bap_numer_polynom_mpq (
    struct bap_polynom_mpz *,
    ba0_mpz_t,
    struct bap_polynom_mpq *);

extern BAP_DLL void bap_denom_polynom_mpq (
    ba0_mpz_t,
    struct bap_polynom_mpq *);

END_C_DECLS
#endif /* !BAP_POLYSPEC_MPQ_H */
#if !defined (BAP_POLYSPEC_MINT_HP_H)
#   define BAP_POLYSPEC_MINT_HP_H 1

/* #   include "bap_common.h" */
/* #   include "bap_polynom_mpz.h" */
/* #   include "bap_polynom_mpzm.h" */
/* #   include "bap_polynom_mpq.h" */
/* #   include "bap_polynom_mint_hp.h" */
/* #   include "bap_product_mint_hp.h" */

BEGIN_C_DECLS
/* 
 * Polynomials with coefficients in Z/nZ where n is a small integer.
 * Precisely, polynomials with coefficients
 * 
 * ba0_mint_hp modulo ba0_mint_hp_module */
extern BAP_DLL void bap_polynom_mpq_to_mint_hp (
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mpq *);

extern BAP_DLL void bap_polynom_mpz_to_mint_hp (
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mpz *);

extern BAP_DLL void bap_random_eval_polynom_mpz_to_mint_hp (
    struct bap_polynom_mint_hp *,
    struct bap_polynom_mpz *,
    ba0_unary_predicate *);

extern BAP_DLL void bap_Berlekamp_mint_hp (
    struct bap_product_mint_hp *,
    struct bap_polynom_mint_hp *);

END_C_DECLS
#endif /* !BAP_POLYSPEC_MINT_HP_H */
#if ! defined (BAZ_COMMON_H)
#   define BAZ_COMMON_H 1

/* #   include <bap.h> */

/* 
 * The _MSC_VER flag is set if the code is compiled under WINDOWS
 * by using Microsoft Visual C (through Visual Studio 2008).
 *
 * In that case, some specific annotations must be added for DLL exports
 * Beware to the fact that this header file is going to be used either
 * for/while building BLAD or for using BLAD from an outer software.
 *
 * In the first case, functions are exported.
 * In the second one, they are imported.
 *
 * The flag BAZ_BLAD_BUILDING must thus be set in the Makefile and passed
 * to the C preprocessor at BAP building time. Do not set it when using BAP.
 *
 * When compiling static libraries under Windows, set BA0_STATIC.
 */

#   if defined (_MSC_VER) && ! defined (BA0_STATIC)
#      if defined (BLAD_BUILDING) || defined (BAZ_BLAD_BUILDING)
#         define BAZ_DLL  __declspec(dllexport)
#      else
#         define BAZ_DLL  __declspec(dllimport)
#      endif
#   else
#      define BAZ_DLL
#   endif

/* #   include "baz_mesgerr.h" */

BEGIN_C_DECLS

extern BAZ_DLL void baz_reset_all_settings (
    void);

extern BAZ_DLL void baz_restart (
    ba0_int_p,
    ba0_int_p);

extern BAZ_DLL void baz_terminate (
    enum ba0_restart_level);

END_C_DECLS
#endif /* !BAZ_COMMON_H */
#if ! defined (BAZ_MESGERR_H)
#   define BAZ_MESGERR_H 1

/* #   include "baz_common.h" */

BEGIN_C_DECLS

extern BAZ_DLL char BAZ_ERRNHL[];

extern BAZ_DLL char BAZ_ERRVPD[];

extern BAZ_DLL char BAZ_ERRGCD[];

extern BAZ_DLL char BAZ_ERRHEU[];

extern BAZ_DLL char BAZ_EXHDIS[];

extern BAZ_DLL char BAZ_EXHENS[];

END_C_DECLS
#endif /* !BAZ_MESGERR_H */
#if ! defined (BAZ_GLOBAL_H)
#   define BAZ_GLOBAL_H 1

/* #   include "baz_common.h" */

BEGIN_C_DECLS

struct baz_initialized_global
{
  struct
  {
/*
 * If nonzero, the lhs of prolongation patterns are quoted using
 * its first character
 */
    char *lhs_quotes;
  } prolongation_pattern;
};

extern BAZ_DLL struct baz_initialized_global baz_initialized_global;

END_C_DECLS
#endif /* !BAZ_GLOBAL_H */
#if ! defined (BAZ_RATFRAC_H)
#   define BAZ_RATFRAC_H 1

/* #   include "baz_common.h" */

BEGIN_C_DECLS

/*
 * texinfo: baz_ratfrac
 * This data type implements fractions of differential polynomials.
 * The fraction is not necessarily reduced.
 * The denominator is nonzero.
 */

struct baz_ratfrac
{
  struct bap_polynom_mpz numer;
  struct bap_polynom_mpz denom;
};

#   define BAZ_NOT_A_RATFRAC (struct baz_ratfrac *)0

struct baz_listof_ratfrac
{
  struct baz_ratfrac *value;
  struct baz_listof_ratfrac *next;
};

struct baz_tableof_ratfrac
{
  ba0_int_p alloc;
  ba0_int_p size;
  struct baz_ratfrac **tab;
};

struct baz_tableof_tableof_ratfrac
{
  ba0_int_p alloc;
  ba0_int_p size;
  struct baz_tableof_ratfrac **tab;
};

struct baz_matrixof_ratfrac
{
  ba0_int_p alloc;
  ba0_int_p nrow;
  ba0_int_p ncol;
  struct baz_ratfrac **entry;
};

extern BAZ_DLL void baz_init_ratfrac (
    struct baz_ratfrac *);

extern BAZ_DLL void baz_init_readonly_ratfrac (
    struct baz_ratfrac *);

extern BAZ_DLL struct baz_ratfrac *baz_new_ratfrac (
    void);

extern BAZ_DLL struct baz_ratfrac *baz_new_readonly_ratfrac (
    void);

extern BAZ_DLL void baz_set_ratfrac (
    struct baz_ratfrac *,
    struct baz_ratfrac *);

extern BAZ_DLL unsigned ba0_int_p baz_sizeof_ratfrac (
    struct baz_ratfrac *,
    enum ba0_garbage_code);

extern BAZ_DLL void baz_switch_ring_ratfrac (
    struct baz_ratfrac *,
    struct bav_differential_ring *);

extern BAZ_DLL void baz_set_tableof_ratfrac (
    struct baz_tableof_ratfrac *,
    struct baz_tableof_ratfrac *);

extern BAZ_DLL void baz_set_tableof_tableof_ratfrac (
    struct baz_tableof_tableof_ratfrac *,
    struct baz_tableof_tableof_ratfrac *);

extern BAZ_DLL void baz_set_ratfrac_zero (
    struct baz_ratfrac *);

extern BAZ_DLL void baz_set_ratfrac_one (
    struct baz_ratfrac *);

extern BAZ_DLL void baz_set_ratfrac_term (
    struct baz_ratfrac *,
    struct bav_term *);

extern BAZ_DLL void baz_set_ratfrac_polynom_mpz (
    struct baz_ratfrac *,
    struct bap_polynom_mpz *);

extern BAZ_DLL void baz_add_ratfrac_polynom_mpz (
    struct baz_ratfrac *,
    struct baz_ratfrac *,
    struct bap_polynom_mpz *);

extern BAZ_DLL void baz_mul_ratfrac_polynom_mpz (
    struct baz_ratfrac *,
    struct baz_ratfrac *,
    struct bap_polynom_mpz *);

extern BAZ_DLL void baz_mul_ratfrac_polynom_mpq (
    struct baz_ratfrac *,
    struct baz_ratfrac *,
    struct bap_polynom_mpq *);

extern BAZ_DLL void baz_set_ratfrac_fraction (
    struct baz_ratfrac *,
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *);

extern BAZ_DLL ba0_scanf_function baz_scanf_ratfrac;

extern BAZ_DLL ba0_scanf_function baz_scanf_product_ratfrac;

extern BAZ_DLL ba0_scanf_function baz_scanf_simplify_ratfrac;

extern BAZ_DLL ba0_scanf_function baz_scanf_expanded_ratfrac;

extern BAZ_DLL ba0_scanf_function baz_scanf_simplify_expanded_ratfrac;

extern BAZ_DLL ba0_printf_function baz_printf_ratfrac;

extern BAZ_DLL ba0_garbage1_function baz_garbage1_ratfrac;

extern BAZ_DLL ba0_garbage2_function baz_garbage2_ratfrac;

extern BAZ_DLL ba0_copy_function baz_copy_ratfrac;

extern BAZ_DLL bool baz_is_zero_ratfrac (
    struct baz_ratfrac *);

extern BAZ_DLL bool baz_is_one_ratfrac (
    struct baz_ratfrac *);

extern BAZ_DLL bool baz_is_numeric_ratfrac (
    struct baz_ratfrac *);

extern BAZ_DLL bool baz_depend_ratfrac (
    struct baz_ratfrac *,
    struct bav_variable *);

extern BAZ_DLL bool baz_equal_ratfrac (
    struct baz_ratfrac *,
    struct baz_ratfrac *);

extern BAZ_DLL void baz_sort_ratfrac (
    struct baz_ratfrac *,
    struct baz_ratfrac *);

extern BAZ_DLL void baz_physort_ratfrac (
    struct baz_ratfrac *);

extern BAZ_DLL void baz_numer_ratfrac (
    struct bap_polynom_mpz *,
    struct baz_ratfrac *);

extern BAZ_DLL void baz_denom_ratfrac (
    struct bap_polynom_mpz *,
    struct baz_ratfrac *);

extern BAZ_DLL void baz_mark_indets_ratfrac (
    struct bav_dictionary_variable *,
    struct bav_tableof_variable *,
    struct baz_ratfrac *);

extern BAZ_DLL struct bav_variable *baz_leader_ratfrac (
    struct baz_ratfrac *);

extern BAZ_DLL struct bav_rank baz_rank_ratfrac (
    struct baz_ratfrac *);

extern BAZ_DLL int baz_compare_rank_ratfrac (
    const void *,
    const void *);

extern BAZ_DLL void baz_initial_ratfrac (
    struct baz_ratfrac *,
    struct baz_ratfrac *);

extern BAZ_DLL void baz_reductum_ratfrac (
    struct baz_ratfrac *,
    struct baz_ratfrac *);

extern BAZ_DLL void baz_lcoeff_and_reductum_ratfrac (
    struct baz_ratfrac *,
    struct baz_ratfrac *,
    struct baz_ratfrac *,
    struct bav_variable *);

extern BAZ_DLL void baz_normalize_numeric_initial_ratfrac (
    struct baz_ratfrac *);

extern BAZ_DLL void baz_reduce_ratfrac (
    struct baz_ratfrac *,
    struct baz_ratfrac *);

extern BAZ_DLL void baz_reduce_numeric_ratfrac (
    struct baz_ratfrac *,
    struct baz_ratfrac *);

extern BAZ_DLL void baz_neg_ratfrac (
    struct baz_ratfrac *,
    struct baz_ratfrac *);

extern BAZ_DLL void baz_add_ratfrac (
    struct baz_ratfrac *,
    struct baz_ratfrac *,
    struct baz_ratfrac *);

extern BAZ_DLL void baz_sub_ratfrac (
    struct baz_ratfrac *,
    struct baz_ratfrac *,
    struct baz_ratfrac *);

extern BAZ_DLL void baz_mul_ratfrac_numeric (
    struct baz_ratfrac *,
    struct baz_ratfrac *,
    ba0_mpz_t);

extern BAZ_DLL void baz_mul_ratfrac_numeric_mpq (
    struct baz_ratfrac *,
    struct baz_ratfrac *,
    ba0_mpq_t);

extern BAZ_DLL void baz_mul_ratfrac_variable (
    struct baz_ratfrac *,
    struct baz_ratfrac *,
    struct bav_variable *,
    bav_Idegree);

extern BAZ_DLL void baz_mul_ratfrac (
    struct baz_ratfrac *,
    struct baz_ratfrac *,
    struct baz_ratfrac *);

extern BAZ_DLL void baz_pow_ratfrac (
    struct baz_ratfrac *,
    struct baz_ratfrac *,
    bav_Idegree);

extern BAZ_DLL void baz_invert_ratfrac (
    struct baz_ratfrac *,
    struct baz_ratfrac *);

extern BAZ_DLL void baz_div_ratfrac (
    struct baz_ratfrac *,
    struct baz_ratfrac *,
    struct baz_ratfrac *);

extern BAZ_DLL void baz_separant_ratfrac (
    struct baz_ratfrac *,
    struct baz_ratfrac *);

extern BAZ_DLL void baz_separant2_ratfrac (
    struct baz_ratfrac *,
    struct baz_ratfrac *,
    struct bav_variable *);

extern BAZ_DLL void baz_diff_ratfrac (
    struct baz_ratfrac *,
    struct baz_ratfrac *,
    struct bav_symbol *);

extern BAZ_DLL bool baz_is_constant_ratfrac (
    struct baz_ratfrac *,
    struct bav_symbol *);

END_C_DECLS
#endif /* !BAZ_RATFRAC_H */
#if !defined (BAZ_PROLONGATION_PATTERN_H)
#   define BAZ_PROLONGATION_PATTERN_H

/* #   include "baz_common.h" */

BEGIN_C_DECLS

/*
 * texinfo: baz_prolongation_pattern
 * This data type implements patterns for prolongating points.
 * Here is an example of pattern:
 * @verbatim
 * R       = DifferentialRing (derivations = [x], blocks = [y,z])
 * pattern = { y[(x,k)] : 'y[k]/factorial(k)' }
 * @end verbatim
 * Every derivative of @var{y} matches the pattern.
 * The pattern associates @math{y_k / k!} to the @var{k}th derivative
 * of @var{y} for every nonnegative integer @var{k}.
 *
 * The field @code{dict} 
 * only aims at speeding up the evaluation of replacement values.
 * It is provided to the substitution dictionary of the 
 * lexical analyzer.
 */

struct baz_prolongation_pattern
{
// The dependent variables (such as "y") matching the pattern
  struct bav_tableof_symbol deps;
// The identifiers denoting the orders of derivation (such as "k")
// The table follows the order provided by bav_global.R.ders
  struct ba0_tableof_string idents;
// The replacement values (such as "y[k]/factorial(k)")
  struct ba0_tableof_string exprs;
// A dictionary which maps identifiers (such as "k") to the corresponding 
//      entry in idents (used by the substitution dictionary)
  struct ba0_dictionary_string dict;
};

extern BAZ_DLL void baz_set_settings_prolongation_pattern (
    char *);

extern BAZ_DLL void baz_get_settings_prolongation_pattern (
    char **);

extern BAZ_DLL void baz_init_prolongation_pattern (
    struct baz_prolongation_pattern *);

extern BAZ_DLL void baz_reset_prolongation_pattern (
    struct baz_prolongation_pattern *);

extern BAZ_DLL struct baz_prolongation_pattern *baz_new_prolongation_pattern (
    void);

extern BAZ_DLL void baz_set_prolongation_pattern (
    struct baz_prolongation_pattern *,
    struct baz_prolongation_pattern *);

extern BAZ_DLL void baz_variable_mapping_prolongation_pattern (
    struct bav_tableof_variable *,
    struct bav_tableof_variable *,
    struct baz_prolongation_pattern *);

extern BAZ_DLL unsigned ba0_int_p baz_sizeof_prolongation_pattern (
    struct baz_prolongation_pattern *,
    enum ba0_garbage_code);

extern BAZ_DLL void baz_switch_ring_prolongation_pattern (
    struct baz_prolongation_pattern *,
    struct bav_differential_ring *);

extern BAZ_DLL ba0_scanf_function baz_scanf_prolongation_pattern;

extern BAZ_DLL ba0_printf_function baz_printf_prolongation_pattern;

END_C_DECLS
#endif /* !BAZ_PROLONGATION_PATTERN_H */
#if ! defined (BAZ_POINT_RATFRAC_H)
#   define BAZ_POINT_RATFRAC_H

/* #   include "baz_ratfrac.h" */
/* #   include "baz_prolongation_pattern.h" */

BEGIN_C_DECLS

/*
 * texinfo: baz_value_ratfrac
 * This data type permits to associate a @code{baz_ratfrac} value
 * to a variable.
 */

struct baz_value_ratfrac
{
  struct bav_variable *var;
  struct baz_ratfrac *value;
};


/*
 * texinfo: baz_point_ratfrac
 * This data type is a particular case of the type @code{struct ba0_point}.
 * It permits to associate @code{baz_ratfrac} values to
 * many different variables. 
 * Many functions assume the @code{tab} field to be sorted
 * (see @code{ba0_sort_point}).
 * They can be parsed using @code{ba0_scanf/%point(%Qz)} and
 * printed by @code{ba0_printf/%point(%Qz)}.
 */

struct baz_point_ratfrac
{
  ba0_int_p alloc;
  ba0_int_p size;
  struct baz_value_ratfrac **tab;
};

extern BAZ_DLL void baz_init_value_ratfrac (
    struct baz_value_ratfrac *);

extern BAZ_DLL struct baz_value_ratfrac *baz_new_value_ratfrac (
    void);

extern BAZ_DLL void baz_set_value_ratfrac (
    struct baz_value_ratfrac *,
    struct baz_value_ratfrac *);

extern BAZ_DLL void baz_set_point_ratfrac (
    struct baz_point_ratfrac *,
    struct baz_point_ratfrac *);

extern BAZ_DLL void baz_prolongate_point_ratfrac_variable (
    struct baz_point_ratfrac *,
    struct baz_point_ratfrac *,
    struct bav_variable *);

extern BAZ_DLL void baz_prolongate_point_ratfrac_term (
    struct baz_point_ratfrac *,
    struct baz_point_ratfrac *,
    struct bav_term *);

extern BAZ_DLL void baz_prolongate_point_ratfrac_using_pattern_variable (
    struct baz_point_ratfrac *,
    struct baz_point_ratfrac *,
    struct baz_prolongation_pattern *,
    struct bav_variable *);

extern BAZ_DLL void baz_prolongate_point_ratfrac_using_pattern_term (
    struct baz_point_ratfrac *,
    struct baz_point_ratfrac *,
    struct baz_prolongation_pattern *,
    struct bav_term *);

END_C_DECLS
#endif /* !BAZ_POINT_RATFRAC_H */
#if !defined (BAZ_EVAL_RATFRAC_H)
#   define BAZ_EVAL_RATFRAC_H

/* #   include "baz_ratfrac.h" */

BEGIN_C_DECLS

extern BAZ_DLL void baz_eval_to_polynom_at_point_int_p_ratfrac (
    struct bap_polynom_mpq *,
    struct baz_ratfrac *,
    struct bav_point_int_p *);

extern BAZ_DLL void baz_eval_to_ratfrac_at_point_ratfrac_ratfrac (
    struct baz_ratfrac *,
    struct baz_ratfrac *,
    struct baz_point_ratfrac *);

extern BAZ_DLL void baz_evaluate_to_ratfrac_at_point_ratfrac_ratfrac (
    struct baz_ratfrac *,
    struct baz_ratfrac *,
    struct baz_point_ratfrac *);

extern BAZ_DLL void baz_twice_evaluate_to_ratfrac_at_point_ratfrac_ratfrac (
    struct baz_ratfrac *,
    struct baz_ratfrac *,
    struct baz_point_ratfrac *,
    struct baz_point_ratfrac *);

END_C_DECLS
#endif /* !BAZ_EVAL_RATFRAC_H */
#if ! defined (BAZ_COLLECT_TERMS_RATFRAC_H)
#   define BAZ_COLLECT_TERMS_RATFRAC_H 1

/* #   include "baz_ratfrac.h" */

BEGIN_C_DECLS

extern BAZ_DLL void baz_collect_terms_tableof_ratfrac (
    struct baz_tableof_ratfrac *,
    struct baz_tableof_ratfrac *,
    struct baz_tableof_ratfrac *,
    struct baz_tableof_ratfrac *);

END_C_DECLS
#endif /*! BAZ_COLLECT_TERMS_RATFRAC_H */
#if ! defined (BAZ_EVAL_POLYSPEC_MPZ_H)
#   define BAZ_EVAL_POLYSPEC_MPZ_H 1

/* #   include "baz_common.h" */
/* #   include "baz_point_ratfrac.h" */

BEGIN_C_DECLS

extern BAZ_DLL void baz_eval_to_ratfrac_at_point_ratfrac_polynom_mpz (
    struct baz_ratfrac *,
    struct bap_polynom_mpz *,
    struct baz_point_ratfrac *);

END_C_DECLS
#endif /* !BAZ_EVAL_POLYSPEC_MPZ_H */
#if ! defined (BAZ_FACTOR_POLYNOM_MPQ_H)
#   define BAZ_FACTOR_POLYNOM_MPQ_H 1

/* #   include "baz_common.h" */

BEGIN_C_DECLS

extern BAZ_DLL void baz_factor_polynom_mpq (
    struct bap_product_mpq *,
    struct bap_polynom_mpq *);

END_C_DECLS
#endif /* !BAZ_FACTOR_POLYNOM_MPQ_H */
#if ! defined (BAZ_FACTOR_POLYNOM_MPZ_H)
#   define BAZ_FACTOR_POLYNOM_MPZ_H 1

/* #   include "baz_common.h" */

BEGIN_C_DECLS

extern BAZ_DLL void baz_factor_polynom_mpz (
    struct bap_product_mpz *,
    struct bap_polynom_mpz *);

END_C_DECLS
#endif /* ! BAZ_FACTOR_POLYNOM_MPZ_H */
#if ! defined (BAZ_GCD_POLYNOM_MPZ_H)
#   define BAZ_GCD_POLYNOM_MPZ_H 1

/* #   include "baz_common.h" */

BEGIN_C_DECLS

struct baz_factored_polynom_mpz
{
  struct bap_product_mpz outer;
  struct bap_polynom_mpz poly;
};


struct baz_tableof_factored_polynom_mpz
{
  ba0_int_p alloc;
  ba0_int_p size;
  struct baz_factored_polynom_mpz **tab;
};


struct baz_gcd_data
{
  bool proved_relatively_prime;
  struct bap_product_mpz common;
  struct baz_tableof_factored_polynom_mpz F;
};


extern BAZ_DLL ba0_printf_function baz_printf_gcd_data;

extern BAZ_DLL void baz_gcd_univariate_tableof_polynom_mpz (
    struct bap_polynom_mpz *,
    struct bap_tableof_polynom_mpz *);

extern BAZ_DLL void baz_gcdheu_tableof_polynom_mpz (
    struct bap_polynom_mpz *,
    struct bap_tableof_polynom_mpz *,
    ba0_int_p);

extern BAZ_DLL void baz_extended_Zassenhaus_gcd_tableof_polynom_mpz (
    struct bap_product_mpz *,
    struct bap_tableof_polynom_mpz *,
    bool);

extern BAZ_DLL void baz_gcd_tableof_polynom_mpz (
    struct bap_product_mpz *,
    struct bap_tableof_polynom_mpz *,
    bool);

extern BAZ_DLL void baz_gcd_polynom_mpz (
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *);

extern BAZ_DLL void baz_content_tableof_polynom_mpz (
    struct bap_product_mpz *,
    struct bap_tableof_polynom_mpz *,
    struct bav_variable *,
    bool);

extern BAZ_DLL void baz_content_polynom_mpz (
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    struct bav_variable *);

extern BAZ_DLL void baz_primpart_polynom_mpz (
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    struct bav_variable *);

extern BAZ_DLL void baz_Yun_polynom_mpz (
    struct bap_product_mpz *,
    struct bap_polynom_mpz *,
    bool);

extern BAZ_DLL void baz_squarefree_polynom_mpz (
    struct bap_product_mpz *,
    struct bap_polynom_mpz *);

extern BAZ_DLL void baz_factor_easy_polynom_mpz (
    struct bap_product_mpz *,
    struct bap_polynom_mpz *,
    struct bap_listof_polynom_mpz *);

END_C_DECLS
#endif /* ! BAZ_GCD_POLYNOM_MPZ_H */
#if ! defined (BAZ_POLYSPEC_MPZ_H)
#   define BAZ_POLYSPEC_MPZ_H 1

/* #   include "baz_common.h" */

BEGIN_C_DECLS

extern BAZ_DLL void baz_genpoly_polynom_mpz (
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    ba0_mpz_t,
    struct bav_variable *);

extern BAZ_DLL void baz_yet_another_point_int_p_mpz (
    struct bav_point_int_p *,
    struct bap_tableof_polynom_mpz *,
    struct bap_product_mpz *,
    struct bav_variable *);

struct baz_ideal_lifting
{
  struct bap_polynom_mpz *A;
  struct bap_polynom_mpz *initial;
  struct bap_product_mpz factors_initial;
  struct bap_product_mpzm factors_mod_point;
  struct bav_point_int_p point;
  ba0_mpz_t p;
  ba0_int_p l;
};


extern BAZ_DLL void baz_HL_init_ideal_lifting (
    struct baz_ideal_lifting *);

extern BAZ_DLL void baz_HL_printf_ideal_lifting (
    void *);

extern BAZ_DLL void baz_HL_integer_divisors (
    ba0_mpz_t *,
    struct baz_ideal_lifting *,
    ba0_mpz_t *);

extern BAZ_DLL void baz_HL_end_redistribute (
    struct baz_ideal_lifting *,
    ba0_mpz_t *,
    struct bap_polynom_mpz *,
    ba0_mpz_t);

extern BAZ_DLL void baz_HL_begin_redistribute (
    struct baz_ideal_lifting *,
    ba0_mpz_t *,
    struct bap_polynom_mpz *,
    ba0_mpz_t);

extern BAZ_DLL void baz_HL_redistribute_the_factors_of_the_initial (
    struct baz_ideal_lifting *);

extern BAZ_DLL void baz_HL_ideal_Hensel_lifting (
    struct bap_product_mpz *,
    struct baz_ideal_lifting *);

extern BAZ_DLL void baz_monomial_reduce_polynom_mpz (
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    ba0_mpz_t,
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *);

extern BAZ_DLL void baz_gcd_pseudo_division_polynom_mpz (
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    struct bap_product_mpz *,
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    struct bav_variable *);

extern BAZ_DLL void baz_gcd_prem_polynom_mpz (
    struct bap_polynom_mpz *,
    struct bap_product_mpz *,
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    struct bav_variable *);

extern BAZ_DLL void baz_gcd_pquo_polynom_mpz (
    struct bap_polynom_mpz *,
    struct bap_product_mpz *,
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    struct bav_variable *);

END_C_DECLS
#endif /* !BAZ_POLYSPEC_MPZ_H */
#if ! defined (BAZ_PROSPEC_MPZ_H)
#   define BAZ_PROSPEC_MPZ_H 1

/* #   include "baz_common.h" */

BEGIN_C_DECLS

extern BAZ_DLL void baz_factor_numeric_content_product_mpz (
    struct bap_product_mpz *,
    struct bap_product_mpz *);

extern BAZ_DLL void baz_gcd_product_mpz (
    struct bap_product_mpz *,
    struct bap_product_mpz *,
    struct bap_product_mpz *,
    struct bap_product_mpz *,
    struct bap_product_mpz *);

END_C_DECLS
#endif /* !BAZ_PROSPEC_MPZ_H */
#if ! defined (BAZ_REALROOT_MPQ_H)
#   define BAZ_REALROOT_MPQ_H

/* #   include "baz_common.h" */

BEGIN_C_DECLS

/*
 * texinfo: baz_typeof_realroot_interval
 * This data type permits to control the behaviour of algorithms
 * for isolating real roots of univariate polynomials.
 */

enum baz_typeof_realroot_interval
{
// Output intervals whenever they have width < epsilon
  baz_any_interval,
// Output intervals if they are guaranteed to isolate exactly one root
  baz_isolation_interval
};

extern BAZ_DLL void baz_positive_roots_polynom_mpq (
    struct ba0_tableof_interval_mpq *,
    struct bap_polynom_mpq *,
    enum baz_typeof_realroot_interval,
    ba0_mpq_t);

extern BAZ_DLL void baz_positive_integer_roots_polynom_mpq (
    struct ba0_tableof_mpz *,
    struct bap_polynom_mpq *);

extern BAZ_DLL void baz_positive_integer_roots_polynom_mpz (
    struct ba0_tableof_mpz *,
    struct bap_polynom_mpz *,
    struct bav_variable *);

END_C_DECLS
#endif /* !BAZ_REALROOT_MPQ_H */
#if ! defined (BAZ_RATBILGE_H)
#   define BAZ_RATBILGE_H 1

/* #   include "baz_ratfrac.h" */

BEGIN_C_DECLS

extern BAZ_DLL void baz_rat_bilge_mpz (
    struct baz_ratfrac *,
    struct baz_ratfrac *,
    struct baz_ratfrac *,
    struct bav_symbol *);

END_C_DECLS
#endif
#if ! defined (BAZ_REL_RATFRAC_H)
#   define BAZ_REL_RATFRAC_H 1

/* #   include "baz_ratfrac.h" */

BEGIN_C_DECLS

/*
 * texinfo: baz_typeof_relop
 * This data type provides an encoding for relational operators.
 */

enum baz_typeof_relop
{
  baz_none_relop,
  baz_equal_relop,
  baz_not_equal_relop,
  baz_greater_relop,
  baz_greater_or_equal_relop,
  baz_less_relop,
  baz_less_or_equal_relop
};

/*
 * texinfo: baz_rel_ratfrac
 * This data type implements a pair of rational fractions connected
 * by a relational operator.
 */

struct baz_rel_ratfrac
{
  struct baz_ratfrac lhs;
  struct baz_ratfrac rhs;
  enum baz_typeof_relop op;
};


struct baz_tableof_rel_ratfrac
{
  ba0_int_p alloc;
  ba0_int_p size;
  struct baz_rel_ratfrac **tab;
};


extern BAZ_DLL void baz_init_rel_ratfrac (
    struct baz_rel_ratfrac *);

extern BAZ_DLL struct baz_rel_ratfrac *baz_new_rel_ratfrac (
    void);

extern BAZ_DLL void baz_set_rel_ratfrac (
    struct baz_rel_ratfrac *,
    struct baz_rel_ratfrac *);

extern BAZ_DLL void baz_set_ratfrac_rel_ratfrac (
    struct baz_ratfrac *,
    struct baz_rel_ratfrac *);

extern BAZ_DLL ba0_scanf_function baz_scanf_rel_ratfrac;

extern BAZ_DLL ba0_printf_function baz_printf_rel_ratfrac;

extern BAZ_DLL ba0_garbage1_function baz_garbage1_rel_ratfrac;

extern BAZ_DLL ba0_garbage2_function baz_garbage2_rel_ratfrac;

extern BAZ_DLL ba0_copy_function baz_copy_rel_ratfrac;

END_C_DECLS
#endif /*!BAZ_REL_RATFRAC_H */
#if !defined (BAD_COMMON_H)
#   define BAD_COMMON_H 1

/* #   include <baz.h> */

/* 
 * The _MSC_VER flag is set if the code is compiled under WINDOWS
 * by using Microsoft Visual C (through Visual Studio 2008).
 *
 * In that case, some specific annotations must be added for DLL exports
 * Beware to the fact that this header file is going to be used either
 * for/while building BLAD or for using BLAD from an outer software.
 *
 * In the first case, functions are exported.
 * In the second one, they are imported.
 *
 * The flag BAD_BLAD_BUILDING must thus be set in the Makefile and passed
 * to the C preprocessor at BAD building time. Do not set it when using BAD.
 *
 * When compiling static libraries under Windows, set BA0_STATIC.
 */

#   if defined (_MSC_VER) && ! defined (BA0_STATIC)
#      if defined (BLAD_BUILDING) || defined (BAD_BLAD_BUILDING)
#         define BAD_DLL  __declspec(dllexport)
#      else
#         define BAD_DLL  __declspec(dllimport)
#      endif
#   else
#      define BAD_DLL
#   endif

/* #   include "bad_mesgerr.h" */

#   define BAD_NOT_A_NUMBER -1

BEGIN_C_DECLS
/* 
 * Restart functions
 */
extern BAD_DLL void bad_reset_all_settings (
    void);

extern BAD_DLL void bad_restart (
    ba0_int_p,
    ba0_int_p);

extern BAD_DLL void bad_terminate (
    enum ba0_restart_level);


END_C_DECLS
#endif /* !BAD_COMMON_H */
#if !defined (BAD_MESGERR_H)
#   define BAD_MESGERR_H 1

/* #   include "bad_common.h" */

BEGIN_C_DECLS

extern BAD_DLL char BAD_EXREDZ[];

extern BAD_DLL char BAD_EXNRDZ[];

extern BAD_DLL char BAD_EXRNUL[];

extern BAD_DLL char BAD_EXRDDZ[];

extern BAD_DLL char BAD_EXRCNC[];

extern BAD_DLL char BAD_EXQUNC[];

extern BAD_DLL char BAD_ERRCRI[];

extern BAD_DLL char BAD_ERRDEL[];

extern BAD_DLL char BAD_ERRNAC[];

extern BAD_DLL char BAD_ERRIAC[];

extern BAD_DLL char BAD_ERRCRC[];

extern BAD_DLL char BAD_ERRNRC[];

extern BAD_DLL char BAD_ERRIRC[];

extern BAD_DLL char BAD_ERRMPT[];

extern BAD_DLL char BAD_ERRIBF[];

extern BAD_DLL char BAD_ERRBAS[];

extern BAD_DLL char BAD_ERRBFD[];

extern BAD_DLL char BAD_ERRIND[];

extern BAD_DLL char BAD_ERRIPT[];

extern BAD_DLL char BAD_ERRSFV[];

END_C_DECLS
#endif /* !BAD_MESGERR_H */
#if !defined (BAD_STATS_H)
#   define BAD_STATS_H 1

/* #   include "bad_common.h" */

BEGIN_C_DECLS

extern BAD_DLL void bad_init_stats (
    void);

extern BAD_DLL ba0_printf_function bad_printf_stats;

END_C_DECLS
#endif /* ! BAD_STATS_H */
#if !defined (BAD_ATTCHAIN_H)
#   define BAD_ATTCHAIN_H 1

/* #   include "bad_common.h" */

BEGIN_C_DECLS

/*
 * texinfo: bad_property_attchain
 * This data type permits to describe the properties of regular chains.
 * It is a subtype of @code{bad_attchain}
 */

enum bad_property_attchain
{
// the ideal defined by the chain is differential
  bad_differential_ideal_property,
// the ideal defined by the chain is prime
  bad_prime_ideal_property,
// the chain is coherent (only relevant in the partial differential case)
  bad_coherence_property,
// the chain is autoreduced
  bad_autoreduced_property,
// the chain is squarefree
  bad_squarefree_property,
// the chain elements, viewed as univariate polynomials in their
// leaders, are primitive
  bad_primitive_property,
// the chain is strongly normalized
  bad_normalized_property
};

/*
 * texinfo: bad_attchain
 * This data type is a subtype of @code{bad_regchain}.
 * It permits to define the @dfn{attributes} associated to a regular chain.
 */

struct bad_attchain
{
// the ordering with respect to which the regular chain is defined
  bav_Iordering ordering;
// the properties bitwise encoded over an integer
  ba0_int_p property;
};


extern BAD_DLL void bad_init_attchain (
    struct bad_attchain *);

extern BAD_DLL void bad_reset_attchain (
    struct bad_attchain *);

extern BAD_DLL void bad_set_attchain (
    struct bad_attchain *,
    struct bad_attchain *);

extern BAD_DLL void bad_intersect_attchain (
    struct bad_attchain *,
    struct bad_attchain *);

extern BAD_DLL void bad_set_properties_attchain (
    struct bad_attchain *,
    struct ba0_tableof_string *);

extern BAD_DLL void bad_set_automatic_properties_attchain (
    struct bad_attchain *);

extern BAD_DLL void bad_set_properties_attchain (
    struct bad_attchain *,
    struct ba0_tableof_string *);

extern BAD_DLL void bad_set_property_attchain (
    struct bad_attchain *,
    enum bad_property_attchain);

extern BAD_DLL void bad_clear_property_attchain (
    struct bad_attchain *,
    enum bad_property_attchain);

extern BAD_DLL bool bad_is_a_property_attchain (
    char *,
    enum bad_property_attchain *);

extern BAD_DLL bool bad_has_property_attchain (
    struct bad_attchain *,
    enum bad_property_attchain);

extern BAD_DLL bool bad_defines_a_differential_ideal_attchain (
    struct bad_attchain *);

extern BAD_DLL bool bad_defines_a_prime_ideal_attchain (
    struct bad_attchain *);

extern BAD_DLL void bad_properties_attchain (
    struct ba0_tableof_string *,
    struct bad_attchain *);

extern BAD_DLL bool bad_equal_attchain (
    struct bad_attchain *,
    struct bad_attchain *);

END_C_DECLS
#endif /* !BAD_ATTCHAIN_H */
#if !defined (BAD_REGCHAIN_H)
#   define BAD_REGCHAIN_H 1

/* #   include "bad_common.h" */
/* #   include "bad_attchain.h" */

BEGIN_C_DECLS

struct bad_base_field;

/*
 * texinfo: bad_regchain
 * This data type implements regular chains.
 * Mathematically, a regular chain @math{A} defines an ideal which
 * is either @math{(A):I_A^\infty} in the nondifferential case, or
 * @math{[A]:H_A^\infty} in the differential case.
 *
 * The field @code{number} is used to associate a number to
 * the regular chain, in order to identify it precisely in
 * the @emph{splitting trees} generated by elimination algorithms.
 * If the regular chain is part of a @emph{quadruple}, the number
 * is used also to identify the quadruple.
 *
 * The field @code{attrib} contains the @emph{attributes} of
 * the regular chain: the @emph{ordering} with respect to which
 * the chain is defined plus some properties.
 *
 * The field @code{decision_system} contains the differential
 * polynomials, sorted increasingly with respect to the chain ordering.
 */

struct bad_regchain
{
// the number of the regular chain in a splitting tree
  ba0_int_p number;
// the attributes of the regular chain - including the ordering
  struct bad_attchain attrib;
// the polynomial set, sorted increasingly with respect to the chain ordering
  struct bap_tableof_polynom_mpz decision_system;
};

struct bad_tableof_regchain
{
  ba0_int_p alloc;
  ba0_int_p size;
  struct bad_regchain **tab;
};

extern BAD_DLL void bad_init_regchain (
    struct bad_regchain *);

extern BAD_DLL void bad_reset_regchain (
    struct bad_regchain *);

extern BAD_DLL struct bad_regchain *bad_new_regchain (
    void);

extern BAD_DLL void bad_realloc_regchain (
    struct bad_regchain *,
    ba0_int_p);

extern BAD_DLL void bad_set_regchain (
    struct bad_regchain *,
    struct bad_regchain *);

extern BAD_DLL void bad_extend_regchain (
    struct bad_regchain *,
    struct bad_regchain *);

extern BAD_DLL ba0_int_p bad_product_of_leading_degrees_regchain (
    struct bad_regchain *);

extern BAD_DLL void bad_set_regchain_tableof_polynom_mpz (
    struct bad_regchain *,
    struct bap_tableof_polynom_mpz *,
    struct ba0_tableof_string *,
    bool);

extern BAD_DLL void bad_set_regchain_tableof_ratfrac_mpz (
    struct bad_regchain *,
    struct baz_tableof_ratfrac *,
    struct ba0_tableof_string *,
    bool);

extern BAD_DLL void bad_fast_primality_test_regchain (
    struct bad_regchain *);

extern BAD_DLL void bad_set_number_regchain (
    struct bad_regchain *,
    ba0_int_p);

extern BAD_DLL ba0_int_p bad_get_number_regchain (
    struct bad_regchain *);

extern BAD_DLL void bad_set_property_regchain (
    struct bad_regchain *,
    enum bad_property_attchain);

extern BAD_DLL void bad_clear_property_regchain (
    struct bad_regchain *,
    enum bad_property_attchain);

extern BAD_DLL void bad_set_properties_regchain (
    struct bad_regchain *,
    struct ba0_tableof_string *);

extern BAD_DLL void bad_set_automatic_properties_regchain (
    struct bad_regchain *);

extern BAD_DLL bool bad_has_property_regchain (
    struct bad_regchain *,
    enum bad_property_attchain);

extern BAD_DLL void bad_properties_regchain (
    struct ba0_tableof_string *,
    struct bad_regchain *);

extern BAD_DLL bool bad_defines_a_differential_ideal_regchain (
    struct bad_regchain *);

extern BAD_DLL bool bad_defines_a_prime_ideal_regchain (
    struct bad_regchain *);

extern BAD_DLL void bad_inequations_regchain (
    struct bap_tableof_polynom_mpz *,
    struct bad_regchain *);

extern BAD_DLL void bad_sort_regchain (
    struct bad_regchain *,
    struct bad_regchain *);

extern BAD_DLL bav_Iordering bad_ordering_eliminating_leaders_of_regchain (
    struct bad_regchain *);

extern BAD_DLL bool bad_is_rank_of_regchain (
    struct bav_rank *,
    struct bad_regchain *,
    ba0_int_p *);

extern BAD_DLL bool bad_is_leader_of_regchain (
    struct bav_variable *,
    struct bad_regchain *,
    ba0_int_p *);

extern BAD_DLL bool bad_depends_on_leader_of_regchain (
    struct bap_polynom_mpz *,
    struct bad_regchain *);

extern BAD_DLL void bad_leaders_of_regchain (
    struct bav_tableof_variable *,
    struct bad_regchain *);

extern BAD_DLL bool bad_is_derivative_of_leader_of_regchain (
    struct bav_variable *,
    struct bad_regchain *,
    ba0_int_p *);

extern BAD_DLL void bad_mark_indets_regchain (
    struct bav_dictionary_variable *,
    struct bav_tableof_variable *,
    struct bad_regchain *);

extern BAD_DLL bool bad_is_solved_regchain (
    struct bad_regchain *);

extern BAD_DLL bool bad_is_a_compatible_regchain (
    struct bad_regchain *,
    struct bad_attchain *);

extern BAD_DLL bool bad_is_orthonomic_regchain (
    struct bad_regchain *,
    struct bad_base_field *);

extern BAD_DLL bool bad_is_explicit_regchain (
    struct bad_regchain *);

extern BAD_DLL bool bad_is_zero_regchain (
    struct bad_regchain *);

extern BAD_DLL ba0_int_p bad_codimension_regchain (
    struct bad_regchain *,
    struct bad_base_field *);

extern BAD_DLL unsigned ba0_int_p bad_sizeof_regchain (
    struct bad_regchain *,
    enum ba0_garbage_code);

extern BAD_DLL void bad_switch_ring_regchain (
    struct bad_regchain *,
    struct bav_differential_ring *);

extern BAD_DLL ba0_scanf_function bad_scanf_regchain;

extern BAD_DLL ba0_scanf_function bad_scanf_pretend_regchain;

extern BAD_DLL ba0_printf_function bad_printf_regchain;

extern BAD_DLL ba0_printf_function bad_printf_regchain_equations;

extern BAD_DLL ba0_garbage1_function bad_garbage1_inline_regchain;

extern BAD_DLL ba0_garbage2_function bad_garbage2_inline_regchain;

extern BAD_DLL ba0_garbage1_function bad_garbage1_regchain;

extern BAD_DLL ba0_garbage2_function bad_garbage2_regchain;

extern BAD_DLL ba0_copy_function bad_copy_regchain;

END_C_DECLS
#endif /* !BAD_REGCHAIN_H */
#if !defined (BAD_SPLITTING_CONTROL_H)
#   define BAD_SPLITTING_CONTROL_H 1

/* #   include "bad_common.h" */
/* #   include "bad_regchain.h" */

BEGIN_C_DECLS

/*
 * texinfo: bad_typeof_dimension_lower_bound
 * This data type permits to specify to differential elimination
 * algorithms the type of dimension lower bound to be applied.
 * Such a lower bound permits to cut any branch of the splitting
 * tree leading to regular chains of differential dimension
 * strictly less than the number of input equations.
 * Note that such a strategy is proved in the algebraic case
 * and in the case of a single differential equation.
 * The other cases are conjectural.
 */

enum bad_typeof_dimension_lower_bound
{
// do not take into account any dimension lower bound
  bad_no_dimension_lower_bound,
// apply it in the case of a non-differential system
  bad_algebraic_dimension_lower_bound,
// apply it in the case of an ordinary differential system
  bad_ode_dimension_lower_bound,
// apply it in the case of a partial differential system
  bad_pde_dimension_lower_bound
};

/* 
 * texinfo: bad_splitting_control
 * This data type permits to specify a splitting control strategy
 * to differential elimination algorithms.
 * 
 * The field @code{first_leaf_only} indicates if the differential
 * elimination process must stop at the first consistent regular
 * chain obtained. Default value is @code{false}.
 *
 * The field @code{dimlb} indicates the type of dimension argument
 * that should be taken into account. Default value is
 * @code{bad_algebraic_dimension_lower_bound}.
 *
 * The field @code{apply_dimlb_one_eq} indicates if the case of
 * a single input equation should be considered specifically (provided
 * that @code{dimlb} is different from @code{bad_no_dimension_lower_bound}).
 * If set to @code{true}, branches of the splitting tree leading to
 * regular chains of differential dimension strictly less than the 
 * number of input equations (which is then equal to @math{1}) are discarded.
 * Default value is @code{true}.
 *
 * The field @code{DenefLipshitz} indicates if we are performing the
 * differential elimination stage of @code{bas_DenefLipshitz}. If this
 * is the case, the other @code{first_leaf_only} and @code{apply_dimlb_one_eq}
 * are set to @code{false} and @code{dimlb} is set to 
 * @code{bad_no_dimension_lower_bound}. 
 * Moreover, the inequations are not used to discard quadruples before
 * the final algebraic processing.
 */

struct bad_splitting_control
{
// Stop at the first consistent regular chain (if any)
  bool first_leaf_only;
// Should a dimension lower bound be taken into account ?
  enum bad_typeof_dimension_lower_bound dimlb;
// Should the case of a single input equation be handled specifically?
  bool apply_dimlb_one_eq;
// Are we in the differential elimination stage of the DenefLipshitz algorithm?
  bool DenefLipshitz;
};

struct bad_base_field;

extern BAD_DLL void bad_init_splitting_control (
    struct bad_splitting_control *);

extern BAD_DLL struct bad_splitting_control *bad_new_splitting_control (
    void);

extern BAD_DLL void bad_set_splitting_control (
    struct bad_splitting_control *,
    struct bad_splitting_control *);

extern BAD_DLL void bad_set_first_leaf_only_splitting_control (
    struct bad_splitting_control *,
    bool);

extern BAD_DLL void bad_set_dimension_lower_bound_splitting_control (
    struct bad_splitting_control *,
    enum bad_typeof_dimension_lower_bound,
    bool);

extern BAD_DLL bool bad_apply_dimension_lower_bound_splitting_control (
    struct bad_splitting_control *,
    struct bad_regchain *,
    struct bap_listof_polynom_mpz *,
    struct bad_base_field *,
    bool,
    ba0_int_p *);

extern BAD_DLL void bad_set_DenefLipshitz_splitting_control (
    struct bad_splitting_control *,
    bool);

END_C_DECLS
#endif /* !BAD_SPLITTING_CONTROL_H */
#if ! defined (BAD_QUENCH_MAP_H)
#   define BAD_QUENCH_MAP_H 1

/* #   include "bad_regchain.h" */

BEGIN_C_DECLS

/*
 * texinfo: bad_quench_map
 * This data type describes the properties currently satisfied by a 
 * triangular set. It drives the process carried out 
 * by @code{bad_quench_regchain} and is updated after each
 * elementary operation performed over the triangular set.
 * Each field is associated to a property of the triangular set
 * under consideration.
 *
 * A property can be @dfn{inactive} (if not desired by the set)
 * or @dfn{active}. In this second case, it can be satisfied 
 * by some elements of the triangular set or not.
 *
 * Properties are encoded by a table of booleans. 
 * For a given property @code{prop}, 
 * @itemize
 * @item if the field @code{prop.size} is zero
 * then the property is inactive ;
 * @item if it is nonzero then @code{prop.tab[k]} is @code{true}
 * if and only if the property holds for the @var{k}th 
 * element of the triangular set.
 * @end itemize
 */

struct bad_quench_map
{
// the number of elements of the triangular set being processed
  ba0_int_p nb_max_elem;
// the triangular set is partially autoreduced
  struct ba0_tableof_int_p partially_autoreduced;
// the triangular set is a regular chain
  struct ba0_tableof_int_p regular;
// the triangular set elements satisfy bad_primitive_property
  struct ba0_tableof_int_p primitive;
// the triangular set satisfies bad_autoreduced_property
  struct ba0_tableof_int_p autoreduced;
// the triangular set satisfies bad_squarefree_property
  struct ba0_tableof_int_p squarefree;
// the triangular set satisfies bad_normalized_property
  struct ba0_tableof_int_p normalized;
};

extern BAD_DLL void bad_init_quench_map (
    struct bad_quench_map *,
    struct bad_regchain *);

extern BAD_DLL void bad_init_from_complete_quench_map (
    struct bad_quench_map *,
    ba0_int_p,
    struct bad_regchain *);

extern BAD_DLL void bad_set_property_quench_map (
    struct ba0_tableof_int_p *,
    bool);

extern BAD_DLL void bad_set_all_properties_quench_map (
    struct bad_quench_map *,
    bool);

extern BAD_DLL void bad_inactivate_property_quench_map (
    struct ba0_tableof_int_p *);

extern BAD_DLL void bad_fully_reduced_polynom_quench_map (
    struct bad_quench_map *,
    ba0_int_p);

extern BAD_DLL void bad_partially_reduced_polynom_quench_map (
    struct bad_quench_map *,
    ba0_int_p);

extern BAD_DLL void bad_is_an_already_satisfied_property_quench_map (
    struct ba0_tableof_int_p *,
    ba0_int_p);

extern BAD_DLL bool bad_address_property_quench_map (
    struct ba0_tableof_int_p *,
    ba0_int_p);

extern BAD_DLL void bad_primitive_polynom_quench_map (
    struct bad_quench_map *,
    ba0_int_p);

extern BAD_DLL void bad_normalized_polynom_quench_map (
    struct bad_quench_map *,
    ba0_int_p);

extern BAD_DLL void bad_pseudo_divided_polynom_quench_map (
    struct bad_quench_map *,
    ba0_int_p);

extern BAD_DLL void bad_init_set_quench_map (
    struct bad_quench_map *,
    struct bad_quench_map *);

extern BAD_DLL ba0_int_p bad_first_index_quench_map (
    struct bad_quench_map *);

extern BAD_DLL void bad_printf_quench_map (
    struct bad_quench_map *);

END_C_DECLS
#endif /* !BAD_QUENCH_MAP_H */
#if !defined (BAD_QUENCH_REGCHAIN_H)
#   define BAD_QUENCH_REGCHAIN_H 1

/* #   include "bad_common.h" */
/* #   include "bad_attchain.h" */
/* #   include "bad_regchain.h" */
/* #   include "bad_quench_map.h" */

BEGIN_C_DECLS

struct bad_base_field;
struct bad_intersectof_regchain;

extern BAD_DLL void bad_quench_regchain (
    struct bad_regchain *,
    struct bad_quench_map *,
    struct bav_tableof_term *,
    bool *,
    struct bad_regchain *,
    struct bad_base_field *,
    struct bap_polynom_mpz **);

extern BAD_DLL void bad_quench_and_handle_exceptions_regchain (
    struct bad_intersectof_regchain *,
    struct bad_quench_map *,
    struct bav_tableof_term *,
    bool *,
    struct bad_regchain *,
    struct bad_base_field *);

extern BAD_DLL void bad_handle_splitting_exceptions_regchain (
    struct bad_intersectof_regchain *,
    struct bad_quench_map *,
    struct bav_tableof_term *,
    bool *,
    struct bap_polynom_mpz *,
    struct bad_regchain *,
    char *,
    struct bad_base_field *);

END_C_DECLS
#endif /* !BAD_QUENCH_REGCHAIN_H */
#if !defined (BAD_BASE_FIELD_H)
#   define BAD_BASE_FIELD_H 1

/* #   include "bad_common.h" */
/* #   include "bad_regchain.h" */

BEGIN_C_DECLS

/*
 * texinfo: bad_base_field
 * This data structure implements base fields for polynomials, regular
 * chains. They are used by elimination methods.
 * Base fields are presented by generators and relations.
 * 
 * The field @code{first_block_index} contains the index
 * of the first block which contains generators, in the table of blocks of 
 * the current ordering.
 * The rule is that any dependent variable which belongs to the same block
 * or to any lower block belongs to the base field.
 * If no generator has been specified, the base field is defined as
 * the field of the rational fractions in the independent variables and
 * the field @code{first_block_index} contains @code{BA0_NOT_AN_INDEX}.
 *
 * Base fields are seen to be defined with respect to some ordering.
 * There is a restriction on orderings with respect to which base
 * fields can be defined: they must not involve @code{varmax} variables.
 *
 * A base field is differential if its @code{relations} field 
 * holds the @code{bad_differential_ideal_property}.
 */

struct bad_base_field
{
// indicate if the polynomials which are going to be tested
// zero or nonzero may supposed to be reduced with respect to relations
  bool assume_reduced;
// the first block index containing generators
  ba0_int_p first_block_index;
// the base field defining equations - the corresponding ideal must be prime.
  struct bad_regchain relations;
};


extern BAD_DLL void bad_init_base_field (
    struct bad_base_field *);

extern BAD_DLL struct bad_base_field *bad_new_base_field (
    void);

extern BAD_DLL bool bad_is_differential_base_field (
    struct bad_base_field *);

extern BAD_DLL void bad_set_base_field (
    struct bad_base_field *,
    struct bad_base_field *);

extern BAD_DLL void bad_base_field_generators (
    struct ba0_tableof_range_indexed_group *,
    struct bad_base_field *);

extern BAD_DLL void bad_set_base_field_relations_properties (
    struct bad_regchain *,
    bool);

extern BAD_DLL void bad_set_base_field_generators_and_relations (
    struct bad_base_field *,
    struct ba0_tableof_range_indexed_group *,
    struct bad_regchain *,
    bool);

extern BAD_DLL bool bad_is_a_compatible_base_field (
    struct bad_base_field *,
    struct bad_attchain *);

extern BAD_DLL bool bad_member_variable_base_field (
    struct bav_variable *,
    struct bad_base_field *);

extern BAD_DLL ba0_int_p bad_number_of_elements_over_base_field_regchain (
    struct bad_regchain *,
    struct bad_base_field *);

extern BAD_DLL bool bad_member_nonzero_polynom_base_field (
    struct bap_polynom_mpz *,
    struct bad_base_field *);

extern BAD_DLL bool bad_member_polynom_base_field (
    struct bap_polynom_mpz *,
    struct bad_base_field *);

extern BAD_DLL bool bad_member_product_base_field (
    struct bap_product_mpz *,
    struct bad_base_field *);

extern BAD_DLL void bad_remove_product_factors_base_field (
    struct bap_product_mpz *,
    struct bap_product_mpz *,
    struct bad_base_field *);

extern BAD_DLL ba0_scanf_function bad_scanf_base_field;

extern BAD_DLL ba0_printf_function bad_printf_base_field;

END_C_DECLS
#endif /* ! BAD_BASE_FIELD_H */
#if !defined (BAD_INTERSECTOF_REGCHAIN_H)
#   define BAD_INTERSECTOF_REGCHAIN_H 1

/* #   include "bad_common.h" */
/* #   include "bad_regchain.h" */
/* #   include "bad_reduction.h" */
/* #   include "bad_base_field.h" */

BEGIN_C_DECLS

/*
 * texinfo: bad_intersectof_regchain
 * This data structure mostly is a table a regular chain.
 * Mathematically, the ideal that it represents is the intersection
 * of the ideals defined by the chains.
 */

struct bad_intersectof_regchain
{
  struct bad_attchain attrib;
  struct bad_tableof_regchain inter;
};


extern BAD_DLL void bad_init_intersectof_regchain (
    struct bad_intersectof_regchain *);

extern BAD_DLL void bad_reset_intersectof_regchain (
    struct bad_intersectof_regchain *);

extern BAD_DLL struct bad_intersectof_regchain *bad_new_intersectof_regchain (
    void);

extern BAD_DLL void bad_realloc_intersectof_regchain (
    struct bad_intersectof_regchain *,
    ba0_int_p);

extern BAD_DLL void bad_set_intersectof_regchain_regchain (
    struct bad_intersectof_regchain *,
    struct bad_regchain *);

extern BAD_DLL void bad_append_intersectof_regchain_regchain (
    struct bad_intersectof_regchain *,
    struct bad_regchain *);

extern BAD_DLL void bad_append_intersectof_regchain (
    struct bad_intersectof_regchain *,
    struct bad_intersectof_regchain *);

extern BAD_DLL void bad_set_intersectof_regchain (
    struct bad_intersectof_regchain *,
    struct bad_intersectof_regchain *);

extern BAD_DLL void bad_set_property_intersectof_regchain (
    struct bad_intersectof_regchain *,
    enum bad_property_attchain);

extern BAD_DLL void bad_clear_property_intersectof_regchain (
    struct bad_intersectof_regchain *,
    enum bad_property_attchain);

extern BAD_DLL void bad_set_properties_intersectof_regchain (
    struct bad_intersectof_regchain *,
    struct ba0_tableof_string *);

extern BAD_DLL void bad_set_automatic_properties_intersectof_regchain (
    struct bad_intersectof_regchain *);

extern BAD_DLL bool bad_has_property_intersectof_regchain (
    struct bad_intersectof_regchain *,
    enum bad_property_attchain);

extern BAD_DLL void bad_properties_intersectof_regchain (
    struct ba0_tableof_string *,
    struct bad_intersectof_regchain *);

extern BAD_DLL struct bad_regchain *bad_get_regchain_intersectof_regchain (
    struct bad_intersectof_regchain *,
    ba0_int_p);

extern BAD_DLL void bad_sort_intersectof_regchain (
    struct bad_intersectof_regchain *,
    struct bad_intersectof_regchain *);

extern BAD_DLL void bad_remove_redundant_components_intersectof_regchain (
    struct bad_intersectof_regchain *,
    struct bad_intersectof_regchain *,
    struct bad_base_field *);

extern BAD_DLL void bad_fast_primality_test_intersectof_regchain (
    struct bad_intersectof_regchain *);

extern BAD_DLL ba0_scanf_function bad_scanf_intersectof_regchain;

extern BAD_DLL ba0_scanf_function bad_scanf_intersectof_pretend_regchain;

extern BAD_DLL ba0_printf_function bad_printf_intersectof_regchain;

extern BAD_DLL ba0_printf_function bad_printf_intersectof_regchain_equations;

extern BAD_DLL ba0_garbage1_function bad_garbage1_intersectof_regchain;

extern BAD_DLL ba0_garbage2_function bad_garbage2_intersectof_regchain;

extern BAD_DLL ba0_copy_function bad_copy_intersectof_regchain;

END_C_DECLS
#endif /* !BAD_INTERSECTOF_REGCHAIN_H */
#if !defined (BAD_REDUCTION_H)
#   define BAD_REDUCTION_H 1

/* #   include "bad_common.h" */
/* #   include "bad_regchain.h" */
/* #   include "bad_base_field.h" */

BEGIN_C_DECLS

/*
 * texinfo: bad_typeof_reduction
 * This data type permits to specify to reduction algorithms
 * the type of reduction to be performed.
 */

enum bad_typeof_reduction
{
  bad_full_reduction,
  bad_partial_reduction,
// no derivation is performed
  bad_algebraic_reduction
};

/*
 * texinfo: bad_typeof_derivative_to_reduce
 * This data type permits to indicate to reduction algorithms if
 * all derivatives have to be reduced or if the leading derivative
 * has to be preserved.
 */

enum bad_typeof_derivative_to_reduce
{
  bad_all_derivatives_to_reduce,
  bad_all_but_leader_to_reduce
};

/*
 * texinfo: bad_typeof_reduction_strategy
 * This data type permits to choose the method carried out by
 * the reduction algorithm.
 */

enum bad_typeof_reduction_strategy
{
// the polynomial to be reduced is factored/easy then reduction is performed factorwise and 
// gcd are computed to reduce power products of initial and separants involved in the process
// - default value
  bad_gcd_prem_and_factor_reduction_strategy,
// basic strategy
  bad_prem_reduction_strategy,
// a change of ordering is performed first in order
// to reduce polynomials coefficient per coefficient
  bad_prem_and_change_of_ordering_reduction_strategy,
};

/*
 * texinfo: bad_typeof_redzero_strategy
 * This data type permits to choose the method carried out by
 * the algorithms designed for testing if a differential polynomial
 * gets reduced to zero or not.
 */

enum bad_typeof_redzero_strategy
{
// the result is guaranteed - default value
  bad_deterministic_using_probabilistic_redzero_strategy,
// perform reduction and test if the result is zero
  bad_deterministic_redzero_strategy,
// the result is not guaranteed
  bad_probabilistic_redzero_strategy
};

/*
 * texinfo: bad_typeof_inclusion_test_result
 * This data type provides a return code after an inclusion
 * test between ideals presented by regular chains.
 */

enum bad_typeof_inclusion_test_result
{
  bad_inclusion_test_positive,
  bad_inclusion_test_negative,
  bad_inclusion_test_uncertain
};

extern BAD_DLL void bad_set_settings_reduction (
    enum bad_typeof_reduction_strategy,
    enum bad_typeof_redzero_strategy,
    ba0_int_p);

extern BAD_DLL void bad_get_settings_reduction (
    enum bad_typeof_reduction_strategy *,
    enum bad_typeof_redzero_strategy *,
    ba0_int_p *);

extern BAD_DLL void bad_reset_theta (
    struct bav_tableof_term *,
    struct bad_regchain *);

extern BAD_DLL void bad_reduce_easy_polynom_by_regchain (
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    struct bad_regchain *,
    enum bad_typeof_reduction);

extern BAD_DLL void bad_ensure_nonzero_initial_mod_regchain (
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    struct bad_regchain *,
    enum bad_typeof_reduction);

extern BAD_DLL void bad_reduce_polynom_by_regchain (
    struct bap_product_mpz *,
    struct bap_product_mpz *,
    struct bav_tableof_term *,
    struct bap_polynom_mpz *,
    struct bad_regchain *,
    enum bad_typeof_reduction,
    enum bad_typeof_derivative_to_reduce);

extern BAD_DLL void bad_reduce_product_by_regchain (
    struct bap_product_mpz *,
    struct bap_product_mpz *,
    struct bav_tableof_term *,
    struct bap_product_mpz *,
    struct bad_regchain *,
    enum bad_typeof_reduction,
    enum bad_typeof_derivative_to_reduce);

extern BAD_DLL bool bad_is_a_reduced_to_zero_polynom_by_regchain (
    struct bap_polynom_mpz *,
    struct bad_regchain *,
    enum bad_typeof_reduction);

extern BAD_DLL enum bad_typeof_inclusion_test_result bad_is_included_regchain (
    struct bad_regchain *,
    struct bad_regchain *,
    struct bad_base_field *);

extern BAD_DLL bool bad_is_a_reducible_polynom_by_regchain (
    struct bap_polynom_mpz *,
    struct bad_regchain *,
    enum bad_typeof_reduction,
    enum bad_typeof_derivative_to_reduce,
    struct bav_rank *,
    ba0_int_p *);

extern BAD_DLL bool bad_is_a_reducible_product_by_regchain (
    struct bap_product_mpz *,
    struct bad_regchain *,
    enum bad_typeof_reduction,
    enum bad_typeof_derivative_to_reduce,
    ba0_int_p *);

extern BAD_DLL bool bad_is_a_partially_reduced_polynom_wrt_regchain (
    struct bap_polynom_mpz *,
    struct bad_regchain *);

END_C_DECLS
#endif /* !BAD_REDUCTION_H */
#if ! defined (BAD_SELECTION_STRATEGY)
#   define BAD_SELECTION_STRATEGY 1

/* #   include "bad_common.h" */

BEGIN_C_DECLS

/*
 * texinfo: bad_typeof_selection_strategy
 * This data type is used to specify a strategy, carried out by
 * differential elimination algorithm, in order to select the next
 * polynomial to process.
 */

enum bad_typeof_selection_strategy
{
// plain polynomials are preferred to polynomials arising from critical pairs
  bad_equation_first_selection_strategy,
// polynomials with lower leaders are preferred
  bad_lower_leader_first_selection_strategy
};

/*
 * texinfo: bad_selection_strategy
 * This data type specifies a strategy, carried out by
 * differential elimination algorithm, in order to select the next
 * polynomial to process.
 */

struct bad_selection_strategy
{
  enum bad_typeof_selection_strategy strategy;
// a penalty used to penalize some critical pairs
  ba0_int_p penalty;
};


extern BAD_DLL void bad_init_selection_strategy (
    struct bad_selection_strategy *);

extern BAD_DLL struct bad_selection_strategy *bad_new_selection_strategy (
    void);

extern BAD_DLL void bad_set_strategy_selection_strategy (
    struct bad_selection_strategy *,
    enum bad_typeof_selection_strategy);

extern BAD_DLL void bad_set_penalty_selection_strategy (
    struct bad_selection_strategy *,
    ba0_int_p);

extern BAD_DLL void bad_double_penalty_selection_strategy (
    struct bad_selection_strategy *);

END_C_DECLS
#endif
#if !defined (BAD_CRITICAL_PAIR_H)
#   define BAD_CRITICAL_PAIR_H 1

/* #   include "bad_common.h" */
/* #   include "bad_selection_strategy.h" */

BEGIN_C_DECLS

/*
 * texinfo: bad_typeof_critical_pair
 * This data type permits to tag critical pairs in order to
 * process the most important ones before the other ones.
 * The default tag is @code{bad_normal_critical_pair}.
 * The tag @code{bad_rejected_easy_critical_pair} corresponds
 * to critical pairs @math{\{p_1, p_2\}} which are not reduction
 * critical pairs and such that neither @var{p_1} nor @var{p_2}
 * occurs in the field @code{A} of the current quadruple.
 */

enum bad_typeof_critical_pair
{
// default tag
  bad_normal_critical_pair,
// this tag indicates a lower priority
  bad_rejected_easy_critical_pair
};

/*
 * texinfo: bad_critical_pair
 * This data type implements critical pairs.
 * A pair @math{\{ p_1, p_2 \}} of differential polynomials is said to 
 * be a @dfn{critical pair} if the leaders of @math{p_1} and @math{p_2} 
 * are derivatives of some same differential indeterminate @math{u}.
 * Denote @math{\theta_1 u} the leading derivative of @math{p_1} and 
 *        @math{\theta_2 u} the one of @math{p_2}. 
 *
 * Denote @math{\theta_{12} = lcm{(\theta_1, \theta_2)}}. 
 *
 * If @math{\theta_{12} = \theta_1} or @math{\theta_{12} = \theta_2} 
 *      then the pair is called a @dfn{reduction critical pair}
 *      and the corresponding @math{\Delta}-polynomial is
 *      @math{\Delta (p_1, p_2) = prem (p_2, (\theta_{12}/{\theta_1}) p_1)}
 *
 * If the critical pair is not a reduction one then the
 *      corresponding @math{\Delta}-polynomial is
 *      @math{\Delta (p_1, p_2) = s_2 \, ({\theta_{12}}/{\theta_1}) p_1 
 *                              - s_1 \, ({\theta_{12}}/{\theta_2}) p_2}
 *      where @math{s_1} and @math{s_2} denote the separants of
 *      @math{p_1} and @math{p_2}.
 */

struct bad_critical_pair
{
  enum bad_typeof_critical_pair tag;
  struct bap_polynom_mpz p;
  struct bap_polynom_mpz q;
};


struct bad_listof_critical_pair
{
  struct bad_critical_pair *value;
  struct bad_listof_critical_pair *next;
};


extern BAD_DLL void bad_init_critical_pair (
    struct bad_critical_pair *);

extern BAD_DLL struct bad_critical_pair *bad_new_critical_pair (
    void);

extern BAD_DLL struct bad_critical_pair *bad_new_critical_pair_polynom_mpz (
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *);

extern BAD_DLL void bad_set_critical_pair (
    struct bad_critical_pair *,
    struct bad_critical_pair *);

extern BAD_DLL void bad_set_critical_pair_polynom_mpz (
    struct bad_critical_pair *,
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *);

extern BAD_DLL void bad_delta_polynom_critical_pair (
    struct bap_polynom_mpz *,
    struct bad_critical_pair *);

extern BAD_DLL void bad_thetas_and_leaders_critical_pair (
    struct bav_tableof_term *,
    struct bav_tableof_variable *,
    struct bad_critical_pair *);

extern BAD_DLL bool bad_is_a_reduction_critical_pair (
    struct bad_critical_pair *,
    struct bav_variable **);

extern BAD_DLL bool bad_is_a_simpler_critical_pair (
    struct bad_critical_pair *,
    struct bad_critical_pair *,
    struct bad_selection_strategy *);

extern BAD_DLL bool bad_is_a_listof_rejected_critical_pair (
    struct bad_listof_critical_pair *);

extern BAD_DLL ba0_scanf_function bad_scanf_critical_pair;

extern BAD_DLL ba0_printf_function bad_printf_critical_pair;

extern BAD_DLL ba0_garbage1_function bad_garbage1_critical_pair;

extern BAD_DLL ba0_garbage2_function bad_garbage2_critical_pair;

extern BAD_DLL ba0_copy_function bad_copy_critical_pair;

END_C_DECLS
#endif /* !BAD_CRITICAL_PAIR_H */
#if !defined (BAD_SPLITTING_EDGE)
#   define BAD_SPLITTING_EDGE 1

/* #   include "bad_common.h" */

BEGIN_C_DECLS

/*
 * texinfo: bad_typeof_splitting_edge
 * This data type is a subtype of @code{bad_splitting_edge}.
 * It permits to associate a type to an edge in the splitting tree
 * generated by @code{bad_Rosenfeld_Groebner}.
 */

enum bad_typeof_splitting_edge
{
// not an edge
  bad_none_edge,
// critical pair leading to a non trivial differential polynomial
  bad_critical_pair_edge,
  bad_critical_pair_novar_edge, // result is base field element
// reduction to zero
  bad_redzero_edge,
// splittings introducing an inequation at each edge
  bad_zero_nonzero_first_edge,  // processing the initial equations
  bad_zero_nonzero_factor_edge, // plain factorization
  bad_zero_nonzero_initial_edge,        // initial
  bad_zero_nonzero_gcd_edge,    // gcd
  bad_zero_nonzero_separant_edge,       // separant
// splittings not introducing inequations
  bad_regularize_edge,          // complete
  bad_reg_characteristic_edge   // reg_characteristic
};

/*
 * texinfo: bad_splitting_edge
 * This data type is a subtype of @code{bad_splitting_vertex}.
 * It permits to describe an edge of the splitting tree
 * generated by a differential elimination algorithm. 
 *
 * The fields @code{src} and @code{dst} contain the @emph{numbers}
 * of the vertices connected by the edge.
 *
 * For some values of the @code{type} field, the leaders of the
 * involved polynomials are provided in the @code{leaders} field.
 * The entry @code{leaders.tab[0]} contains the leader of the
 * polynomial over which the edge operation has been applied.
 * The entries @code{leaders.tab[k]} for @math{k \geq 1} contain 
 * the leaders of the resulting polynomials.
 * 
 * For the type @code{bad_zero_nonzero_separant_edge}, the field @code{leaders}
 * has size @math{2} and @code{leaders.tab[1]} contains the 
 * leader of one of the factors of the separant.
 * The same description holds for the types @code{bad_zero_nonzero_initial_edge}
 * and @code{bad_zero_nonzero_factor_edge}.
 * 
 * For the type @code{bad_zero_nonzero_gcd_edge}, the field @code{leaders}
 * has size greater than or equal to @math{2}. The entries
 * @code{leaders.tab[k]} for @math{k \geq 1} contain the leaders
 * of the polynomials the vanishing of which has been considered
 * in order to secure some gcd.
 *
 * For all other types, the field @code{leaders} has size zero.
 */

struct bad_splitting_edge
{
// the type of the edge
  enum bad_typeof_splitting_edge type;
// the number of the source vertex
  ba0_int_p src;
// the number of the target vertex
  ba0_int_p dst;
// the leaders of the involved polynomials
  struct bav_tableof_variable leaders;
};

struct bad_tableof_splitting_edge
{
  ba0_int_p alloc;
  ba0_int_p size;
  struct bad_splitting_edge **tab;
};


extern BAD_DLL void bad_init_splitting_edge (
    struct bad_splitting_edge *);

extern BAD_DLL struct bad_splitting_edge *bad_new_splitting_edge (
    void);

extern BAD_DLL char *bad_typeof_splitting_edge_to_string (
    enum bad_typeof_splitting_edge);

extern BAD_DLL void bad_set_splitting_edge (
    struct bad_splitting_edge *,
    struct bad_splitting_edge *);

extern BAD_DLL bool bad_has_var_typeof_splitting_edge (
    enum bad_typeof_splitting_edge);

extern BAD_DLL bool bad_zero_nonzero_typeof_splitting_edge (
    enum bad_typeof_splitting_edge);

extern BAD_DLL struct bav_symbol *bad_src_symbol_splitting_edge (
    struct bad_splitting_edge *);

extern BAD_DLL void bad_set_tvsd_splitting_edge (
    struct bad_splitting_edge *,
    enum bad_typeof_splitting_edge,
    ba0_int_p,
    struct bav_variable *,
    ba0_int_p,
    struct bav_variable *);

extern BAD_DLL void bad_set_tsdl_splitting_edge (
    struct bad_splitting_edge *,
    enum bad_typeof_splitting_edge,
    ba0_int_p,
    ba0_int_p,
    struct bav_tableof_variable *);

extern BAD_DLL ba0_scanf_function bad_scanf_splitting_edge;

extern BAD_DLL ba0_printf_function bad_printf_splitting_edge;

extern BAD_DLL ba0_garbage1_function bad_garbage1_splitting_edge;

extern BAD_DLL ba0_garbage2_function bad_garbage2_splitting_edge;

extern BAD_DLL ba0_copy_function bad_copy_splitting_edge;


END_C_DECLS
#endif
#if !defined (BAD_SPLITTING_VERTEX_H)
#   define BAD_SPLITTING_VERTEX_H 1

/* #   include "bad_splitting_edge.h" */

BEGIN_C_DECLS

/*
 * texinfo: bad_typeof_consistency_vertex
 * This data type is a subtype of @code{bad_splitting_vertex}.
 * It determines the consistency information of one vertex
 * of a splitting tree.
 */

enum bad_typeof_consistency_vertex
{
// the vertex is inconsistent
  bad_inconsistent_vertex,
// the vertex is rejected (by a dimension argument, ...)
  bad_rejected_vertex,
// the consistency of the vertex is uncertain (at least when created)
  bad_uncertain_vertex,
// the vertex is consistent
  bad_consistent_vertex
};

/*
 * texinfo: bad_inconsistency_argument_vertex
 * This data type is a subtype of @code{bad_splitting_vertex}.
 * It provides the argument which permitted to determine the inconsistency
 * of a vertex.
 */

enum bad_inconsistency_argument_vertex
{
// does not apply
  bad_none_argument,
// the reg_characteristic algorithm has not produced any regular chain
  bad_reg_characteric_argument,
// the new equation is a nonzero base field element
  bad_nonzero_base_field_equation_argument,
// the complete algorithm has not produced any quadruple
  bad_complete_argument,
// the complete algorithm, applied over a gcd, has not produced any quadruple
  bad_gcd_complete_argument
};

/*
 * texinfo: bad_splitting_vertex
 * This data type is a subtype of @code{bad_splitting_tree}.
 * It permits to describe one vertex of the tree.
 * Each vertex corresponds to a quadruple / regular chain, which
 * is identified by its @emph{number}.
 *
 * The field @code{number} contains the number of the vertex.
 *
 * The field @code{is_first} indicates if the vertex is a @dfn{first}
 * vertex. First vertices play a special role in elimination methods
 * for they provide bounds which permit to discard quadruples
 * by means of a dimension argument.
 *
 * The field @code{consistency} provides the consistency information
 * for the vertex. The default value is @code{bad_uncertain_vertex}.
 *
 * The field @code{argument} is only meaningful if @code{consistency}
 * is equal to @code{bad_inconsistent_vertex}. The default value
 * is @code{bad_none_argument}.
 *
 * The field @code{edges} contains the table of the edges starting
 * from the vertex towards other vertices of the splitting tree.
 * This table is sorted by increasing @code{dst} number.
 *
 * The fields @code{thetas} and @code{leaders} are only meaningful
 * if the successors of the vertex in the splitting tree were
 * obtained by a process invlving a differential reduction step.
 * In such a case, @code{leaders} contains the leaders of the
 * regular differential chain used to performed the reduction while
 * @code{thetas} contains the least common multiple of the derivative
 * operators applied to these regular differential chain elements
 * by the reduction. Both tables have the same size and there is a
 * one-to-one correspondence between there elements.
 *
 * The field @code{discarded_branch} indicates if a possible branch,
 * starting from the vertex, was discarded because of the presence
 * of differential inequations.
 */

struct bad_splitting_vertex
{
// the number of the vertex which is also the number of the quadruple
  ba0_int_p number;
// indicate if the vertex is a ``first'' vertex
  bool is_first;
// the consistency information for the vertex
  enum bad_typeof_consistency_vertex consistency;
// the argument which permitted to conclude that the vertex is inconsistent
  enum bad_inconsistency_argument_vertex argument;
// the edges towards the children of the vertex
  struct bad_tableof_splitting_edge edges;
// the derivative operators involved in a reduction process (if applicable)
  struct bav_tableof_term thetas;
// the leaders of the polynomials they have applied to (if applicable)
  struct bav_tableof_variable leaders;
// does there exist a discarded branch starting from the vertex?
  bool discarded_branch;
};

struct bad_tableof_splitting_vertex
{
  ba0_int_p alloc;
  ba0_int_p size;
  struct bad_splitting_vertex **tab;
};

extern BAD_DLL void bad_init_splitting_vertex (
    struct bad_splitting_vertex *);

extern BAD_DLL struct bad_splitting_vertex *bad_new_splitting_vertex (
    void);

extern BAD_DLL void bad_reset_splitting_vertex (
    struct bad_splitting_vertex *,
    ba0_int_p);

extern BAD_DLL void bad_set_splitting_vertex (
    struct bad_splitting_vertex *,
    struct bad_splitting_vertex *);

extern BAD_DLL void bad_merge_thetas_leaders_splitting_vertex (
    struct bad_splitting_vertex *,
    struct bav_tableof_term *,
    struct bav_tableof_variable *);

extern BAD_DLL void bad_set_discarded_branch_splitting_vertex (
    struct bad_splitting_vertex *,
    bool);

extern BAD_DLL ba0_scanf_function bad_scanf_splitting_vertex;

extern BAD_DLL ba0_printf_function bad_printf_splitting_vertex;

extern BAD_DLL ba0_garbage1_function bad_garbage1_splitting_vertex;

extern BAD_DLL ba0_garbage2_function bad_garbage2_splitting_vertex;

extern BAD_DLL ba0_copy_function bad_copy_splitting_vertex;


END_C_DECLS
#endif /* !BAD_SPLITTING_VERTEX_H */
#if !defined (BAD_SPLITTING_TREE_H)
#   define BAD_SPLITTING_TREE_H 1

/* #   include "bad_splitting_vertex.h" */

BEGIN_C_DECLS

/*
 * texinfo: bad_activity_level_splitting_tree
 * This data type is a subtype of @code{bad_splitting_tree}.
 */

enum bad_activity_level_splitting_tree
{
// the splitting tree is not generated
  bad_inactive_splitting_tree,
// the splitting tree is generated
  bad_quiet_splitting_tree,
// the splitting tree is generated and messages are printed
  bad_verbose_splitting_tree
};

/*
 * texinfo: bad_splitting_tree
 * This data type permits to describe the splitting tree generated by a
 * differential elimination algorithm.
 *
 * The field @code{vertices} contains the table of the tree vertices.
 * Each vertex is associated to one quadruple / regular chain, identified
 * by its @emph{number}. This @emph{number} is moreover equal to
 * the index of the vertex in the table. 
 *
 * The first entry of @code{vertices}, with @emph{number} zero,
 * is the @dfn{root vertex}. It does not correspond to any
 * actual quadruple / regular chain. It permits to handle
 * systems which have many different @emph{first} vertices.
 * First vertices play a special role in differential elimination methods
 * because they provide bounds which permit to discard quadruples
 * by means of a dimension argument.
 *
 * The field @code{number} contains the next free vertex number.
 * It may be greater than the @code{alloc} field of the @code{vertices}
 * table.
 *
 * The field @code{activity} provides the level of activity of the
 * tree. It may have three values:
 * @itemize
 * @item @code{bad_inactive_splitting_tree} then at most one vertex
 * is allocated to @code{vertices}: the @emph{root} vertex
 * @item @code{bad_quiet_splitting_tree} then the splitting tree
 * is generated
 * @item @code{bad_verbose_splitting_tree} same as above but the
 * differential elimination algorithm which builds the tree
 * may print some data on the standard output.
 * @end itemize
 */

struct bad_splitting_tree
{
  enum bad_activity_level_splitting_tree activity;
// the table of vertices
  struct bad_tableof_splitting_vertex vertices;
// the next free vertex number
  ba0_int_p number;
};

extern BAD_DLL void bad_init_splitting_tree (
    struct bad_splitting_tree *);

extern BAD_DLL struct bad_splitting_tree *bad_new_splitting_tree (
    void);

extern BAD_DLL void bad_reset_splitting_tree (
    struct bad_splitting_tree *,
    enum bad_activity_level_splitting_tree);

extern BAD_DLL void bad_set_splitting_tree (
    struct bad_splitting_tree *,
    struct bad_splitting_tree *);

extern BAD_DLL ba0_int_p bad_next_number_splitting_tree (
    struct bad_splitting_tree *);

extern BAD_DLL struct bad_splitting_vertex *bad_ith_vertex_splitting_tree (
    struct bad_splitting_tree *,
    ba0_int_p);

extern BAD_DLL bool bad_is_first_vertex_splitting_tree (
    struct bad_splitting_tree *,
    ba0_int_p);

extern BAD_DLL void bad_set_first_vertex_splitting_tree (
    struct bad_splitting_tree *,
    ba0_int_p,
    bool);

extern BAD_DLL void bad_set_vertex_consistency_splitting_tree (
    struct bad_splitting_tree *,
    ba0_int_p,
    enum bad_typeof_consistency_vertex,
    enum bad_inconsistency_argument_vertex);

extern BAD_DLL void bad_merge_thetas_leaders_vertex_splitting_tree (
    struct bad_splitting_tree *,
    ba0_int_p,
    struct bav_tableof_term *,
    struct bav_tableof_variable *);

extern BAD_DLL void bad_set_discarded_branch_splitting_tree (
    struct bad_splitting_tree *,
    ba0_int_p,
    bool);

extern BAD_DLL void bad_add_edge_splitting_tree (
    struct bad_splitting_tree *,
    enum bad_typeof_splitting_edge,
    ba0_int_p,
    struct bav_variable *,
    ba0_int_p,
    struct bav_variable *);

extern BAD_DLL void bad_add_edge_novar_splitting_tree (
    struct bad_splitting_tree *,
    enum bad_typeof_splitting_edge,
    ba0_int_p,
    ba0_int_p);

extern BAD_DLL void bad_dot_splitting_tree (
    struct bad_splitting_tree *);

extern BAD_DLL ba0_scanf_function bad_scanf_splitting_tree;

extern BAD_DLL ba0_printf_function bad_printf_splitting_tree;

extern BAD_DLL ba0_garbage1_function bad_garbage1_splitting_tree;

extern BAD_DLL ba0_garbage2_function bad_garbage2_splitting_tree;

extern BAD_DLL ba0_copy_function bad_copy_splitting_tree;

END_C_DECLS
#endif /* !BAD_SPLITTING_TREE_H */
#if !defined (BAD_QUADRUPLE_H)
#   define BAD_QUADRUPLE_H 1

/* #   include "bad_common.h" */
/* #   include "bad_regchain.h" */
/* #   include "bad_intersectof_regchain.h" */
/* #   include "bad_selection_strategy.h" */
/* #   include "bad_critical_pair.h" */
/* #   include "bad_base_field.h" */

BEGIN_C_DECLS

/* 
 * texinfo: bad_quadruple
 * This data type implements quadruples 
 *      @math{G = \langle A,\, D,\, P,\, S \rangle},
 * which are processed by the RosenfeldGroebner algorithm.
 *
 * The field @code{A} contains a regular differential chain.
 *
 * The field @code{D} contains the list of the critical pairs
 * to be processed.
 *
 * The field @code{P} contains the list of the differential polynomials
 * to be processed.
 *
 * The field @code{S} contains a list of inequations.
 *
 * Quadruples are identified in splitting trees by a @emph{number}
 * which is held by the @code{number} field of @code{A}.
 *
 * The RosenfeldGroebner algorithm starts with
 *      @math{G = \langle \emptyset,\, \emptyset,\, P_0,\, S_0 \rangle}
 * where @math{P_0} and @math{S_0} are the input lists of equations 
 * and inequations. It computes a finite set of quadruples containing
 * regular systems i.e. of the form
 *      @math{G = \langle A,\, \emptyset,\, \emptyset,\, S \rangle}
 * and @var{S} partially reduced with respect to @var{A}.
 * These regular systems are then processed by the regCharacteristic
 * algorithm to produce a finite set of regular differential chains.
 */

struct bad_quadruple
{
// the (somehow) already processed differential polynomials
  struct bad_regchain A;
// the list of critical pairs waiting to be processed
  struct bad_listof_critical_pair *D;
// the list of differential polynomials waiting to be processed
  struct bap_listof_polynom_mpz *P;
// the list of inequations (different from zero) 
  struct bap_listof_polynom_mpz *S;
};

struct bad_tableof_quadruple
{
  ba0_int_p alloc;
  ba0_int_p size;
  struct bad_quadruple **tab;
};

struct bad_listof_quadruple
{
  struct bad_quadruple *value;
  struct bad_listof_quadruple *next;
};

struct bad_splitting_tree;

extern BAD_DLL void bad_init_quadruple (
    struct bad_quadruple *);

extern BAD_DLL struct bad_quadruple *bad_new_quadruple (
    void);

extern BAD_DLL void bad_set_number_quadruple (
    struct bad_quadruple *,
    ba0_int_p);

extern BAD_DLL void bad_set_next_number_quadruple (
    struct bad_quadruple *,
    struct bad_splitting_tree *);

extern BAD_DLL ba0_int_p bad_get_number_quadruple (
    struct bad_quadruple *);

extern BAD_DLL void bad_set_quadruple (
    struct bad_quadruple *,
    struct bad_quadruple *);

extern BAD_DLL void bad_mark_indets_quadruple (
    struct bav_dictionary_variable *,
    struct bav_tableof_variable *,
    struct bad_quadruple *);

extern BAD_DLL void bad_extend_quadruple_regchain (
    struct bad_quadruple *,
    struct bad_regchain *,
    struct bad_base_field *);

extern BAD_DLL void bad_insert_in_P_quadruple (
    struct bad_quadruple *,
    struct bad_quadruple *,
    struct bap_polynom_mpz *);

extern BAD_DLL void bad_insert_in_S_quadruple (
    struct bad_quadruple *,
    struct bad_quadruple *,
    struct bap_polynom_mpz *);

extern BAD_DLL struct bap_listof_polynom_mpz *bad_insert_in_listof_polynom_mpz (
    struct bap_polynom_mpz *,
    struct bap_listof_polynom_mpz *);

extern BAD_DLL struct bap_listof_polynom_mpz *bad_delete_from_listof_polynom_mpz (
    struct bap_polynom_mpz *,
    struct bap_listof_polynom_mpz *,
    bool *);

extern BAD_DLL void bad_preprocess_equation_quadruple (
    struct bap_product_mpz *,
    struct bap_tableof_polynom_mpz *,
    struct bap_tableof_product_mpz *,
    bool *,
    struct bad_quadruple *,
    struct bad_base_field *);

extern BAD_DLL void bad_report_simplification_of_inequations_quadruple (
    struct bad_tableof_quadruple *,
    struct bap_tableof_polynom_mpz *,
    struct bap_tableof_product_mpz *);

extern BAD_DLL void bad_split_on_factors_of_equations_quadruple (
    struct bad_tableof_quadruple *,
    struct bav_tableof_variable *,
    struct bav_tableof_variable *,
    struct bad_splitting_tree *,
    struct bap_product_mpz *,
    struct bap_product_mpz *,
    bool);

extern BAD_DLL bool bad_simplify_and_store_in_P_quadruple (
    struct bad_quadruple *,
    bool *,
    struct bap_polynom_mpz *,
    struct bad_base_field *);

extern BAD_DLL bool bad_simplify_and_store_in_S_quadruple (
    struct bad_quadruple *,
    bool *,
    struct bap_polynom_mpz *,
    struct bad_base_field *);

extern BAD_DLL void bad_pick_and_remove_quadruple (
    struct bap_polynom_mpz *,
    struct bad_quadruple *,
    struct bad_critical_pair **,
    struct bad_selection_strategy *);

extern BAD_DLL void bad_reg_characteristic_quadruple (
    struct bad_intersectof_regchain *,
    struct bad_quadruple *,
    struct bad_regchain *,
    struct bad_base_field *);

extern BAD_DLL void bad_complete_quadruple (
    struct bad_tableof_quadruple *,
    struct bav_tableof_term *,
    bool *,
    struct bad_splitting_tree *,
    struct bap_polynom_mpz *,
    struct bad_regchain *,
    struct bad_base_field *,
    struct bad_selection_strategy *);

extern BAD_DLL ba0_scanf_function bad_scanf_quadruple;

extern BAD_DLL ba0_printf_function bad_printf_quadruple;

extern BAD_DLL ba0_garbage1_function bad_garbage1_quadruple;

extern BAD_DLL ba0_garbage2_function bad_garbage2_quadruple;

extern BAD_DLL ba0_copy_function bad_copy_quadruple;

END_C_DECLS
#endif /* !BAD_QUADRUPLE_H */
#if !defined (BAD_REGULARIZE_H)
#   define BAD_REGULARIZE_H 1

/* #   include "bad_common.h" */
/* #   include "bad_regchain.h" */
/* #   include "bad_base_field.h" */
/* #   include "bad_quadruple.h" */

BEGIN_C_DECLS

/*
 * texinfo: bad_typeof_regularize_strategy
 * This data type permits to indicate to regularization algorithms
 * the strategy to be carried out. All tests are based on 
 * pseudoremainder sequence computations.
 */

enum bad_typeof_regularize_strategy
{
// Lionel Ducos algorithm is applied
  bad_subresultant_regularize_strategy = 1,
// pseudoremainders are computed using baz_gcd_pseudo_division_polynom_mpz
  bad_gcd_prem_regularize_strategy,
// pseudoremainders are computed factor per factor using
//  baz_gcd_pseudo_division_polynom_mpz
  bad_gcd_prem_and_factor_regularize_strategy
};

/*
 * texinfo: bad_typeof_Euclid
 * This data type permits to control the type of extended Euclidean
 * algorithm to be performed.
 */

enum bad_typeof_Euclid
{
  bad_basic_Euclid,
  bad_half_extended_Euclid,
  bad_extended_Euclid
};

/*
 * texinfo: bad_typeof_context
 * This data type indicates to regularization methods the context
 * from which they are called.
 */

enum bad_typeof_context
{
// from an algebraic inverse computation
  bad_inverse_context,
// from the PARDI algorithm (change of ordering on regular chains)
  bad_pardi_context,
// from the RosenfeldGroebner algorithm
  bad_rg_context
};

extern BAD_DLL void bad_set_settings_regularize (
    enum bad_typeof_regularize_strategy);

extern BAD_DLL void bad_get_settings_regularize (
    enum bad_typeof_regularize_strategy *);

extern BAD_DLL void bad_Euclid_mod_regchain (
    struct bap_tableof_tableof_polynom_mpz *,
    struct bad_tableof_quadruple *,
    enum bad_typeof_Euclid,
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    struct bav_variable *,
    bool,
    bool,
    struct bad_regchain *,
    struct bad_base_field *,
    struct bap_polynom_mpz **);

extern BAD_DLL void bad_check_regularity_polynom_mod_regchain (
    struct bap_polynom_mpz *,
    struct bad_regchain *,
    struct bad_base_field *,
    struct bap_polynom_mpz **);

extern BAD_DLL void bad_reg_characteristic_regchain (
    struct bad_intersectof_regchain *,
    struct bap_listof_polynom_mpz *,
    struct bad_regchain *,
    struct bad_base_field *);

extern BAD_DLL void bad_normal_form_polynom_mod_regchain (
    struct baz_ratfrac *,
    struct bap_polynom_mpz *,
    struct bad_regchain *,
    struct bap_polynom_mpz **);

extern BAD_DLL void bad_normal_form_ratfrac_mod_regchain (
    struct baz_ratfrac *,
    struct baz_ratfrac *,
    struct bad_regchain *,
    struct bap_polynom_mpz **);

extern BAD_DLL void bad_normal_form_ratfrac_mod_intersectof_regchain (
    struct baz_tableof_ratfrac *,
    struct baz_ratfrac *,
    struct bad_intersectof_regchain *,
    struct bap_polynom_mpz **);

extern BAD_DLL void bad_normal_form_handling_exceptions_ratfrac_mod_regchain (
    struct baz_tableof_ratfrac *,
    struct bad_intersectof_regchain *,
    struct bad_intersectof_regchain *,
    struct baz_ratfrac *);

END_C_DECLS
#endif /* !BAD_REGULARIZE_H */
#if ! defined (BAD_RESULTANT_H)
#   define BAD_RESULTANT_H 1

/* #   include "bad_regchain.h" */

BEGIN_C_DECLS

extern BAD_DLL void bad_resultant_mod_regchain (
    struct bap_product_mpz *,
    struct bap_polynom_mpz *,
    struct bad_regchain *);

END_C_DECLS
#endif /* BAD_RESULTANT_H */
#if !defined (BAD_INVERT_H)
#   define BAD_INVERT_H 1

/* #   include "bad_common.h" */
/* #   include "bad_regchain.h" */
/* #   include "bad_quadruple.h" */
/* #   include "bad_base_field.h" */

BEGIN_C_DECLS

extern BAD_DLL void bad_invert_polynom_mod_regchain (
    struct bap_product_mpz *,
    struct bap_product_mpz *,
    struct bap_polynom_mpz *,
    struct bad_regchain *,
    struct bad_base_field *,
    struct bap_polynom_mpz *volatile *);

extern BAD_DLL void bad_invert_product_mod_regchain (
    struct bap_product_mpz *,
    struct bap_product_mpz *,
    struct bap_product_mpz *,
    struct bad_regchain *,
    struct bad_base_field *,
    struct bap_polynom_mpz *volatile *);

extern BAD_DLL void bad_iterated_lsr3_product_mod_regchain (
    struct bap_product_mpz *,
    struct bap_product_mpz *,
    struct bap_product_mpz *,
    struct bad_regchain *);

END_C_DECLS
#endif /* !BAD_INVERT_H */
#if !defined (BAD_REDUCED_FORM_H)
#   define BAD_REDUCED_FORM_H 1

/* #   include "bad_common.h" */
/* #   include "bad_regchain.h" */
/* #   include "bad_intersectof_regchain.h" */

BEGIN_C_DECLS

extern BAD_DLL void bad_reduced_form_polynom_mod_regchain (
    struct baz_ratfrac *,
    struct bap_polynom_mpz *,
    struct bav_variable *,
    struct bad_regchain *);

extern BAD_DLL void bad_reduced_form_polynom_mod_intersectof_regchain (
    struct baz_tableof_ratfrac *,
    struct bap_polynom_mpz *,
    struct bav_variable *,
    struct bad_intersectof_regchain *);

END_C_DECLS
#endif /* !BAD_REDUCED_FORM_H */
#if !defined (BAD_LOW_POWER_THEOREM_H)
#   define BAD_LOW_POWER_THEOREM_H 1

/* #   include "bad_common.h" */
/* #   include "bad_regchain.h" */
/* #   include "bad_intersectof_regchain.h" */
/* #   include "bad_base_field.h" */

BEGIN_C_DECLS
#   define BAD_ZSTRING	"z%d"
extern BAD_DLL void bad_set_settings_preparation (
    char *);

extern BAD_DLL void bad_get_settings_preparation (
    char **);

/* 
 * texinfo: bad_preparation_term
 * This data type implements one term in a preparation equation.
 * Denote @math{A = A_1, \ldots, A_r} a differential regular chain.
 * Introduce @math{r} differential indeterminates @math{z_1, \ldots, z_r}.
 * A @code{bad_preparation_term} represents a sequence of terms on the 
 * derivatives of the @math{z_i}. All fields have the same size.
 */

struct bad_preparation_term
{
// z[i] = an index in the range [0, ..., r-1]
  struct ba0_tableof_int_p z;
// theta[i] = a power product of derivations = a derivation operator
  struct bav_tableof_term theta;
// deg[i] = a degree
  struct bav_tableof_Idegree deg;
};


struct bad_tableof_preparation_term
{
  ba0_int_p alloc;
  ba0_int_p size;
  struct bad_preparation_term **tab;
};


/* 
 * texinfo: bad_preparation_equation
 * This data type implements preparation equations (Kolchin, IV, 13).
 * Given @math{F} and @math{A = A_1, \ldots, A_r} a preparation
 * equation mostly represents @math{H\,F} as the sum of the
 * pairwise products of the coefficients by the terms modulo @math{(z_i = A_i)}.
 */

struct bad_preparation_equation
{
// power product of initials and separants
  struct bap_product_mpz H;
// the coefficients (reduced and regular w.r.t. A)
  struct bap_tableof_polynom_mpz coeffs;
// the terms
  struct bad_tableof_preparation_term terms;
// the polynomial for which the preparation equation is defined
  struct bap_polynom_mpz *F;
// the denominator of a rational number (to handle
// polynomials with rational number coefficients)
  ba0__mpz_struct *denom;
// the regular chain A
  struct bad_regchain *A;
// the base field - its elements are on the bottom of A
  struct bad_base_field *K;
};


extern BAD_DLL void bad_init_preparation_equation (
    struct bad_preparation_equation *);

extern BAD_DLL struct bad_preparation_equation *bad_new_preparation_equation (
    void);

extern BAD_DLL void bad_set_preparation_equation_polynom (
    struct bad_preparation_equation *,
    struct bap_polynom_mpz *,
    ba0_mpz_t,
    struct bad_regchain *,
    struct bad_base_field *,
    struct bap_polynom_mpz **);

extern BAD_DLL void bad_check_preparation_equation (
    struct bad_preparation_equation *);

extern BAD_DLL ba0_printf_function bad_printf_preparation_equation;

extern BAD_DLL void bad_preparation_congruence (
    ba0_int_p *,
    bav_Idegree *,
    struct bad_preparation_equation *);

extern BAD_DLL bool bad_low_power_theorem_condition_to_be_a_component (
    struct bad_preparation_equation *E);

extern BAD_DLL void bad_low_power_theorem_simplify_intersectof_regchain (
    struct bad_intersectof_regchain *,
    struct bad_intersectof_regchain *,
    struct bad_base_field *);

END_C_DECLS
#endif /* !BAD_LOW_POWER_THEOREM_H */
#if !defined (BAD_PARDI_H)
#   define BAD_PARDI_H 1

/* #   include "bad_common.h" */
/* #   include "bad_regchain.h" */

BEGIN_C_DECLS

extern BAD_DLL void bad_pardi (
    struct bad_regchain *,
    bav_Iordering,
    struct bad_regchain *);

END_C_DECLS
#endif /* !BAD_PARDI_H */
#if !defined (BAD_ROSENFELD_GROEBNER_H)
#   define BAD_ROSENFELD_GROEBNER_H 1

/* #   include "bad_common.h" */
/* #   include "bad_intersectof_regchain.h" */
/* #   include "bad_base_field.h" */
/* #   include "bad_splitting_control.h" */
/* #   include "bad_splitting_tree.h" */

BEGIN_C_DECLS

extern BAD_DLL void bad_Rosenfeld_Groebner (
    struct bad_intersectof_regchain *,
    struct bad_splitting_tree *,
    struct bap_tableof_polynom_mpz *,
    struct bap_tableof_polynom_mpz *,
    struct bad_base_field *,
    struct bad_regchain *,
    struct bad_splitting_control *);

extern BAD_DLL void bad_first_quadruple (
    struct bad_tableof_quadruple *,
    bool *,
    struct bad_splitting_tree *,
    struct bad_attchain *,
    struct bap_tableof_polynom_mpz *,
    struct bap_tableof_polynom_mpz *,
    enum bad_typeof_reduction,
    struct bad_base_field *,
    struct bad_regchain *);

extern BAD_DLL void bad_gcd_mod_quadruple (
    struct bap_tableof_polynom_mpz *,
    struct bad_tableof_quadruple *,
    struct bav_tableof_tableof_variable *,
    bool *,
    struct bad_splitting_tree *,
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    struct bav_variable *,
    struct bad_base_field *);

extern BAD_DLL void bad_split_on_separant_quadruple (
    struct bad_tableof_quadruple *,
    struct bav_tableof_variable *,
    struct bav_tableof_variable *,
    bool *,
    struct bad_splitting_tree *,
    struct bap_polynom_mpz *,
    struct bad_base_field *);

extern BAD_DLL void bad_split_on_initial_quadruple (
    struct bad_tableof_quadruple *,
    struct bav_tableof_variable *,
    struct bav_tableof_variable *,
    bool *,
    struct bad_splitting_tree *,
    struct bap_polynom_mpz *,
    struct bad_base_field *);

END_C_DECLS
#endif /* !BAD_ROSENFELD_GROEBNER_H */
#if !defined (BAD_GLOBAL_H)
#   define BAD_GLOBAL_H 1

/* #   include "bad_common.h" */
/* #   include "bad_reduction.h" */
/* #   include "bad_regularize.h" */
/* #   include "bad_low_power_theorem.h" */

BEGIN_C_DECLS

struct bad_global
{
  struct
  {
/* 
 * Local variable to bad_reduction.
 * Used to pass some extra information to a subfunction in
 * bad_random_eval_variables_under_the_stairs
 * Its value is meaningless between two calls to this function.
 */
    struct bav_tableof_variable *stairs;
  } reduction;
  struct
  {
/* 
 * Statistical information set by bad_Rosenfeld_Groebner and bad_pardi
 */
    time_t begin;
    time_t end;
    ba0_int_p critical_pairs_processed;
    ba0_int_p reductions_to_zero;
  } stats;
};

struct bad_initialized_global
{
  struct
  {
/* 
 * reduction_strategy = the type of reduction strategy applied
 * redzero_strategy   = the type of reduction test to zero applied
 * number_of_redzero_tries = tuning for probabilistic methods
 * Local to bad_reduction.
 */
    enum bad_typeof_reduction_strategy reduction_strategy;
    enum bad_typeof_redzero_strategy redzero_strategy;
    ba0_int_p number_of_redzero_tries;
  } reduction;
  struct
  {
/* 
 * strategy = the type of regularization strategy applied
 * Local to bad_regularize.
 */
    enum bad_typeof_regularize_strategy strategy;
  } regularize;
  struct
  {
/*
 * The string used for denoting differential regular chain elements
 * in the context of preparation equations (cf. Low Power Theorem).
 */
    char *zstring;
  } preparation;
};

extern BAD_DLL struct bad_global bad_global;

extern BAD_DLL struct bad_initialized_global bad_initialized_global;

END_C_DECLS
#endif /* !BAD_GLOBAL_H */
#if !defined (BAS_COMMON_H)
#   define BAS_COMMON_H 1

/* #   include <bad.h> */

/* 
 * The _MSC_VER flag is set if the code is compiled under WINDOWS
 * by using Microsoft Visual C (through Visual Studio 2008).
 *
 * In that case, some specific annotations must be added for DLL exports
 * Beware to the fact that this header file is going to be used either
 * for/while building BLAD or for using BLAD from an outer software.
 *
 * In the first case, functions are exported.
 * In the second one, they are imported.
 *
 * The flag BAS_BLAD_BUILDING must thus be set in the Makefile and passed
 * to the C preprocessor at BAS building time. Do not set it when using BAS.
 *
 * When compiling static libraries under Windows, set BA0_STATIC.
 */

#   if defined (_MSC_VER) && ! defined (BA0_STATIC)
#      if defined (BLAD_BUILDING) || defined (BAS_BLAD_BUILDING)
#         define BAS_DLL  __declspec(dllexport)
#      else
#         define BAS_DLL  __declspec(dllimport)
#      endif
#   else
#      define BAS_DLL
#   endif

/* #   include "bas_mesgerr.h" */

/* 
 * For Solaris 8
 */

#   if HAVE_IEEEFP_H
#      include <ieeefp.h>
#   endif

BEGIN_C_DECLS

#   define BAS_NOT_A_NUMBER -1

extern BAS_DLL void bas_reset_all_settings (
    void);

extern BAS_DLL void bas_restart (
    ba0_int_p,
    ba0_int_p);

extern BAS_DLL void bas_terminate (
    enum ba0_restart_level);

END_C_DECLS
#endif /* !BAS_COMMON_H */
#if !defined (BAS_MESGERR_H)
#   define BAS_MESGERR_H 1

/* #   include "bas_common.h" */

BEGIN_C_DECLS

extern BAS_DLL char BAS_ERRPAT[];

extern BAS_DLL char BAS_ERRSTR[];

END_C_DECLS
#endif /* !BAS_MESGERR_H */
#if ! defined (BAS_DL_EDGE_H)
#   define BAS_DL_EDGE_H 1

/* #   include "bas_common.h" */

BEGIN_C_DECLS

/*
 * texinfo: bas_typeof_DL_edge
 * This data type is a subtype of @code{bas_DL_edge}.
 * It permits to associate a type to an edge in the DL tree
 * generated by the @code{DenefLipshitz_leaf} algorithm.
 */

enum bas_typeof_DL_edge
{
// not an edge
  bas_none_edge,
// investigation of some coefficient being zero
  bas_vanishing_edge,
// investigation of some coefficient being nonzero
  bas_non_vanishing_edge,
// splitting due to regular chain decomposition
  bas_RG_edge
};

/*
 * texinfo: bas_DL_edge
 * This data type is a subtype of @code{struct bas_DL_vertex} and
 * @code{struct bas_DL_tree}. The @code{bas_DenefLipshitz_leaf}
 * function is led to consider some polynomials which may possibly
 * vanish. In such cases, two cases are generated: the one in which
 * the polynomial under consideration vanish and the one in which
 * it does not. 
 * The two corresponding types are @code{bas_vanishing_edge} and
 * @code{bas_non_vanishing_edge}.
 * The @code{bas_DenefLipshitz_leaf} function is also
 * led to generate prolongation equations, which are simplified by
 * a regular chain decomposition algorithm, possibly yielding some
 * case discussion. The corresponding branches have type
 * @code{bas_RG_edge}.
 */

struct bas_DL_edge
{
// the type of the edge
  enum bas_typeof_DL_edge type;
// the number of the source vertex
  ba0_int_p src;
// the number of the target vertex
  ba0_int_p dst;
};

struct bas_tableof_DL_edge
{
  ba0_int_p alloc;
  ba0_int_p size;
  struct bas_DL_edge **tab;
};


extern BAS_DLL void bas_init_DL_edge (
    struct bas_DL_edge *);

extern BAS_DLL struct bas_DL_edge *bas_new_DL_edge (
    void);

extern BAS_DLL char *bas_typeof_DL_edge_to_string (
    enum bas_typeof_DL_edge);

extern BAS_DLL void bas_set_DL_edge (
    struct bas_DL_edge *,
    struct bas_DL_edge *);

extern BAS_DLL void bas_set_tsd_DL_edge (
    struct bas_DL_edge *,
    enum bas_typeof_DL_edge,
    ba0_int_p,
    ba0_int_p);

extern BAS_DLL ba0_scanf_function bas_scanf_DL_edge;

extern BAS_DLL ba0_printf_function bas_printf_DL_edge;

extern BAS_DLL ba0_garbage1_function bas_garbage1_DL_edge;

extern BAS_DLL ba0_garbage2_function bas_garbage2_DL_edge;

extern BAS_DLL ba0_copy_function bas_copy_DL_edge;

END_C_DECLS
#endif /* !BAS_DL_EDGE_H */
#if ! defined (BAS_POSITIVE_INTEGER_ROOTS_H)
#   define BAS_POSITIVE_INTEGER_ROOTS_H 1

/* #   include "bas_common.h" */

BEGIN_C_DECLS

extern BAS_DLL void bas_nonnegative_integer_roots (
    struct ba0_tableof_mpz *,
    struct bap_polynom_mpz *,
    struct bav_variable *,
    struct bad_regchain *);

END_C_DECLS
#endif /* !BAS_POSITIVE_INTEGER_ROOTS_H */
#if ! defined (BAS_HURWITZ_H)
#   define BAS_HURWITZ_H 1

/* #   include "bas_common.h" */

BEGIN_C_DECLS

extern BAS_DLL void bas_Hurwitz_coeffs (
    struct bap_tableof_polynom_mpz *,
    struct bap_polynom_mpz *,
    struct bap_polynom_mpz *,
    ba0_int_p,
    struct bav_symbol *);

END_C_DECLS
#endif /* !BAS_HURWITZ_H */
#if ! defined (BAS_YUPLE_H)
#   define BAS_YUPLE_H 1

/* #   include "bas_common.h" */

BEGIN_C_DECLS

/*
 * texinfo: bas_Yuple
 * The data type is used by the @code{bas_Denef_Lipshitz} algorithm.
 * It contains the part of the data related to the differential
 * indeterminates @var{y} for which formal power series are sought
 * and to their defining differential equations.
 * 
 * The field @code{Y} contains the table of the differential indeterminates.
 *
 * The other fields which are tables all have the same size as @code{Y}.
 * The @math{i}th entry of any table applies to the @math{i}th
 * differential indeterminate. Some of these entries may remain unused:
 * the ones for which the differential indeterminate have no defining equation.
 *
 * Let @math{y} denote one of the differential indeterminates
 * for which formal power series solutions are sought
 * and @math{y_i} the coefficients of the sought formal power
 * series solution @math{\bar{\bar{y}}}.
 * These coefficients are implemented as
 * @emph{subscripted variables} @code{y[i]}.
 * The @math{y} defining ODE i.e. the one which has a derivative
 * of @math{y} for leader is denoted @math{F}.
 * Its separant is denoted @math{S}.
 * The coefficients of the series obtained by evaluating @math{F}
 * at @math{\bar{\bar{y}}} are the non-differential polynomials
 * @math{F^{(j)}(y_i)}. They are called the @dfn{prolongation equations}.
 *
 * To simplify statements, the table fields of the data structure
 * are described as if they applied to the single differential
 * indeterminate @math{y}.
 *
 * The field @code{dict_Y} permits to map @var{y} to its index in @code{Y}.
 * 
 * The field @code{Ybar} contains the prolongation pattern which
 * permits to evaluate derivatives of @var{y}
 * to subscripted variables, possibly multiplied by some coefficient.
 * Assume for instance that @code{Ybar} the second derivative derivative 
 * @math{\ddot y} gets evaluated to @math{y_2}. Then @code{Ybar}
 * defines a map which associates the subscripted variable @code{y[2]}
 * to the variable @code{y[x,x]}.
 * 
 * The field @code{point} is an evaluation point defined by @code{Ybar},
 * which is involved in the evaluation process mentioned above.
 * 
 * All the subscripted variables generated from @var{y}
 * have different symbols but all these 
 * symbols share the same @code{index_in_rigs} field.
 * 
 * The field @code{R} contains the value of the @code{index_in_rigs} field
 * of the subscripted variables associated to @var{y}.
 * 
 * The field @code{dict_R} permits to map any @code{index_in_rigs} to its
 * index in @code{R} hence to the index of the corresponding
 * differential indeterminate in @code{Y}.
 * 
 * The field @code{ozs} contains the subscript associated to 
 * the order zero derivative of @var{y}.
 *
 * The field @code{kappa} contains an upper bound on the valuation
 * of the separant of the @var{y}-defining ODE. 
 * More precisely, it is the smallest integer such that
 * @math{S^{(k)}(y_i)} is nonzero.
 * If undefined, it is equal to @math{-1}.
 * 
 * The field @code{ode} is a table containing derivatives of @math{F}.
 * If undefined it contains the empty table.
 * Otherwise, it contains at least @math{F}.
 * 
 * The field @code{order} contains the order of the leader of @math{F}.
 * 
 * The field @code{sep} is a table containing derivatives of @math{S}.
 * If undefined it contains the empty table.
 * Otherwise, it contains at least @math{S}.
 * 
 * The field @code{S} is the list of the inequations provided
 * by the user and which apply to constant polynomials with respect
 * to the derivation.
 * These inequations, which include in particular
 * constraints on the subscripted variables associated to differential
 * indeterminates, are provided to the regular chain decomposition method.
 *
 * The field @code{binomials} contains binomial polynomials involved
 * in the computation process of the polynomials @math{A(q)}.
 * See the @code{struct bas_Zuple} data structure.
 * 
 * The field @code{q} contains the variable to be used in the context
 * of Hurwitz formula. It stands for a number of differentiations.
 * 
 * The field @code{x} contains the independent variable.
 */

struct bas_Yuple
{
  struct bav_tableof_symbol Y;
  struct bav_dictionary_symbol dict_Y;

  struct baz_prolongation_pattern Ybar;
  struct baz_point_ratfrac point;

  struct ba0_tableof_int_p R;
  struct ba0_dictionary dict_R;

  struct ba0_tableof_int_p ozs;

  struct ba0_tableof_int_p kappa;

  struct bap_tableof_tableof_polynom_mpz ode;
  struct ba0_tableof_int_p order;

  struct bap_tableof_tableof_polynom_mpz sep;

  struct bap_listof_polynom_mpz *S;

  struct bap_tableof_polynom_mpq binomials;

  struct bav_variable *q;
  struct bav_symbol *x;
};

extern BAS_DLL void bas_init_Yuple (
    struct bas_Yuple *);

extern BAS_DLL struct bas_Yuple *bas_new_Yuple (
    void);

extern BAS_DLL void bas_set_Yuple (
    struct bas_Yuple *,
    struct bas_Yuple *);

extern BAS_DLL void bas_set_Y_Ybar_Yuple (
    struct bas_Yuple *,
    struct bav_tableof_symbol *,
    struct baz_prolongation_pattern *,
    struct bap_tableof_polynom_mpz *,
    struct bav_variable *,
    struct bav_symbol *);

extern BAS_DLL void bas_set_ode_Yuple (
    struct bas_Yuple *,
    struct bad_regchain *,
    struct bad_base_field *);

extern BAS_DLL void bas_prolongate_binomials_Yuple (
    struct bas_Yuple *,
    ba0_int_p);

extern BAS_DLL ba0_scanf_function bas_scanf_Yuple;

extern BAS_DLL ba0_printf_function bas_printf_Yuple;

extern BAS_DLL ba0_garbage1_function bas_garbage1_Yuple;

extern BAS_DLL ba0_garbage2_function bas_garbage2_Yuple;

extern BAS_DLL ba0_copy_function bas_copy_Yuple;

END_C_DECLS
#endif /* !BAS_YUPLE_H */
#if ! defined (BAS_ZUPLE_H)
#   define BAS_ZUPLE_H 1

/* #   include "bas_common.h" */
/* #   include "bas_Yuple.h" */

BEGIN_C_DECLS

/*
 * texinfo: bas_Zuple
 * This data structure is a working data structure used by
 * the @code{bas_Denef_Lipshitz_leaf} function.
 * 
 * This data structure is meaningful with respect to some
 * @code{struct bas_Yuple} data structure, denoted @var{U}
 * in the following text. 
 * 
 * The fields which are tables all have the same size:
 * the number of differential indeterminates for which formal
 * power series solutions are sought (see the field @code{Y} of @var{U}).
 * The @math{i}th entry of any table applies to the @math{i}th
 * differential indeterminate. Some of these entries may remain unused:
 * the ones for which the differential indeterminate is not constrained
 * by any differential polynomial, corresponding to an empty entry
 * in the field @code{ode} of @var{U}.
 * 
 * Let @math{y} denote one of the differential indeterminates
 * for which formal power series solutions are sought
 * and @math{y_i} the coefficients of the sought formal power
 * series solution @math{\bar{\bar{y}}}. 
 * These coefficients are implemented as
 * @emph{subscripted variables} @code{y[i]}.
 * The @math{y} defining ODE i.e. the one which has a derivative
 * of @math{y} for leader is denoted @math{F}.
 * Its separant is denoted @math{S}.
 * The coefficients of the series obtained by evaluating @math{F}
 * at @math{\bar{\bar{y}}} are the non-differential polynomials 
 * @math{F^{(j)}(y_i)}. They are called the @emph{prolongation equations}.
 * 
 * To simplify statements, the table fields of the data structure
 * are described as if they applied to the single differential
 * indeterminate @math{y}.
 * 
 * The field @code{sigma} contains the maximum of the subscripts
 * of the variables @code{y[i]} occurring in the fields @code{C},
 * @code{P} and @code{S}.
 * If undefined, @code{sigma} is equal to @math{-1}.
 * 
 * The field @code{mu} contains the prolongation order for @math{F}.
 * Roughly speaking, the field @code{C} contains the polynomials
 * @math{F^{(j)}(y_i)} for @math{0 \leq j \leq \mu}.
 * Strictly speaking, the above statement is incorrect because @code{C} is a
 * regular differential chain obtained by processing these polynomials
 * by a non-differential regular chain decomposition algorithm.
 * Moreover, before being processed, these polynomials lie in @code{P} and
 * not in @code{C}.
 * 
 * The field @code{zeta} contains the last tried value for the
 * valuation @code{k} of the separant of @math{F}.
 * Its value is bounded by the field @code{kappa} of @var{U}.
 * If undefined, @code{zeta} is equal to @math{-1}.
 * 
 * The field @code{C} contains a regular differential chain obtained
 * by extension of an initial regular differential chain with
 * prolongation equations and other polynomials considered while
 * building the polynomial @math{A(q)}.
 * 
 * The field @code{P} contains the equations waiting for being processed.
 * The polynomials in @code{P} are meant to be processed by a 
 * non-differential regular chain decomposition algorithm in order
 * to extend @code{C}. This process may actually split the 
 * current regular differential chain.
 * After the process, the field @code{P} becomes empty.
 * 
 * The field @code{S} contains the non-differential inequations to be taken into
 * account by the non-differential regular chain decomposition algorithm.
 * It contains polynomials which must be guaranteed to be nonzero in
 * order to guarantee the valuations of the separants of the ODE
 * system (the field @code{k}) and the degrees of the polynomials @math{A(q)}
 * (the fields @code{r} and @code{A}).
 * It is never emptied but its elements may get simplified when
 * @code{C} is updated.
 * 
 * The field @code{k} contains the valuation of the separant of @math{F}
 * i.e. of the series @math{S(\bar{\bar{y}})}.
 * If undefined, it is equal to @math{-1} otherwise, the polynomial
 * @math{S^{(k)}(y_i)} is guaranteed to be nonzero: it is either an element
 * of the base field or stored in the field @code{S}.
 * 
 * The field @code{fn} contains the Hurwitz coefficients of @math{F}
 * with respect to the valuation stored in @code{k}.
 * See the @code{bas_Hurwitz_coeffs} function.
 * This field is undefined if @code{k} is undefined else it 
 * contains @math{k+1} differential polynomials denoted
 * (see [DL84, Lemma 2.2])
 * @display
 * @math{[f_n, f_{n+1}, f_{n+2}, ..., f_{n+k}].}
 * @end display
 * 
 * The field @code{der_fn} contains differential polynomials 
 * involved in the definition of the polynomial @math{A(q)}.
 * It is built incrementally.
 * Successive values of this field are
 * @display
 * @math{[f_n], \quad [f_{n+1}, f_n'], \quad [f_{n+2}, f_{n+1}', f_n''], \quad @dots{}}
 * @end display
 * 
 * The field @code{phi} contains the last tried value for @code{r}.
 * Its value is bounded by the valuation @code{k}.
 * It is equal to the index of the last defined entry of @code{der_fn}.
 * If undefined, @code{phi} is equal to @math{-1}.
 * 
 * The field @code{deg} contains the last tried value for the
 * degree of the polynomial @math{A(q)}.
 * Its value is bounded by @code{phi}.
 * If undefined, @code{deg} is equal to @math{-1}.
 * 
 * The field @code{r} contains the first value of @code{phi} for
 * which a nonzero polynomial @math{A(q)} has been determined.
 * Its value is bounded by the valuation @code{k}.
 * The field @code{deg} then contains the degree of @math{A(q)}.
 * The leading coefficient of @math{A(q)} is either a base field
 * element or stored in the list @code{S} of polynomials which must
 * not vanish.
 * If undefined, @code{r} is equal to @math{-1}.
 *
 * The field @code{coeffs} contains the coefficients of the
 * polynomial @math{A(q)}. It is built using @code{der_fn}.
 * If undefined, it is empty else it involves @math{@code{deg} + 1} elements.
 * Indeed we have
 * @display
 * @math{A(q) = \sum_{i=0}^{@code{deg}}} @code{coeffs}_@math{i} @math{{q \choose i}}
 * @end display
 * 
 * The field @code{A} contains the polynomial @math{A(q)}.
 * Its degree in @math{q} is stored in the field @code{deg}.
 * If undefined it contains @math{0}.
 * 
 * The field @code{roots} contains the positive integer roots
 * of @math{A(q)}, stored by increasing values.
 * 
 * The field @code{gamma} contains either @math{0} is @code{roots}
 * is empty or @math{1} plus the maximal positive integer root
 * of @math{A(q)}.
 * If undefined, it contains @math{-1}.
 * 
 * The field @code{beta} contains the bound @math{2\,k+2+\gamma+r}
 * or @math{-1} if undefined.
 * 
 * The field @code{delta} contains the bound @math{n+2\,k+2+\gamma}
 * where @math{n} denotes the order of @math{F}
 * or @math{-1} if undefined.
 * 
 * The field @code{done} contains @code{true} if the bounds are
 * considered as correct, @code{false} otherwise.
 * Indeed, when the bound @code{beta} is determined, new prolongation
 * equations are generated which may simplify coefficients of the 
 * polynomial @math{A(q)} thereby increase @code{gamma} hence
 * @code{beta}. In such cases, some computations have to be 
 * done again.
 * If @code{done} is equal to @code{false} then the coefficients
 * of the polynomial @math{A(q)} are checked and the computation
 * of @code{beta} is possibly restarted.
 * If @code{done} is equal to @code{true}, the current @code{struct bas_Zuple}
 * is complete and can be transformed into a @code{bas_DLuple}.
 * Eventually, @code{beta} is equal to @code{mu} minus @math{1}.
 *
 * The field @code{number} identifies the current 
 * @code{struct bas_Zuple} in a @code{struct bas_DL_tree}.
 */

struct bas_Zuple
{
  struct ba0_tableof_int_p sigma;

  struct ba0_tableof_int_p mu;

  struct ba0_tableof_int_p zeta;

  struct bad_regchain C;
  struct bap_listof_polynom_mpz *P;
  struct bap_listof_polynom_mpz *S;

  struct ba0_tableof_int_p k;
  struct bap_tableof_tableof_polynom_mpz fn;
  struct bap_tableof_tableof_polynom_mpz der_fn;

  struct ba0_tableof_int_p phi;
  struct ba0_tableof_int_p deg;
  struct ba0_tableof_int_p r;

  struct baz_tableof_tableof_ratfrac coeffs;
  struct baz_tableof_ratfrac A;
  struct ba0_tableof_tableof_mpz roots;
  struct ba0_tableof_int_p gamma;
  struct ba0_tableof_int_p beta;
  struct ba0_tableof_int_p delta;

  struct ba0_tableof_int_p done;

  ba0_int_p number;
};

struct bas_tableof_Zuple
{
  ba0_int_p alloc;
  ba0_int_p size;
  struct bas_Zuple **tab;
};

/*
 * texinfo: bas_typeof_action_on_Zuple
 * This data type is used to determine which action needs be
 * undertaken over a given Zuple.
 */

enum bas_typeof_action_on_Zuple
{
  bas_nothing_to_do_Zuple,
  bas_discard_Zuple,
  bas_k_to_secure_Zuple,
  bas_r_to_secure_Zuple,
  bas_beta_to_compute_Zuple,
  bas_A_to_specialize_and_beta_to_recompute_Zuple
};

struct bas_DL_tree;

extern BAS_DLL void bas_init_Zuple (
    struct bas_Zuple *);

extern BAS_DLL struct bas_Zuple *bas_new_Zuple (
    void);

extern BAS_DLL void bas_set_Yuple_Zuple (
    struct bas_tableof_Zuple *,
    struct ba0_tableof_int_p *,
    struct bas_Yuple *,
    struct bas_DL_tree *,
    struct bap_tableof_polynom_mpz *,
    struct bad_regchain *,
    struct bad_base_field *,
    struct bav_tableof_variable *);

extern BAS_DLL void bas_set_but_change_regchain_Zuple (
    struct bas_Zuple *,
    struct bas_Zuple *,
    struct bad_regchain *);

extern BAS_DLL void bas_set_Zuple (
    struct bas_Zuple *,
    struct bas_Zuple *);

extern BAS_DLL void bas_set_number_Zuple (
    struct bas_Zuple *,
    ba0_int_p);

extern BAS_DLL char *bas_typeof_action_on_Zuple_to_string (
    enum bas_typeof_action_on_Zuple);

extern BAS_DLL enum bas_typeof_action_on_Zuple bas_get_action_on_Zuple (
    struct bas_Zuple *,
    struct bas_Yuple *);

extern BAS_DLL void bas_secure_k_Zuple (
    struct bas_tableof_Zuple *,
    struct ba0_tableof_int_p *,
    struct bas_Yuple *,
    struct bas_DL_tree *,
    struct bad_base_field *);

extern BAS_DLL void bas_secure_r_Zuple (
    struct bas_tableof_Zuple *,
    struct ba0_tableof_int_p *,
    struct bas_Yuple *,
    struct bas_DL_tree *,
    struct bad_base_field *);

extern BAS_DLL void bas_compute_beta_Zuple (
    struct bas_tableof_Zuple *,
    struct ba0_tableof_int_p *,
    struct bas_Yuple *,
    struct bas_DL_tree *,
    struct bad_base_field *);

extern BAS_DLL void bas_specialize_A_and_recompute_beta_Zuple (
    struct bas_tableof_Zuple *,
    struct ba0_tableof_int_p *,
    struct bas_Yuple *,
    struct bas_DL_tree *,
    struct bad_base_field *);

extern BAS_DLL ba0_scanf_function bas_scanf_Zuple;

extern BAS_DLL ba0_printf_function bas_printf_Zuple;

extern BAS_DLL ba0_garbage1_function bas_garbage1_Zuple;

extern BAS_DLL ba0_garbage2_function bas_garbage2_Zuple;

extern BAS_DLL ba0_copy_function bas_copy_Zuple;


END_C_DECLS
#endif /* !BAS_ZUPLE_H */
#if !defined (BAS_DL_VERTEX_H)
#   define BAS_DL_VERTEX_H 1

/* #   include "bas_DL_edge.h" */
/* #   include "bas_Zuple.h" */

BEGIN_C_DECLS

/*
 * texinfo: bas_typeof_consistency_vertex
 * This data type is a subtype of @code{bas_DL_vertex}.
 * It determines the consistency information of one vertex
 * of a DL tree.
 */

enum bas_typeof_consistency_vertex
{
// the vertex is inconsistent
  bas_inconsistent_vertex,
// the vertex is rejected because kappa is exceeded
  bas_rejected_vertex,
// the consistency of the vertex is uncertain (at least when created)
  bas_uncertain_vertex,
// the vertex is consistent
  bas_consistent_vertex
};

/*
 * texinfo: bas_DL_vertex
 * This data type is a subtype of @code{bas_DL_tree}.
 * It permits to describe one vertex of the tree.
 * Each vertex corresponds to a Zuple @var{Z}, which
 * is identified by its @emph{number}.
 *
 * The field @code{number} contains the number of the vertex.
 *
 * The field @code{consistency} provides the consistency information
 * for the vertex. The default value is @code{bas_uncertain_vertex}.
 *
 * The field @code{edges} contains the table of the edges starting
 * from the vertex towards other vertices of the DL tree.
 *
 * The field @code{action} contains the action to be undertaken on the vertex.
 * The field @code{y} contains the differential indeterminate
 * with respect to which the action is undertaken. 
 * The fields @code{k}, @code{r} and @code{deg} contain the entries of the 
 * corresponding fields of @var{Z} which apply to @code{y}.
 */

struct bas_DL_vertex
{
// the number of the vertex which is also the number of the quadruple
  ba0_int_p number;
// the consistency information for the vertex
  enum bas_typeof_consistency_vertex consistency;
// the edges towards the children of the vertex
  struct bas_tableof_DL_edge edges;
// information of the process undertaken by the vertex
  enum bas_typeof_action_on_Zuple action;
  struct bav_symbol *y;
  ba0_int_p k;
  ba0_int_p r;
  ba0_int_p deg;
};

struct bas_tableof_DL_vertex
{
  ba0_int_p alloc;
  ba0_int_p size;
  struct bas_DL_vertex **tab;
};

extern BAS_DLL void bas_init_DL_vertex (
    struct bas_DL_vertex *);

extern BAS_DLL struct bas_DL_vertex *bas_new_DL_vertex (
    void);

extern BAS_DLL void bas_reset_DL_vertex (
    struct bas_DL_vertex *,
    ba0_int_p);

extern BAS_DLL void bas_set_DL_vertex (
    struct bas_DL_vertex *,
    struct bas_DL_vertex *);

extern BAS_DLL void bas_set_aykrd_DL_vertex (
    struct bas_DL_vertex *,
    enum bas_typeof_action_on_Zuple,
    struct bav_symbol *,
    ba0_int_p,
    ba0_int_p,
    ba0_int_p);

extern BAS_DLL ba0_scanf_function bas_scanf_DL_vertex;

extern BAS_DLL ba0_printf_function bas_printf_DL_vertex;

extern BAS_DLL ba0_garbage1_function bas_garbage1_DL_vertex;

extern BAS_DLL ba0_garbage2_function bas_garbage2_DL_vertex;

extern BAS_DLL ba0_copy_function bas_copy_DL_vertex;

END_C_DECLS
#endif /* !BAS_DL_VERTEX_H */
#if !defined (BAS_DL_TREE_H)
#   define BAS_DL_TREE_H 1

/* #   include "bas_DL_vertex.h" */

BEGIN_C_DECLS

/*
 * texinfo: bas_activity_level_DL_tree
 * This data type is a subtype of @code{bas_DL_tree}.
 */

enum bas_activity_level_DL_tree
{
// the DL tree is not generated
  bas_inactive_DL_tree,
// the DL tree is generated
  bas_quiet_DL_tree,
// the DL tree is generated and messages are printed
  bas_verbose_DL_tree
};

/*
 * texinfo: bas_DL_tree
 * This data type permits to describe the DL tree generated by the
 * @code{bas_Denef_Lipshitz_leaf} function.
 *
 * The field @code{roots} contains the numbers of the different
 * roots of the different trees (the data structure actually contains
 * a forrest rather than a single tree).
 *
 * The field @code{vertices} contains the table of the tree vertices.
 * Each vertex is associated to one Zuple, identified
 * by its @emph{number}. This @emph{number} is moreover equal to
 * the index of the vertex in the table. 
 *
 * The field @code{number} contains the next free vertex number.
 * It may be greater than the @code{alloc} field of the @code{vertices}
 * table.
 *
 * The field @code{activity} provides the level of activity of the
 * tree. It may have three values:
 * @itemize
 * @item @code{bas_inactive_DL_tree} then the only active field
 * if @code{number} and the two tables remain empty~;
 * @item @code{bas_quiet_DL_tree} then the DL tree is generated
 * @item @code{bas_verbose_DL_tree} same as above but the
 * the @code{bas_Denef_Lipshitz_leaf} function may print some 
 * further data on the standard output.
 * @end itemize
 */

struct bas_DL_tree
{
  enum bas_activity_level_DL_tree activity;
// the table of the roots
  struct ba0_tableof_int_p roots;
// the table of vertices
  struct bas_tableof_DL_vertex vertices;
// the next free vertex number
  ba0_int_p number;
};

extern BAS_DLL void bas_init_DL_tree (
    struct bas_DL_tree *);

extern BAS_DLL struct bas_DL_tree *bas_new_DL_tree (
    void);

extern BAS_DLL void bas_reset_DL_tree (
    struct bas_DL_tree *,
    enum bas_activity_level_DL_tree);

extern BAS_DLL void bas_set_DL_tree (
    struct bas_DL_tree *,
    struct bas_DL_tree *);

extern BAS_DLL void bas_add_root_DL_tree (
    struct bas_DL_tree *,
    ba0_int_p);

extern BAS_DLL ba0_int_p bas_next_number_DL_tree (
    struct bas_DL_tree *);

extern BAS_DLL struct bas_DL_vertex *bas_ith_vertex_DL_tree (
    struct bas_DL_tree *,
    ba0_int_p);

extern BAS_DLL void bas_set_vertex_consistency_DL_tree (
    struct bas_DL_tree *,
    ba0_int_p,
    enum bas_typeof_consistency_vertex);

extern BAS_DLL void bas_set_aykrd_vertex_DL_tree (
    struct bas_DL_tree *,
    ba0_int_p,
    enum bas_typeof_action_on_Zuple,
    struct bav_symbol *,
    ba0_int_p,
    ba0_int_p,
    ba0_int_p);

extern BAS_DLL void bas_add_edge_DL_tree (
    struct bas_DL_tree *,
    enum bas_typeof_DL_edge,
    ba0_int_p,
    ba0_int_p);

extern BAS_DLL void bas_dot_DL_tree (
    struct bas_DL_tree *);

extern BAS_DLL ba0_scanf_function bas_scanf_DL_tree;

extern BAS_DLL ba0_printf_function bas_printf_DL_tree;

extern BAS_DLL ba0_garbage1_function bas_garbage1_DL_tree;

extern BAS_DLL ba0_garbage2_function bas_garbage2_DL_tree;

extern BAS_DLL ba0_copy_function bas_copy_DL_tree;

END_C_DECLS
#endif
#if ! defined (BAS_DLUPLE_H)
#   define BAS_DLUPLE_H 1

/* #   include "bas_Yuple.h" */
/* #   include "bas_Zuple.h" */

BEGIN_C_DECLS

/*
 * texinfo: bas_DLuple
 * This data structure is used to store the output of the
 * Denef Lipshitz algorithm. Its fields are copies of
 * the corresponding fields of a @code{struct bas_Yuple} and
 * a @code{struct bas_Zuple} produced by the 
 * @code{bas_Denef_Lipshitz_leaf} function.
 */

struct bas_DLuple
{
  struct bav_tableof_symbol Y;
  struct baz_prolongation_pattern Ybar;
  struct bav_symbol *x;
  struct ba0_tableof_int_p order;
  struct ba0_tableof_int_p kappa;
  struct bad_regchain C;
  struct bap_listof_polynom_mpz *S;
  struct ba0_tableof_int_p k;
  struct ba0_tableof_int_p r;
  struct bav_variable *q;
  struct baz_tableof_ratfrac A;
  struct ba0_tableof_int_p gamma;
  struct ba0_tableof_int_p mu;
  struct ba0_tableof_int_p sigma;
  struct ba0_tableof_int_p beta;
  struct ba0_tableof_int_p delta;
};

struct bas_tableof_DLuple
{
  ba0_int_p alloc;
  ba0_int_p size;
  struct bas_DLuple **tab;
};

extern BAS_DLL void bas_init_DLuple (
    struct bas_DLuple *);

extern BAS_DLL struct bas_DLuple *bas_new_DLuple (
    void);

extern BAS_DLL void bas_set_DLuple (
    struct bas_DLuple *,
    struct bas_DLuple *);

extern BAS_DLL void bas_set_YZuple_DLuple (
    struct bas_DLuple *,
    struct bas_Yuple *,
    struct bas_Zuple *);

extern BAS_DLL unsigned ba0_int_p bas_sizeof_DLuple (
    struct bas_DLuple *,
    enum ba0_garbage_code);

extern BAS_DLL void bas_switch_ring_DLuple (
    struct bas_DLuple *,
    struct bav_differential_ring *);

extern BAS_DLL void bas_constant_variables_DLuple (
    struct ba0_tableof_int_p *,
    struct bav_tableof_variable *,
    struct bas_DLuple *);

extern BAS_DLL void bas_series_coefficients_DLuple (
    struct baz_tableof_tableof_ratfrac *,
    struct bas_DLuple *);

extern BAS_DLL ba0_scanf_function bas_scanf_DLuple;

extern BAS_DLL ba0_printf_function bas_printf_DLuple;

extern BAS_DLL ba0_printf_function bas_printf_stripped_DLuple;

extern BAS_DLL ba0_garbage1_function bas_garbage1_DLuple;

extern BAS_DLL ba0_garbage2_function bas_garbage2_DLuple;

extern BAS_DLL ba0_copy_function bas_copy_DLuple;

END_C_DECLS
#endif /* !BAS_DL_UPLE_H */
#if ! defined (BAS_BETA_H)
#   define BAS_BETA_H 1

/* #   include "bas_common.h" */

BEGIN_C_DECLS

/*
 * texinfo: bas_beta_control
 * This data type permits to control the management of the @math{\beta}
 * bounds in the @code{bas_Denef_Lipshitz} function and, more precisely
 * in the @code{bas_Denef_Lipshitz_aux} subfunction.
 *
 * The value @code{bas_single_beta_control} corresponds to the strategy 
 * given in [Theorem 3.1, DL84]: the bound @math{\beta} is a single
 * nonnegative integer.
 *
 * The value @code{bas_vector_beta_control} is an optimization, leading
 * to lower bounds: the bound @math{\beta} is a vectior with one entry
 * per differential indeterminate for which formal power series are sought.
 */

enum bas_beta_control
{
  bas_single_beta_control,
  bas_vector_beta_control
};

/*
 * texinfo: bas_beta
 * This data type implements the beta bound in the @code{bas_Denef_Lipshitz_aux}
 * algorithm.
 *
 * The field @code{control} contains the type of control to be applied.
 *
 * The field @code{single} contains the value of @math{\beta} in the
 * @code{bas_single_beta_control} case.
 *
 * The field @code{vector} contains the value of @math{\beta} in the
 * @code{bas_vector_beta_control} case.
 *
 * In the documentation of functions, by @emph{entries of @math{\beta}}
 * we mean either the @code{single} field when @code{control}
 * contains @code{bas_single_beta_control}~; or the coordinates
 * of the @code{vector} table in the other case.
 */

struct bas_beta
{
  enum bas_beta_control control;
  ba0_int_p single;
  struct ba0_tableof_int_p vector;
};

struct bas_Yuple;

extern BAS_DLL void bas_init_beta (
    struct bas_beta *);

extern BAS_DLL struct bas_beta *bas_new_beta (
    void);

extern BAS_DLL void bas_set_Y_control_beta (
    struct bas_beta *,
    struct bav_tableof_symbol *,
    enum bas_beta_control);

extern BAS_DLL void bas_set_beta (
    struct bas_beta *,
    struct bas_beta *);

extern BAS_DLL void bas_set_int_beta (
    struct bas_beta *,
    ba0_int_p);

extern BAS_DLL void bas_max_componentwise_beta (
    struct bas_beta *,
    struct bas_beta *);

extern BAS_DLL void bas_max_componentwise2_beta (
    struct bas_beta *,
    struct ba0_tableof_int_p *);

extern BAS_DLL ba0_int_p bas_max_value_beta (
    struct bas_beta *);

extern BAS_DLL void bas_add_thetas_to_beta (
    struct bas_beta *,
    struct bas_Yuple *,
    struct bav_tableof_variable *,
    struct bav_tableof_term *);

extern BAS_DLL void bas_max_splitting_edge_beta (
    struct bas_beta *,
    struct bas_beta *,
    struct bad_splitting_edge *,
    struct bas_Yuple *);

extern BAS_DLL ba0_printf_function bas_printf_beta;

END_C_DECLS
#endif /* !BAS_BETA_H */
#if ! defined (BAS_DENEF_LIPSHITZ_H)
#   define BAS_DENEF_LIPSHITZ_H 1

/* #   include "bas_DLuple.h" */
/* #   include "bas_DL_tree.h" */
/* #   include "bas_beta.h" */

BEGIN_C_DECLS

extern BAS_DLL void bas_prolongate_DLuple (
    struct bas_DLuple *,
    struct bas_DLuple *,
    struct bav_tableof_variable *);

extern BAS_DLL void bas_Denef_Lipshitz_resume (
    struct bas_tableof_DLuple *,
    struct bas_DLuple *,
    struct bap_tableof_polynom_mpz *,
    struct bap_tableof_polynom_mpz *);

extern BAS_DLL ba0_int_p bas_Denef_Lipshitz_leaf (
    struct bas_tableof_DLuple *,
    struct bas_DL_tree *,
    ba0_int_p,
    struct bas_Yuple *,
    struct bad_regchain *,
    struct bad_base_field *);

extern BAS_DLL ba0_int_p bas_Denef_Lipshitz_aux (
    struct bas_tableof_DLuple *,
    struct bas_DL_tree *,
    ba0_int_p,
    struct bas_Yuple *,
    struct bad_intersectof_regchain *,
    struct bad_splitting_tree *,
    ba0_int_p,
    struct bad_base_field *);

extern BAS_DLL void bas_Denef_Lipshitz (
    struct bas_tableof_DLuple *,
    struct bas_DL_tree *,
    struct bap_tableof_polynom_mpz *,
    struct bap_tableof_polynom_mpz *,
    struct ba0_tableof_string *,
    struct bav_tableof_symbol *,
    struct baz_prolongation_pattern *,
    struct bav_variable *,
    struct bav_symbol *,
    enum bas_beta_control);

END_C_DECLS
#endif /* !BAS_DENEF_LIPSHITZ_H */
#if !defined (BAI_COMMON_H)
#   define BAI_COMMON_H 1

/* #   include <bas.h> */

/* 
 * The _MSC_VER flag is set if the code is compiled under WINDOWS
 * by using Microsoft Visual C (through Visual Studio 2008).
 *
 * In that case, some specific annotations must be added for DLL exports
 * Beware to the fact that this header file is going to be used either
 * for/while building BLAD or for using BLAD from an outer software.
 *
 * In the first case, functions are exported.
 * In the second one, they are imported.
 *
 * The flag BAI_BLAD_BUILDING must thus be set in the Makefile and passed
 * to the C preprocessor at BAI building time. Do not set it when using BAI.
 *
 * When compiling static libraries under Windows, set BA0_STATIC.
 */

#   if defined (_MSC_VER) && ! defined (BA0_STATIC)
#      if defined (BLAD_BUILDING) || defined (BAI_BLAD_BUILDING)
#         define BAI_DLL  __declspec(dllexport)
#      else
#         define BAI_DLL  __declspec(dllimport)
#      endif
#   else
#      define BAI_DLL
#   endif

/* #   include "bai_mesgerr.h" */

/* 
 * For Solaris 8
 */

#   if HAVE_IEEEFP_H
#      include <ieeefp.h>
#   endif

BEGIN_C_DECLS

extern BAI_DLL void bai_reset_all_settings (
    void);

extern BAI_DLL void bai_restart (
    ba0_int_p,
    ba0_int_p);

extern BAI_DLL void bai_terminate (
    enum ba0_restart_level);

END_C_DECLS
#endif /* !BAI_COMMON_H */
#if !defined (BAI_MESGERR_H)
#   define BAI_MESGERR_H 1

/* #   include "bai_common.h" */

BEGIN_C_DECLS

extern BAI_DLL char BAI_ERRUNK[];

extern BAI_DLL char BAI_ERRDOW[];

extern BAI_DLL char BAI_EXEVAL[];

extern BAI_DLL char BAI_EXSSIZ[];

extern BAI_DLL char BAI_EXMAXS[];

extern BAI_DLL char BAI_EXSTIF[];

extern BAI_DLL char BAI_ERROXS[];

END_C_DECLS
#endif /* !BAI_MESGERR_H */
#if !defined (BAI_ODEX_FUNCTION_H)
#   define BAI_ODEX_FUNCTION_H 1

/* #   include "bai_common.h" */

BEGIN_C_DECLS

/*
 * texinfo: bai_parameters
 * This data type associates floating point values to symbolic parameters.
 */

struct bai_parameters
{
// parameter values
  double *values;
// actually points to a struct bav_tableof_variable
// it is a copy of the field S->params of the differential system S
  void *names;
};

/*
 * texinfo: bai_command_function
 * This data type provides the signature of command functions.
 */

typedef double bai_command_function (
// the independent variable
    double t,
// actually points to a struct bai_params
    void *params);

/*
 * texinfo: bai_commands
 * This data type associates bai_command_function to symbolic function names.
 */

struct bai_commands
{
// the function pointers
  bai_command_function **fptrs;
// actually points to a struct bav_tableof_variable
// it is a copy of the field S->commands of the differential system S
  void *names;
};

/*
 * texinfo: bai_params
 * This data type describes the data structure passed as an extra argument
 * to the functions which need be evaluated by ODE integrators.
 */

struct bai_params
{
// the parameters
  struct bai_parameters pars;
// the commands
  struct bai_commands cmds;
// unused
  void *extra;
};

/* 
 * texinfo: bai_exit_code
 * This data type defines the possible exit codes for 
 * explicit ODE integrators.
 */

enum bai_exit_code
{
// compatible with the Gnu Scientific Library : GSL_SUCCESS = 0
  bai_odex_success = 0,
  bai_odex_non_finite = 1
};

END_C_DECLS
#endif /* !BAI_ODEX_FUNCTION_H */
#if !defined (BAI_ODEX_INTEGRATED_FUNCTION_H)
#   define BAI_ODEX_INTEGRATED_FUNCTION_H 1

/* 
 * The signatures of the function which evaluate the righthand side
 * of the ODE system to be integrated by explicit ODE integrators and 
 * its jacobian matrix.
 *
 * Signatures are compatible with that defined in the Gnu Scientific Library.
 */

/* #   include "bai_common.h" */
/* #   include "bai_odex_function.h" */

BEGIN_C_DECLS

typedef enum bai_exit_code bai_odex_integrated_function (
// the independent variable
    double t,
// the current values of the dependent variables
    double *x,
// the output vector f(x)
    double *f,
// if the function is generated by bai_odex_generate_C_code,
// params points to a struct bai_parameters
    void *params);

typedef enum bai_exit_code bai_odex_jacobianof_integrated_function (
// the independent variable
    double t,
// the current values of the dependent variables
    double *x,
// the output row-ordered Jacobian matrix
// same convention as the GSL
    double *J,
// the output vector df/dt (x)
    double *K,
// if the function is generated by bai_odex_generate_C_code,
// params points to a struct bai_parameters
    void *params);

END_C_DECLS
#endif /* !BAI_ODEX_INTEGRATED_FUNCTION_H */
#if !defined (BAI_ODEX_H)
#   define BAI_ODEX_H 1

/* #   include "bai_common.h" */

BEGIN_C_DECLS

/*
 * texinfo: bai_odex_system
 * This data type permits to implement an explicit parametric
 * ordinary differential system, possibly with commands.
 */

struct bai_odex_system
{
// the independent variable
  struct bav_variable *t;
// the left hand sides of the differential equations
  struct bav_tableof_variable lhs;
// the right hand sides
  struct baz_tableof_ratfrac rhs;
// the parameters
  struct bav_tableof_variable params;
// the commands
  struct bav_tableof_variable commands;
};


extern BAI_DLL void bai_init_odex_system (
    struct bai_odex_system *);

extern BAI_DLL void bai_reset_odex_system (
    struct bai_odex_system *);

extern BAI_DLL struct bai_odex_system *bai_new_odex_system (
    void);

extern BAI_DLL void bai_set_odex_system (
    struct bai_odex_system *,
    struct bai_odex_system *);

extern BAI_DLL void bai_set_odex_system_tables (
    struct bai_odex_system *,
    struct bav_variable *,
    struct bav_tableof_variable *,
    struct bav_tableof_variable *,
    struct bav_tableof_variable *,
    struct baz_tableof_ratfrac *);

extern BAI_DLL void bai_set_odex_system_regchain (
    struct bai_odex_system *,
    struct bav_variable *,
    struct bav_tableof_variable *,
    struct bav_tableof_variable *,
    struct bav_tableof_variable *,
    struct bad_regchain *);

extern BAI_DLL bool bai_odex_is_lhs (
    struct bav_variable *,
    struct bai_odex_system *,
    ba0_int_p *);

extern BAI_DLL ba0_scanf_function bai_scanf_odex_system;

extern BAI_DLL ba0_printf_function bai_printf_odex_system;

extern BAI_DLL ba0_garbage1_function bai_garbage1_odex_system;

extern BAI_DLL ba0_garbage2_function bai_garbage2_odex_system;

extern BAI_DLL ba0_copy_function bai_copy_odex_system;

extern BAI_DLL void bai_odex_generate_rhs_C_code (
    FILE *,
    char *,
    struct bai_odex_system *);

extern BAI_DLL void bai_odex_generate_jacobianof_rhs_C_code (
    FILE *,
    char *,
    struct bai_odex_system *);

END_C_DECLS
#endif /* !BAI_ODEX_H */
#if !defined (BAI_PARAMETERS_H)
#   define BAI_PARAMETERS_H 1

/* #   include "bai_common.h" */

BEGIN_C_DECLS
/* Keep it here */
/* #   include "bai_odex_function.h" */
extern BAI_DLL void bai_init_params (
    struct bai_params *);

extern BAI_DLL void bai_reset_params (
    struct bai_params *);

extern BAI_DLL struct bai_params *bai_new_params (
    void);

extern BAI_DLL void bai_set_params (
    struct bai_params *,
    struct bai_params *);

struct bai_odex_system;

extern BAI_DLL void bai_set_params_odex_system (
    struct bai_params *,
    struct bai_odex_system *);

extern BAI_DLL void bai_set_params_parameter (
    struct bai_params *,
    struct bav_variable *,
    double);

extern BAI_DLL void bai_set_params_command (
    struct bai_params *,
    struct bav_variable *,
    bai_command_function *);

END_C_DECLS
#endif /* !BAI_PARAMETERS_H */
#if !defined (BAI_DOP853_H)
#   define BAI_DOP853_H 1

/**********************************************************************
   Adaptation of the FORTRAN code provided by Ernst Hairer for DOP853.
   Page numbers refer to 

   Solving Ordinary Differential Equations I
   Ernst Hairer, Syvert Norsett, Gerhard Wanner
   Springer Verlag
   Second Revised Edition

   The Runge-Kutta method has order 8.
   There are two different embedded methods of respective orders 5 and 3
   in order to increase stability w.r.t. the "basic" 8(6) method. See page 254.

   The dense output method has order 7. See page 194.

   ODE y'(t) = f (t, y(t))

   The signature of the functions to be integrated.
   t = the independent variable
   y = the current value of the dependent variables y(t)
   f = the values to be computed f (t, y(t))
   params = whatever you want as extra parameters to provide to the function

   The function returns 0 on success and any nonzero value on failure.
 **********************************************************************/

/* #   include "bai_common.h" */
/* #   include "bai_odex.h" */
/* #   include "bai_odex_integrated_function.h" */

/**********************************************************************
 INITIAL VALUES

 There should be one y0 [i] per dependent variable.
 The ODE is integrated from t0 to t1. t0 > t1 is allowed.
 **********************************************************************/

BEGIN_C_DECLS

/*
 * texinfo: bai_dop853_initial_values
 * This data type permits to specify initial values for the DOP853
 * explicit ODE integrator.
 */

struct bai_dop853_initial_values
{
// starting value for the independent variable
  double t0;
// ending value
  double t1;
// initial values for the dependent variables
  struct ba0_arrayof_double y0;
};


extern BAI_DLL void bai_dop853_init_initial_values (
    struct bai_dop853_initial_values *);

extern BAI_DLL void bai_dop853_reset_initial_values (
    struct bai_dop853_initial_values *);

extern BAI_DLL struct bai_dop853_initial_values *bai_dop853_new_initial_values (
    void);

extern BAI_DLL void bai_dop853_realloc_initial_values (
    struct bai_dop853_initial_values *,
    ba0_int_p);

extern BAI_DLL void bai_dop853_set_initial_values_time (
    struct bai_dop853_initial_values *,
    double,
    double);

extern BAI_DLL void bai_dop853_set_initial_values_variable (
    struct bai_dop853_initial_values *,
    struct bav_variable *,
    struct bai_odex_system *,
    double);

extern BAI_DLL void bai_dop853_set_initial_values (
    struct bai_dop853_initial_values *,
    struct bai_dop853_initial_values *);

/**********************************************************************
   CONTROL
   Some default values can be provided using the initial values 

   uround = 2.3e-16
   safe_fac = 0.9
   fac1 = 1./3.
   fac2 = 6.
   beta = 0.
   hmax = |t1 - t0|
   h0 = determined by computation
   nb_max_steps = 100000
   stiffness_test_step = 1000

 **********************************************************************/

/*
 * texinfo: bai_dop853_control
 * This data structure controls the behaviour of the DOP 853 numerical
 * integrator.
 */

struct bai_dop853_control
{
// rounding unit
  double uround;
// factors which prevent stepsizes to increase/decrease too fast
  double safe_fac;
  double fac1;
  double fac2;
  double beta;
// maximum absolute value of the stepsize
  double hmax;
// signed initial stepsize
  double h0;
// maximum number of steps
  ba0_int_p nb_max_steps;
// used to decide when stiffness steps need be performed
  ba0_int_p stiffness_test_step;
};


extern BAI_DLL void bai_dop853_init_control (
    struct bai_dop853_control *);

extern BAI_DLL void bai_dop853_reset_control (
    struct bai_dop853_control *);

extern BAI_DLL void bai_dop853_set_control (
    struct bai_dop853_control *,
    struct bai_dop853_control *);

extern BAI_DLL void bai_dop853_set_default_control (
    struct bai_dop853_control *);

/**********************************************************************
 STATISTICS

 They are inlined now in the struct bai_dop853_workspace* structure
 **********************************************************************/

/*
 * texinfo: bai_dop853_stats
 * This data structure permits to provide statistics
 * on a numerical integration.
 */

struct bai_dop853_stats
{
// number of calls to the function to be integrated
  ba0_int_p nb_evals;
// number of steps
  ba0_int_p nb_steps;
// number of accepted steps
  ba0_int_p nb_accepts;
// number of rejected steps
  ba0_int_p nb_rejects;
};


extern BAI_DLL void bai_dop853_init_stats (
    struct bai_dop853_stats *);

extern BAI_DLL void bai_dop853_reset_stats (
    struct bai_dop853_stats *);

extern BAI_DLL void bai_dop853_set_stats (
    struct bai_dop853_stats *,
    struct bai_dop853_stats *);

/**********************************************************************
 ERROR TOLERANCE

 There are two types of error tolerance.
 bai_dop853_global_errtol: the entries relative [0] and absolute [0] are used
 bai_dop853_componentwise_errtol: the entries relative [i] and absolute [i]
	are used for each i (there should be an entry per dependent variable).
 **********************************************************************/

/*
 * texinfo: bai_dop853_typeof_errtol
 * This data type describes the two types of error tolerance.
 */

enum bai_dop853_typeof_errtol
{
  bai_dop853_global_errtol,
  bai_dop853_componentwise_errtol
};

/*
 * texinfo: bai_dop853_errtol
 * This data type permits to control the numerical integrator
 * by means of error tolerances.
 */

struct bai_dop853_errtol
{
  enum bai_dop853_typeof_errtol type;
// if type is bai_dop853_global_errtol then
//      the first entries of the next two arrays are used
// if type is bai_dop853_componentwise_errtol then
//      there should be one entry per dependent variable
  struct ba0_arrayof_double relative;
  struct ba0_arrayof_double absolute;
};


/* 
 * Initializes to bai_dop853_global_errtol with a absolute [0] = 1e-6 
 */

extern BAI_DLL void bai_dop853_init_errtol (
    struct bai_dop853_errtol *);

extern BAI_DLL void bai_dop853_reset_errtol (
    struct bai_dop853_errtol *);

extern BAI_DLL void bai_dop853_set_default_errtol (
    struct bai_dop853_errtol *);

extern BAI_DLL void bai_dop853_set_errtol (
    struct bai_dop853_errtol *,
    struct bai_dop853_errtol *);

extern BAI_DLL void bai_dop853_realloc_errtol (
    struct bai_dop853_errtol *,
    ba0_int_p);

/**********************************************************************
   VIEW

   What should be displayed

   view_t indicates if the independent variable must be displayed.
   Each entry of tab provides a variable or, more generally, a value
	to be displayed.
   If isvar is true then the value of the variable number varnum must be
	displayed. If isvar is false, then the* eval function is called
	and its returned value is displayed.
 **********************************************************************/

/*
 * texinfo: bai_dop853_eval_function
 * This data type provides the signature of user-defined function
 * called for printing the output of a numerical integration.
 */

typedef double bai_dop853_eval_function (
    double t,
// the numerical integrator workspace
    void *workspace);

/*
 * texinfo: bai_dop853_view_elt
 * This data type describes what should be printed on some given column.
 */

struct bai_dop853_view_elt
{
// if true the value of the dependent variable with index varnum is printed
// if false the result of the call to eval is printed
  bool isvar;
  ba0_int_p varnum;
  bai_dop853_eval_function *eval;
};


struct bai_arrayof_view_elt
{
  ba0_int_p alloc;
  ba0_int_p size;
  struct bai_dop853_view_elt *tab;
  ba0_int_p sizelt;
};


/*
 * texinfo: bai_dop853_view
 * This data type describes what should be printed during numerical
 * integration by the @code{bai_dop853_solout} function.
 * Each printed row involves many different columns.
 */

struct bai_dop853_view
{
// should the independent variable be printed ?
  bool view_t;
// one bai_dop853_view_elt per column
  struct bai_arrayof_view_elt elts;
};


extern BAI_DLL void bai_dop853_init_view (
    struct bai_dop853_view *);

extern BAI_DLL void bai_dop853_reset_view (
    struct bai_dop853_view *);

extern BAI_DLL void bai_dop853_realloc_view (
    struct bai_dop853_view *,
    ba0_int_p);

extern BAI_DLL void bai_dop853_set_view_variable (
    struct bai_dop853_view *,
    struct bav_variable *,
    struct bai_odex_system *);

extern BAI_DLL void bai_dop853_set_view_function (
    struct bai_dop853_view *,
    bai_dop853_eval_function *);

/**********************************************************************
 SOLOUT

 Prints in file f the values in w of the variables given in view.
 The boolean indicates if some interpolation must be performed, i.e. if
 a curve must be printed instead of a single point.
 If the boolean is true then
 - the double provides the interpolation step.
 - the variables in view must be prepared for dense output.
 
 **********************************************************************/

struct bai_dop853_workspace;

extern BAI_DLL void bai_dop853_solout (
    FILE *,
    struct bai_dop853_workspace *,
    struct bai_dop853_view *,
    bool,
    double);

/**********************************************************************
 DENSE OUTPUT 

 Dense output permits to interpolate the values of some dependent variables
 between two integration steps. 

 The indices of the variables over which dense output is going to be
 processed should be stored in index.
 **********************************************************************/

/*
 * texinfo: bai_dop853_dense_output
 * This data structure permits to provide dense output for some
 * dependent variables.
 */

struct bai_dop853_dense_output
{
// the indices of the variables for which dense output is desired
  struct ba0_tableof_int_p index;
// technical arrays
  struct ba0_arrayof_double cont0;
  struct ba0_arrayof_double cont1;
  struct ba0_arrayof_double cont2;
  struct ba0_arrayof_double cont3;
  struct ba0_arrayof_double cont4;
  struct ba0_arrayof_double cont5;
  struct ba0_arrayof_double cont6;
  struct ba0_arrayof_double cont7;
};


extern BAI_DLL void bai_dop853_init_dense_output (
    struct bai_dop853_dense_output *);

extern BAI_DLL void bai_dop853_reset_dense_output (
    struct bai_dop853_dense_output *);

extern BAI_DLL void bai_dop853_realloc_dense_output (
    struct bai_dop853_dense_output *,
    ba0_int_p);

extern BAI_DLL void bai_dop853_set_dense_output_all_variables (
    struct bai_dop853_dense_output *,
    struct bai_odex_system *);

extern BAI_DLL void bai_dop853_set_dense_output_variable (
    struct bai_dop853_dense_output *,
    struct bav_variable *,
    struct bai_odex_system *);

extern BAI_DLL void bai_dop853_set_dense_output (
    struct bai_dop853_dense_output *v,
    struct bai_dop853_dense_output *w);

/* 
 * Assigns yi (t) to *res. The value of t should be in the range w->told .. w->t */

extern BAI_DLL double bai_dop853_dense_output_evaluate (
    ba0_int_p i,
    double t,
    struct bai_dop853_workspace *w);

/**********************************************************************
 DOP 853
 **********************************************************************/

/*
 * texinfo: bai_dop853_workspace
 * This data type describes the workspace (the internal variables)
 * of the numerical integrator.
 */

struct bai_dop853_workspace
{
// old value of the independent variable
  double told;
// current value of the independent variable
  double t;
// current step size
  double h;
// values of the dependent variables at t
  struct ba0_arrayof_double y;
  struct ba0_arrayof_double y1;
  struct ba0_arrayof_double k1;
  struct ba0_arrayof_double k2;
  struct ba0_arrayof_double k3;
  struct ba0_arrayof_double k4;
  struct ba0_arrayof_double k5;
  struct ba0_arrayof_double k6;
  struct ba0_arrayof_double k7;
  struct ba0_arrayof_double k8;
  struct ba0_arrayof_double k9;
  struct ba0_arrayof_double k10;
  double hlamb;
  ba0_int_p nb_stiffs;
  ba0_int_p nb_non_stiffs;
  double facold;
  struct bai_dop853_stats stat;
// the function which evaluates the ODE right hand side
  bai_odex_integrated_function *fcn;
// initial values, error tolerance, control and dense output
  struct bai_dop853_initial_values iv;
  struct bai_dop853_errtol tol;
  struct bai_dop853_control control;
  struct bai_dop853_dense_output dow;
// if fcn is generated by bai_odex_generate_rhs_C_code then
// should point towards a struct bai_params structure
  void *params;
};


extern BAI_DLL void bai_dop853_init_workspace (
    struct bai_dop853_workspace *);

extern BAI_DLL void bai_dop853_reset_workspace (
    struct bai_dop853_workspace *);

extern BAI_DLL void bai_dop853_set_workspace (
    struct bai_dop853_workspace *,
    struct bai_dop853_workspace *);

extern BAI_DLL void bai_dop853_start_workspace (
    struct bai_dop853_workspace *,
    bai_odex_integrated_function * fcn,
    struct bai_dop853_initial_values *iv,
    struct bai_dop853_errtol *tol,
    struct bai_dop853_control *control,
    struct bai_dop853_dense_output *dow,
    void *params);

/* 
 * Performs one Runge-Kutta step. The main function. 
 */

extern BAI_DLL void bai_dop853_step_workspace (
    struct bai_dop853_workspace *);

/**********************************************************************
 EVALUATION FUNCTION

 The function index i must be prepared for dense output (it must
 appear in the index array of w->dow). res is a pointer to one double.

 Assigns to yi (t) to* res. 
 **********************************************************************/

extern BAI_DLL double bai_dop853_evaluate_variable (
    struct bav_variable *v,
    double t,
    struct bai_dop853_workspace *w,
    struct bai_odex_system *);

END_C_DECLS
#endif /* !BAI_DOP853_H */
#if !defined (BAI_GLOBAL_H)
#   define BAI_GLOBAL_H 1

/* #   include "bai_common.h" */
/* #   include "bai_odex.h" */

BEGIN_C_DECLS

struct bai_global
{
  struct
  {
/* 
 * Points to the ODEX system being considered.
 * Local to bai_odex.
 * Meaningless value between two calls.
 */
    struct bai_odex_system *system;
  } odex;
};

extern BAI_DLL struct bai_global bai_global;

END_C_DECLS
#endif /* !BAI_GLOBAL_H */
