# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServicePerimeterEgressPolicyArgs', 'ServicePerimeterEgressPolicy']

@pulumi.input_type
class ServicePerimeterEgressPolicyArgs:
    def __init__(__self__, *,
                 perimeter: pulumi.Input[builtins.str],
                 egress_from: Optional[pulumi.Input['ServicePerimeterEgressPolicyEgressFromArgs']] = None,
                 egress_to: Optional[pulumi.Input['ServicePerimeterEgressPolicyEgressToArgs']] = None,
                 title: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ServicePerimeterEgressPolicy resource.
        :param pulumi.Input[builtins.str] perimeter: The name of the Service Perimeter to add this resource to.
        :param pulumi.Input['ServicePerimeterEgressPolicyEgressFromArgs'] egress_from: Defines conditions on the source of a request causing this `EgressPolicy` to apply.
               Structure is documented below.
        :param pulumi.Input['ServicePerimeterEgressPolicyEgressToArgs'] egress_to: Defines the conditions on the `ApiOperation` and destination resources that
               cause this `EgressPolicy` to apply.
               Structure is documented below.
        :param pulumi.Input[builtins.str] title: Human readable title. Must be unique within the perimeter. Does not affect behavior.
        """
        pulumi.set(__self__, "perimeter", perimeter)
        if egress_from is not None:
            pulumi.set(__self__, "egress_from", egress_from)
        if egress_to is not None:
            pulumi.set(__self__, "egress_to", egress_to)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def perimeter(self) -> pulumi.Input[builtins.str]:
        """
        The name of the Service Perimeter to add this resource to.
        """
        return pulumi.get(self, "perimeter")

    @perimeter.setter
    def perimeter(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "perimeter", value)

    @property
    @pulumi.getter(name="egressFrom")
    def egress_from(self) -> Optional[pulumi.Input['ServicePerimeterEgressPolicyEgressFromArgs']]:
        """
        Defines conditions on the source of a request causing this `EgressPolicy` to apply.
        Structure is documented below.
        """
        return pulumi.get(self, "egress_from")

    @egress_from.setter
    def egress_from(self, value: Optional[pulumi.Input['ServicePerimeterEgressPolicyEgressFromArgs']]):
        pulumi.set(self, "egress_from", value)

    @property
    @pulumi.getter(name="egressTo")
    def egress_to(self) -> Optional[pulumi.Input['ServicePerimeterEgressPolicyEgressToArgs']]:
        """
        Defines the conditions on the `ApiOperation` and destination resources that
        cause this `EgressPolicy` to apply.
        Structure is documented below.
        """
        return pulumi.get(self, "egress_to")

    @egress_to.setter
    def egress_to(self, value: Optional[pulumi.Input['ServicePerimeterEgressPolicyEgressToArgs']]):
        pulumi.set(self, "egress_to", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Human readable title. Must be unique within the perimeter. Does not affect behavior.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "title", value)


@pulumi.input_type
class _ServicePerimeterEgressPolicyState:
    def __init__(__self__, *,
                 access_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 egress_from: Optional[pulumi.Input['ServicePerimeterEgressPolicyEgressFromArgs']] = None,
                 egress_to: Optional[pulumi.Input['ServicePerimeterEgressPolicyEgressToArgs']] = None,
                 etag: Optional[pulumi.Input[builtins.str]] = None,
                 perimeter: Optional[pulumi.Input[builtins.str]] = None,
                 title: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ServicePerimeterEgressPolicy resources.
        :param pulumi.Input[builtins.str] access_policy_id: The name of the Access Policy this resource belongs to.
        :param pulumi.Input['ServicePerimeterEgressPolicyEgressFromArgs'] egress_from: Defines conditions on the source of a request causing this `EgressPolicy` to apply.
               Structure is documented below.
        :param pulumi.Input['ServicePerimeterEgressPolicyEgressToArgs'] egress_to: Defines the conditions on the `ApiOperation` and destination resources that
               cause this `EgressPolicy` to apply.
               Structure is documented below.
        :param pulumi.Input[builtins.str] etag: The perimeter etag is internally used to prevent overwriting the list of policies on PATCH calls. It is retrieved from the same GET perimeter API call that's used to get the current list of policies. The policy defined in this resource is added or removed from that list, and then this etag is sent with the PATCH call along with the updated policies.
        :param pulumi.Input[builtins.str] perimeter: The name of the Service Perimeter to add this resource to.
        :param pulumi.Input[builtins.str] title: Human readable title. Must be unique within the perimeter. Does not affect behavior.
        """
        if access_policy_id is not None:
            pulumi.set(__self__, "access_policy_id", access_policy_id)
        if egress_from is not None:
            pulumi.set(__self__, "egress_from", egress_from)
        if egress_to is not None:
            pulumi.set(__self__, "egress_to", egress_to)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if perimeter is not None:
            pulumi.set(__self__, "perimeter", perimeter)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter(name="accessPolicyId")
    def access_policy_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Access Policy this resource belongs to.
        """
        return pulumi.get(self, "access_policy_id")

    @access_policy_id.setter
    def access_policy_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "access_policy_id", value)

    @property
    @pulumi.getter(name="egressFrom")
    def egress_from(self) -> Optional[pulumi.Input['ServicePerimeterEgressPolicyEgressFromArgs']]:
        """
        Defines conditions on the source of a request causing this `EgressPolicy` to apply.
        Structure is documented below.
        """
        return pulumi.get(self, "egress_from")

    @egress_from.setter
    def egress_from(self, value: Optional[pulumi.Input['ServicePerimeterEgressPolicyEgressFromArgs']]):
        pulumi.set(self, "egress_from", value)

    @property
    @pulumi.getter(name="egressTo")
    def egress_to(self) -> Optional[pulumi.Input['ServicePerimeterEgressPolicyEgressToArgs']]:
        """
        Defines the conditions on the `ApiOperation` and destination resources that
        cause this `EgressPolicy` to apply.
        Structure is documented below.
        """
        return pulumi.get(self, "egress_to")

    @egress_to.setter
    def egress_to(self, value: Optional[pulumi.Input['ServicePerimeterEgressPolicyEgressToArgs']]):
        pulumi.set(self, "egress_to", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The perimeter etag is internally used to prevent overwriting the list of policies on PATCH calls. It is retrieved from the same GET perimeter API call that's used to get the current list of policies. The policy defined in this resource is added or removed from that list, and then this etag is sent with the PATCH call along with the updated policies.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter
    def perimeter(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Service Perimeter to add this resource to.
        """
        return pulumi.get(self, "perimeter")

    @perimeter.setter
    def perimeter(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "perimeter", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Human readable title. Must be unique within the perimeter. Does not affect behavior.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "title", value)


@pulumi.type_token("gcp:accesscontextmanager/servicePerimeterEgressPolicy:ServicePerimeterEgressPolicy")
class ServicePerimeterEgressPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 egress_from: Optional[pulumi.Input[Union['ServicePerimeterEgressPolicyEgressFromArgs', 'ServicePerimeterEgressPolicyEgressFromArgsDict']]] = None,
                 egress_to: Optional[pulumi.Input[Union['ServicePerimeterEgressPolicyEgressToArgs', 'ServicePerimeterEgressPolicyEgressToArgsDict']]] = None,
                 perimeter: Optional[pulumi.Input[builtins.str]] = None,
                 title: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manage a single EgressPolicy in the status (enforced) configuration for a service perimeter.
        EgressPolicies match requests based on egressFrom and egressTo stanzas.
        For an EgressPolicy to match, both egressFrom and egressTo stanzas must be matched.
        If an EgressPolicy matches a request, the request is allowed to span the ServicePerimeter
        boundary. For example, an EgressPolicy can be used to allow VMs on networks
        within the ServicePerimeter to access a defined set of projects outside the
        perimeter in certain contexts (e.g. to read data from a Cloud Storage bucket
        or query against a BigQuery dataset).

        > **Note:** By default, updates to this resource will remove the EgressPolicy from the
        from the perimeter and add it back in a non-atomic manner. To ensure that the new EgressPolicy
        is added before the old one is removed, add a `lifecycle` block with `create_before_destroy = true` to this resource.
        **Note:** If this resource is used alongside a `accesscontextmanager.ServicePerimeter` resource,
        the service perimeter resource must have a `lifecycle` block with `ignore_changes = [status[0].egress_policies]` so
        they don't fight over which egress rules should be in the policy.

        To get more information about ServicePerimeterEgressPolicy, see:

        * [API documentation](https://cloud.google.com/access-context-manager/docs/reference/rest/v1/accessPolicies.servicePerimeters#egresspolicy)
        * How-to Guides
            * [Guide to Ingress and Egress Rules](https://cloud.google.com/vpc-service-controls/docs/ingress-egress-rules)

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ServicePerimeterEgressPolicyEgressFromArgs', 'ServicePerimeterEgressPolicyEgressFromArgsDict']] egress_from: Defines conditions on the source of a request causing this `EgressPolicy` to apply.
               Structure is documented below.
        :param pulumi.Input[Union['ServicePerimeterEgressPolicyEgressToArgs', 'ServicePerimeterEgressPolicyEgressToArgsDict']] egress_to: Defines the conditions on the `ApiOperation` and destination resources that
               cause this `EgressPolicy` to apply.
               Structure is documented below.
        :param pulumi.Input[builtins.str] perimeter: The name of the Service Perimeter to add this resource to.
        :param pulumi.Input[builtins.str] title: Human readable title. Must be unique within the perimeter. Does not affect behavior.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServicePerimeterEgressPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manage a single EgressPolicy in the status (enforced) configuration for a service perimeter.
        EgressPolicies match requests based on egressFrom and egressTo stanzas.
        For an EgressPolicy to match, both egressFrom and egressTo stanzas must be matched.
        If an EgressPolicy matches a request, the request is allowed to span the ServicePerimeter
        boundary. For example, an EgressPolicy can be used to allow VMs on networks
        within the ServicePerimeter to access a defined set of projects outside the
        perimeter in certain contexts (e.g. to read data from a Cloud Storage bucket
        or query against a BigQuery dataset).

        > **Note:** By default, updates to this resource will remove the EgressPolicy from the
        from the perimeter and add it back in a non-atomic manner. To ensure that the new EgressPolicy
        is added before the old one is removed, add a `lifecycle` block with `create_before_destroy = true` to this resource.
        **Note:** If this resource is used alongside a `accesscontextmanager.ServicePerimeter` resource,
        the service perimeter resource must have a `lifecycle` block with `ignore_changes = [status[0].egress_policies]` so
        they don't fight over which egress rules should be in the policy.

        To get more information about ServicePerimeterEgressPolicy, see:

        * [API documentation](https://cloud.google.com/access-context-manager/docs/reference/rest/v1/accessPolicies.servicePerimeters#egresspolicy)
        * How-to Guides
            * [Guide to Ingress and Egress Rules](https://cloud.google.com/vpc-service-controls/docs/ingress-egress-rules)

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param ServicePerimeterEgressPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServicePerimeterEgressPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 egress_from: Optional[pulumi.Input[Union['ServicePerimeterEgressPolicyEgressFromArgs', 'ServicePerimeterEgressPolicyEgressFromArgsDict']]] = None,
                 egress_to: Optional[pulumi.Input[Union['ServicePerimeterEgressPolicyEgressToArgs', 'ServicePerimeterEgressPolicyEgressToArgsDict']]] = None,
                 perimeter: Optional[pulumi.Input[builtins.str]] = None,
                 title: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServicePerimeterEgressPolicyArgs.__new__(ServicePerimeterEgressPolicyArgs)

            __props__.__dict__["egress_from"] = egress_from
            __props__.__dict__["egress_to"] = egress_to
            if perimeter is None and not opts.urn:
                raise TypeError("Missing required property 'perimeter'")
            __props__.__dict__["perimeter"] = perimeter
            __props__.__dict__["title"] = title
            __props__.__dict__["access_policy_id"] = None
            __props__.__dict__["etag"] = None
        super(ServicePerimeterEgressPolicy, __self__).__init__(
            'gcp:accesscontextmanager/servicePerimeterEgressPolicy:ServicePerimeterEgressPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_policy_id: Optional[pulumi.Input[builtins.str]] = None,
            egress_from: Optional[pulumi.Input[Union['ServicePerimeterEgressPolicyEgressFromArgs', 'ServicePerimeterEgressPolicyEgressFromArgsDict']]] = None,
            egress_to: Optional[pulumi.Input[Union['ServicePerimeterEgressPolicyEgressToArgs', 'ServicePerimeterEgressPolicyEgressToArgsDict']]] = None,
            etag: Optional[pulumi.Input[builtins.str]] = None,
            perimeter: Optional[pulumi.Input[builtins.str]] = None,
            title: Optional[pulumi.Input[builtins.str]] = None) -> 'ServicePerimeterEgressPolicy':
        """
        Get an existing ServicePerimeterEgressPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] access_policy_id: The name of the Access Policy this resource belongs to.
        :param pulumi.Input[Union['ServicePerimeterEgressPolicyEgressFromArgs', 'ServicePerimeterEgressPolicyEgressFromArgsDict']] egress_from: Defines conditions on the source of a request causing this `EgressPolicy` to apply.
               Structure is documented below.
        :param pulumi.Input[Union['ServicePerimeterEgressPolicyEgressToArgs', 'ServicePerimeterEgressPolicyEgressToArgsDict']] egress_to: Defines the conditions on the `ApiOperation` and destination resources that
               cause this `EgressPolicy` to apply.
               Structure is documented below.
        :param pulumi.Input[builtins.str] etag: The perimeter etag is internally used to prevent overwriting the list of policies on PATCH calls. It is retrieved from the same GET perimeter API call that's used to get the current list of policies. The policy defined in this resource is added or removed from that list, and then this etag is sent with the PATCH call along with the updated policies.
        :param pulumi.Input[builtins.str] perimeter: The name of the Service Perimeter to add this resource to.
        :param pulumi.Input[builtins.str] title: Human readable title. Must be unique within the perimeter. Does not affect behavior.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServicePerimeterEgressPolicyState.__new__(_ServicePerimeterEgressPolicyState)

        __props__.__dict__["access_policy_id"] = access_policy_id
        __props__.__dict__["egress_from"] = egress_from
        __props__.__dict__["egress_to"] = egress_to
        __props__.__dict__["etag"] = etag
        __props__.__dict__["perimeter"] = perimeter
        __props__.__dict__["title"] = title
        return ServicePerimeterEgressPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessPolicyId")
    def access_policy_id(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Access Policy this resource belongs to.
        """
        return pulumi.get(self, "access_policy_id")

    @property
    @pulumi.getter(name="egressFrom")
    def egress_from(self) -> pulumi.Output[Optional['outputs.ServicePerimeterEgressPolicyEgressFrom']]:
        """
        Defines conditions on the source of a request causing this `EgressPolicy` to apply.
        Structure is documented below.
        """
        return pulumi.get(self, "egress_from")

    @property
    @pulumi.getter(name="egressTo")
    def egress_to(self) -> pulumi.Output[Optional['outputs.ServicePerimeterEgressPolicyEgressTo']]:
        """
        Defines the conditions on the `ApiOperation` and destination resources that
        cause this `EgressPolicy` to apply.
        Structure is documented below.
        """
        return pulumi.get(self, "egress_to")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[builtins.str]:
        """
        The perimeter etag is internally used to prevent overwriting the list of policies on PATCH calls. It is retrieved from the same GET perimeter API call that's used to get the current list of policies. The policy defined in this resource is added or removed from that list, and then this etag is sent with the PATCH call along with the updated policies.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def perimeter(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Service Perimeter to add this resource to.
        """
        return pulumi.get(self, "perimeter")

    @property
    @pulumi.getter
    def title(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Human readable title. Must be unique within the perimeter. Does not affect behavior.
        """
        return pulumi.get(self, "title")

