# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServicePerimetersArgs', 'ServicePerimeters']

@pulumi.input_type
class ServicePerimetersArgs:
    def __init__(__self__, *,
                 parent: pulumi.Input[builtins.str],
                 service_perimeters: Optional[pulumi.Input[Sequence[pulumi.Input['ServicePerimetersServicePerimeterArgs']]]] = None):
        """
        The set of arguments for constructing a ServicePerimeters resource.
        :param pulumi.Input[builtins.str] parent: The AccessPolicy this ServicePerimeter lives in.
               Format: accessPolicies/{policy_id}
        :param pulumi.Input[Sequence[pulumi.Input['ServicePerimetersServicePerimeterArgs']]] service_perimeters: The desired Service Perimeters that should replace all existing Service Perimeters in the Access Policy.
               Structure is documented below.
        """
        pulumi.set(__self__, "parent", parent)
        if service_perimeters is not None:
            pulumi.set(__self__, "service_perimeters", service_perimeters)

    @property
    @pulumi.getter
    def parent(self) -> pulumi.Input[builtins.str]:
        """
        The AccessPolicy this ServicePerimeter lives in.
        Format: accessPolicies/{policy_id}
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "parent", value)

    @property
    @pulumi.getter(name="servicePerimeters")
    def service_perimeters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServicePerimetersServicePerimeterArgs']]]]:
        """
        The desired Service Perimeters that should replace all existing Service Perimeters in the Access Policy.
        Structure is documented below.
        """
        return pulumi.get(self, "service_perimeters")

    @service_perimeters.setter
    def service_perimeters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServicePerimetersServicePerimeterArgs']]]]):
        pulumi.set(self, "service_perimeters", value)


@pulumi.input_type
class _ServicePerimetersState:
    def __init__(__self__, *,
                 parent: Optional[pulumi.Input[builtins.str]] = None,
                 service_perimeters: Optional[pulumi.Input[Sequence[pulumi.Input['ServicePerimetersServicePerimeterArgs']]]] = None):
        """
        Input properties used for looking up and filtering ServicePerimeters resources.
        :param pulumi.Input[builtins.str] parent: The AccessPolicy this ServicePerimeter lives in.
               Format: accessPolicies/{policy_id}
        :param pulumi.Input[Sequence[pulumi.Input['ServicePerimetersServicePerimeterArgs']]] service_perimeters: The desired Service Perimeters that should replace all existing Service Perimeters in the Access Policy.
               Structure is documented below.
        """
        if parent is not None:
            pulumi.set(__self__, "parent", parent)
        if service_perimeters is not None:
            pulumi.set(__self__, "service_perimeters", service_perimeters)

    @property
    @pulumi.getter
    def parent(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The AccessPolicy this ServicePerimeter lives in.
        Format: accessPolicies/{policy_id}
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "parent", value)

    @property
    @pulumi.getter(name="servicePerimeters")
    def service_perimeters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServicePerimetersServicePerimeterArgs']]]]:
        """
        The desired Service Perimeters that should replace all existing Service Perimeters in the Access Policy.
        Structure is documented below.
        """
        return pulumi.get(self, "service_perimeters")

    @service_perimeters.setter
    def service_perimeters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServicePerimetersServicePerimeterArgs']]]]):
        pulumi.set(self, "service_perimeters", value)


@pulumi.type_token("gcp:accesscontextmanager/servicePerimeters:ServicePerimeters")
class ServicePerimeters(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 parent: Optional[pulumi.Input[builtins.str]] = None,
                 service_perimeters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServicePerimetersServicePerimeterArgs', 'ServicePerimetersServicePerimeterArgsDict']]]]] = None,
                 __props__=None):
        """
        Replace all existing Service Perimeters in an Access Policy with the Service Perimeters provided. This is done atomically.
        This is a bulk edit of all Service Perimeters and may override existing Service Perimeters created by `accesscontextmanager.ServicePerimeter`,
        thus causing a permadiff if used alongside `accesscontextmanager.ServicePerimeter` on the same parent.

        To get more information about ServicePerimeters, see:

        * [API documentation](https://cloud.google.com/access-context-manager/docs/reference/rest/v1/accessPolicies.servicePerimeters)
        * How-to Guides
            * [Guide to Ingress and Egress Rules](https://cloud.google.com/vpc-service-controls/docs/ingress-egress-rules)
            * [Service Perimeter Quickstart](https://cloud.google.com/vpc-service-controls/docs/quickstart)

        ## Example Usage

        ### Access Context Manager Service Perimeters Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        access_policy = gcp.accesscontextmanager.AccessPolicy("access-policy",
            parent="organizations/123456789",
            title="my policy")
        service_perimeter = gcp.accesscontextmanager.ServicePerimeters("service-perimeter",
            parent=access_policy.name.apply(lambda name: f"accessPolicies/{name}"),
            service_perimeters=[
                {
                    "name": access_policy.name.apply(lambda name: f"accessPolicies/{name}/servicePerimeters/"),
                    "title": "",
                    "status": {
                        "restricted_services": ["storage.googleapis.com"],
                    },
                },
                {
                    "name": access_policy.name.apply(lambda name: f"accessPolicies/{name}/servicePerimeters/"),
                    "title": "",
                    "status": {
                        "restricted_services": ["bigtable.googleapis.com"],
                    },
                },
            ])
        access_level = gcp.accesscontextmanager.AccessLevel("access-level",
            parent=access_policy.name.apply(lambda name: f"accessPolicies/{name}"),
            name=access_policy.name.apply(lambda name: f"accessPolicies/{name}/accessLevels/chromeos_no_lock"),
            title="chromeos_no_lock",
            basic={
                "conditions": [{
                    "device_policy": {
                        "require_screen_lock": False,
                        "os_constraints": [{
                            "os_type": "DESKTOP_CHROME_OS",
                        }],
                    },
                    "regions": [
                        "CH",
                        "IT",
                        "US",
                    ],
                }],
            })
        ```

        ## Import

        ServicePerimeters can be imported using any of these accepted formats:

        * `{{parent}}/servicePerimeters`

        * `{{parent}}`

        When using the `pulumi import` command, ServicePerimeters can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:accesscontextmanager/servicePerimeters:ServicePerimeters default {{parent}}/servicePerimeters
        ```

        ```sh
        $ pulumi import gcp:accesscontextmanager/servicePerimeters:ServicePerimeters default {{parent}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] parent: The AccessPolicy this ServicePerimeter lives in.
               Format: accessPolicies/{policy_id}
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServicePerimetersServicePerimeterArgs', 'ServicePerimetersServicePerimeterArgsDict']]]] service_perimeters: The desired Service Perimeters that should replace all existing Service Perimeters in the Access Policy.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServicePerimetersArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Replace all existing Service Perimeters in an Access Policy with the Service Perimeters provided. This is done atomically.
        This is a bulk edit of all Service Perimeters and may override existing Service Perimeters created by `accesscontextmanager.ServicePerimeter`,
        thus causing a permadiff if used alongside `accesscontextmanager.ServicePerimeter` on the same parent.

        To get more information about ServicePerimeters, see:

        * [API documentation](https://cloud.google.com/access-context-manager/docs/reference/rest/v1/accessPolicies.servicePerimeters)
        * How-to Guides
            * [Guide to Ingress and Egress Rules](https://cloud.google.com/vpc-service-controls/docs/ingress-egress-rules)
            * [Service Perimeter Quickstart](https://cloud.google.com/vpc-service-controls/docs/quickstart)

        ## Example Usage

        ### Access Context Manager Service Perimeters Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        access_policy = gcp.accesscontextmanager.AccessPolicy("access-policy",
            parent="organizations/123456789",
            title="my policy")
        service_perimeter = gcp.accesscontextmanager.ServicePerimeters("service-perimeter",
            parent=access_policy.name.apply(lambda name: f"accessPolicies/{name}"),
            service_perimeters=[
                {
                    "name": access_policy.name.apply(lambda name: f"accessPolicies/{name}/servicePerimeters/"),
                    "title": "",
                    "status": {
                        "restricted_services": ["storage.googleapis.com"],
                    },
                },
                {
                    "name": access_policy.name.apply(lambda name: f"accessPolicies/{name}/servicePerimeters/"),
                    "title": "",
                    "status": {
                        "restricted_services": ["bigtable.googleapis.com"],
                    },
                },
            ])
        access_level = gcp.accesscontextmanager.AccessLevel("access-level",
            parent=access_policy.name.apply(lambda name: f"accessPolicies/{name}"),
            name=access_policy.name.apply(lambda name: f"accessPolicies/{name}/accessLevels/chromeos_no_lock"),
            title="chromeos_no_lock",
            basic={
                "conditions": [{
                    "device_policy": {
                        "require_screen_lock": False,
                        "os_constraints": [{
                            "os_type": "DESKTOP_CHROME_OS",
                        }],
                    },
                    "regions": [
                        "CH",
                        "IT",
                        "US",
                    ],
                }],
            })
        ```

        ## Import

        ServicePerimeters can be imported using any of these accepted formats:

        * `{{parent}}/servicePerimeters`

        * `{{parent}}`

        When using the `pulumi import` command, ServicePerimeters can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:accesscontextmanager/servicePerimeters:ServicePerimeters default {{parent}}/servicePerimeters
        ```

        ```sh
        $ pulumi import gcp:accesscontextmanager/servicePerimeters:ServicePerimeters default {{parent}}
        ```

        :param str resource_name: The name of the resource.
        :param ServicePerimetersArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServicePerimetersArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 parent: Optional[pulumi.Input[builtins.str]] = None,
                 service_perimeters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServicePerimetersServicePerimeterArgs', 'ServicePerimetersServicePerimeterArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServicePerimetersArgs.__new__(ServicePerimetersArgs)

            if parent is None and not opts.urn:
                raise TypeError("Missing required property 'parent'")
            __props__.__dict__["parent"] = parent
            __props__.__dict__["service_perimeters"] = service_perimeters
        super(ServicePerimeters, __self__).__init__(
            'gcp:accesscontextmanager/servicePerimeters:ServicePerimeters',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            parent: Optional[pulumi.Input[builtins.str]] = None,
            service_perimeters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServicePerimetersServicePerimeterArgs', 'ServicePerimetersServicePerimeterArgsDict']]]]] = None) -> 'ServicePerimeters':
        """
        Get an existing ServicePerimeters resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] parent: The AccessPolicy this ServicePerimeter lives in.
               Format: accessPolicies/{policy_id}
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServicePerimetersServicePerimeterArgs', 'ServicePerimetersServicePerimeterArgsDict']]]] service_perimeters: The desired Service Perimeters that should replace all existing Service Perimeters in the Access Policy.
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServicePerimetersState.__new__(_ServicePerimetersState)

        __props__.__dict__["parent"] = parent
        __props__.__dict__["service_perimeters"] = service_perimeters
        return ServicePerimeters(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def parent(self) -> pulumi.Output[builtins.str]:
        """
        The AccessPolicy this ServicePerimeter lives in.
        Format: accessPolicies/{policy_id}
        """
        return pulumi.get(self, "parent")

    @property
    @pulumi.getter(name="servicePerimeters")
    def service_perimeters(self) -> pulumi.Output[Optional[Sequence['outputs.ServicePerimetersServicePerimeter']]]:
        """
        The desired Service Perimeters that should replace all existing Service Perimeters in the Access Policy.
        Structure is documented below.
        """
        return pulumi.get(self, "service_perimeters")

