# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DeveloperArgs', 'Developer']

@pulumi.input_type
class DeveloperArgs:
    def __init__(__self__, *,
                 email: pulumi.Input[builtins.str],
                 first_name: pulumi.Input[builtins.str],
                 last_name: pulumi.Input[builtins.str],
                 org_id: pulumi.Input[builtins.str],
                 user_name: pulumi.Input[builtins.str],
                 attributes: Optional[pulumi.Input[Sequence[pulumi.Input['DeveloperAttributeArgs']]]] = None):
        """
        The set of arguments for constructing a Developer resource.
        :param pulumi.Input[builtins.str] email: Email address of the developer. This value is used to uniquely identify the developer in Apigee hybrid. Note that the email address has to be in lowercase only..
        :param pulumi.Input[builtins.str] first_name: First name of the developer.
        :param pulumi.Input[builtins.str] last_name: Last name of the developer.
        :param pulumi.Input[builtins.str] org_id: The Apigee Organization associated with the Apigee instance,
               in the format `organizations/{{org_name}}`.
        :param pulumi.Input[builtins.str] user_name: User name of the developer. Not used by Apigee hybrid.
        :param pulumi.Input[Sequence[pulumi.Input['DeveloperAttributeArgs']]] attributes: Developer attributes (name/value pairs). The custom attribute limit is 18.
               Structure is documented below.
        """
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "first_name", first_name)
        pulumi.set(__self__, "last_name", last_name)
        pulumi.set(__self__, "org_id", org_id)
        pulumi.set(__self__, "user_name", user_name)
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)

    @property
    @pulumi.getter
    def email(self) -> pulumi.Input[builtins.str]:
        """
        Email address of the developer. This value is used to uniquely identify the developer in Apigee hybrid. Note that the email address has to be in lowercase only..
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> pulumi.Input[builtins.str]:
        """
        First name of the developer.
        """
        return pulumi.get(self, "first_name")

    @first_name.setter
    def first_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "first_name", value)

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> pulumi.Input[builtins.str]:
        """
        Last name of the developer.
        """
        return pulumi.get(self, "last_name")

    @last_name.setter
    def last_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "last_name", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Input[builtins.str]:
        """
        The Apigee Organization associated with the Apigee instance,
        in the format `organizations/{{org_name}}`.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Input[builtins.str]:
        """
        User name of the developer. Not used by Apigee hybrid.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "user_name", value)

    @property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeveloperAttributeArgs']]]]:
        """
        Developer attributes (name/value pairs). The custom attribute limit is 18.
        Structure is documented below.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeveloperAttributeArgs']]]]):
        pulumi.set(self, "attributes", value)


@pulumi.input_type
class _DeveloperState:
    def __init__(__self__, *,
                 attributes: Optional[pulumi.Input[Sequence[pulumi.Input['DeveloperAttributeArgs']]]] = None,
                 created_at: Optional[pulumi.Input[builtins.str]] = None,
                 email: Optional[pulumi.Input[builtins.str]] = None,
                 first_name: Optional[pulumi.Input[builtins.str]] = None,
                 last_modified_at: Optional[pulumi.Input[builtins.str]] = None,
                 last_name: Optional[pulumi.Input[builtins.str]] = None,
                 org_id: Optional[pulumi.Input[builtins.str]] = None,
                 organizatio_name: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 user_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Developer resources.
        :param pulumi.Input[Sequence[pulumi.Input['DeveloperAttributeArgs']]] attributes: Developer attributes (name/value pairs). The custom attribute limit is 18.
               Structure is documented below.
        :param pulumi.Input[builtins.str] created_at: Time at which the developer was created in milliseconds since epoch.
        :param pulumi.Input[builtins.str] email: Email address of the developer. This value is used to uniquely identify the developer in Apigee hybrid. Note that the email address has to be in lowercase only..
        :param pulumi.Input[builtins.str] first_name: First name of the developer.
        :param pulumi.Input[builtins.str] last_modified_at: Time at which the developer was last modified in milliseconds since epoch.
        :param pulumi.Input[builtins.str] last_name: Last name of the developer.
        :param pulumi.Input[builtins.str] org_id: The Apigee Organization associated with the Apigee instance,
               in the format `organizations/{{org_name}}`.
        :param pulumi.Input[builtins.str] organizatio_name: Name of the Apigee organization in which the developer resides.
        :param pulumi.Input[builtins.str] status: Status of the developer. Valid values are active and inactive.
        :param pulumi.Input[builtins.str] user_name: User name of the developer. Not used by Apigee hybrid.
        """
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if first_name is not None:
            pulumi.set(__self__, "first_name", first_name)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_name is not None:
            pulumi.set(__self__, "last_name", last_name)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if organizatio_name is not None:
            pulumi.set(__self__, "organizatio_name", organizatio_name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeveloperAttributeArgs']]]]:
        """
        Developer attributes (name/value pairs). The custom attribute limit is 18.
        Structure is documented below.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeveloperAttributeArgs']]]]):
        pulumi.set(self, "attributes", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Time at which the developer was created in milliseconds since epoch.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Email address of the developer. This value is used to uniquely identify the developer in Apigee hybrid. Note that the email address has to be in lowercase only..
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        First name of the developer.
        """
        return pulumi.get(self, "first_name")

    @first_name.setter
    def first_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "first_name", value)

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Time at which the developer was last modified in milliseconds since epoch.
        """
        return pulumi.get(self, "last_modified_at")

    @last_modified_at.setter
    def last_modified_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "last_modified_at", value)

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Last name of the developer.
        """
        return pulumi.get(self, "last_name")

    @last_name.setter
    def last_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "last_name", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Apigee Organization associated with the Apigee instance,
        in the format `organizations/{{org_name}}`.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter(name="organizatioName")
    def organizatio_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the Apigee organization in which the developer resides.
        """
        return pulumi.get(self, "organizatio_name")

    @organizatio_name.setter
    def organizatio_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "organizatio_name", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Status of the developer. Valid values are active and inactive.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User name of the developer. Not used by Apigee hybrid.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user_name", value)


@pulumi.type_token("gcp:apigee/developer:Developer")
class Developer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DeveloperAttributeArgs', 'DeveloperAttributeArgsDict']]]]] = None,
                 email: Optional[pulumi.Input[builtins.str]] = None,
                 first_name: Optional[pulumi.Input[builtins.str]] = None,
                 last_name: Optional[pulumi.Input[builtins.str]] = None,
                 org_id: Optional[pulumi.Input[builtins.str]] = None,
                 user_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        A `Developer` is an API consumer that can have apps registered in Apigee.

        To get more information about Developer, see:

        * [API documentation](https://cloud.google.com/apigee/docs/reference/apis/apigee/rest/v1/organizations.developers)
        * How-to Guides
            * [Creating a developer](https://cloud.google.com/apigee/docs/api-platform/publish/adding-developers-your-api-product)

        ## Example Usage

        ### Apigee Developer Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        current = gcp.organizations.get_client_config()
        apigee_network = gcp.compute.Network("apigee_network", name="apigee-network")
        apigee_range = gcp.compute.GlobalAddress("apigee_range",
            name="apigee-range",
            purpose="VPC_PEERING",
            address_type="INTERNAL",
            prefix_length=16,
            network=apigee_network.id)
        apigee_vpc_connection = gcp.servicenetworking.Connection("apigee_vpc_connection",
            network=apigee_network.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[apigee_range.name])
        apigee_org = gcp.apigee.Organization("apigee_org",
            analytics_region="us-central1",
            project_id=current.project,
            authorized_network=apigee_network.id,
            opts = pulumi.ResourceOptions(depends_on=[apigee_vpc_connection]))
        apigee_instance = gcp.apigee.Instance("apigee_instance",
            name="my-instance",
            location="us-central1",
            org_id=apigee_org.id,
            peering_cidr_range="SLASH_22")
        apigee_developer = gcp.apigee.Developer("apigee_developer",
            email="john.doe@acme.com",
            first_name="John",
            last_name="Doe",
            user_name="john.doe",
            org_id=apigee_org.id,
            opts = pulumi.ResourceOptions(depends_on=[apigee_instance]))
        ```
        ### Apigee Developer With Attributes

        ```python
        import pulumi
        import pulumi_gcp as gcp

        current = gcp.organizations.get_client_config()
        apigee_network = gcp.compute.Network("apigee_network", name="apigee-network")
        apigee_range = gcp.compute.GlobalAddress("apigee_range",
            name="apigee-range",
            purpose="VPC_PEERING",
            address_type="INTERNAL",
            prefix_length=16,
            network=apigee_network.id)
        apigee_vpc_connection = gcp.servicenetworking.Connection("apigee_vpc_connection",
            network=apigee_network.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[apigee_range.name])
        apigee_org = gcp.apigee.Organization("apigee_org",
            analytics_region="us-central1",
            project_id=current.project,
            authorized_network=apigee_network.id,
            opts = pulumi.ResourceOptions(depends_on=[apigee_vpc_connection]))
        apigee_instance = gcp.apigee.Instance("apigee_instance",
            name="my-instance",
            location="us-central1",
            org_id=apigee_org.id,
            peering_cidr_range="SLASH_22")
        apigee_developer = gcp.apigee.Developer("apigee_developer",
            email="john.doe@acme.com",
            first_name="John",
            last_name="Doe",
            user_name="john.doe",
            attributes=[
                {
                    "name": "business_unit",
                    "value": "HR",
                },
                {
                    "name": "department",
                    "value": "payroll",
                },
            ],
            org_id=apigee_org.id,
            opts = pulumi.ResourceOptions(depends_on=[apigee_instance]))
        ```

        ## Import

        Developer can be imported using any of these accepted formats:

        * `{{org_id}}/developers/{{email}}`

        * `{{org_id}}/{{email}}`

        When using the `pulumi import` command, Developer can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:apigee/developer:Developer default {{org_id}}/developers/{{email}}
        ```

        ```sh
        $ pulumi import gcp:apigee/developer:Developer default {{org_id}}/{{email}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DeveloperAttributeArgs', 'DeveloperAttributeArgsDict']]]] attributes: Developer attributes (name/value pairs). The custom attribute limit is 18.
               Structure is documented below.
        :param pulumi.Input[builtins.str] email: Email address of the developer. This value is used to uniquely identify the developer in Apigee hybrid. Note that the email address has to be in lowercase only..
        :param pulumi.Input[builtins.str] first_name: First name of the developer.
        :param pulumi.Input[builtins.str] last_name: Last name of the developer.
        :param pulumi.Input[builtins.str] org_id: The Apigee Organization associated with the Apigee instance,
               in the format `organizations/{{org_name}}`.
        :param pulumi.Input[builtins.str] user_name: User name of the developer. Not used by Apigee hybrid.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DeveloperArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A `Developer` is an API consumer that can have apps registered in Apigee.

        To get more information about Developer, see:

        * [API documentation](https://cloud.google.com/apigee/docs/reference/apis/apigee/rest/v1/organizations.developers)
        * How-to Guides
            * [Creating a developer](https://cloud.google.com/apigee/docs/api-platform/publish/adding-developers-your-api-product)

        ## Example Usage

        ### Apigee Developer Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        current = gcp.organizations.get_client_config()
        apigee_network = gcp.compute.Network("apigee_network", name="apigee-network")
        apigee_range = gcp.compute.GlobalAddress("apigee_range",
            name="apigee-range",
            purpose="VPC_PEERING",
            address_type="INTERNAL",
            prefix_length=16,
            network=apigee_network.id)
        apigee_vpc_connection = gcp.servicenetworking.Connection("apigee_vpc_connection",
            network=apigee_network.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[apigee_range.name])
        apigee_org = gcp.apigee.Organization("apigee_org",
            analytics_region="us-central1",
            project_id=current.project,
            authorized_network=apigee_network.id,
            opts = pulumi.ResourceOptions(depends_on=[apigee_vpc_connection]))
        apigee_instance = gcp.apigee.Instance("apigee_instance",
            name="my-instance",
            location="us-central1",
            org_id=apigee_org.id,
            peering_cidr_range="SLASH_22")
        apigee_developer = gcp.apigee.Developer("apigee_developer",
            email="john.doe@acme.com",
            first_name="John",
            last_name="Doe",
            user_name="john.doe",
            org_id=apigee_org.id,
            opts = pulumi.ResourceOptions(depends_on=[apigee_instance]))
        ```
        ### Apigee Developer With Attributes

        ```python
        import pulumi
        import pulumi_gcp as gcp

        current = gcp.organizations.get_client_config()
        apigee_network = gcp.compute.Network("apigee_network", name="apigee-network")
        apigee_range = gcp.compute.GlobalAddress("apigee_range",
            name="apigee-range",
            purpose="VPC_PEERING",
            address_type="INTERNAL",
            prefix_length=16,
            network=apigee_network.id)
        apigee_vpc_connection = gcp.servicenetworking.Connection("apigee_vpc_connection",
            network=apigee_network.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[apigee_range.name])
        apigee_org = gcp.apigee.Organization("apigee_org",
            analytics_region="us-central1",
            project_id=current.project,
            authorized_network=apigee_network.id,
            opts = pulumi.ResourceOptions(depends_on=[apigee_vpc_connection]))
        apigee_instance = gcp.apigee.Instance("apigee_instance",
            name="my-instance",
            location="us-central1",
            org_id=apigee_org.id,
            peering_cidr_range="SLASH_22")
        apigee_developer = gcp.apigee.Developer("apigee_developer",
            email="john.doe@acme.com",
            first_name="John",
            last_name="Doe",
            user_name="john.doe",
            attributes=[
                {
                    "name": "business_unit",
                    "value": "HR",
                },
                {
                    "name": "department",
                    "value": "payroll",
                },
            ],
            org_id=apigee_org.id,
            opts = pulumi.ResourceOptions(depends_on=[apigee_instance]))
        ```

        ## Import

        Developer can be imported using any of these accepted formats:

        * `{{org_id}}/developers/{{email}}`

        * `{{org_id}}/{{email}}`

        When using the `pulumi import` command, Developer can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:apigee/developer:Developer default {{org_id}}/developers/{{email}}
        ```

        ```sh
        $ pulumi import gcp:apigee/developer:Developer default {{org_id}}/{{email}}
        ```

        :param str resource_name: The name of the resource.
        :param DeveloperArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DeveloperArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DeveloperAttributeArgs', 'DeveloperAttributeArgsDict']]]]] = None,
                 email: Optional[pulumi.Input[builtins.str]] = None,
                 first_name: Optional[pulumi.Input[builtins.str]] = None,
                 last_name: Optional[pulumi.Input[builtins.str]] = None,
                 org_id: Optional[pulumi.Input[builtins.str]] = None,
                 user_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DeveloperArgs.__new__(DeveloperArgs)

            __props__.__dict__["attributes"] = attributes
            if email is None and not opts.urn:
                raise TypeError("Missing required property 'email'")
            __props__.__dict__["email"] = email
            if first_name is None and not opts.urn:
                raise TypeError("Missing required property 'first_name'")
            __props__.__dict__["first_name"] = first_name
            if last_name is None and not opts.urn:
                raise TypeError("Missing required property 'last_name'")
            __props__.__dict__["last_name"] = last_name
            if org_id is None and not opts.urn:
                raise TypeError("Missing required property 'org_id'")
            __props__.__dict__["org_id"] = org_id
            if user_name is None and not opts.urn:
                raise TypeError("Missing required property 'user_name'")
            __props__.__dict__["user_name"] = user_name
            __props__.__dict__["created_at"] = None
            __props__.__dict__["last_modified_at"] = None
            __props__.__dict__["organizatio_name"] = None
            __props__.__dict__["status"] = None
        super(Developer, __self__).__init__(
            'gcp:apigee/developer:Developer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            attributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DeveloperAttributeArgs', 'DeveloperAttributeArgsDict']]]]] = None,
            created_at: Optional[pulumi.Input[builtins.str]] = None,
            email: Optional[pulumi.Input[builtins.str]] = None,
            first_name: Optional[pulumi.Input[builtins.str]] = None,
            last_modified_at: Optional[pulumi.Input[builtins.str]] = None,
            last_name: Optional[pulumi.Input[builtins.str]] = None,
            org_id: Optional[pulumi.Input[builtins.str]] = None,
            organizatio_name: Optional[pulumi.Input[builtins.str]] = None,
            status: Optional[pulumi.Input[builtins.str]] = None,
            user_name: Optional[pulumi.Input[builtins.str]] = None) -> 'Developer':
        """
        Get an existing Developer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DeveloperAttributeArgs', 'DeveloperAttributeArgsDict']]]] attributes: Developer attributes (name/value pairs). The custom attribute limit is 18.
               Structure is documented below.
        :param pulumi.Input[builtins.str] created_at: Time at which the developer was created in milliseconds since epoch.
        :param pulumi.Input[builtins.str] email: Email address of the developer. This value is used to uniquely identify the developer in Apigee hybrid. Note that the email address has to be in lowercase only..
        :param pulumi.Input[builtins.str] first_name: First name of the developer.
        :param pulumi.Input[builtins.str] last_modified_at: Time at which the developer was last modified in milliseconds since epoch.
        :param pulumi.Input[builtins.str] last_name: Last name of the developer.
        :param pulumi.Input[builtins.str] org_id: The Apigee Organization associated with the Apigee instance,
               in the format `organizations/{{org_name}}`.
        :param pulumi.Input[builtins.str] organizatio_name: Name of the Apigee organization in which the developer resides.
        :param pulumi.Input[builtins.str] status: Status of the developer. Valid values are active and inactive.
        :param pulumi.Input[builtins.str] user_name: User name of the developer. Not used by Apigee hybrid.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DeveloperState.__new__(_DeveloperState)

        __props__.__dict__["attributes"] = attributes
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["email"] = email
        __props__.__dict__["first_name"] = first_name
        __props__.__dict__["last_modified_at"] = last_modified_at
        __props__.__dict__["last_name"] = last_name
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["organizatio_name"] = organizatio_name
        __props__.__dict__["status"] = status
        __props__.__dict__["user_name"] = user_name
        return Developer(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def attributes(self) -> pulumi.Output[Optional[Sequence['outputs.DeveloperAttribute']]]:
        """
        Developer attributes (name/value pairs). The custom attribute limit is 18.
        Structure is documented below.
        """
        return pulumi.get(self, "attributes")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.str]:
        """
        Time at which the developer was created in milliseconds since epoch.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def email(self) -> pulumi.Output[builtins.str]:
        """
        Email address of the developer. This value is used to uniquely identify the developer in Apigee hybrid. Note that the email address has to be in lowercase only..
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> pulumi.Output[builtins.str]:
        """
        First name of the developer.
        """
        return pulumi.get(self, "first_name")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> pulumi.Output[builtins.str]:
        """
        Time at which the developer was last modified in milliseconds since epoch.
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> pulumi.Output[builtins.str]:
        """
        Last name of the developer.
        """
        return pulumi.get(self, "last_name")

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[builtins.str]:
        """
        The Apigee Organization associated with the Apigee instance,
        in the format `organizations/{{org_name}}`.
        """
        return pulumi.get(self, "org_id")

    @property
    @pulumi.getter(name="organizatioName")
    def organizatio_name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the Apigee organization in which the developer resides.
        """
        return pulumi.get(self, "organizatio_name")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[builtins.str]:
        """
        Status of the developer. Valid values are active and inactive.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Output[builtins.str]:
        """
        User name of the developer. Not used by Apigee hybrid.
        """
        return pulumi.get(self, "user_name")

