# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['EnvironmentKeyvaluemapsEntriesArgs', 'EnvironmentKeyvaluemapsEntries']

@pulumi.input_type
class EnvironmentKeyvaluemapsEntriesArgs:
    def __init__(__self__, *,
                 env_keyvaluemap_id: pulumi.Input[builtins.str],
                 value: pulumi.Input[builtins.str],
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a EnvironmentKeyvaluemapsEntries resource.
        :param pulumi.Input[builtins.str] env_keyvaluemap_id: The Apigee environment keyvalumaps Id associated with the Apigee environment,
               in the format `organizations/{{org_name}}/environments/{{env_name}}/keyvaluemaps/{{keyvaluemap_name}}`.
        :param pulumi.Input[builtins.str] value: Required. Data or payload that is being retrieved and associated with the unique key.
        :param pulumi.Input[builtins.str] name: Required. Resource URI that can be used to identify the scope of the key value map entries.
        """
        pulumi.set(__self__, "env_keyvaluemap_id", env_keyvaluemap_id)
        pulumi.set(__self__, "value", value)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="envKeyvaluemapId")
    def env_keyvaluemap_id(self) -> pulumi.Input[builtins.str]:
        """
        The Apigee environment keyvalumaps Id associated with the Apigee environment,
        in the format `organizations/{{org_name}}/environments/{{env_name}}/keyvaluemaps/{{keyvaluemap_name}}`.
        """
        return pulumi.get(self, "env_keyvaluemap_id")

    @env_keyvaluemap_id.setter
    def env_keyvaluemap_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "env_keyvaluemap_id", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[builtins.str]:
        """
        Required. Data or payload that is being retrieved and associated with the unique key.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Required. Resource URI that can be used to identify the scope of the key value map entries.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _EnvironmentKeyvaluemapsEntriesState:
    def __init__(__self__, *,
                 env_keyvaluemap_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 value: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering EnvironmentKeyvaluemapsEntries resources.
        :param pulumi.Input[builtins.str] env_keyvaluemap_id: The Apigee environment keyvalumaps Id associated with the Apigee environment,
               in the format `organizations/{{org_name}}/environments/{{env_name}}/keyvaluemaps/{{keyvaluemap_name}}`.
        :param pulumi.Input[builtins.str] name: Required. Resource URI that can be used to identify the scope of the key value map entries.
        :param pulumi.Input[builtins.str] value: Required. Data or payload that is being retrieved and associated with the unique key.
        """
        if env_keyvaluemap_id is not None:
            pulumi.set(__self__, "env_keyvaluemap_id", env_keyvaluemap_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="envKeyvaluemapId")
    def env_keyvaluemap_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Apigee environment keyvalumaps Id associated with the Apigee environment,
        in the format `organizations/{{org_name}}/environments/{{env_name}}/keyvaluemaps/{{keyvaluemap_name}}`.
        """
        return pulumi.get(self, "env_keyvaluemap_id")

    @env_keyvaluemap_id.setter
    def env_keyvaluemap_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "env_keyvaluemap_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Required. Resource URI that can be used to identify the scope of the key value map entries.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Required. Data or payload that is being retrieved and associated with the unique key.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "value", value)


@pulumi.type_token("gcp:apigee/environmentKeyvaluemapsEntries:EnvironmentKeyvaluemapsEntries")
class EnvironmentKeyvaluemapsEntries(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 env_keyvaluemap_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 value: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Creates key value entries in a key value map scoped to an environment.

        To get more information about EnvironmentKeyvaluemapsEntries, see:

        * [API documentation](https://cloud.google.com/apigee/docs/reference/apis/apigee/rest/v1/organizations.keyvaluemaps.entries/create)
        * How-to Guides
            * [Using key value maps](https://cloud.google.com/apigee/docs/api-platform/cache/key-value-maps)

        ## Example Usage

        ### Apigee Environment Keyvaluemaps Entries Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        current = gcp.organizations.get_client_config()
        apigee_network = gcp.compute.Network("apigee_network", name="apigee-network")
        apigee_range = gcp.compute.GlobalAddress("apigee_range",
            name="apigee-range",
            purpose="VPC_PEERING",
            address_type="INTERNAL",
            prefix_length=16,
            network=apigee_network.id)
        apigee_vpc_connection = gcp.servicenetworking.Connection("apigee_vpc_connection",
            network=apigee_network.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[apigee_range.name])
        apigee_org = gcp.apigee.Organization("apigee_org",
            analytics_region="us-central1",
            project_id=current.project,
            authorized_network=apigee_network.id,
            opts = pulumi.ResourceOptions(depends_on=[apigee_vpc_connection]))
        apigee_environment = gcp.apigee.Environment("apigee_environment",
            org_id=apigee_org.id,
            name="tf-test-env",
            description="Apigee Environment",
            display_name="Apigee Environment")
        apigee_instance = gcp.apigee.Instance("apigee_instance",
            name="tf-test-instance",
            location="us-central1",
            org_id=apigee_org.id)
        apigee_instance_attachment = gcp.apigee.InstanceAttachment("apigee_instance_attachment",
            instance_id=apigee_instance.id,
            environment=apigee_environment.name)
        apigee_environment_keyvaluemaps = gcp.apigee.EnvironmentKeyvaluemaps("apigee_environment_keyvaluemaps",
            env_id=create_apigee_environment["id"],
            name="tf-test-env-kvms",
            opts = pulumi.ResourceOptions(depends_on=[
                    apigee_org,
                    apigee_environment,
                    apigee_instance,
                    apigee_instance_attachment,
                ]))
        apigee_environment_keyvaluemaps_entries = gcp.apigee.EnvironmentKeyvaluemapsEntries("apigee_environment_keyvaluemaps_entries",
            env_keyvaluemap_id=apigee_environment_keyvaluemaps.id,
            name="testName",
            value="testValue",
            opts = pulumi.ResourceOptions(depends_on=[
                    apigee_org,
                    apigee_environment,
                    apigee_instance,
                    apigee_instance_attachment,
                    apigee_environment_keyvaluemaps,
                ]))
        ```

        ## Import

        EnvironmentKeyvaluemapsEntries can be imported using any of these accepted formats:

        * `{{env_keyvaluemap_id}}/entries/{{name}}`

        * `{{env_keyvaluemap_id}}/{{name}}`

        When using the `pulumi import` command, EnvironmentKeyvaluemapsEntries can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:apigee/environmentKeyvaluemapsEntries:EnvironmentKeyvaluemapsEntries default {{env_keyvaluemap_id}}/entries/{{name}}
        ```

        ```sh
        $ pulumi import gcp:apigee/environmentKeyvaluemapsEntries:EnvironmentKeyvaluemapsEntries default {{env_keyvaluemap_id}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] env_keyvaluemap_id: The Apigee environment keyvalumaps Id associated with the Apigee environment,
               in the format `organizations/{{org_name}}/environments/{{env_name}}/keyvaluemaps/{{keyvaluemap_name}}`.
        :param pulumi.Input[builtins.str] name: Required. Resource URI that can be used to identify the scope of the key value map entries.
        :param pulumi.Input[builtins.str] value: Required. Data or payload that is being retrieved and associated with the unique key.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EnvironmentKeyvaluemapsEntriesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates key value entries in a key value map scoped to an environment.

        To get more information about EnvironmentKeyvaluemapsEntries, see:

        * [API documentation](https://cloud.google.com/apigee/docs/reference/apis/apigee/rest/v1/organizations.keyvaluemaps.entries/create)
        * How-to Guides
            * [Using key value maps](https://cloud.google.com/apigee/docs/api-platform/cache/key-value-maps)

        ## Example Usage

        ### Apigee Environment Keyvaluemaps Entries Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        current = gcp.organizations.get_client_config()
        apigee_network = gcp.compute.Network("apigee_network", name="apigee-network")
        apigee_range = gcp.compute.GlobalAddress("apigee_range",
            name="apigee-range",
            purpose="VPC_PEERING",
            address_type="INTERNAL",
            prefix_length=16,
            network=apigee_network.id)
        apigee_vpc_connection = gcp.servicenetworking.Connection("apigee_vpc_connection",
            network=apigee_network.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[apigee_range.name])
        apigee_org = gcp.apigee.Organization("apigee_org",
            analytics_region="us-central1",
            project_id=current.project,
            authorized_network=apigee_network.id,
            opts = pulumi.ResourceOptions(depends_on=[apigee_vpc_connection]))
        apigee_environment = gcp.apigee.Environment("apigee_environment",
            org_id=apigee_org.id,
            name="tf-test-env",
            description="Apigee Environment",
            display_name="Apigee Environment")
        apigee_instance = gcp.apigee.Instance("apigee_instance",
            name="tf-test-instance",
            location="us-central1",
            org_id=apigee_org.id)
        apigee_instance_attachment = gcp.apigee.InstanceAttachment("apigee_instance_attachment",
            instance_id=apigee_instance.id,
            environment=apigee_environment.name)
        apigee_environment_keyvaluemaps = gcp.apigee.EnvironmentKeyvaluemaps("apigee_environment_keyvaluemaps",
            env_id=create_apigee_environment["id"],
            name="tf-test-env-kvms",
            opts = pulumi.ResourceOptions(depends_on=[
                    apigee_org,
                    apigee_environment,
                    apigee_instance,
                    apigee_instance_attachment,
                ]))
        apigee_environment_keyvaluemaps_entries = gcp.apigee.EnvironmentKeyvaluemapsEntries("apigee_environment_keyvaluemaps_entries",
            env_keyvaluemap_id=apigee_environment_keyvaluemaps.id,
            name="testName",
            value="testValue",
            opts = pulumi.ResourceOptions(depends_on=[
                    apigee_org,
                    apigee_environment,
                    apigee_instance,
                    apigee_instance_attachment,
                    apigee_environment_keyvaluemaps,
                ]))
        ```

        ## Import

        EnvironmentKeyvaluemapsEntries can be imported using any of these accepted formats:

        * `{{env_keyvaluemap_id}}/entries/{{name}}`

        * `{{env_keyvaluemap_id}}/{{name}}`

        When using the `pulumi import` command, EnvironmentKeyvaluemapsEntries can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:apigee/environmentKeyvaluemapsEntries:EnvironmentKeyvaluemapsEntries default {{env_keyvaluemap_id}}/entries/{{name}}
        ```

        ```sh
        $ pulumi import gcp:apigee/environmentKeyvaluemapsEntries:EnvironmentKeyvaluemapsEntries default {{env_keyvaluemap_id}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param EnvironmentKeyvaluemapsEntriesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EnvironmentKeyvaluemapsEntriesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 env_keyvaluemap_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 value: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EnvironmentKeyvaluemapsEntriesArgs.__new__(EnvironmentKeyvaluemapsEntriesArgs)

            if env_keyvaluemap_id is None and not opts.urn:
                raise TypeError("Missing required property 'env_keyvaluemap_id'")
            __props__.__dict__["env_keyvaluemap_id"] = env_keyvaluemap_id
            __props__.__dict__["name"] = name
            if value is None and not opts.urn:
                raise TypeError("Missing required property 'value'")
            __props__.__dict__["value"] = value
        super(EnvironmentKeyvaluemapsEntries, __self__).__init__(
            'gcp:apigee/environmentKeyvaluemapsEntries:EnvironmentKeyvaluemapsEntries',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            env_keyvaluemap_id: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            value: Optional[pulumi.Input[builtins.str]] = None) -> 'EnvironmentKeyvaluemapsEntries':
        """
        Get an existing EnvironmentKeyvaluemapsEntries resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] env_keyvaluemap_id: The Apigee environment keyvalumaps Id associated with the Apigee environment,
               in the format `organizations/{{org_name}}/environments/{{env_name}}/keyvaluemaps/{{keyvaluemap_name}}`.
        :param pulumi.Input[builtins.str] name: Required. Resource URI that can be used to identify the scope of the key value map entries.
        :param pulumi.Input[builtins.str] value: Required. Data or payload that is being retrieved and associated with the unique key.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EnvironmentKeyvaluemapsEntriesState.__new__(_EnvironmentKeyvaluemapsEntriesState)

        __props__.__dict__["env_keyvaluemap_id"] = env_keyvaluemap_id
        __props__.__dict__["name"] = name
        __props__.__dict__["value"] = value
        return EnvironmentKeyvaluemapsEntries(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="envKeyvaluemapId")
    def env_keyvaluemap_id(self) -> pulumi.Output[builtins.str]:
        """
        The Apigee environment keyvalumaps Id associated with the Apigee environment,
        in the format `organizations/{{org_name}}/environments/{{env_name}}/keyvaluemaps/{{keyvaluemap_name}}`.
        """
        return pulumi.get(self, "env_keyvaluemap_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Required. Resource URI that can be used to identify the scope of the key value map entries.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> pulumi.Output[builtins.str]:
        """
        Required. Data or payload that is being retrieved and associated with the unique key.
        """
        return pulumi.get(self, "value")

