# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[builtins.str],
                 org_id: pulumi.Input[builtins.str],
                 access_logging_config: Optional[pulumi.Input['InstanceAccessLoggingConfigArgs']] = None,
                 consumer_accept_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 disk_encryption_key_name: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 ip_range: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 peering_cidr_range: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[builtins.str] location: Required. Compute Engine location where the instance resides.
        :param pulumi.Input[builtins.str] org_id: The Apigee Organization associated with the Apigee instance,
               in the format `organizations/{{org_name}}`.
        :param pulumi.Input['InstanceAccessLoggingConfigArgs'] access_logging_config: Access logging configuration enables the access logging feature at the instance.
               Apigee customers can enable access logging to ship the access logs to their own project's cloud logging.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] consumer_accept_lists: Optional. Customer accept list represents the list of projects (id/number) on customer
               side that can privately connect to the service attachment. It is an optional field
               which the customers can provide during the instance creation. By default, the customer
               project associated with the Apigee organization will be included to the list.
        :param pulumi.Input[builtins.str] description: Description of the instance.
        :param pulumi.Input[builtins.str] disk_encryption_key_name: Customer Managed Encryption Key (CMEK) used for disk and volume encryption. Required for Apigee paid subscriptions only.
               Use the following format: `projects/([^/]+)/locations/([^/]+)/keyRings/([^/]+)/cryptoKeys/([^/]+)`
        :param pulumi.Input[builtins.str] display_name: Display name of the instance.
        :param pulumi.Input[builtins.str] ip_range: IP range represents the customer-provided CIDR block of length 22 that will be used for
               the Apigee instance creation. This optional range, if provided, should be freely
               available as part of larger named range the customer has allocated to the Service
               Networking peering. If this is not provided, Apigee will automatically request for any
               available /22 CIDR block from Service Networking. The customer should use this CIDR block
               for configuring their firewall needs to allow traffic from Apigee.
               Input format: "a.b.c.d/22"
        :param pulumi.Input[builtins.str] name: Resource ID of the instance.
        :param pulumi.Input[builtins.str] peering_cidr_range: The size of the CIDR block range that will be reserved by the instance. For valid values,
               see [CidrRange](https://cloud.google.com/apigee/docs/reference/apis/apigee/rest/v1/organizations.instances#CidrRange) on the documentation.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "org_id", org_id)
        if access_logging_config is not None:
            pulumi.set(__self__, "access_logging_config", access_logging_config)
        if consumer_accept_lists is not None:
            pulumi.set(__self__, "consumer_accept_lists", consumer_accept_lists)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disk_encryption_key_name is not None:
            pulumi.set(__self__, "disk_encryption_key_name", disk_encryption_key_name)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if ip_range is not None:
            pulumi.set(__self__, "ip_range", ip_range)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if peering_cidr_range is not None:
            pulumi.set(__self__, "peering_cidr_range", peering_cidr_range)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        Required. Compute Engine location where the instance resides.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Input[builtins.str]:
        """
        The Apigee Organization associated with the Apigee instance,
        in the format `organizations/{{org_name}}`.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter(name="accessLoggingConfig")
    def access_logging_config(self) -> Optional[pulumi.Input['InstanceAccessLoggingConfigArgs']]:
        """
        Access logging configuration enables the access logging feature at the instance.
        Apigee customers can enable access logging to ship the access logs to their own project's cloud logging.
        Structure is documented below.
        """
        return pulumi.get(self, "access_logging_config")

    @access_logging_config.setter
    def access_logging_config(self, value: Optional[pulumi.Input['InstanceAccessLoggingConfigArgs']]):
        pulumi.set(self, "access_logging_config", value)

    @property
    @pulumi.getter(name="consumerAcceptLists")
    def consumer_accept_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Optional. Customer accept list represents the list of projects (id/number) on customer
        side that can privately connect to the service attachment. It is an optional field
        which the customers can provide during the instance creation. By default, the customer
        project associated with the Apigee organization will be included to the list.
        """
        return pulumi.get(self, "consumer_accept_lists")

    @consumer_accept_lists.setter
    def consumer_accept_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "consumer_accept_lists", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the instance.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="diskEncryptionKeyName")
    def disk_encryption_key_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Customer Managed Encryption Key (CMEK) used for disk and volume encryption. Required for Apigee paid subscriptions only.
        Use the following format: `projects/([^/]+)/locations/([^/]+)/keyRings/([^/]+)/cryptoKeys/([^/]+)`
        """
        return pulumi.get(self, "disk_encryption_key_name")

    @disk_encryption_key_name.setter
    def disk_encryption_key_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "disk_encryption_key_name", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Display name of the instance.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IP range represents the customer-provided CIDR block of length 22 that will be used for
        the Apigee instance creation. This optional range, if provided, should be freely
        available as part of larger named range the customer has allocated to the Service
        Networking peering. If this is not provided, Apigee will automatically request for any
        available /22 CIDR block from Service Networking. The customer should use this CIDR block
        for configuring their firewall needs to allow traffic from Apigee.
        Input format: "a.b.c.d/22"
        """
        return pulumi.get(self, "ip_range")

    @ip_range.setter
    def ip_range(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip_range", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Resource ID of the instance.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="peeringCidrRange")
    def peering_cidr_range(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The size of the CIDR block range that will be reserved by the instance. For valid values,
        see [CidrRange](https://cloud.google.com/apigee/docs/reference/apis/apigee/rest/v1/organizations.instances#CidrRange) on the documentation.
        """
        return pulumi.get(self, "peering_cidr_range")

    @peering_cidr_range.setter
    def peering_cidr_range(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "peering_cidr_range", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 access_logging_config: Optional[pulumi.Input['InstanceAccessLoggingConfigArgs']] = None,
                 consumer_accept_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 disk_encryption_key_name: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 host: Optional[pulumi.Input[builtins.str]] = None,
                 ip_range: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 org_id: Optional[pulumi.Input[builtins.str]] = None,
                 peering_cidr_range: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.str]] = None,
                 service_attachment: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input['InstanceAccessLoggingConfigArgs'] access_logging_config: Access logging configuration enables the access logging feature at the instance.
               Apigee customers can enable access logging to ship the access logs to their own project's cloud logging.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] consumer_accept_lists: Optional. Customer accept list represents the list of projects (id/number) on customer
               side that can privately connect to the service attachment. It is an optional field
               which the customers can provide during the instance creation. By default, the customer
               project associated with the Apigee organization will be included to the list.
        :param pulumi.Input[builtins.str] description: Description of the instance.
        :param pulumi.Input[builtins.str] disk_encryption_key_name: Customer Managed Encryption Key (CMEK) used for disk and volume encryption. Required for Apigee paid subscriptions only.
               Use the following format: `projects/([^/]+)/locations/([^/]+)/keyRings/([^/]+)/cryptoKeys/([^/]+)`
        :param pulumi.Input[builtins.str] display_name: Display name of the instance.
        :param pulumi.Input[builtins.str] host: Output only. Hostname or IP address of the exposed Apigee endpoint used by clients to connect to the service.
        :param pulumi.Input[builtins.str] ip_range: IP range represents the customer-provided CIDR block of length 22 that will be used for
               the Apigee instance creation. This optional range, if provided, should be freely
               available as part of larger named range the customer has allocated to the Service
               Networking peering. If this is not provided, Apigee will automatically request for any
               available /22 CIDR block from Service Networking. The customer should use this CIDR block
               for configuring their firewall needs to allow traffic from Apigee.
               Input format: "a.b.c.d/22"
        :param pulumi.Input[builtins.str] location: Required. Compute Engine location where the instance resides.
        :param pulumi.Input[builtins.str] name: Resource ID of the instance.
        :param pulumi.Input[builtins.str] org_id: The Apigee Organization associated with the Apigee instance,
               in the format `organizations/{{org_name}}`.
        :param pulumi.Input[builtins.str] peering_cidr_range: The size of the CIDR block range that will be reserved by the instance. For valid values,
               see [CidrRange](https://cloud.google.com/apigee/docs/reference/apis/apigee/rest/v1/organizations.instances#CidrRange) on the documentation.
        :param pulumi.Input[builtins.str] port: Output only. Port number of the exposed Apigee endpoint.
        :param pulumi.Input[builtins.str] service_attachment: Output only. Resource name of the service attachment created for the instance in
               the format: projects/*/regions/*/serviceAttachments/* Apigee customers can privately
               forward traffic to this service attachment using the PSC endpoints.
        """
        if access_logging_config is not None:
            pulumi.set(__self__, "access_logging_config", access_logging_config)
        if consumer_accept_lists is not None:
            pulumi.set(__self__, "consumer_accept_lists", consumer_accept_lists)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disk_encryption_key_name is not None:
            pulumi.set(__self__, "disk_encryption_key_name", disk_encryption_key_name)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if ip_range is not None:
            pulumi.set(__self__, "ip_range", ip_range)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if peering_cidr_range is not None:
            pulumi.set(__self__, "peering_cidr_range", peering_cidr_range)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if service_attachment is not None:
            pulumi.set(__self__, "service_attachment", service_attachment)

    @property
    @pulumi.getter(name="accessLoggingConfig")
    def access_logging_config(self) -> Optional[pulumi.Input['InstanceAccessLoggingConfigArgs']]:
        """
        Access logging configuration enables the access logging feature at the instance.
        Apigee customers can enable access logging to ship the access logs to their own project's cloud logging.
        Structure is documented below.
        """
        return pulumi.get(self, "access_logging_config")

    @access_logging_config.setter
    def access_logging_config(self, value: Optional[pulumi.Input['InstanceAccessLoggingConfigArgs']]):
        pulumi.set(self, "access_logging_config", value)

    @property
    @pulumi.getter(name="consumerAcceptLists")
    def consumer_accept_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Optional. Customer accept list represents the list of projects (id/number) on customer
        side that can privately connect to the service attachment. It is an optional field
        which the customers can provide during the instance creation. By default, the customer
        project associated with the Apigee organization will be included to the list.
        """
        return pulumi.get(self, "consumer_accept_lists")

    @consumer_accept_lists.setter
    def consumer_accept_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "consumer_accept_lists", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the instance.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="diskEncryptionKeyName")
    def disk_encryption_key_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Customer Managed Encryption Key (CMEK) used for disk and volume encryption. Required for Apigee paid subscriptions only.
        Use the following format: `projects/([^/]+)/locations/([^/]+)/keyRings/([^/]+)/cryptoKeys/([^/]+)`
        """
        return pulumi.get(self, "disk_encryption_key_name")

    @disk_encryption_key_name.setter
    def disk_encryption_key_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "disk_encryption_key_name", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Display name of the instance.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. Hostname or IP address of the exposed Apigee endpoint used by clients to connect to the service.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IP range represents the customer-provided CIDR block of length 22 that will be used for
        the Apigee instance creation. This optional range, if provided, should be freely
        available as part of larger named range the customer has allocated to the Service
        Networking peering. If this is not provided, Apigee will automatically request for any
        available /22 CIDR block from Service Networking. The customer should use this CIDR block
        for configuring their firewall needs to allow traffic from Apigee.
        Input format: "a.b.c.d/22"
        """
        return pulumi.get(self, "ip_range")

    @ip_range.setter
    def ip_range(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip_range", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Required. Compute Engine location where the instance resides.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Resource ID of the instance.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Apigee Organization associated with the Apigee instance,
        in the format `organizations/{{org_name}}`.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter(name="peeringCidrRange")
    def peering_cidr_range(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The size of the CIDR block range that will be reserved by the instance. For valid values,
        see [CidrRange](https://cloud.google.com/apigee/docs/reference/apis/apigee/rest/v1/organizations.instances#CidrRange) on the documentation.
        """
        return pulumi.get(self, "peering_cidr_range")

    @peering_cidr_range.setter
    def peering_cidr_range(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "peering_cidr_range", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. Port number of the exposed Apigee endpoint.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="serviceAttachment")
    def service_attachment(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. Resource name of the service attachment created for the instance in
        the format: projects/*/regions/*/serviceAttachments/* Apigee customers can privately
        forward traffic to this service attachment using the PSC endpoints.
        """
        return pulumi.get(self, "service_attachment")

    @service_attachment.setter
    def service_attachment(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_attachment", value)


@pulumi.type_token("gcp:apigee/instance:Instance")
class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_logging_config: Optional[pulumi.Input[Union['InstanceAccessLoggingConfigArgs', 'InstanceAccessLoggingConfigArgsDict']]] = None,
                 consumer_accept_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 disk_encryption_key_name: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 ip_range: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 org_id: Optional[pulumi.Input[builtins.str]] = None,
                 peering_cidr_range: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        An `Instance` is the runtime dataplane in Apigee.

        To get more information about Instance, see:

        * [API documentation](https://cloud.google.com/apigee/docs/reference/apis/apigee/rest/v1/organizations.instances/create)
        * How-to Guides
            * [Creating a runtime instance](https://cloud.google.com/apigee/docs/api-platform/get-started/create-instance)

        ## Example Usage

        ### Apigee Instance Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        current = gcp.organizations.get_client_config()
        apigee_network = gcp.compute.Network("apigee_network", name="apigee-network")
        apigee_range = gcp.compute.GlobalAddress("apigee_range",
            name="apigee-range",
            purpose="VPC_PEERING",
            address_type="INTERNAL",
            prefix_length=16,
            network=apigee_network.id)
        apigee_vpc_connection = gcp.servicenetworking.Connection("apigee_vpc_connection",
            network=apigee_network.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[apigee_range.name])
        apigee_org = gcp.apigee.Organization("apigee_org",
            analytics_region="us-central1",
            project_id=current.project,
            authorized_network=apigee_network.id,
            opts = pulumi.ResourceOptions(depends_on=[apigee_vpc_connection]))
        apigee_instance = gcp.apigee.Instance("apigee_instance",
            name="my-instance-name",
            location="us-central1",
            org_id=apigee_org.id)
        ```
        ### Apigee Instance Cidr Range

        ```python
        import pulumi
        import pulumi_gcp as gcp

        current = gcp.organizations.get_client_config()
        apigee_network = gcp.compute.Network("apigee_network", name="apigee-network")
        apigee_range = gcp.compute.GlobalAddress("apigee_range",
            name="apigee-range",
            purpose="VPC_PEERING",
            address_type="INTERNAL",
            prefix_length=22,
            network=apigee_network.id)
        apigee_vpc_connection = gcp.servicenetworking.Connection("apigee_vpc_connection",
            network=apigee_network.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[apigee_range.name])
        apigee_org = gcp.apigee.Organization("apigee_org",
            analytics_region="us-central1",
            project_id=current.project,
            authorized_network=apigee_network.id,
            opts = pulumi.ResourceOptions(depends_on=[apigee_vpc_connection]))
        apigee_instance = gcp.apigee.Instance("apigee_instance",
            name="my-instance-name",
            location="us-central1",
            org_id=apigee_org.id,
            peering_cidr_range="SLASH_22")
        ```
        ### Apigee Instance Ip Range

        ```python
        import pulumi
        import pulumi_gcp as gcp

        current = gcp.organizations.get_client_config()
        apigee_network = gcp.compute.Network("apigee_network", name="apigee-network")
        apigee_range = gcp.compute.GlobalAddress("apigee_range",
            name="apigee-range",
            purpose="VPC_PEERING",
            address_type="INTERNAL",
            prefix_length=22,
            network=apigee_network.id)
        apigee_vpc_connection = gcp.servicenetworking.Connection("apigee_vpc_connection",
            network=apigee_network.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[apigee_range.name])
        apigee_org = gcp.apigee.Organization("apigee_org",
            analytics_region="us-central1",
            project_id=current.project,
            authorized_network=apigee_network.id,
            opts = pulumi.ResourceOptions(depends_on=[apigee_vpc_connection]))
        apigee_instance = gcp.apigee.Instance("apigee_instance",
            name="my-instance-name",
            location="us-central1",
            org_id=apigee_org.id,
            ip_range="10.87.8.0/22")
        ```
        ### Apigee Instance Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        current = gcp.organizations.get_client_config()
        apigee_network = gcp.compute.Network("apigee_network", name="apigee-network")
        apigee_range = gcp.compute.GlobalAddress("apigee_range",
            name="apigee-range",
            purpose="VPC_PEERING",
            address_type="INTERNAL",
            prefix_length=16,
            network=apigee_network.id)
        apigee_vpc_connection = gcp.servicenetworking.Connection("apigee_vpc_connection",
            network=apigee_network.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[apigee_range.name])
        apigee_keyring = gcp.kms.KeyRing("apigee_keyring",
            name="apigee-keyring",
            location="us-central1")
        apigee_key = gcp.kms.CryptoKey("apigee_key",
            name="apigee-key",
            key_ring=apigee_keyring.id)
        apigee_sa = gcp.projects.ServiceIdentity("apigee_sa",
            project=project["projectId"],
            service=apigee["service"])
        apigee_sa_keyuser = gcp.kms.CryptoKeyIAMMember("apigee_sa_keyuser",
            crypto_key_id=apigee_key.id,
            role="roles/cloudkms.cryptoKeyEncrypterDecrypter",
            member=apigee_sa.member)
        apigee_org = gcp.apigee.Organization("apigee_org",
            analytics_region="us-central1",
            display_name="apigee-org",
            description="Auto-provisioned Apigee Org.",
            project_id=current.project,
            authorized_network=apigee_network.id,
            runtime_database_encryption_key_name=apigee_key.id,
            opts = pulumi.ResourceOptions(depends_on=[
                    apigee_vpc_connection,
                    apigee_sa_keyuser,
                ]))
        apigee_instance = gcp.apigee.Instance("apigee_instance",
            name="my-instance-name",
            location="us-central1",
            description="Auto-managed Apigee Runtime Instance",
            display_name="my-instance-name",
            org_id=apigee_org.id,
            disk_encryption_key_name=apigee_key.id)
        ```

        ## Import

        Instance can be imported using any of these accepted formats:

        * `{{org_id}}/instances/{{name}}`

        * `{{org_id}}/{{name}}`

        When using the `pulumi import` command, Instance can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:apigee/instance:Instance default {{org_id}}/instances/{{name}}
        ```

        ```sh
        $ pulumi import gcp:apigee/instance:Instance default {{org_id}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['InstanceAccessLoggingConfigArgs', 'InstanceAccessLoggingConfigArgsDict']] access_logging_config: Access logging configuration enables the access logging feature at the instance.
               Apigee customers can enable access logging to ship the access logs to their own project's cloud logging.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] consumer_accept_lists: Optional. Customer accept list represents the list of projects (id/number) on customer
               side that can privately connect to the service attachment. It is an optional field
               which the customers can provide during the instance creation. By default, the customer
               project associated with the Apigee organization will be included to the list.
        :param pulumi.Input[builtins.str] description: Description of the instance.
        :param pulumi.Input[builtins.str] disk_encryption_key_name: Customer Managed Encryption Key (CMEK) used for disk and volume encryption. Required for Apigee paid subscriptions only.
               Use the following format: `projects/([^/]+)/locations/([^/]+)/keyRings/([^/]+)/cryptoKeys/([^/]+)`
        :param pulumi.Input[builtins.str] display_name: Display name of the instance.
        :param pulumi.Input[builtins.str] ip_range: IP range represents the customer-provided CIDR block of length 22 that will be used for
               the Apigee instance creation. This optional range, if provided, should be freely
               available as part of larger named range the customer has allocated to the Service
               Networking peering. If this is not provided, Apigee will automatically request for any
               available /22 CIDR block from Service Networking. The customer should use this CIDR block
               for configuring their firewall needs to allow traffic from Apigee.
               Input format: "a.b.c.d/22"
        :param pulumi.Input[builtins.str] location: Required. Compute Engine location where the instance resides.
        :param pulumi.Input[builtins.str] name: Resource ID of the instance.
        :param pulumi.Input[builtins.str] org_id: The Apigee Organization associated with the Apigee instance,
               in the format `organizations/{{org_name}}`.
        :param pulumi.Input[builtins.str] peering_cidr_range: The size of the CIDR block range that will be reserved by the instance. For valid values,
               see [CidrRange](https://cloud.google.com/apigee/docs/reference/apis/apigee/rest/v1/organizations.instances#CidrRange) on the documentation.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        An `Instance` is the runtime dataplane in Apigee.

        To get more information about Instance, see:

        * [API documentation](https://cloud.google.com/apigee/docs/reference/apis/apigee/rest/v1/organizations.instances/create)
        * How-to Guides
            * [Creating a runtime instance](https://cloud.google.com/apigee/docs/api-platform/get-started/create-instance)

        ## Example Usage

        ### Apigee Instance Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        current = gcp.organizations.get_client_config()
        apigee_network = gcp.compute.Network("apigee_network", name="apigee-network")
        apigee_range = gcp.compute.GlobalAddress("apigee_range",
            name="apigee-range",
            purpose="VPC_PEERING",
            address_type="INTERNAL",
            prefix_length=16,
            network=apigee_network.id)
        apigee_vpc_connection = gcp.servicenetworking.Connection("apigee_vpc_connection",
            network=apigee_network.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[apigee_range.name])
        apigee_org = gcp.apigee.Organization("apigee_org",
            analytics_region="us-central1",
            project_id=current.project,
            authorized_network=apigee_network.id,
            opts = pulumi.ResourceOptions(depends_on=[apigee_vpc_connection]))
        apigee_instance = gcp.apigee.Instance("apigee_instance",
            name="my-instance-name",
            location="us-central1",
            org_id=apigee_org.id)
        ```
        ### Apigee Instance Cidr Range

        ```python
        import pulumi
        import pulumi_gcp as gcp

        current = gcp.organizations.get_client_config()
        apigee_network = gcp.compute.Network("apigee_network", name="apigee-network")
        apigee_range = gcp.compute.GlobalAddress("apigee_range",
            name="apigee-range",
            purpose="VPC_PEERING",
            address_type="INTERNAL",
            prefix_length=22,
            network=apigee_network.id)
        apigee_vpc_connection = gcp.servicenetworking.Connection("apigee_vpc_connection",
            network=apigee_network.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[apigee_range.name])
        apigee_org = gcp.apigee.Organization("apigee_org",
            analytics_region="us-central1",
            project_id=current.project,
            authorized_network=apigee_network.id,
            opts = pulumi.ResourceOptions(depends_on=[apigee_vpc_connection]))
        apigee_instance = gcp.apigee.Instance("apigee_instance",
            name="my-instance-name",
            location="us-central1",
            org_id=apigee_org.id,
            peering_cidr_range="SLASH_22")
        ```
        ### Apigee Instance Ip Range

        ```python
        import pulumi
        import pulumi_gcp as gcp

        current = gcp.organizations.get_client_config()
        apigee_network = gcp.compute.Network("apigee_network", name="apigee-network")
        apigee_range = gcp.compute.GlobalAddress("apigee_range",
            name="apigee-range",
            purpose="VPC_PEERING",
            address_type="INTERNAL",
            prefix_length=22,
            network=apigee_network.id)
        apigee_vpc_connection = gcp.servicenetworking.Connection("apigee_vpc_connection",
            network=apigee_network.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[apigee_range.name])
        apigee_org = gcp.apigee.Organization("apigee_org",
            analytics_region="us-central1",
            project_id=current.project,
            authorized_network=apigee_network.id,
            opts = pulumi.ResourceOptions(depends_on=[apigee_vpc_connection]))
        apigee_instance = gcp.apigee.Instance("apigee_instance",
            name="my-instance-name",
            location="us-central1",
            org_id=apigee_org.id,
            ip_range="10.87.8.0/22")
        ```
        ### Apigee Instance Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        current = gcp.organizations.get_client_config()
        apigee_network = gcp.compute.Network("apigee_network", name="apigee-network")
        apigee_range = gcp.compute.GlobalAddress("apigee_range",
            name="apigee-range",
            purpose="VPC_PEERING",
            address_type="INTERNAL",
            prefix_length=16,
            network=apigee_network.id)
        apigee_vpc_connection = gcp.servicenetworking.Connection("apigee_vpc_connection",
            network=apigee_network.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[apigee_range.name])
        apigee_keyring = gcp.kms.KeyRing("apigee_keyring",
            name="apigee-keyring",
            location="us-central1")
        apigee_key = gcp.kms.CryptoKey("apigee_key",
            name="apigee-key",
            key_ring=apigee_keyring.id)
        apigee_sa = gcp.projects.ServiceIdentity("apigee_sa",
            project=project["projectId"],
            service=apigee["service"])
        apigee_sa_keyuser = gcp.kms.CryptoKeyIAMMember("apigee_sa_keyuser",
            crypto_key_id=apigee_key.id,
            role="roles/cloudkms.cryptoKeyEncrypterDecrypter",
            member=apigee_sa.member)
        apigee_org = gcp.apigee.Organization("apigee_org",
            analytics_region="us-central1",
            display_name="apigee-org",
            description="Auto-provisioned Apigee Org.",
            project_id=current.project,
            authorized_network=apigee_network.id,
            runtime_database_encryption_key_name=apigee_key.id,
            opts = pulumi.ResourceOptions(depends_on=[
                    apigee_vpc_connection,
                    apigee_sa_keyuser,
                ]))
        apigee_instance = gcp.apigee.Instance("apigee_instance",
            name="my-instance-name",
            location="us-central1",
            description="Auto-managed Apigee Runtime Instance",
            display_name="my-instance-name",
            org_id=apigee_org.id,
            disk_encryption_key_name=apigee_key.id)
        ```

        ## Import

        Instance can be imported using any of these accepted formats:

        * `{{org_id}}/instances/{{name}}`

        * `{{org_id}}/{{name}}`

        When using the `pulumi import` command, Instance can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:apigee/instance:Instance default {{org_id}}/instances/{{name}}
        ```

        ```sh
        $ pulumi import gcp:apigee/instance:Instance default {{org_id}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_logging_config: Optional[pulumi.Input[Union['InstanceAccessLoggingConfigArgs', 'InstanceAccessLoggingConfigArgsDict']]] = None,
                 consumer_accept_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 disk_encryption_key_name: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 ip_range: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 org_id: Optional[pulumi.Input[builtins.str]] = None,
                 peering_cidr_range: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["access_logging_config"] = access_logging_config
            __props__.__dict__["consumer_accept_lists"] = consumer_accept_lists
            __props__.__dict__["description"] = description
            __props__.__dict__["disk_encryption_key_name"] = disk_encryption_key_name
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["ip_range"] = ip_range
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            if org_id is None and not opts.urn:
                raise TypeError("Missing required property 'org_id'")
            __props__.__dict__["org_id"] = org_id
            __props__.__dict__["peering_cidr_range"] = peering_cidr_range
            __props__.__dict__["host"] = None
            __props__.__dict__["port"] = None
            __props__.__dict__["service_attachment"] = None
        super(Instance, __self__).__init__(
            'gcp:apigee/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_logging_config: Optional[pulumi.Input[Union['InstanceAccessLoggingConfigArgs', 'InstanceAccessLoggingConfigArgsDict']]] = None,
            consumer_accept_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            disk_encryption_key_name: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            host: Optional[pulumi.Input[builtins.str]] = None,
            ip_range: Optional[pulumi.Input[builtins.str]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            org_id: Optional[pulumi.Input[builtins.str]] = None,
            peering_cidr_range: Optional[pulumi.Input[builtins.str]] = None,
            port: Optional[pulumi.Input[builtins.str]] = None,
            service_attachment: Optional[pulumi.Input[builtins.str]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['InstanceAccessLoggingConfigArgs', 'InstanceAccessLoggingConfigArgsDict']] access_logging_config: Access logging configuration enables the access logging feature at the instance.
               Apigee customers can enable access logging to ship the access logs to their own project's cloud logging.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] consumer_accept_lists: Optional. Customer accept list represents the list of projects (id/number) on customer
               side that can privately connect to the service attachment. It is an optional field
               which the customers can provide during the instance creation. By default, the customer
               project associated with the Apigee organization will be included to the list.
        :param pulumi.Input[builtins.str] description: Description of the instance.
        :param pulumi.Input[builtins.str] disk_encryption_key_name: Customer Managed Encryption Key (CMEK) used for disk and volume encryption. Required for Apigee paid subscriptions only.
               Use the following format: `projects/([^/]+)/locations/([^/]+)/keyRings/([^/]+)/cryptoKeys/([^/]+)`
        :param pulumi.Input[builtins.str] display_name: Display name of the instance.
        :param pulumi.Input[builtins.str] host: Output only. Hostname or IP address of the exposed Apigee endpoint used by clients to connect to the service.
        :param pulumi.Input[builtins.str] ip_range: IP range represents the customer-provided CIDR block of length 22 that will be used for
               the Apigee instance creation. This optional range, if provided, should be freely
               available as part of larger named range the customer has allocated to the Service
               Networking peering. If this is not provided, Apigee will automatically request for any
               available /22 CIDR block from Service Networking. The customer should use this CIDR block
               for configuring their firewall needs to allow traffic from Apigee.
               Input format: "a.b.c.d/22"
        :param pulumi.Input[builtins.str] location: Required. Compute Engine location where the instance resides.
        :param pulumi.Input[builtins.str] name: Resource ID of the instance.
        :param pulumi.Input[builtins.str] org_id: The Apigee Organization associated with the Apigee instance,
               in the format `organizations/{{org_name}}`.
        :param pulumi.Input[builtins.str] peering_cidr_range: The size of the CIDR block range that will be reserved by the instance. For valid values,
               see [CidrRange](https://cloud.google.com/apigee/docs/reference/apis/apigee/rest/v1/organizations.instances#CidrRange) on the documentation.
        :param pulumi.Input[builtins.str] port: Output only. Port number of the exposed Apigee endpoint.
        :param pulumi.Input[builtins.str] service_attachment: Output only. Resource name of the service attachment created for the instance in
               the format: projects/*/regions/*/serviceAttachments/* Apigee customers can privately
               forward traffic to this service attachment using the PSC endpoints.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["access_logging_config"] = access_logging_config
        __props__.__dict__["consumer_accept_lists"] = consumer_accept_lists
        __props__.__dict__["description"] = description
        __props__.__dict__["disk_encryption_key_name"] = disk_encryption_key_name
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["host"] = host
        __props__.__dict__["ip_range"] = ip_range
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["peering_cidr_range"] = peering_cidr_range
        __props__.__dict__["port"] = port
        __props__.__dict__["service_attachment"] = service_attachment
        return Instance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessLoggingConfig")
    def access_logging_config(self) -> pulumi.Output[Optional['outputs.InstanceAccessLoggingConfig']]:
        """
        Access logging configuration enables the access logging feature at the instance.
        Apigee customers can enable access logging to ship the access logs to their own project's cloud logging.
        Structure is documented below.
        """
        return pulumi.get(self, "access_logging_config")

    @property
    @pulumi.getter(name="consumerAcceptLists")
    def consumer_accept_lists(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        Optional. Customer accept list represents the list of projects (id/number) on customer
        side that can privately connect to the service attachment. It is an optional field
        which the customers can provide during the instance creation. By default, the customer
        project associated with the Apigee organization will be included to the list.
        """
        return pulumi.get(self, "consumer_accept_lists")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Description of the instance.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="diskEncryptionKeyName")
    def disk_encryption_key_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Customer Managed Encryption Key (CMEK) used for disk and volume encryption. Required for Apigee paid subscriptions only.
        Use the following format: `projects/([^/]+)/locations/([^/]+)/keyRings/([^/]+)/cryptoKeys/([^/]+)`
        """
        return pulumi.get(self, "disk_encryption_key_name")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Display name of the instance.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def host(self) -> pulumi.Output[builtins.str]:
        """
        Output only. Hostname or IP address of the exposed Apigee endpoint used by clients to connect to the service.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        IP range represents the customer-provided CIDR block of length 22 that will be used for
        the Apigee instance creation. This optional range, if provided, should be freely
        available as part of larger named range the customer has allocated to the Service
        Networking peering. If this is not provided, Apigee will automatically request for any
        available /22 CIDR block from Service Networking. The customer should use this CIDR block
        for configuring their firewall needs to allow traffic from Apigee.
        Input format: "a.b.c.d/22"
        """
        return pulumi.get(self, "ip_range")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        Required. Compute Engine location where the instance resides.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Resource ID of the instance.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[builtins.str]:
        """
        The Apigee Organization associated with the Apigee instance,
        in the format `organizations/{{org_name}}`.
        """
        return pulumi.get(self, "org_id")

    @property
    @pulumi.getter(name="peeringCidrRange")
    def peering_cidr_range(self) -> pulumi.Output[builtins.str]:
        """
        The size of the CIDR block range that will be reserved by the instance. For valid values,
        see [CidrRange](https://cloud.google.com/apigee/docs/reference/apis/apigee/rest/v1/organizations.instances#CidrRange) on the documentation.
        """
        return pulumi.get(self, "peering_cidr_range")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[builtins.str]:
        """
        Output only. Port number of the exposed Apigee endpoint.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="serviceAttachment")
    def service_attachment(self) -> pulumi.Output[builtins.str]:
        """
        Output only. Resource name of the service attachment created for the instance in
        the format: projects/*/regions/*/serviceAttachments/* Apigee customers can privately
        forward traffic to this service attachment using the PSC endpoints.
        """
        return pulumi.get(self, "service_attachment")

