# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'AddonsConfigAddonsConfig',
    'AddonsConfigAddonsConfigAdvancedApiOpsConfig',
    'AddonsConfigAddonsConfigApiSecurityConfig',
    'AddonsConfigAddonsConfigConnectorsPlatformConfig',
    'AddonsConfigAddonsConfigIntegrationConfig',
    'AddonsConfigAddonsConfigMonetizationConfig',
    'ApiMetaData',
    'AppGroupAttribute',
    'DeveloperAttribute',
    'DnsZonePeeringConfig',
    'EnvironmentClientIpResolutionConfig',
    'EnvironmentClientIpResolutionConfigHeaderIndexAlgorithm',
    'EnvironmentIamBindingCondition',
    'EnvironmentIamMemberCondition',
    'EnvironmentNodeConfig',
    'EnvironmentProperties',
    'EnvironmentPropertiesProperty',
    'InstanceAccessLoggingConfig',
    'KeystoresAliasesKeyCertFileCertsInfo',
    'KeystoresAliasesKeyCertFileCertsInfoCertInfo',
    'KeystoresAliasesPkcs12CertsInfo',
    'KeystoresAliasesPkcs12CertsInfoCertInfo',
    'KeystoresAliasesSelfSignedCertCertsInfo',
    'KeystoresAliasesSelfSignedCertCertsInfoCertInfo',
    'KeystoresAliasesSelfSignedCertSubject',
    'KeystoresAliasesSelfSignedCertSubjectAlternativeDnsNames',
    'OrganizationProperties',
    'OrganizationPropertiesProperty',
    'SecurityMonitoringConditionIncludeAllResources',
    'SecurityProfileV2ProfileAssessmentConfig',
    'SharedflowMetaData',
    'TargetServerSSlInfo',
    'TargetServerSSlInfoCommonName',
]

@pulumi.output_type
class AddonsConfigAddonsConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "advancedApiOpsConfig":
            suggest = "advanced_api_ops_config"
        elif key == "apiSecurityConfig":
            suggest = "api_security_config"
        elif key == "connectorsPlatformConfig":
            suggest = "connectors_platform_config"
        elif key == "integrationConfig":
            suggest = "integration_config"
        elif key == "monetizationConfig":
            suggest = "monetization_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AddonsConfigAddonsConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AddonsConfigAddonsConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AddonsConfigAddonsConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 advanced_api_ops_config: Optional['outputs.AddonsConfigAddonsConfigAdvancedApiOpsConfig'] = None,
                 api_security_config: Optional['outputs.AddonsConfigAddonsConfigApiSecurityConfig'] = None,
                 connectors_platform_config: Optional['outputs.AddonsConfigAddonsConfigConnectorsPlatformConfig'] = None,
                 integration_config: Optional['outputs.AddonsConfigAddonsConfigIntegrationConfig'] = None,
                 monetization_config: Optional['outputs.AddonsConfigAddonsConfigMonetizationConfig'] = None):
        """
        :param 'AddonsConfigAddonsConfigAdvancedApiOpsConfigArgs' advanced_api_ops_config: Configuration for the Advanced API Ops add-on.
               Structure is documented below.
        :param 'AddonsConfigAddonsConfigApiSecurityConfigArgs' api_security_config: Configuration for the API Security add-on.
               Structure is documented below.
        :param 'AddonsConfigAddonsConfigConnectorsPlatformConfigArgs' connectors_platform_config: Configuration for the Monetization add-on.
               Structure is documented below.
        :param 'AddonsConfigAddonsConfigIntegrationConfigArgs' integration_config: Configuration for the Integration add-on.
               Structure is documented below.
        :param 'AddonsConfigAddonsConfigMonetizationConfigArgs' monetization_config: Configuration for the Monetization add-on.
               Structure is documented below.
        """
        if advanced_api_ops_config is not None:
            pulumi.set(__self__, "advanced_api_ops_config", advanced_api_ops_config)
        if api_security_config is not None:
            pulumi.set(__self__, "api_security_config", api_security_config)
        if connectors_platform_config is not None:
            pulumi.set(__self__, "connectors_platform_config", connectors_platform_config)
        if integration_config is not None:
            pulumi.set(__self__, "integration_config", integration_config)
        if monetization_config is not None:
            pulumi.set(__self__, "monetization_config", monetization_config)

    @property
    @pulumi.getter(name="advancedApiOpsConfig")
    def advanced_api_ops_config(self) -> Optional['outputs.AddonsConfigAddonsConfigAdvancedApiOpsConfig']:
        """
        Configuration for the Advanced API Ops add-on.
        Structure is documented below.
        """
        return pulumi.get(self, "advanced_api_ops_config")

    @property
    @pulumi.getter(name="apiSecurityConfig")
    def api_security_config(self) -> Optional['outputs.AddonsConfigAddonsConfigApiSecurityConfig']:
        """
        Configuration for the API Security add-on.
        Structure is documented below.
        """
        return pulumi.get(self, "api_security_config")

    @property
    @pulumi.getter(name="connectorsPlatformConfig")
    def connectors_platform_config(self) -> Optional['outputs.AddonsConfigAddonsConfigConnectorsPlatformConfig']:
        """
        Configuration for the Monetization add-on.
        Structure is documented below.
        """
        return pulumi.get(self, "connectors_platform_config")

    @property
    @pulumi.getter(name="integrationConfig")
    def integration_config(self) -> Optional['outputs.AddonsConfigAddonsConfigIntegrationConfig']:
        """
        Configuration for the Integration add-on.
        Structure is documented below.
        """
        return pulumi.get(self, "integration_config")

    @property
    @pulumi.getter(name="monetizationConfig")
    def monetization_config(self) -> Optional['outputs.AddonsConfigAddonsConfigMonetizationConfig']:
        """
        Configuration for the Monetization add-on.
        Structure is documented below.
        """
        return pulumi.get(self, "monetization_config")


@pulumi.output_type
class AddonsConfigAddonsConfigAdvancedApiOpsConfig(dict):
    def __init__(__self__, *,
                 enabled: Optional[builtins.bool] = None):
        """
        :param builtins.bool enabled: Flag that specifies whether the Advanced API Ops add-on is enabled.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[builtins.bool]:
        """
        Flag that specifies whether the Advanced API Ops add-on is enabled.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class AddonsConfigAddonsConfigApiSecurityConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expiresAt":
            suggest = "expires_at"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AddonsConfigAddonsConfigApiSecurityConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AddonsConfigAddonsConfigApiSecurityConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AddonsConfigAddonsConfigApiSecurityConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[builtins.bool] = None,
                 expires_at: Optional[builtins.str] = None):
        """
        :param builtins.bool enabled: Flag that specifies whether the API security add-on is enabled.
        :param builtins.str expires_at: (Output)
               Time at which the API Security add-on expires in in milliseconds since epoch. If unspecified, the add-on will never expire.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if expires_at is not None:
            pulumi.set(__self__, "expires_at", expires_at)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[builtins.bool]:
        """
        Flag that specifies whether the API security add-on is enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> Optional[builtins.str]:
        """
        (Output)
        Time at which the API Security add-on expires in in milliseconds since epoch. If unspecified, the add-on will never expire.
        """
        return pulumi.get(self, "expires_at")


@pulumi.output_type
class AddonsConfigAddonsConfigConnectorsPlatformConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expiresAt":
            suggest = "expires_at"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AddonsConfigAddonsConfigConnectorsPlatformConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AddonsConfigAddonsConfigConnectorsPlatformConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AddonsConfigAddonsConfigConnectorsPlatformConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[builtins.bool] = None,
                 expires_at: Optional[builtins.str] = None):
        """
        :param builtins.bool enabled: Flag that specifies whether the Connectors Platform add-on is enabled.
        :param builtins.str expires_at: (Output)
               Time at which the Connectors Platform add-on expires in milliseconds since epoch. If unspecified, the add-on will never expire.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if expires_at is not None:
            pulumi.set(__self__, "expires_at", expires_at)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[builtins.bool]:
        """
        Flag that specifies whether the Connectors Platform add-on is enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> Optional[builtins.str]:
        """
        (Output)
        Time at which the Connectors Platform add-on expires in milliseconds since epoch. If unspecified, the add-on will never expire.
        """
        return pulumi.get(self, "expires_at")


@pulumi.output_type
class AddonsConfigAddonsConfigIntegrationConfig(dict):
    def __init__(__self__, *,
                 enabled: Optional[builtins.bool] = None):
        """
        :param builtins.bool enabled: Flag that specifies whether the Integration add-on is enabled.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[builtins.bool]:
        """
        Flag that specifies whether the Integration add-on is enabled.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class AddonsConfigAddonsConfigMonetizationConfig(dict):
    def __init__(__self__, *,
                 enabled: Optional[builtins.bool] = None):
        """
        :param builtins.bool enabled: Flag that specifies whether the Monetization add-on is enabled.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[builtins.bool]:
        """
        Flag that specifies whether the Monetization add-on is enabled.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class ApiMetaData(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "subType":
            suggest = "sub_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiMetaData. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiMetaData.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiMetaData.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[builtins.str] = None,
                 last_modified_at: Optional[builtins.str] = None,
                 sub_type: Optional[builtins.str] = None):
        """
        :param builtins.str created_at: Time at which the API proxy was created, in milliseconds since epoch.
        :param builtins.str last_modified_at: Time at which the API proxy was most recently modified, in milliseconds since epoch.
        :param builtins.str sub_type: The type of entity described
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if sub_type is not None:
            pulumi.set(__self__, "sub_type", sub_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[builtins.str]:
        """
        Time at which the API proxy was created, in milliseconds since epoch.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[builtins.str]:
        """
        Time at which the API proxy was most recently modified, in milliseconds since epoch.
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="subType")
    def sub_type(self) -> Optional[builtins.str]:
        """
        The type of entity described
        """
        return pulumi.get(self, "sub_type")


@pulumi.output_type
class AppGroupAttribute(dict):
    def __init__(__self__, *,
                 name: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        """
        :param builtins.str name: Key of the attribute
        :param builtins.str value: Value of the attribute
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Key of the attribute
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        """
        Value of the attribute
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class DeveloperAttribute(dict):
    def __init__(__self__, *,
                 name: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        """
        :param builtins.str name: Key of the attribute
        :param builtins.str value: Value of the attribute
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Key of the attribute
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        """
        Value of the attribute
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class DnsZonePeeringConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetNetworkId":
            suggest = "target_network_id"
        elif key == "targetProjectId":
            suggest = "target_project_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DnsZonePeeringConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DnsZonePeeringConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DnsZonePeeringConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_network_id: builtins.str,
                 target_project_id: builtins.str):
        """
        :param builtins.str target_network_id: The name of the producer VPC network.
        :param builtins.str target_project_id: The ID of the project that contains the producer VPC network.
        """
        pulumi.set(__self__, "target_network_id", target_network_id)
        pulumi.set(__self__, "target_project_id", target_project_id)

    @property
    @pulumi.getter(name="targetNetworkId")
    def target_network_id(self) -> builtins.str:
        """
        The name of the producer VPC network.
        """
        return pulumi.get(self, "target_network_id")

    @property
    @pulumi.getter(name="targetProjectId")
    def target_project_id(self) -> builtins.str:
        """
        The ID of the project that contains the producer VPC network.
        """
        return pulumi.get(self, "target_project_id")


@pulumi.output_type
class EnvironmentClientIpResolutionConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "headerIndexAlgorithm":
            suggest = "header_index_algorithm"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnvironmentClientIpResolutionConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnvironmentClientIpResolutionConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnvironmentClientIpResolutionConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 header_index_algorithm: Optional['outputs.EnvironmentClientIpResolutionConfigHeaderIndexAlgorithm'] = None):
        """
        :param 'EnvironmentClientIpResolutionConfigHeaderIndexAlgorithmArgs' header_index_algorithm: Resolves the client ip based on a custom header.
               Structure is documented below.
        """
        if header_index_algorithm is not None:
            pulumi.set(__self__, "header_index_algorithm", header_index_algorithm)

    @property
    @pulumi.getter(name="headerIndexAlgorithm")
    def header_index_algorithm(self) -> Optional['outputs.EnvironmentClientIpResolutionConfigHeaderIndexAlgorithm']:
        """
        Resolves the client ip based on a custom header.
        Structure is documented below.
        """
        return pulumi.get(self, "header_index_algorithm")


@pulumi.output_type
class EnvironmentClientIpResolutionConfigHeaderIndexAlgorithm(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipHeaderIndex":
            suggest = "ip_header_index"
        elif key == "ipHeaderName":
            suggest = "ip_header_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnvironmentClientIpResolutionConfigHeaderIndexAlgorithm. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnvironmentClientIpResolutionConfigHeaderIndexAlgorithm.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnvironmentClientIpResolutionConfigHeaderIndexAlgorithm.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_header_index: builtins.int,
                 ip_header_name: builtins.str):
        """
        :param builtins.int ip_header_index: The index of the ip in the header. Positive indices 0, 1, 2, 3 chooses indices from the left (first ips). Negative indices -1, -2, -3 chooses indices from the right (last ips).
        :param builtins.str ip_header_name: The name of the header to extract the client ip from. We are currently only supporting the X-Forwarded-For header.
        """
        pulumi.set(__self__, "ip_header_index", ip_header_index)
        pulumi.set(__self__, "ip_header_name", ip_header_name)

    @property
    @pulumi.getter(name="ipHeaderIndex")
    def ip_header_index(self) -> builtins.int:
        """
        The index of the ip in the header. Positive indices 0, 1, 2, 3 chooses indices from the left (first ips). Negative indices -1, -2, -3 chooses indices from the right (last ips).
        """
        return pulumi.get(self, "ip_header_index")

    @property
    @pulumi.getter(name="ipHeaderName")
    def ip_header_name(self) -> builtins.str:
        """
        The name of the header to extract the client ip from. We are currently only supporting the X-Forwarded-For header.
        """
        return pulumi.get(self, "ip_header_name")


@pulumi.output_type
class EnvironmentIamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: builtins.str,
                 title: builtins.str,
                 description: Optional[builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> builtins.str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> builtins.str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class EnvironmentIamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: builtins.str,
                 title: builtins.str,
                 description: Optional[builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> builtins.str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> builtins.str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class EnvironmentNodeConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "currentAggregateNodeCount":
            suggest = "current_aggregate_node_count"
        elif key == "maxNodeCount":
            suggest = "max_node_count"
        elif key == "minNodeCount":
            suggest = "min_node_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnvironmentNodeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnvironmentNodeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnvironmentNodeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 current_aggregate_node_count: Optional[builtins.str] = None,
                 max_node_count: Optional[builtins.str] = None,
                 min_node_count: Optional[builtins.str] = None):
        """
        :param builtins.str current_aggregate_node_count: (Output)
               The current total number of gateway nodes that each environment currently has across
               all instances.
        :param builtins.str max_node_count: The maximum total number of gateway nodes that the is reserved for all instances that
               has the specified environment. If not specified, the default is determined by the
               recommended maximum number of nodes for that gateway.
        :param builtins.str min_node_count: The minimum total number of gateway nodes that the is reserved for all instances that
               has the specified environment. If not specified, the default is determined by the
               recommended minimum number of nodes for that gateway.
        """
        if current_aggregate_node_count is not None:
            pulumi.set(__self__, "current_aggregate_node_count", current_aggregate_node_count)
        if max_node_count is not None:
            pulumi.set(__self__, "max_node_count", max_node_count)
        if min_node_count is not None:
            pulumi.set(__self__, "min_node_count", min_node_count)

    @property
    @pulumi.getter(name="currentAggregateNodeCount")
    def current_aggregate_node_count(self) -> Optional[builtins.str]:
        """
        (Output)
        The current total number of gateway nodes that each environment currently has across
        all instances.
        """
        return pulumi.get(self, "current_aggregate_node_count")

    @property
    @pulumi.getter(name="maxNodeCount")
    def max_node_count(self) -> Optional[builtins.str]:
        """
        The maximum total number of gateway nodes that the is reserved for all instances that
        has the specified environment. If not specified, the default is determined by the
        recommended maximum number of nodes for that gateway.
        """
        return pulumi.get(self, "max_node_count")

    @property
    @pulumi.getter(name="minNodeCount")
    def min_node_count(self) -> Optional[builtins.str]:
        """
        The minimum total number of gateway nodes that the is reserved for all instances that
        has the specified environment. If not specified, the default is determined by the
        recommended minimum number of nodes for that gateway.
        """
        return pulumi.get(self, "min_node_count")


@pulumi.output_type
class EnvironmentProperties(dict):
    def __init__(__self__, *,
                 properties: Optional[Sequence['outputs.EnvironmentPropertiesProperty']] = None):
        """
        :param Sequence['EnvironmentPropertiesPropertyArgs'] properties: List of all properties in the object.
               Structure is documented below.
        """
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter
    def properties(self) -> Optional[Sequence['outputs.EnvironmentPropertiesProperty']]:
        """
        List of all properties in the object.
        Structure is documented below.
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class EnvironmentPropertiesProperty(dict):
    def __init__(__self__, *,
                 name: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        """
        :param builtins.str name: The property key.
        :param builtins.str value: The property value.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The property key.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        """
        The property value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class InstanceAccessLoggingConfig(dict):
    def __init__(__self__, *,
                 enabled: builtins.bool,
                 filter: Optional[builtins.str] = None):
        """
        :param builtins.bool enabled: Boolean flag that specifies whether the customer access log feature is enabled.
        :param builtins.str filter: Ship the access log entries that match the statusCode defined in the filter.
               The statusCode is the only expected/supported filter field. (Ex: statusCode)
               The filter will parse it to the Common Expression Language semantics for expression
               evaluation to build the filter condition. (Ex: "filter": statusCode >= 200 && statusCode < 300 )
        """
        pulumi.set(__self__, "enabled", enabled)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        Boolean flag that specifies whether the customer access log feature is enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def filter(self) -> Optional[builtins.str]:
        """
        Ship the access log entries that match the statusCode defined in the filter.
        The statusCode is the only expected/supported filter field. (Ex: statusCode)
        The filter will parse it to the Common Expression Language semantics for expression
        evaluation to build the filter condition. (Ex: "filter": statusCode >= 200 && statusCode < 300 )
        """
        return pulumi.get(self, "filter")


@pulumi.output_type
class KeystoresAliasesKeyCertFileCertsInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certInfos":
            suggest = "cert_infos"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeystoresAliasesKeyCertFileCertsInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeystoresAliasesKeyCertFileCertsInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeystoresAliasesKeyCertFileCertsInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cert_infos: Optional[Sequence['outputs.KeystoresAliasesKeyCertFileCertsInfoCertInfo']] = None):
        """
        :param Sequence['KeystoresAliasesKeyCertFileCertsInfoCertInfoArgs'] cert_infos: (Output)
               List of all properties in the object.
               Structure is documented below.
        """
        if cert_infos is not None:
            pulumi.set(__self__, "cert_infos", cert_infos)

    @property
    @pulumi.getter(name="certInfos")
    def cert_infos(self) -> Optional[Sequence['outputs.KeystoresAliasesKeyCertFileCertsInfoCertInfo']]:
        """
        (Output)
        List of all properties in the object.
        Structure is documented below.
        """
        return pulumi.get(self, "cert_infos")


@pulumi.output_type
class KeystoresAliasesKeyCertFileCertsInfoCertInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "basicConstraints":
            suggest = "basic_constraints"
        elif key == "expiryDate":
            suggest = "expiry_date"
        elif key == "isValid":
            suggest = "is_valid"
        elif key == "publicKey":
            suggest = "public_key"
        elif key == "serialNumber":
            suggest = "serial_number"
        elif key == "sigAlgName":
            suggest = "sig_alg_name"
        elif key == "subjectAlternativeNames":
            suggest = "subject_alternative_names"
        elif key == "validFrom":
            suggest = "valid_from"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeystoresAliasesKeyCertFileCertsInfoCertInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeystoresAliasesKeyCertFileCertsInfoCertInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeystoresAliasesKeyCertFileCertsInfoCertInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 basic_constraints: Optional[builtins.str] = None,
                 expiry_date: Optional[builtins.str] = None,
                 is_valid: Optional[builtins.str] = None,
                 issuer: Optional[builtins.str] = None,
                 public_key: Optional[builtins.str] = None,
                 serial_number: Optional[builtins.str] = None,
                 sig_alg_name: Optional[builtins.str] = None,
                 subject: Optional[builtins.str] = None,
                 subject_alternative_names: Optional[Sequence[builtins.str]] = None,
                 valid_from: Optional[builtins.str] = None,
                 version: Optional[builtins.int] = None):
        """
        :param builtins.str basic_constraints: (Output)
               X.509 basic constraints extension.
        :param builtins.str expiry_date: (Output)
               X.509 notAfter validity period in milliseconds since epoch.
        :param builtins.str is_valid: (Output)
               Flag that specifies whether the certificate is valid.
               Flag is set to Yes if the certificate is valid, No if expired, or Not yet if not yet valid.
        :param builtins.str issuer: (Output)
               X.509 issuer.
        :param builtins.str public_key: (Output)
               Public key component of the X.509 subject public key info.
        :param builtins.str serial_number: (Output)
               X.509 serial number.
        :param builtins.str sig_alg_name: (Output)
               X.509 signatureAlgorithm.
        :param builtins.str subject: (Output)
               X.509 subject.
        :param Sequence[builtins.str] subject_alternative_names: (Output)
               X.509 subject alternative names (SANs) extension.
        :param builtins.str valid_from: (Output)
               X.509 notBefore validity period in milliseconds since epoch.
        :param builtins.int version: (Output)
               X.509 version.
        """
        if basic_constraints is not None:
            pulumi.set(__self__, "basic_constraints", basic_constraints)
        if expiry_date is not None:
            pulumi.set(__self__, "expiry_date", expiry_date)
        if is_valid is not None:
            pulumi.set(__self__, "is_valid", is_valid)
        if issuer is not None:
            pulumi.set(__self__, "issuer", issuer)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if serial_number is not None:
            pulumi.set(__self__, "serial_number", serial_number)
        if sig_alg_name is not None:
            pulumi.set(__self__, "sig_alg_name", sig_alg_name)
        if subject is not None:
            pulumi.set(__self__, "subject", subject)
        if subject_alternative_names is not None:
            pulumi.set(__self__, "subject_alternative_names", subject_alternative_names)
        if valid_from is not None:
            pulumi.set(__self__, "valid_from", valid_from)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="basicConstraints")
    def basic_constraints(self) -> Optional[builtins.str]:
        """
        (Output)
        X.509 basic constraints extension.
        """
        return pulumi.get(self, "basic_constraints")

    @property
    @pulumi.getter(name="expiryDate")
    def expiry_date(self) -> Optional[builtins.str]:
        """
        (Output)
        X.509 notAfter validity period in milliseconds since epoch.
        """
        return pulumi.get(self, "expiry_date")

    @property
    @pulumi.getter(name="isValid")
    def is_valid(self) -> Optional[builtins.str]:
        """
        (Output)
        Flag that specifies whether the certificate is valid.
        Flag is set to Yes if the certificate is valid, No if expired, or Not yet if not yet valid.
        """
        return pulumi.get(self, "is_valid")

    @property
    @pulumi.getter
    def issuer(self) -> Optional[builtins.str]:
        """
        (Output)
        X.509 issuer.
        """
        return pulumi.get(self, "issuer")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[builtins.str]:
        """
        (Output)
        Public key component of the X.509 subject public key info.
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> Optional[builtins.str]:
        """
        (Output)
        X.509 serial number.
        """
        return pulumi.get(self, "serial_number")

    @property
    @pulumi.getter(name="sigAlgName")
    def sig_alg_name(self) -> Optional[builtins.str]:
        """
        (Output)
        X.509 signatureAlgorithm.
        """
        return pulumi.get(self, "sig_alg_name")

    @property
    @pulumi.getter
    def subject(self) -> Optional[builtins.str]:
        """
        (Output)
        X.509 subject.
        """
        return pulumi.get(self, "subject")

    @property
    @pulumi.getter(name="subjectAlternativeNames")
    def subject_alternative_names(self) -> Optional[Sequence[builtins.str]]:
        """
        (Output)
        X.509 subject alternative names (SANs) extension.
        """
        return pulumi.get(self, "subject_alternative_names")

    @property
    @pulumi.getter(name="validFrom")
    def valid_from(self) -> Optional[builtins.str]:
        """
        (Output)
        X.509 notBefore validity period in milliseconds since epoch.
        """
        return pulumi.get(self, "valid_from")

    @property
    @pulumi.getter
    def version(self) -> Optional[builtins.int]:
        """
        (Output)
        X.509 version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class KeystoresAliasesPkcs12CertsInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certInfos":
            suggest = "cert_infos"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeystoresAliasesPkcs12CertsInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeystoresAliasesPkcs12CertsInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeystoresAliasesPkcs12CertsInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cert_infos: Optional[Sequence['outputs.KeystoresAliasesPkcs12CertsInfoCertInfo']] = None):
        """
        :param Sequence['KeystoresAliasesPkcs12CertsInfoCertInfoArgs'] cert_infos: (Output)
               List of all properties in the object.
               Structure is documented below.
        """
        if cert_infos is not None:
            pulumi.set(__self__, "cert_infos", cert_infos)

    @property
    @pulumi.getter(name="certInfos")
    def cert_infos(self) -> Optional[Sequence['outputs.KeystoresAliasesPkcs12CertsInfoCertInfo']]:
        """
        (Output)
        List of all properties in the object.
        Structure is documented below.
        """
        return pulumi.get(self, "cert_infos")


@pulumi.output_type
class KeystoresAliasesPkcs12CertsInfoCertInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "basicConstraints":
            suggest = "basic_constraints"
        elif key == "expiryDate":
            suggest = "expiry_date"
        elif key == "isValid":
            suggest = "is_valid"
        elif key == "publicKey":
            suggest = "public_key"
        elif key == "serialNumber":
            suggest = "serial_number"
        elif key == "sigAlgName":
            suggest = "sig_alg_name"
        elif key == "subjectAlternativeNames":
            suggest = "subject_alternative_names"
        elif key == "validFrom":
            suggest = "valid_from"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeystoresAliasesPkcs12CertsInfoCertInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeystoresAliasesPkcs12CertsInfoCertInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeystoresAliasesPkcs12CertsInfoCertInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 basic_constraints: Optional[builtins.str] = None,
                 expiry_date: Optional[builtins.str] = None,
                 is_valid: Optional[builtins.str] = None,
                 issuer: Optional[builtins.str] = None,
                 public_key: Optional[builtins.str] = None,
                 serial_number: Optional[builtins.str] = None,
                 sig_alg_name: Optional[builtins.str] = None,
                 subject: Optional[builtins.str] = None,
                 subject_alternative_names: Optional[Sequence[builtins.str]] = None,
                 valid_from: Optional[builtins.str] = None,
                 version: Optional[builtins.int] = None):
        """
        :param builtins.str basic_constraints: (Output)
               X.509 basic constraints extension.
        :param builtins.str expiry_date: (Output)
               X.509 notAfter validity period in milliseconds since epoch.
        :param builtins.str is_valid: (Output)
               Flag that specifies whether the certificate is valid.
               Flag is set to Yes if the certificate is valid, No if expired, or Not yet if not yet valid.
        :param builtins.str issuer: (Output)
               X.509 issuer.
        :param builtins.str public_key: (Output)
               Public key component of the X.509 subject public key info.
        :param builtins.str serial_number: (Output)
               X.509 serial number.
        :param builtins.str sig_alg_name: (Output)
               X.509 signatureAlgorithm.
        :param builtins.str subject: (Output)
               X.509 subject.
        :param Sequence[builtins.str] subject_alternative_names: (Output)
               X.509 subject alternative names (SANs) extension.
        :param builtins.str valid_from: (Output)
               X.509 notBefore validity period in milliseconds since epoch.
        :param builtins.int version: (Output)
               X.509 version.
        """
        if basic_constraints is not None:
            pulumi.set(__self__, "basic_constraints", basic_constraints)
        if expiry_date is not None:
            pulumi.set(__self__, "expiry_date", expiry_date)
        if is_valid is not None:
            pulumi.set(__self__, "is_valid", is_valid)
        if issuer is not None:
            pulumi.set(__self__, "issuer", issuer)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if serial_number is not None:
            pulumi.set(__self__, "serial_number", serial_number)
        if sig_alg_name is not None:
            pulumi.set(__self__, "sig_alg_name", sig_alg_name)
        if subject is not None:
            pulumi.set(__self__, "subject", subject)
        if subject_alternative_names is not None:
            pulumi.set(__self__, "subject_alternative_names", subject_alternative_names)
        if valid_from is not None:
            pulumi.set(__self__, "valid_from", valid_from)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="basicConstraints")
    def basic_constraints(self) -> Optional[builtins.str]:
        """
        (Output)
        X.509 basic constraints extension.
        """
        return pulumi.get(self, "basic_constraints")

    @property
    @pulumi.getter(name="expiryDate")
    def expiry_date(self) -> Optional[builtins.str]:
        """
        (Output)
        X.509 notAfter validity period in milliseconds since epoch.
        """
        return pulumi.get(self, "expiry_date")

    @property
    @pulumi.getter(name="isValid")
    def is_valid(self) -> Optional[builtins.str]:
        """
        (Output)
        Flag that specifies whether the certificate is valid.
        Flag is set to Yes if the certificate is valid, No if expired, or Not yet if not yet valid.
        """
        return pulumi.get(self, "is_valid")

    @property
    @pulumi.getter
    def issuer(self) -> Optional[builtins.str]:
        """
        (Output)
        X.509 issuer.
        """
        return pulumi.get(self, "issuer")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[builtins.str]:
        """
        (Output)
        Public key component of the X.509 subject public key info.
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> Optional[builtins.str]:
        """
        (Output)
        X.509 serial number.
        """
        return pulumi.get(self, "serial_number")

    @property
    @pulumi.getter(name="sigAlgName")
    def sig_alg_name(self) -> Optional[builtins.str]:
        """
        (Output)
        X.509 signatureAlgorithm.
        """
        return pulumi.get(self, "sig_alg_name")

    @property
    @pulumi.getter
    def subject(self) -> Optional[builtins.str]:
        """
        (Output)
        X.509 subject.
        """
        return pulumi.get(self, "subject")

    @property
    @pulumi.getter(name="subjectAlternativeNames")
    def subject_alternative_names(self) -> Optional[Sequence[builtins.str]]:
        """
        (Output)
        X.509 subject alternative names (SANs) extension.
        """
        return pulumi.get(self, "subject_alternative_names")

    @property
    @pulumi.getter(name="validFrom")
    def valid_from(self) -> Optional[builtins.str]:
        """
        (Output)
        X.509 notBefore validity period in milliseconds since epoch.
        """
        return pulumi.get(self, "valid_from")

    @property
    @pulumi.getter
    def version(self) -> Optional[builtins.int]:
        """
        (Output)
        X.509 version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class KeystoresAliasesSelfSignedCertCertsInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certInfos":
            suggest = "cert_infos"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeystoresAliasesSelfSignedCertCertsInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeystoresAliasesSelfSignedCertCertsInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeystoresAliasesSelfSignedCertCertsInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cert_infos: Optional[Sequence['outputs.KeystoresAliasesSelfSignedCertCertsInfoCertInfo']] = None):
        """
        :param Sequence['KeystoresAliasesSelfSignedCertCertsInfoCertInfoArgs'] cert_infos: (Output)
               List of all properties in the object.
               Structure is documented below.
        """
        if cert_infos is not None:
            pulumi.set(__self__, "cert_infos", cert_infos)

    @property
    @pulumi.getter(name="certInfos")
    def cert_infos(self) -> Optional[Sequence['outputs.KeystoresAliasesSelfSignedCertCertsInfoCertInfo']]:
        """
        (Output)
        List of all properties in the object.
        Structure is documented below.
        """
        return pulumi.get(self, "cert_infos")


@pulumi.output_type
class KeystoresAliasesSelfSignedCertCertsInfoCertInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "basicConstraints":
            suggest = "basic_constraints"
        elif key == "expiryDate":
            suggest = "expiry_date"
        elif key == "isValid":
            suggest = "is_valid"
        elif key == "publicKey":
            suggest = "public_key"
        elif key == "serialNumber":
            suggest = "serial_number"
        elif key == "sigAlgName":
            suggest = "sig_alg_name"
        elif key == "subjectAlternativeNames":
            suggest = "subject_alternative_names"
        elif key == "validFrom":
            suggest = "valid_from"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeystoresAliasesSelfSignedCertCertsInfoCertInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeystoresAliasesSelfSignedCertCertsInfoCertInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeystoresAliasesSelfSignedCertCertsInfoCertInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 basic_constraints: Optional[builtins.str] = None,
                 expiry_date: Optional[builtins.str] = None,
                 is_valid: Optional[builtins.str] = None,
                 issuer: Optional[builtins.str] = None,
                 public_key: Optional[builtins.str] = None,
                 serial_number: Optional[builtins.str] = None,
                 sig_alg_name: Optional[builtins.str] = None,
                 subject: Optional[builtins.str] = None,
                 subject_alternative_names: Optional[Sequence[builtins.str]] = None,
                 valid_from: Optional[builtins.str] = None,
                 version: Optional[builtins.int] = None):
        """
        :param builtins.str basic_constraints: (Output)
               X.509 basic constraints extension.
        :param builtins.str expiry_date: (Output)
               X.509 notAfter validity period in milliseconds since epoch.
        :param builtins.str is_valid: (Output)
               Flag that specifies whether the certificate is valid.
               Flag is set to Yes if the certificate is valid, No if expired, or Not yet if not yet valid.
        :param builtins.str issuer: (Output)
               X.509 issuer.
        :param builtins.str public_key: (Output)
               Public key component of the X.509 subject public key info.
        :param builtins.str serial_number: (Output)
               X.509 serial number.
        :param builtins.str sig_alg_name: (Output)
               X.509 signatureAlgorithm.
        :param builtins.str subject: Subject details.
               Structure is documented below.
        :param Sequence[builtins.str] subject_alternative_names: (Output)
               X.509 subject alternative names (SANs) extension.
        :param builtins.str valid_from: (Output)
               X.509 notBefore validity period in milliseconds since epoch.
        :param builtins.int version: (Output)
               X.509 version.
        """
        if basic_constraints is not None:
            pulumi.set(__self__, "basic_constraints", basic_constraints)
        if expiry_date is not None:
            pulumi.set(__self__, "expiry_date", expiry_date)
        if is_valid is not None:
            pulumi.set(__self__, "is_valid", is_valid)
        if issuer is not None:
            pulumi.set(__self__, "issuer", issuer)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if serial_number is not None:
            pulumi.set(__self__, "serial_number", serial_number)
        if sig_alg_name is not None:
            pulumi.set(__self__, "sig_alg_name", sig_alg_name)
        if subject is not None:
            pulumi.set(__self__, "subject", subject)
        if subject_alternative_names is not None:
            pulumi.set(__self__, "subject_alternative_names", subject_alternative_names)
        if valid_from is not None:
            pulumi.set(__self__, "valid_from", valid_from)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="basicConstraints")
    def basic_constraints(self) -> Optional[builtins.str]:
        """
        (Output)
        X.509 basic constraints extension.
        """
        return pulumi.get(self, "basic_constraints")

    @property
    @pulumi.getter(name="expiryDate")
    def expiry_date(self) -> Optional[builtins.str]:
        """
        (Output)
        X.509 notAfter validity period in milliseconds since epoch.
        """
        return pulumi.get(self, "expiry_date")

    @property
    @pulumi.getter(name="isValid")
    def is_valid(self) -> Optional[builtins.str]:
        """
        (Output)
        Flag that specifies whether the certificate is valid.
        Flag is set to Yes if the certificate is valid, No if expired, or Not yet if not yet valid.
        """
        return pulumi.get(self, "is_valid")

    @property
    @pulumi.getter
    def issuer(self) -> Optional[builtins.str]:
        """
        (Output)
        X.509 issuer.
        """
        return pulumi.get(self, "issuer")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[builtins.str]:
        """
        (Output)
        Public key component of the X.509 subject public key info.
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> Optional[builtins.str]:
        """
        (Output)
        X.509 serial number.
        """
        return pulumi.get(self, "serial_number")

    @property
    @pulumi.getter(name="sigAlgName")
    def sig_alg_name(self) -> Optional[builtins.str]:
        """
        (Output)
        X.509 signatureAlgorithm.
        """
        return pulumi.get(self, "sig_alg_name")

    @property
    @pulumi.getter
    def subject(self) -> Optional[builtins.str]:
        """
        Subject details.
        Structure is documented below.
        """
        return pulumi.get(self, "subject")

    @property
    @pulumi.getter(name="subjectAlternativeNames")
    def subject_alternative_names(self) -> Optional[Sequence[builtins.str]]:
        """
        (Output)
        X.509 subject alternative names (SANs) extension.
        """
        return pulumi.get(self, "subject_alternative_names")

    @property
    @pulumi.getter(name="validFrom")
    def valid_from(self) -> Optional[builtins.str]:
        """
        (Output)
        X.509 notBefore validity period in milliseconds since epoch.
        """
        return pulumi.get(self, "valid_from")

    @property
    @pulumi.getter
    def version(self) -> Optional[builtins.int]:
        """
        (Output)
        X.509 version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class KeystoresAliasesSelfSignedCertSubject(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "commonName":
            suggest = "common_name"
        elif key == "countryCode":
            suggest = "country_code"
        elif key == "orgUnit":
            suggest = "org_unit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeystoresAliasesSelfSignedCertSubject. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeystoresAliasesSelfSignedCertSubject.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeystoresAliasesSelfSignedCertSubject.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 common_name: Optional[builtins.str] = None,
                 country_code: Optional[builtins.str] = None,
                 email: Optional[builtins.str] = None,
                 locality: Optional[builtins.str] = None,
                 org: Optional[builtins.str] = None,
                 org_unit: Optional[builtins.str] = None,
                 state: Optional[builtins.str] = None):
        """
        :param builtins.str common_name: Common name of the organization. Maximum length is 64 characters.
        :param builtins.str country_code: Two-letter country code. Example, IN for India, US for United States of America.
        :param builtins.str email: Email address. Max 255 characters.
        :param builtins.str locality: City or town name. Maximum length is 128 characters.
        :param builtins.str org: Organization name. Maximum length is 64 characters.
        :param builtins.str org_unit: Organization team name. Maximum length is 64 characters.
        :param builtins.str state: State or district name. Maximum length is 128 characters.
        """
        if common_name is not None:
            pulumi.set(__self__, "common_name", common_name)
        if country_code is not None:
            pulumi.set(__self__, "country_code", country_code)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if locality is not None:
            pulumi.set(__self__, "locality", locality)
        if org is not None:
            pulumi.set(__self__, "org", org)
        if org_unit is not None:
            pulumi.set(__self__, "org_unit", org_unit)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> Optional[builtins.str]:
        """
        Common name of the organization. Maximum length is 64 characters.
        """
        return pulumi.get(self, "common_name")

    @property
    @pulumi.getter(name="countryCode")
    def country_code(self) -> Optional[builtins.str]:
        """
        Two-letter country code. Example, IN for India, US for United States of America.
        """
        return pulumi.get(self, "country_code")

    @property
    @pulumi.getter
    def email(self) -> Optional[builtins.str]:
        """
        Email address. Max 255 characters.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def locality(self) -> Optional[builtins.str]:
        """
        City or town name. Maximum length is 128 characters.
        """
        return pulumi.get(self, "locality")

    @property
    @pulumi.getter
    def org(self) -> Optional[builtins.str]:
        """
        Organization name. Maximum length is 64 characters.
        """
        return pulumi.get(self, "org")

    @property
    @pulumi.getter(name="orgUnit")
    def org_unit(self) -> Optional[builtins.str]:
        """
        Organization team name. Maximum length is 64 characters.
        """
        return pulumi.get(self, "org_unit")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        State or district name. Maximum length is 128 characters.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class KeystoresAliasesSelfSignedCertSubjectAlternativeDnsNames(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subjectAlternativeName":
            suggest = "subject_alternative_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeystoresAliasesSelfSignedCertSubjectAlternativeDnsNames. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeystoresAliasesSelfSignedCertSubjectAlternativeDnsNames.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeystoresAliasesSelfSignedCertSubjectAlternativeDnsNames.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subject_alternative_name: Optional[builtins.str] = None):
        """
        :param builtins.str subject_alternative_name: Subject Alternative Name
        """
        if subject_alternative_name is not None:
            pulumi.set(__self__, "subject_alternative_name", subject_alternative_name)

    @property
    @pulumi.getter(name="subjectAlternativeName")
    def subject_alternative_name(self) -> Optional[builtins.str]:
        """
        Subject Alternative Name
        """
        return pulumi.get(self, "subject_alternative_name")


@pulumi.output_type
class OrganizationProperties(dict):
    def __init__(__self__, *,
                 properties: Optional[Sequence['outputs.OrganizationPropertiesProperty']] = None):
        """
        :param Sequence['OrganizationPropertiesPropertyArgs'] properties: List of all properties in the object.
               Structure is documented below.
        """
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter
    def properties(self) -> Optional[Sequence['outputs.OrganizationPropertiesProperty']]:
        """
        List of all properties in the object.
        Structure is documented below.
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class OrganizationPropertiesProperty(dict):
    def __init__(__self__, *,
                 name: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        """
        :param builtins.str name: Name of the property.
        :param builtins.str value: Value of the property.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Name of the property.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        """
        Value of the property.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class SecurityMonitoringConditionIncludeAllResources(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class SecurityProfileV2ProfileAssessmentConfig(dict):
    def __init__(__self__, *,
                 assessment: builtins.str,
                 weight: builtins.str):
        """
        :param builtins.str assessment: The identifier for this object. Format specified above.
        :param builtins.str weight: The weight of the assessment.
               Possible values are: `MINOR`, `MODERATE`, `MAJOR`.
        """
        pulumi.set(__self__, "assessment", assessment)
        pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter
    def assessment(self) -> builtins.str:
        """
        The identifier for this object. Format specified above.
        """
        return pulumi.get(self, "assessment")

    @property
    @pulumi.getter
    def weight(self) -> builtins.str:
        """
        The weight of the assessment.
        Possible values are: `MINOR`, `MODERATE`, `MAJOR`.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class SharedflowMetaData(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "subType":
            suggest = "sub_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SharedflowMetaData. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SharedflowMetaData.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SharedflowMetaData.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[builtins.str] = None,
                 last_modified_at: Optional[builtins.str] = None,
                 sub_type: Optional[builtins.str] = None):
        """
        :param builtins.str created_at: Time at which the API proxy was created, in milliseconds since epoch.
        :param builtins.str last_modified_at: Time at which the API proxy was most recently modified, in milliseconds since epoch.
        :param builtins.str sub_type: The type of entity described
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if sub_type is not None:
            pulumi.set(__self__, "sub_type", sub_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[builtins.str]:
        """
        Time at which the API proxy was created, in milliseconds since epoch.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[builtins.str]:
        """
        Time at which the API proxy was most recently modified, in milliseconds since epoch.
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="subType")
    def sub_type(self) -> Optional[builtins.str]:
        """
        The type of entity described
        """
        return pulumi.get(self, "sub_type")


@pulumi.output_type
class TargetServerSSlInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientAuthEnabled":
            suggest = "client_auth_enabled"
        elif key == "commonName":
            suggest = "common_name"
        elif key == "ignoreValidationErrors":
            suggest = "ignore_validation_errors"
        elif key == "keyAlias":
            suggest = "key_alias"
        elif key == "keyStore":
            suggest = "key_store"
        elif key == "trustStore":
            suggest = "trust_store"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TargetServerSSlInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TargetServerSSlInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TargetServerSSlInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: builtins.bool,
                 ciphers: Optional[Sequence[builtins.str]] = None,
                 client_auth_enabled: Optional[builtins.bool] = None,
                 common_name: Optional['outputs.TargetServerSSlInfoCommonName'] = None,
                 enforce: Optional[builtins.bool] = None,
                 ignore_validation_errors: Optional[builtins.bool] = None,
                 key_alias: Optional[builtins.str] = None,
                 key_store: Optional[builtins.str] = None,
                 protocols: Optional[Sequence[builtins.str]] = None,
                 trust_store: Optional[builtins.str] = None):
        """
        :param builtins.bool enabled: Enables TLS. If false, neither one-way nor two-way TLS will be enabled.
        :param Sequence[builtins.str] ciphers: The SSL/TLS cipher suites to be used. For programmable proxies, it must be one of the cipher suite names listed in: http://docs.oracle.com/javase/8/docs/technotes/guides/security/StandardNames.html#ciphersuites. For configurable proxies, it must follow the configuration specified in: https://commondatastorage.googleapis.com/chromium-boringssl-docs/ssl.h.html#Cipher-suite-configuration. This setting has no effect for configurable proxies when negotiating TLS 1.3.
        :param builtins.bool client_auth_enabled: Enables two-way TLS.
        :param 'TargetServerSSlInfoCommonNameArgs' common_name: The TLS Common Name of the certificate.
               Structure is documented below.
        :param builtins.bool enforce: If true, TLS is strictly enforced.
        :param builtins.bool ignore_validation_errors: If true, Edge ignores TLS certificate errors. Valid when configuring TLS for target servers and target endpoints, and when configuring virtual hosts that use 2-way TLS. When used with a target endpoint/target server, if the backend system uses SNI and returns a cert with a subject Distinguished Name (DN) that does not match the hostname, there is no way to ignore the error and the connection fails.
        :param builtins.str key_alias: Required if clientAuthEnabled is true. The resource ID for the alias containing the private key and cert.
        :param builtins.str key_store: Required if clientAuthEnabled is true. The resource ID of the keystore.
        :param Sequence[builtins.str] protocols: The TLS versioins to be used.
        :param builtins.str trust_store: The resource ID of the truststore.
        """
        pulumi.set(__self__, "enabled", enabled)
        if ciphers is not None:
            pulumi.set(__self__, "ciphers", ciphers)
        if client_auth_enabled is not None:
            pulumi.set(__self__, "client_auth_enabled", client_auth_enabled)
        if common_name is not None:
            pulumi.set(__self__, "common_name", common_name)
        if enforce is not None:
            pulumi.set(__self__, "enforce", enforce)
        if ignore_validation_errors is not None:
            pulumi.set(__self__, "ignore_validation_errors", ignore_validation_errors)
        if key_alias is not None:
            pulumi.set(__self__, "key_alias", key_alias)
        if key_store is not None:
            pulumi.set(__self__, "key_store", key_store)
        if protocols is not None:
            pulumi.set(__self__, "protocols", protocols)
        if trust_store is not None:
            pulumi.set(__self__, "trust_store", trust_store)

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        Enables TLS. If false, neither one-way nor two-way TLS will be enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def ciphers(self) -> Optional[Sequence[builtins.str]]:
        """
        The SSL/TLS cipher suites to be used. For programmable proxies, it must be one of the cipher suite names listed in: http://docs.oracle.com/javase/8/docs/technotes/guides/security/StandardNames.html#ciphersuites. For configurable proxies, it must follow the configuration specified in: https://commondatastorage.googleapis.com/chromium-boringssl-docs/ssl.h.html#Cipher-suite-configuration. This setting has no effect for configurable proxies when negotiating TLS 1.3.
        """
        return pulumi.get(self, "ciphers")

    @property
    @pulumi.getter(name="clientAuthEnabled")
    def client_auth_enabled(self) -> Optional[builtins.bool]:
        """
        Enables two-way TLS.
        """
        return pulumi.get(self, "client_auth_enabled")

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> Optional['outputs.TargetServerSSlInfoCommonName']:
        """
        The TLS Common Name of the certificate.
        Structure is documented below.
        """
        return pulumi.get(self, "common_name")

    @property
    @pulumi.getter
    def enforce(self) -> Optional[builtins.bool]:
        """
        If true, TLS is strictly enforced.
        """
        return pulumi.get(self, "enforce")

    @property
    @pulumi.getter(name="ignoreValidationErrors")
    def ignore_validation_errors(self) -> Optional[builtins.bool]:
        """
        If true, Edge ignores TLS certificate errors. Valid when configuring TLS for target servers and target endpoints, and when configuring virtual hosts that use 2-way TLS. When used with a target endpoint/target server, if the backend system uses SNI and returns a cert with a subject Distinguished Name (DN) that does not match the hostname, there is no way to ignore the error and the connection fails.
        """
        return pulumi.get(self, "ignore_validation_errors")

    @property
    @pulumi.getter(name="keyAlias")
    def key_alias(self) -> Optional[builtins.str]:
        """
        Required if clientAuthEnabled is true. The resource ID for the alias containing the private key and cert.
        """
        return pulumi.get(self, "key_alias")

    @property
    @pulumi.getter(name="keyStore")
    def key_store(self) -> Optional[builtins.str]:
        """
        Required if clientAuthEnabled is true. The resource ID of the keystore.
        """
        return pulumi.get(self, "key_store")

    @property
    @pulumi.getter
    def protocols(self) -> Optional[Sequence[builtins.str]]:
        """
        The TLS versioins to be used.
        """
        return pulumi.get(self, "protocols")

    @property
    @pulumi.getter(name="trustStore")
    def trust_store(self) -> Optional[builtins.str]:
        """
        The resource ID of the truststore.
        """
        return pulumi.get(self, "trust_store")


@pulumi.output_type
class TargetServerSSlInfoCommonName(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "wildcardMatch":
            suggest = "wildcard_match"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TargetServerSSlInfoCommonName. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TargetServerSSlInfoCommonName.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TargetServerSSlInfoCommonName.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 value: Optional[builtins.str] = None,
                 wildcard_match: Optional[builtins.bool] = None):
        """
        :param builtins.str value: The TLS Common Name string of the certificate.
        :param builtins.bool wildcard_match: Indicates whether the cert should be matched against as a wildcard cert.
        """
        if value is not None:
            pulumi.set(__self__, "value", value)
        if wildcard_match is not None:
            pulumi.set(__self__, "wildcard_match", wildcard_match)

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        """
        The TLS Common Name string of the certificate.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="wildcardMatch")
    def wildcard_match(self) -> Optional[builtins.bool]:
        """
        Indicates whether the cert should be matched against as a wildcard cert.
        """
        return pulumi.get(self, "wildcard_match")


