# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WorkloadArgs', 'Workload']

@pulumi.input_type
class WorkloadArgs:
    def __init__(__self__, *,
                 application_id: pulumi.Input[builtins.str],
                 discovered_workload: pulumi.Input[builtins.str],
                 location: pulumi.Input[builtins.str],
                 workload_id: pulumi.Input[builtins.str],
                 attributes: Optional[pulumi.Input['WorkloadAttributesArgs']] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Workload resource.
        :param pulumi.Input[builtins.str] application_id: Part of `parent`.  Full resource name of a parent Application. Example: projects/{HOST_PROJECT_ID}/locations/{LOCATION}/applications/{APPLICATION_ID}
        :param pulumi.Input[builtins.str] discovered_workload: Immutable. The resource name of the original discovered workload.
        :param pulumi.Input[builtins.str] location: Part of `parent`.  Full resource name of a parent Application. Example: projects/{HOST_PROJECT_ID}/locations/{LOCATION}/applications/{APPLICATION_ID}
        :param pulumi.Input[builtins.str] workload_id: The Workload identifier.
        :param pulumi.Input['WorkloadAttributesArgs'] attributes: Consumer provided attributes.
               Structure is documented below.
        :param pulumi.Input[builtins.str] description: User-defined description of a Workload.
        :param pulumi.Input[builtins.str] display_name: User-defined name for the Workload.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "application_id", application_id)
        pulumi.set(__self__, "discovered_workload", discovered_workload)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "workload_id", workload_id)
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Input[builtins.str]:
        """
        Part of `parent`.  Full resource name of a parent Application. Example: projects/{HOST_PROJECT_ID}/locations/{LOCATION}/applications/{APPLICATION_ID}
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "application_id", value)

    @property
    @pulumi.getter(name="discoveredWorkload")
    def discovered_workload(self) -> pulumi.Input[builtins.str]:
        """
        Immutable. The resource name of the original discovered workload.
        """
        return pulumi.get(self, "discovered_workload")

    @discovered_workload.setter
    def discovered_workload(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "discovered_workload", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        Part of `parent`.  Full resource name of a parent Application. Example: projects/{HOST_PROJECT_ID}/locations/{LOCATION}/applications/{APPLICATION_ID}
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="workloadId")
    def workload_id(self) -> pulumi.Input[builtins.str]:
        """
        The Workload identifier.
        """
        return pulumi.get(self, "workload_id")

    @workload_id.setter
    def workload_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "workload_id", value)

    @property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input['WorkloadAttributesArgs']]:
        """
        Consumer provided attributes.
        Structure is documented below.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input['WorkloadAttributesArgs']]):
        pulumi.set(self, "attributes", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User-defined description of a Workload.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User-defined name for the Workload.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _WorkloadState:
    def __init__(__self__, *,
                 application_id: Optional[pulumi.Input[builtins.str]] = None,
                 attributes: Optional[pulumi.Input['WorkloadAttributesArgs']] = None,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 discovered_workload: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 uid: Optional[pulumi.Input[builtins.str]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None,
                 workload_id: Optional[pulumi.Input[builtins.str]] = None,
                 workload_properties: Optional[pulumi.Input[Sequence[pulumi.Input['WorkloadWorkloadPropertyArgs']]]] = None,
                 workload_references: Optional[pulumi.Input[Sequence[pulumi.Input['WorkloadWorkloadReferenceArgs']]]] = None):
        """
        Input properties used for looking up and filtering Workload resources.
        :param pulumi.Input[builtins.str] application_id: Part of `parent`.  Full resource name of a parent Application. Example: projects/{HOST_PROJECT_ID}/locations/{LOCATION}/applications/{APPLICATION_ID}
        :param pulumi.Input['WorkloadAttributesArgs'] attributes: Consumer provided attributes.
               Structure is documented below.
        :param pulumi.Input[builtins.str] create_time: Output only. Create time.
        :param pulumi.Input[builtins.str] description: User-defined description of a Workload.
        :param pulumi.Input[builtins.str] discovered_workload: Immutable. The resource name of the original discovered workload.
        :param pulumi.Input[builtins.str] display_name: User-defined name for the Workload.
        :param pulumi.Input[builtins.str] location: Part of `parent`.  Full resource name of a parent Application. Example: projects/{HOST_PROJECT_ID}/locations/{LOCATION}/applications/{APPLICATION_ID}
        :param pulumi.Input[builtins.str] name: Identifier. The resource name of the Workload. Format:"projects/{host-project-id}/locations/{location}/applications/{application-id}/workloads/{workload-id}"
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] state: Output only. Workload state. Possible values:  STATE_UNSPECIFIED CREATING ACTIVE DELETING DETACHED
        :param pulumi.Input[builtins.str] uid: Output only. A universally unique identifier (UUID) for the `Workload` in the UUID4 format.
        :param pulumi.Input[builtins.str] update_time: Output only. Update time.
        :param pulumi.Input[builtins.str] workload_id: The Workload identifier.
        :param pulumi.Input[Sequence[pulumi.Input['WorkloadWorkloadPropertyArgs']]] workload_properties: Properties of an underlying compute resource represented by the Workload.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['WorkloadWorkloadReferenceArgs']]] workload_references: Reference of an underlying compute resource represented by the Workload.
               Structure is documented below.
        """
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if discovered_workload is not None:
            pulumi.set(__self__, "discovered_workload", discovered_workload)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if workload_id is not None:
            pulumi.set(__self__, "workload_id", workload_id)
        if workload_properties is not None:
            pulumi.set(__self__, "workload_properties", workload_properties)
        if workload_references is not None:
            pulumi.set(__self__, "workload_references", workload_references)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Part of `parent`.  Full resource name of a parent Application. Example: projects/{HOST_PROJECT_ID}/locations/{LOCATION}/applications/{APPLICATION_ID}
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "application_id", value)

    @property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input['WorkloadAttributesArgs']]:
        """
        Consumer provided attributes.
        Structure is documented below.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input['WorkloadAttributesArgs']]):
        pulumi.set(self, "attributes", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. Create time.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User-defined description of a Workload.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="discoveredWorkload")
    def discovered_workload(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Immutable. The resource name of the original discovered workload.
        """
        return pulumi.get(self, "discovered_workload")

    @discovered_workload.setter
    def discovered_workload(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "discovered_workload", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User-defined name for the Workload.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Part of `parent`.  Full resource name of a parent Application. Example: projects/{HOST_PROJECT_ID}/locations/{LOCATION}/applications/{APPLICATION_ID}
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier. The resource name of the Workload. Format:"projects/{host-project-id}/locations/{location}/applications/{application-id}/workloads/{workload-id}"
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. Workload state. Possible values:  STATE_UNSPECIFIED CREATING ACTIVE DELETING DETACHED
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. A universally unique identifier (UUID) for the `Workload` in the UUID4 format.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "uid", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. Update time.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)

    @property
    @pulumi.getter(name="workloadId")
    def workload_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Workload identifier.
        """
        return pulumi.get(self, "workload_id")

    @workload_id.setter
    def workload_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "workload_id", value)

    @property
    @pulumi.getter(name="workloadProperties")
    def workload_properties(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkloadWorkloadPropertyArgs']]]]:
        """
        Properties of an underlying compute resource represented by the Workload.
        Structure is documented below.
        """
        return pulumi.get(self, "workload_properties")

    @workload_properties.setter
    def workload_properties(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkloadWorkloadPropertyArgs']]]]):
        pulumi.set(self, "workload_properties", value)

    @property
    @pulumi.getter(name="workloadReferences")
    def workload_references(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkloadWorkloadReferenceArgs']]]]:
        """
        Reference of an underlying compute resource represented by the Workload.
        Structure is documented below.
        """
        return pulumi.get(self, "workload_references")

    @workload_references.setter
    def workload_references(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkloadWorkloadReferenceArgs']]]]):
        pulumi.set(self, "workload_references", value)


@pulumi.type_token("gcp:apphub/workload:Workload")
class Workload(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_id: Optional[pulumi.Input[builtins.str]] = None,
                 attributes: Optional[pulumi.Input[Union['WorkloadAttributesArgs', 'WorkloadAttributesArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 discovered_workload: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 workload_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Workload represents a binary deployment (such as Managed Instance Groups (MIGs), GKE deployments, etc.) that performs the smallest logical subset of business functionality. It registers identified workload to the Application.

        ## Example Usage

        ## Import

        Workload can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/applications/{{application_id}}/workloads/{{workload_id}}`

        * `{{project}}/{{location}}/{{application_id}}/{{workload_id}}`

        * `{{location}}/{{application_id}}/{{workload_id}}`

        When using the `pulumi import` command, Workload can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:apphub/workload:Workload default projects/{{project}}/locations/{{location}}/applications/{{application_id}}/workloads/{{workload_id}}
        ```

        ```sh
        $ pulumi import gcp:apphub/workload:Workload default {{project}}/{{location}}/{{application_id}}/{{workload_id}}
        ```

        ```sh
        $ pulumi import gcp:apphub/workload:Workload default {{location}}/{{application_id}}/{{workload_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] application_id: Part of `parent`.  Full resource name of a parent Application. Example: projects/{HOST_PROJECT_ID}/locations/{LOCATION}/applications/{APPLICATION_ID}
        :param pulumi.Input[Union['WorkloadAttributesArgs', 'WorkloadAttributesArgsDict']] attributes: Consumer provided attributes.
               Structure is documented below.
        :param pulumi.Input[builtins.str] description: User-defined description of a Workload.
        :param pulumi.Input[builtins.str] discovered_workload: Immutable. The resource name of the original discovered workload.
        :param pulumi.Input[builtins.str] display_name: User-defined name for the Workload.
        :param pulumi.Input[builtins.str] location: Part of `parent`.  Full resource name of a parent Application. Example: projects/{HOST_PROJECT_ID}/locations/{LOCATION}/applications/{APPLICATION_ID}
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] workload_id: The Workload identifier.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkloadArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Workload represents a binary deployment (such as Managed Instance Groups (MIGs), GKE deployments, etc.) that performs the smallest logical subset of business functionality. It registers identified workload to the Application.

        ## Example Usage

        ## Import

        Workload can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/applications/{{application_id}}/workloads/{{workload_id}}`

        * `{{project}}/{{location}}/{{application_id}}/{{workload_id}}`

        * `{{location}}/{{application_id}}/{{workload_id}}`

        When using the `pulumi import` command, Workload can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:apphub/workload:Workload default projects/{{project}}/locations/{{location}}/applications/{{application_id}}/workloads/{{workload_id}}
        ```

        ```sh
        $ pulumi import gcp:apphub/workload:Workload default {{project}}/{{location}}/{{application_id}}/{{workload_id}}
        ```

        ```sh
        $ pulumi import gcp:apphub/workload:Workload default {{location}}/{{application_id}}/{{workload_id}}
        ```

        :param str resource_name: The name of the resource.
        :param WorkloadArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkloadArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_id: Optional[pulumi.Input[builtins.str]] = None,
                 attributes: Optional[pulumi.Input[Union['WorkloadAttributesArgs', 'WorkloadAttributesArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 discovered_workload: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 workload_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkloadArgs.__new__(WorkloadArgs)

            if application_id is None and not opts.urn:
                raise TypeError("Missing required property 'application_id'")
            __props__.__dict__["application_id"] = application_id
            __props__.__dict__["attributes"] = attributes
            __props__.__dict__["description"] = description
            if discovered_workload is None and not opts.urn:
                raise TypeError("Missing required property 'discovered_workload'")
            __props__.__dict__["discovered_workload"] = discovered_workload
            __props__.__dict__["display_name"] = display_name
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            if workload_id is None and not opts.urn:
                raise TypeError("Missing required property 'workload_id'")
            __props__.__dict__["workload_id"] = workload_id
            __props__.__dict__["create_time"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["update_time"] = None
            __props__.__dict__["workload_properties"] = None
            __props__.__dict__["workload_references"] = None
        super(Workload, __self__).__init__(
            'gcp:apphub/workload:Workload',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_id: Optional[pulumi.Input[builtins.str]] = None,
            attributes: Optional[pulumi.Input[Union['WorkloadAttributesArgs', 'WorkloadAttributesArgsDict']]] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            discovered_workload: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            uid: Optional[pulumi.Input[builtins.str]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None,
            workload_id: Optional[pulumi.Input[builtins.str]] = None,
            workload_properties: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkloadWorkloadPropertyArgs', 'WorkloadWorkloadPropertyArgsDict']]]]] = None,
            workload_references: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkloadWorkloadReferenceArgs', 'WorkloadWorkloadReferenceArgsDict']]]]] = None) -> 'Workload':
        """
        Get an existing Workload resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] application_id: Part of `parent`.  Full resource name of a parent Application. Example: projects/{HOST_PROJECT_ID}/locations/{LOCATION}/applications/{APPLICATION_ID}
        :param pulumi.Input[Union['WorkloadAttributesArgs', 'WorkloadAttributesArgsDict']] attributes: Consumer provided attributes.
               Structure is documented below.
        :param pulumi.Input[builtins.str] create_time: Output only. Create time.
        :param pulumi.Input[builtins.str] description: User-defined description of a Workload.
        :param pulumi.Input[builtins.str] discovered_workload: Immutable. The resource name of the original discovered workload.
        :param pulumi.Input[builtins.str] display_name: User-defined name for the Workload.
        :param pulumi.Input[builtins.str] location: Part of `parent`.  Full resource name of a parent Application. Example: projects/{HOST_PROJECT_ID}/locations/{LOCATION}/applications/{APPLICATION_ID}
        :param pulumi.Input[builtins.str] name: Identifier. The resource name of the Workload. Format:"projects/{host-project-id}/locations/{location}/applications/{application-id}/workloads/{workload-id}"
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] state: Output only. Workload state. Possible values:  STATE_UNSPECIFIED CREATING ACTIVE DELETING DETACHED
        :param pulumi.Input[builtins.str] uid: Output only. A universally unique identifier (UUID) for the `Workload` in the UUID4 format.
        :param pulumi.Input[builtins.str] update_time: Output only. Update time.
        :param pulumi.Input[builtins.str] workload_id: The Workload identifier.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkloadWorkloadPropertyArgs', 'WorkloadWorkloadPropertyArgsDict']]]] workload_properties: Properties of an underlying compute resource represented by the Workload.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkloadWorkloadReferenceArgs', 'WorkloadWorkloadReferenceArgsDict']]]] workload_references: Reference of an underlying compute resource represented by the Workload.
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WorkloadState.__new__(_WorkloadState)

        __props__.__dict__["application_id"] = application_id
        __props__.__dict__["attributes"] = attributes
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["discovered_workload"] = discovered_workload
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["state"] = state
        __props__.__dict__["uid"] = uid
        __props__.__dict__["update_time"] = update_time
        __props__.__dict__["workload_id"] = workload_id
        __props__.__dict__["workload_properties"] = workload_properties
        __props__.__dict__["workload_references"] = workload_references
        return Workload(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Output[builtins.str]:
        """
        Part of `parent`.  Full resource name of a parent Application. Example: projects/{HOST_PROJECT_ID}/locations/{LOCATION}/applications/{APPLICATION_ID}
        """
        return pulumi.get(self, "application_id")

    @property
    @pulumi.getter
    def attributes(self) -> pulumi.Output[Optional['outputs.WorkloadAttributes']]:
        """
        Consumer provided attributes.
        Structure is documented below.
        """
        return pulumi.get(self, "attributes")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        Output only. Create time.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        User-defined description of a Workload.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="discoveredWorkload")
    def discovered_workload(self) -> pulumi.Output[builtins.str]:
        """
        Immutable. The resource name of the original discovered workload.
        """
        return pulumi.get(self, "discovered_workload")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        User-defined name for the Workload.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        Part of `parent`.  Full resource name of a parent Application. Example: projects/{HOST_PROJECT_ID}/locations/{LOCATION}/applications/{APPLICATION_ID}
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Identifier. The resource name of the Workload. Format:"projects/{host-project-id}/locations/{location}/applications/{application-id}/workloads/{workload-id}"
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        Output only. Workload state. Possible values:  STATE_UNSPECIFIED CREATING ACTIVE DELETING DETACHED
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Output[builtins.str]:
        """
        Output only. A universally unique identifier (UUID) for the `Workload` in the UUID4 format.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        Output only. Update time.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter(name="workloadId")
    def workload_id(self) -> pulumi.Output[builtins.str]:
        """
        The Workload identifier.
        """
        return pulumi.get(self, "workload_id")

    @property
    @pulumi.getter(name="workloadProperties")
    def workload_properties(self) -> pulumi.Output[Sequence['outputs.WorkloadWorkloadProperty']]:
        """
        Properties of an underlying compute resource represented by the Workload.
        Structure is documented below.
        """
        return pulumi.get(self, "workload_properties")

    @property
    @pulumi.getter(name="workloadReferences")
    def workload_references(self) -> pulumi.Output[Sequence['outputs.WorkloadWorkloadReference']]:
        """
        Reference of an underlying compute resource represented by the Workload.
        Structure is documented below.
        """
        return pulumi.get(self, "workload_references")

