# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AuthConfigArgs', 'AuthConfig']

@pulumi.input_type
class AuthConfigArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[builtins.str],
                 location: pulumi.Input[builtins.str],
                 client_certificate: Optional[pulumi.Input['AuthConfigClientCertificateArgs']] = None,
                 decrypted_credential: Optional[pulumi.Input['AuthConfigDecryptedCredentialArgs']] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 expiry_notification_durations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 override_valid_time: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 visibility: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a AuthConfig resource.
        :param pulumi.Input[builtins.str] display_name: The name of the auth config.
        :param pulumi.Input[builtins.str] location: Location in which client needs to be provisioned.
        :param pulumi.Input['AuthConfigClientCertificateArgs'] client_certificate: Raw client certificate
               Structure is documented below.
        :param pulumi.Input['AuthConfigDecryptedCredentialArgs'] decrypted_credential: Raw auth credentials.
               Structure is documented below.
        :param pulumi.Input[builtins.str] description: A description of the auth config.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] expiry_notification_durations: User can define the time to receive notification after which the auth config becomes invalid. Support up to 30 days. Support granularity in hours.
               A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        :param pulumi.Input[builtins.str] override_valid_time: User provided expiry time to override. For the example of Salesforce, username/password credentials can be valid for 6 months depending on the instance settings.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] visibility: The visibility of the auth config.
               Possible values are: `PRIVATE`, `CLIENT_VISIBLE`.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "location", location)
        if client_certificate is not None:
            pulumi.set(__self__, "client_certificate", client_certificate)
        if decrypted_credential is not None:
            pulumi.set(__self__, "decrypted_credential", decrypted_credential)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if expiry_notification_durations is not None:
            pulumi.set(__self__, "expiry_notification_durations", expiry_notification_durations)
        if override_valid_time is not None:
            pulumi.set(__self__, "override_valid_time", override_valid_time)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if visibility is not None:
            pulumi.set(__self__, "visibility", visibility)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the auth config.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        Location in which client needs to be provisioned.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="clientCertificate")
    def client_certificate(self) -> Optional[pulumi.Input['AuthConfigClientCertificateArgs']]:
        """
        Raw client certificate
        Structure is documented below.
        """
        return pulumi.get(self, "client_certificate")

    @client_certificate.setter
    def client_certificate(self, value: Optional[pulumi.Input['AuthConfigClientCertificateArgs']]):
        pulumi.set(self, "client_certificate", value)

    @property
    @pulumi.getter(name="decryptedCredential")
    def decrypted_credential(self) -> Optional[pulumi.Input['AuthConfigDecryptedCredentialArgs']]:
        """
        Raw auth credentials.
        Structure is documented below.
        """
        return pulumi.get(self, "decrypted_credential")

    @decrypted_credential.setter
    def decrypted_credential(self, value: Optional[pulumi.Input['AuthConfigDecryptedCredentialArgs']]):
        pulumi.set(self, "decrypted_credential", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description of the auth config.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="expiryNotificationDurations")
    def expiry_notification_durations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        User can define the time to receive notification after which the auth config becomes invalid. Support up to 30 days. Support granularity in hours.
        A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        """
        return pulumi.get(self, "expiry_notification_durations")

    @expiry_notification_durations.setter
    def expiry_notification_durations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "expiry_notification_durations", value)

    @property
    @pulumi.getter(name="overrideValidTime")
    def override_valid_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User provided expiry time to override. For the example of Salesforce, username/password credentials can be valid for 6 months depending on the instance settings.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "override_valid_time")

    @override_valid_time.setter
    def override_valid_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "override_valid_time", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def visibility(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The visibility of the auth config.
        Possible values are: `PRIVATE`, `CLIENT_VISIBLE`.
        """
        return pulumi.get(self, "visibility")

    @visibility.setter
    def visibility(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "visibility", value)


@pulumi.input_type
class _AuthConfigState:
    def __init__(__self__, *,
                 certificate_id: Optional[pulumi.Input[builtins.str]] = None,
                 client_certificate: Optional[pulumi.Input['AuthConfigClientCertificateArgs']] = None,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 creator_email: Optional[pulumi.Input[builtins.str]] = None,
                 credential_type: Optional[pulumi.Input[builtins.str]] = None,
                 decrypted_credential: Optional[pulumi.Input['AuthConfigDecryptedCredentialArgs']] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 encrypted_credential: Optional[pulumi.Input[builtins.str]] = None,
                 expiry_notification_durations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 last_modifier_email: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 override_valid_time: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 reason: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None,
                 valid_time: Optional[pulumi.Input[builtins.str]] = None,
                 visibility: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering AuthConfig resources.
        :param pulumi.Input[builtins.str] certificate_id: Certificate id for client certificate.
        :param pulumi.Input['AuthConfigClientCertificateArgs'] client_certificate: Raw client certificate
               Structure is documented below.
        :param pulumi.Input[builtins.str] create_time: The timestamp when the auth config is created.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input[builtins.str] creator_email: The creator's email address. Generated based on the End User Credentials/LOAS role of the user making the call.
        :param pulumi.Input[builtins.str] credential_type: Credential type of the encrypted credential.
        :param pulumi.Input['AuthConfigDecryptedCredentialArgs'] decrypted_credential: Raw auth credentials.
               Structure is documented below.
        :param pulumi.Input[builtins.str] description: A description of the auth config.
        :param pulumi.Input[builtins.str] display_name: The name of the auth config.
        :param pulumi.Input[builtins.str] encrypted_credential: Auth credential encrypted by Cloud KMS. Can be decrypted as Credential with proper KMS key.
               A base64-encoded string.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] expiry_notification_durations: User can define the time to receive notification after which the auth config becomes invalid. Support up to 30 days. Support granularity in hours.
               A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        :param pulumi.Input[builtins.str] last_modifier_email: The last modifier's email address. Generated based on the End User Credentials/LOAS role of the user making the call.
        :param pulumi.Input[builtins.str] location: Location in which client needs to be provisioned.
        :param pulumi.Input[builtins.str] name: Resource name of the auth config.
        :param pulumi.Input[builtins.str] override_valid_time: User provided expiry time to override. For the example of Salesforce, username/password credentials can be valid for 6 months depending on the instance settings.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] reason: The reason / details of the current status.
        :param pulumi.Input[builtins.str] state: The status of the auth config.
        :param pulumi.Input[builtins.str] update_time: The timestamp when the auth config is modified.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input[builtins.str] valid_time: The time until the auth config is valid. Empty or max value is considered the auth config won't expire.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input[builtins.str] visibility: The visibility of the auth config.
               Possible values are: `PRIVATE`, `CLIENT_VISIBLE`.
        """
        if certificate_id is not None:
            pulumi.set(__self__, "certificate_id", certificate_id)
        if client_certificate is not None:
            pulumi.set(__self__, "client_certificate", client_certificate)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if creator_email is not None:
            pulumi.set(__self__, "creator_email", creator_email)
        if credential_type is not None:
            pulumi.set(__self__, "credential_type", credential_type)
        if decrypted_credential is not None:
            pulumi.set(__self__, "decrypted_credential", decrypted_credential)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if encrypted_credential is not None:
            pulumi.set(__self__, "encrypted_credential", encrypted_credential)
        if expiry_notification_durations is not None:
            pulumi.set(__self__, "expiry_notification_durations", expiry_notification_durations)
        if last_modifier_email is not None:
            pulumi.set(__self__, "last_modifier_email", last_modifier_email)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if override_valid_time is not None:
            pulumi.set(__self__, "override_valid_time", override_valid_time)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if valid_time is not None:
            pulumi.set(__self__, "valid_time", valid_time)
        if visibility is not None:
            pulumi.set(__self__, "visibility", visibility)

    @property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Certificate id for client certificate.
        """
        return pulumi.get(self, "certificate_id")

    @certificate_id.setter
    def certificate_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "certificate_id", value)

    @property
    @pulumi.getter(name="clientCertificate")
    def client_certificate(self) -> Optional[pulumi.Input['AuthConfigClientCertificateArgs']]:
        """
        Raw client certificate
        Structure is documented below.
        """
        return pulumi.get(self, "client_certificate")

    @client_certificate.setter
    def client_certificate(self, value: Optional[pulumi.Input['AuthConfigClientCertificateArgs']]):
        pulumi.set(self, "client_certificate", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The timestamp when the auth config is created.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="creatorEmail")
    def creator_email(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The creator's email address. Generated based on the End User Credentials/LOAS role of the user making the call.
        """
        return pulumi.get(self, "creator_email")

    @creator_email.setter
    def creator_email(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "creator_email", value)

    @property
    @pulumi.getter(name="credentialType")
    def credential_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Credential type of the encrypted credential.
        """
        return pulumi.get(self, "credential_type")

    @credential_type.setter
    def credential_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "credential_type", value)

    @property
    @pulumi.getter(name="decryptedCredential")
    def decrypted_credential(self) -> Optional[pulumi.Input['AuthConfigDecryptedCredentialArgs']]:
        """
        Raw auth credentials.
        Structure is documented below.
        """
        return pulumi.get(self, "decrypted_credential")

    @decrypted_credential.setter
    def decrypted_credential(self, value: Optional[pulumi.Input['AuthConfigDecryptedCredentialArgs']]):
        pulumi.set(self, "decrypted_credential", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description of the auth config.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the auth config.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Auth credential encrypted by Cloud KMS. Can be decrypted as Credential with proper KMS key.
        A base64-encoded string.
        """
        return pulumi.get(self, "encrypted_credential")

    @encrypted_credential.setter
    def encrypted_credential(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "encrypted_credential", value)

    @property
    @pulumi.getter(name="expiryNotificationDurations")
    def expiry_notification_durations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        User can define the time to receive notification after which the auth config becomes invalid. Support up to 30 days. Support granularity in hours.
        A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        """
        return pulumi.get(self, "expiry_notification_durations")

    @expiry_notification_durations.setter
    def expiry_notification_durations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "expiry_notification_durations", value)

    @property
    @pulumi.getter(name="lastModifierEmail")
    def last_modifier_email(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The last modifier's email address. Generated based on the End User Credentials/LOAS role of the user making the call.
        """
        return pulumi.get(self, "last_modifier_email")

    @last_modifier_email.setter
    def last_modifier_email(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "last_modifier_email", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Location in which client needs to be provisioned.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Resource name of the auth config.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="overrideValidTime")
    def override_valid_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User provided expiry time to override. For the example of Salesforce, username/password credentials can be valid for 6 months depending on the instance settings.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "override_valid_time")

    @override_valid_time.setter
    def override_valid_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "override_valid_time", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def reason(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The reason / details of the current status.
        """
        return pulumi.get(self, "reason")

    @reason.setter
    def reason(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "reason", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The status of the auth config.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The timestamp when the auth config is modified.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)

    @property
    @pulumi.getter(name="validTime")
    def valid_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time until the auth config is valid. Empty or max value is considered the auth config won't expire.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "valid_time")

    @valid_time.setter
    def valid_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "valid_time", value)

    @property
    @pulumi.getter
    def visibility(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The visibility of the auth config.
        Possible values are: `PRIVATE`, `CLIENT_VISIBLE`.
        """
        return pulumi.get(self, "visibility")

    @visibility.setter
    def visibility(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "visibility", value)


@pulumi.type_token("gcp:applicationintegration/authConfig:AuthConfig")
class AuthConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 client_certificate: Optional[pulumi.Input[Union['AuthConfigClientCertificateArgs', 'AuthConfigClientCertificateArgsDict']]] = None,
                 decrypted_credential: Optional[pulumi.Input[Union['AuthConfigDecryptedCredentialArgs', 'AuthConfigDecryptedCredentialArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 expiry_notification_durations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 override_valid_time: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 visibility: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        The AuthConfig resource use to hold channels and connection config data.

        To get more information about AuthConfig, see:

        * [API documentation](https://cloud.google.com/application-integration/docs/reference/rest/v1/projects.locations.authConfigs)
        * How-to Guides
            * [Manage authentication profiles](https://cloud.google.com/application-integration/docs/configure-authentication-profiles)
            * [Official Documentation](https://cloud.google.com/application-integration/docs/overview)

        ## Example Usage

        ### Integrations Auth Config Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        client = gcp.applicationintegration.Client("client", location="us-west1")
        basic_example = gcp.applicationintegration.AuthConfig("basic_example",
            location="us-west1",
            display_name="test-authconfig",
            description="Test auth config created via terraform",
            decrypted_credential={
                "credential_type": "USERNAME_AND_PASSWORD",
                "username_and_password": {
                    "username": "test-username",
                    "password": "test-password",
                },
            },
            opts = pulumi.ResourceOptions(depends_on=[client]))
        ```

        ## Import

        AuthConfig can be imported using any of these accepted formats:

        * `{{project}}/{{name}}`

        * `{{project}} {{name}}`

        * `{{name}}`

        When using the `pulumi import` command, AuthConfig can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:applicationintegration/authConfig:AuthConfig default {{project}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:applicationintegration/authConfig:AuthConfig default "{{project}} {{name}}"
        ```

        ```sh
        $ pulumi import gcp:applicationintegration/authConfig:AuthConfig default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['AuthConfigClientCertificateArgs', 'AuthConfigClientCertificateArgsDict']] client_certificate: Raw client certificate
               Structure is documented below.
        :param pulumi.Input[Union['AuthConfigDecryptedCredentialArgs', 'AuthConfigDecryptedCredentialArgsDict']] decrypted_credential: Raw auth credentials.
               Structure is documented below.
        :param pulumi.Input[builtins.str] description: A description of the auth config.
        :param pulumi.Input[builtins.str] display_name: The name of the auth config.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] expiry_notification_durations: User can define the time to receive notification after which the auth config becomes invalid. Support up to 30 days. Support granularity in hours.
               A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        :param pulumi.Input[builtins.str] location: Location in which client needs to be provisioned.
        :param pulumi.Input[builtins.str] override_valid_time: User provided expiry time to override. For the example of Salesforce, username/password credentials can be valid for 6 months depending on the instance settings.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] visibility: The visibility of the auth config.
               Possible values are: `PRIVATE`, `CLIENT_VISIBLE`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AuthConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The AuthConfig resource use to hold channels and connection config data.

        To get more information about AuthConfig, see:

        * [API documentation](https://cloud.google.com/application-integration/docs/reference/rest/v1/projects.locations.authConfigs)
        * How-to Guides
            * [Manage authentication profiles](https://cloud.google.com/application-integration/docs/configure-authentication-profiles)
            * [Official Documentation](https://cloud.google.com/application-integration/docs/overview)

        ## Example Usage

        ### Integrations Auth Config Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        client = gcp.applicationintegration.Client("client", location="us-west1")
        basic_example = gcp.applicationintegration.AuthConfig("basic_example",
            location="us-west1",
            display_name="test-authconfig",
            description="Test auth config created via terraform",
            decrypted_credential={
                "credential_type": "USERNAME_AND_PASSWORD",
                "username_and_password": {
                    "username": "test-username",
                    "password": "test-password",
                },
            },
            opts = pulumi.ResourceOptions(depends_on=[client]))
        ```

        ## Import

        AuthConfig can be imported using any of these accepted formats:

        * `{{project}}/{{name}}`

        * `{{project}} {{name}}`

        * `{{name}}`

        When using the `pulumi import` command, AuthConfig can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:applicationintegration/authConfig:AuthConfig default {{project}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:applicationintegration/authConfig:AuthConfig default "{{project}} {{name}}"
        ```

        ```sh
        $ pulumi import gcp:applicationintegration/authConfig:AuthConfig default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param AuthConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AuthConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 client_certificate: Optional[pulumi.Input[Union['AuthConfigClientCertificateArgs', 'AuthConfigClientCertificateArgsDict']]] = None,
                 decrypted_credential: Optional[pulumi.Input[Union['AuthConfigDecryptedCredentialArgs', 'AuthConfigDecryptedCredentialArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 expiry_notification_durations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 override_valid_time: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 visibility: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AuthConfigArgs.__new__(AuthConfigArgs)

            __props__.__dict__["client_certificate"] = client_certificate
            __props__.__dict__["decrypted_credential"] = decrypted_credential
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["expiry_notification_durations"] = expiry_notification_durations
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["override_valid_time"] = override_valid_time
            __props__.__dict__["project"] = project
            __props__.__dict__["visibility"] = visibility
            __props__.__dict__["certificate_id"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["creator_email"] = None
            __props__.__dict__["credential_type"] = None
            __props__.__dict__["encrypted_credential"] = None
            __props__.__dict__["last_modifier_email"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["reason"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["update_time"] = None
            __props__.__dict__["valid_time"] = None
        super(AuthConfig, __self__).__init__(
            'gcp:applicationintegration/authConfig:AuthConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            certificate_id: Optional[pulumi.Input[builtins.str]] = None,
            client_certificate: Optional[pulumi.Input[Union['AuthConfigClientCertificateArgs', 'AuthConfigClientCertificateArgsDict']]] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            creator_email: Optional[pulumi.Input[builtins.str]] = None,
            credential_type: Optional[pulumi.Input[builtins.str]] = None,
            decrypted_credential: Optional[pulumi.Input[Union['AuthConfigDecryptedCredentialArgs', 'AuthConfigDecryptedCredentialArgsDict']]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            encrypted_credential: Optional[pulumi.Input[builtins.str]] = None,
            expiry_notification_durations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            last_modifier_email: Optional[pulumi.Input[builtins.str]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            override_valid_time: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            reason: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None,
            valid_time: Optional[pulumi.Input[builtins.str]] = None,
            visibility: Optional[pulumi.Input[builtins.str]] = None) -> 'AuthConfig':
        """
        Get an existing AuthConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] certificate_id: Certificate id for client certificate.
        :param pulumi.Input[Union['AuthConfigClientCertificateArgs', 'AuthConfigClientCertificateArgsDict']] client_certificate: Raw client certificate
               Structure is documented below.
        :param pulumi.Input[builtins.str] create_time: The timestamp when the auth config is created.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input[builtins.str] creator_email: The creator's email address. Generated based on the End User Credentials/LOAS role of the user making the call.
        :param pulumi.Input[builtins.str] credential_type: Credential type of the encrypted credential.
        :param pulumi.Input[Union['AuthConfigDecryptedCredentialArgs', 'AuthConfigDecryptedCredentialArgsDict']] decrypted_credential: Raw auth credentials.
               Structure is documented below.
        :param pulumi.Input[builtins.str] description: A description of the auth config.
        :param pulumi.Input[builtins.str] display_name: The name of the auth config.
        :param pulumi.Input[builtins.str] encrypted_credential: Auth credential encrypted by Cloud KMS. Can be decrypted as Credential with proper KMS key.
               A base64-encoded string.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] expiry_notification_durations: User can define the time to receive notification after which the auth config becomes invalid. Support up to 30 days. Support granularity in hours.
               A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        :param pulumi.Input[builtins.str] last_modifier_email: The last modifier's email address. Generated based on the End User Credentials/LOAS role of the user making the call.
        :param pulumi.Input[builtins.str] location: Location in which client needs to be provisioned.
        :param pulumi.Input[builtins.str] name: Resource name of the auth config.
        :param pulumi.Input[builtins.str] override_valid_time: User provided expiry time to override. For the example of Salesforce, username/password credentials can be valid for 6 months depending on the instance settings.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] reason: The reason / details of the current status.
        :param pulumi.Input[builtins.str] state: The status of the auth config.
        :param pulumi.Input[builtins.str] update_time: The timestamp when the auth config is modified.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input[builtins.str] valid_time: The time until the auth config is valid. Empty or max value is considered the auth config won't expire.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input[builtins.str] visibility: The visibility of the auth config.
               Possible values are: `PRIVATE`, `CLIENT_VISIBLE`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AuthConfigState.__new__(_AuthConfigState)

        __props__.__dict__["certificate_id"] = certificate_id
        __props__.__dict__["client_certificate"] = client_certificate
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["creator_email"] = creator_email
        __props__.__dict__["credential_type"] = credential_type
        __props__.__dict__["decrypted_credential"] = decrypted_credential
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["encrypted_credential"] = encrypted_credential
        __props__.__dict__["expiry_notification_durations"] = expiry_notification_durations
        __props__.__dict__["last_modifier_email"] = last_modifier_email
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["override_valid_time"] = override_valid_time
        __props__.__dict__["project"] = project
        __props__.__dict__["reason"] = reason
        __props__.__dict__["state"] = state
        __props__.__dict__["update_time"] = update_time
        __props__.__dict__["valid_time"] = valid_time
        __props__.__dict__["visibility"] = visibility
        return AuthConfig(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> pulumi.Output[builtins.str]:
        """
        Certificate id for client certificate.
        """
        return pulumi.get(self, "certificate_id")

    @property
    @pulumi.getter(name="clientCertificate")
    def client_certificate(self) -> pulumi.Output[Optional['outputs.AuthConfigClientCertificate']]:
        """
        Raw client certificate
        Structure is documented below.
        """
        return pulumi.get(self, "client_certificate")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        The timestamp when the auth config is created.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="creatorEmail")
    def creator_email(self) -> pulumi.Output[builtins.str]:
        """
        The creator's email address. Generated based on the End User Credentials/LOAS role of the user making the call.
        """
        return pulumi.get(self, "creator_email")

    @property
    @pulumi.getter(name="credentialType")
    def credential_type(self) -> pulumi.Output[builtins.str]:
        """
        Credential type of the encrypted credential.
        """
        return pulumi.get(self, "credential_type")

    @property
    @pulumi.getter(name="decryptedCredential")
    def decrypted_credential(self) -> pulumi.Output[Optional['outputs.AuthConfigDecryptedCredential']]:
        """
        Raw auth credentials.
        Structure is documented below.
        """
        return pulumi.get(self, "decrypted_credential")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A description of the auth config.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the auth config.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="encryptedCredential")
    def encrypted_credential(self) -> pulumi.Output[builtins.str]:
        """
        Auth credential encrypted by Cloud KMS. Can be decrypted as Credential with proper KMS key.
        A base64-encoded string.
        """
        return pulumi.get(self, "encrypted_credential")

    @property
    @pulumi.getter(name="expiryNotificationDurations")
    def expiry_notification_durations(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        User can define the time to receive notification after which the auth config becomes invalid. Support up to 30 days. Support granularity in hours.
        A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        """
        return pulumi.get(self, "expiry_notification_durations")

    @property
    @pulumi.getter(name="lastModifierEmail")
    def last_modifier_email(self) -> pulumi.Output[builtins.str]:
        """
        The last modifier's email address. Generated based on the End User Credentials/LOAS role of the user making the call.
        """
        return pulumi.get(self, "last_modifier_email")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        Location in which client needs to be provisioned.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Resource name of the auth config.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="overrideValidTime")
    def override_valid_time(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        User provided expiry time to override. For the example of Salesforce, username/password credentials can be valid for 6 months depending on the instance settings.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "override_valid_time")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def reason(self) -> pulumi.Output[builtins.str]:
        """
        The reason / details of the current status.
        """
        return pulumi.get(self, "reason")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The status of the auth config.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        The timestamp when the auth config is modified.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter(name="validTime")
    def valid_time(self) -> pulumi.Output[builtins.str]:
        """
        The time until the auth config is valid. Empty or max value is considered the auth config won't expire.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "valid_time")

    @property
    @pulumi.getter
    def visibility(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The visibility of the auth config.
        Possible values are: `PRIVATE`, `CLIENT_VISIBLE`.
        """
        return pulumi.get(self, "visibility")

