# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'RepositoryCleanupPolicy',
    'RepositoryCleanupPolicyCondition',
    'RepositoryCleanupPolicyMostRecentVersions',
    'RepositoryDockerConfig',
    'RepositoryIamBindingCondition',
    'RepositoryIamMemberCondition',
    'RepositoryMavenConfig',
    'RepositoryRemoteRepositoryConfig',
    'RepositoryRemoteRepositoryConfigAptRepository',
    'RepositoryRemoteRepositoryConfigAptRepositoryPublicRepository',
    'RepositoryRemoteRepositoryConfigCommonRepository',
    'RepositoryRemoteRepositoryConfigDockerRepository',
    'RepositoryRemoteRepositoryConfigDockerRepositoryCustomRepository',
    'RepositoryRemoteRepositoryConfigMavenRepository',
    'RepositoryRemoteRepositoryConfigMavenRepositoryCustomRepository',
    'RepositoryRemoteRepositoryConfigNpmRepository',
    'RepositoryRemoteRepositoryConfigNpmRepositoryCustomRepository',
    'RepositoryRemoteRepositoryConfigPythonRepository',
    'RepositoryRemoteRepositoryConfigPythonRepositoryCustomRepository',
    'RepositoryRemoteRepositoryConfigUpstreamCredentials',
    'RepositoryRemoteRepositoryConfigUpstreamCredentialsUsernamePasswordCredentials',
    'RepositoryRemoteRepositoryConfigYumRepository',
    'RepositoryRemoteRepositoryConfigYumRepositoryPublicRepository',
    'RepositoryVirtualRepositoryConfig',
    'RepositoryVirtualRepositoryConfigUpstreamPolicy',
    'RepositoryVulnerabilityScanningConfig',
    'GetRepositoryCleanupPolicyResult',
    'GetRepositoryCleanupPolicyConditionResult',
    'GetRepositoryCleanupPolicyMostRecentVersionResult',
    'GetRepositoryDockerConfigResult',
    'GetRepositoryMavenConfigResult',
    'GetRepositoryRemoteRepositoryConfigResult',
    'GetRepositoryRemoteRepositoryConfigAptRepositoryResult',
    'GetRepositoryRemoteRepositoryConfigAptRepositoryPublicRepositoryResult',
    'GetRepositoryRemoteRepositoryConfigCommonRepositoryResult',
    'GetRepositoryRemoteRepositoryConfigDockerRepositoryResult',
    'GetRepositoryRemoteRepositoryConfigDockerRepositoryCustomRepositoryResult',
    'GetRepositoryRemoteRepositoryConfigMavenRepositoryResult',
    'GetRepositoryRemoteRepositoryConfigMavenRepositoryCustomRepositoryResult',
    'GetRepositoryRemoteRepositoryConfigNpmRepositoryResult',
    'GetRepositoryRemoteRepositoryConfigNpmRepositoryCustomRepositoryResult',
    'GetRepositoryRemoteRepositoryConfigPythonRepositoryResult',
    'GetRepositoryRemoteRepositoryConfigPythonRepositoryCustomRepositoryResult',
    'GetRepositoryRemoteRepositoryConfigUpstreamCredentialResult',
    'GetRepositoryRemoteRepositoryConfigUpstreamCredentialUsernamePasswordCredentialResult',
    'GetRepositoryRemoteRepositoryConfigYumRepositoryResult',
    'GetRepositoryRemoteRepositoryConfigYumRepositoryPublicRepositoryResult',
    'GetRepositoryVirtualRepositoryConfigResult',
    'GetRepositoryVirtualRepositoryConfigUpstreamPolicyResult',
    'GetRepositoryVulnerabilityScanningConfigResult',
]

@pulumi.output_type
class RepositoryCleanupPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mostRecentVersions":
            suggest = "most_recent_versions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepositoryCleanupPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepositoryCleanupPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepositoryCleanupPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: builtins.str,
                 action: Optional[builtins.str] = None,
                 condition: Optional['outputs.RepositoryCleanupPolicyCondition'] = None,
                 most_recent_versions: Optional['outputs.RepositoryCleanupPolicyMostRecentVersions'] = None):
        """
        :param builtins.str id: The identifier for this object. Format specified above.
        :param builtins.str action: Policy action.
               Possible values are: `DELETE`, `KEEP`.
        :param 'RepositoryCleanupPolicyConditionArgs' condition: Policy condition for matching versions.
               Structure is documented below.
        :param 'RepositoryCleanupPolicyMostRecentVersionsArgs' most_recent_versions: Policy condition for retaining a minimum number of versions. May only be
               specified with a Keep action.
               Structure is documented below.
        """
        pulumi.set(__self__, "id", id)
        if action is not None:
            pulumi.set(__self__, "action", action)
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if most_recent_versions is not None:
            pulumi.set(__self__, "most_recent_versions", most_recent_versions)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The identifier for this object. Format specified above.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def action(self) -> Optional[builtins.str]:
        """
        Policy action.
        Possible values are: `DELETE`, `KEEP`.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def condition(self) -> Optional['outputs.RepositoryCleanupPolicyCondition']:
        """
        Policy condition for matching versions.
        Structure is documented below.
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter(name="mostRecentVersions")
    def most_recent_versions(self) -> Optional['outputs.RepositoryCleanupPolicyMostRecentVersions']:
        """
        Policy condition for retaining a minimum number of versions. May only be
        specified with a Keep action.
        Structure is documented below.
        """
        return pulumi.get(self, "most_recent_versions")


@pulumi.output_type
class RepositoryCleanupPolicyCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "newerThan":
            suggest = "newer_than"
        elif key == "olderThan":
            suggest = "older_than"
        elif key == "packageNamePrefixes":
            suggest = "package_name_prefixes"
        elif key == "tagPrefixes":
            suggest = "tag_prefixes"
        elif key == "tagState":
            suggest = "tag_state"
        elif key == "versionNamePrefixes":
            suggest = "version_name_prefixes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepositoryCleanupPolicyCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepositoryCleanupPolicyCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepositoryCleanupPolicyCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 newer_than: Optional[builtins.str] = None,
                 older_than: Optional[builtins.str] = None,
                 package_name_prefixes: Optional[Sequence[builtins.str]] = None,
                 tag_prefixes: Optional[Sequence[builtins.str]] = None,
                 tag_state: Optional[builtins.str] = None,
                 version_name_prefixes: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str newer_than: Match versions newer than a duration.
        :param builtins.str older_than: Match versions older than a duration.
        :param Sequence[builtins.str] package_name_prefixes: Match versions by package prefix. Applied on any prefix match.
        :param Sequence[builtins.str] tag_prefixes: Match versions by tag prefix. Applied on any prefix match.
        :param builtins.str tag_state: Match versions by tag status.
               Default value is `ANY`.
               Possible values are: `TAGGED`, `UNTAGGED`, `ANY`.
        :param Sequence[builtins.str] version_name_prefixes: Match versions by version name prefix. Applied on any prefix match.
        """
        if newer_than is not None:
            pulumi.set(__self__, "newer_than", newer_than)
        if older_than is not None:
            pulumi.set(__self__, "older_than", older_than)
        if package_name_prefixes is not None:
            pulumi.set(__self__, "package_name_prefixes", package_name_prefixes)
        if tag_prefixes is not None:
            pulumi.set(__self__, "tag_prefixes", tag_prefixes)
        if tag_state is not None:
            pulumi.set(__self__, "tag_state", tag_state)
        if version_name_prefixes is not None:
            pulumi.set(__self__, "version_name_prefixes", version_name_prefixes)

    @property
    @pulumi.getter(name="newerThan")
    def newer_than(self) -> Optional[builtins.str]:
        """
        Match versions newer than a duration.
        """
        return pulumi.get(self, "newer_than")

    @property
    @pulumi.getter(name="olderThan")
    def older_than(self) -> Optional[builtins.str]:
        """
        Match versions older than a duration.
        """
        return pulumi.get(self, "older_than")

    @property
    @pulumi.getter(name="packageNamePrefixes")
    def package_name_prefixes(self) -> Optional[Sequence[builtins.str]]:
        """
        Match versions by package prefix. Applied on any prefix match.
        """
        return pulumi.get(self, "package_name_prefixes")

    @property
    @pulumi.getter(name="tagPrefixes")
    def tag_prefixes(self) -> Optional[Sequence[builtins.str]]:
        """
        Match versions by tag prefix. Applied on any prefix match.
        """
        return pulumi.get(self, "tag_prefixes")

    @property
    @pulumi.getter(name="tagState")
    def tag_state(self) -> Optional[builtins.str]:
        """
        Match versions by tag status.
        Default value is `ANY`.
        Possible values are: `TAGGED`, `UNTAGGED`, `ANY`.
        """
        return pulumi.get(self, "tag_state")

    @property
    @pulumi.getter(name="versionNamePrefixes")
    def version_name_prefixes(self) -> Optional[Sequence[builtins.str]]:
        """
        Match versions by version name prefix. Applied on any prefix match.
        """
        return pulumi.get(self, "version_name_prefixes")


@pulumi.output_type
class RepositoryCleanupPolicyMostRecentVersions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keepCount":
            suggest = "keep_count"
        elif key == "packageNamePrefixes":
            suggest = "package_name_prefixes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepositoryCleanupPolicyMostRecentVersions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepositoryCleanupPolicyMostRecentVersions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepositoryCleanupPolicyMostRecentVersions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 keep_count: Optional[builtins.int] = None,
                 package_name_prefixes: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.int keep_count: Minimum number of versions to keep.
        :param Sequence[builtins.str] package_name_prefixes: Match versions by package prefix. Applied on any prefix match.
        """
        if keep_count is not None:
            pulumi.set(__self__, "keep_count", keep_count)
        if package_name_prefixes is not None:
            pulumi.set(__self__, "package_name_prefixes", package_name_prefixes)

    @property
    @pulumi.getter(name="keepCount")
    def keep_count(self) -> Optional[builtins.int]:
        """
        Minimum number of versions to keep.
        """
        return pulumi.get(self, "keep_count")

    @property
    @pulumi.getter(name="packageNamePrefixes")
    def package_name_prefixes(self) -> Optional[Sequence[builtins.str]]:
        """
        Match versions by package prefix. Applied on any prefix match.
        """
        return pulumi.get(self, "package_name_prefixes")


@pulumi.output_type
class RepositoryDockerConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "immutableTags":
            suggest = "immutable_tags"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepositoryDockerConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepositoryDockerConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepositoryDockerConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 immutable_tags: Optional[builtins.bool] = None):
        """
        :param builtins.bool immutable_tags: The repository which enabled this flag prevents all tags from being modified, moved or deleted. This does not prevent tags from being created.
        """
        if immutable_tags is not None:
            pulumi.set(__self__, "immutable_tags", immutable_tags)

    @property
    @pulumi.getter(name="immutableTags")
    def immutable_tags(self) -> Optional[builtins.bool]:
        """
        The repository which enabled this flag prevents all tags from being modified, moved or deleted. This does not prevent tags from being created.
        """
        return pulumi.get(self, "immutable_tags")


@pulumi.output_type
class RepositoryIamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: builtins.str,
                 title: builtins.str,
                 description: Optional[builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> builtins.str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> builtins.str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class RepositoryIamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: builtins.str,
                 title: builtins.str,
                 description: Optional[builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> builtins.str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> builtins.str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class RepositoryMavenConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowSnapshotOverwrites":
            suggest = "allow_snapshot_overwrites"
        elif key == "versionPolicy":
            suggest = "version_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepositoryMavenConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepositoryMavenConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepositoryMavenConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_snapshot_overwrites: Optional[builtins.bool] = None,
                 version_policy: Optional[builtins.str] = None):
        """
        :param builtins.bool allow_snapshot_overwrites: The repository with this flag will allow publishing the same
               snapshot versions.
        :param builtins.str version_policy: Version policy defines the versions that the registry will accept.
               Default value is `VERSION_POLICY_UNSPECIFIED`.
               Possible values are: `VERSION_POLICY_UNSPECIFIED`, `RELEASE`, `SNAPSHOT`.
        """
        if allow_snapshot_overwrites is not None:
            pulumi.set(__self__, "allow_snapshot_overwrites", allow_snapshot_overwrites)
        if version_policy is not None:
            pulumi.set(__self__, "version_policy", version_policy)

    @property
    @pulumi.getter(name="allowSnapshotOverwrites")
    def allow_snapshot_overwrites(self) -> Optional[builtins.bool]:
        """
        The repository with this flag will allow publishing the same
        snapshot versions.
        """
        return pulumi.get(self, "allow_snapshot_overwrites")

    @property
    @pulumi.getter(name="versionPolicy")
    def version_policy(self) -> Optional[builtins.str]:
        """
        Version policy defines the versions that the registry will accept.
        Default value is `VERSION_POLICY_UNSPECIFIED`.
        Possible values are: `VERSION_POLICY_UNSPECIFIED`, `RELEASE`, `SNAPSHOT`.
        """
        return pulumi.get(self, "version_policy")


@pulumi.output_type
class RepositoryRemoteRepositoryConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "aptRepository":
            suggest = "apt_repository"
        elif key == "commonRepository":
            suggest = "common_repository"
        elif key == "disableUpstreamValidation":
            suggest = "disable_upstream_validation"
        elif key == "dockerRepository":
            suggest = "docker_repository"
        elif key == "mavenRepository":
            suggest = "maven_repository"
        elif key == "npmRepository":
            suggest = "npm_repository"
        elif key == "pythonRepository":
            suggest = "python_repository"
        elif key == "upstreamCredentials":
            suggest = "upstream_credentials"
        elif key == "yumRepository":
            suggest = "yum_repository"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepositoryRemoteRepositoryConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepositoryRemoteRepositoryConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepositoryRemoteRepositoryConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 apt_repository: Optional['outputs.RepositoryRemoteRepositoryConfigAptRepository'] = None,
                 common_repository: Optional['outputs.RepositoryRemoteRepositoryConfigCommonRepository'] = None,
                 description: Optional[builtins.str] = None,
                 disable_upstream_validation: Optional[builtins.bool] = None,
                 docker_repository: Optional['outputs.RepositoryRemoteRepositoryConfigDockerRepository'] = None,
                 maven_repository: Optional['outputs.RepositoryRemoteRepositoryConfigMavenRepository'] = None,
                 npm_repository: Optional['outputs.RepositoryRemoteRepositoryConfigNpmRepository'] = None,
                 python_repository: Optional['outputs.RepositoryRemoteRepositoryConfigPythonRepository'] = None,
                 upstream_credentials: Optional['outputs.RepositoryRemoteRepositoryConfigUpstreamCredentials'] = None,
                 yum_repository: Optional['outputs.RepositoryRemoteRepositoryConfigYumRepository'] = None):
        """
        :param 'RepositoryRemoteRepositoryConfigAptRepositoryArgs' apt_repository: Specific settings for an Apt remote repository.
               Structure is documented below.
        :param 'RepositoryRemoteRepositoryConfigCommonRepositoryArgs' common_repository: Specific settings for an Artifact Registory remote repository.
               Structure is documented below.
        :param builtins.str description: The description of the remote source.
        :param builtins.bool disable_upstream_validation: If true, the remote repository upstream and upstream credentials will
               not be validated.
        :param 'RepositoryRemoteRepositoryConfigDockerRepositoryArgs' docker_repository: Specific settings for a Docker remote repository.
               Structure is documented below.
        :param 'RepositoryRemoteRepositoryConfigMavenRepositoryArgs' maven_repository: Specific settings for a Maven remote repository.
               Structure is documented below.
        :param 'RepositoryRemoteRepositoryConfigNpmRepositoryArgs' npm_repository: Specific settings for an Npm remote repository.
               Structure is documented below.
        :param 'RepositoryRemoteRepositoryConfigPythonRepositoryArgs' python_repository: Specific settings for a Python remote repository.
               Structure is documented below.
        :param 'RepositoryRemoteRepositoryConfigUpstreamCredentialsArgs' upstream_credentials: The credentials used to access the remote repository.
               Structure is documented below.
        :param 'RepositoryRemoteRepositoryConfigYumRepositoryArgs' yum_repository: Specific settings for an Yum remote repository.
               Structure is documented below.
        """
        if apt_repository is not None:
            pulumi.set(__self__, "apt_repository", apt_repository)
        if common_repository is not None:
            pulumi.set(__self__, "common_repository", common_repository)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_upstream_validation is not None:
            pulumi.set(__self__, "disable_upstream_validation", disable_upstream_validation)
        if docker_repository is not None:
            pulumi.set(__self__, "docker_repository", docker_repository)
        if maven_repository is not None:
            pulumi.set(__self__, "maven_repository", maven_repository)
        if npm_repository is not None:
            pulumi.set(__self__, "npm_repository", npm_repository)
        if python_repository is not None:
            pulumi.set(__self__, "python_repository", python_repository)
        if upstream_credentials is not None:
            pulumi.set(__self__, "upstream_credentials", upstream_credentials)
        if yum_repository is not None:
            pulumi.set(__self__, "yum_repository", yum_repository)

    @property
    @pulumi.getter(name="aptRepository")
    def apt_repository(self) -> Optional['outputs.RepositoryRemoteRepositoryConfigAptRepository']:
        """
        Specific settings for an Apt remote repository.
        Structure is documented below.
        """
        return pulumi.get(self, "apt_repository")

    @property
    @pulumi.getter(name="commonRepository")
    def common_repository(self) -> Optional['outputs.RepositoryRemoteRepositoryConfigCommonRepository']:
        """
        Specific settings for an Artifact Registory remote repository.
        Structure is documented below.
        """
        return pulumi.get(self, "common_repository")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        The description of the remote source.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="disableUpstreamValidation")
    def disable_upstream_validation(self) -> Optional[builtins.bool]:
        """
        If true, the remote repository upstream and upstream credentials will
        not be validated.
        """
        return pulumi.get(self, "disable_upstream_validation")

    @property
    @pulumi.getter(name="dockerRepository")
    def docker_repository(self) -> Optional['outputs.RepositoryRemoteRepositoryConfigDockerRepository']:
        """
        Specific settings for a Docker remote repository.
        Structure is documented below.
        """
        return pulumi.get(self, "docker_repository")

    @property
    @pulumi.getter(name="mavenRepository")
    def maven_repository(self) -> Optional['outputs.RepositoryRemoteRepositoryConfigMavenRepository']:
        """
        Specific settings for a Maven remote repository.
        Structure is documented below.
        """
        return pulumi.get(self, "maven_repository")

    @property
    @pulumi.getter(name="npmRepository")
    def npm_repository(self) -> Optional['outputs.RepositoryRemoteRepositoryConfigNpmRepository']:
        """
        Specific settings for an Npm remote repository.
        Structure is documented below.
        """
        return pulumi.get(self, "npm_repository")

    @property
    @pulumi.getter(name="pythonRepository")
    def python_repository(self) -> Optional['outputs.RepositoryRemoteRepositoryConfigPythonRepository']:
        """
        Specific settings for a Python remote repository.
        Structure is documented below.
        """
        return pulumi.get(self, "python_repository")

    @property
    @pulumi.getter(name="upstreamCredentials")
    def upstream_credentials(self) -> Optional['outputs.RepositoryRemoteRepositoryConfigUpstreamCredentials']:
        """
        The credentials used to access the remote repository.
        Structure is documented below.
        """
        return pulumi.get(self, "upstream_credentials")

    @property
    @pulumi.getter(name="yumRepository")
    def yum_repository(self) -> Optional['outputs.RepositoryRemoteRepositoryConfigYumRepository']:
        """
        Specific settings for an Yum remote repository.
        Structure is documented below.
        """
        return pulumi.get(self, "yum_repository")


@pulumi.output_type
class RepositoryRemoteRepositoryConfigAptRepository(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publicRepository":
            suggest = "public_repository"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepositoryRemoteRepositoryConfigAptRepository. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepositoryRemoteRepositoryConfigAptRepository.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepositoryRemoteRepositoryConfigAptRepository.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 public_repository: Optional['outputs.RepositoryRemoteRepositoryConfigAptRepositoryPublicRepository'] = None):
        """
        :param 'RepositoryRemoteRepositoryConfigAptRepositoryPublicRepositoryArgs' public_repository: One of the publicly available Apt repositories supported by Artifact Registry.
               Structure is documented below.
        """
        if public_repository is not None:
            pulumi.set(__self__, "public_repository", public_repository)

    @property
    @pulumi.getter(name="publicRepository")
    def public_repository(self) -> Optional['outputs.RepositoryRemoteRepositoryConfigAptRepositoryPublicRepository']:
        """
        One of the publicly available Apt repositories supported by Artifact Registry.
        Structure is documented below.
        """
        return pulumi.get(self, "public_repository")


@pulumi.output_type
class RepositoryRemoteRepositoryConfigAptRepositoryPublicRepository(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "repositoryBase":
            suggest = "repository_base"
        elif key == "repositoryPath":
            suggest = "repository_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepositoryRemoteRepositoryConfigAptRepositoryPublicRepository. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepositoryRemoteRepositoryConfigAptRepositoryPublicRepository.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepositoryRemoteRepositoryConfigAptRepositoryPublicRepository.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 repository_base: builtins.str,
                 repository_path: builtins.str):
        """
        :param builtins.str repository_base: A common public repository base for Yum.
               Possible values are: `CENTOS`, `CENTOS_DEBUG`, `CENTOS_VAULT`, `CENTOS_STREAM`, `ROCKY`, `EPEL`.
        :param builtins.str repository_path: Specific repository from the base, e.g. `"pub/rocky/9/BaseOS/x86_64/os"`
        """
        pulumi.set(__self__, "repository_base", repository_base)
        pulumi.set(__self__, "repository_path", repository_path)

    @property
    @pulumi.getter(name="repositoryBase")
    def repository_base(self) -> builtins.str:
        """
        A common public repository base for Yum.
        Possible values are: `CENTOS`, `CENTOS_DEBUG`, `CENTOS_VAULT`, `CENTOS_STREAM`, `ROCKY`, `EPEL`.
        """
        return pulumi.get(self, "repository_base")

    @property
    @pulumi.getter(name="repositoryPath")
    def repository_path(self) -> builtins.str:
        """
        Specific repository from the base, e.g. `"pub/rocky/9/BaseOS/x86_64/os"`
        """
        return pulumi.get(self, "repository_path")


@pulumi.output_type
class RepositoryRemoteRepositoryConfigCommonRepository(dict):
    def __init__(__self__, *,
                 uri: builtins.str):
        """
        :param builtins.str uri: One of:
               a. Artifact Registry Repository resource, e.g. `projects/UPSTREAM_PROJECT_ID/locations/REGION/repositories/UPSTREAM_REPOSITORY`
               b. URI to the registry, e.g. `"https://registry-1.docker.io"`
               c. URI to Artifact Registry Repository, e.g. `"https://REGION-docker.pkg.dev/UPSTREAM_PROJECT_ID/UPSTREAM_REPOSITORY"`
        """
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def uri(self) -> builtins.str:
        """
        One of:
        a. Artifact Registry Repository resource, e.g. `projects/UPSTREAM_PROJECT_ID/locations/REGION/repositories/UPSTREAM_REPOSITORY`
        b. URI to the registry, e.g. `"https://registry-1.docker.io"`
        c. URI to Artifact Registry Repository, e.g. `"https://REGION-docker.pkg.dev/UPSTREAM_PROJECT_ID/UPSTREAM_REPOSITORY"`
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class RepositoryRemoteRepositoryConfigDockerRepository(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customRepository":
            suggest = "custom_repository"
        elif key == "publicRepository":
            suggest = "public_repository"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepositoryRemoteRepositoryConfigDockerRepository. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepositoryRemoteRepositoryConfigDockerRepository.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepositoryRemoteRepositoryConfigDockerRepository.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_repository: Optional['outputs.RepositoryRemoteRepositoryConfigDockerRepositoryCustomRepository'] = None,
                 public_repository: Optional[builtins.str] = None):
        """
        :param 'RepositoryRemoteRepositoryConfigDockerRepositoryCustomRepositoryArgs' custom_repository: [Deprecated, please use commonRepository instead] Settings for a remote repository with a custom uri.
               Structure is documented below.
        :param builtins.str public_repository: Address of the remote repository.
               Default value is `DOCKER_HUB`.
               Possible values are: `DOCKER_HUB`.
        """
        if custom_repository is not None:
            pulumi.set(__self__, "custom_repository", custom_repository)
        if public_repository is not None:
            pulumi.set(__self__, "public_repository", public_repository)

    @property
    @pulumi.getter(name="customRepository")
    def custom_repository(self) -> Optional['outputs.RepositoryRemoteRepositoryConfigDockerRepositoryCustomRepository']:
        """
        [Deprecated, please use commonRepository instead] Settings for a remote repository with a custom uri.
        Structure is documented below.
        """
        return pulumi.get(self, "custom_repository")

    @property
    @pulumi.getter(name="publicRepository")
    def public_repository(self) -> Optional[builtins.str]:
        """
        Address of the remote repository.
        Default value is `DOCKER_HUB`.
        Possible values are: `DOCKER_HUB`.
        """
        return pulumi.get(self, "public_repository")


@pulumi.output_type
class RepositoryRemoteRepositoryConfigDockerRepositoryCustomRepository(dict):
    def __init__(__self__, *,
                 uri: Optional[builtins.str] = None):
        """
        :param builtins.str uri: Specific uri to the registry, e.g. `"https://pypi.io"`
        """
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def uri(self) -> Optional[builtins.str]:
        """
        Specific uri to the registry, e.g. `"https://pypi.io"`
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class RepositoryRemoteRepositoryConfigMavenRepository(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customRepository":
            suggest = "custom_repository"
        elif key == "publicRepository":
            suggest = "public_repository"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepositoryRemoteRepositoryConfigMavenRepository. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepositoryRemoteRepositoryConfigMavenRepository.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepositoryRemoteRepositoryConfigMavenRepository.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_repository: Optional['outputs.RepositoryRemoteRepositoryConfigMavenRepositoryCustomRepository'] = None,
                 public_repository: Optional[builtins.str] = None):
        """
        :param 'RepositoryRemoteRepositoryConfigMavenRepositoryCustomRepositoryArgs' custom_repository: [Deprecated, please use commonRepository instead] Settings for a remote repository with a custom uri.
               Structure is documented below.
        :param builtins.str public_repository: Address of the remote repository.
               Default value is `MAVEN_CENTRAL`.
               Possible values are: `MAVEN_CENTRAL`.
        """
        if custom_repository is not None:
            pulumi.set(__self__, "custom_repository", custom_repository)
        if public_repository is not None:
            pulumi.set(__self__, "public_repository", public_repository)

    @property
    @pulumi.getter(name="customRepository")
    def custom_repository(self) -> Optional['outputs.RepositoryRemoteRepositoryConfigMavenRepositoryCustomRepository']:
        """
        [Deprecated, please use commonRepository instead] Settings for a remote repository with a custom uri.
        Structure is documented below.
        """
        return pulumi.get(self, "custom_repository")

    @property
    @pulumi.getter(name="publicRepository")
    def public_repository(self) -> Optional[builtins.str]:
        """
        Address of the remote repository.
        Default value is `MAVEN_CENTRAL`.
        Possible values are: `MAVEN_CENTRAL`.
        """
        return pulumi.get(self, "public_repository")


@pulumi.output_type
class RepositoryRemoteRepositoryConfigMavenRepositoryCustomRepository(dict):
    def __init__(__self__, *,
                 uri: Optional[builtins.str] = None):
        """
        :param builtins.str uri: Specific uri to the registry, e.g. `"https://pypi.io"`
        """
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def uri(self) -> Optional[builtins.str]:
        """
        Specific uri to the registry, e.g. `"https://pypi.io"`
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class RepositoryRemoteRepositoryConfigNpmRepository(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customRepository":
            suggest = "custom_repository"
        elif key == "publicRepository":
            suggest = "public_repository"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepositoryRemoteRepositoryConfigNpmRepository. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepositoryRemoteRepositoryConfigNpmRepository.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepositoryRemoteRepositoryConfigNpmRepository.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_repository: Optional['outputs.RepositoryRemoteRepositoryConfigNpmRepositoryCustomRepository'] = None,
                 public_repository: Optional[builtins.str] = None):
        """
        :param 'RepositoryRemoteRepositoryConfigNpmRepositoryCustomRepositoryArgs' custom_repository: [Deprecated, please use commonRepository instead] Settings for a remote repository with a custom uri.
               Structure is documented below.
        :param builtins.str public_repository: Address of the remote repository.
               Default value is `NPMJS`.
               Possible values are: `NPMJS`.
        """
        if custom_repository is not None:
            pulumi.set(__self__, "custom_repository", custom_repository)
        if public_repository is not None:
            pulumi.set(__self__, "public_repository", public_repository)

    @property
    @pulumi.getter(name="customRepository")
    def custom_repository(self) -> Optional['outputs.RepositoryRemoteRepositoryConfigNpmRepositoryCustomRepository']:
        """
        [Deprecated, please use commonRepository instead] Settings for a remote repository with a custom uri.
        Structure is documented below.
        """
        return pulumi.get(self, "custom_repository")

    @property
    @pulumi.getter(name="publicRepository")
    def public_repository(self) -> Optional[builtins.str]:
        """
        Address of the remote repository.
        Default value is `NPMJS`.
        Possible values are: `NPMJS`.
        """
        return pulumi.get(self, "public_repository")


@pulumi.output_type
class RepositoryRemoteRepositoryConfigNpmRepositoryCustomRepository(dict):
    def __init__(__self__, *,
                 uri: Optional[builtins.str] = None):
        """
        :param builtins.str uri: Specific uri to the registry, e.g. `"https://pypi.io"`
        """
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def uri(self) -> Optional[builtins.str]:
        """
        Specific uri to the registry, e.g. `"https://pypi.io"`
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class RepositoryRemoteRepositoryConfigPythonRepository(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customRepository":
            suggest = "custom_repository"
        elif key == "publicRepository":
            suggest = "public_repository"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepositoryRemoteRepositoryConfigPythonRepository. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepositoryRemoteRepositoryConfigPythonRepository.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepositoryRemoteRepositoryConfigPythonRepository.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_repository: Optional['outputs.RepositoryRemoteRepositoryConfigPythonRepositoryCustomRepository'] = None,
                 public_repository: Optional[builtins.str] = None):
        """
        :param 'RepositoryRemoteRepositoryConfigPythonRepositoryCustomRepositoryArgs' custom_repository: [Deprecated, please use commonRepository instead] Settings for a remote repository with a custom uri.
               Structure is documented below.
        :param builtins.str public_repository: Address of the remote repository.
               Default value is `PYPI`.
               Possible values are: `PYPI`.
        """
        if custom_repository is not None:
            pulumi.set(__self__, "custom_repository", custom_repository)
        if public_repository is not None:
            pulumi.set(__self__, "public_repository", public_repository)

    @property
    @pulumi.getter(name="customRepository")
    def custom_repository(self) -> Optional['outputs.RepositoryRemoteRepositoryConfigPythonRepositoryCustomRepository']:
        """
        [Deprecated, please use commonRepository instead] Settings for a remote repository with a custom uri.
        Structure is documented below.
        """
        return pulumi.get(self, "custom_repository")

    @property
    @pulumi.getter(name="publicRepository")
    def public_repository(self) -> Optional[builtins.str]:
        """
        Address of the remote repository.
        Default value is `PYPI`.
        Possible values are: `PYPI`.
        """
        return pulumi.get(self, "public_repository")


@pulumi.output_type
class RepositoryRemoteRepositoryConfigPythonRepositoryCustomRepository(dict):
    def __init__(__self__, *,
                 uri: Optional[builtins.str] = None):
        """
        :param builtins.str uri: Specific uri to the registry, e.g. `"https://pypi.io"`
        """
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def uri(self) -> Optional[builtins.str]:
        """
        Specific uri to the registry, e.g. `"https://pypi.io"`
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class RepositoryRemoteRepositoryConfigUpstreamCredentials(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "usernamePasswordCredentials":
            suggest = "username_password_credentials"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepositoryRemoteRepositoryConfigUpstreamCredentials. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepositoryRemoteRepositoryConfigUpstreamCredentials.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepositoryRemoteRepositoryConfigUpstreamCredentials.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 username_password_credentials: Optional['outputs.RepositoryRemoteRepositoryConfigUpstreamCredentialsUsernamePasswordCredentials'] = None):
        """
        :param 'RepositoryRemoteRepositoryConfigUpstreamCredentialsUsernamePasswordCredentialsArgs' username_password_credentials: Use username and password to access the remote repository.
               Structure is documented below.
        """
        if username_password_credentials is not None:
            pulumi.set(__self__, "username_password_credentials", username_password_credentials)

    @property
    @pulumi.getter(name="usernamePasswordCredentials")
    def username_password_credentials(self) -> Optional['outputs.RepositoryRemoteRepositoryConfigUpstreamCredentialsUsernamePasswordCredentials']:
        """
        Use username and password to access the remote repository.
        Structure is documented below.
        """
        return pulumi.get(self, "username_password_credentials")


@pulumi.output_type
class RepositoryRemoteRepositoryConfigUpstreamCredentialsUsernamePasswordCredentials(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "passwordSecretVersion":
            suggest = "password_secret_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepositoryRemoteRepositoryConfigUpstreamCredentialsUsernamePasswordCredentials. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepositoryRemoteRepositoryConfigUpstreamCredentialsUsernamePasswordCredentials.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepositoryRemoteRepositoryConfigUpstreamCredentialsUsernamePasswordCredentials.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 password_secret_version: Optional[builtins.str] = None,
                 username: Optional[builtins.str] = None):
        """
        :param builtins.str password_secret_version: The Secret Manager key version that holds the password to access the
               remote repository. Must be in the format of
               `projects/{project}/secrets/{secret}/versions/{version}`.
        :param builtins.str username: The username to access the remote repository.
        """
        if password_secret_version is not None:
            pulumi.set(__self__, "password_secret_version", password_secret_version)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="passwordSecretVersion")
    def password_secret_version(self) -> Optional[builtins.str]:
        """
        The Secret Manager key version that holds the password to access the
        remote repository. Must be in the format of
        `projects/{project}/secrets/{secret}/versions/{version}`.
        """
        return pulumi.get(self, "password_secret_version")

    @property
    @pulumi.getter
    def username(self) -> Optional[builtins.str]:
        """
        The username to access the remote repository.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class RepositoryRemoteRepositoryConfigYumRepository(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publicRepository":
            suggest = "public_repository"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepositoryRemoteRepositoryConfigYumRepository. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepositoryRemoteRepositoryConfigYumRepository.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepositoryRemoteRepositoryConfigYumRepository.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 public_repository: Optional['outputs.RepositoryRemoteRepositoryConfigYumRepositoryPublicRepository'] = None):
        """
        :param 'RepositoryRemoteRepositoryConfigYumRepositoryPublicRepositoryArgs' public_repository: One of the publicly available Yum repositories supported by Artifact Registry.
               Structure is documented below.
        """
        if public_repository is not None:
            pulumi.set(__self__, "public_repository", public_repository)

    @property
    @pulumi.getter(name="publicRepository")
    def public_repository(self) -> Optional['outputs.RepositoryRemoteRepositoryConfigYumRepositoryPublicRepository']:
        """
        One of the publicly available Yum repositories supported by Artifact Registry.
        Structure is documented below.
        """
        return pulumi.get(self, "public_repository")


@pulumi.output_type
class RepositoryRemoteRepositoryConfigYumRepositoryPublicRepository(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "repositoryBase":
            suggest = "repository_base"
        elif key == "repositoryPath":
            suggest = "repository_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepositoryRemoteRepositoryConfigYumRepositoryPublicRepository. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepositoryRemoteRepositoryConfigYumRepositoryPublicRepository.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepositoryRemoteRepositoryConfigYumRepositoryPublicRepository.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 repository_base: builtins.str,
                 repository_path: builtins.str):
        """
        :param builtins.str repository_base: A common public repository base for Yum.
               Possible values are: `CENTOS`, `CENTOS_DEBUG`, `CENTOS_VAULT`, `CENTOS_STREAM`, `ROCKY`, `EPEL`.
        :param builtins.str repository_path: Specific repository from the base, e.g. `"pub/rocky/9/BaseOS/x86_64/os"`
        """
        pulumi.set(__self__, "repository_base", repository_base)
        pulumi.set(__self__, "repository_path", repository_path)

    @property
    @pulumi.getter(name="repositoryBase")
    def repository_base(self) -> builtins.str:
        """
        A common public repository base for Yum.
        Possible values are: `CENTOS`, `CENTOS_DEBUG`, `CENTOS_VAULT`, `CENTOS_STREAM`, `ROCKY`, `EPEL`.
        """
        return pulumi.get(self, "repository_base")

    @property
    @pulumi.getter(name="repositoryPath")
    def repository_path(self) -> builtins.str:
        """
        Specific repository from the base, e.g. `"pub/rocky/9/BaseOS/x86_64/os"`
        """
        return pulumi.get(self, "repository_path")


@pulumi.output_type
class RepositoryVirtualRepositoryConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "upstreamPolicies":
            suggest = "upstream_policies"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepositoryVirtualRepositoryConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepositoryVirtualRepositoryConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepositoryVirtualRepositoryConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 upstream_policies: Optional[Sequence['outputs.RepositoryVirtualRepositoryConfigUpstreamPolicy']] = None):
        """
        :param Sequence['RepositoryVirtualRepositoryConfigUpstreamPolicyArgs'] upstream_policies: Policies that configure the upstream artifacts distributed by the Virtual
               Repository. Upstream policies cannot be set on a standard repository.
               Structure is documented below.
        """
        if upstream_policies is not None:
            pulumi.set(__self__, "upstream_policies", upstream_policies)

    @property
    @pulumi.getter(name="upstreamPolicies")
    def upstream_policies(self) -> Optional[Sequence['outputs.RepositoryVirtualRepositoryConfigUpstreamPolicy']]:
        """
        Policies that configure the upstream artifacts distributed by the Virtual
        Repository. Upstream policies cannot be set on a standard repository.
        Structure is documented below.
        """
        return pulumi.get(self, "upstream_policies")


@pulumi.output_type
class RepositoryVirtualRepositoryConfigUpstreamPolicy(dict):
    def __init__(__self__, *,
                 id: Optional[builtins.str] = None,
                 priority: Optional[builtins.int] = None,
                 repository: Optional[builtins.str] = None):
        """
        :param builtins.str id: The user-provided ID of the upstream policy.
        :param builtins.int priority: Entries with a greater priority value take precedence in the pull order.
        :param builtins.str repository: A reference to the repository resource, for example:
               "projects/p1/locations/us-central1/repository/repo1".
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if repository is not None:
            pulumi.set(__self__, "repository", repository)

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The user-provided ID of the upstream policy.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def priority(self) -> Optional[builtins.int]:
        """
        Entries with a greater priority value take precedence in the pull order.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def repository(self) -> Optional[builtins.str]:
        """
        A reference to the repository resource, for example:
        "projects/p1/locations/us-central1/repository/repo1".
        """
        return pulumi.get(self, "repository")


@pulumi.output_type
class RepositoryVulnerabilityScanningConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enablementConfig":
            suggest = "enablement_config"
        elif key == "enablementState":
            suggest = "enablement_state"
        elif key == "enablementStateReason":
            suggest = "enablement_state_reason"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepositoryVulnerabilityScanningConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepositoryVulnerabilityScanningConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepositoryVulnerabilityScanningConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enablement_config: Optional[builtins.str] = None,
                 enablement_state: Optional[builtins.str] = None,
                 enablement_state_reason: Optional[builtins.str] = None):
        """
        :param builtins.str enablement_config: This configures whether vulnerability scanning is automatically performed for artifacts pushed to this repository.
               Possible values are: `INHERITED`, `DISABLED`.
        :param builtins.str enablement_state: (Output)
               This field returns whether scanning is active for this repository.
        :param builtins.str enablement_state_reason: (Output)
               This provides an explanation for the state of scanning on this repository.
        """
        if enablement_config is not None:
            pulumi.set(__self__, "enablement_config", enablement_config)
        if enablement_state is not None:
            pulumi.set(__self__, "enablement_state", enablement_state)
        if enablement_state_reason is not None:
            pulumi.set(__self__, "enablement_state_reason", enablement_state_reason)

    @property
    @pulumi.getter(name="enablementConfig")
    def enablement_config(self) -> Optional[builtins.str]:
        """
        This configures whether vulnerability scanning is automatically performed for artifacts pushed to this repository.
        Possible values are: `INHERITED`, `DISABLED`.
        """
        return pulumi.get(self, "enablement_config")

    @property
    @pulumi.getter(name="enablementState")
    def enablement_state(self) -> Optional[builtins.str]:
        """
        (Output)
        This field returns whether scanning is active for this repository.
        """
        return pulumi.get(self, "enablement_state")

    @property
    @pulumi.getter(name="enablementStateReason")
    def enablement_state_reason(self) -> Optional[builtins.str]:
        """
        (Output)
        This provides an explanation for the state of scanning on this repository.
        """
        return pulumi.get(self, "enablement_state_reason")


@pulumi.output_type
class GetRepositoryCleanupPolicyResult(dict):
    def __init__(__self__, *,
                 action: builtins.str,
                 conditions: Sequence['outputs.GetRepositoryCleanupPolicyConditionResult'],
                 id: builtins.str,
                 most_recent_versions: Sequence['outputs.GetRepositoryCleanupPolicyMostRecentVersionResult']):
        """
        :param builtins.str action: Policy action. Possible values: ["DELETE", "KEEP"]
        :param Sequence['GetRepositoryCleanupPolicyConditionArgs'] conditions: Policy condition for matching versions.
        :param Sequence['GetRepositoryCleanupPolicyMostRecentVersionArgs'] most_recent_versions: Policy condition for retaining a minimum number of versions. May only be
               specified with a Keep action.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "conditions", conditions)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "most_recent_versions", most_recent_versions)

    @property
    @pulumi.getter
    def action(self) -> builtins.str:
        """
        Policy action. Possible values: ["DELETE", "KEEP"]
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def conditions(self) -> Sequence['outputs.GetRepositoryCleanupPolicyConditionResult']:
        """
        Policy condition for matching versions.
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="mostRecentVersions")
    def most_recent_versions(self) -> Sequence['outputs.GetRepositoryCleanupPolicyMostRecentVersionResult']:
        """
        Policy condition for retaining a minimum number of versions. May only be
        specified with a Keep action.
        """
        return pulumi.get(self, "most_recent_versions")


@pulumi.output_type
class GetRepositoryCleanupPolicyConditionResult(dict):
    def __init__(__self__, *,
                 newer_than: builtins.str,
                 older_than: builtins.str,
                 package_name_prefixes: Sequence[builtins.str],
                 tag_prefixes: Sequence[builtins.str],
                 tag_state: builtins.str,
                 version_name_prefixes: Sequence[builtins.str]):
        """
        :param builtins.str newer_than: Match versions newer than a duration.
        :param builtins.str older_than: Match versions older than a duration.
        :param Sequence[builtins.str] package_name_prefixes: Match versions by package prefix. Applied on any prefix match.
        :param Sequence[builtins.str] tag_prefixes: Match versions by tag prefix. Applied on any prefix match.
        :param builtins.str tag_state: Match versions by tag status. Default value: "ANY" Possible values: ["TAGGED", "UNTAGGED", "ANY"]
        :param Sequence[builtins.str] version_name_prefixes: Match versions by version name prefix. Applied on any prefix match.
        """
        pulumi.set(__self__, "newer_than", newer_than)
        pulumi.set(__self__, "older_than", older_than)
        pulumi.set(__self__, "package_name_prefixes", package_name_prefixes)
        pulumi.set(__self__, "tag_prefixes", tag_prefixes)
        pulumi.set(__self__, "tag_state", tag_state)
        pulumi.set(__self__, "version_name_prefixes", version_name_prefixes)

    @property
    @pulumi.getter(name="newerThan")
    def newer_than(self) -> builtins.str:
        """
        Match versions newer than a duration.
        """
        return pulumi.get(self, "newer_than")

    @property
    @pulumi.getter(name="olderThan")
    def older_than(self) -> builtins.str:
        """
        Match versions older than a duration.
        """
        return pulumi.get(self, "older_than")

    @property
    @pulumi.getter(name="packageNamePrefixes")
    def package_name_prefixes(self) -> Sequence[builtins.str]:
        """
        Match versions by package prefix. Applied on any prefix match.
        """
        return pulumi.get(self, "package_name_prefixes")

    @property
    @pulumi.getter(name="tagPrefixes")
    def tag_prefixes(self) -> Sequence[builtins.str]:
        """
        Match versions by tag prefix. Applied on any prefix match.
        """
        return pulumi.get(self, "tag_prefixes")

    @property
    @pulumi.getter(name="tagState")
    def tag_state(self) -> builtins.str:
        """
        Match versions by tag status. Default value: "ANY" Possible values: ["TAGGED", "UNTAGGED", "ANY"]
        """
        return pulumi.get(self, "tag_state")

    @property
    @pulumi.getter(name="versionNamePrefixes")
    def version_name_prefixes(self) -> Sequence[builtins.str]:
        """
        Match versions by version name prefix. Applied on any prefix match.
        """
        return pulumi.get(self, "version_name_prefixes")


@pulumi.output_type
class GetRepositoryCleanupPolicyMostRecentVersionResult(dict):
    def __init__(__self__, *,
                 keep_count: builtins.int,
                 package_name_prefixes: Sequence[builtins.str]):
        """
        :param builtins.int keep_count: Minimum number of versions to keep.
        :param Sequence[builtins.str] package_name_prefixes: Match versions by package prefix. Applied on any prefix match.
        """
        pulumi.set(__self__, "keep_count", keep_count)
        pulumi.set(__self__, "package_name_prefixes", package_name_prefixes)

    @property
    @pulumi.getter(name="keepCount")
    def keep_count(self) -> builtins.int:
        """
        Minimum number of versions to keep.
        """
        return pulumi.get(self, "keep_count")

    @property
    @pulumi.getter(name="packageNamePrefixes")
    def package_name_prefixes(self) -> Sequence[builtins.str]:
        """
        Match versions by package prefix. Applied on any prefix match.
        """
        return pulumi.get(self, "package_name_prefixes")


@pulumi.output_type
class GetRepositoryDockerConfigResult(dict):
    def __init__(__self__, *,
                 immutable_tags: builtins.bool):
        """
        :param builtins.bool immutable_tags: The repository which enabled this flag prevents all tags from being modified, moved or deleted. This does not prevent tags from being created.
        """
        pulumi.set(__self__, "immutable_tags", immutable_tags)

    @property
    @pulumi.getter(name="immutableTags")
    def immutable_tags(self) -> builtins.bool:
        """
        The repository which enabled this flag prevents all tags from being modified, moved or deleted. This does not prevent tags from being created.
        """
        return pulumi.get(self, "immutable_tags")


@pulumi.output_type
class GetRepositoryMavenConfigResult(dict):
    def __init__(__self__, *,
                 allow_snapshot_overwrites: builtins.bool,
                 version_policy: builtins.str):
        """
        :param builtins.bool allow_snapshot_overwrites: The repository with this flag will allow publishing the same
               snapshot versions.
        :param builtins.str version_policy: Version policy defines the versions that the registry will accept. Default value: "VERSION_POLICY_UNSPECIFIED" Possible values: ["VERSION_POLICY_UNSPECIFIED", "RELEASE", "SNAPSHOT"]
        """
        pulumi.set(__self__, "allow_snapshot_overwrites", allow_snapshot_overwrites)
        pulumi.set(__self__, "version_policy", version_policy)

    @property
    @pulumi.getter(name="allowSnapshotOverwrites")
    def allow_snapshot_overwrites(self) -> builtins.bool:
        """
        The repository with this flag will allow publishing the same
        snapshot versions.
        """
        return pulumi.get(self, "allow_snapshot_overwrites")

    @property
    @pulumi.getter(name="versionPolicy")
    def version_policy(self) -> builtins.str:
        """
        Version policy defines the versions that the registry will accept. Default value: "VERSION_POLICY_UNSPECIFIED" Possible values: ["VERSION_POLICY_UNSPECIFIED", "RELEASE", "SNAPSHOT"]
        """
        return pulumi.get(self, "version_policy")


@pulumi.output_type
class GetRepositoryRemoteRepositoryConfigResult(dict):
    def __init__(__self__, *,
                 apt_repositories: Sequence['outputs.GetRepositoryRemoteRepositoryConfigAptRepositoryResult'],
                 common_repositories: Sequence['outputs.GetRepositoryRemoteRepositoryConfigCommonRepositoryResult'],
                 description: builtins.str,
                 disable_upstream_validation: builtins.bool,
                 docker_repositories: Sequence['outputs.GetRepositoryRemoteRepositoryConfigDockerRepositoryResult'],
                 maven_repositories: Sequence['outputs.GetRepositoryRemoteRepositoryConfigMavenRepositoryResult'],
                 npm_repositories: Sequence['outputs.GetRepositoryRemoteRepositoryConfigNpmRepositoryResult'],
                 python_repositories: Sequence['outputs.GetRepositoryRemoteRepositoryConfigPythonRepositoryResult'],
                 upstream_credentials: Sequence['outputs.GetRepositoryRemoteRepositoryConfigUpstreamCredentialResult'],
                 yum_repositories: Sequence['outputs.GetRepositoryRemoteRepositoryConfigYumRepositoryResult']):
        """
        :param Sequence['GetRepositoryRemoteRepositoryConfigAptRepositoryArgs'] apt_repositories: Specific settings for an Apt remote repository.
        :param Sequence['GetRepositoryRemoteRepositoryConfigCommonRepositoryArgs'] common_repositories: Specific settings for an Artifact Registory remote repository.
        :param builtins.str description: The description of the remote source.
        :param builtins.bool disable_upstream_validation: If true, the remote repository upstream and upstream credentials will
               not be validated.
        :param Sequence['GetRepositoryRemoteRepositoryConfigDockerRepositoryArgs'] docker_repositories: Specific settings for a Docker remote repository.
        :param Sequence['GetRepositoryRemoteRepositoryConfigMavenRepositoryArgs'] maven_repositories: Specific settings for a Maven remote repository.
        :param Sequence['GetRepositoryRemoteRepositoryConfigNpmRepositoryArgs'] npm_repositories: Specific settings for an Npm remote repository.
        :param Sequence['GetRepositoryRemoteRepositoryConfigPythonRepositoryArgs'] python_repositories: Specific settings for a Python remote repository.
        :param Sequence['GetRepositoryRemoteRepositoryConfigUpstreamCredentialArgs'] upstream_credentials: The credentials used to access the remote repository.
        :param Sequence['GetRepositoryRemoteRepositoryConfigYumRepositoryArgs'] yum_repositories: Specific settings for an Yum remote repository.
        """
        pulumi.set(__self__, "apt_repositories", apt_repositories)
        pulumi.set(__self__, "common_repositories", common_repositories)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "disable_upstream_validation", disable_upstream_validation)
        pulumi.set(__self__, "docker_repositories", docker_repositories)
        pulumi.set(__self__, "maven_repositories", maven_repositories)
        pulumi.set(__self__, "npm_repositories", npm_repositories)
        pulumi.set(__self__, "python_repositories", python_repositories)
        pulumi.set(__self__, "upstream_credentials", upstream_credentials)
        pulumi.set(__self__, "yum_repositories", yum_repositories)

    @property
    @pulumi.getter(name="aptRepositories")
    def apt_repositories(self) -> Sequence['outputs.GetRepositoryRemoteRepositoryConfigAptRepositoryResult']:
        """
        Specific settings for an Apt remote repository.
        """
        return pulumi.get(self, "apt_repositories")

    @property
    @pulumi.getter(name="commonRepositories")
    def common_repositories(self) -> Sequence['outputs.GetRepositoryRemoteRepositoryConfigCommonRepositoryResult']:
        """
        Specific settings for an Artifact Registory remote repository.
        """
        return pulumi.get(self, "common_repositories")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        The description of the remote source.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="disableUpstreamValidation")
    def disable_upstream_validation(self) -> builtins.bool:
        """
        If true, the remote repository upstream and upstream credentials will
        not be validated.
        """
        return pulumi.get(self, "disable_upstream_validation")

    @property
    @pulumi.getter(name="dockerRepositories")
    def docker_repositories(self) -> Sequence['outputs.GetRepositoryRemoteRepositoryConfigDockerRepositoryResult']:
        """
        Specific settings for a Docker remote repository.
        """
        return pulumi.get(self, "docker_repositories")

    @property
    @pulumi.getter(name="mavenRepositories")
    def maven_repositories(self) -> Sequence['outputs.GetRepositoryRemoteRepositoryConfigMavenRepositoryResult']:
        """
        Specific settings for a Maven remote repository.
        """
        return pulumi.get(self, "maven_repositories")

    @property
    @pulumi.getter(name="npmRepositories")
    def npm_repositories(self) -> Sequence['outputs.GetRepositoryRemoteRepositoryConfigNpmRepositoryResult']:
        """
        Specific settings for an Npm remote repository.
        """
        return pulumi.get(self, "npm_repositories")

    @property
    @pulumi.getter(name="pythonRepositories")
    def python_repositories(self) -> Sequence['outputs.GetRepositoryRemoteRepositoryConfigPythonRepositoryResult']:
        """
        Specific settings for a Python remote repository.
        """
        return pulumi.get(self, "python_repositories")

    @property
    @pulumi.getter(name="upstreamCredentials")
    def upstream_credentials(self) -> Sequence['outputs.GetRepositoryRemoteRepositoryConfigUpstreamCredentialResult']:
        """
        The credentials used to access the remote repository.
        """
        return pulumi.get(self, "upstream_credentials")

    @property
    @pulumi.getter(name="yumRepositories")
    def yum_repositories(self) -> Sequence['outputs.GetRepositoryRemoteRepositoryConfigYumRepositoryResult']:
        """
        Specific settings for an Yum remote repository.
        """
        return pulumi.get(self, "yum_repositories")


@pulumi.output_type
class GetRepositoryRemoteRepositoryConfigAptRepositoryResult(dict):
    def __init__(__self__, *,
                 public_repositories: Sequence['outputs.GetRepositoryRemoteRepositoryConfigAptRepositoryPublicRepositoryResult']):
        """
        :param Sequence['GetRepositoryRemoteRepositoryConfigAptRepositoryPublicRepositoryArgs'] public_repositories: One of the publicly available Apt repositories supported by Artifact Registry.
        """
        pulumi.set(__self__, "public_repositories", public_repositories)

    @property
    @pulumi.getter(name="publicRepositories")
    def public_repositories(self) -> Sequence['outputs.GetRepositoryRemoteRepositoryConfigAptRepositoryPublicRepositoryResult']:
        """
        One of the publicly available Apt repositories supported by Artifact Registry.
        """
        return pulumi.get(self, "public_repositories")


@pulumi.output_type
class GetRepositoryRemoteRepositoryConfigAptRepositoryPublicRepositoryResult(dict):
    def __init__(__self__, *,
                 repository_base: builtins.str,
                 repository_path: builtins.str):
        """
        :param builtins.str repository_base: A common public repository base for Apt, e.g. '"debian/dists/buster"' Possible values: ["DEBIAN", "UBUNTU", "DEBIAN_SNAPSHOT"]
        :param builtins.str repository_path: Specific repository from the base.
        """
        pulumi.set(__self__, "repository_base", repository_base)
        pulumi.set(__self__, "repository_path", repository_path)

    @property
    @pulumi.getter(name="repositoryBase")
    def repository_base(self) -> builtins.str:
        """
        A common public repository base for Apt, e.g. '"debian/dists/buster"' Possible values: ["DEBIAN", "UBUNTU", "DEBIAN_SNAPSHOT"]
        """
        return pulumi.get(self, "repository_base")

    @property
    @pulumi.getter(name="repositoryPath")
    def repository_path(self) -> builtins.str:
        """
        Specific repository from the base.
        """
        return pulumi.get(self, "repository_path")


@pulumi.output_type
class GetRepositoryRemoteRepositoryConfigCommonRepositoryResult(dict):
    def __init__(__self__, *,
                 uri: builtins.str):
        """
        :param builtins.str uri: One of:
               a. Artifact Registry Repository resource, e.g. 'projects/UPSTREAM_PROJECT_ID/locations/REGION/repositories/UPSTREAM_REPOSITORY'
               b. URI to the registry, e.g. '"https://registry-1.docker.io"'
               c. URI to Artifact Registry Repository, e.g. '"https://REGION-docker.pkg.dev/UPSTREAM_PROJECT_ID/UPSTREAM_REPOSITORY"'
        """
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def uri(self) -> builtins.str:
        """
        One of:
        a. Artifact Registry Repository resource, e.g. 'projects/UPSTREAM_PROJECT_ID/locations/REGION/repositories/UPSTREAM_REPOSITORY'
        b. URI to the registry, e.g. '"https://registry-1.docker.io"'
        c. URI to Artifact Registry Repository, e.g. '"https://REGION-docker.pkg.dev/UPSTREAM_PROJECT_ID/UPSTREAM_REPOSITORY"'
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class GetRepositoryRemoteRepositoryConfigDockerRepositoryResult(dict):
    def __init__(__self__, *,
                 custom_repositories: Sequence['outputs.GetRepositoryRemoteRepositoryConfigDockerRepositoryCustomRepositoryResult'],
                 public_repository: builtins.str):
        """
        :param Sequence['GetRepositoryRemoteRepositoryConfigDockerRepositoryCustomRepositoryArgs'] custom_repositories: [Deprecated, please use commonRepository instead] Settings for a remote repository with a custom uri.
        :param builtins.str public_repository: Address of the remote repository. Default value: "DOCKER_HUB" Possible values: ["DOCKER_HUB"]
        """
        pulumi.set(__self__, "custom_repositories", custom_repositories)
        pulumi.set(__self__, "public_repository", public_repository)

    @property
    @pulumi.getter(name="customRepositories")
    def custom_repositories(self) -> Sequence['outputs.GetRepositoryRemoteRepositoryConfigDockerRepositoryCustomRepositoryResult']:
        """
        [Deprecated, please use commonRepository instead] Settings for a remote repository with a custom uri.
        """
        return pulumi.get(self, "custom_repositories")

    @property
    @pulumi.getter(name="publicRepository")
    def public_repository(self) -> builtins.str:
        """
        Address of the remote repository. Default value: "DOCKER_HUB" Possible values: ["DOCKER_HUB"]
        """
        return pulumi.get(self, "public_repository")


@pulumi.output_type
class GetRepositoryRemoteRepositoryConfigDockerRepositoryCustomRepositoryResult(dict):
    def __init__(__self__, *,
                 uri: builtins.str):
        """
        :param builtins.str uri: Specific uri to the registry, e.g. '"https://registry-1.docker.io"'
        """
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def uri(self) -> builtins.str:
        """
        Specific uri to the registry, e.g. '"https://registry-1.docker.io"'
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class GetRepositoryRemoteRepositoryConfigMavenRepositoryResult(dict):
    def __init__(__self__, *,
                 custom_repositories: Sequence['outputs.GetRepositoryRemoteRepositoryConfigMavenRepositoryCustomRepositoryResult'],
                 public_repository: builtins.str):
        """
        :param Sequence['GetRepositoryRemoteRepositoryConfigMavenRepositoryCustomRepositoryArgs'] custom_repositories: [Deprecated, please use commonRepository instead] Settings for a remote repository with a custom uri.
        :param builtins.str public_repository: Address of the remote repository. Default value: "MAVEN_CENTRAL" Possible values: ["MAVEN_CENTRAL"]
        """
        pulumi.set(__self__, "custom_repositories", custom_repositories)
        pulumi.set(__self__, "public_repository", public_repository)

    @property
    @pulumi.getter(name="customRepositories")
    def custom_repositories(self) -> Sequence['outputs.GetRepositoryRemoteRepositoryConfigMavenRepositoryCustomRepositoryResult']:
        """
        [Deprecated, please use commonRepository instead] Settings for a remote repository with a custom uri.
        """
        return pulumi.get(self, "custom_repositories")

    @property
    @pulumi.getter(name="publicRepository")
    def public_repository(self) -> builtins.str:
        """
        Address of the remote repository. Default value: "MAVEN_CENTRAL" Possible values: ["MAVEN_CENTRAL"]
        """
        return pulumi.get(self, "public_repository")


@pulumi.output_type
class GetRepositoryRemoteRepositoryConfigMavenRepositoryCustomRepositoryResult(dict):
    def __init__(__self__, *,
                 uri: builtins.str):
        """
        :param builtins.str uri: Specific uri to the registry, e.g. '"https://repo.maven.apache.org/maven2"'
        """
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def uri(self) -> builtins.str:
        """
        Specific uri to the registry, e.g. '"https://repo.maven.apache.org/maven2"'
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class GetRepositoryRemoteRepositoryConfigNpmRepositoryResult(dict):
    def __init__(__self__, *,
                 custom_repositories: Sequence['outputs.GetRepositoryRemoteRepositoryConfigNpmRepositoryCustomRepositoryResult'],
                 public_repository: builtins.str):
        """
        :param Sequence['GetRepositoryRemoteRepositoryConfigNpmRepositoryCustomRepositoryArgs'] custom_repositories: [Deprecated, please use commonRepository instead] Settings for a remote repository with a custom uri.
        :param builtins.str public_repository: Address of the remote repository. Default value: "NPMJS" Possible values: ["NPMJS"]
        """
        pulumi.set(__self__, "custom_repositories", custom_repositories)
        pulumi.set(__self__, "public_repository", public_repository)

    @property
    @pulumi.getter(name="customRepositories")
    def custom_repositories(self) -> Sequence['outputs.GetRepositoryRemoteRepositoryConfigNpmRepositoryCustomRepositoryResult']:
        """
        [Deprecated, please use commonRepository instead] Settings for a remote repository with a custom uri.
        """
        return pulumi.get(self, "custom_repositories")

    @property
    @pulumi.getter(name="publicRepository")
    def public_repository(self) -> builtins.str:
        """
        Address of the remote repository. Default value: "NPMJS" Possible values: ["NPMJS"]
        """
        return pulumi.get(self, "public_repository")


@pulumi.output_type
class GetRepositoryRemoteRepositoryConfigNpmRepositoryCustomRepositoryResult(dict):
    def __init__(__self__, *,
                 uri: builtins.str):
        """
        :param builtins.str uri: Specific uri to the registry, e.g. '"https://registry.npmjs.org"'
        """
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def uri(self) -> builtins.str:
        """
        Specific uri to the registry, e.g. '"https://registry.npmjs.org"'
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class GetRepositoryRemoteRepositoryConfigPythonRepositoryResult(dict):
    def __init__(__self__, *,
                 custom_repositories: Sequence['outputs.GetRepositoryRemoteRepositoryConfigPythonRepositoryCustomRepositoryResult'],
                 public_repository: builtins.str):
        """
        :param Sequence['GetRepositoryRemoteRepositoryConfigPythonRepositoryCustomRepositoryArgs'] custom_repositories: [Deprecated, please use commonRepository instead] Settings for a remote repository with a custom uri.
        :param builtins.str public_repository: Address of the remote repository. Default value: "PYPI" Possible values: ["PYPI"]
        """
        pulumi.set(__self__, "custom_repositories", custom_repositories)
        pulumi.set(__self__, "public_repository", public_repository)

    @property
    @pulumi.getter(name="customRepositories")
    def custom_repositories(self) -> Sequence['outputs.GetRepositoryRemoteRepositoryConfigPythonRepositoryCustomRepositoryResult']:
        """
        [Deprecated, please use commonRepository instead] Settings for a remote repository with a custom uri.
        """
        return pulumi.get(self, "custom_repositories")

    @property
    @pulumi.getter(name="publicRepository")
    def public_repository(self) -> builtins.str:
        """
        Address of the remote repository. Default value: "PYPI" Possible values: ["PYPI"]
        """
        return pulumi.get(self, "public_repository")


@pulumi.output_type
class GetRepositoryRemoteRepositoryConfigPythonRepositoryCustomRepositoryResult(dict):
    def __init__(__self__, *,
                 uri: builtins.str):
        """
        :param builtins.str uri: Specific uri to the registry, e.g. '"https://pypi.io"'
        """
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def uri(self) -> builtins.str:
        """
        Specific uri to the registry, e.g. '"https://pypi.io"'
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class GetRepositoryRemoteRepositoryConfigUpstreamCredentialResult(dict):
    def __init__(__self__, *,
                 username_password_credentials: Sequence['outputs.GetRepositoryRemoteRepositoryConfigUpstreamCredentialUsernamePasswordCredentialResult']):
        """
        :param Sequence['GetRepositoryRemoteRepositoryConfigUpstreamCredentialUsernamePasswordCredentialArgs'] username_password_credentials: Use username and password to access the remote repository.
        """
        pulumi.set(__self__, "username_password_credentials", username_password_credentials)

    @property
    @pulumi.getter(name="usernamePasswordCredentials")
    def username_password_credentials(self) -> Sequence['outputs.GetRepositoryRemoteRepositoryConfigUpstreamCredentialUsernamePasswordCredentialResult']:
        """
        Use username and password to access the remote repository.
        """
        return pulumi.get(self, "username_password_credentials")


@pulumi.output_type
class GetRepositoryRemoteRepositoryConfigUpstreamCredentialUsernamePasswordCredentialResult(dict):
    def __init__(__self__, *,
                 password_secret_version: builtins.str,
                 username: builtins.str):
        """
        :param builtins.str password_secret_version: The Secret Manager key version that holds the password to access the
               remote repository. Must be in the format of
               'projects/{project}/secrets/{secret}/versions/{version}'.
        :param builtins.str username: The username to access the remote repository.
        """
        pulumi.set(__self__, "password_secret_version", password_secret_version)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="passwordSecretVersion")
    def password_secret_version(self) -> builtins.str:
        """
        The Secret Manager key version that holds the password to access the
        remote repository. Must be in the format of
        'projects/{project}/secrets/{secret}/versions/{version}'.
        """
        return pulumi.get(self, "password_secret_version")

    @property
    @pulumi.getter
    def username(self) -> builtins.str:
        """
        The username to access the remote repository.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class GetRepositoryRemoteRepositoryConfigYumRepositoryResult(dict):
    def __init__(__self__, *,
                 public_repositories: Sequence['outputs.GetRepositoryRemoteRepositoryConfigYumRepositoryPublicRepositoryResult']):
        """
        :param Sequence['GetRepositoryRemoteRepositoryConfigYumRepositoryPublicRepositoryArgs'] public_repositories: One of the publicly available Yum repositories supported by Artifact Registry.
        """
        pulumi.set(__self__, "public_repositories", public_repositories)

    @property
    @pulumi.getter(name="publicRepositories")
    def public_repositories(self) -> Sequence['outputs.GetRepositoryRemoteRepositoryConfigYumRepositoryPublicRepositoryResult']:
        """
        One of the publicly available Yum repositories supported by Artifact Registry.
        """
        return pulumi.get(self, "public_repositories")


@pulumi.output_type
class GetRepositoryRemoteRepositoryConfigYumRepositoryPublicRepositoryResult(dict):
    def __init__(__self__, *,
                 repository_base: builtins.str,
                 repository_path: builtins.str):
        """
        :param builtins.str repository_base: A common public repository base for Yum. Possible values: ["CENTOS", "CENTOS_DEBUG", "CENTOS_VAULT", "CENTOS_STREAM", "ROCKY", "EPEL"]
        :param builtins.str repository_path: Specific repository from the base, e.g. '"pub/rocky/9/BaseOS/x86_64/os"'
        """
        pulumi.set(__self__, "repository_base", repository_base)
        pulumi.set(__self__, "repository_path", repository_path)

    @property
    @pulumi.getter(name="repositoryBase")
    def repository_base(self) -> builtins.str:
        """
        A common public repository base for Yum. Possible values: ["CENTOS", "CENTOS_DEBUG", "CENTOS_VAULT", "CENTOS_STREAM", "ROCKY", "EPEL"]
        """
        return pulumi.get(self, "repository_base")

    @property
    @pulumi.getter(name="repositoryPath")
    def repository_path(self) -> builtins.str:
        """
        Specific repository from the base, e.g. '"pub/rocky/9/BaseOS/x86_64/os"'
        """
        return pulumi.get(self, "repository_path")


@pulumi.output_type
class GetRepositoryVirtualRepositoryConfigResult(dict):
    def __init__(__self__, *,
                 upstream_policies: Sequence['outputs.GetRepositoryVirtualRepositoryConfigUpstreamPolicyResult']):
        """
        :param Sequence['GetRepositoryVirtualRepositoryConfigUpstreamPolicyArgs'] upstream_policies: Policies that configure the upstream artifacts distributed by the Virtual
               Repository. Upstream policies cannot be set on a standard repository.
        """
        pulumi.set(__self__, "upstream_policies", upstream_policies)

    @property
    @pulumi.getter(name="upstreamPolicies")
    def upstream_policies(self) -> Sequence['outputs.GetRepositoryVirtualRepositoryConfigUpstreamPolicyResult']:
        """
        Policies that configure the upstream artifacts distributed by the Virtual
        Repository. Upstream policies cannot be set on a standard repository.
        """
        return pulumi.get(self, "upstream_policies")


@pulumi.output_type
class GetRepositoryVirtualRepositoryConfigUpstreamPolicyResult(dict):
    def __init__(__self__, *,
                 id: builtins.str,
                 priority: builtins.int,
                 repository: builtins.str):
        """
        :param builtins.str id: The user-provided ID of the upstream policy.
        :param builtins.int priority: Entries with a greater priority value take precedence in the pull order.
        :param builtins.str repository: A reference to the repository resource, for example:
               "projects/p1/locations/us-central1/repository/repo1".
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "repository", repository)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The user-provided ID of the upstream policy.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def priority(self) -> builtins.int:
        """
        Entries with a greater priority value take precedence in the pull order.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def repository(self) -> builtins.str:
        """
        A reference to the repository resource, for example:
        "projects/p1/locations/us-central1/repository/repo1".
        """
        return pulumi.get(self, "repository")


@pulumi.output_type
class GetRepositoryVulnerabilityScanningConfigResult(dict):
    def __init__(__self__, *,
                 enablement_config: builtins.str,
                 enablement_state: builtins.str,
                 enablement_state_reason: builtins.str):
        """
        :param builtins.str enablement_config: This configures whether vulnerability scanning is automatically performed for artifacts pushed to this repository. Possible values: ["INHERITED", "DISABLED"]
        :param builtins.str enablement_state: This field returns whether scanning is active for this repository.
        :param builtins.str enablement_state_reason: This provides an explanation for the state of scanning on this repository.
        """
        pulumi.set(__self__, "enablement_config", enablement_config)
        pulumi.set(__self__, "enablement_state", enablement_state)
        pulumi.set(__self__, "enablement_state_reason", enablement_state_reason)

    @property
    @pulumi.getter(name="enablementConfig")
    def enablement_config(self) -> builtins.str:
        """
        This configures whether vulnerability scanning is automatically performed for artifacts pushed to this repository. Possible values: ["INHERITED", "DISABLED"]
        """
        return pulumi.get(self, "enablement_config")

    @property
    @pulumi.getter(name="enablementState")
    def enablement_state(self) -> builtins.str:
        """
        This field returns whether scanning is active for this repository.
        """
        return pulumi.get(self, "enablement_state")

    @property
    @pulumi.getter(name="enablementStateReason")
    def enablement_state_reason(self) -> builtins.str:
        """
        This provides an explanation for the state of scanning on this repository.
        """
        return pulumi.get(self, "enablement_state_reason")


