# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BackupPlanArgs', 'BackupPlan']

@pulumi.input_type
class BackupPlanArgs:
    def __init__(__self__, *,
                 backup_plan_id: pulumi.Input[builtins.str],
                 backup_rules: pulumi.Input[Sequence[pulumi.Input['BackupPlanBackupRuleArgs']]],
                 backup_vault: pulumi.Input[builtins.str],
                 location: pulumi.Input[builtins.str],
                 resource_type: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a BackupPlan resource.
        :param pulumi.Input[builtins.str] backup_plan_id: The ID of the backup plan
        :param pulumi.Input[Sequence[pulumi.Input['BackupPlanBackupRuleArgs']]] backup_rules: The backup rules for this `BackupPlan`. There must be at least one `BackupRule` message.
               Structure is documented below.
        :param pulumi.Input[builtins.str] backup_vault: Backup vault where the backups gets stored using this Backup plan.
        :param pulumi.Input[builtins.str] location: The location for the backup plan
        :param pulumi.Input[builtins.str] resource_type: The resource type to which the `BackupPlan` will be applied.
               Examples include, "compute.googleapis.com/Instance", "compute.googleapis.com/Disk", and "storage.googleapis.com/Bucket".
        :param pulumi.Input[builtins.str] description: The description allows for additional details about `BackupPlan` and its use cases to be provided.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "backup_plan_id", backup_plan_id)
        pulumi.set(__self__, "backup_rules", backup_rules)
        pulumi.set(__self__, "backup_vault", backup_vault)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "resource_type", resource_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="backupPlanId")
    def backup_plan_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the backup plan
        """
        return pulumi.get(self, "backup_plan_id")

    @backup_plan_id.setter
    def backup_plan_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "backup_plan_id", value)

    @property
    @pulumi.getter(name="backupRules")
    def backup_rules(self) -> pulumi.Input[Sequence[pulumi.Input['BackupPlanBackupRuleArgs']]]:
        """
        The backup rules for this `BackupPlan`. There must be at least one `BackupRule` message.
        Structure is documented below.
        """
        return pulumi.get(self, "backup_rules")

    @backup_rules.setter
    def backup_rules(self, value: pulumi.Input[Sequence[pulumi.Input['BackupPlanBackupRuleArgs']]]):
        pulumi.set(self, "backup_rules", value)

    @property
    @pulumi.getter(name="backupVault")
    def backup_vault(self) -> pulumi.Input[builtins.str]:
        """
        Backup vault where the backups gets stored using this Backup plan.
        """
        return pulumi.get(self, "backup_vault")

    @backup_vault.setter
    def backup_vault(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "backup_vault", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        The location for the backup plan
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Input[builtins.str]:
        """
        The resource type to which the `BackupPlan` will be applied.
        Examples include, "compute.googleapis.com/Instance", "compute.googleapis.com/Disk", and "storage.googleapis.com/Bucket".
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description allows for additional details about `BackupPlan` and its use cases to be provided.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _BackupPlanState:
    def __init__(__self__, *,
                 backup_plan_id: Optional[pulumi.Input[builtins.str]] = None,
                 backup_rules: Optional[pulumi.Input[Sequence[pulumi.Input['BackupPlanBackupRuleArgs']]]] = None,
                 backup_vault: Optional[pulumi.Input[builtins.str]] = None,
                 backup_vault_service_account: Optional[pulumi.Input[builtins.str]] = None,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 resource_type: Optional[pulumi.Input[builtins.str]] = None,
                 supported_resource_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering BackupPlan resources.
        :param pulumi.Input[builtins.str] backup_plan_id: The ID of the backup plan
        :param pulumi.Input[Sequence[pulumi.Input['BackupPlanBackupRuleArgs']]] backup_rules: The backup rules for this `BackupPlan`. There must be at least one `BackupRule` message.
               Structure is documented below.
        :param pulumi.Input[builtins.str] backup_vault: Backup vault where the backups gets stored using this Backup plan.
        :param pulumi.Input[builtins.str] backup_vault_service_account: The Google Cloud Platform Service Account to be used by the BackupVault for taking backups.
        :param pulumi.Input[builtins.str] create_time: When the `BackupPlan` was created.
        :param pulumi.Input[builtins.str] description: The description allows for additional details about `BackupPlan` and its use cases to be provided.
        :param pulumi.Input[builtins.str] location: The location for the backup plan
        :param pulumi.Input[builtins.str] name: The name of backup plan resource created
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] resource_type: The resource type to which the `BackupPlan` will be applied.
               Examples include, "compute.googleapis.com/Instance", "compute.googleapis.com/Disk", and "storage.googleapis.com/Bucket".
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] supported_resource_types: The list of all resource types to which the 'BackupPlan' can be applied.
        :param pulumi.Input[builtins.str] update_time: When the `BackupPlan` was last updated.
        """
        if backup_plan_id is not None:
            pulumi.set(__self__, "backup_plan_id", backup_plan_id)
        if backup_rules is not None:
            pulumi.set(__self__, "backup_rules", backup_rules)
        if backup_vault is not None:
            pulumi.set(__self__, "backup_vault", backup_vault)
        if backup_vault_service_account is not None:
            pulumi.set(__self__, "backup_vault_service_account", backup_vault_service_account)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)
        if supported_resource_types is not None:
            pulumi.set(__self__, "supported_resource_types", supported_resource_types)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="backupPlanId")
    def backup_plan_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the backup plan
        """
        return pulumi.get(self, "backup_plan_id")

    @backup_plan_id.setter
    def backup_plan_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "backup_plan_id", value)

    @property
    @pulumi.getter(name="backupRules")
    def backup_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BackupPlanBackupRuleArgs']]]]:
        """
        The backup rules for this `BackupPlan`. There must be at least one `BackupRule` message.
        Structure is documented below.
        """
        return pulumi.get(self, "backup_rules")

    @backup_rules.setter
    def backup_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BackupPlanBackupRuleArgs']]]]):
        pulumi.set(self, "backup_rules", value)

    @property
    @pulumi.getter(name="backupVault")
    def backup_vault(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Backup vault where the backups gets stored using this Backup plan.
        """
        return pulumi.get(self, "backup_vault")

    @backup_vault.setter
    def backup_vault(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "backup_vault", value)

    @property
    @pulumi.getter(name="backupVaultServiceAccount")
    def backup_vault_service_account(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Google Cloud Platform Service Account to be used by the BackupVault for taking backups.
        """
        return pulumi.get(self, "backup_vault_service_account")

    @backup_vault_service_account.setter
    def backup_vault_service_account(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "backup_vault_service_account", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        When the `BackupPlan` was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description allows for additional details about `BackupPlan` and its use cases to be provided.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location for the backup plan
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of backup plan resource created
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource type to which the `BackupPlan` will be applied.
        Examples include, "compute.googleapis.com/Instance", "compute.googleapis.com/Disk", and "storage.googleapis.com/Bucket".
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_type", value)

    @property
    @pulumi.getter(name="supportedResourceTypes")
    def supported_resource_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The list of all resource types to which the 'BackupPlan' can be applied.
        """
        return pulumi.get(self, "supported_resource_types")

    @supported_resource_types.setter
    def supported_resource_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "supported_resource_types", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        When the `BackupPlan` was last updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:backupdisasterrecovery/backupPlan:BackupPlan")
class BackupPlan(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_plan_id: Optional[pulumi.Input[builtins.str]] = None,
                 backup_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BackupPlanBackupRuleArgs', 'BackupPlanBackupRuleArgsDict']]]]] = None,
                 backup_vault: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 resource_type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        A backup plan defines when and how to back up a resource, including the backup's schedule, retention, and location.

        To get more information about BackupPlan, see:

        * [API documentation](https://cloud.google.com/backup-disaster-recovery/docs/reference/rest)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/backup-disaster-recovery/docs)

        ## Example Usage

        ### Backup Dr Backup Plan Simple

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_backup_vault = gcp.backupdisasterrecovery.BackupVault("my_backup_vault",
            location="us-central1",
            backup_vault_id="backup-vault-simple-test",
            backup_minimum_enforced_retention_duration="100000s")
        my_backup_plan_1 = gcp.backupdisasterrecovery.BackupPlan("my-backup-plan-1",
            location="us-central1",
            backup_plan_id="backup-plan-simple-test",
            resource_type="compute.googleapis.com/Instance",
            backup_vault=my_backup_vault.id,
            backup_rules=[{
                "rule_id": "rule-1",
                "backup_retention_days": 5,
                "standard_schedule": {
                    "recurrence_type": "HOURLY",
                    "hourly_frequency": 6,
                    "time_zone": "UTC",
                    "backup_window": {
                        "start_hour_of_day": 0,
                        "end_hour_of_day": 24,
                    },
                },
            }])
        ```
        ### Backup Dr Backup Plan For Disk Resource

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_backup_vault = gcp.backupdisasterrecovery.BackupVault("my_backup_vault",
            location="us-central1",
            backup_vault_id="backup-vault-disk-test",
            backup_minimum_enforced_retention_duration="100000s")
        my_disk_backup_plan_1 = gcp.backupdisasterrecovery.BackupPlan("my-disk-backup-plan-1",
            location="us-central1",
            backup_plan_id="backup-plan-disk-test",
            resource_type="compute.googleapis.com/Disk",
            backup_vault=my_backup_vault.id,
            backup_rules=[{
                "rule_id": "rule-1",
                "backup_retention_days": 5,
                "standard_schedule": {
                    "recurrence_type": "HOURLY",
                    "hourly_frequency": 1,
                    "time_zone": "UTC",
                    "backup_window": {
                        "start_hour_of_day": 0,
                        "end_hour_of_day": 6,
                    },
                },
            }])
        ```

        ## Import

        BackupPlan can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/backupPlans/{{backup_plan_id}}`

        * `{{project}}/{{location}}/{{backup_plan_id}}`

        * `{{location}}/{{backup_plan_id}}`

        When using the `pulumi import` command, BackupPlan can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:backupdisasterrecovery/backupPlan:BackupPlan default projects/{{project}}/locations/{{location}}/backupPlans/{{backup_plan_id}}
        ```

        ```sh
        $ pulumi import gcp:backupdisasterrecovery/backupPlan:BackupPlan default {{project}}/{{location}}/{{backup_plan_id}}
        ```

        ```sh
        $ pulumi import gcp:backupdisasterrecovery/backupPlan:BackupPlan default {{location}}/{{backup_plan_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] backup_plan_id: The ID of the backup plan
        :param pulumi.Input[Sequence[pulumi.Input[Union['BackupPlanBackupRuleArgs', 'BackupPlanBackupRuleArgsDict']]]] backup_rules: The backup rules for this `BackupPlan`. There must be at least one `BackupRule` message.
               Structure is documented below.
        :param pulumi.Input[builtins.str] backup_vault: Backup vault where the backups gets stored using this Backup plan.
        :param pulumi.Input[builtins.str] description: The description allows for additional details about `BackupPlan` and its use cases to be provided.
        :param pulumi.Input[builtins.str] location: The location for the backup plan
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] resource_type: The resource type to which the `BackupPlan` will be applied.
               Examples include, "compute.googleapis.com/Instance", "compute.googleapis.com/Disk", and "storage.googleapis.com/Bucket".
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BackupPlanArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A backup plan defines when and how to back up a resource, including the backup's schedule, retention, and location.

        To get more information about BackupPlan, see:

        * [API documentation](https://cloud.google.com/backup-disaster-recovery/docs/reference/rest)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/backup-disaster-recovery/docs)

        ## Example Usage

        ### Backup Dr Backup Plan Simple

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_backup_vault = gcp.backupdisasterrecovery.BackupVault("my_backup_vault",
            location="us-central1",
            backup_vault_id="backup-vault-simple-test",
            backup_minimum_enforced_retention_duration="100000s")
        my_backup_plan_1 = gcp.backupdisasterrecovery.BackupPlan("my-backup-plan-1",
            location="us-central1",
            backup_plan_id="backup-plan-simple-test",
            resource_type="compute.googleapis.com/Instance",
            backup_vault=my_backup_vault.id,
            backup_rules=[{
                "rule_id": "rule-1",
                "backup_retention_days": 5,
                "standard_schedule": {
                    "recurrence_type": "HOURLY",
                    "hourly_frequency": 6,
                    "time_zone": "UTC",
                    "backup_window": {
                        "start_hour_of_day": 0,
                        "end_hour_of_day": 24,
                    },
                },
            }])
        ```
        ### Backup Dr Backup Plan For Disk Resource

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_backup_vault = gcp.backupdisasterrecovery.BackupVault("my_backup_vault",
            location="us-central1",
            backup_vault_id="backup-vault-disk-test",
            backup_minimum_enforced_retention_duration="100000s")
        my_disk_backup_plan_1 = gcp.backupdisasterrecovery.BackupPlan("my-disk-backup-plan-1",
            location="us-central1",
            backup_plan_id="backup-plan-disk-test",
            resource_type="compute.googleapis.com/Disk",
            backup_vault=my_backup_vault.id,
            backup_rules=[{
                "rule_id": "rule-1",
                "backup_retention_days": 5,
                "standard_schedule": {
                    "recurrence_type": "HOURLY",
                    "hourly_frequency": 1,
                    "time_zone": "UTC",
                    "backup_window": {
                        "start_hour_of_day": 0,
                        "end_hour_of_day": 6,
                    },
                },
            }])
        ```

        ## Import

        BackupPlan can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/backupPlans/{{backup_plan_id}}`

        * `{{project}}/{{location}}/{{backup_plan_id}}`

        * `{{location}}/{{backup_plan_id}}`

        When using the `pulumi import` command, BackupPlan can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:backupdisasterrecovery/backupPlan:BackupPlan default projects/{{project}}/locations/{{location}}/backupPlans/{{backup_plan_id}}
        ```

        ```sh
        $ pulumi import gcp:backupdisasterrecovery/backupPlan:BackupPlan default {{project}}/{{location}}/{{backup_plan_id}}
        ```

        ```sh
        $ pulumi import gcp:backupdisasterrecovery/backupPlan:BackupPlan default {{location}}/{{backup_plan_id}}
        ```

        :param str resource_name: The name of the resource.
        :param BackupPlanArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BackupPlanArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_plan_id: Optional[pulumi.Input[builtins.str]] = None,
                 backup_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BackupPlanBackupRuleArgs', 'BackupPlanBackupRuleArgsDict']]]]] = None,
                 backup_vault: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 resource_type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BackupPlanArgs.__new__(BackupPlanArgs)

            if backup_plan_id is None and not opts.urn:
                raise TypeError("Missing required property 'backup_plan_id'")
            __props__.__dict__["backup_plan_id"] = backup_plan_id
            if backup_rules is None and not opts.urn:
                raise TypeError("Missing required property 'backup_rules'")
            __props__.__dict__["backup_rules"] = backup_rules
            if backup_vault is None and not opts.urn:
                raise TypeError("Missing required property 'backup_vault'")
            __props__.__dict__["backup_vault"] = backup_vault
            __props__.__dict__["description"] = description
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            if resource_type is None and not opts.urn:
                raise TypeError("Missing required property 'resource_type'")
            __props__.__dict__["resource_type"] = resource_type
            __props__.__dict__["backup_vault_service_account"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["supported_resource_types"] = None
            __props__.__dict__["update_time"] = None
        super(BackupPlan, __self__).__init__(
            'gcp:backupdisasterrecovery/backupPlan:BackupPlan',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backup_plan_id: Optional[pulumi.Input[builtins.str]] = None,
            backup_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BackupPlanBackupRuleArgs', 'BackupPlanBackupRuleArgsDict']]]]] = None,
            backup_vault: Optional[pulumi.Input[builtins.str]] = None,
            backup_vault_service_account: Optional[pulumi.Input[builtins.str]] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            resource_type: Optional[pulumi.Input[builtins.str]] = None,
            supported_resource_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None) -> 'BackupPlan':
        """
        Get an existing BackupPlan resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] backup_plan_id: The ID of the backup plan
        :param pulumi.Input[Sequence[pulumi.Input[Union['BackupPlanBackupRuleArgs', 'BackupPlanBackupRuleArgsDict']]]] backup_rules: The backup rules for this `BackupPlan`. There must be at least one `BackupRule` message.
               Structure is documented below.
        :param pulumi.Input[builtins.str] backup_vault: Backup vault where the backups gets stored using this Backup plan.
        :param pulumi.Input[builtins.str] backup_vault_service_account: The Google Cloud Platform Service Account to be used by the BackupVault for taking backups.
        :param pulumi.Input[builtins.str] create_time: When the `BackupPlan` was created.
        :param pulumi.Input[builtins.str] description: The description allows for additional details about `BackupPlan` and its use cases to be provided.
        :param pulumi.Input[builtins.str] location: The location for the backup plan
        :param pulumi.Input[builtins.str] name: The name of backup plan resource created
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] resource_type: The resource type to which the `BackupPlan` will be applied.
               Examples include, "compute.googleapis.com/Instance", "compute.googleapis.com/Disk", and "storage.googleapis.com/Bucket".
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] supported_resource_types: The list of all resource types to which the 'BackupPlan' can be applied.
        :param pulumi.Input[builtins.str] update_time: When the `BackupPlan` was last updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BackupPlanState.__new__(_BackupPlanState)

        __props__.__dict__["backup_plan_id"] = backup_plan_id
        __props__.__dict__["backup_rules"] = backup_rules
        __props__.__dict__["backup_vault"] = backup_vault
        __props__.__dict__["backup_vault_service_account"] = backup_vault_service_account
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["resource_type"] = resource_type
        __props__.__dict__["supported_resource_types"] = supported_resource_types
        __props__.__dict__["update_time"] = update_time
        return BackupPlan(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="backupPlanId")
    def backup_plan_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the backup plan
        """
        return pulumi.get(self, "backup_plan_id")

    @property
    @pulumi.getter(name="backupRules")
    def backup_rules(self) -> pulumi.Output[Sequence['outputs.BackupPlanBackupRule']]:
        """
        The backup rules for this `BackupPlan`. There must be at least one `BackupRule` message.
        Structure is documented below.
        """
        return pulumi.get(self, "backup_rules")

    @property
    @pulumi.getter(name="backupVault")
    def backup_vault(self) -> pulumi.Output[builtins.str]:
        """
        Backup vault where the backups gets stored using this Backup plan.
        """
        return pulumi.get(self, "backup_vault")

    @property
    @pulumi.getter(name="backupVaultServiceAccount")
    def backup_vault_service_account(self) -> pulumi.Output[builtins.str]:
        """
        The Google Cloud Platform Service Account to be used by the BackupVault for taking backups.
        """
        return pulumi.get(self, "backup_vault_service_account")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        When the `BackupPlan` was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description allows for additional details about `BackupPlan` and its use cases to be provided.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The location for the backup plan
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of backup plan resource created
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Output[builtins.str]:
        """
        The resource type to which the `BackupPlan` will be applied.
        Examples include, "compute.googleapis.com/Instance", "compute.googleapis.com/Disk", and "storage.googleapis.com/Bucket".
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter(name="supportedResourceTypes")
    def supported_resource_types(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        The list of all resource types to which the 'BackupPlan' can be applied.
        """
        return pulumi.get(self, "supported_resource_types")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        When the `BackupPlan` was last updated.
        """
        return pulumi.get(self, "update_time")

