# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DatabaseArgs', 'Database']

@pulumi.input_type
class DatabaseArgs:
    def __init__(__self__, *,
                 catalog: pulumi.Input[builtins.str],
                 hive_options: pulumi.Input['DatabaseHiveOptionsArgs'],
                 type: pulumi.Input[builtins.str],
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Database resource.
        :param pulumi.Input[builtins.str] catalog: The parent catalog.
        :param pulumi.Input['DatabaseHiveOptionsArgs'] hive_options: Options of a Hive database.
               Structure is documented below.
        :param pulumi.Input[builtins.str] type: The database type.
        :param pulumi.Input[builtins.str] name: The name of the database.
        """
        pulumi.set(__self__, "catalog", catalog)
        pulumi.set(__self__, "hive_options", hive_options)
        pulumi.set(__self__, "type", type)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def catalog(self) -> pulumi.Input[builtins.str]:
        """
        The parent catalog.
        """
        return pulumi.get(self, "catalog")

    @catalog.setter
    def catalog(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "catalog", value)

    @property
    @pulumi.getter(name="hiveOptions")
    def hive_options(self) -> pulumi.Input['DatabaseHiveOptionsArgs']:
        """
        Options of a Hive database.
        Structure is documented below.
        """
        return pulumi.get(self, "hive_options")

    @hive_options.setter
    def hive_options(self, value: pulumi.Input['DatabaseHiveOptionsArgs']):
        pulumi.set(self, "hive_options", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        The database type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the database.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _DatabaseState:
    def __init__(__self__, *,
                 catalog: Optional[pulumi.Input[builtins.str]] = None,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 delete_time: Optional[pulumi.Input[builtins.str]] = None,
                 expire_time: Optional[pulumi.Input[builtins.str]] = None,
                 hive_options: Optional[pulumi.Input['DatabaseHiveOptionsArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Database resources.
        :param pulumi.Input[builtins.str] catalog: The parent catalog.
        :param pulumi.Input[builtins.str] create_time: Output only. The creation time of the database. A timestamp in RFC3339
               UTC "Zulu" format, with nanosecond resolution and up to nine fractional
               digits. Examples: "2014-10-02T15:01:23Z" and
               "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input[builtins.str] delete_time: Output only. The deletion time of the database. Only set after the
               database is deleted. A timestamp in RFC3339 UTC "Zulu" format, with
               nanosecond resolution and up to nine fractional digits. Examples:
               "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input[builtins.str] expire_time: Output only. The time when this database is considered expired. Only set
               after the database is deleted. A timestamp in RFC3339 UTC "Zulu" format,
               with nanosecond resolution and up to nine fractional digits. Examples:
               "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input['DatabaseHiveOptionsArgs'] hive_options: Options of a Hive database.
               Structure is documented below.
        :param pulumi.Input[builtins.str] name: The name of the database.
        :param pulumi.Input[builtins.str] type: The database type.
        :param pulumi.Input[builtins.str] update_time: Output only. The last modification time of the database. A timestamp in
               RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine
               fractional digits. Examples: "2014-10-02T15:01:23Z" and
               "2014-10-02T15:01:23.045123456Z".
        """
        if catalog is not None:
            pulumi.set(__self__, "catalog", catalog)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if delete_time is not None:
            pulumi.set(__self__, "delete_time", delete_time)
        if expire_time is not None:
            pulumi.set(__self__, "expire_time", expire_time)
        if hive_options is not None:
            pulumi.set(__self__, "hive_options", hive_options)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter
    def catalog(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The parent catalog.
        """
        return pulumi.get(self, "catalog")

    @catalog.setter
    def catalog(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "catalog", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. The creation time of the database. A timestamp in RFC3339
        UTC "Zulu" format, with nanosecond resolution and up to nine fractional
        digits. Examples: "2014-10-02T15:01:23Z" and
        "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="deleteTime")
    def delete_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. The deletion time of the database. Only set after the
        database is deleted. A timestamp in RFC3339 UTC "Zulu" format, with
        nanosecond resolution and up to nine fractional digits. Examples:
        "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "delete_time")

    @delete_time.setter
    def delete_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "delete_time", value)

    @property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. The time when this database is considered expired. Only set
        after the database is deleted. A timestamp in RFC3339 UTC "Zulu" format,
        with nanosecond resolution and up to nine fractional digits. Examples:
        "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "expire_time")

    @expire_time.setter
    def expire_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "expire_time", value)

    @property
    @pulumi.getter(name="hiveOptions")
    def hive_options(self) -> Optional[pulumi.Input['DatabaseHiveOptionsArgs']]:
        """
        Options of a Hive database.
        Structure is documented below.
        """
        return pulumi.get(self, "hive_options")

    @hive_options.setter
    def hive_options(self, value: Optional[pulumi.Input['DatabaseHiveOptionsArgs']]):
        pulumi.set(self, "hive_options", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the database.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The database type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. The last modification time of the database. A timestamp in
        RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine
        fractional digits. Examples: "2014-10-02T15:01:23Z" and
        "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:biglake/database:Database")
class Database(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 catalog: Optional[pulumi.Input[builtins.str]] = None,
                 hive_options: Optional[pulumi.Input[Union['DatabaseHiveOptionsArgs', 'DatabaseHiveOptionsArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Databases are containers of tables.

        To get more information about Database, see:

        * [API documentation](https://cloud.google.com/bigquery/docs/reference/biglake/rest/v1/projects.locations.catalogs.databases)
        * How-to Guides
            * [Manage open source metadata with BigLake Metastore](https://cloud.google.com/bigquery/docs/manage-open-source-metadata#create_databases)

        ## Example Usage

        ### Biglake Database

        ```python
        import pulumi
        import pulumi_gcp as gcp

        catalog = gcp.biglake.Catalog("catalog",
            name="my_catalog",
            location="US")
        bucket = gcp.storage.Bucket("bucket",
            name="my_bucket",
            location="US",
            force_destroy=True,
            uniform_bucket_level_access=True)
        metadata_folder = gcp.storage.BucketObject("metadata_folder",
            name="metadata/",
            content=" ",
            bucket=bucket.name)
        database = gcp.biglake.Database("database",
            name="my_database",
            catalog=catalog.id,
            type="HIVE",
            hive_options={
                "location_uri": pulumi.Output.all(
                    bucketName=bucket.name,
                    metadataFolderName=metadata_folder.name
        ).apply(lambda resolved_outputs: f"gs://{resolved_outputs['bucketName']}/{resolved_outputs['metadataFolderName']}")
        ,
                "parameters": {
                    "owner": "John Doe",
                },
            })
        ```

        ## Import

        Database can be imported using any of these accepted formats:

        * `{{catalog}}/databases/{{name}}`

        When using the `pulumi import` command, Database can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:biglake/database:Database default {{catalog}}/databases/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] catalog: The parent catalog.
        :param pulumi.Input[Union['DatabaseHiveOptionsArgs', 'DatabaseHiveOptionsArgsDict']] hive_options: Options of a Hive database.
               Structure is documented below.
        :param pulumi.Input[builtins.str] name: The name of the database.
        :param pulumi.Input[builtins.str] type: The database type.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DatabaseArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Databases are containers of tables.

        To get more information about Database, see:

        * [API documentation](https://cloud.google.com/bigquery/docs/reference/biglake/rest/v1/projects.locations.catalogs.databases)
        * How-to Guides
            * [Manage open source metadata with BigLake Metastore](https://cloud.google.com/bigquery/docs/manage-open-source-metadata#create_databases)

        ## Example Usage

        ### Biglake Database

        ```python
        import pulumi
        import pulumi_gcp as gcp

        catalog = gcp.biglake.Catalog("catalog",
            name="my_catalog",
            location="US")
        bucket = gcp.storage.Bucket("bucket",
            name="my_bucket",
            location="US",
            force_destroy=True,
            uniform_bucket_level_access=True)
        metadata_folder = gcp.storage.BucketObject("metadata_folder",
            name="metadata/",
            content=" ",
            bucket=bucket.name)
        database = gcp.biglake.Database("database",
            name="my_database",
            catalog=catalog.id,
            type="HIVE",
            hive_options={
                "location_uri": pulumi.Output.all(
                    bucketName=bucket.name,
                    metadataFolderName=metadata_folder.name
        ).apply(lambda resolved_outputs: f"gs://{resolved_outputs['bucketName']}/{resolved_outputs['metadataFolderName']}")
        ,
                "parameters": {
                    "owner": "John Doe",
                },
            })
        ```

        ## Import

        Database can be imported using any of these accepted formats:

        * `{{catalog}}/databases/{{name}}`

        When using the `pulumi import` command, Database can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:biglake/database:Database default {{catalog}}/databases/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param DatabaseArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DatabaseArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 catalog: Optional[pulumi.Input[builtins.str]] = None,
                 hive_options: Optional[pulumi.Input[Union['DatabaseHiveOptionsArgs', 'DatabaseHiveOptionsArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DatabaseArgs.__new__(DatabaseArgs)

            if catalog is None and not opts.urn:
                raise TypeError("Missing required property 'catalog'")
            __props__.__dict__["catalog"] = catalog
            if hive_options is None and not opts.urn:
                raise TypeError("Missing required property 'hive_options'")
            __props__.__dict__["hive_options"] = hive_options
            __props__.__dict__["name"] = name
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["create_time"] = None
            __props__.__dict__["delete_time"] = None
            __props__.__dict__["expire_time"] = None
            __props__.__dict__["update_time"] = None
        super(Database, __self__).__init__(
            'gcp:biglake/database:Database',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            catalog: Optional[pulumi.Input[builtins.str]] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            delete_time: Optional[pulumi.Input[builtins.str]] = None,
            expire_time: Optional[pulumi.Input[builtins.str]] = None,
            hive_options: Optional[pulumi.Input[Union['DatabaseHiveOptionsArgs', 'DatabaseHiveOptionsArgsDict']]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None) -> 'Database':
        """
        Get an existing Database resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] catalog: The parent catalog.
        :param pulumi.Input[builtins.str] create_time: Output only. The creation time of the database. A timestamp in RFC3339
               UTC "Zulu" format, with nanosecond resolution and up to nine fractional
               digits. Examples: "2014-10-02T15:01:23Z" and
               "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input[builtins.str] delete_time: Output only. The deletion time of the database. Only set after the
               database is deleted. A timestamp in RFC3339 UTC "Zulu" format, with
               nanosecond resolution and up to nine fractional digits. Examples:
               "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input[builtins.str] expire_time: Output only. The time when this database is considered expired. Only set
               after the database is deleted. A timestamp in RFC3339 UTC "Zulu" format,
               with nanosecond resolution and up to nine fractional digits. Examples:
               "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input[Union['DatabaseHiveOptionsArgs', 'DatabaseHiveOptionsArgsDict']] hive_options: Options of a Hive database.
               Structure is documented below.
        :param pulumi.Input[builtins.str] name: The name of the database.
        :param pulumi.Input[builtins.str] type: The database type.
        :param pulumi.Input[builtins.str] update_time: Output only. The last modification time of the database. A timestamp in
               RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine
               fractional digits. Examples: "2014-10-02T15:01:23Z" and
               "2014-10-02T15:01:23.045123456Z".
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DatabaseState.__new__(_DatabaseState)

        __props__.__dict__["catalog"] = catalog
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["delete_time"] = delete_time
        __props__.__dict__["expire_time"] = expire_time
        __props__.__dict__["hive_options"] = hive_options
        __props__.__dict__["name"] = name
        __props__.__dict__["type"] = type
        __props__.__dict__["update_time"] = update_time
        return Database(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def catalog(self) -> pulumi.Output[builtins.str]:
        """
        The parent catalog.
        """
        return pulumi.get(self, "catalog")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        Output only. The creation time of the database. A timestamp in RFC3339
        UTC "Zulu" format, with nanosecond resolution and up to nine fractional
        digits. Examples: "2014-10-02T15:01:23Z" and
        "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="deleteTime")
    def delete_time(self) -> pulumi.Output[builtins.str]:
        """
        Output only. The deletion time of the database. Only set after the
        database is deleted. A timestamp in RFC3339 UTC "Zulu" format, with
        nanosecond resolution and up to nine fractional digits. Examples:
        "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "delete_time")

    @property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> pulumi.Output[builtins.str]:
        """
        Output only. The time when this database is considered expired. Only set
        after the database is deleted. A timestamp in RFC3339 UTC "Zulu" format,
        with nanosecond resolution and up to nine fractional digits. Examples:
        "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "expire_time")

    @property
    @pulumi.getter(name="hiveOptions")
    def hive_options(self) -> pulumi.Output['outputs.DatabaseHiveOptions']:
        """
        Options of a Hive database.
        Structure is documented below.
        """
        return pulumi.get(self, "hive_options")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the database.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[builtins.str]:
        """
        The database type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        Output only. The last modification time of the database. A timestamp in
        RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine
        fractional digits. Examples: "2014-10-02T15:01:23Z" and
        "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "update_time")

