# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetDatasetResult',
    'AwaitableGetDatasetResult',
    'get_dataset',
    'get_dataset_output',
]

@pulumi.output_type
class GetDatasetResult:
    """
    A collection of values returned by getDataset.
    """
    def __init__(__self__, accesses=None, creation_time=None, dataset_id=None, default_collation=None, default_encryption_configurations=None, default_partition_expiration_ms=None, default_table_expiration_ms=None, delete_contents_on_destroy=None, description=None, effective_labels=None, etag=None, external_catalog_dataset_options=None, external_dataset_references=None, friendly_name=None, id=None, is_case_insensitive=None, labels=None, last_modified_time=None, location=None, max_time_travel_hours=None, project=None, pulumi_labels=None, resource_tags=None, self_link=None, storage_billing_model=None):
        if accesses and not isinstance(accesses, list):
            raise TypeError("Expected argument 'accesses' to be a list")
        pulumi.set(__self__, "accesses", accesses)
        if creation_time and not isinstance(creation_time, int):
            raise TypeError("Expected argument 'creation_time' to be a int")
        pulumi.set(__self__, "creation_time", creation_time)
        if dataset_id and not isinstance(dataset_id, str):
            raise TypeError("Expected argument 'dataset_id' to be a str")
        pulumi.set(__self__, "dataset_id", dataset_id)
        if default_collation and not isinstance(default_collation, str):
            raise TypeError("Expected argument 'default_collation' to be a str")
        pulumi.set(__self__, "default_collation", default_collation)
        if default_encryption_configurations and not isinstance(default_encryption_configurations, list):
            raise TypeError("Expected argument 'default_encryption_configurations' to be a list")
        pulumi.set(__self__, "default_encryption_configurations", default_encryption_configurations)
        if default_partition_expiration_ms and not isinstance(default_partition_expiration_ms, int):
            raise TypeError("Expected argument 'default_partition_expiration_ms' to be a int")
        pulumi.set(__self__, "default_partition_expiration_ms", default_partition_expiration_ms)
        if default_table_expiration_ms and not isinstance(default_table_expiration_ms, int):
            raise TypeError("Expected argument 'default_table_expiration_ms' to be a int")
        pulumi.set(__self__, "default_table_expiration_ms", default_table_expiration_ms)
        if delete_contents_on_destroy and not isinstance(delete_contents_on_destroy, bool):
            raise TypeError("Expected argument 'delete_contents_on_destroy' to be a bool")
        pulumi.set(__self__, "delete_contents_on_destroy", delete_contents_on_destroy)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if effective_labels and not isinstance(effective_labels, dict):
            raise TypeError("Expected argument 'effective_labels' to be a dict")
        pulumi.set(__self__, "effective_labels", effective_labels)
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if external_catalog_dataset_options and not isinstance(external_catalog_dataset_options, list):
            raise TypeError("Expected argument 'external_catalog_dataset_options' to be a list")
        pulumi.set(__self__, "external_catalog_dataset_options", external_catalog_dataset_options)
        if external_dataset_references and not isinstance(external_dataset_references, list):
            raise TypeError("Expected argument 'external_dataset_references' to be a list")
        pulumi.set(__self__, "external_dataset_references", external_dataset_references)
        if friendly_name and not isinstance(friendly_name, str):
            raise TypeError("Expected argument 'friendly_name' to be a str")
        pulumi.set(__self__, "friendly_name", friendly_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_case_insensitive and not isinstance(is_case_insensitive, bool):
            raise TypeError("Expected argument 'is_case_insensitive' to be a bool")
        pulumi.set(__self__, "is_case_insensitive", is_case_insensitive)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if last_modified_time and not isinstance(last_modified_time, int):
            raise TypeError("Expected argument 'last_modified_time' to be a int")
        pulumi.set(__self__, "last_modified_time", last_modified_time)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if max_time_travel_hours and not isinstance(max_time_travel_hours, str):
            raise TypeError("Expected argument 'max_time_travel_hours' to be a str")
        pulumi.set(__self__, "max_time_travel_hours", max_time_travel_hours)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if pulumi_labels and not isinstance(pulumi_labels, dict):
            raise TypeError("Expected argument 'pulumi_labels' to be a dict")
        pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if resource_tags and not isinstance(resource_tags, dict):
            raise TypeError("Expected argument 'resource_tags' to be a dict")
        pulumi.set(__self__, "resource_tags", resource_tags)
        if self_link and not isinstance(self_link, str):
            raise TypeError("Expected argument 'self_link' to be a str")
        pulumi.set(__self__, "self_link", self_link)
        if storage_billing_model and not isinstance(storage_billing_model, str):
            raise TypeError("Expected argument 'storage_billing_model' to be a str")
        pulumi.set(__self__, "storage_billing_model", storage_billing_model)

    @property
    @pulumi.getter
    def accesses(self) -> Sequence['outputs.GetDatasetAccessResult']:
        return pulumi.get(self, "accesses")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> builtins.int:
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> builtins.str:
        return pulumi.get(self, "dataset_id")

    @property
    @pulumi.getter(name="defaultCollation")
    def default_collation(self) -> builtins.str:
        return pulumi.get(self, "default_collation")

    @property
    @pulumi.getter(name="defaultEncryptionConfigurations")
    def default_encryption_configurations(self) -> Sequence['outputs.GetDatasetDefaultEncryptionConfigurationResult']:
        return pulumi.get(self, "default_encryption_configurations")

    @property
    @pulumi.getter(name="defaultPartitionExpirationMs")
    def default_partition_expiration_ms(self) -> builtins.int:
        return pulumi.get(self, "default_partition_expiration_ms")

    @property
    @pulumi.getter(name="defaultTableExpirationMs")
    def default_table_expiration_ms(self) -> builtins.int:
        return pulumi.get(self, "default_table_expiration_ms")

    @property
    @pulumi.getter(name="deleteContentsOnDestroy")
    def delete_contents_on_destroy(self) -> builtins.bool:
        return pulumi.get(self, "delete_contents_on_destroy")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Mapping[str, builtins.str]:
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter
    def etag(self) -> builtins.str:
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="externalCatalogDatasetOptions")
    def external_catalog_dataset_options(self) -> Sequence['outputs.GetDatasetExternalCatalogDatasetOptionResult']:
        return pulumi.get(self, "external_catalog_dataset_options")

    @property
    @pulumi.getter(name="externalDatasetReferences")
    def external_dataset_references(self) -> Sequence['outputs.GetDatasetExternalDatasetReferenceResult']:
        return pulumi.get(self, "external_dataset_references")

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> builtins.str:
        return pulumi.get(self, "friendly_name")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isCaseInsensitive")
    def is_case_insensitive(self) -> builtins.bool:
        return pulumi.get(self, "is_case_insensitive")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, builtins.str]:
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> builtins.int:
        return pulumi.get(self, "last_modified_time")

    @property
    @pulumi.getter
    def location(self) -> builtins.str:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="maxTimeTravelHours")
    def max_time_travel_hours(self) -> builtins.str:
        return pulumi.get(self, "max_time_travel_hours")

    @property
    @pulumi.getter
    def project(self) -> Optional[builtins.str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Mapping[str, builtins.str]:
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter(name="resourceTags")
    def resource_tags(self) -> Mapping[str, builtins.str]:
        return pulumi.get(self, "resource_tags")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> builtins.str:
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter(name="storageBillingModel")
    def storage_billing_model(self) -> builtins.str:
        return pulumi.get(self, "storage_billing_model")


class AwaitableGetDatasetResult(GetDatasetResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDatasetResult(
            accesses=self.accesses,
            creation_time=self.creation_time,
            dataset_id=self.dataset_id,
            default_collation=self.default_collation,
            default_encryption_configurations=self.default_encryption_configurations,
            default_partition_expiration_ms=self.default_partition_expiration_ms,
            default_table_expiration_ms=self.default_table_expiration_ms,
            delete_contents_on_destroy=self.delete_contents_on_destroy,
            description=self.description,
            effective_labels=self.effective_labels,
            etag=self.etag,
            external_catalog_dataset_options=self.external_catalog_dataset_options,
            external_dataset_references=self.external_dataset_references,
            friendly_name=self.friendly_name,
            id=self.id,
            is_case_insensitive=self.is_case_insensitive,
            labels=self.labels,
            last_modified_time=self.last_modified_time,
            location=self.location,
            max_time_travel_hours=self.max_time_travel_hours,
            project=self.project,
            pulumi_labels=self.pulumi_labels,
            resource_tags=self.resource_tags,
            self_link=self.self_link,
            storage_billing_model=self.storage_billing_model)


def get_dataset(dataset_id: Optional[builtins.str] = None,
                project: Optional[builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDatasetResult:
    """
    Get information about a BigQuery dataset. For more information see
    the [official documentation](https://cloud.google.com/bigquery/docs)
    and [API](https://cloud.google.com/bigquery/docs/reference/rest/v2/datasets).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    dataset = gcp.bigquery.get_dataset(dataset_id="my-bq-dataset",
        project="my-project")
    ```


    :param builtins.str dataset_id: The dataset ID.
    :param builtins.str project: The ID of the project in which the resource belongs.
           If it is not provided, the provider project is used.
    """
    __args__ = dict()
    __args__['datasetId'] = dataset_id
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:bigquery/getDataset:getDataset', __args__, opts=opts, typ=GetDatasetResult).value

    return AwaitableGetDatasetResult(
        accesses=pulumi.get(__ret__, 'accesses'),
        creation_time=pulumi.get(__ret__, 'creation_time'),
        dataset_id=pulumi.get(__ret__, 'dataset_id'),
        default_collation=pulumi.get(__ret__, 'default_collation'),
        default_encryption_configurations=pulumi.get(__ret__, 'default_encryption_configurations'),
        default_partition_expiration_ms=pulumi.get(__ret__, 'default_partition_expiration_ms'),
        default_table_expiration_ms=pulumi.get(__ret__, 'default_table_expiration_ms'),
        delete_contents_on_destroy=pulumi.get(__ret__, 'delete_contents_on_destroy'),
        description=pulumi.get(__ret__, 'description'),
        effective_labels=pulumi.get(__ret__, 'effective_labels'),
        etag=pulumi.get(__ret__, 'etag'),
        external_catalog_dataset_options=pulumi.get(__ret__, 'external_catalog_dataset_options'),
        external_dataset_references=pulumi.get(__ret__, 'external_dataset_references'),
        friendly_name=pulumi.get(__ret__, 'friendly_name'),
        id=pulumi.get(__ret__, 'id'),
        is_case_insensitive=pulumi.get(__ret__, 'is_case_insensitive'),
        labels=pulumi.get(__ret__, 'labels'),
        last_modified_time=pulumi.get(__ret__, 'last_modified_time'),
        location=pulumi.get(__ret__, 'location'),
        max_time_travel_hours=pulumi.get(__ret__, 'max_time_travel_hours'),
        project=pulumi.get(__ret__, 'project'),
        pulumi_labels=pulumi.get(__ret__, 'pulumi_labels'),
        resource_tags=pulumi.get(__ret__, 'resource_tags'),
        self_link=pulumi.get(__ret__, 'self_link'),
        storage_billing_model=pulumi.get(__ret__, 'storage_billing_model'))
def get_dataset_output(dataset_id: Optional[pulumi.Input[builtins.str]] = None,
                       project: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDatasetResult]:
    """
    Get information about a BigQuery dataset. For more information see
    the [official documentation](https://cloud.google.com/bigquery/docs)
    and [API](https://cloud.google.com/bigquery/docs/reference/rest/v2/datasets).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    dataset = gcp.bigquery.get_dataset(dataset_id="my-bq-dataset",
        project="my-project")
    ```


    :param builtins.str dataset_id: The dataset ID.
    :param builtins.str project: The ID of the project in which the resource belongs.
           If it is not provided, the provider project is used.
    """
    __args__ = dict()
    __args__['datasetId'] = dataset_id
    __args__['project'] = project
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:bigquery/getDataset:getDataset', __args__, opts=opts, typ=GetDatasetResult)
    return __ret__.apply(lambda __response__: GetDatasetResult(
        accesses=pulumi.get(__response__, 'accesses'),
        creation_time=pulumi.get(__response__, 'creation_time'),
        dataset_id=pulumi.get(__response__, 'dataset_id'),
        default_collation=pulumi.get(__response__, 'default_collation'),
        default_encryption_configurations=pulumi.get(__response__, 'default_encryption_configurations'),
        default_partition_expiration_ms=pulumi.get(__response__, 'default_partition_expiration_ms'),
        default_table_expiration_ms=pulumi.get(__response__, 'default_table_expiration_ms'),
        delete_contents_on_destroy=pulumi.get(__response__, 'delete_contents_on_destroy'),
        description=pulumi.get(__response__, 'description'),
        effective_labels=pulumi.get(__response__, 'effective_labels'),
        etag=pulumi.get(__response__, 'etag'),
        external_catalog_dataset_options=pulumi.get(__response__, 'external_catalog_dataset_options'),
        external_dataset_references=pulumi.get(__response__, 'external_dataset_references'),
        friendly_name=pulumi.get(__response__, 'friendly_name'),
        id=pulumi.get(__response__, 'id'),
        is_case_insensitive=pulumi.get(__response__, 'is_case_insensitive'),
        labels=pulumi.get(__response__, 'labels'),
        last_modified_time=pulumi.get(__response__, 'last_modified_time'),
        location=pulumi.get(__response__, 'location'),
        max_time_travel_hours=pulumi.get(__response__, 'max_time_travel_hours'),
        project=pulumi.get(__response__, 'project'),
        pulumi_labels=pulumi.get(__response__, 'pulumi_labels'),
        resource_tags=pulumi.get(__response__, 'resource_tags'),
        self_link=pulumi.get(__response__, 'self_link'),
        storage_billing_model=pulumi.get(__response__, 'storage_billing_model')))
