# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DataExchangeArgs', 'DataExchange']

@pulumi.input_type
class DataExchangeArgs:
    def __init__(__self__, *,
                 data_exchange_id: pulumi.Input[builtins.str],
                 display_name: pulumi.Input[builtins.str],
                 location: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 documentation: Optional[pulumi.Input[builtins.str]] = None,
                 icon: Optional[pulumi.Input[builtins.str]] = None,
                 log_linked_dataset_query_user_email: Optional[pulumi.Input[builtins.bool]] = None,
                 primary_contact: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 sharing_environment_config: Optional[pulumi.Input['DataExchangeSharingEnvironmentConfigArgs']] = None):
        """
        The set of arguments for constructing a DataExchange resource.
        :param pulumi.Input[builtins.str] data_exchange_id: The ID of the data exchange. Must contain only Unicode letters, numbers (0-9), underscores (_). Should not use characters that require URL-escaping, or characters outside of ASCII, spaces.
        :param pulumi.Input[builtins.str] display_name: Human-readable display name of the data exchange. The display name must contain only Unicode letters, numbers (0-9), underscores (_), dashes (-), spaces ( ), and must not start or end with spaces.
        :param pulumi.Input[builtins.str] location: The name of the location this data exchange.
        :param pulumi.Input[builtins.str] description: Description of the data exchange.
        :param pulumi.Input[builtins.str] documentation: Documentation describing the data exchange.
        :param pulumi.Input[builtins.str] icon: Base64 encoded image representing the data exchange.
        :param pulumi.Input[builtins.bool] log_linked_dataset_query_user_email: If true, subscriber email logging is enabled and all queries on the linked dataset will log the email address of the querying user. Once enabled, this setting cannot be turned off.
        :param pulumi.Input[builtins.str] primary_contact: Email or URL of the primary point of contact of the data exchange.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['DataExchangeSharingEnvironmentConfigArgs'] sharing_environment_config: Configurable data sharing environment option for a data exchange.
               This field is required for data clean room exchanges.
               Structure is documented below.
        """
        pulumi.set(__self__, "data_exchange_id", data_exchange_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "location", location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if documentation is not None:
            pulumi.set(__self__, "documentation", documentation)
        if icon is not None:
            pulumi.set(__self__, "icon", icon)
        if log_linked_dataset_query_user_email is not None:
            pulumi.set(__self__, "log_linked_dataset_query_user_email", log_linked_dataset_query_user_email)
        if primary_contact is not None:
            pulumi.set(__self__, "primary_contact", primary_contact)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if sharing_environment_config is not None:
            pulumi.set(__self__, "sharing_environment_config", sharing_environment_config)

    @property
    @pulumi.getter(name="dataExchangeId")
    def data_exchange_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the data exchange. Must contain only Unicode letters, numbers (0-9), underscores (_). Should not use characters that require URL-escaping, or characters outside of ASCII, spaces.
        """
        return pulumi.get(self, "data_exchange_id")

    @data_exchange_id.setter
    def data_exchange_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "data_exchange_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        Human-readable display name of the data exchange. The display name must contain only Unicode letters, numbers (0-9), underscores (_), dashes (-), spaces ( ), and must not start or end with spaces.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        The name of the location this data exchange.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the data exchange.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def documentation(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Documentation describing the data exchange.
        """
        return pulumi.get(self, "documentation")

    @documentation.setter
    def documentation(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "documentation", value)

    @property
    @pulumi.getter
    def icon(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Base64 encoded image representing the data exchange.
        """
        return pulumi.get(self, "icon")

    @icon.setter
    def icon(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "icon", value)

    @property
    @pulumi.getter(name="logLinkedDatasetQueryUserEmail")
    def log_linked_dataset_query_user_email(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If true, subscriber email logging is enabled and all queries on the linked dataset will log the email address of the querying user. Once enabled, this setting cannot be turned off.
        """
        return pulumi.get(self, "log_linked_dataset_query_user_email")

    @log_linked_dataset_query_user_email.setter
    def log_linked_dataset_query_user_email(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "log_linked_dataset_query_user_email", value)

    @property
    @pulumi.getter(name="primaryContact")
    def primary_contact(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Email or URL of the primary point of contact of the data exchange.
        """
        return pulumi.get(self, "primary_contact")

    @primary_contact.setter
    def primary_contact(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_contact", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="sharingEnvironmentConfig")
    def sharing_environment_config(self) -> Optional[pulumi.Input['DataExchangeSharingEnvironmentConfigArgs']]:
        """
        Configurable data sharing environment option for a data exchange.
        This field is required for data clean room exchanges.
        Structure is documented below.
        """
        return pulumi.get(self, "sharing_environment_config")

    @sharing_environment_config.setter
    def sharing_environment_config(self, value: Optional[pulumi.Input['DataExchangeSharingEnvironmentConfigArgs']]):
        pulumi.set(self, "sharing_environment_config", value)


@pulumi.input_type
class _DataExchangeState:
    def __init__(__self__, *,
                 data_exchange_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 documentation: Optional[pulumi.Input[builtins.str]] = None,
                 icon: Optional[pulumi.Input[builtins.str]] = None,
                 listing_count: Optional[pulumi.Input[builtins.int]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 log_linked_dataset_query_user_email: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 primary_contact: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 sharing_environment_config: Optional[pulumi.Input['DataExchangeSharingEnvironmentConfigArgs']] = None):
        """
        Input properties used for looking up and filtering DataExchange resources.
        :param pulumi.Input[builtins.str] data_exchange_id: The ID of the data exchange. Must contain only Unicode letters, numbers (0-9), underscores (_). Should not use characters that require URL-escaping, or characters outside of ASCII, spaces.
        :param pulumi.Input[builtins.str] description: Description of the data exchange.
        :param pulumi.Input[builtins.str] display_name: Human-readable display name of the data exchange. The display name must contain only Unicode letters, numbers (0-9), underscores (_), dashes (-), spaces ( ), and must not start or end with spaces.
        :param pulumi.Input[builtins.str] documentation: Documentation describing the data exchange.
        :param pulumi.Input[builtins.str] icon: Base64 encoded image representing the data exchange.
        :param pulumi.Input[builtins.int] listing_count: Number of listings contained in the data exchange.
        :param pulumi.Input[builtins.str] location: The name of the location this data exchange.
        :param pulumi.Input[builtins.bool] log_linked_dataset_query_user_email: If true, subscriber email logging is enabled and all queries on the linked dataset will log the email address of the querying user. Once enabled, this setting cannot be turned off.
        :param pulumi.Input[builtins.str] name: The resource name of the data exchange, for example:
               "projects/myproject/locations/US/dataExchanges/123"
        :param pulumi.Input[builtins.str] primary_contact: Email or URL of the primary point of contact of the data exchange.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['DataExchangeSharingEnvironmentConfigArgs'] sharing_environment_config: Configurable data sharing environment option for a data exchange.
               This field is required for data clean room exchanges.
               Structure is documented below.
        """
        if data_exchange_id is not None:
            pulumi.set(__self__, "data_exchange_id", data_exchange_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if documentation is not None:
            pulumi.set(__self__, "documentation", documentation)
        if icon is not None:
            pulumi.set(__self__, "icon", icon)
        if listing_count is not None:
            pulumi.set(__self__, "listing_count", listing_count)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if log_linked_dataset_query_user_email is not None:
            pulumi.set(__self__, "log_linked_dataset_query_user_email", log_linked_dataset_query_user_email)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if primary_contact is not None:
            pulumi.set(__self__, "primary_contact", primary_contact)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if sharing_environment_config is not None:
            pulumi.set(__self__, "sharing_environment_config", sharing_environment_config)

    @property
    @pulumi.getter(name="dataExchangeId")
    def data_exchange_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the data exchange. Must contain only Unicode letters, numbers (0-9), underscores (_). Should not use characters that require URL-escaping, or characters outside of ASCII, spaces.
        """
        return pulumi.get(self, "data_exchange_id")

    @data_exchange_id.setter
    def data_exchange_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "data_exchange_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the data exchange.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Human-readable display name of the data exchange. The display name must contain only Unicode letters, numbers (0-9), underscores (_), dashes (-), spaces ( ), and must not start or end with spaces.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def documentation(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Documentation describing the data exchange.
        """
        return pulumi.get(self, "documentation")

    @documentation.setter
    def documentation(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "documentation", value)

    @property
    @pulumi.getter
    def icon(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Base64 encoded image representing the data exchange.
        """
        return pulumi.get(self, "icon")

    @icon.setter
    def icon(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "icon", value)

    @property
    @pulumi.getter(name="listingCount")
    def listing_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of listings contained in the data exchange.
        """
        return pulumi.get(self, "listing_count")

    @listing_count.setter
    def listing_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "listing_count", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the location this data exchange.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="logLinkedDatasetQueryUserEmail")
    def log_linked_dataset_query_user_email(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If true, subscriber email logging is enabled and all queries on the linked dataset will log the email address of the querying user. Once enabled, this setting cannot be turned off.
        """
        return pulumi.get(self, "log_linked_dataset_query_user_email")

    @log_linked_dataset_query_user_email.setter
    def log_linked_dataset_query_user_email(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "log_linked_dataset_query_user_email", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource name of the data exchange, for example:
        "projects/myproject/locations/US/dataExchanges/123"
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="primaryContact")
    def primary_contact(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Email or URL of the primary point of contact of the data exchange.
        """
        return pulumi.get(self, "primary_contact")

    @primary_contact.setter
    def primary_contact(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_contact", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="sharingEnvironmentConfig")
    def sharing_environment_config(self) -> Optional[pulumi.Input['DataExchangeSharingEnvironmentConfigArgs']]:
        """
        Configurable data sharing environment option for a data exchange.
        This field is required for data clean room exchanges.
        Structure is documented below.
        """
        return pulumi.get(self, "sharing_environment_config")

    @sharing_environment_config.setter
    def sharing_environment_config(self, value: Optional[pulumi.Input['DataExchangeSharingEnvironmentConfigArgs']]):
        pulumi.set(self, "sharing_environment_config", value)


@pulumi.type_token("gcp:bigqueryanalyticshub/dataExchange:DataExchange")
class DataExchange(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_exchange_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 documentation: Optional[pulumi.Input[builtins.str]] = None,
                 icon: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 log_linked_dataset_query_user_email: Optional[pulumi.Input[builtins.bool]] = None,
                 primary_contact: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 sharing_environment_config: Optional[pulumi.Input[Union['DataExchangeSharingEnvironmentConfigArgs', 'DataExchangeSharingEnvironmentConfigArgsDict']]] = None,
                 __props__=None):
        """
        A Bigquery Analytics Hub data exchange

        To get more information about DataExchange, see:

        * [API documentation](https://cloud.google.com/bigquery/docs/reference/analytics-hub/rest/v1/projects.locations.dataExchanges)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/bigquery/docs/analytics-hub-introduction)

        ## Example Usage

        ### Bigquery Analyticshub Data Exchange Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        data_exchange = gcp.bigqueryanalyticshub.DataExchange("data_exchange",
            location="US",
            data_exchange_id="my_data_exchange",
            display_name="my_data_exchange",
            description="example data exchange")
        ```
        ### Bigquery Analyticshub Data Exchange Dcr

        ```python
        import pulumi
        import pulumi_gcp as gcp

        data_exchange = gcp.bigqueryanalyticshub.DataExchange("data_exchange",
            location="US",
            data_exchange_id="dcr_data_exchange",
            display_name="dcr_data_exchange",
            description="example dcr data exchange",
            sharing_environment_config={
                "dcr_exchange_config": {},
            })
        ```
        ### Bigquery Analyticshub Data Exchange Log Linked Dataset Query User

        ```python
        import pulumi
        import pulumi_gcp as gcp

        data_exchange = gcp.bigqueryanalyticshub.DataExchange("data_exchange",
            location="US",
            data_exchange_id="tf_test_log_email_data_exchange",
            display_name="tf_test_log_email_data_exchange",
            description="Example for log email test for data exchange",
            log_linked_dataset_query_user_email=True)
        ```

        ## Import

        DataExchange can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/dataExchanges/{{data_exchange_id}}`

        * `{{project}}/{{location}}/{{data_exchange_id}}`

        * `{{location}}/{{data_exchange_id}}`

        * `{{data_exchange_id}}`

        When using the `pulumi import` command, DataExchange can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:bigqueryanalyticshub/dataExchange:DataExchange default projects/{{project}}/locations/{{location}}/dataExchanges/{{data_exchange_id}}
        ```

        ```sh
        $ pulumi import gcp:bigqueryanalyticshub/dataExchange:DataExchange default {{project}}/{{location}}/{{data_exchange_id}}
        ```

        ```sh
        $ pulumi import gcp:bigqueryanalyticshub/dataExchange:DataExchange default {{location}}/{{data_exchange_id}}
        ```

        ```sh
        $ pulumi import gcp:bigqueryanalyticshub/dataExchange:DataExchange default {{data_exchange_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] data_exchange_id: The ID of the data exchange. Must contain only Unicode letters, numbers (0-9), underscores (_). Should not use characters that require URL-escaping, or characters outside of ASCII, spaces.
        :param pulumi.Input[builtins.str] description: Description of the data exchange.
        :param pulumi.Input[builtins.str] display_name: Human-readable display name of the data exchange. The display name must contain only Unicode letters, numbers (0-9), underscores (_), dashes (-), spaces ( ), and must not start or end with spaces.
        :param pulumi.Input[builtins.str] documentation: Documentation describing the data exchange.
        :param pulumi.Input[builtins.str] icon: Base64 encoded image representing the data exchange.
        :param pulumi.Input[builtins.str] location: The name of the location this data exchange.
        :param pulumi.Input[builtins.bool] log_linked_dataset_query_user_email: If true, subscriber email logging is enabled and all queries on the linked dataset will log the email address of the querying user. Once enabled, this setting cannot be turned off.
        :param pulumi.Input[builtins.str] primary_contact: Email or URL of the primary point of contact of the data exchange.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['DataExchangeSharingEnvironmentConfigArgs', 'DataExchangeSharingEnvironmentConfigArgsDict']] sharing_environment_config: Configurable data sharing environment option for a data exchange.
               This field is required for data clean room exchanges.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DataExchangeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Bigquery Analytics Hub data exchange

        To get more information about DataExchange, see:

        * [API documentation](https://cloud.google.com/bigquery/docs/reference/analytics-hub/rest/v1/projects.locations.dataExchanges)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/bigquery/docs/analytics-hub-introduction)

        ## Example Usage

        ### Bigquery Analyticshub Data Exchange Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        data_exchange = gcp.bigqueryanalyticshub.DataExchange("data_exchange",
            location="US",
            data_exchange_id="my_data_exchange",
            display_name="my_data_exchange",
            description="example data exchange")
        ```
        ### Bigquery Analyticshub Data Exchange Dcr

        ```python
        import pulumi
        import pulumi_gcp as gcp

        data_exchange = gcp.bigqueryanalyticshub.DataExchange("data_exchange",
            location="US",
            data_exchange_id="dcr_data_exchange",
            display_name="dcr_data_exchange",
            description="example dcr data exchange",
            sharing_environment_config={
                "dcr_exchange_config": {},
            })
        ```
        ### Bigquery Analyticshub Data Exchange Log Linked Dataset Query User

        ```python
        import pulumi
        import pulumi_gcp as gcp

        data_exchange = gcp.bigqueryanalyticshub.DataExchange("data_exchange",
            location="US",
            data_exchange_id="tf_test_log_email_data_exchange",
            display_name="tf_test_log_email_data_exchange",
            description="Example for log email test for data exchange",
            log_linked_dataset_query_user_email=True)
        ```

        ## Import

        DataExchange can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/dataExchanges/{{data_exchange_id}}`

        * `{{project}}/{{location}}/{{data_exchange_id}}`

        * `{{location}}/{{data_exchange_id}}`

        * `{{data_exchange_id}}`

        When using the `pulumi import` command, DataExchange can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:bigqueryanalyticshub/dataExchange:DataExchange default projects/{{project}}/locations/{{location}}/dataExchanges/{{data_exchange_id}}
        ```

        ```sh
        $ pulumi import gcp:bigqueryanalyticshub/dataExchange:DataExchange default {{project}}/{{location}}/{{data_exchange_id}}
        ```

        ```sh
        $ pulumi import gcp:bigqueryanalyticshub/dataExchange:DataExchange default {{location}}/{{data_exchange_id}}
        ```

        ```sh
        $ pulumi import gcp:bigqueryanalyticshub/dataExchange:DataExchange default {{data_exchange_id}}
        ```

        :param str resource_name: The name of the resource.
        :param DataExchangeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DataExchangeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_exchange_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 documentation: Optional[pulumi.Input[builtins.str]] = None,
                 icon: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 log_linked_dataset_query_user_email: Optional[pulumi.Input[builtins.bool]] = None,
                 primary_contact: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 sharing_environment_config: Optional[pulumi.Input[Union['DataExchangeSharingEnvironmentConfigArgs', 'DataExchangeSharingEnvironmentConfigArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DataExchangeArgs.__new__(DataExchangeArgs)

            if data_exchange_id is None and not opts.urn:
                raise TypeError("Missing required property 'data_exchange_id'")
            __props__.__dict__["data_exchange_id"] = data_exchange_id
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["documentation"] = documentation
            __props__.__dict__["icon"] = icon
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["log_linked_dataset_query_user_email"] = log_linked_dataset_query_user_email
            __props__.__dict__["primary_contact"] = primary_contact
            __props__.__dict__["project"] = project
            __props__.__dict__["sharing_environment_config"] = sharing_environment_config
            __props__.__dict__["listing_count"] = None
            __props__.__dict__["name"] = None
        super(DataExchange, __self__).__init__(
            'gcp:bigqueryanalyticshub/dataExchange:DataExchange',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            data_exchange_id: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            documentation: Optional[pulumi.Input[builtins.str]] = None,
            icon: Optional[pulumi.Input[builtins.str]] = None,
            listing_count: Optional[pulumi.Input[builtins.int]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            log_linked_dataset_query_user_email: Optional[pulumi.Input[builtins.bool]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            primary_contact: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            sharing_environment_config: Optional[pulumi.Input[Union['DataExchangeSharingEnvironmentConfigArgs', 'DataExchangeSharingEnvironmentConfigArgsDict']]] = None) -> 'DataExchange':
        """
        Get an existing DataExchange resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] data_exchange_id: The ID of the data exchange. Must contain only Unicode letters, numbers (0-9), underscores (_). Should not use characters that require URL-escaping, or characters outside of ASCII, spaces.
        :param pulumi.Input[builtins.str] description: Description of the data exchange.
        :param pulumi.Input[builtins.str] display_name: Human-readable display name of the data exchange. The display name must contain only Unicode letters, numbers (0-9), underscores (_), dashes (-), spaces ( ), and must not start or end with spaces.
        :param pulumi.Input[builtins.str] documentation: Documentation describing the data exchange.
        :param pulumi.Input[builtins.str] icon: Base64 encoded image representing the data exchange.
        :param pulumi.Input[builtins.int] listing_count: Number of listings contained in the data exchange.
        :param pulumi.Input[builtins.str] location: The name of the location this data exchange.
        :param pulumi.Input[builtins.bool] log_linked_dataset_query_user_email: If true, subscriber email logging is enabled and all queries on the linked dataset will log the email address of the querying user. Once enabled, this setting cannot be turned off.
        :param pulumi.Input[builtins.str] name: The resource name of the data exchange, for example:
               "projects/myproject/locations/US/dataExchanges/123"
        :param pulumi.Input[builtins.str] primary_contact: Email or URL of the primary point of contact of the data exchange.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['DataExchangeSharingEnvironmentConfigArgs', 'DataExchangeSharingEnvironmentConfigArgsDict']] sharing_environment_config: Configurable data sharing environment option for a data exchange.
               This field is required for data clean room exchanges.
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DataExchangeState.__new__(_DataExchangeState)

        __props__.__dict__["data_exchange_id"] = data_exchange_id
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["documentation"] = documentation
        __props__.__dict__["icon"] = icon
        __props__.__dict__["listing_count"] = listing_count
        __props__.__dict__["location"] = location
        __props__.__dict__["log_linked_dataset_query_user_email"] = log_linked_dataset_query_user_email
        __props__.__dict__["name"] = name
        __props__.__dict__["primary_contact"] = primary_contact
        __props__.__dict__["project"] = project
        __props__.__dict__["sharing_environment_config"] = sharing_environment_config
        return DataExchange(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="dataExchangeId")
    def data_exchange_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the data exchange. Must contain only Unicode letters, numbers (0-9), underscores (_). Should not use characters that require URL-escaping, or characters outside of ASCII, spaces.
        """
        return pulumi.get(self, "data_exchange_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Description of the data exchange.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        Human-readable display name of the data exchange. The display name must contain only Unicode letters, numbers (0-9), underscores (_), dashes (-), spaces ( ), and must not start or end with spaces.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def documentation(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Documentation describing the data exchange.
        """
        return pulumi.get(self, "documentation")

    @property
    @pulumi.getter
    def icon(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Base64 encoded image representing the data exchange.
        """
        return pulumi.get(self, "icon")

    @property
    @pulumi.getter(name="listingCount")
    def listing_count(self) -> pulumi.Output[builtins.int]:
        """
        Number of listings contained in the data exchange.
        """
        return pulumi.get(self, "listing_count")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The name of the location this data exchange.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="logLinkedDatasetQueryUserEmail")
    def log_linked_dataset_query_user_email(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        If true, subscriber email logging is enabled and all queries on the linked dataset will log the email address of the querying user. Once enabled, this setting cannot be turned off.
        """
        return pulumi.get(self, "log_linked_dataset_query_user_email")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The resource name of the data exchange, for example:
        "projects/myproject/locations/US/dataExchanges/123"
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="primaryContact")
    def primary_contact(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Email or URL of the primary point of contact of the data exchange.
        """
        return pulumi.get(self, "primary_contact")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="sharingEnvironmentConfig")
    def sharing_environment_config(self) -> pulumi.Output['outputs.DataExchangeSharingEnvironmentConfig']:
        """
        Configurable data sharing environment option for a data exchange.
        This field is required for data clean room exchanges.
        Structure is documented below.
        """
        return pulumi.get(self, "sharing_environment_config")

