# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DataPolicyArgs', 'DataPolicy']

@pulumi.input_type
class DataPolicyArgs:
    def __init__(__self__, *,
                 data_policy_id: pulumi.Input[builtins.str],
                 data_policy_type: pulumi.Input[builtins.str],
                 location: pulumi.Input[builtins.str],
                 policy_tag: pulumi.Input[builtins.str],
                 data_masking_policy: Optional[pulumi.Input['DataPolicyDataMaskingPolicyArgs']] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a DataPolicy resource.
        :param pulumi.Input[builtins.str] data_policy_id: User-assigned (human readable) ID of the data policy that needs to be unique within a project. Used as {dataPolicyId} in part of the resource name.
        :param pulumi.Input[builtins.str] data_policy_type: The enrollment level of the service.
               Possible values are: `COLUMN_LEVEL_SECURITY_POLICY`, `DATA_MASKING_POLICY`.
        :param pulumi.Input[builtins.str] location: The name of the location of the data policy.
        :param pulumi.Input[builtins.str] policy_tag: Policy tag resource name, in the format of projects/{project_number}/locations/{locationId}/taxonomies/{taxonomyId}/policyTags/{policyTag_id}.
        :param pulumi.Input['DataPolicyDataMaskingPolicyArgs'] data_masking_policy: The data masking policy that specifies the data masking rule to use.
               Structure is documented below.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "data_policy_id", data_policy_id)
        pulumi.set(__self__, "data_policy_type", data_policy_type)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "policy_tag", policy_tag)
        if data_masking_policy is not None:
            pulumi.set(__self__, "data_masking_policy", data_masking_policy)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="dataPolicyId")
    def data_policy_id(self) -> pulumi.Input[builtins.str]:
        """
        User-assigned (human readable) ID of the data policy that needs to be unique within a project. Used as {dataPolicyId} in part of the resource name.
        """
        return pulumi.get(self, "data_policy_id")

    @data_policy_id.setter
    def data_policy_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "data_policy_id", value)

    @property
    @pulumi.getter(name="dataPolicyType")
    def data_policy_type(self) -> pulumi.Input[builtins.str]:
        """
        The enrollment level of the service.
        Possible values are: `COLUMN_LEVEL_SECURITY_POLICY`, `DATA_MASKING_POLICY`.
        """
        return pulumi.get(self, "data_policy_type")

    @data_policy_type.setter
    def data_policy_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "data_policy_type", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        The name of the location of the data policy.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="policyTag")
    def policy_tag(self) -> pulumi.Input[builtins.str]:
        """
        Policy tag resource name, in the format of projects/{project_number}/locations/{locationId}/taxonomies/{taxonomyId}/policyTags/{policyTag_id}.
        """
        return pulumi.get(self, "policy_tag")

    @policy_tag.setter
    def policy_tag(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "policy_tag", value)

    @property
    @pulumi.getter(name="dataMaskingPolicy")
    def data_masking_policy(self) -> Optional[pulumi.Input['DataPolicyDataMaskingPolicyArgs']]:
        """
        The data masking policy that specifies the data masking rule to use.
        Structure is documented below.
        """
        return pulumi.get(self, "data_masking_policy")

    @data_masking_policy.setter
    def data_masking_policy(self, value: Optional[pulumi.Input['DataPolicyDataMaskingPolicyArgs']]):
        pulumi.set(self, "data_masking_policy", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _DataPolicyState:
    def __init__(__self__, *,
                 data_masking_policy: Optional[pulumi.Input['DataPolicyDataMaskingPolicyArgs']] = None,
                 data_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 data_policy_type: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 policy_tag: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering DataPolicy resources.
        :param pulumi.Input['DataPolicyDataMaskingPolicyArgs'] data_masking_policy: The data masking policy that specifies the data masking rule to use.
               Structure is documented below.
        :param pulumi.Input[builtins.str] data_policy_id: User-assigned (human readable) ID of the data policy that needs to be unique within a project. Used as {dataPolicyId} in part of the resource name.
        :param pulumi.Input[builtins.str] data_policy_type: The enrollment level of the service.
               Possible values are: `COLUMN_LEVEL_SECURITY_POLICY`, `DATA_MASKING_POLICY`.
        :param pulumi.Input[builtins.str] location: The name of the location of the data policy.
        :param pulumi.Input[builtins.str] name: Resource name of this data policy, in the format of projects/{project_number}/locations/{locationId}/dataPolicies/{dataPolicyId}.
        :param pulumi.Input[builtins.str] policy_tag: Policy tag resource name, in the format of projects/{project_number}/locations/{locationId}/taxonomies/{taxonomyId}/policyTags/{policyTag_id}.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        if data_masking_policy is not None:
            pulumi.set(__self__, "data_masking_policy", data_masking_policy)
        if data_policy_id is not None:
            pulumi.set(__self__, "data_policy_id", data_policy_id)
        if data_policy_type is not None:
            pulumi.set(__self__, "data_policy_type", data_policy_type)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if policy_tag is not None:
            pulumi.set(__self__, "policy_tag", policy_tag)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="dataMaskingPolicy")
    def data_masking_policy(self) -> Optional[pulumi.Input['DataPolicyDataMaskingPolicyArgs']]:
        """
        The data masking policy that specifies the data masking rule to use.
        Structure is documented below.
        """
        return pulumi.get(self, "data_masking_policy")

    @data_masking_policy.setter
    def data_masking_policy(self, value: Optional[pulumi.Input['DataPolicyDataMaskingPolicyArgs']]):
        pulumi.set(self, "data_masking_policy", value)

    @property
    @pulumi.getter(name="dataPolicyId")
    def data_policy_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User-assigned (human readable) ID of the data policy that needs to be unique within a project. Used as {dataPolicyId} in part of the resource name.
        """
        return pulumi.get(self, "data_policy_id")

    @data_policy_id.setter
    def data_policy_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "data_policy_id", value)

    @property
    @pulumi.getter(name="dataPolicyType")
    def data_policy_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The enrollment level of the service.
        Possible values are: `COLUMN_LEVEL_SECURITY_POLICY`, `DATA_MASKING_POLICY`.
        """
        return pulumi.get(self, "data_policy_type")

    @data_policy_type.setter
    def data_policy_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "data_policy_type", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the location of the data policy.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Resource name of this data policy, in the format of projects/{project_number}/locations/{locationId}/dataPolicies/{dataPolicyId}.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="policyTag")
    def policy_tag(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Policy tag resource name, in the format of projects/{project_number}/locations/{locationId}/taxonomies/{taxonomyId}/policyTags/{policyTag_id}.
        """
        return pulumi.get(self, "policy_tag")

    @policy_tag.setter
    def policy_tag(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "policy_tag", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.type_token("gcp:bigquerydatapolicy/dataPolicy:DataPolicy")
class DataPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_masking_policy: Optional[pulumi.Input[Union['DataPolicyDataMaskingPolicyArgs', 'DataPolicyDataMaskingPolicyArgsDict']]] = None,
                 data_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 data_policy_type: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 policy_tag: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        A BigQuery Data Policy

        To get more information about DataPolicy, see:

        * [API documentation](https://cloud.google.com/bigquery/docs/reference/bigquerydatapolicy/rest/v1beta1/projects.locations.dataPolicies/create)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/bigquery/docs/column-data-masking-intro)

        ## Example Usage

        ### Bigquery Datapolicy Data Policy Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        taxonomy = gcp.datacatalog.Taxonomy("taxonomy",
            region="us-central1",
            display_name="taxonomy",
            description="A collection of policy tags",
            activated_policy_types=["FINE_GRAINED_ACCESS_CONTROL"])
        policy_tag = gcp.datacatalog.PolicyTag("policy_tag",
            taxonomy=taxonomy.id,
            display_name="Low security",
            description="A policy tag normally associated with low security items")
        data_policy = gcp.bigquerydatapolicy.DataPolicy("data_policy",
            location="us-central1",
            data_policy_id="data_policy",
            policy_tag=policy_tag.name,
            data_policy_type="COLUMN_LEVEL_SECURITY_POLICY")
        ```
        ### Bigquery Datapolicy Data Policy Routine

        ```python
        import pulumi
        import pulumi_gcp as gcp

        taxonomy = gcp.datacatalog.Taxonomy("taxonomy",
            region="us-central1",
            display_name="taxonomy",
            description="A collection of policy tags",
            activated_policy_types=["FINE_GRAINED_ACCESS_CONTROL"])
        policy_tag = gcp.datacatalog.PolicyTag("policy_tag",
            taxonomy=taxonomy.id,
            display_name="Low security",
            description="A policy tag normally associated with low security items")
        test = gcp.bigquery.Dataset("test",
            dataset_id="dataset_id",
            location="us-central1")
        custom_masking_routine = gcp.bigquery.Routine("custom_masking_routine",
            dataset_id=test.dataset_id,
            routine_id="custom_masking_routine",
            routine_type="SCALAR_FUNCTION",
            language="SQL",
            data_governance_type="DATA_MASKING",
            definition_body="SAFE.REGEXP_REPLACE(ssn, '[0-9]', 'X')",
            return_type="{\\"typeKind\\" :  \\"STRING\\"}",
            arguments=[{
                "name": "ssn",
                "data_type": "{\\"typeKind\\" :  \\"STRING\\"}",
            }])
        data_policy = gcp.bigquerydatapolicy.DataPolicy("data_policy",
            location="us-central1",
            data_policy_id="data_policy",
            policy_tag=policy_tag.name,
            data_policy_type="DATA_MASKING_POLICY",
            data_masking_policy={
                "routine": custom_masking_routine.id,
            })
        ```

        ## Import

        DataPolicy can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/dataPolicies/{{data_policy_id}}`

        * `{{project}}/{{location}}/{{data_policy_id}}`

        * `{{location}}/{{data_policy_id}}`

        When using the `pulumi import` command, DataPolicy can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:bigquerydatapolicy/dataPolicy:DataPolicy default projects/{{project}}/locations/{{location}}/dataPolicies/{{data_policy_id}}
        ```

        ```sh
        $ pulumi import gcp:bigquerydatapolicy/dataPolicy:DataPolicy default {{project}}/{{location}}/{{data_policy_id}}
        ```

        ```sh
        $ pulumi import gcp:bigquerydatapolicy/dataPolicy:DataPolicy default {{location}}/{{data_policy_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['DataPolicyDataMaskingPolicyArgs', 'DataPolicyDataMaskingPolicyArgsDict']] data_masking_policy: The data masking policy that specifies the data masking rule to use.
               Structure is documented below.
        :param pulumi.Input[builtins.str] data_policy_id: User-assigned (human readable) ID of the data policy that needs to be unique within a project. Used as {dataPolicyId} in part of the resource name.
        :param pulumi.Input[builtins.str] data_policy_type: The enrollment level of the service.
               Possible values are: `COLUMN_LEVEL_SECURITY_POLICY`, `DATA_MASKING_POLICY`.
        :param pulumi.Input[builtins.str] location: The name of the location of the data policy.
        :param pulumi.Input[builtins.str] policy_tag: Policy tag resource name, in the format of projects/{project_number}/locations/{locationId}/taxonomies/{taxonomyId}/policyTags/{policyTag_id}.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DataPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A BigQuery Data Policy

        To get more information about DataPolicy, see:

        * [API documentation](https://cloud.google.com/bigquery/docs/reference/bigquerydatapolicy/rest/v1beta1/projects.locations.dataPolicies/create)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/bigquery/docs/column-data-masking-intro)

        ## Example Usage

        ### Bigquery Datapolicy Data Policy Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        taxonomy = gcp.datacatalog.Taxonomy("taxonomy",
            region="us-central1",
            display_name="taxonomy",
            description="A collection of policy tags",
            activated_policy_types=["FINE_GRAINED_ACCESS_CONTROL"])
        policy_tag = gcp.datacatalog.PolicyTag("policy_tag",
            taxonomy=taxonomy.id,
            display_name="Low security",
            description="A policy tag normally associated with low security items")
        data_policy = gcp.bigquerydatapolicy.DataPolicy("data_policy",
            location="us-central1",
            data_policy_id="data_policy",
            policy_tag=policy_tag.name,
            data_policy_type="COLUMN_LEVEL_SECURITY_POLICY")
        ```
        ### Bigquery Datapolicy Data Policy Routine

        ```python
        import pulumi
        import pulumi_gcp as gcp

        taxonomy = gcp.datacatalog.Taxonomy("taxonomy",
            region="us-central1",
            display_name="taxonomy",
            description="A collection of policy tags",
            activated_policy_types=["FINE_GRAINED_ACCESS_CONTROL"])
        policy_tag = gcp.datacatalog.PolicyTag("policy_tag",
            taxonomy=taxonomy.id,
            display_name="Low security",
            description="A policy tag normally associated with low security items")
        test = gcp.bigquery.Dataset("test",
            dataset_id="dataset_id",
            location="us-central1")
        custom_masking_routine = gcp.bigquery.Routine("custom_masking_routine",
            dataset_id=test.dataset_id,
            routine_id="custom_masking_routine",
            routine_type="SCALAR_FUNCTION",
            language="SQL",
            data_governance_type="DATA_MASKING",
            definition_body="SAFE.REGEXP_REPLACE(ssn, '[0-9]', 'X')",
            return_type="{\\"typeKind\\" :  \\"STRING\\"}",
            arguments=[{
                "name": "ssn",
                "data_type": "{\\"typeKind\\" :  \\"STRING\\"}",
            }])
        data_policy = gcp.bigquerydatapolicy.DataPolicy("data_policy",
            location="us-central1",
            data_policy_id="data_policy",
            policy_tag=policy_tag.name,
            data_policy_type="DATA_MASKING_POLICY",
            data_masking_policy={
                "routine": custom_masking_routine.id,
            })
        ```

        ## Import

        DataPolicy can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/dataPolicies/{{data_policy_id}}`

        * `{{project}}/{{location}}/{{data_policy_id}}`

        * `{{location}}/{{data_policy_id}}`

        When using the `pulumi import` command, DataPolicy can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:bigquerydatapolicy/dataPolicy:DataPolicy default projects/{{project}}/locations/{{location}}/dataPolicies/{{data_policy_id}}
        ```

        ```sh
        $ pulumi import gcp:bigquerydatapolicy/dataPolicy:DataPolicy default {{project}}/{{location}}/{{data_policy_id}}
        ```

        ```sh
        $ pulumi import gcp:bigquerydatapolicy/dataPolicy:DataPolicy default {{location}}/{{data_policy_id}}
        ```

        :param str resource_name: The name of the resource.
        :param DataPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DataPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_masking_policy: Optional[pulumi.Input[Union['DataPolicyDataMaskingPolicyArgs', 'DataPolicyDataMaskingPolicyArgsDict']]] = None,
                 data_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 data_policy_type: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 policy_tag: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DataPolicyArgs.__new__(DataPolicyArgs)

            __props__.__dict__["data_masking_policy"] = data_masking_policy
            if data_policy_id is None and not opts.urn:
                raise TypeError("Missing required property 'data_policy_id'")
            __props__.__dict__["data_policy_id"] = data_policy_id
            if data_policy_type is None and not opts.urn:
                raise TypeError("Missing required property 'data_policy_type'")
            __props__.__dict__["data_policy_type"] = data_policy_type
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            if policy_tag is None and not opts.urn:
                raise TypeError("Missing required property 'policy_tag'")
            __props__.__dict__["policy_tag"] = policy_tag
            __props__.__dict__["project"] = project
            __props__.__dict__["name"] = None
        super(DataPolicy, __self__).__init__(
            'gcp:bigquerydatapolicy/dataPolicy:DataPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            data_masking_policy: Optional[pulumi.Input[Union['DataPolicyDataMaskingPolicyArgs', 'DataPolicyDataMaskingPolicyArgsDict']]] = None,
            data_policy_id: Optional[pulumi.Input[builtins.str]] = None,
            data_policy_type: Optional[pulumi.Input[builtins.str]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            policy_tag: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None) -> 'DataPolicy':
        """
        Get an existing DataPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['DataPolicyDataMaskingPolicyArgs', 'DataPolicyDataMaskingPolicyArgsDict']] data_masking_policy: The data masking policy that specifies the data masking rule to use.
               Structure is documented below.
        :param pulumi.Input[builtins.str] data_policy_id: User-assigned (human readable) ID of the data policy that needs to be unique within a project. Used as {dataPolicyId} in part of the resource name.
        :param pulumi.Input[builtins.str] data_policy_type: The enrollment level of the service.
               Possible values are: `COLUMN_LEVEL_SECURITY_POLICY`, `DATA_MASKING_POLICY`.
        :param pulumi.Input[builtins.str] location: The name of the location of the data policy.
        :param pulumi.Input[builtins.str] name: Resource name of this data policy, in the format of projects/{project_number}/locations/{locationId}/dataPolicies/{dataPolicyId}.
        :param pulumi.Input[builtins.str] policy_tag: Policy tag resource name, in the format of projects/{project_number}/locations/{locationId}/taxonomies/{taxonomyId}/policyTags/{policyTag_id}.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DataPolicyState.__new__(_DataPolicyState)

        __props__.__dict__["data_masking_policy"] = data_masking_policy
        __props__.__dict__["data_policy_id"] = data_policy_id
        __props__.__dict__["data_policy_type"] = data_policy_type
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["policy_tag"] = policy_tag
        __props__.__dict__["project"] = project
        return DataPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="dataMaskingPolicy")
    def data_masking_policy(self) -> pulumi.Output[Optional['outputs.DataPolicyDataMaskingPolicy']]:
        """
        The data masking policy that specifies the data masking rule to use.
        Structure is documented below.
        """
        return pulumi.get(self, "data_masking_policy")

    @property
    @pulumi.getter(name="dataPolicyId")
    def data_policy_id(self) -> pulumi.Output[builtins.str]:
        """
        User-assigned (human readable) ID of the data policy that needs to be unique within a project. Used as {dataPolicyId} in part of the resource name.
        """
        return pulumi.get(self, "data_policy_id")

    @property
    @pulumi.getter(name="dataPolicyType")
    def data_policy_type(self) -> pulumi.Output[builtins.str]:
        """
        The enrollment level of the service.
        Possible values are: `COLUMN_LEVEL_SECURITY_POLICY`, `DATA_MASKING_POLICY`.
        """
        return pulumi.get(self, "data_policy_type")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The name of the location of the data policy.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Resource name of this data policy, in the format of projects/{project_number}/locations/{locationId}/dataPolicies/{dataPolicyId}.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="policyTag")
    def policy_tag(self) -> pulumi.Output[builtins.str]:
        """
        Policy tag resource name, in the format of projects/{project_number}/locations/{locationId}/taxonomies/{taxonomyId}/policyTags/{policyTag_id}.
        """
        return pulumi.get(self, "policy_tag")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

